/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class AblaufPlanGUI
extends JInternalFrame {
    public static final long serialVersionUID = 1L;
    private Debug d = new Debug(false);
    private boolean debug = false;
    private AblaufPlan ablauf;
    private boolean aktualisierungMouse = true;
    private JPanel mainPanel = new JPanel();
    private JPanel logoPanel = new JPanel();
    private EmptyBorder border5 = new EmptyBorder(5, 5, 5, 5);
    private GridBagConstraints constraints;
    private GridBagLayout gridbag;
    private JLabel titelLabel = new JLabel("Ablaufplan");
    private JLabel logoLabel = new JLabel("Logo:");
    private JLabel logoTextLabel = new JLabel("keines");
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Abbrechen");
    private JButton aktuellButton = new JButton("Aktuell-Liste hinzuf\u00fcgen");
    private JButton hgbButton = new JButton("Hintergrundbilder-Liste");
    private JButton leerButton = new JButton("Leeren");
    private JButton helpButton = new JButton();
    private JButton printButton = new JButton();
    private JCheckBox benutzen = new JCheckBox("Benutzen");
    private JRadioButton links = new JRadioButton("links");
    private JRadioButton mitte = new JRadioButton("mittig");
    private JRadioButton rechts = new JRadioButton("rechts");
    private ButtonGroup woGroup = new ButtonGroup();
    private JTextArea textfeld = new JTextArea(10, 40);
    private JScrollPane textScrollPane;
    private JScrollPane fensterScrollPane;
    private Daten daten;
    private LoBeT lobet;
    private Einstellungen einstellungen;

    public AblaufPlanGUI(LoBeT loBeT, Daten daten, boolean bl) {
        this.d = new Debug(bl);
        this.debug = bl;
        this.setTitle("Ablaufplan");
        this.daten = daten;
        this.einstellungen = daten.getEinstellungen();
        this.ablauf = this.einstellungen.getAblaufPlan();
        this.lobet = loBeT;
        int n = daten.getEinstellungen().getSeitenFontSize();
        this.setBounds(0, 0, 600, 400);
        this.initGUI();
        this.init();
        this.create();
        this.setResizable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setClosable(true);
        this.setVisible(true);
    }

    public void init() {
        this.einstellungen = this.daten.getEinstellungen();
        this.ablauf = this.einstellungen.getAblaufPlan();
        this.textfeld.setText(this.ablauf.getText());
        int n = this.ablauf.getPosition();
        switch (n) {
            case 0: {
                this.links.setSelected(true);
                break;
            }
            case 1: {
                this.mitte.setSelected(true);
                break;
            }
            case 2: {
                this.rechts.setSelected(true);
            }
        }
        this.benutzen.setSelected(this.ablauf.getLogo());
        this.logoTextLabel.setText(this.ablauf.getLogoText());
        this.setStatus();
    }

    private void setStatus() {
        if (this.aktualisierungMouse) {
            if (this.benutzen.isSelected()) {
                this.links.setEnabled(true);
                this.mitte.setEnabled(true);
                this.rechts.setEnabled(true);
                this.logoTextLabel.setEnabled(true);
            } else {
                this.links.setEnabled(false);
                this.mitte.setEnabled(false);
                this.rechts.setEnabled(false);
                this.logoTextLabel.setEnabled(false);
            }
        } else if (this.ablauf.getLogo() || this.benutzen.isSelected()) {
            this.links.setEnabled(true);
            this.mitte.setEnabled(true);
            this.rechts.setEnabled(true);
            this.logoTextLabel.setEnabled(true);
        } else {
            this.links.setEnabled(false);
            this.mitte.setEnabled(false);
            this.rechts.setEnabled(false);
            this.logoTextLabel.setEnabled(false);
        }
        this.logoTextLabel.setText(this.ablauf.getLogoText());
    }

    public void initGUI() {
        this.okButton.addActionListener(new AblaufPlanActionAdapter(this));
        this.cancelButton.addActionListener(new AblaufPlanActionAdapter(this));
        this.helpButton.addActionListener(new AblaufPlanActionAdapter(this));
        this.printButton.addActionListener(new AblaufPlanActionAdapter(this));
        this.benutzen.addMouseListener(new AblaufPlanMouseAdapter(this));
        this.aktuellButton.addActionListener(new AblaufPlanActionAdapter(this));
        this.hgbButton.addActionListener(new AblaufPlanActionAdapter(this));
        this.leerButton.addActionListener(new AblaufPlanActionAdapter(this));
        this.woGroup.add(this.links);
        this.woGroup.add(this.mitte);
        this.woGroup.add(this.rechts);
        this.setIcons(this.einstellungen.getIcons());
        this.setToolTips(this.einstellungen.getToolTips());
        this.RadioButtonsInit();
    }

    public void create() {
        this.setDefaultCloseOperation(1);
        this.gridbag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.mainPanel.setLayout(this.gridbag);
        this.logoPanel.setLayout(this.gridbag);
        this.textScrollPane = new JScrollPane(this.textfeld);
        this.constr(0, 0, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.logoLabel, this.constraints);
        this.logoPanel.add(this.logoLabel);
        this.constr(0, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.logoTextLabel, this.constraints);
        this.logoPanel.add(this.logoTextLabel);
        this.constr(0, 2, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.links, this.constraints);
        this.logoPanel.add(this.links);
        this.constr(0, 3, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.mitte, this.constraints);
        this.logoPanel.add(this.mitte);
        this.constr(0, 4, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.rechts, this.constraints);
        this.logoPanel.add(this.rechts);
        this.constr(0, 5, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.benutzen, this.constraints);
        this.logoPanel.add(this.benutzen);
        this.constr(0, 0, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.titelLabel, this.constraints);
        this.mainPanel.add(this.titelLabel);
        this.constr(0, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.aktuellButton, this.constraints);
        this.mainPanel.add(this.aktuellButton);
        this.constr(0, 2, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.hgbButton, this.constraints);
        this.mainPanel.add(this.hgbButton);
        this.constr(1, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.leerButton, this.constraints);
        this.mainPanel.add(this.leerButton);
        this.constr(3, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.helpButton, this.constraints);
        this.mainPanel.add(this.helpButton);
        this.constr(3, 2, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.printButton, this.constraints);
        this.mainPanel.add(this.printButton);
        this.constr(0, 3, 3, 1);
        this.constraints.fill = 0;
        this.gridbag.setConstraints(this.textScrollPane, this.constraints);
        this.mainPanel.add(this.textScrollPane);
        this.constr(3, 3, 1, 1);
        this.constraints.fill = 0;
        this.gridbag.setConstraints(this.logoPanel, this.constraints);
        this.mainPanel.add(this.logoPanel);
        this.constr(0, 4, 1, 1);
        this.constraints.fill = 0;
        this.gridbag.setConstraints(this.okButton, this.constraints);
        this.mainPanel.add(this.okButton);
        this.constr(1, 4, 1, 1);
        this.constraints.fill = 0;
        this.gridbag.setConstraints(this.cancelButton, this.constraints);
        this.mainPanel.add(this.cancelButton);
        this.mainPanel.setBorder(new LineBorder(null, 1));
        this.logoPanel.setBorder(new LineBorder(null, 1));
        this.fensterScrollPane = new JScrollPane(this.mainPanel);
        this.getContentPane().add(this.fensterScrollPane);
        this.pack();
    }

    public void mouse(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.benutzen) {
            this.aktualisierungMouse = true;
            this.setStatus();
        }
    }

    public void menuEvent(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.speichern(true);
        } else if (object == this.cancelButton) {
            this.close();
            this.init();
        } else if (object == this.helpButton) {
            this.lobet.hilfe(6);
        } else if (object == this.aktuellButton) {
            this.addAktuell();
        } else if (object == this.hgbButton) {
            this.addHintergrund();
        } else if (object == this.leerButton) {
            this.leeren();
        } else if (object == this.printButton) {
            this.speichern(false);
            this.lobet.openPrinter(6);
        }
    }

    public void taste(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getKeyCode();
        if (n2 != 0) {
            if (n2 == 10) {
                this.d.out("Enter gedr\u00fcckt!");
                this.speichern(true);
            } else if (n2 == 27) {
                this.close();
                this.init();
            }
        }
    }

    private void leeren() {
        this.textfeld.setText("");
    }

    private void addAktuell() {
        String string = this.textfeld.getText();
        String string2 = "";
        String string3 = "";
        int n = this.daten.getSize(3);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                n3 = 0;
                string3 = "";
                bl2 = true;
                for (n2 = 0; bl2 && n2 < 10; ++n2) {
                    if (this.daten.getLabel(n2) != i) continue;
                    string2 = "[" + n2 + "] ";
                    bl2 = false;
                }
                if (this.daten.getLabel(10) == i) {
                    string2 = "[L] ";
                    bl2 = false;
                }
                if (bl2) {
                    string2 = "    ";
                }
                Aktuell aktuell = this.daten.getAkt(i);
                int n5 = aktuell.getTyp();
                switch (n5) {
                    case 0: {
                        string2 = string2 + "[L] ";
                        Lied lied = aktuell.getLied();
                        n3 = lied.getMaxStrophen();
                        lied.setAuswahl();
                        bl = false;
                        bl3 = false;
                        n4 = 0;
                        for (int j = 1; j <= n3; ++j) {
                            Strophe strophe = lied.getStrophe();
                            if (strophe.getAnfang()) {
                                ++n4;
                            }
                            if (strophe.getRefrain()) {
                                bl3 = true;
                            }
                            if (strophe.getBridge()) {
                                bl = true;
                            }
                            lied.getNextStrophe();
                        }
                        if (n4 < 10) {
                            string3 = "0";
                        }
                        string3 = string3 + n4;
                        string3 = bl3 ? string3 + "+" : string3 + "/";
                        if (n3 < 10) {
                            string3 = string3 + "0";
                        }
                        string3 = string3 + n3;
                        if (bl) {
                            string3 = string3 + "B";
                            break;
                        }
                        string3 = string3 + " ";
                        break;
                    }
                    case 1: {
                        string2 = string2 + "[T] ";
                        string3 = "      ";
                        break;
                    }
                    case 2: {
                        string2 = string2 + "[B] ";
                        string3 = "      ";
                    }
                }
                string2 = string2 + string3 + " " + aktuell.getTitel();
                string = string + "\n" + string2;
                string2 = "";
                string3 = "";
            }
        }
        this.textfeld.setText(string);
    }

    private void addHintergrund() {
        String string = this.textfeld.getText() + "\nHintergrundbilder:<f>\n";
        String string2 = "";
        for (int i = 0; i < 10; ++i) {
            if (this.daten.gethgBild(i) == -1) {
                this.d.out("" + i + " = -1");
                continue;
            }
            Bild bild = this.daten.getBild(this.daten.gethgBild(i));
            string = string + "[" + i + "] " + this.daten.gethgBild(i) + " " + bild.getTitel() + "\n";
        }
        this.textfeld.setText(string);
    }

    private void constr(int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
    }

    private void speichern(boolean bl) {
        int n = 0;
        n = this.links.isSelected() ? 0 : (this.mitte.isSelected() ? 1 : 2);
        this.ablauf.setAblaufPlan(this.textfeld.getText(), n, this.benutzen.isSelected());
        if (bl) {
            this.close();
        }
    }

    public void nachLaden() {
        int n = this.daten.getEinstellungen().getSeitenFontSize();
        Font font = new Font("Monospaced", 0, n);
        this.textfeld.setFont(font);
        this.setBounds(0, 0, 600, 400);
        this.aktualisierungMouse = false;
        this.init();
    }

    public void close() {
        this.setVisible(false);
    }

    public void open() {
        this.setVisible(false);
        this.init();
        try {
            this.setIcon(false);
        }
        catch (Exception exception) {
            System.err.println("Fehler beim Deiconifizieren der AblaufPlanGUI");
            JOptionPane.showMessageDialog(this, "Fehler beim deiconifizieren!", "DeIconifizieren", 0);
        }
        this.setLocation(0, 0);
        this.setVisible(true);
    }

    private void setToolTips() {
        if (this.einstellungen.getToolTips()) {
            // empty if block
        }
    }

    private void RadioButtonsInit() {
    }

    private void setToolTips(boolean bl) {
        if (bl) {
            this.helpButton.setToolTipText("Hilfe zum Ablaufplan");
            this.printButton.setToolTipText("Ablaufplan Drucken");
        } else {
            this.helpButton.setToolTipText(null);
            this.printButton.setToolTipText(null);
        }
    }

    private void setIcons(boolean bl) {
        if (bl) {
            this.helpButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/ContextualHelp24.gif")));
            this.printButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Print24.gif")));
        } else {
            this.helpButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/ContextualHelp16.gif")));
            this.printButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Print16.gif")));
        }
    }
}

