/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JFrame;

public class Bild
implements Serializable {
    public static final long serialVersionUID = 1L;
    private String Titel;
    private Kommentar kommentar;
    private BufferedImage bild;
    private BufferedImage kopie;
    private Dimension dim;
    private Dimension kopieDim;
    private BildDaten bildDaten;
    private boolean jpg = false;
    private BildEinstellungen bildE;

    public Bild() {
        this.kommentar = new Kommentar();
        this.Titel = "";
        boolean bl = false;
        this.bildE = new BildEinstellungen();
        this.kopieDim = this.dim = new Dimension(0, 0);
    }

    public Bild(BildDaten bildDaten) {
        this.kommentar = bildDaten.getKommentar();
        this.dim = bildDaten.getDim();
        this.kopieDim = bildDaten.getKopie();
        this.Titel = bildDaten.getTitel();
        this.jpg = bildDaten.getJPG();
        this.bildE = bildDaten.getBildEinstellungen();
    }

    public void setTitel(String string) {
        this.Titel = string;
    }

    public String getTitel() {
        return this.Titel;
    }

    public void setKommentar(Kommentar kommentar) {
        this.kommentar = kommentar;
    }

    public Kommentar getKommentar() {
        return this.kommentar;
    }

    public void setJPG(boolean bl) {
        this.jpg = bl;
    }

    public boolean getJPG() {
        return this.jpg;
    }

    public BufferedImage getBild() {
        return this.kopie;
    }

    public void newSize(int n, int n2) {
        MediaTracker mediaTracker = new MediaTracker(new JFrame());
        if (null != this.bild) {
            this.kopie = this.bild.getSubimage(0, 0, n, n2);
            mediaTracker.addImage(this.kopie, 2);
            try {
                mediaTracker.waitForID(2);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Bild.java:\n Methode newSize(int, int):\n  Fehler beim Kopieren des Bildes!");
            }
            this.kopieDim = new Dimension(this.kopie.getWidth(), this.kopie.getHeight());
        }
    }

    public void setBild(BufferedImage bufferedImage) {
        this.bild = bufferedImage;
        this.dim = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        this.newSize(this.dim.width, this.dim.height);
    }

    public void setSize(Dimension dimension) {
    }

    public Dimension getSize() {
        return this.kopieDim;
    }

    public Dimension getOrgSize() {
        return this.dim;
    }

    public BildDaten getDaten() {
        this.bildDaten = new BildDaten(this.Titel, this.kommentar, this.dim, this.kopieDim, this.jpg, this.bildE);
        return this.bildDaten;
    }

    public void close() {
        this.bild.flush();
        this.kopie.flush();
    }

    protected void finalize() {
        this.bild.flush();
        this.kopie.flush();
        this.Titel = null;
        this.kommentar = null;
        this.bild = null;
        this.kopie = null;
        this.dim = null;
        this.kopieDim = null;
        this.bildDaten = null;
        this.bildE = null;
    }

    public void setBildEinstellungen(BildEinstellungen bildEinstellungen) {
        this.bildE = bildEinstellungen;
    }

    public BildEinstellungen getBildEinstellungen() {
        return this.bildE;
    }

    public void applyBildEinstellungen(BildEinstellungen bildEinstellungen) {
        this.bildE.setBildH(bildEinstellungen.getBildH());
        this.bildE.setOriginal(bildEinstellungen.getOriginal());
        this.bildE.setScreensize(bildEinstellungen.getScreensize());
        this.bildE.setRahmen(bildEinstellungen.getRahmen());
        this.bildE.setGross(bildEinstellungen.getGross());
        this.bildE.setKlein(bildEinstellungen.getKlein());
        this.bildE.setPosition(bildEinstellungen.getPosition());
        this.bildE.setPixelX(bildEinstellungen.getPixelX());
        this.bildE.setPixelY(bildEinstellungen.getPixelY());
    }
}

