/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class SuchenGUI
extends JInternalFrame {
    public static final long serialVersionUID = 1L;
    private Debug d = new Debug(false);
    private boolean debug = false;
    private JPanel mainPanel = new JPanel();
    private JPanel woPanel = new JPanel();
    private JPanel inPanel = new JPanel();
    private JPanel textPanel = new JPanel();
    private EmptyBorder border5 = new EmptyBorder(5, 5, 5, 5);
    private GridBagConstraints constraints;
    private GridBagLayout gridbag;
    private JLabel leer = new JLabel(" ");
    private JLabel inLabel = new JLabel("Suchen in");
    private JButton okButton = new JButton("Suchen");
    private JButton cancelButton = new JButton("Abbrechen");
    private JCheckBox lied = new JCheckBox("Lieder");
    private JCheckBox text = new JCheckBox("Texte");
    private JCheckBox aktuell = new JCheckBox("Aktuell");
    private JCheckBox bild = new JCheckBox("Bilder");
    private JCheckBox schreibung = new JCheckBox("Gross/Kleinschreibung beachten");
    private JRadioButton nurtitel = new JRadioButton("nur Titel");
    private JRadioButton nurtext = new JRadioButton("Titel und Text");
    private JRadioButton alles = new JRadioButton("alles");
    private ButtonGroup woGroup = new ButtonGroup();
    private JTextField textFeld = new JTextField(10);
    private Daten daten;
    private LoBeT lobet;
    private Einstellungen einstellungen;
    private Suchen suchen;

    public SuchenGUI(LoBeT loBeT, Daten daten) {
        this.setTitle("Suchen");
        this.daten = daten;
        this.lobet = loBeT;
        this.einstellungen = daten.getEinstellungen();
        this.initGUI();
        this.init();
        this.create();
        this.textFeld.requestFocus();
        this.setBounds(150, 50, 300, 300);
        this.setResizable(false);
        this.setMaximizable(false);
        this.setIconifiable(true);
        this.setClosable(true);
        this.setVisible(true);
        this.textFeld.requestFocus();
    }

    public SuchenGUI(LoBeT loBeT, Daten daten, boolean bl) {
        this.d = new Debug(bl);
        this.debug = bl;
        this.setTitle("Suchen");
        this.daten = daten;
        this.einstellungen = daten.getEinstellungen();
        this.lobet = loBeT;
        this.setBounds(150, 50, 300, 300);
        this.initGUI();
        this.init();
        this.create();
        this.textFeld.requestFocus();
        this.setResizable(false);
        this.setMaximizable(false);
        this.setIconifiable(true);
        this.setClosable(true);
        this.setVisible(true);
        this.textFeld.requestFocus();
    }

    public void init() {
        this.einstellungen = this.daten.getEinstellungen();
        this.setToolTips();
    }

    public void initGUI() {
        this.okButton.addActionListener(new SuchenActionAdapter(this));
        this.cancelButton.addActionListener(new SuchenActionAdapter(this));
        this.textFeld.addKeyListener(new SuchenTastenAdapter(this));
        this.RadioButtonsInit();
    }

    public void create() {
        this.setDefaultCloseOperation(1);
        this.gridbag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.mainPanel.setLayout(this.gridbag);
        this.inPanel.setLayout(this.gridbag);
        this.woPanel.setLayout(this.gridbag);
        this.textPanel.setLayout(this.gridbag);
        this.constr(0, 0, 2, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.inLabel, this.constraints);
        this.inPanel.add(this.inLabel);
        this.constr(0, 0, 2, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.textFeld, this.constraints);
        this.textPanel.add(this.textFeld);
        this.textFeld.requestFocus();
        this.constr(0, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.lied, this.constraints);
        this.inPanel.add(this.lied);
        this.constr(1, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.text, this.constraints);
        this.inPanel.add(this.text);
        this.constr(2, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.bild, this.constraints);
        this.inPanel.add(this.bild);
        this.constr(0, 0, 2, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.nurtitel, this.constraints);
        this.woPanel.add(this.nurtitel);
        this.constr(0, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.nurtext, this.constraints);
        this.woPanel.add(this.nurtext);
        this.constr(0, 2, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.alles, this.constraints);
        this.woPanel.add(this.alles);
        this.constr(0, 1, 1, 1);
        this.constraints.fill = 0;
        this.gridbag.setConstraints(this.okButton, this.constraints);
        this.textPanel.add(this.okButton);
        this.constr(1, 1, 1, 1);
        this.constraints.fill = 0;
        this.gridbag.setConstraints(this.cancelButton, this.constraints);
        this.textPanel.add(this.cancelButton);
        this.inPanel.setBorder(new LineBorder(null, 1));
        this.woPanel.setBorder(new LineBorder(null, 1));
        this.textPanel.setBorder(new LineBorder(null, 1));
        this.constr(0, 0, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.inPanel, this.constraints);
        this.mainPanel.add(this.inPanel);
        this.constr(0, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.woPanel, this.constraints);
        this.mainPanel.add(this.woPanel);
        this.constr(0, 2, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.textPanel, this.constraints);
        this.mainPanel.add(this.textPanel);
        this.woGroup.add(this.nurtitel);
        this.woGroup.add(this.nurtext);
        this.woGroup.add(this.alles);
        this.getContentPane().add(this.mainPanel);
        this.pack();
    }

    public void menuEvent(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.speichern(true);
        } else if (object == this.cancelButton) {
            this.close();
        }
    }

    public void taste(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getKeyCode();
        if (n2 != 0) {
            if (n2 == 10) {
                this.d.out("Enter gedr\u00fcckt!");
                this.speichern(true);
            } else if (n2 == 27) {
                this.close();
            }
        }
    }

    private void constr(int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
    }

    private void speichern(boolean bl) {
        String string = this.textFeld.getText();
        if (Pattern.matches("[a-z|A-Z| ]*", string)) {
            string = ".*" + string + ".*";
        }
        this.d.out("Suchtext: " + string);
        this.suchen = new Suchen(this.nurtitel.isSelected(), this.nurtext.isSelected(), this.alles.isSelected(), this.lied.isSelected(), this.text.isSelected(), this.bild.isSelected(), string);
        this.close();
        ProgressBarNeuThread progressBarNeuThread = new ProgressBarNeuThread(this.lobet, this.daten, this.suchen);
        progressBarNeuThread.run();
    }

    public void close() {
        this.setVisible(false);
    }

    public void open() {
        this.setVisible(false);
        this.init();
        try {
            this.setIcon(false);
        }
        catch (Exception exception) {
            System.err.println("Fehler beim Deiconifizieren der EinstellungenGUI");
            JOptionPane.showMessageDialog(this, "Fehler beim deiconifizieren!", "DeIconifizieren", 0);
        }
        this.setLocation(150, 50);
        this.setVisible(true);
    }

    private void setToolTips() {
        if (this.einstellungen.getToolTips()) {
            // empty if block
        }
    }

    private void RadioButtonsInit() {
        this.lied.setEnabled(true);
        this.text.setEnabled(true);
        this.aktuell.setEnabled(true);
        this.bild.setEnabled(true);
        this.nurtext.setEnabled(true);
        this.nurtitel.setEnabled(true);
        this.alles.setEnabled(true);
        this.schreibung.setEnabled(false);
        this.schreibung.setSelected(true);
        this.lied.setSelected(true);
        this.nurtext.setSelected(true);
    }
}

