/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDaten
extends DefaultHandler {
    static int READING_TITEL = 1;
    static int READING_ORIGINAL = 2;
    static int READING_ANFANG = 3;
    static int READING_REFRAIN = 4;
    static int READING_BRIDGE = 5;
    static int READING_TRANSLATE = 6;
    static int READING_ZEILE = 7;
    static int READING_VORNAME = 8;
    static int READING_NAME = 9;
    static int READING_AUTOR = 10;
    static int READING_MELODIE = 11;
    static int READING_UEBERSETZER = 12;
    static int READING_COPYRIGHT = 13;
    static int READING_VERLAG = 14;
    static int READING_KOMMENTAR = 15;
    static int READING_VERSION = 16;
    static int READING_WANN = 17;
    static int READING_WIE_OFT = 18;
    static int READING_NOTHING = 0;
    int currentActivity = READING_NOTHING;
    private String titel = "";
    private String original = "";
    private boolean anfang = false;
    private boolean refrain = false;
    private boolean bridge = false;
    private boolean translate = false;
    private String zeile = "";
    private Autor liedmacher;
    private Autor texter;
    private Autor translater;
    private int copyrightZahl;
    private int versionZahl;
    private String vorname = "";
    private String name = "";
    private String copyright = "";
    private String verlag = "";
    private String kommentar = "";
    private String version = "";
    private String wann = "";
    private String wieOft = "";
    private int wieOftZahl = 0;
    private long wannZahl = 0L;
    private XMLLied[] lieder;
    private Text[] texte;
    private int woLied = 0;
    private int woText = 0;
    private int woZeile = 0;
    private int woXLied = 0;
    private int woXText = 0;
    private Debug d;
    private boolean debug = false;
    public static final int maxZeile = 24;
    private String[] zeilen = new String[24];
    ProgressBarNeu pbn;
    int liedAnzahl;
    int textAnzahl;

    public XMLDaten(int n, int n2, ProgressBarNeu progressBarNeu, File file, boolean bl) {
        this.debug = bl;
        this.d = new Debug(bl);
        this.pbn = progressBarNeu;
        this.liedAnzahl = n;
        this.textAnzahl = n2;
        this.lieder = new XMLLied[n];
        this.texte = new Text[n2];
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(file, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Could not create that parser.");
            System.out.println(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            System.out.println("Problem with the SAX parser.");
            System.out.println(sAXException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Error reading file.");
            System.out.println(iOException.getMessage());
        }
        progressBarNeu.ende();
        if (bl) {
            this.ausgabe();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("Lied")) {
            this.currentActivity = READING_NOTHING;
            this.pbn.progress();
            for (int i = 0; i < 24; ++i) {
                this.zeilen[i] = "";
            }
            this.titel = "";
            this.original = "";
            this.anfang = false;
            this.refrain = false;
            this.bridge = false;
            this.translate = false;
            this.zeile = "";
            this.vorname = "";
            this.name = "";
            this.copyright = "";
            this.verlag = "";
            this.kommentar = "";
            this.version = "";
            this.woZeile = 0;
            this.wann = "";
            this.wieOft = "";
            this.wieOftZahl = 0;
            this.wannZahl = 0L;
            this.liedmacher = new Autor();
            this.texter = new Autor();
            this.translater = new Autor();
            this.copyrightZahl = 0;
            this.versionZahl = 0;
            this.lieder[this.woLied] = new XMLLied();
        } else if (string3.equals("Text")) {
            this.currentActivity = READING_NOTHING;
            this.pbn.progress();
            for (int i = 0; i < 24; ++i) {
                this.zeilen[i] = "";
            }
            this.titel = "";
            this.zeile = "";
            this.vorname = "";
            this.name = "";
            this.copyright = "";
            this.verlag = "";
            this.kommentar = "";
            this.version = "";
            this.woZeile = 0;
            this.liedmacher = new Autor();
            this.texter = new Autor();
            this.translater = new Autor();
            this.copyrightZahl = 0;
            this.versionZahl = 0;
            this.texte[this.woText] = new Text();
        } else if (string3.equals("Titel")) {
            this.currentActivity = READING_TITEL;
        } else if (string3.equals("Original")) {
            this.currentActivity = READING_ORIGINAL;
        } else if (string3.equals("Lieder")) {
            this.currentActivity = READING_NOTHING;
            this.pbn.progress("Lese Lieder...");
        } else if (string3.equals("Texte")) {
            this.currentActivity = READING_NOTHING;
            this.pbn.progress("Lese Texte...");
        } else if (string3.equals("Version")) {
            this.currentActivity = READING_VERSION;
        } else if (string3.equals("Vorname")) {
            this.currentActivity = READING_VORNAME;
        } else if (string3.equals("Name")) {
            this.currentActivity = READING_NAME;
        } else if (string3.equals("Verlag")) {
            this.currentActivity = READING_VERLAG;
        } else if (string3.equals("Kommentar")) {
            this.currentActivity = READING_KOMMENTAR;
        } else if (string3.equals("Zeile")) {
            this.currentActivity = READING_ZEILE;
        } else if (string3.equals("Anfang")) {
            this.anfang = true;
        } else if (string3.equals("Refrain")) {
            this.refrain = true;
        } else if (string3.equals("Bridge")) {
            this.bridge = true;
        } else {
            this.currentActivity = string3.equals("Statistik") ? READING_WIE_OFT : (string3.equals("WannStatistik") ? READING_WANN : (string3.equals("Copyright") ? READING_COPYRIGHT : READING_NOTHING));
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        if (this.currentActivity == READING_TITEL) {
            this.titel = this.titel + string;
        } else if (this.currentActivity == READING_ORIGINAL) {
            this.original = this.original + string;
        } else if (this.currentActivity == READING_ZEILE) {
            this.zeilen[this.woZeile] = this.zeilen[this.woZeile] + string;
        } else if (this.currentActivity == READING_VORNAME) {
            this.vorname = this.vorname + string;
        } else if (this.currentActivity == READING_NAME) {
            this.name = this.name + string;
        } else if (this.currentActivity == READING_COPYRIGHT) {
            this.copyright = this.copyright + string;
        } else if (this.currentActivity == READING_VERSION) {
            this.version = this.version + string;
        } else if (this.currentActivity == READING_KOMMENTAR) {
            this.kommentar = this.kommentar + string;
        } else if (this.currentActivity == READING_VERLAG) {
            this.verlag = this.verlag + string;
        } else if (this.currentActivity == READING_WANN) {
            this.wann = this.wann + string;
        } else if (this.currentActivity == READING_WIE_OFT) {
            this.wieOft = this.wieOft + string;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        int n = 0;
        if (string3.equals("Lied")) {
            this.lieder[this.woLied].setTitel(this.titel);
            this.lieder[this.woLied].setOriginal(this.original);
            this.lieder[this.woLied].setKommentar(new Kommentar(this.liedmacher, this.texter, this.translater, this.copyrightZahl, this.kommentar, this.verlag, this.versionZahl));
            this.lieder[this.woLied].removeStrophe(0);
            this.lieder[this.woLied].setStatistiken(this.wieOftZahl, this.wannZahl);
            ++this.woLied;
        } else if (string3.equals("Zeile")) {
            if (this.woZeile < 23) {
                ++this.woZeile;
            }
        } else if (string3.equals("Liedseite")) {
            Strophe strophe = new Strophe();
            for (n = 0; n < 24; ++n) {
                strophe.set(this.zeilen[n], n);
                this.zeilen[n] = "";
            }
            strophe.setAnfang(this.anfang);
            strophe.setBridge(this.bridge);
            strophe.setRefrain(this.refrain);
            this.lieder[this.woLied].addStrophe(strophe);
            this.anfang = false;
            this.bridge = false;
            this.refrain = false;
            this.woZeile = 0;
        } else if (string3.equals("Textseite")) {
            Strophe strophe = new Strophe();
            for (n = 0; n < 24; ++n) {
                strophe.set(this.zeilen[n], n);
                this.zeilen[n] = "";
            }
            this.texte[this.woText].addText(strophe);
            this.anfang = false;
            this.bridge = false;
            this.refrain = false;
            this.woZeile = 0;
        } else if (string3.equals("Text")) {
            this.d.out("Text: " + this.woText + " " + this.titel);
            this.texte[this.woText].setTitel(this.titel);
            this.texte[this.woText].setKommentar(new Kommentar(this.liedmacher, this.texter, this.translater, this.copyrightZahl, this.kommentar, this.verlag, this.versionZahl));
            this.texte[this.woText].removeText(0);
            ++this.woText;
        } else if (string3.equals("Textautor")) {
            this.texter = new Autor(this.vorname, this.name);
            this.vorname = "";
            this.name = "";
        } else if (string3.equals("Melodie")) {
            this.liedmacher = new Autor(this.vorname, this.name);
            this.vorname = "";
            this.name = "";
        } else if (string3.equals("Uebersetzer")) {
            this.translater = new Autor(this.vorname, this.name);
            this.vorname = "";
            this.name = "";
        } else if (string3.equals("Copyright")) {
            if (this.copyright.equals("")) {
                this.copyrightZahl = 0;
            } else {
                try {
                    this.copyrightZahl = Integer.parseInt(this.copyright);
                }
                catch (NumberFormatException numberFormatException) {
                    this.copyrightZahl = 0;
                    this.d.out("Warnung: Keine Zahl im Copyright");
                }
            }
        } else if (string3.equals("Version")) {
            if (this.version.equals("")) {
                this.version = "0";
            }
            try {
                this.versionZahl = Integer.parseInt(this.version);
            }
            catch (NumberFormatException numberFormatException) {
                this.versionZahl = 0;
                this.d.out("Exception Version");
            }
        } else if (string3.equals("WannStatistik")) {
            if (this.wann.equals("")) {
                this.wann = "0";
            }
            try {
                this.wannZahl = Long.parseLong(this.wann);
            }
            catch (NumberFormatException numberFormatException) {
                this.wannZahl = 0L;
                this.d.out("Exception WannStatistik");
            }
        } else if (string3.equals("Statistik")) {
            if (this.wieOft.equals("")) {
                this.wieOft = "0";
            }
            try {
                this.wieOftZahl = Integer.parseInt(this.wieOft);
            }
            catch (NumberFormatException numberFormatException) {
                this.wieOftZahl = 0;
                this.d.out("Exception wieOft");
            }
        }
    }

    public void ausgabe() {
        int n;
        for (n = 0; n < this.liedAnzahl; ++n) {
            System.out.println("Lied: " + this.lieder[n].getTitel());
        }
        for (n = 0; n < this.textAnzahl; ++n) {
            System.out.println("Text: " + this.texte[n].getTitel());
        }
    }

    public void startLied() {
        this.woXLied = 0;
    }

    public void startText() {
        this.woXText = 0;
    }

    public XMLLied nextLied() {
        XMLLied xMLLied = null;
        if (this.woXLied < this.liedAnzahl) {
            xMLLied = this.lieder[this.woXLied];
            ++this.woXLied;
        }
        return xMLLied;
    }

    public Text nextText() {
        Text text = null;
        if (this.woXText < this.textAnzahl) {
            text = this.texte[this.woXText];
            ++this.woXText;
        }
        return text;
    }
}

