/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class XMLExport {
    private Debug d = new Debug(false);
    private boolean debug = false;
    private Daten daten;
    private ProgressBarNeu pbn;
    private File file;
    private String titel = "Liederliste";
    private final String VERSION = Start.showVersion();
    private final String xmlVersion = "1.0";
    private final String[] buchstaben = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "z", "zz"};
    private String path;
    private String name;
    private Lied lied;
    private Text text;
    private Vector liedVector;
    private Vector textVector;
    private Vector aktVector;
    public static final int LIED = 0;
    private static final int maxSchirm = 5;
    private static final int maxZeile = 24;
    private int liedNr = 0;
    private FileOutputStream fos;
    private ObjectOutputStream oos;
    private FileInputStream fis;
    private ObjectInputStream ois;
    private BufferedWriter bw;
    String dateiInhalt = "";

    public XMLExport(Daten daten, ProgressBarNeu progressBarNeu, File file, boolean bl) throws IOException {
        this.d = new Debug(bl);
        this.daten = daten;
        this.pbn = progressBarNeu;
        this.file = file;
        this.debug = bl;
        this.schreiben();
    }

    private void schreiben() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        Strophe strophe;
        int n5;
        int n6 = 0;
        this.liedVector = this.daten.getVector(0);
        this.textVector = this.daten.getVector(1);
        this.aktVector = this.daten.getVector(3);
        this.pbn.setMax(this.liedVector.size() + this.textVector.size() + 1);
        this.pbn.progress(0, "XML-Daten generieren");
        this.pbn.setIndeterminate(false);
        this.d.out("Datei (" + this.file.getName() + ") \u00f6ffnen");
        this.fos = new FileOutputStream(this.file);
        this.bw = new BufferedWriter(new OutputStreamWriter((OutputStream)this.fos, "UTF-8"));
        this.d.out("XML schreiben");
        this.vorspann();
        this.bw.newLine();
        this.bw.write("<LiederUndTexteDokument version=\"1.0\">");
        this.bw.newLine();
        if (this.daten.getEinstellungen().getXMLlied() && this.liedVector.size() > 0) {
            this.bw.write("  <Lieder>");
            this.bw.newLine();
            for (n5 = 0; n5 < this.liedVector.size(); ++n5) {
                this.pbn.progress();
                this.lied = this.daten.getLied(n5);
                if (null == this.lied) continue;
                this.bw.write("    <Lied>");
                this.bw.newLine();
                this.bw.write("      <Titel>");
                this.bw.write(this.entity(this.lied.getTitel()));
                this.bw.write("</Titel>");
                this.bw.newLine();
                if (this.lied.getKopie()) {
                    this.bw.write("      <Original>");
                    this.bw.write(this.entity(this.lied.getOriginal()));
                    this.bw.write("</Original>");
                    this.bw.newLine();
                }
                this.bw.write("      <Statistik>");
                this.bw.write("" + this.lied.getStatistiken());
                this.bw.write("</Statistik>");
                this.bw.newLine();
                this.bw.write("      <WannStatistik>");
                this.bw.write("" + this.lied.getTimeStatistiken());
                this.bw.write("</WannStatistik>");
                this.bw.newLine();
                this.lied.setAuswahl();
                strophe = this.lied.getStrophe();
                for (n4 = 0; n4 < this.lied.getMaxStrophen(); ++n4) {
                    this.bw.write("      <Liedseite>");
                    this.bw.newLine();
                    if (strophe.getAnfang()) {
                        this.bw.write("        <Anfang>YES</Anfang>");
                        this.bw.newLine();
                    }
                    if (strophe.getRefrain()) {
                        this.bw.write("        <Refrain>YES</Refrain>");
                        this.bw.newLine();
                    }
                    if (strophe.getBridge()) {
                        this.bw.write("        <Bridge>YES</Bridge>");
                        this.bw.newLine();
                    }
                    n6 = 0;
                    for (n3 = 0; n3 < 24; ++n3) {
                        if (strophe.get(n3).length() <= 1) continue;
                        n6 = n3;
                    }
                    for (n3 = 0; n3 <= n6; ++n3) {
                        this.bw.write("        <Zeile>");
                        this.bw.write(this.entity(strophe.get(n3)));
                        this.bw.write("</Zeile>");
                        this.bw.newLine();
                    }
                    this.bw.write("      </Liedseite>");
                    this.bw.newLine();
                    strophe = this.lied.getNextStrophe();
                }
                this.kommentare(this.lied.getKommentar());
                this.bw.write("    </Lied>");
                this.bw.newLine();
            }
            this.bw.write("  </Lieder>");
            this.bw.newLine();
        }
        if (this.daten.getEinstellungen().getXMLtext() && this.textVector.size() > 0) {
            this.bw.write("  <Texte>");
            this.bw.newLine();
            for (n5 = 0; n5 < this.textVector.size(); ++n5) {
                this.pbn.progress();
                this.text = this.daten.getText(n5);
                if (null == this.text) continue;
                this.bw.write("    <Text>");
                this.bw.newLine();
                this.bw.write("      <Titel>");
                this.bw.write(this.entity(this.text.getTitel()));
                this.bw.write("</Titel>");
                this.bw.newLine();
                this.text.setAuswahl();
                strophe = this.text.getText();
                for (n4 = 0; n4 < this.text.getMaxText(); ++n4) {
                    this.bw.write("      <Textseite>");
                    this.bw.newLine();
                    n6 = 0;
                    for (n3 = 0; n3 < 24; ++n3) {
                        if (strophe.get(n3).length() <= 1) continue;
                        n6 = n3;
                    }
                    for (n3 = 0; n3 <= n6; ++n3) {
                        this.bw.write("        <Zeile>");
                        this.bw.write(this.entity(strophe.get(n3)));
                        this.bw.write("</Zeile>");
                        this.bw.newLine();
                    }
                    this.bw.write("      </Textseite>");
                    this.bw.newLine();
                    strophe = this.text.getNextText();
                }
                this.kommentare(this.text.getKommentar());
                this.bw.write("    </Text>");
                this.bw.newLine();
            }
            this.bw.write("  </Texte>");
            this.bw.newLine();
        }
        if (this.daten.getEinstellungen().getXMLakt() && !this.daten.getEinstellungen().getXMLlied() && !this.daten.getEinstellungen().getXMLtext() && this.liedVector.size() > 0 && this.aktVector.size() > 0) {
            n5 = 0;
            n4 = 0;
            n2 = 0;
            for (n3 = 0; n5 == 0 && n3 < this.aktVector.size(); ++n3) {
                if (this.daten.getAkt(n3).getTyp() != 0) continue;
                n5 = 1;
            }
            if (n5 != 0) {
                this.bw.write("  <Lieder>");
                this.bw.newLine();
                for (n3 = 0; n3 < this.liedVector.size(); ++n3) {
                    this.pbn.progress();
                    this.lied = this.daten.getLied(n3);
                    n4 = 0;
                    for (n2 = 0; n4 == 0 && n2 < this.aktVector.size(); ++n2) {
                        if (this.lied != this.daten.getAkt(n2).getLied()) continue;
                        n4 = 1;
                    }
                    if (n4 == 0 || null == this.lied) continue;
                    this.bw.write("    <Lied>");
                    this.bw.newLine();
                    this.bw.write("      <Titel>");
                    this.bw.write(this.entity(this.lied.getTitel()));
                    this.bw.write("</Titel>");
                    this.bw.newLine();
                    if (this.lied.getKopie()) {
                        this.bw.write("      <Original>");
                        this.bw.write(this.entity(this.lied.getOriginal()));
                        this.bw.write("</Original>");
                        this.bw.newLine();
                    }
                    this.bw.write("      <Statistik>");
                    this.bw.write("" + this.lied.getStatistiken());
                    this.bw.write("</Statistik>");
                    this.bw.newLine();
                    this.bw.write("      <WannStatistik>");
                    this.bw.write("" + this.lied.getTimeStatistiken());
                    this.bw.write("</WannStatistik>");
                    this.bw.newLine();
                    this.lied.setAuswahl();
                    strophe = this.lied.getStrophe();
                    for (n2 = 0; n2 < this.lied.getMaxStrophen(); ++n2) {
                        this.bw.write("      <Liedseite>");
                        this.bw.newLine();
                        if (strophe.getAnfang()) {
                            this.bw.write("        <Anfang>YES</Anfang>");
                            this.bw.newLine();
                        }
                        if (strophe.getRefrain()) {
                            this.bw.write("        <Refrain>YES</Refrain>");
                            this.bw.newLine();
                        }
                        if (strophe.getBridge()) {
                            this.bw.write("        <Bridge>YES</Bridge>");
                            this.bw.newLine();
                        }
                        n6 = 0;
                        for (n = 0; n < 24; ++n) {
                            if (strophe.get(n).length() <= 1) continue;
                            n6 = n;
                        }
                        for (n = 0; n <= n6; ++n) {
                            this.bw.write("        <Zeile>");
                            this.bw.write(this.entity(strophe.get(n)));
                            this.bw.write("</Zeile>");
                            this.bw.newLine();
                        }
                        this.bw.write("      </Liedseite>");
                        this.bw.newLine();
                        strophe = this.lied.getNextStrophe();
                    }
                    this.kommentare(this.lied.getKommentar());
                    this.bw.write("    </Lied>");
                    this.bw.newLine();
                }
                this.bw.write("  </Lieder>");
                this.bw.newLine();
            }
        }
        if (this.daten.getEinstellungen().getXMLakt() && !this.daten.getEinstellungen().getXMLlied() && !this.daten.getEinstellungen().getXMLtext() && this.textVector.size() > 0 && this.aktVector.size() > 0) {
            n5 = 0;
            n4 = 0;
            n2 = 0;
            for (n3 = 0; n5 == 0 && n3 < this.aktVector.size(); ++n3) {
                if (this.daten.getAkt(n3).getTyp() != 1) continue;
                n5 = 1;
            }
            if (n5 != 0) {
                this.bw.write("  <Texte>");
                this.bw.newLine();
                for (n3 = 0; n3 < this.textVector.size(); ++n3) {
                    this.pbn.progress();
                    this.text = this.daten.getText(n3);
                    n4 = 0;
                    for (n2 = 0; n4 == 0 && n2 < this.aktVector.size(); ++n2) {
                        if (this.text != this.daten.getAkt(n2).getText()) continue;
                        n4 = 1;
                    }
                    if (n4 == 0 || null == this.text) continue;
                    this.bw.write("    <Text>");
                    this.bw.newLine();
                    this.bw.write("      <Titel>");
                    this.bw.write(this.entity(this.text.getTitel()));
                    this.bw.write("</Titel>");
                    this.bw.newLine();
                    this.text.setAuswahl();
                    strophe = this.text.getText();
                    for (n2 = 0; n2 < this.text.getMaxText(); ++n2) {
                        this.bw.write("      <Textseite>");
                        this.bw.newLine();
                        n6 = 0;
                        for (n = 0; n < 24; ++n) {
                            if (strophe.get(n).length() <= 1) continue;
                            n6 = n;
                        }
                        for (n = 0; n <= n6; ++n) {
                            this.bw.write("        <Zeile>");
                            this.bw.write(this.entity(strophe.get(n)));
                            this.bw.write("</Zeile>");
                            this.bw.newLine();
                        }
                        this.bw.write("      </Textseite>");
                        this.bw.newLine();
                        strophe = this.text.getNextText();
                    }
                    this.kommentare(this.text.getKommentar());
                    this.bw.write("    </Text>");
                    this.bw.newLine();
                }
                this.bw.write("  </Texte>");
                this.bw.newLine();
            }
        }
        this.bw.write("</LiederUndTexteDokument>");
        this.bw.newLine();
        this.bw.flush();
        this.fos.flush();
        this.fos.close();
    }

    private void vorspann() throws IOException {
        this.bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        this.bw.newLine();
        this.bw.write("<!-- Geschrieben von LoBeT " + this.VERSION + " -->");
        this.bw.newLine();
        this.bw.write("<!DOCTYPE LiederUndTexteDokument [");
        this.bw.newLine();
        this.bw.write("  <!ELEMENT LiederUndTexteDokument (Lieder?, Texte?)>");
        this.bw.newLine();
        this.bw.write("    <!ATTLIST LiederUndTexteDokument version CDATA \"\">");
        this.bw.newLine();
        this.bw.write("    <!ELEMENT Lieder (Lied*)>");
        this.bw.newLine();
        this.bw.write("      <!ELEMENT Lied (Titel, Original?, Statistik, WannStatistik, Liedseite+, Kommentare)>");
        this.bw.newLine();
        this.bw.write("        <!ELEMENT Titel (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("        <!ELEMENT Original (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("        <!ELEMENT Statistik (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("        <!ELEMENT WannStatistik (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("        <!ELEMENT Liedseite (Anfang?, Refrain?, Bridge?, Translate?, Zeile+)>");
        this.bw.newLine();
        this.bw.write("          <!ELEMENT Anfang (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("          <!ELEMENT Refrain (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("          <!ELEMENT Bridge (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("          <!ELEMENT Translate (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("          <!ELEMENT Zeile (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("        <!ELEMENT Kommentare (Textautor, Melodie, Uebersetzer, Copyright, Verlag, Kommentar, Version)>");
        this.bw.newLine();
        this.bw.write("          <!ELEMENT Textautor (Vorname, Name)>");
        this.bw.newLine();
        this.bw.write("            <!ELEMENT Vorname (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("            <!ELEMENT Name (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("          <!ELEMENT Melodie (Vorname, Name)>");
        this.bw.newLine();
        this.bw.write("          <!ELEMENT Uebersetzer (Vorname, Name)>");
        this.bw.newLine();
        this.bw.write("          <!ELEMENT Copyright (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("          <!ELEMENT Verlag (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("          <!ELEMENT Kommentar (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("          <!ELEMENT Version (#PCDATA)>");
        this.bw.newLine();
        this.bw.write("    <!ELEMENT Texte (Text*)>");
        this.bw.newLine();
        this.bw.write("      <!ELEMENT Text (Titel, Textseite+, Kommentare)>");
        this.bw.newLine();
        this.bw.write("        <!ELEMENT Textseite (Zeile+)>");
        this.bw.newLine();
        this.bw.write("]>");
        this.bw.newLine();
    }

    private void pfadFinden() {
        int n = this.path.lastIndexOf(File.separator);
        if (-1 != n) {
            this.path = this.path.substring(0, n) + File.separator;
        }
        this.d.out("Pfad: " + this.path);
    }

    private void kommentare(Kommentar kommentar) throws IOException {
        this.bw.write("      <Kommentare>");
        this.bw.newLine();
        this.bw.write("        <Textautor>");
        this.bw.newLine();
        this.bw.write("          <Vorname>");
        this.bw.write(this.entity(kommentar.getTexter().getVorname()));
        this.bw.write("</Vorname>");
        this.bw.newLine();
        this.bw.write("          <Name>");
        this.bw.write(this.entity(kommentar.getTexter().getName()));
        this.bw.write("</Name>");
        this.bw.newLine();
        this.bw.write("        </Textautor>");
        this.bw.newLine();
        this.bw.write("        <Melodie>");
        this.bw.newLine();
        this.bw.write("          <Vorname>");
        this.bw.write(this.entity(kommentar.getLiedmacher().getVorname()));
        this.bw.write("</Vorname>");
        this.bw.newLine();
        this.bw.write("          <Name>");
        this.bw.write(this.entity(kommentar.getLiedmacher().getName()));
        this.bw.write("</Name>");
        this.bw.newLine();
        this.bw.write("        </Melodie>");
        this.bw.newLine();
        this.bw.write("        <Uebersetzer>");
        this.bw.newLine();
        this.bw.write("          <Vorname>");
        this.bw.write(this.entity(kommentar.getTranslater().getVorname()));
        this.bw.write("</Vorname>");
        this.bw.newLine();
        this.bw.write("          <Name>");
        this.bw.write(this.entity(kommentar.getTranslater().getName()));
        this.bw.write("</Name>");
        this.bw.newLine();
        this.bw.write("        </Uebersetzer>");
        this.bw.newLine();
        this.bw.write("        <Copyright>");
        this.bw.write("" + kommentar.getJahr());
        this.bw.write("</Copyright>");
        this.bw.newLine();
        this.bw.write("        <Verlag>");
        this.bw.write(this.entity(kommentar.getVerlag()));
        this.bw.write("</Verlag>");
        this.bw.newLine();
        this.bw.write("        <Kommentar>");
        this.bw.write(this.entity(kommentar.getSonstiges()));
        this.bw.write("</Kommentar>");
        this.bw.newLine();
        this.bw.write("        <Version>");
        this.bw.write("" + kommentar.getVersion());
        this.bw.write("</Version>");
        this.bw.newLine();
        this.bw.write("      </Kommentare>");
        this.bw.newLine();
    }

    private String entity(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            string2 = c == '<' ? string2 + "&lt;" : (c == '>' ? string2 + "&gt;" : (c == '&' ? string2 + "&amp;" : (c == '\'' ? string2 + "&apos;" : (c == '\"' ? string2 + "&quot;" : string2 + c))));
        }
        return string2;
    }
}

