/*     */ import java.awt.Container;
/*     */ import java.awt.Font;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.awt.event.KeyEvent;
/*     */ import java.awt.event.MouseEvent;
/*     */ import java.io.PrintStream;
/*     */ import javax.swing.ButtonGroup;
/*     */ import javax.swing.ImageIcon;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JCheckBox;
/*     */ import javax.swing.JInternalFrame;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JOptionPane;
/*     */ import javax.swing.JPanel;
/*     */ import javax.swing.JRadioButton;
/*     */ import javax.swing.JScrollPane;
/*     */ import javax.swing.JTextArea;
/*     */ import javax.swing.border.EmptyBorder;
/*     */ import javax.swing.border.LineBorder;
/*     */ 
/*     */ public class AblaufPlanGUI extends JInternalFrame
/*     */ {
/*     */   public static final long serialVersionUID = 1L;
/*   9 */   private Debug d = new Debug(false);
/*  10 */   private boolean debug = false;
/*     */   private AblaufPlan ablauf;
/*  12 */   private boolean aktualisierungMouse = true;
/*     */ 
/*  15 */   private JPanel mainPanel = new JPanel();
/*  16 */   private JPanel logoPanel = new JPanel();
/*     */ 
/*  18 */   private EmptyBorder border5 = new EmptyBorder(5, 5, 5, 5);
/*     */   private GridBagConstraints constraints;
/*     */   private GridBagLayout gridbag;
/*  25 */   private JLabel titelLabel = new JLabel("Ablaufplan");
/*  26 */   private JLabel logoLabel = new JLabel("Logo:");
/*  27 */   private JLabel logoTextLabel = new JLabel("keines");
/*     */ 
/*  31 */   private JButton okButton = new JButton("OK");
/*  32 */   private JButton cancelButton = new JButton("Abbrechen");
/*  33 */   private JButton aktuellButton = new JButton("Aktuell-Liste hinzufügen");
/*  34 */   private JButton hgbButton = new JButton("Hintergrundbilder-Liste");
/*  35 */   private JButton leerButton = new JButton("Leeren");
/*  36 */   private JButton helpButton = new JButton();
/*  37 */   private JButton printButton = new JButton();
/*     */ 
/*  40 */   private JCheckBox benutzen = new JCheckBox("Benutzen");
/*     */ 
/*  43 */   private JRadioButton links = new JRadioButton("links");
/*  44 */   private JRadioButton mitte = new JRadioButton("mittig");
/*  45 */   private JRadioButton rechts = new JRadioButton("rechts");
/*     */ 
/*  48 */   private ButtonGroup woGroup = new ButtonGroup();
/*     */ 
/*  51 */   private JTextArea textfeld = new JTextArea(10, 40);
/*     */   private JScrollPane textScrollPane;
/*     */   private JScrollPane fensterScrollPane;
/*     */   private Daten daten;
/*     */   private LoBeT lobet;
/*     */   private Einstellungen einstellungen;
/*     */ 
/*     */   public AblaufPlanGUI(LoBeT paramLoBeT, Daten paramDaten, boolean paramBoolean)
/*     */   {
/*  63 */     this.d = new Debug(paramBoolean);
/*  64 */     this.debug = paramBoolean;
/*  65 */     setTitle("Ablaufplan");
/*  66 */     this.daten = paramDaten;
/*  67 */     this.einstellungen = paramDaten.getEinstellungen();
/*  68 */     this.ablauf = this.einstellungen.getAblaufPlan();
/*  69 */     this.lobet = paramLoBeT;
/*  70 */     int i = paramDaten.getEinstellungen().getSeitenFontSize();
/*  71 */     setBounds(0, 0, 600, 400);
/*  72 */     initGUI();
/*  73 */     init();
/*  74 */     create();
/*  75 */     setResizable(true);
/*  76 */     setMaximizable(true);
/*  77 */     setIconifiable(true);
/*  78 */     setClosable(true);
/*  79 */     setVisible(true);
/*     */   }
/*     */ 
/*     */   public void init()
/*     */   {
/*  88 */     this.einstellungen = this.daten.getEinstellungen();
/*  89 */     this.ablauf = this.einstellungen.getAblaufPlan();
/*  90 */     this.textfeld.setText(this.ablauf.getText());
/*  91 */     int i = this.ablauf.getPosition();
/*  92 */     switch (i) {
/*     */     case 0:
/*  94 */       this.links.setSelected(true);
/*  95 */       break;
/*     */     case 1:
/*  97 */       this.mitte.setSelected(true);
/*  98 */       break;
/*     */     case 2:
/* 100 */       this.rechts.setSelected(true);
/*     */     }
/*     */ 
/* 103 */     this.benutzen.setSelected(this.ablauf.getLogo());
/* 104 */     this.logoTextLabel.setText(this.ablauf.getLogoText());
/* 105 */     setStatus();
/*     */   }
/*     */ 
/*     */   private void setStatus()
/*     */   {
/* 114 */     if (this.aktualisierungMouse) {
/* 115 */       if (this.benutzen.isSelected()) {
/* 116 */         this.links.setEnabled(true);
/* 117 */         this.mitte.setEnabled(true);
/* 118 */         this.rechts.setEnabled(true);
/* 119 */         this.logoTextLabel.setEnabled(true);
/*     */       } else {
/* 121 */         this.links.setEnabled(false);
/* 122 */         this.mitte.setEnabled(false);
/* 123 */         this.rechts.setEnabled(false);
/* 124 */         this.logoTextLabel.setEnabled(false);
/*     */       }
/*     */     }
/* 127 */     else if ((this.ablauf.getLogo()) || (this.benutzen.isSelected())) {
/* 128 */       this.links.setEnabled(true);
/* 129 */       this.mitte.setEnabled(true);
/* 130 */       this.rechts.setEnabled(true);
/* 131 */       this.logoTextLabel.setEnabled(true);
/*     */     } else {
/* 133 */       this.links.setEnabled(false);
/* 134 */       this.mitte.setEnabled(false);
/* 135 */       this.rechts.setEnabled(false);
/* 136 */       this.logoTextLabel.setEnabled(false);
/*     */     }
/*     */ 
/* 139 */     this.logoTextLabel.setText(this.ablauf.getLogoText());
/*     */   }
/*     */ 
/*     */   public void initGUI()
/*     */   {
/* 147 */     this.okButton.addActionListener(new AblaufPlanActionAdapter(this));
/* 148 */     this.cancelButton.addActionListener(new AblaufPlanActionAdapter(this));
/* 149 */     this.helpButton.addActionListener(new AblaufPlanActionAdapter(this));
/* 150 */     this.printButton.addActionListener(new AblaufPlanActionAdapter(this));
/* 151 */     this.benutzen.addMouseListener(new AblaufPlanMouseAdapter(this));
/* 152 */     this.aktuellButton.addActionListener(new AblaufPlanActionAdapter(this));
/* 153 */     this.hgbButton.addActionListener(new AblaufPlanActionAdapter(this));
/* 154 */     this.leerButton.addActionListener(new AblaufPlanActionAdapter(this));
/*     */ 
/* 156 */     this.woGroup.add(this.links);
/* 157 */     this.woGroup.add(this.mitte);
/* 158 */     this.woGroup.add(this.rechts);
/* 159 */     setIcons(this.einstellungen.getIcons());
/* 160 */     setToolTips(this.einstellungen.getToolTips());
/* 161 */     RadioButtonsInit();
/*     */   }
/*     */ 
/*     */   public void create()
/*     */   {
/* 167 */     setDefaultCloseOperation(1);
/*     */ 
/* 169 */     this.gridbag = new GridBagLayout();
/* 170 */     this.constraints = new GridBagConstraints();
/*     */ 
/* 173 */     this.mainPanel.setLayout(this.gridbag);
/* 174 */     this.logoPanel.setLayout(this.gridbag);
/*     */ 
/* 176 */     this.textScrollPane = new JScrollPane(this.textfeld);
/*     */ 
/* 179 */     constr(0, 0, 1, 1);
/* 180 */     this.constraints.fill = 1;
/* 181 */     this.gridbag.setConstraints(this.logoLabel, this.constraints);
/* 182 */     this.logoPanel.add(this.logoLabel);
/*     */ 
/* 184 */     constr(0, 1, 1, 1);
/* 185 */     this.constraints.fill = 1;
/* 186 */     this.gridbag.setConstraints(this.logoTextLabel, this.constraints);
/* 187 */     this.logoPanel.add(this.logoTextLabel);
/*     */ 
/* 189 */     constr(0, 2, 1, 1);
/* 190 */     this.constraints.fill = 1;
/* 191 */     this.gridbag.setConstraints(this.links, this.constraints);
/* 192 */     this.logoPanel.add(this.links);
/*     */ 
/* 194 */     constr(0, 3, 1, 1);
/* 195 */     this.constraints.fill = 1;
/* 196 */     this.gridbag.setConstraints(this.mitte, this.constraints);
/* 197 */     this.logoPanel.add(this.mitte);
/*     */ 
/* 199 */     constr(0, 4, 1, 1);
/* 200 */     this.constraints.fill = 1;
/* 201 */     this.gridbag.setConstraints(this.rechts, this.constraints);
/* 202 */     this.logoPanel.add(this.rechts);
/*     */ 
/* 204 */     constr(0, 5, 1, 1);
/* 205 */     this.constraints.fill = 1;
/* 206 */     this.gridbag.setConstraints(this.benutzen, this.constraints);
/* 207 */     this.logoPanel.add(this.benutzen);
/*     */ 
/* 212 */     constr(0, 0, 1, 1);
/* 213 */     this.constraints.fill = 1;
/* 214 */     this.gridbag.setConstraints(this.titelLabel, this.constraints);
/* 215 */     this.mainPanel.add(this.titelLabel);
/*     */ 
/* 217 */     constr(0, 1, 1, 1);
/* 218 */     this.constraints.fill = 1;
/* 219 */     this.gridbag.setConstraints(this.aktuellButton, this.constraints);
/* 220 */     this.mainPanel.add(this.aktuellButton);
/*     */ 
/* 222 */     constr(0, 2, 1, 1);
/* 223 */     this.constraints.fill = 1;
/* 224 */     this.gridbag.setConstraints(this.hgbButton, this.constraints);
/* 225 */     this.mainPanel.add(this.hgbButton);
/*     */ 
/* 227 */     constr(1, 1, 1, 1);
/* 228 */     this.constraints.fill = 1;
/* 229 */     this.gridbag.setConstraints(this.leerButton, this.constraints);
/* 230 */     this.mainPanel.add(this.leerButton);
/*     */ 
/* 232 */     constr(3, 1, 1, 1);
/* 233 */     this.constraints.fill = 1;
/* 234 */     this.gridbag.setConstraints(this.helpButton, this.constraints);
/* 235 */     this.mainPanel.add(this.helpButton);
/*     */ 
/* 237 */     constr(3, 2, 1, 1);
/* 238 */     this.constraints.fill = 1;
/* 239 */     this.gridbag.setConstraints(this.printButton, this.constraints);
/* 240 */     this.mainPanel.add(this.printButton);
/*     */ 
/* 242 */     constr(0, 3, 3, 1);
/* 243 */     this.constraints.fill = 0;
/* 244 */     this.gridbag.setConstraints(this.textScrollPane, this.constraints);
/* 245 */     this.mainPanel.add(this.textScrollPane);
/*     */ 
/* 247 */     constr(3, 3, 1, 1);
/* 248 */     this.constraints.fill = 0;
/* 249 */     this.gridbag.setConstraints(this.logoPanel, this.constraints);
/* 250 */     this.mainPanel.add(this.logoPanel);
/*     */ 
/* 252 */     constr(0, 4, 1, 1);
/* 253 */     this.constraints.fill = 0;
/* 254 */     this.gridbag.setConstraints(this.okButton, this.constraints);
/* 255 */     this.mainPanel.add(this.okButton);
/*     */ 
/* 257 */     constr(1, 4, 1, 1);
/* 258 */     this.constraints.fill = 0;
/* 259 */     this.gridbag.setConstraints(this.cancelButton, this.constraints);
/* 260 */     this.mainPanel.add(this.cancelButton);
/*     */ 
/* 262 */     this.mainPanel.setBorder(new LineBorder(null, 1));
/* 263 */     this.logoPanel.setBorder(new LineBorder(null, 1));
/*     */ 
/* 271 */     this.fensterScrollPane = new JScrollPane(this.mainPanel);
/*     */ 
/* 273 */     getContentPane().add(this.fensterScrollPane);
/* 274 */     pack();
/*     */   }
/*     */ 
/*     */   public void mouse(MouseEvent paramMouseEvent)
/*     */   {
/* 279 */     Object localObject = paramMouseEvent.getSource();
/* 280 */     if (localObject == this.benutzen) {
/* 281 */       this.aktualisierungMouse = true;
/* 282 */       setStatus();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void menuEvent(ActionEvent paramActionEvent)
/*     */   {
/* 290 */     String str = paramActionEvent.getActionCommand();
/* 291 */     Object localObject = paramActionEvent.getSource();
/* 292 */     if (localObject == this.okButton) {
/* 293 */       speichern(true);
/* 294 */     } else if (localObject == this.cancelButton) {
/* 295 */       close();
/* 296 */       init();
/* 297 */     } else if (localObject == this.helpButton) {
/* 298 */       this.lobet.hilfe(6);
/* 299 */     } else if (localObject == this.aktuellButton) {
/* 300 */       addAktuell();
/* 301 */     } else if (localObject == this.hgbButton) {
/* 302 */       addHintergrund();
/* 303 */     } else if (localObject == this.leerButton) {
/* 304 */       leeren();
/* 305 */     } else if (localObject == this.printButton) {
/* 306 */       speichern(false);
/* 307 */       this.lobet.openPrinter(6);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void taste(KeyEvent paramKeyEvent)
/*     */   {
/* 313 */     int i = paramKeyEvent.getModifiers();
/* 314 */     int j = paramKeyEvent.getKeyChar();
/* 315 */     int k = paramKeyEvent.getKeyCode();
/*     */ 
/* 317 */     if (k != 0)
/*     */     {
/* 319 */       if (k == 10)
/*     */       {
/* 321 */         this.d.out("Enter gedrückt!");
/* 322 */         speichern(true);
/* 323 */       } else if (k == 27) {
/* 324 */         close();
/* 325 */         init();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void leeren()
/*     */   {
/* 362 */     this.textfeld.setText("");
/*     */   }
/*     */ 
/*     */   private void addAktuell() {
/* 366 */     String str1 = this.textfeld.getText();
/* 367 */     String str2 = "";
/* 368 */     String str3 = "";
/* 369 */     int i = this.daten.getSize(3);
/* 370 */     int j = 0;
/* 371 */     int k = 0;
/* 372 */     int m = 0;
/* 373 */     int n = 0;
/* 374 */     int i1 = 1;
/* 375 */     int i2 = 0;
/*     */ 
/* 378 */     if (i > 0) {
/* 379 */       for (int i4 = 0; i4 < i; i4++) {
/* 380 */         j = 0;
/* 381 */         k = 0;
/* 382 */         str3 = "";
/* 383 */         i1 = 1;
/* 384 */         while ((i1 != 0) && (j < 10)) {
/* 385 */           if (this.daten.getLabel(j) == i4) {
/* 386 */             str2 = "[" + j + "] ";
/* 387 */             i1 = 0;
/*     */           }
/* 389 */           j++;
/*     */         }
/* 391 */         if (this.daten.getLabel(10) == i4) {
/* 392 */           str2 = "[L] ";
/* 393 */           i1 = 0;
/*     */         }
/* 395 */         if (i1 != 0) {
/* 396 */           str2 = "    ";
/*     */         }
/* 398 */         Aktuell localAktuell = this.daten.getAkt(i4);
/* 399 */         int i3 = localAktuell.getTyp();
/* 400 */         switch (i3) {
/*     */         case 0:
/* 402 */           str2 = str2 + "[L] ";
/* 403 */           Lied localLied = localAktuell.getLied();
/*     */ 
/* 405 */           k = localLied.getMaxStrophen();
/* 406 */           localLied.setAuswahl();
/* 407 */           n = 0;
/* 408 */           i2 = 0;
/* 409 */           m = 0;
/* 410 */           for (int i5 = 1; i5 <= k; i5++) {
/* 411 */             Strophe localStrophe = localLied.getStrophe();
/* 412 */             if (localStrophe.getAnfang())
/* 413 */               m++;
/* 414 */             if (localStrophe.getRefrain())
/* 415 */               i2 = 1;
/* 416 */             if (localStrophe.getBridge())
/* 417 */               n = 1;
/* 418 */             localLied.getNextStrophe();
/*     */           }
/* 420 */           if (m < 10)
/* 421 */             str3 = "0";
/* 422 */           str3 = str3 + m;
/* 423 */           if (i2 != 0)
/* 424 */             str3 = str3 + "+";
/*     */           else
/* 426 */             str3 = str3 + "/";
/* 427 */           if (k < 10)
/* 428 */             str3 = str3 + "0";
/* 429 */           str3 = str3 + k;
/* 430 */           if (n != 0)
/* 431 */             str3 = str3 + "B";
/*     */           else
/* 433 */             str3 = str3 + " ";
/* 434 */           break;
/*     */         case 1:
/* 436 */           str2 = str2 + "[T] ";
/* 437 */           str3 = "      ";
/* 438 */           break;
/*     */         case 2:
/* 440 */           str2 = str2 + "[B] ";
/* 441 */           str3 = "      ";
/*     */         }
/*     */ 
/* 444 */         str2 = str2 + str3 + " " + localAktuell.getTitel();
/*     */ 
/* 449 */         str1 = str1 + "\n" + str2;
/* 450 */         str2 = "";
/* 451 */         str3 = "";
/*     */       }
/*     */     }
/* 454 */     this.textfeld.setText(str1);
/*     */   }
/*     */ 
/*     */   private void addHintergrund() {
/* 458 */     String str1 = this.textfeld.getText() + "\nHintergrundbilder:<f>\n";
/* 459 */     String str2 = "";
/*     */ 
/* 461 */     for (int i = 0; i < 10; i++)
/* 462 */       if (this.daten.gethgBild(i) == -1) {
/* 463 */         this.d.out("" + i + " = -1");
/*     */       } else {
/* 465 */         Bild localBild = this.daten.getBild(this.daten.gethgBild(i));
/* 466 */         str1 = str1 + "[" + i + "] " + this.daten.gethgBild(i) + " " + localBild.getTitel() + "\n";
/*     */       }
/* 468 */     this.textfeld.setText(str1);
/*     */   }
/*     */ 
/*     */   private void constr(int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
/* 472 */     this.constraints.gridx = paramInt1;
/* 473 */     this.constraints.gridy = paramInt2;
/* 474 */     this.constraints.gridwidth = paramInt3;
/* 475 */     this.constraints.gridheight = paramInt4;
/*     */   }
/*     */ 
/*     */   private void speichern(boolean paramBoolean) {
/* 479 */     int i = 0;
/* 480 */     if (this.links.isSelected())
/* 481 */       i = 0;
/* 482 */     else if (this.mitte.isSelected())
/* 483 */       i = 1;
/*     */     else
/* 485 */       i = 2;
/* 486 */     this.ablauf.setAblaufPlan(this.textfeld.getText(), i, this.benutzen.isSelected());
/* 487 */     if (paramBoolean)
/* 488 */       close();
/*     */   }
/*     */ 
/*     */   public void nachLaden() {
/* 492 */     int i = this.daten.getEinstellungen().getSeitenFontSize();
/* 493 */     Font localFont = new Font("Monospaced", 0, i);
/* 494 */     this.textfeld.setFont(localFont);
/* 495 */     setBounds(0, 0, 600, 400);
/* 496 */     this.aktualisierungMouse = false;
/* 497 */     init();
/*     */   }
/*     */ 
/*     */   public void close() {
/* 501 */     setVisible(false);
/*     */   }
/*     */ 
/*     */   public void open() {
/* 505 */     setVisible(false);
/* 506 */     init();
/*     */     try {
/* 508 */       setIcon(false);
/*     */     } catch (Exception localException) {
/* 510 */       System.err.println("Fehler beim Deiconifizieren der AblaufPlanGUI");
/*     */ 
/* 512 */       JOptionPane.showMessageDialog(this, "Fehler beim deiconifizieren!", "DeIconifizieren", 0);
/*     */     }
/* 514 */     setLocation(0, 0);
/* 515 */     setVisible(true);
/*     */   }
/*     */ 
/*     */   private void setToolTips()
/*     */   {
/* 520 */     if (this.einstellungen.getToolTips());
/*     */   }
/*     */ 
/*     */   private void RadioButtonsInit()
/*     */   {
/*     */   }
/*     */ 
/*     */   private void setToolTips(boolean paramBoolean)
/*     */   {
/* 534 */     if (paramBoolean) {
/* 535 */       this.helpButton.setToolTipText("Hilfe zum Ablaufplan");
/* 536 */       this.printButton.setToolTipText("Ablaufplan Drucken");
/*     */     } else {
/* 538 */       this.helpButton.setToolTipText(null);
/* 539 */       this.printButton.setToolTipText(null);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setIcons(boolean paramBoolean) {
/* 544 */     if (paramBoolean)
/*     */     {
/* 546 */       this.helpButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/ContextualHelp24.gif")));
/* 547 */       this.printButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Print24.gif")));
/*     */     }
/*     */     else {
/* 550 */       this.helpButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/ContextualHelp16.gif")));
/* 551 */       this.printButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Print16.gif")));
/*     */     }
/*     */   }
/*     */ }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     AblaufPlanGUI
 * JD-Core Version:    0.6.0
 */