
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
  
  public class Bildschirm extends JDialog
  {
    public static final long serialVersionUID = 1L;
    private LoBeT l;
    private Daten daten;
    private Debug d = new Debug(false);
    private Einstellungen options;
    private TextEinstellungen textE;
    private TextEinstellungen liedE;
    private BildEinstellungen bildE;
    private Aktuell dies = new Aktuell();
    private boolean newsticker = false;
    private int[] nr = new int[4];
    private int[] max = new int[4];
    private int aktStrophe = 1;
    private boolean refrain = false;
    private boolean bridge = false;
    private boolean debug = false;
    private int maxFont = 200;
    private boolean maxFontSchon = false;
    private boolean logo = false;
    private boolean nt = true;
    private NewstickerThread ntt;
    private boolean schwarz = false;
    private boolean isNummer = true;
    private boolean buchstaben = false;
    private boolean rahmenWahl = true;
    private int nummer = 0;
    private int[] letter = new int[26];
    public static final int NICHTS = -1;
    public static final int LIED = 0;
    public static final int TEXT = 1;
    public static final int BILD = 2;
    public static final int AKT = 3;
    public static final int NORMAL = 0;
    public static final int SANFANG = 1;
    public static final int REFRAIN = 2;
    public static final int BRIDGE = 4;
    public static final int kNORMAL = 1;
    public static final int kSANFANG = 1;
    public static final int kREFRAIN = 2;
    public static final int kBRIDGE = 3;
    private boolean hgBild = false;
    private boolean hgbTaste = false;
    private int hgbZiffer = 0;
    private int hgbBild = -1;
    private boolean hgb_only = false;
  
    private int wbi = 3;
    private int wf = 3;
    private int was = 0;
    private int konkret = 1;
    private int translate = 4;
  
    private Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
  
    private boolean neu = false;
    private Container content;
    private Graphics comp2d;
    private Graphics2D g;
    private BufferedImage leinwand;
    private BufferedImage ohneNT;
    private BufferedImage logoBild;
    private BufferedImage hgbleinwand;
    private long startzeit = System.currentTimeMillis();
    private long jetztzeit = System.currentTimeMillis();
    private long weiterzeit = System.currentTimeMillis();
    private BildschirmZeichnen zeichnen;
    private int x = screen.width; private int y = screen.height;
    private int wo = x;
    private byte[] mem = new byte[5000000];
  
    private void datenUbertragen()
    {
      options = daten.getEinstellungen();
      liedE = options.getLiedEinstellungen();
      textE = options.getTextEinstellungen();
      bildE = options.getBildEinstellungen();
  
      for (int i = 0; i < 4; i++) {
        Vector localVector = daten.getVector(i);
        if (null == localVector) {
          max[i] = 0;
          nr[i] = -1;
        } else {
          max[i] = localVector.size();
          nr[i] = 0;
        }
      }
      if (max[3] != 0)
      {
        dies = daten.getAkt(0);
      }
  
      hgbBild = daten.gethgBild(0);
      hgBild = false;
  
      Vector localVector = daten.getVector(0);
      int j = localVector.size();
      int k = 65;
      int m = 0;
  
      for (int i = 0; i < 26; i++)
        letter[i] = 0;
      for (int i = 0; i < j; i++) {
        Lied localLied = daten.getLied(i);
        String str = localLied.getTitel();
        m = str.charAt(0);
        if ((m >= k) && (k <= 90)) {
          letter[(k++ - 65)] = i;
          d.out("Nr: " + k + " Titel: " + str);
        }
      }
      d.out("A: " + k);
    }
  
    public Bildschirm()
    {
      System.out.println("Warnung: Alibi-Bildschirm gew�hlt");
    }
  
    public Bildschirm(LoBeT paramLoBeT) {
      super(paramLoBeT, "LoBeT-Präsentation", true);
      daten = new Daten();
      datenUbertragen();
      l = paramLoBeT;
      create();
      setVisible(true);
    }
  
    public Bildschirm(LoBeT paramLoBeT, Daten paramDaten, boolean paramBoolean)
    {
      super(paramLoBeT, "LoBeT-Präsentation", true);
      l = paramLoBeT;
      daten = paramDaten;
      datenUbertragen();
      d = new Debug(paramBoolean);
      debug = paramBoolean;
      create();
      setVisible(true);
    }
  
    public Bildschirm(LoBeT paramLoBeT, Daten paramDaten, int paramInt1, int paramInt2, boolean paramBoolean)
    {
      super(paramLoBeT, "LoBeT-Präsentation", true);
      l = paramLoBeT;
      daten = paramDaten;
      datenUbertragen();
      d = new Debug(paramBoolean);
      debug = paramBoolean;
      create();
  
      refrain = false;
      maxFontSchon = false;
      switch (paramInt1) {
      case 3:
        if (paramInt2 >= max[3]) break;
        d.out("Gogo: Aktuell");
        wf = 3;
        nr[3] = paramInt2;
        akt(); break;
      case 0:
        if (paramInt2 >= max[0]) break;
        d.out("Gogo: Lied");
        wf = 0;
        nr[0] = paramInt2;
        lied(); break;
      case 1:
        if (paramInt2 >= max[1]) break;
        d.out("Gogo: Text");
        wf = 1;
        nr[1] = paramInt2;
        text(); break;
      case 2:
        if (paramInt2 >= max[2]) break;
        d.out("Gogo: Bild");
        wf = 2;
        nr[2] = paramInt2;
        bild();
         break;
      }
  
      setVisible(true);
    }
  
    public void create()
    {
      refrain = false;
      addKeyListener(new BildschirmTastenAdapter(this));
  
      Dimension localDimension = Toolkit.getDefaultToolkit().getScreenSize();
      GraphicsDevice localGraphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
  
      setSize(localDimension);
      setUndecorated(true);
      try
      {
        zeichnen = new BildschirmZeichnen(localDimension.width, localDimension.height, l);
  
        setResizable(false);
  
        content = getContentPane();
  
        content.add(zeichnen);
        setBackground(new Color(0, 0, 0));
        leinwand = new BufferedImage(x, y, 1);
        Graphics2D localGraphics2D1 = leinwand.createGraphics();
        localGraphics2D1.setColor(new Color(0, 0, 0));
        localGraphics2D1.fillRect(0, 0, x, y);
  
        int i1 = daten.getLabel(10);
        d.out("Logolabel: " + i1);
        if ((i1 >= 0) && (i1 < max[3])) {
          Aktuell localAktuell = daten.getAkt(i1);
          Bild localBild = localAktuell.getBild();
          if (null != localBild) {
            d.out("Bild kann gezeichnet werden...");
            maxFontSchon = false;
            logoBild = new BufferedImage(x, y, 1);
            Graphics2D localGraphics2D2 = logoBild.createGraphics();
            localGraphics2D2.setColor(bildE.getBildH());
            localGraphics2D2.fillRect(0, 0, x, y);
            int i = bildE.getPosition();
            int j = localBild.getSize().height;
            int k = localBild.getSize().width;
            d.out("Originalbildgröße: " + k + " " + j);
            d.out("Bildschirmgröße: " + x + " " + y);
            double d2 = (double)k / (double)j;
            double d1 = (double)j / (double)k;
            d.out("Verhältnis yy: " + d2);
            d.out("Verhältnis xx: " + d1);
            int m = 0;
            int n = 0;
            if (bildE.getOriginal()) {
              switch (i) {
              case 0:
                n = 0;
                m = (x - k) / 2;
                break;
              case 1:
                m = 0;
                n = (y - j) / 2;
                break;
              case 2:
                m = (x - k) / 2;
                n = (y - j) / 2;
                break;
              case 3:
                m = x - k;
                n = (y - j) / 2;
                break;
              case 4:
                m = (x - k) / 2;
                n = y - j;
              }
            }
            else {
              if (bildE.getRahmen()) {
                d.out("Seitenverhältnis beibehalten");
                if (bildE.getScreensize()) {
                  d.out("Bildschirmgröße");
                  if (j > k) {
                    j = y;
                    k = (int)(y / d1);
                  } else {
                    k = x;
                    j = (int)(x / d2);
                  }
                  d.out("Bildgröße: " + k + " " + j);
                } else {
                  d.out("Keine Bildschirmgröße");
                  if (j > k) {
                    j = bildE.getPixelY();
                    k = (int)(bildE.getPixelY() / d1);
                  } else {
                    k = bildE.getPixelX();
                    j = (int)(bildE.getPixelX() / d2);
                  }
                  d.out("Bildgröße: " + k + " " + j);
                }
              } else {
                d.out("Kein Seitenverhältnis");
                if (bildE.getScreensize()) {
                  d.out("Bildschirmgröße");
                  j = y;
                  k = x;
                  d.out("Bildgröße: " + k + " " + j);
                } else {
                  d.out("keine Bildschirmgröße");
                  k = bildE.getPixelX();
                  j = bildE.getPixelY();
                  d.out("Bildgröße: " + k + " " + j);
                }
              }
              switch (i) {
              case 0:
                n = 0;
                m = (x - k) / 2;
                break;
              case 1:
                m = 0;
                n = (y - j) / 2;
                break;
              case 2:
                m = (x - k) / 2;
                n = (y - j) / 2;
                break;
              case 3:
                m = x - k;
                n = (y - j) / 2;
                break;
              case 4:
                m = (x - k) / 2;
                n = y - j;
              }
            }
  
            localGraphics2D2.drawImage(localBild.getBild(), m, n, k, j, zeichnen);
          } else {
            d.out("Kein Bild vorhanden");
  
            logoBild = leinwand;
          }
        }
  
        repaint();
  
        setDefaultCloseOperation(0);
      } catch (OutOfMemoryError localOutOfMemoryError) {
        mem = null;
        System.gc();
        System.err.println("java.lang.OutOfMemoryError...");
        System.err.println("... abgefangen ...");
        System.err.println("Präsentation wird abgebrochen ...");
        JOptionPane.showMessageDialog(this, "Das Programm hat zuwenig Speicher. \nDie Präsentation wird abgebrochen!", "Out of Memory - Error", 0);
  
        close();
      }
    }
  
    public void close()
    {
      if (null != ntt) {
        ntt.close();
      }
      if (null != zeichnen)
        zeichnen.close();
      if (null != leinwand)
        leinwand.flush();
      setVisible(false);
      dispose();
    }
  
    public void action(ActionEvent paramActionEvent)
    {
    }
  
    public boolean getNew()
    {
      return neu;
    }
  
    private boolean veraendert() {
      neu = true;
      return neu;
    }
  
    private void setStrophe(Strophe paramStrophe, Lied paramLied) {
      int i = options.getLiedPosX();
      int j = options.getLiedPosY();
      int k = options.getLiedRahmenPos();
  
      boolean globaleE = options.getLiedVorrang();
      setWas(paramStrophe);
      
      // Get config local or global
      liedE = paramLied.getTextEinstellungen();
      if (globaleE)
         liedE = options.getLiedEinstellungen();  
      
      Color colorTextFill = liedE.getTextF();
      Color colorTextBkr = liedE.getTextH();
      Color colorTextBorder = liedE.getRahmenFarbe();
      Color colorTextTrans = liedE.getTransF();
       
      String sFontName = TextEinstellungen.fontNamen[liedE.getTextFont(konkret)];
      String sFontNameTrans = TextEinstellungen.fontNamen[liedE.getTextFont(translate)];
      
      int iStyleF = getTextFont();
      int iSizeF = liedE.getTextSize(konkret);
      int iSizeFTransl = liedE.getTextSize(translate);
     
      rahmenWahl = liedE.getRahmen();
      /*
      } else {
        liedE = paramLied.getTextEinstellungen();
        colorTextFill = configTEXT.getTextF();
        colorTextBkr = configTEXT.getTextH();
        sFontName = TextEinstellungen.fontNamen[liedE.getTextFont(konkret)];
        iStyleF = getTextFont();
        iSizeF = liedE.getTextSize(konkret);
        colorTextBorder = configTEXT.getRahmenFarbe();
        rahmenWahl = configTEXT.getRahmen();
      }
      */
      
      boolean bShowTranslation = liedE.getAnzeige();
     
      int i10 = options.getTranslatePosX();
      int iStyleF2 = 0;
      if (liedE.getTextBold(4))
        iStyleF2 += 1;
      if (liedE.getTextItalic(4)) 
        iStyleF2 += 2;
      
      d.out("org. Fontstring, fontBold, fontSize: " + sFontName + " " + iStyleF + " " + iSizeF);
      leinwand = new BufferedImage(x, y, 1);
      g = leinwand.createGraphics();
  
      g.setColor(colorTextBkr);
      g.fillRect(0, 0, x, y);
  
      HGBild_zeichnen(g);
      g.setColor(colorTextFill);
      Font localFont = new Font(sFontName, iStyleF, iSizeF);
      FontMetrics localFontMetrics = getFontMetrics(localFont);
      g.setFont(localFont);
      int begin = j;
      int n;
    if (liedE.getTextKleiner()) 
    {
        int i5 = 0;
        for (int i6 = 0; i6 < 24; i6++)
          if (i5 < localFontMetrics.stringWidth(paramStrophe.get(i6)))
            i5 = localFontMetrics.stringWidth(paramStrophe.get(i6));
        int iSizeFMax;
        if (liedE.getTextZeile()) {
          for (int iZ = 0; iZ < Strophe.maxZeile; iZ++) {
            iSizeFMax = iSizeF;
            localFont = new Font(sFontName, iStyleF, iSizeFMax);
            localFontMetrics = getFontMetrics(localFont);
            g.setFont(localFont);
            while (localFontMetrics.stringWidth(paramStrophe.get(iZ)) > x - i) {
              iSizeFMax--;
              localFont = new Font(sFontName, iStyleF, iSizeFMax);
              localFontMetrics = getFontMetrics(localFont);
              g.setFont(localFont);
            }
            begin += localFontMetrics.getHeight();
            if (paramStrophe.get(iZ).length() > 0) {
               if (paramStrophe.get(iZ).charAt(0) == '*') {
                  begin -= localFontMetrics.getHeight();
                } else if (paramStrophe.get(iZ).charAt(0) == '#') 
				{
                if (bShowTranslation) {
                  g.setFont(localFont);
                  localFontMetrics = getFontMetrics(localFont);
                  n = localFontMetrics.getHeight();
  
                  if (iSizeFMax - iSizeFTransl > 0)
                    localFont = new Font(sFontNameTrans, iStyleF2, iSizeFMax - iSizeFTransl);
                  else
                    localFont = new Font(sFontNameTrans, iStyleF2, iSizeFMax);
                  localFontMetrics = getFontMetrics(localFont);
                  int m = localFontMetrics.getHeight();
  
                  if (rahmenWahl) {
                    g.setColor(colorTextBorder);
                    g.setFont(localFont);
  
                    g.drawString(paramStrophe.get(iZ).substring(1), i + i10 - k, begin - n + m);
                    g.drawString(paramStrophe.get(iZ).substring(1), i + i10 + k, begin - n + m);
                    g.drawString(paramStrophe.get(iZ).substring(1), i + i10, begin - n + m + k);
                    g.drawString(paramStrophe.get(iZ).substring(1), i + i10, begin - n + m - k);
                  }
  
                  g.setColor(colorTextTrans);
                  g.setFont(localFont);
                  g.drawString(paramStrophe.get(iZ).substring(1), i + i10, begin - n + m);
                }
                else {
                  begin -= localFontMetrics.getHeight();
                }
              } else {
                localFont = new Font(sFontName, iStyleF, iSizeFMax);
                localFontMetrics = getFontMetrics(localFont);
                if (rahmenWahl) {
                  g.setColor(colorTextBorder);
                  g.setFont(localFont);
                  g.drawString(paramStrophe.get(iZ), i - k, begin);
                  g.drawString(paramStrophe.get(iZ), i + k, begin);
                  g.drawString(paramStrophe.get(iZ), i, begin + k);
                  g.drawString(paramStrophe.get(iZ), i, begin - k);
                }
                g.setColor(colorTextFill);
                g.setFont(localFont);
                g.drawString(paramStrophe.get(iZ), i, begin);
                int m = localFontMetrics.getHeight();
              }
            }
		  }
        } else {
	//ganzen Text verkleinern
				
  
        if (maxFontSchon) {
          d.out("Fontsize ist schon errechnet");
  
          iSizeFMax = maxFont;
          localFont = new Font(sFontName, iStyleF, iSizeFMax);
          localFontMetrics = getFontMetrics(localFont);
          g.setFont(localFont);
        }
        else if (paramLied.getOldFont() > -1) {
          d.out("Font aus dem Speicher");
          iSizeFMax = paramLied.getOldFont();
          localFont = new Font(sFontName, iStyleF, iSizeFMax);
          localFontMetrics = getFontMetrics(localFont);
          g.setFont(localFont);
        }
        else {
          d.out("Font wird erst noch errechnet");
  
          iSizeFMax = iSizeF;
          paramLied.setAuswahl();
          paramStrophe = paramLied.getStrophe();
          setWas(paramStrophe);
          sFontName = TextEinstellungen.fontNamen[liedE.getTextFont(konkret)];
          iStyleF = 3;
          iSizeF = liedE.getTextSize(konkret);
          iSizeFMax = iSizeF;
          localFont = new Font(sFontName, iStyleF, iSizeFMax);
          localFontMetrics = getFontMetrics(localFont);
          g.setFont(localFont);
          String str3 = paramStrophe.get(1);
          i5 = 0;
          for (int i6 = 0; i6 < paramLied.getMaxStrophen(); i6++) {
            for (int i7 = 0; i7 < 24; i7++)
            {
              if ((paramStrophe.get(i7).length() <= 1) || 
                (paramStrophe.get(i7).charAt(0) == '#') || (paramStrophe.get(i7).charAt(0) == '*') || 
                (i5 >= localFontMetrics.stringWidth(paramStrophe.get(i7))))

				continue;
              i5 = localFontMetrics.stringWidth(paramStrophe.get(i7));
              str3 = paramStrophe.get(i7);
            }
  
            paramStrophe = paramLied.getNextStrophe();
            setWas(paramStrophe);
            sFontName = TextEinstellungen.fontNamen[liedE.getTextFont(konkret)];
            iSizeF = liedE.getTextSize(konkret);
            iSizeFMax = iSizeF;
            localFont = new Font(sFontName, iStyleF, iSizeFMax);
            localFontMetrics = getFontMetrics(localFont);
            g.setFont(localFont);
          }
  
          paramLied.setAuswahl();
          paramStrophe = paramLied.getStrophe();
          setWas(paramStrophe);
          sFontName = TextEinstellungen.fontNamen[liedE.getTextFont(konkret)];
          iSizeF = liedE.getTextSize(konkret);
          iSizeFMax = iSizeF;
          localFont = new Font(sFontName, iStyleF, iSizeFMax);
          localFontMetrics = getFontMetrics(localFont);
          g.setFont(localFont);
  
          while (i5 > x - i) {
            iSizeFMax--;
            localFont = new Font(sFontName, iStyleF, iSizeFMax);
            localFontMetrics = getFontMetrics(localFont);
            g.setFont(localFont);
            i5 = localFontMetrics.stringWidth(str3);
          }
  
          paramLied.setAuswahl();
          paramStrophe = paramLied.getStrophe();
          setWas(paramStrophe);
          sFontName = TextEinstellungen.fontNamen[liedE.getTextFont(konkret)];
          iStyleF = getTextFont();
          localFont = new Font(sFontName, iStyleF, iSizeFMax);
          localFontMetrics = getFontMetrics(localFont);
          g.setFont(localFont);
          
          maxFont = iSizeFMax;
          paramLied.setOldFont(maxFont);
          maxFontSchon = true;
         }
		
        d.out("Fontstring, fontBold, fontSize: " + sFontName + " " + iStyleF + " " + iSizeF);
        begin = j + localFontMetrics.getHeight();
        int hight = localFontMetrics.getHeight();
        for (int i6 = 0; i6 < 24; i6++) {
          if (paramStrophe.get(i6).length() > 1)
          {
            if (paramStrophe.get(i6).charAt(0) == '*') {
              begin -= localFontMetrics.getHeight();
            } else if (paramStrophe.get(i6).charAt(0) == '#') {
              if (bShowTranslation) {
                g.setColor(colorTextTrans);
                n = localFontMetrics.getHeight();
  
                if (iSizeFMax - iSizeFTransl > 0)
                  localFont = new Font(sFontNameTrans, iStyleF2, iSizeFMax - iSizeFTransl);
                else
                  localFont = new Font(sFontNameTrans, iStyleF2, iSizeFMax);
                localFontMetrics = getFontMetrics(localFont);
                hight = localFontMetrics.getHeight();
  
                if (rahmenWahl) {
                  g.setFont(localFont);
                  g.setColor(colorTextBorder);
                  g.drawString(paramStrophe.get(i6).substring(1), i + i10 - k, begin - n + hight);
                  g.drawString(paramStrophe.get(i6).substring(1), i + i10 + k, begin - n + hight);
                  g.drawString(paramStrophe.get(i6).substring(1), i + i10, begin - n + hight - k);
                  g.drawString(paramStrophe.get(i6).substring(1), i + i10, begin - n + hight + k);
                }
                g.setFont(localFont);
                g.setColor(colorTextTrans);
                g.drawString(paramStrophe.get(i6).substring(1), i + i10, begin - n + hight);
              } else {
                hight = 0;
              }
            } else {
              localFont = new Font(sFontName, iStyleF, iSizeFMax);
              localFontMetrics = getFontMetrics(localFont);
              g.setFont(localFont);
              if (rahmenWahl) {
                g.setColor(colorTextBorder);
                g.drawString(paramStrophe.get(i6), i - k, begin);
                g.drawString(paramStrophe.get(i6), i + k, begin);
                g.drawString(paramStrophe.get(i6), i, begin - k);
                g.drawString(paramStrophe.get(i6), i, begin + k);
              }
              g.setColor(colorTextFill);
              g.drawString(paramStrophe.get(i6), i, begin);
              hight = localFontMetrics.getHeight();
            }
          }
          begin += hight;
        }
      }
	 
    } else
    {
 // ============================================================================================================================
 /* double code - disable ---- */
      
   
  
      int begin1 = j + localFontMetrics.getHeight();
      int hight = localFontMetrics.getHeight();
      d.out("Fontstring, fontBold, fontSize: " + sFontName + " " + iStyleF + " " + iSizeF);
      for (int i6 = 0; i6 < 24; i6++) {
        if (paramStrophe.get(i6).length() > 1) {
          if (paramStrophe.get(i6).charAt(0) == '*') {
            begin1 -= localFontMetrics.getHeight();
          } else if (paramStrophe.get(i6).charAt(0) == '#') {
            if (bShowTranslation) {
              n = localFontMetrics.getHeight();
              if (iSizeF - iSizeFTransl > 0)
                localFont = new Font(sFontNameTrans, iStyleF2, iSizeF - iSizeFTransl);
              else
                localFont = new Font(sFontNameTrans, iStyleF2, iSizeF);
              localFontMetrics = getFontMetrics(localFont);
              hight = localFontMetrics.getHeight();
              g.setFont(localFont);
              if (rahmenWahl) {
                g.setColor(colorTextBorder);
                g.drawString(paramStrophe.get(i6).substring(1), i + i10 - k, begin1 - n + hight);
                g.drawString(paramStrophe.get(i6).substring(1), i + i10 + k, begin1 - n + hight);
                g.drawString(paramStrophe.get(i6).substring(1), i + i10, begin1 - n + hight - k);
                g.drawString(paramStrophe.get(i6).substring(1), i + i10, begin1 - n + hight + k);
              }
              g.setColor(colorTextTrans);
              g.drawString(paramStrophe.get(i6).substring(1), i + i10, begin1 - n + hight);
            } else {
              hight = 0;
            }
          } else {
            localFont = new Font(sFontName, iStyleF, iSizeF);
            localFontMetrics = getFontMetrics(localFont);
            g.setFont(localFont);
            if (rahmenWahl) {
              g.setColor(colorTextBorder);
              g.drawString(paramStrophe.get(i6), i - k, begin1);
              g.drawString(paramStrophe.get(i6), i + k, begin1);
              g.drawString(paramStrophe.get(i6), i, begin1 + k);
              g.drawString(paramStrophe.get(i6), i, begin1 - k);
            }
            g.setColor(colorTextFill);
            g.drawString(paramStrophe.get(i6), i, begin1);
            hight = localFontMetrics.getHeight();
          }
        }
        begin1 += hight;
      }
 
    }   
      zeichnen.maleBild(leinwand);
      ohneNT = leinwand;
      schwarz = false;
      logo = false;
      hgb_only = false;
    }
  
    private void setText(Strophe paramStrophe, Text paramText)
    {
      int i = options.getTextPosX();
      int j = options.getTextPosY();
      int k = options.getTextRahmenPos();
  
      boolean bool = options.getTextVorrang();
      TextEinstellungen localTextEinstellungen = paramText.getTextEinstellungen();
      Color localColor1;
      Color localColor2;
      Color localColor3;
      if (bool) {
        textE = options.getTextEinstellungen();
        localColor1 = textE.getTextF();
        localColor2 = textE.getTextH();
        String str1 = TextEinstellungen.fontNamen[textE.getTextFont(konkret)];
        int m = getTextFont();
        int n = textE.getTextSize(konkret);
        localColor3 = textE.getRahmenFarbe();
        rahmenWahl = textE.getRahmen();
      } else {
        textE = paramText.getTextEinstellungen();
        localColor1 = localTextEinstellungen.getTextF();
        localColor2 = localTextEinstellungen.getTextH();
        String str1 = TextEinstellungen.fontNamen[textE.getTextFont(konkret)];
        int m = getTextFont();
        int n = textE.getTextSize(konkret);
        localColor3 = localTextEinstellungen.getRahmenFarbe();
        rahmenWahl = localTextEinstellungen.getRahmen();
      }
  
      setWas(paramStrophe);
  
      String str1 = TextEinstellungen.fontNamen[textE.getTextFont(0)];
      int m = getTextFont();
      int n = textE.getTextSize(0);
  
      d.out("Fontstring, fontBold, fontSize: " + str1 + " " + m + " " + n);
      leinwand = new BufferedImage(x, y, 1);
      g = leinwand.createGraphics();
  
      g.setColor(localColor2);
      g.fillRect(0, 0, x, y);
  
      HGBild_zeichnen(g);
      g.setColor(localColor1);
      Font localFont = new Font(str1, m, n);
      FontMetrics localFontMetrics = getFontMetrics(localFont);
      g.setFont(localFont);
      int i4 = j;
      if (textE.getTextKleiner()) {
        int i1 = 0;
        for (int i2 = 0; i2 < 24; i2++)
          if (i1 < localFontMetrics.stringWidth(paramStrophe.get(i2)))
            i1 = localFontMetrics.stringWidth(paramStrophe.get(i2));
        d.out("Maxlength: " + i1);
        int i5;
        if (textE.getTextZeile()) {
          for (int i2 = 0; i2 < 24; i2++) {
            i5 = n;
            localFont = new Font(str1, m, i5);
            localFontMetrics = getFontMetrics(localFont);
            g.setFont(localFont);
            while (localFontMetrics.stringWidth(paramStrophe.get(i2)) > x - i) {
              i5--;
              localFont = new Font(str1, m, i5);
              localFontMetrics = getFontMetrics(localFont);
              g.setFont(localFont);
            }
            i4 += localFontMetrics.getHeight();
            if (paramStrophe.get(i2).length() > 0) {
              if (rahmenWahl) {
                g.setColor(localColor3);
                g.drawString(paramStrophe.get(i2), i - k, i4);
                g.drawString(paramStrophe.get(i2), i + k, i4);
                g.drawString(paramStrophe.get(i2), i, i4 + k);
                g.drawString(paramStrophe.get(i2), i, i4 - k);
              }
              g.setColor(localColor1);
              g.drawString(paramStrophe.get(i2), i, i4);
            }
  
          }
  
        }
  
        if (maxFontSchon) {
          d.out("Fontsize ist schon errechnet");
  
          i5 = maxFont;
          localFont = new Font(str1, m, i5);
          localFontMetrics = getFontMetrics(localFont);
          g.setFont(localFont);
        }
        else if (paramText.getOldFont() > -1) {
          d.out("Font aus dem Speicher");
          i5 = paramText.getOldFont();
          localFont = new Font(str1, m, i5);
          localFontMetrics = getFontMetrics(localFont);
          g.setFont(localFont);
        } else {
          d.out("Font wird erst noch errechnet");
  
          i5 = n;
          paramText.setAuswahl();
          paramStrophe = paramText.getText();
          String str2 = paramStrophe.get(1);
          setWas(paramStrophe);
          str1 = TextEinstellungen.fontNamen[textE.getTextFont(0)];
          m = 3;
          n = textE.getTextSize(0);
          i5 = n;
          localFont = new Font(str1, m, i5);
          localFontMetrics = getFontMetrics(localFont);
          g.setFont(localFont);
          i1 = 0;
          for (int i2 = 0; i2 < paramText.getMaxText(); i2++) {
            for (int i3 = 0; i3 < 24; i3++)
            {
              if (i1 < localFontMetrics.stringWidth(paramStrophe.get(i3))) {
                i1 = localFontMetrics.stringWidth(paramStrophe.get(i3));
                str2 = paramStrophe.get(i3);
              }
            }
            d.out("Maxlength/Seite/Text: " + i1 + " / " + i2 + " / " + str2);
            paramStrophe = paramText.getNextText();
            setWas(paramStrophe);
            str1 = TextEinstellungen.fontNamen[textE.getTextFont(0)];
            n = textE.getTextSize(0);
            i5 = n;
            localFont = new Font(str1, m, i5);
            localFontMetrics = getFontMetrics(localFont);
            g.setFont(localFont);
          }
  
          paramText.setAuswahl();
          paramStrophe = paramText.getText();
          setWas(paramStrophe);
          str1 = TextEinstellungen.fontNamen[textE.getTextFont(0)];
          n = textE.getTextSize(0);
          i5 = n;
          d.out("Fontsize: " + n);
          localFont = new Font(str1, m, i5);
          localFontMetrics = getFontMetrics(localFont);
          g.setFont(localFont);
  
          d.out("x-zuPosX: " + x + " - " + i + " = " + (x - i));
          while (i1 > x - i) {
            i5--;
            localFont = new Font(str1, m, i5);
            localFontMetrics = getFontMetrics(localFont);
            g.setFont(localFont);
            i1 = localFontMetrics.stringWidth(str2);
  
            d.out("StringWidth as maxlength: " + i1);
          }
          paramText.setAuswahl();
          paramStrophe = paramText.getText();
          setWas(paramStrophe);
          str1 = TextEinstellungen.fontNamen[textE.getTextFont(0)];
          m = getTextFont();
          localFont = new Font(str1, m, i5);
          localFontMetrics = getFontMetrics(localFont);
          g.setFont(localFont);
          maxFont = i5;
          paramText.setOldFont(maxFont);
          maxFontSchon = true;
        }
  
        d.out("Fontstring, fontBold, fontSize: " + str1 + " " + m + " " + i5);
        i4 = j + localFontMetrics.getHeight();
        for(int i2 = 0; i2 < 24; i2++) {
          if (paramStrophe.get(i2).length() > 0) {
            if (rahmenWahl) {
              g.setColor(localColor3);
              g.drawString(paramStrophe.get(i2), i - k, i4);
              g.drawString(paramStrophe.get(i2), i + k, i4);
              g.drawString(paramStrophe.get(i2), i, i4 + k);
              g.drawString(paramStrophe.get(i2), i, i4 - k);
            }
            g.setColor(localColor1);
            g.drawString(paramStrophe.get(i2), i, i4);
          }
          i4 += localFontMetrics.getHeight();
        }
      }
  
      i4 = j + localFontMetrics.getHeight();
      for (int i2 = 0; i2 < 24; i2++) {
        if (paramStrophe.get(i2).length() > 0) {
          if (rahmenWahl) {
            g.setColor(localColor3);
            g.drawString(paramStrophe.get(i2), i - k, i4);
            g.drawString(paramStrophe.get(i2), i + k, i4);
            g.drawString(paramStrophe.get(i2), i, i4 + k);
            g.drawString(paramStrophe.get(i2), i, i4 - k);
          }
          g.setColor(localColor1);
          g.drawString(paramStrophe.get(i2), i, i4);
        }
  
        i4 += localFontMetrics.getHeight();
      }
  
      zeichnen.maleBild(leinwand);
      ohneNT = leinwand;
      schwarz = false;
      logo = false;
      hgb_only = false;
    }
  
    private void setWas(Strophe paramStrophe) {
      was = 0;
      konkret = 1;
      if (paramStrophe.getBridge()) {
        was += 4;
        konkret = 3;
      }
      if (paramStrophe.getAnfang()) {
        was += 1;
        konkret = 1;
      }
      if (paramStrophe.getRefrain()) {
        was += 2;
        konkret = 2;
      }
    }
  
    private int getTextFont() {
      int i = 0;
      int j = wbi;
      if (wbi == 3)
        j = wf;
      switch (j)
      {
      case 0:
        if (liedE.getTextBold(konkret))
          i += 1;
        if (!liedE.getTextItalic(konkret)) break;
        i += 2; break;
      case 1:
        if (textE.getTextBold(0))
          i += 1;
        if (!textE.getTextItalic(0)) break;
        i += 2;
      }
  
      return i;
    }
  
    private void liedAnfang()
    {
      refrain = false;
      Lied localLied;
      Strophe localStrophe;
      Text localText;
      switch (wf) {
      case 0:
        if (0 != wbi) break;
        localLied = daten.getLied(nr[0]);
        localLied.setAktStrophe(1);
        localStrophe = localLied.getStrophe();
        setStrophe(localStrophe, localLied);
        repaint();
        break;
      case 1:
        if (1 != wbi) break;
        localText = daten.getText(nr[1]);
        localText.setAktText(1);
        localStrophe = localText.getText();
        setText(localStrophe, localText);
        repaint();
        break;
      case 3:
        if (0 == wbi) {
          dies = daten.getAkt(nr[3]);
          localLied = dies.getLied();
          localLied.setAktStrophe(1);
          localStrophe = localLied.getStrophe();
          setStrophe(localStrophe, localLied);
          repaint(); 
        } else {
          if (1 != wbi) break;
          dies = daten.getAkt(nr[3]);
          localText = dies.getText();
          localText.setAktText(1);
          localStrophe = localText.getText();
          setText(localStrophe, localText);
          repaint();
        } break;
      default:
          break;
      }
    }
  
    private void refrain()
    {
      d.out("Refrain ausgewählt");
      Lied localLied;
      Strophe localStrophe1;
      Strophe localStrophe2;
      int i;
      if (refrain) {
        refrain = false;
        switch (wf) {
        case 0:
          if (0 != wbi) break;
          localLied = daten.getLied(nr[0]);
          localLied.setAktStrophe(aktStrophe);
          localStrophe1 = localLied.getStrophe();
          localStrophe2 = localStrophe1;
          i = localLied.getAktStrophe();
          setWas(localStrophe2);
          while ((localLied.getAktStrophe() > 1) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
            localStrophe2 = localLied.getVorStrophe();
            setWas(localStrophe2);
          }
          if ((was == 1) || (was == 3) || (was == 5) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (oben)");
          }
          repaint();
          break;
        case 3:
          if (0 != wbi) break;
          dies = daten.getAkt(nr[3]);
          localLied = dies.getLied();
          localLied.setAktStrophe(aktStrophe);
          localStrophe1 = localLied.getStrophe();
          localStrophe2 = localStrophe1;
          i = localLied.getAktStrophe();
          setWas(localStrophe2);
          while ((localLied.getAktStrophe() > 1) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
            localStrophe2 = localLied.getVorStrophe();
            setWas(localStrophe2);
          }
          if ((was == 1) || (was == 3) || (was == 5) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (oben)");
          }
          repaint();
          break;
        default:
          break;
        }
      }
      else
      {
        switch (wf) {
        case 0:
          if (0 != wbi) break;
          localLied = daten.getLied(nr[0]);
          localStrophe1 = localLied.getStrophe();
          i = localLied.getAktStrophe();
          localLied.setAktStrophe(1);
          localStrophe2 = localLied.getStrophe();
          setWas(localStrophe2);
          while ((localLied.getAktStrophe() < localLied.getMaxStrophen()) && (was != 2) && (was != 3) && (was != 6) && (was != 7)) {
            localStrophe2 = localLied.getNextStrophe();
            setWas(localStrophe2);
            d.out("Strophe: " + localLied.getAktStrophe());
          }
          if ((was == 2) || (was == 3) || (was == 6) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
            refrain = true;
            bridge = false;
            aktStrophe = i;
            d.out("Refrain gefunden");
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            refrain = false;
            aktStrophe = 0;
            d.out("alte Daten (Refrain)");
          }
          repaint();
          break;
        case 3:
          if (0 != wbi) break;
          dies = daten.getAkt(nr[3]);
          localLied = dies.getLied();
  
          localStrophe1 = localLied.getStrophe();
          i = localLied.getAktStrophe();
          localLied.setAktStrophe(1);
          localStrophe2 = localLied.getStrophe();
          setWas(localStrophe2);
          while ((localLied.getAktStrophe() < localLied.getMaxStrophen()) && (was != 2) && (was != 3) && (was != 6) && (was != 7)) {
            localStrophe2 = localLied.getNextStrophe();
            setWas(localStrophe2);
          }
          if ((was == 2) || (was == 3) || (was == 6) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
            refrain = true;
            bridge = false;
            aktStrophe = i;
            d.out("Refrain gefunden");
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            refrain = false;
            aktStrophe = 0;
            d.out("alte Daten (Refrain)");
          }
          repaint();
          break;
        }
      }
    }
  
    private void bridge()
    {
      d.out("Bridge ausgewählt");
      Lied localLied;
      Strophe localStrophe1;
      Strophe localStrophe2;
      int i;
      if (bridge) {
        bridge = false;
        switch (wf) {
        case 0:
          if (0 != wbi) break;
          localLied = daten.getLied(nr[0]);
          localLied.setAktStrophe(aktStrophe);
          localStrophe1 = localLied.getStrophe();
          localStrophe2 = localStrophe1;
          i = localLied.getAktStrophe();
          setWas(localStrophe2);
          while ((localLied.getAktStrophe() > 1) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
            localStrophe2 = localLied.getVorStrophe();
            setWas(localStrophe2);
          }
          if ((was == 1) || (was == 3) || (was == 5) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (oben)");
          }
          repaint();
          break;
        case 3:
          if (0 != wbi) break;
          dies = daten.getAkt(nr[3]);
          localLied = dies.getLied();
          localLied.setAktStrophe(aktStrophe);
          localStrophe1 = localLied.getStrophe();
          localStrophe2 = localStrophe1;
          i = localLied.getAktStrophe();
          setWas(localStrophe2);
          while ((localLied.getAktStrophe() > 1) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
            localStrophe2 = localLied.getVorStrophe();
            setWas(localStrophe2);
          }
          if ((was == 1) || (was == 3) || (was == 5) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (oben)");
          }
          repaint();
          break;
        default:
          break;
        }
      }
      else
      {
        switch (wf) {
        case 0:
          if (0 != wbi) break;
          localLied = daten.getLied(nr[0]);
          localStrophe1 = localLied.getStrophe();
          i = localLied.getAktStrophe();
          localLied.setAktStrophe(1);
          localStrophe2 = localLied.getStrophe();
          setWas(localStrophe2);
          while ((localLied.getAktStrophe() < localLied.getMaxStrophen()) && (was != 4) && (was != 5) && (was != 6) && (was != 7)) {
            localStrophe2 = localLied.getNextStrophe();
            setWas(localStrophe2);
            d.out("Strophe: " + localLied.getAktStrophe());
          }
          if ((was == 4) || (was == 5) || (was == 6) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
            bridge = true;
            refrain = false;
            aktStrophe = i;
            d.out("Bridge gefunden");
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            bridge = false;
            aktStrophe = 0;
            d.out("alte Daten (Bridge)");
          }
          repaint();
          break;
        case 3:
          if (0 != wbi) break;
          dies = daten.getAkt(nr[3]);
          localLied = dies.getLied();
  
          localStrophe1 = localLied.getStrophe();
          i = localLied.getAktStrophe();
          localLied.setAktStrophe(1);
          localStrophe2 = localLied.getStrophe();
          setWas(localStrophe2);
          while ((localLied.getAktStrophe() < localLied.getMaxStrophen()) && (was != 4) && (was != 5) && (was != 6) && (was != 7)) {
            localStrophe2 = localLied.getNextStrophe();
            setWas(localStrophe2);
          }
          if ((was == 4) || (was == 5) || (was == 6) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
            bridge = true;
            refrain = false;
            aktStrophe = i;
            d.out("Bridge gefunden");
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            bridge = false;
            aktStrophe = 0;
            d.out("alte Daten (Bridge)");
          }
          repaint();
          break;
        }
      }
    }
  
    private void down()
    {
      Lied localLied;
      Strophe localStrophe1;
      Strophe localStrophe2;
      int i;
      if (refrain) {
        refrain = false;
        switch (wf) {
        case 0:
          if (0 != wbi) break;
          localLied = daten.getLied(nr[0]);
          localLied.setAktStrophe(aktStrophe);
          localStrophe1 = localLied.getStrophe();
          localStrophe2 = localStrophe1;
          i = localLied.getAktStrophe();
          was = 0;
          while ((localLied.getAktStrophe() < localLied.getMaxStrophen()) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
            localStrophe2 = localLied.getNextStrophe();
            setWas(localStrophe2);
          }
          if ((was == 1) || (was == 3) || (was == 5) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (unten)");
          }
          repaint();
          break;
        case 3:
          if (0 != wbi) break;
          dies = daten.getAkt(nr[3]);
          localLied = dies.getLied();
          localLied.setAktStrophe(aktStrophe);
          localStrophe1 = localLied.getStrophe();
          localStrophe2 = localStrophe1;
          i = localLied.getAktStrophe();
          was = 0;
          while ((localLied.getAktStrophe() < localLied.getMaxStrophen()) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
            localStrophe2 = localLied.getNextStrophe();
            setWas(localStrophe2);
          }
          if ((was == 1) || (was == 3) || (was == 5) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (unten)");
          }
          repaint();
          break;
        default:
          break;
        }
      }
      else
      {
        switch (wf) {
        case 0:
          if (0 != wbi) break;
          localLied = daten.getLied(nr[0]);
          localStrophe1 = localLied.getStrophe();
          localStrophe2 = localStrophe1;
          i = localLied.getAktStrophe();
          was = 0;
          while ((localLied.getAktStrophe() < localLied.getMaxStrophen()) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
            localStrophe2 = localLied.getNextStrophe();
            setWas(localStrophe2);
          }
          if ((was == 1) || (was == 3) || (was == 5) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (unten)");
          }
          repaint();
          break;
        case 3:
          if (0 != wbi) break;
          dies = daten.getAkt(nr[3]);
          localLied = dies.getLied();
  
          localStrophe1 = localLied.getStrophe();
          localStrophe2 = localStrophe1;
          i = localLied.getAktStrophe();
          was = 0;
          while ((localLied.getAktStrophe() < localLied.getMaxStrophen()) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
            localStrophe2 = localLied.getNextStrophe();
            setWas(localStrophe2);
          }
          if ((was == 1) || (was == 3) || (was == 5) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (unten)");
          }
          repaint();
          break;
        }
      }
    }
  
    private void up()
    {
      Lied localLied;
      Strophe localStrophe1;
      Strophe localStrophe2;
      if (refrain)
      {
        boolean bool = false;
        int j = 0;
        refrain = false;
        int k;
        switch (wf) {
        case 0:
          if (0 != wbi) break;
          localLied = daten.getLied(nr[0]);
          localLied.setAktStrophe(aktStrophe);
          localStrophe1 = localLied.getStrophe();
          localStrophe2 = localStrophe1;
          k = localLied.getAktStrophe();
          setWas(localStrophe2);
          j = was;
          if ((j != 1) && (j != 3) && (j != 5) && (j != 7)) bool = true;
          d.out("Nochmal: " + bool);
          was = 0;
          while ((localLied.getAktStrophe() > 1) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
            localStrophe2 = localLied.getVorStrophe();
            setWas(localStrophe2);
          }
  
          if (bool) {
            if ((was == 1) || (was == 3) || (was == 5) || (was == 7))
            {
              k = localLied.getAktStrophe();
              localStrophe1 = localLied.getStrophe();
            } else {
              localLied.setAktStrophe(k);
              setStrophe(localStrophe1, localLied);
              d.out("alte Daten (oben)");
            }
            was = 0;
            while ((localLied.getAktStrophe() > 1) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
              localStrophe2 = localLied.getVorStrophe();
              setWas(localStrophe2);
            }
          }
          if ((was == 1) || (was == 3) || (was == 5) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
          } else {
            localLied.setAktStrophe(k);
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (oben)");
          }
          repaint();
          break;
        case 3:
          if (0 != wbi) break;
          dies = daten.getAkt(nr[3]);
          localLied = dies.getLied();
  
          localLied.setAktStrophe(aktStrophe);
          localStrophe1 = localLied.getStrophe();
          localStrophe2 = localStrophe1;
          k = localLied.getAktStrophe();
          setWas(localStrophe2);
          j = was;
          if ((j != 1) && (j != 3) && (j != 5) && (j != 7)) bool = true;
          d.out("Nochmal: " + bool);
          was = 0;
          while ((localLied.getAktStrophe() > 1) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
            localStrophe2 = localLied.getVorStrophe();
            setWas(localStrophe2);
          }
          if (bool) {
            if ((was == 1) || (was == 3) || (was == 5) || (was == 7))
            {
              k = localLied.getAktStrophe();
              localStrophe1 = localLied.getStrophe();
            } else {
              localLied.setAktStrophe(k);
              setStrophe(localStrophe1, localLied);
              d.out("alte Daten (oben)");
            }
            was = 0;
            while ((localLied.getAktStrophe() > 1) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
              localStrophe2 = localLied.getVorStrophe();
              setWas(localStrophe2);
            }
          }
          if ((was == 1) || (was == 3) || (was == 5) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
          } else {
            localLied.setAktStrophe(k);
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (oben)");
          }
          repaint();
          break;
        }
      }
      else
      {
        int i;
        switch (wf) {
        case 0:
          if (0 != wbi) break;
          localLied = daten.getLied(nr[0]);
          localStrophe1 = localLied.getStrophe();
          localStrophe2 = localStrophe1;
          i = localLied.getAktStrophe();
          was = 0;
          while ((localLied.getAktStrophe() > 1) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
            localStrophe2 = localLied.getVorStrophe();
            setWas(localStrophe2);
          }
          if ((was == 1) || (was == 3) || (was == 5) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (oben)");
          }
          repaint();
          break;
        case 3:
          if (0 != wbi) break;
          dies = daten.getAkt(nr[3]);
          localLied = dies.getLied();
  
          localStrophe1 = localLied.getStrophe();
          localStrophe2 = localStrophe1;
          i = localLied.getAktStrophe();
          was = 0;
          while ((localLied.getAktStrophe() > 1) && (was != 1) && (was != 3) && (was != 5) && (was != 7)) {
            localStrophe2 = localLied.getVorStrophe();
            setWas(localStrophe2);
          }
          if ((was == 1) || (was == 3) || (was == 5) || (was == 7)) {
            setStrophe(localStrophe2, localLied);
          } else {
            localLied.setAktStrophe(i);
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (oben)");
          }
          repaint();
          break;
        }
      }
    }
  
    private void left()
    {
      Lied localLied;
      Strophe localStrophe1;
      Strophe localStrophe2;
      Text localText;
      switch (wf) {
      case 0:
        if (0 != wbi) break;
        localLied = daten.getLied(nr[0]);
        localStrophe1 = localLied.getStrophe();
        if (localLied.getAktStrophe() - 1 > 0) {
          localStrophe2 = localLied.getVorStrophe();
          setStrophe(localStrophe2, localLied);
          if ((was != 2) && (was != 3) && (was != 6) && (was != 7))
            refrain = false;
        } else {
          setStrophe(localStrophe1, localLied);
          d.out("alte Daten (links)");
        }
        repaint(); break;
      case 1:
        if (1 != wbi) break;
        localText = daten.getText(nr[1]);
        localStrophe1 = localText.getText();
        if (localText.getAktText() - 1 > 0) {
          localStrophe2 = localText.getVorText();
          setText(localStrophe2, localText);
          refrain = false;
        } else {
          setText(localStrophe1, localText);
          d.out("alte Daten (links)");
        }
        repaint(); break;
      case 3:
        if (0 == wbi) {
          dies = daten.getAkt(nr[3]);
          localLied = dies.getLied();
  
          localStrophe1 = localLied.getStrophe();
          if (localLied.getAktStrophe() - 1 > 0) {
            localStrophe2 = localLied.getVorStrophe();
            setStrophe(localStrophe2, localLied);
            if ((was != 2) && (was != 3) && (was != 6) && (was != 7))
              refrain = false;
          } else {
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (links)");
          }
          repaint(); } else {
          if (1 != wbi) break;
          dies = daten.getAkt(nr[3]);
          localText = dies.getText();
          localStrophe1 = localText.getText();
          if (localText.getAktText() - 1 > 0) {
            localStrophe2 = localText.getVorText();
            setText(localStrophe2, localText);
            refrain = false;
          } else {
            setText(localStrophe1, localText);
            d.out("alte Daten (links)");
          }
          repaint(); } break;
      case 2:
      }
    }
  
    private void right()
    {
      Lied localLied;
      Strophe localStrophe1;
      Strophe localStrophe2;
      Text localText;
      switch (wf) {
      case 0:
        if (0 != wbi) break;
        localLied = daten.getLied(nr[0]);
        localStrophe1 = localLied.getStrophe();
        if (localLied.getAktStrophe() + 1 <= localLied.getMaxStrophen()) {
          localStrophe2 = localLied.getNextStrophe();
          setStrophe(localStrophe2, localLied);
          if ((was != 2) && (was != 3) && (was != 6) && (was != 7))
            refrain = false;
        } else {
          setStrophe(localStrophe1, localLied);
          d.out("alte Daten (rechts)");
        }
        repaint(); break;
      case 1:
        if (1 != wbi) break;
        localText = daten.getText(nr[1]);
        localStrophe1 = localText.getText();
        if (localText.getAktText() + 1 <= localText.getMaxText()) {
          localStrophe2 = localText.getNextText();
          setText(localStrophe2, localText);
          refrain = false;
        } else {
          setText(localStrophe1, localText);
          d.out("alte Daten (rechts)");
        }
        repaint(); break;
      case 3:
        if (0 == wbi) {
          dies = daten.getAkt(nr[3]);
          localLied = dies.getLied();
  
          localStrophe1 = localLied.getStrophe();
          if (localLied.getAktStrophe() + 1 <= localLied.getMaxStrophen()) {
            localStrophe2 = localLied.getNextStrophe();
            setStrophe(localStrophe2, localLied);
            if ((was != 2) && (was != 3) && (was != 6) && (was != 7))
              refrain = false;
          } else {
            setStrophe(localStrophe1, localLied);
            d.out("alte Daten (rechts)");
          }
          repaint(); } else {
          if (1 != wbi) break;
          dies = daten.getAkt(nr[3]);
          localText = dies.getText();
          localStrophe1 = localText.getText();
          if (localText.getAktText() + 1 <= localText.getMaxText()) {
            localStrophe2 = localText.getNextText();
            setText(localStrophe2, localText);
            refrain = false;
          } else {
            setText(localStrophe1, localText);
            d.out("alte Daten (rechts)");
          }
          repaint(); } break;
      case 2:
      }
    }
  
    private void hoch()
    {
      refrain = false;
      maxFontSchon = false;
      switch (wf) {
      case 3:
        if (nr[3] > 0)
          nr[3] -= 1;
        akt();
        break;
      case 0:
        if (nr[0] > 0)
          nr[0] -= 1;
        lied();
        break;
      case 1:
        if (nr[1] > 0)
          nr[1] -= 1;
        text();
        break;
      case 2:
        if (nr[2] > 0)
          nr[2] -= 1;
        bild();
      }
    }
  
    private void runter()
    {
      refrain = false;
      maxFontSchon = false;
      switch (wf) {
      case 3:
        if (nr[3] + 1 < max[3])
          nr[3] += 1;
        akt();
        break;
      case 0:
        if (nr[0] + 1 < max[0])
          nr[0] += 1;
        lied();
        break;
      case 1:
        if (nr[1] + 1 < max[1])
          nr[1] += 1;
        text();
        break;
      case 2:
        if (nr[2] + 1 < max[2])
          nr[2] += 1;
        bild();
      }
    }
  
    private void anfang()
    {
      refrain = false;
      maxFontSchon = false;
      switch (wf) {
      case 3:
        nr[3] = 0;
        akt();
        break;
      case 0:
        nr[0] = 0;
        lied();
        break;
      case 1:
        nr[1] = 0;
        text();
        break;
      case 2:
        nr[2] = 0;
        bild();
      }
    }
  
    private void akt()
    {
      refrain = false;
      if (max[3] != 0) {
        dies = daten.getAkt(nr[3]);
        wf = 3;
        maxFontSchon = false;
        Strophe localStrophe;
        switch (dies.getTyp()) {
        case 0:
          wbi = 0;
          was = 0;
  
          Lied localLied = dies.getLied();
          if (null == localLied) break;
          localLied.setAuswahl();
          localStrophe = localLied.getStrophe();
          setStrophe(localStrophe, localLied); break;
        case 1:
          wbi = 1;
          was = 0;
  
          Text localText = dies.getText();
          if (null == localText) break;
          localText.setAuswahl();
          localStrophe = localText.getText();
          setText(localStrophe, localText); break;
        case 2:
          wbi = BILD;
          was = NORMAL;
  
          Bild localBild = dies.getBild();
          if (null == localBild) break;
          setBild(localBild);
/*
 
          leinwand = new BufferedImage(x, y, 1);
          g = leinwand.createGraphics();
          if (options.getBildVorrang())
            bildE = options.getBildEinstellungen();
          else
            bildE = localBild.getBildEinstellungen();
          g.setColor(bildE.getBildH());
          g.fillRect(0, 0, x, y);
          int i = bildE.getPosition();
          int j = localBild.getSize().height;
          int k = localBild.getSize().width;
          double d2 = (double)k / (double)j;
          double d1 = (double)j / (double)k;
          int m = 0;
          int n = 0;
          if (bildE.getOriginal()) {
            switch (i) {
            case 0:
              n = 0;
              m = (x - k) / 2;
              break;
            case 1:
              m = 0;
              n = (y - j) / 2;
              break;
            case 2:
              m = (x - k) / 2;
              n = (y - j) / 2;
              break;
            case 3:
              m = x - k;
              n = (y - j) / 2;
              break;
            case 4:
              m = (x - k) / 2;
              n = y - j;
            }
          }
          else {
            if (bildE.getRahmen()) {
              d.out("Seitenverhältnis beibehalten");
              if (bildE.getScreensize()) {
                d.out("Bildschirmgröße");
                if (j > k) {
                  j = y;
                  k = (int)(y / d1);
                } else {
                  k = x;
                  j = (int)(x / d2);
                }
                d.out("Bildgröße: " + k + " " + j);
              } else {
                d.out("Keine Bildschirmgröße");
                if (j > k) {
                  j = bildE.getPixelY();
                  k = (int)(bildE.getPixelY() / d1);
                } else {
                  k = bildE.getPixelX();
                  j = (int)(bildE.getPixelX() / d2);
                }
                d.out("Bildgröße: " + k + " " + j);
              }
            } else {
              d.out("Kein Seitenverhältnis");
              if (bildE.getScreensize()) {
                d.out("Bildschirmgröße");
                j = y;
                k = x;
                d.out("Bildgröße: " + k + " " + j);
              } else {
                d.out("keine Bildschirmgröße");
                k = bildE.getPixelX();
                j = bildE.getPixelY();
                d.out("Bildgröße: " + k + " " + j);
              }
            }
            switch (i) {
            case 0:
              n = 0;
              m = (x - k) / 2;
              break;
            case 1:
              m = 0;
              n = (y - j) / 2;
              break;
            case 2:
              m = (x - k) / 2;
              n = (y - j) / 2;
              break;
            case 3:
              m = x - k;
              n = (y - j) / 2;
              break;
            case 4:
              m = (x - k) / 2;
              n = y - j;
            }
          }
  
          g.drawImage(localBild.getBild(), m, n, k, j, zeichnen);
          zeichnen.maleBild(leinwand);
          schwarz = false;
          logo = false;
          hgb_only = false;
          * 
          * 
    */
            
        } // case
          
        repaint();
      }
    }
  
    private void nextakt()
    {
      refrain = false;
      if (max[3] != 0)
        if (nr[3] + 1 < max[3]) {
          nr[3] += 1;
          dies = daten.getAkt(nr[3]);
          wf = 3;
          maxFontSchon = false;
          Strophe localStrophe;
          switch (dies.getTyp()) {
          case 0:
            wbi = 0;
            was = 0;
  
            Lied localLied = dies.getLied();
            if (null == localLied) break;
            localLied.setAuswahl();
            localStrophe = localLied.getStrophe();
            setWas(localStrophe);
            setStrophe(localStrophe, localLied); break;
          case 1:
            wbi = 1;
            was = 0;
  
            Text localText = dies.getText();
            if (null == localText) break;
            localText.setAuswahl();
            localStrophe = localText.getText();
            setWas(localStrophe);
            setText(localStrophe, localText); break;
          case 2:
            wbi = 2;
            was = 0;
  
            Bild localBild = dies.getBild();
            if (null == localBild) break;
            leinwand = new BufferedImage(x, y, 1);
            g = leinwand.createGraphics();
            if (options.getBildVorrang())
              bildE = options.getBildEinstellungen();
            else
              bildE = localBild.getBildEinstellungen();
            g.setColor(bildE.getBildH());
            g.fillRect(0, 0, x, y);
            int i = bildE.getPosition();
            int j = localBild.getSize().height;
            int k = localBild.getSize().width;
            double d2 = (double) k / (double)j;
            double d1 = (double)j / (double)k;
            int m = 0;
            int n = 0;
            if (bildE.getOriginal()) {
              switch (i) {
              case 0:
                n = 0;
                m = (x - k) / 2;
                break;
              case 1:
                m = 0;
                n = (y - j) / 2;
                break;
              case 2:
                m = (x - k) / 2;
                n = (y - j) / 2;
                break;
              case 3:
                m = x - k;
                n = (y - j) / 2;
                break;
              case 4:
                m = (x - k) / 2;
                n = y - j;
              }
            }
            else {
              if (bildE.getRahmen()) {
                d.out("Seitenverhältnis beibehalten");
                if (bildE.getScreensize()) {
                  d.out("Bildschirmgröße");
                  if (j > k) {
                    j = y;
                    k = (int)(y / d1);
                  } else {
                    k = x;
                    j = (int)(x / d2);
                  }
                  d.out("Bildgröße: " + k + " " + j);
                } else {
                  d.out("Keine Bildschirmgröße");
                  if (j > k) {
                    j = bildE.getPixelY();
                    k = (int)(bildE.getPixelY() / d1);
                  } else {
                    k = bildE.getPixelX();
                    j = (int)(bildE.getPixelX() / d2);
                  }
                  d.out("Bildgröße: " + k + " " + j);
                }
              } else {
                d.out("Kein Seitenverhältnis");
                if (bildE.getScreensize()) {
                  d.out("Bildschirmgröße");
                  j = y;
                  k = x;
                  d.out("Bildgröße: " + k + " " + j);
                } else {
                  d.out("keine Bildschirmgröße");
                  k = bildE.getPixelX();
                  j = bildE.getPixelY();
                  d.out("Bildgröße: " + k + " " + j);
                }
              }
              switch (i) {
              case 0:
                n = 0;
                m = (x - k) / 2;
                break;
              case 1:
                m = 0;
                n = (y - j) / 2;
                break;
              case 2:
                m = (x - k) / 2;
                n = (y - j) / 2;
                break;
              case 3:
                m = x - k;
                n = (y - j) / 2;
                break;
              case 4:
                m = (x - k) / 2;
                n = y - j;
              }
            }
  
            g.drawImage(localBild.getBild(), m, n, k, j, zeichnen);
            zeichnen.maleBild(leinwand);
            ohneNT = leinwand;
            schwarz = false;
            logo = false;
            hgb_only = false;
          }
  
          repaint();
        } else {
          akt();
        }
    }
  
    private void text()
    {
      refrain = false;
      if (max[1] != 0) {
        dies = new Aktuell(daten.getText(nr[1]));
        wf = 1;
        wbi = 1;
        was = 0;
  
        Text localText = dies.getText();
        if (null != localText) {
          maxFontSchon = false;
          localText.setAuswahl();
          Strophe localStrophe = localText.getText();
          setWas(localStrophe);
          setText(localStrophe, localText);
        }
  
        repaint();
      }
    }
  
    private void nexttext()
    {
      refrain = false;
      if (max[1] != 0)
        if (nr[1] + 1 < max[1]) {
          nr[1] += 1;
          dies = new Aktuell(daten.getText(nr[1]));
          wf = 1;
          wbi = 1;
          was = 0;
  
          Text localText = dies.getText();
          if (null != localText) {
            maxFontSchon = false;
            localText.setAuswahl();
            Strophe localStrophe = localText.getText();
            setWas(localStrophe);
            setText(localStrophe, localText);
          }
  
          repaint();
        } else {
          text();
        }
    }
  
    private void lied()
    {
      refrain = false;
      if (max[0] != 0) {
        dies = new Aktuell(daten.getLied(nr[0]));
        wf = 0;
        wbi = 0;
        was = 0;
  
        Lied localLied = dies.getLied();
        if (null != localLied) {
          maxFontSchon = false;
          localLied.setAuswahl();
          Strophe localStrophe = localLied.getStrophe();
          setWas(localStrophe);
          setStrophe(localStrophe, localLied);
        }
  
        repaint();
      }
    }
  
    private void nextlied()
    {
      refrain = false;
      if (max[0] != 0)
        if (nr[0] + 1 < max[0]) {
          nr[0] += 1;
          dies = new Aktuell(daten.getLied(nr[0]));
          wf = 0;
          wbi = 0;
          was = 0;
  
          Lied localLied = dies.getLied();
          if (null != localLied) {
            maxFontSchon = false;
            localLied.setAuswahl();
            Strophe localStrophe = localLied.getStrophe();
            setWas(localStrophe);
            setStrophe(localStrophe, localLied);
          }
  
          repaint();
        } else {
          lied();
        }
    }
  
    private void bild()
    {
       if (max[BILD] != 0)
       {
        dies = new Aktuell(daten.getBild(nr[BILD]));
        wf = BILD;
        wbi = BILD;
        was = NORMAL;
       
        setBild(dies.getBild());  
       }
    }
    
    private void nextbild()
    {
         
      if (max[BILD] != 0) 
        if (nr[BILD] + 1 < max[BILD])
        {
          maxFontSchon = false;
          nr[BILD]++; 
          dies = new Aktuell(daten.getBild(nr[BILD]));
          wf = BILD;
          wbi = BILD;
          was = NORMAL;
          
          setBild(dies.getBild());
        }
    }
  
    private void setBild(Bild pBild)
    {
      refrain = false;
      if (null != pBild) {
          if (options.getBildVorrang())
            bildE = options.getBildEinstellungen();
          else
            bildE = pBild.getBildEinstellungen();
          maxFontSchon = false;
          leinwand = new BufferedImage(x, y, 1);
          g = leinwand.createGraphics();
          g.setColor(bildE.getBildH());
          g.fillRect(0, 0, x, y);
          int pos = bildE.getPosition();
          int iImageHeight = pBild.getSize().height;
          int iImageWidth = pBild.getSize().width;
          d.out("Originalbildgröße: " + iImageWidth + " " + iImageHeight);
          d.out("Bildschirmgröße: " + x + " " + y);
          double yy = (double)iImageWidth / (double)iImageHeight;
          double xx = (double)iImageHeight / (double)iImageWidth;
          d.out("Verhältnis yy: " + yy);
          d.out("Verhältnis xx: " + xx);
          int iPosX = 0;
          int iPosY = 0;
          
          if (bildE.getOriginal()) {
           d.out("Originalbildgröße");
          }
          else if (bildE.getRahmen()) {
              d.out("Seitenverhältnis beibehalten");
              int iSizeY =y;
              int iSizeX =x;
              
              // Keine Bildschirmgröße - extra Werte
              if (!bildE.getScreensize())
              {
                 iSizeY= bildE.getPixelY();
                 iSizeX= bildE.getPixelX();
              }
              // Die absolute größte Abweichung muss korrigiert werden               
              int diffHeigth = Math.abs(iSizeY - iImageHeight);
              int diffWidth  = Math.abs(iSizeX - iImageWidth);
               
              if (diffHeigth < diffWidth)
              {
                  iImageHeight = iSizeY;
                  iImageWidth = (int) ((double)iSizeY / xx);
              }
              else
              {
                  iImageWidth = iSizeX;
                  iImageHeight = (int)((double)iSizeX / yy);
              }
              d.out("Bildgröße: " + iImageWidth + " " + iImageHeight);
             
         }
         else {
           d.out("Kein Seitenverhältnis");
           if (bildE.getScreensize()) {
                d.out("Bildschirmgröße");
                iImageHeight = y;
                iImageWidth = x;
                d.out("Bildgröße: " + iImageWidth + " " + iImageHeight);
              } else {
                d.out("keine Bildschirmgröße");
                iImageWidth = bildE.getPixelX();
                iImageHeight = bildE.getPixelY();
                d.out("Bildgröße: " + iImageWidth + " " + iImageHeight);
              }
          }
          
          switch (pos) {
            case 0:
              iPosY = 0;
              iPosX = (x - iImageWidth) / 2;
              break;
            case 1:
              iPosX = 0;
              iPosY = (y - iImageHeight) / 2;
              break;
            case 2:
              iPosX = (x - iImageWidth) / 2;
              iPosY = (y - iImageHeight) / 2;
              break;
            case 3:
              iPosX = x - iImageWidth;
              iPosY = (y - iImageHeight) / 2;
              break;
            case 4:
              iPosX = (x - iImageWidth) / 2;
              iPosY = y - iImageHeight;
              break;
          }
          
  
          g.drawImage(pBild.getBild(), iPosX, iPosY, iImageWidth, iImageHeight, zeichnen);
          zeichnen.maleBild(leinwand);
          ohneNT = leinwand;
          schwarz = false;
          logo = false;
          hgb_only = false;
        }
        repaint();
      }
 
    /*
    private void disnextBild()
    {
      refrain = false;
      if (max[2] != 0)
        if (nr[2] + 1 < max[2]) {
          maxFontSchon = false;
          nr[2] += 1;
          dies = new Aktuell(daten.getBild(nr[2]));
          wf = 2;
          wbi = 2;
          was = 0;
  
          Bild localBild = dies.getBild();
          if (null != localBild) {
            if (options.getBildVorrang())
              bildE = options.getBildEinstellungen();
            else
              bildE = localBild.getBildEinstellungen();
            leinwand = new BufferedImage(x, y, 1);
            g = leinwand.createGraphics();
            g.setColor(bildE.getBildH());
            g.fillRect(0, 0, x, y);
            int i = bildE.getPosition();
            int m = localBild.getSize().height;
            int n = localBild.getSize().width;
            double d2 = (double)n / (double)m;
            double d1 =(double) m / (double)n;
            int j = 0;
            int k = 0;
            if (bildE.getOriginal()) {
              switch (i) {
              case 0:
                k = 0;
                j = (x - n) / 2;
                break;
              case 1:
                j = 0;
                k = (y - m) / 2;
                break;
              case 2:
                j = (x - n) / 2;
                k = (y - m) / 2;
                break;
              case 3:
                j = x - n;
                k = (y - m) / 2;
                break;
              case 4:
                j = (x - n) / 2;
                k = y - m;
              }
            }
            else {
              if (bildE.getRahmen()) {
                d.out("Seitenverhältnis beibehalten");
                if (bildE.getScreensize()) {
                  d.out("Bildschirmgröße");
                  if (m > n) {
                    m = y;
                    n = (int)(y / d1);
                  } else {
                    n = x;
                    m = (int)(x / d2);
                  }
                  d.out("Bildgröße: " + n + " " + m);
                } else {
                  d.out("Keine Bildschirmgröße");
                  if (m > n) {
                    m = bildE.getPixelY();
                    n = (int)(bildE.getPixelY() / d1);
                  } else {
                    n = bildE.getPixelX();
                    m = (int)(bildE.getPixelX() / d2);
                  }
                  d.out("Bildgröße: " + n + " " + m);
                }
              } else {
                d.out("Kein Seitenverhältnis");
                if (bildE.getScreensize()) {
                  d.out("Bildschirmgröße");
                  m = y;
                  n = x;
                  d.out("Bildgröße: " + n + " " + m);
                } else {
                  d.out("keine Bildschirmgröße");
                  n = bildE.getPixelX();
                  m = bildE.getPixelY();
                  d.out("Bildgröße: " + n + " " + m);
                }
              }
              switch (i) {
              case 0:
                k = 0;
                j = (x - n) / 2;
                break;
              case 1:
                j = 0;
                k = (y - m) / 2;
                break;
              case 2:
                j = (x - n) / 2;
                k = (y - m) / 2;
                break;
              case 3:
                j = x - n;
                k = (y - m) / 2;
                break;
              case 4:
                j = (x - n) / 2;
                k = y - m;
              }
            }
  
            g.drawImage(localBild.getBild(), j, k, n, m, zeichnen);
            zeichnen.maleBild(leinwand);
            ohneNT = leinwand;
            schwarz = false;
            logo = false;
            hgb_only = false;
          }
          repaint();
        } else {
          bild();
        }
    }
*/
    
    private void hgBildOnly()
    {
      Color localColor;
      if (wf == 0)
        localColor = liedE.getTextH();
      else
        localColor = textE.getTextH();
      hgbleinwand = new BufferedImage(x, y, 1);
      g = hgbleinwand.createGraphics();
      g.setColor(localColor);
      g.fillRect(0, 0, x, y);
      HGBild_zeichnen(g);
      zeichnen.maleBild(hgbleinwand);
      ohneNT = leinwand;
      hgb_only = true;
    }
  
    private void HGBild_zeichnen(Graphics2D paramGraphics2D)
    {
      d.out("Hintergrundbild wird ");
  
      if (hgBild) {
        d.out("gezeichnet");
        dies = new Aktuell(daten.getHGBild(hgbBild));
  
        Bild localBild = dies.getBild();
        if (null != localBild) {
          if (options.getBildVorrang())
            bildE = options.getBildEinstellungen();
          else
            bildE = localBild.getBildEinstellungen();
          maxFontSchon = false;
  
          int i = bildE.getPosition();
          int m = localBild.getSize().height;
          int n = localBild.getSize().width;
          d.out("Originalbildgröße: " + n + " " + m);
          d.out("Bildschirmgröße: " + x + " " + y);
          double d2 = (double) n / (double) m;
          double d1 = (double) m / (double) n;
          d.out("Verhältnis yy: " + d2);
          d.out("Verhältnis xx: " + d1);
          int j = 0;
          int k = 0;
          if (bildE.getOriginal()) {
            switch (i) {
            case 0:
              k = 0;
              j = (x - n) / 2;
              break;
            case 1:
              j = 0;
              k = (y - m) / 2;
              break;
            case 2:
              j = (x - n) / 2;
              k = (y - m) / 2;
              break;
            case 3:
              j = x - n;
              k = (y - m) / 2;
              break;
            case 4:
              j = (x - n) / 2;
              k = y - m;
            }
          }
          else {
            if (bildE.getRahmen()) {
              d.out("Seitenverhältnis beibehalten");
              if (bildE.getScreensize()) {
                d.out("Bildschirmgröße");
                if (m > n) {
                  m = y;
                  n = (int)(y / d1);
                } else {
                  n = x;
                  m = (int)(x / d2);
                }
                d.out("Bildgröße: " + n + " " + m);
              } else {
                d.out("Keine Bildschirmgröße");
                if (m > n) {
                  m = bildE.getPixelY();
                  n = (int)(bildE.getPixelY() / d1);
                } else {
                  n = bildE.getPixelX();
                  m = (int)(bildE.getPixelX() / d2);
                }
                d.out("Bildgröße: " + n + " " + m);
              }
            } else {
              d.out("Kein Seitenverhältnis");
              if (bildE.getScreensize()) {
                d.out("Bildschirmgröße");
                m = y;
                n = x;
                d.out("Bildgröße: " + n + " " + m);
              } else {
                d.out("keine Bildschirmgröße");
                n = bildE.getPixelX();
                m = bildE.getPixelY();
                d.out("Bildgröße: " + n + " " + m);
              }
            }
            switch (i) {
            case 0:
              k = 0;
              j = (x - n) / 2;
              break;
            case 1:
              j = 0;
              k = (y - m) / 2;
              break;
            case 2:
              j = (x - n) / 2;
              k = (y - m) / 2;
              break;
            case 3:
              j = x - n;
              k = (y - m) / 2;
              break;
            case 4:
              j = (x - n) / 2;
              k = y - m;
            }
          }
  
          paramGraphics2D.drawImage(localBild.getBild(), j, k, n, m, zeichnen);
          zeichnen.maleBild(leinwand);
          ohneNT = leinwand;
        }
      }
    }
  
    public void taste(KeyEvent paramKeyEvent)
    {
      int i = paramKeyEvent.getModifiers();
      int j = paramKeyEvent.getKeyChar();
      int k = paramKeyEvent.getKeyCode();
      Object localObject = paramKeyEvent.getSource();
  
      if (k != 0)
      {
        if (k == 10)
        {
          OK();
        }
        else if (k == 27) {
          close();
        } else if (k == 40) {
          down();
        } else if (k == 38) {
          up();
        } else if (k == 37) {
          left();
        } else if (k == 39) {
          right();
        } else if (k == 32) {
          if (schwarz) {
            zeichnen.maleBild(leinwand);
  
            schwarz = false;
          } else {
            zeichnen.setSchwarz();
            schwarz = true;
            logo = false;
            hgb_only = false;
          }
          repaint();
        } else if (k == 112) {
          akt();
        } else if (k == 113) {
          lied();
        } else if (k == 114) {
          text();
        } else if (k == 115) {
          bild();
        } else if (k == 116) {
          nextakt();
        } else if (k == 117) {
          nextlied();
        } else if (k == 118) {
          nexttext();
        } else if (k == 119) {
          nextbild();
        } else if (k == 120)
        {
          d.out("F9");
          if (nt) {
            ntt = new NewstickerThread(l, this, daten, 0, debug);
            nt = false;
            ntt.start();
          } else {
            nt = true;
            ntt.close();
          }
        } else if (k == 122)
        {
          d.out("F11");
          if (nt) {
            ntt = new NewstickerThread(l, this, daten, 1, debug);
            nt = false;
            ntt.start();
          } else {
            nt = true;
            ntt.close();
          }
        } else if (k == 123)
        {
          d.out("F12");
          if (nt) {
            ntt = new NewstickerThread(l, this, daten, 2, debug);
            nt = false;
            ntt.start();
          } else {
            nt = true;
            ntt.close();
          }
        } else if (k == 16) {
          if (logo) {
            d.out("Kein Logo mehr");
            zeichnen.maleBild(leinwand);
            ohneNT = leinwand;
            logo = false;
          } else if (daten.getLabel(10) >= 0) {
            logo = true;
            schwarz = false;
            hgb_only = false;
            if (null != logoBild)
              zeichnen.maleBild(logoBild);
            else
              d.out("Nullpointer beim logoBild");
            d.out("Logo malen");
          }
          repaint();
        } else if (k == 36) {
          anfang();
        } else if (k == 33) {
          hoch();
        } else if (k == 34) {
          runter();
        } else if (k == 35) {
          refrain();
        } else if (k == 127)
        {
          bridge();
        } else if (k == 155) {
          liedAnfang();
        } else if ((k == 521) || (k == 107)) {
          hgBild();
        } else if (k == 520) {
          nummer(true);
        } else if (k == 514) {
          if (hgb_only) {
            zeichnen.maleBild(leinwand);
            ohneNT = leinwand;
            hgb_only = false;
          } else {
            hgBild = true;
            hgBildOnly();
            hgb_only = true;
          }
          repaint();
        } else if (k == 8) {
          nummer(false);
        } else if ((k == 45) || (k == 109)) {
          buchstaben = true;
        } else if ((k == 49) || (k == 50) || (k == 51) || (k == 52) || (k == 53) || (k == 54) || (k == 55) || (k == 56) || (k == 57) || (k == 48)) {
          nummer(k);
        } else if ((k >= 65) && (k <= 90)) {
          buchstabe(k);
        } else if ((k >= 96) && (k <= 105)) {
          nummer2(k);
        } else {
          d.out("Keycode: " + k);
        }
      }
    }
  
    public void NewstickerEnde(boolean paramBoolean)
    {
      nt = paramBoolean;
      ntt = null;
    }
  
    public boolean NewstickerLauf() {
      return nt;
    }
  
    private void nummer(boolean paramBoolean)
    {
      buchstaben = false;
      if (paramBoolean) {
        d.out("Es ist eine Zahl");
        nummer = 0;
        isNummer = true;
      } else {
        d.out("Es ist ein Label");
        isNummer = false;
      }
    }
  
    private void nummer(int paramInt)
    {
      buchstaben = false;
      if (hgbTaste) {
        hgbZiffer = (paramInt - 48);
        hgbTaste = false;
        hgbBild = daten.gethgBild(hgbZiffer);
      }
      else if (isNummer) {
        nummer = (nummer * 10 + paramInt - 48);
        d.out("Es ist eine Ziffer");
        d.out("Nummer: " + nummer);
      } else {
        d.out("Es ist ein Label!");
        d.out("Labelnr: " + (paramInt - 48));
        int i = daten.getLabel(paramInt - 48);
        if ((i >= 0) && (i < max[3])) {
          nr[3] = i;
          akt();
        }
      }
    }
  
    private void nummer2(int paramInt)
    {
      buchstaben = false;
      if (hgbTaste) {
        hgbZiffer = (paramInt - 96);
        hgbTaste = false;
        hgbBild = daten.gethgBild(hgbZiffer);
      }
      else if (isNummer) {
        nummer = (nummer * 10 + paramInt - 96);
        d.out("Es ist eine Ziffer");
        d.out("Nummer: " + nummer);
      } else {
        d.out("Es ist ein Label!");
        d.out("Labelnr: " + (paramInt - 96));
        int i = daten.getLabel(paramInt - 96);
        if ((i >= 0) && (i < max[3])) {
          nr[3] = i;
          akt();
        }
      }
    }
  
    private void buchstabe(int paramInt)
    {
      hgbTaste = false;
      if (buchstaben) {
        d.out("Buchstabe ist: " + paramInt);
        if ((paramInt >= 65) && (paramInt <= 90)) {
          nr[0] = letter[(paramInt - 65)];
          lied();
        }
      }
    }
  
    private void OK() {
      d.out("Die Returntaste wurde gedrückt!");
      d.out("Die Zusatzzahl: " + nummer);
      buchstaben = false;
      hgbTaste = false;
  
      if ((nummer >= 0) && (nummer < max[0])) {
        nr[0] = nummer;
        lied();
      }
    }
  
    private void hgBild() {
      if (hgBild) {
        hgBild = false;
        hgbTaste = false;
  
        d.out("Hintergrundbild abgeschaltet");
      }
      else {
        d.out("Hintergrundbild eingeschaltet");
        hgBild = true;
        hgbTaste = true;
      }
    }
  
    public void schwarzBlenden() {
      d.out("Schwarzblenden");
      if (!schwarz) {
        d.out("Ja, Schwarz");
        zeichnen.setSchwarz();
        schwarz = true;
        logo = false;
        hgb_only = false;
        repaint();
      }
    }
  
    public void maleNewsticker(NewstickerBildschirm paramNewstickerBildschirm, Newsticker paramNewsticker) {
      int i = 0;
      int j = x;
      int k = 0;
  
      int n = 0;
      int i1 = 0;
  
      boolean bool1 = false;
      boolean bool3 = false;
      int i3 = 0;
      int i4 = 50;
  
      boolean bool2 = paramNewsticker.CDisEnabled();
      bool3 = paramNewsticker.TickerisEnabled();
      int m = paramNewsticker.getSpeed();
      i1 = 10000 / ((m + 1) * 10);
      long l1 = paramNewsticker.getCountdown() + 1000L;
      i4 = paramNewsticker.getMilli();
      bool1 = paramNewsticker.isUhrzeit();
      long l2 = paramNewsticker.getEndzeit();
  
      jetztzeit = System.currentTimeMillis();
      long l3 = jetztzeit - weiterzeit;
      weiterzeit = System.currentTimeMillis();
      int i9 = 0;
      String str1 = "";
      String str2 = "";
      String str3 = "";
      String str4 = "";
  
      i3 = x;
  
      String str5 = Newsticker.fontNamen[paramNewsticker.getFont()];
      String str6 = Newsticker.fontNamen[paramNewsticker.getCDFont()];
      d.out("Fontnamen: " + str5 + "-" + str6);
      int i10 = 0;
      int i11 = paramNewsticker.getSize();
      d.out("org. Fontstring, fontBold, fontSize: " + str5 + " " + i10 + " " + i11);
      Font localFont1 = new Font(str5, i10, i11);
  
      Font localFont2 = new Font(str6, i10, i11);
      FontMetrics localFontMetrics1 = getFontMetrics(localFont1);
      FontMetrics localFontMetrics2 = getFontMetrics(localFont2);
      int i2 = localFontMetrics1.getHeight();
      int i5 = localFontMetrics1.getMaxAscent();
      int i6 = localFontMetrics1.getMaxDescent();
      i = localFontMetrics1.stringWidth(paramNewsticker.getText());
  
      k = -1 * i;
  
      BufferedImage localBufferedImage = new BufferedImage(i3, i2, 1);
      g = ohneNT.createGraphics();
      g.drawImage(ohneNT, 0, 0, x, y, zeichnen);
  
      if (bool3)
      {
        g.setFont(localFont1);
        wo -= (int)(NewstickerBildschirm.f(m) * l3 / i4);
  
        if (wo < k) wo = j;
        g.setColor(paramNewsticker.getHinterFarbe());
        g.fillRect(0, 0, i3, i2);
        g.setColor(paramNewsticker.getTextFarbe());
        g.drawString(paramNewsticker.getText(), wo, i2 - i6);
  
        if (wo < k + x) {
          g.drawString(paramNewsticker.getText(), wo + i, i2 - i6);
        }
      }
      if (bool2)
      {
        long l4 = startzeit + l1 - jetztzeit;
        if (bool1)
          l4 = l2 - jetztzeit;
        if (l4 < 1000L) {
          paramNewstickerBildschirm.close();
          paramNewstickerBildschirm.ende();
        }
        int i7 = (int)l4 / 3600000;
        int i8 = (int)(l4 - i7 * 3600000) / 60000;
        i9 = (int)(l4 - i7 * 3600000 - i8 * 60000) / 1000;
        if (i9 < 10) str2 = "0" + i9; else str2 = "" + i9;
        if (i8 < 10) str3 = "0" + i8; else str3 = "" + i8;
        str4 = "" + i7;
        if (i7 > 0) str1 = str4 + ":" + str3 + ":" + str2; else str1 = str3 + ":" + str2;
        g.setFont(localFont2);
        int i12 = localFontMetrics2.stringWidth(str1);
        int i13 = 0;
        int i14 = 0;
        if (bool3) {
          switch (paramNewsticker.getPosition()) { case 0:
            i13 = 0; break;
          case 1:
            i13 = x - i12; break;
          case 2:
            i13 = 0; break;
          case 3:
            i13 = x - i12; break;
          case 4:
            i13 = 0; break;
          case 5:
            i13 = x - i12;
          }
          g.setColor(paramNewsticker.getHinterFarbe());
          g.fillRect(i13, 0, i13 + i12, i2 + i6);
          g.setColor(paramNewsticker.getTextFarbe());
          g.drawString(str1, i13, i2 - i6);
        }
        else {
          switch (paramNewsticker.getPosition()) { case 0:
            i14 = 0; i13 = 0; break;
          case 4:
            i14 = y - (i2 + i6); i13 = 0; break;
          case 2:
          case 3:
            i13 = (x - i12) / 2; i14 = (y - (i2 + i6)) / 2; break;
          case 1:
            i14 = 0; i13 = x - i12; break;
          case 5:
            i14 = y - (i2 + i6); i13 = x - i12;
          }
          g.setColor(paramNewsticker.getHinterFarbe());
          g.fillRect(0, 0, i13 + i12, i2 + i6);
          g.setColor(paramNewsticker.getTextFarbe());
          g.drawString(str1, 0, i2 - i6);
        }
  
      }
  
      repaint();
    }
  }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     Bildschirm
 * JD-Core Version:    0.6.0
 */