        import java.awt.Color;
        import java.awt.Container;
        import java.awt.Dimension;
        import java.awt.Graphics;
        import java.awt.Graphics2D;
        import java.awt.GraphicsDevice;
        import java.awt.GraphicsEnvironment;
        import java.awt.MediaTracker;
        import java.awt.Toolkit;
        import java.awt.event.ActionEvent;
        import java.awt.event.KeyEvent;
        import java.awt.image.BufferedImage;
        import java.awt.image.ImageObserver;
        import java.io.File;
        import java.io.IOException;
        import java.io.PrintStream;
        import javax.imageio.ImageIO;
        import javax.swing.JDialog;
        import javax.swing.JOptionPane;
        
        public class DiaShow extends JDialog
        {
          public static final long serialVersionUID = 1L;
          private LoBeT l;
          private Daten daten;
          private Debug d = new Debug(true);
          private Einstellungen options;
          private BildEinstellungen diaE;
          private File[] dateien;
          private int wo = 0;
          private int max;
          private ImageObserver io;
          private Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
          private SchirmBild sb = new SchirmBild(screen.width, screen.height, io);
          private Bild b;
          private DiaThread diat;
          private boolean pause = true;
          private boolean weiter = true;
          private boolean auto = true;
          private boolean nt = true;
          private NewstickerDiaThread ntt;
          private boolean schwarz = false;
        
          private byte[] mem = new byte[5000000];
        
          private boolean neu = false;
          private Container content;
          private Graphics comp2d;
          private BufferedImage leinwand;
          private BufferedImage bild;
          private BildschirmZeichnen zeichnen;
          private int x = screen.width; private int y = screen.height;
        
          private void datenUbertragen() {
            options = daten.getEinstellungen();
            diaE = options.getDiaEinstellungen();
          }
        
          public DiaShow(DiaThread paramDiaThread, LoBeT paramLoBeT, Daten paramDaten, boolean paramBoolean, File[] paramArrayOfFile) {
            super(paramLoBeT, "LoBeT-DiaShow", true);
            l = paramLoBeT;
            daten = paramDaten;
            dateien = paramArrayOfFile;
            diat = paramDiaThread;
            paramDiaThread.ich(this);
            paramDiaThread.start();
            datenUbertragen();
            max = paramArrayOfFile.length;
        
            d = new Debug(paramBoolean);
            create();
            bild();
            setVisible(true);
          }
        
          public void create()
          {
            addKeyListener(new DiaShowTastenAdapter(this));
            Dimension localDimension = Toolkit.getDefaultToolkit().getScreenSize();
            setSize(localDimension);
            setUndecorated(true);
            zeichnen = new BildschirmZeichnen(localDimension.width, localDimension.height, l);
            GraphicsDevice localGraphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        
            setResizable(false);
        
            content = getContentPane();
        
            content.add(zeichnen);
            setBackground(new Color(0, 0, 0));
            leinwand = new BufferedImage(x, y, 1);
            Graphics2D localGraphics2D = leinwand.createGraphics();
            localGraphics2D.setColor(new Color(0, 0, 0));
            localGraphics2D.fillRect(0, 0, x, y);
        
            setDefaultCloseOperation(0);
          }
        
          public void close() {
            weiter = false;
            pause = false;
            if (null != ntt) ntt.close();
            if (null != diat)
              diat.ende();
            zeichnen.close();
            leinwand.flush();
            if (null != bild)
              bild.flush();
            setVisible(false);
            dispose();
          }
        
          public void action(ActionEvent paramActionEvent)
          {
          }
        
          private void OK()
          {
            close();
          }
        
          public boolean getNew() {
            return neu;
          }
        
          private boolean veraendert() {
            neu = true;
            return neu;
          }
        
          private void hoch() {
            if (wo > 0) {
              pause = true;
              auto = false;
              wo -= 1;
              bild();
            }
          }
        
          private void runter() {
            if (wo + 1 < max) {
              pause = true;
              auto = false;
              wo += 1;
              bild();
            }
          }
        
          private void anfang() {
            pause = true;
            auto = false;
            wo = 0;
            bild();
          }
        
          private void ende() {
            pause = true;
            auto = false;
            wo = (max - 1);
            bild();
          }
        
          private void bild()
          {
            d.out("Es geht los...");
            File localFile = dateien[wo];
            if (localFile.exists()) {
              d.out("Datei existiert");
              try {
                MediaTracker localMediaTracker = new MediaTracker(this);
        
                BufferedImage localBufferedImage = ImageIO.read(localFile);
        
                localMediaTracker.addImage(localBufferedImage, 1);
                try {
                  localMediaTracker.waitForID(1);
                } catch (InterruptedException localInterruptedException) {
                  System.err.println("Fehler während des Ladens eines Bildes.");
                  System.err.println("Bild " + localFile.getName() + " wird übersprungen");
                  localInterruptedException.printStackTrace();
                  nextBild();
                }
                if (null != localBufferedImage)
                {
                  d.out("Bild tatsächlich vorhanden");
                  sb.delBild();
                  sb.setBild(localBufferedImage);
                  b = new Bild();
                  b.setBild(localBufferedImage);
                  leinwand = new BufferedImage(x, y, 1);
                  Graphics2D localGraphics2D = leinwand.createGraphics();
                  localGraphics2D.setColor(diaE.getBildH());
                  localGraphics2D.fillRect(0, 0, x, y);
                  int i = diaE.getPosition();
                  int m = b.getSize().height;
                  int n = b.getSize().width;
                  d.out("Originalbildgröße: " + n + " " + m);
                  d.out("Bildschirmgröße: " + x + " " + y);
                  double d2 = (double)n / (double)m;
                  double d1 = (double)m / (double)n;
                  d.out("Verhältnis yy: " + d2);
                  d.out("Verhältnis xx: " + d1);
                  int j = 0;
                  int k = 0;
                  if (diaE.getOriginal()) {
                    switch (i) {
                    case 0:
                      k = 0;
                      j = (x - n) / 2;
                      break;
                    case 1:
                      j = 0;
                      k = (y - m) / 2;
                      break;
                    case 2:
                      j = (x - n) / 2;
                      k = (y - m) / 2;
                      break;
                    case 3:
                      j = x - n;
                      k = (y - m) / 2;
                      break;
                    case 4:
                      j = (x - n) / 2;
                      k = y - m;
                    }
                  }
                  else {
                    if (diaE.getRahmen()) {
                      d.out("Seitenverhältnis beibehalten");
                      if (diaE.getScreensize()) {
                        d.out("Bildschirmgröße");
                        if (m > n) {
                          m = y;
                          n = (int)(y / d1);
                        } else {
                          n = x;
                          m = (int)(x / d2);
                        }
                        d.out("Bildgröße: " + n + " " + m);
                      } else {
                        d.out("Keine Bildschirmgröße");
                        if (m > n) {
                          m = diaE.getPixelY();
                          n = (int)(diaE.getPixelY() / d1);
                        } else {
                          n = diaE.getPixelX();
                          m = (int)(diaE.getPixelX() / d2);
                        }
                        d.out("Bildgröße: " + n + " " + m);
                      }
                    } else {
                      d.out("Kein Seitenverhältnis");
                      if (diaE.getScreensize()) {
                        d.out("Bildschirmgröße");
                        m = y;
                        n = x;
                        d.out("Bildgröße: " + n + " " + m);
                      } else {
                        d.out("keine Bildschirmgröße");
                        n = diaE.getPixelX();
                        m = diaE.getPixelY();
                        d.out("Bildgröße: " + n + " " + m);
                      }
                    }
                    switch (i) {
                    case 0:
                      k = 0;
                      j = (x - n) / 2;
                      break;
                    case 1:
                      j = 0;
                      k = (y - m) / 2;
                      break;
                    case 2:
                      j = (x - n) / 2;
                      k = (y - m) / 2;
                      break;
                    case 3:
                      j = x - n;
                      k = (y - m) / 2;
                      break;
                    case 4:
                      j = (x - n) / 2;
                      k = y - m;
                    }
                  }
        
                  localGraphics2D.drawImage(localBufferedImage, j, k, n, m, zeichnen);
                  if (auto) {
                    zeichnen.maleBild(leinwand);
        
                    schwarz = false;
                  }
                } else {
                  d.out("Bild ist null!");
                  nextBild();
                }
              } catch (IOException localIOException) {
                System.err.println("IO-Exception\nEs trat ein Fehler während des Schreibens der Datei (" + localFile.getAbsolutePath() + ") auf.");
                localIOException.printStackTrace();
                int i1 = JOptionPane.showConfirmDialog(this, "Während des Schreibens der Datei\n" + localFile.getAbsolutePath() + "\n trat ein Fehler auf.", "Fehler beim Schreiben der Datei:", -1, 0, null);
              }
              catch (OutOfMemoryError localOutOfMemoryError)
              {
                mem = null;
                System.gc();
                System.err.println("java.lang.OutOfMemoryError...");
                System.err.println("... abgefangen ...");
                System.err.println("Diashow wird abgebrochen ...");
                JOptionPane.showMessageDialog(this, "Das Programm hat zuwenig Speicher. \nDie Diashow wird abgebrochen!", "Out of Memory - Error", 0);
                close();
              }
              repaint();
            } else {
              d.out("Bild existiert nicht!");
            }
            pause = false;
            diat.pausenklingel();
          }
        
          public void nextBild() {
            pause = true;
            if (auto) {
              d.out("Dia: next Bild");
              if (wo + 1 < max) {
                wo += 1;
                bild();
              }
              else if (options.getEndlos()) {
                wo = 0;
                bild();
              }
              else {
                close();
              }
            }
          }
        
          public void taste(KeyEvent paramKeyEvent)
          {
            int i = paramKeyEvent.getModifiers();
            int j = paramKeyEvent.getKeyChar();
            int k = paramKeyEvent.getKeyCode();
            Object localObject = paramKeyEvent.getSource();
        
            if (k != 0)
            {
              if (k == 10)
              {
                auto = true;
                nextBild();
              } else if (k == 27) {
                close();
              } else if (k == 40) {
                runter();
              } else if (k == 38) {
                hoch();
              } else if (k == 37) {
                hoch();
              } else if (k == 39) {
                runter();
              } else if (k == 32) {
                if (schwarz) {
                  zeichnen.maleBild(leinwand);
                  schwarz = false;
                  pause = false;
                } else {
                  zeichnen.setSchwarz();
                  schwarz = true;
                  pause = true;
                  auto = false;
                }
                repaint();
              } else if (k == 36) {
                anfang();
              } else if (k != 127)
              {
                if (k == 33) {
                  hoch();
                } else if (k == 34) {
                  runter();
                } else if (k == 35) {
                  ende();
                } else if (k == 120)
                {
                  d.out("F9");
                  if (nt) {
                    ntt = new NewstickerDiaThread(l, this, daten, 0, true);
                    nt = false;
                    ntt.start();
                  } else {
                    nt = true;
                    ntt.close();
                  }
                } else if (k == 122)
                {
                  d.out("F11");
                  if (nt) {
                    ntt = new NewstickerDiaThread(l, this, daten, 1, true);
                    nt = false;
                    ntt.start();
                  } else {
                    nt = true;
                    ntt.close();
                  }
                } else if (k == 123)
                {
                  d.out("F12");
                  if (nt) {
                    ntt = new NewstickerDiaThread(l, this, daten, 2, false);
                    nt = false;
                    ntt.start();
                  } else {
                    nt = true;
                    ntt.close();
                  }
                }
              }
            }
          }
        
          public boolean weiter()
          {
            return weiter;
          }
        
          public boolean pause() {
            return pause;
          }
        
          public void NewstickerEnde(boolean paramBoolean) {
            nt = paramBoolean;
            ntt = null;
          }
        
          public boolean NewstickerLauf() {
            return nt;
          }
        
          public void schwarzBlenden() {
            d.out("Schwarzblenden");
            if (!schwarz) {
              d.out("Ja, Schwarz");
              zeichnen.setSchwarz();
              schwarz = true;
        
              pause = true;
              auto = false;
              repaint();
            }
          }
        }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     DiaShow
 * JD-Core Version:    0.6.0
 */