/*     */ import java.io.BufferedWriter;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.FileWriter;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class HTML
/*     */ {
/*  14 */   private Debug d = new Debug(false);
/*  15 */   private boolean debug = false;
/*     */   private Daten daten;
/*     */   private ProgressBarNeu pbn;
/*     */   private File file;
/*  19 */   private String titel = "Liederliste";
/*  20 */   private final String VERSION = Start.showVersion();
/*  21 */   private final String[] buchstaben = { "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "z", "zz" };
/*     */   private String path;
/*     */   private String name;
/*     */   private Lied lied;
/*     */   private Vector liedVector;
/*     */   public static final int LIED = 0;
/*     */   private static final int maxSchirm = 5;
/*     */   private static final int maxZeile = 24;
/*  33 */   private int liedNr = 0;
/*     */   private FileOutputStream fos;
/*     */   private ObjectOutputStream oos;
/*     */   private FileInputStream fis;
/*     */   private ObjectInputStream ois;
/*     */   private BufferedWriter bw;
/*     */   private int[] statInt;
/*     */   private String[] statString;
/*     */   private int[] org;
/*     */   private long[] statLong;
/*     */   private int liedVectorSize;
/*  47 */   private String style = "style.css";
/*  48 */   private boolean styles = true;
/*  49 */   private boolean kommies = true;
/*     */   private long jetzt;
/*     */   private long wann;
/*  53 */   private boolean abWann = false;
/*  54 */   private String wannText = "";
/*  55 */   private boolean aufsteigend = true;
/*     */ 
/*  62 */   String dateiInhalt = "";
/*     */ 
/*     */   public HTML(Daten paramDaten, ProgressBarNeu paramProgressBarNeu, File paramFile, boolean paramBoolean) throws IOException
/*     */   {
/*  66 */     this.d = new Debug(paramBoolean);
/*  67 */     this.daten = paramDaten;
/*  68 */     this.style = paramDaten.getEinstellungen().getStyle();
/*  69 */     this.styles = paramDaten.getEinstellungen().getIfStyle();
/*  70 */     this.kommies = paramDaten.getEinstellungen().getKommentare();
/*  71 */     this.pbn = paramProgressBarNeu;
/*  72 */     this.file = paramFile;
/*  73 */     this.debug = paramBoolean;
/*  74 */     this.jetzt = System.currentTimeMillis();
/*  75 */     this.abWann = paramDaten.getEinstellungen().getEndStats();
/*  76 */     long l = paramDaten.getEinstellungen().getEndStatsInt();
/*  77 */     switch (paramDaten.getEinstellungen().getEndStatsTyp()) {
/*     */     case 0:
/*  79 */       this.wann = (this.jetzt - (l + 1L) * 1000L * 60L * 60L * 24L);
/*  80 */       this.wannText = ("Die Statistik der letzten " + (l + 1L) + " Tage");
/*  81 */       if (l != 0L) break;
/*  82 */       this.wannText = "Die Statistik des letzten Tages"; break;
/*     */     case 1:
/*  85 */       this.wann = (this.jetzt - (l + 1L) * 1000L * 60L * 60L * 24L * 7L);
/*  86 */       this.wannText = ("Die Statistik der letzten " + (l + 1L) + " Wochen");
/*  87 */       if (l != 0L) break;
/*  88 */       this.wannText = "Die Statistik der letzten Woche"; break;
/*     */     case 2:
/*  91 */       this.wann = (this.jetzt - (l + 1L) * 1000L * 60L * 60L * 24L * 30L);
/*  92 */       this.wannText = ("Die Statistik der letzten " + (l + 1L) + " Monate");
/*  93 */       if (l != 0L) break;
/*  94 */       this.wannText = "Die Statistik des letzten Monats"; break;
/*     */     default:
/*  96 */       this.wann = this.jetzt;
/*  97 */       this.wannText = "";
/*     */     }
/*     */ 
/* 100 */     liste();
/*     */ 
/* 102 */     this.aufsteigend = paramDaten.getEinstellungen().getAufsteigend();
/* 103 */     this.path = paramFile.getPath();
/* 104 */     this.name = paramFile.getName();
/* 105 */     pfadFinden();
/* 106 */     lieder();
/* 107 */     statistiken();
/*     */   }
/*     */ 
/*     */   private void liste() throws IOException {
/* 111 */     this.liedVector = this.daten.getVector(0);
/* 112 */     this.liedVectorSize = this.liedVector.size();
/* 113 */     this.pbn.setMax(4 * this.liedVectorSize + 1);
/* 114 */     this.pbn.progress(0, "HTML Liste generieren");
/* 115 */     this.pbn.setIndeterminate(false);
/* 116 */     this.d.out("Datei (" + this.file.getName() + ") öffnen");
/* 117 */     FileWriter localFileWriter = new FileWriter(this.file);
/* 118 */     this.bw = new BufferedWriter(localFileWriter);
/* 119 */     this.d.out("Lieder schreiben");
/*     */ 
/* 146 */     vorspann(this.titel);
/* 147 */     this.bw.write("  <div class=\"Menu\">");
/* 148 */     this.bw.newLine();
/* 149 */     this.bw.write("   <P>");
/* 150 */     this.bw.newLine();
/* 151 */     this.bw.write("    <A href=\"#A\">A</A> <A href=\"#B\">B</A> <A href=\"#C\">C</A> <A href=\"#D\">D</A> <A href=\"#E\">E</A> <A href=\"#F\">F</A> <A href=\"#G\">G</A> <A href=\"#H\">H</A> <A href=\"#I\">I</A> <A href=\"#J\">J</A> <A href=\"#K\">K</A> <A href=\"#L\">L</A> <A href=\"#M\">M</A> <A href=\"#N\">N</A> <A href=\"#O\">O</A> <A href=\"#P\">P</A> <A href=\"#Q\">Q</A> <A href=\"#R\">R</A> <A href=\"#S\">S</A> <A href=\"#T\">T</A> <A href=\"#U\">U</A> <A href=\"#V\">V</A> <A href=\"#W\">W</A> <A href=\"#X\">X</A> <A href=\"#Y\">Y</A> <A href=\"#Z\">Z</A>");
/* 152 */     this.bw.newLine();
/* 153 */     this.bw.write("   </P>");
/* 154 */     this.bw.newLine();
/* 155 */     this.bw.write("   <P>");
/* 156 */     this.bw.newLine();
/* 157 */     this.bw.write("    <A href=\"Statistiken.html\">Statistiken</A>");
/* 158 */     this.bw.newLine();
/* 159 */     this.bw.write("   </P>");
/* 160 */     this.bw.newLine();
/* 161 */     this.bw.write("  </div><hr>");
/* 162 */     this.bw.newLine();
/* 163 */     this.bw.write("  <div class=\"Listen\">");
/* 164 */     this.bw.newLine();
/* 165 */     liederListen();
/* 166 */     this.bw.write("  </div>");
/* 167 */     this.bw.newLine();
/*     */ 
/* 179 */     abspann();
/* 180 */     this.bw.flush();
/* 181 */     localFileWriter.close();
/*     */   }
/*     */ 
/*     */   private void liederListen() throws IOException {
/* 185 */     int i = 0;
/*     */ 
/* 187 */     this.liedVector = this.daten.getVector(0);
/* 188 */     for (int k = 0; k < 26; k++) {
/* 189 */       this.bw.write("<A name=\"" + this.buchstaben[k] + "\"><H2>" + this.buchstaben[k] + "</H2></A>");
/* 190 */       this.bw.newLine();
/* 191 */       this.bw.write("<ul>");
/* 192 */       this.bw.newLine();
/* 193 */       this.lied = this.daten.getLied(i);
/* 194 */       int j = 0;
/*     */       String str;
/*     */       int m;
/* 195 */       if (this.lied.getKopie()) {
/* 196 */         str = this.lied.getOriginal();
/* 197 */         m = 0;
/* 198 */         while ((m == 0) && (j < this.liedVectorSize)) {
/* 199 */           if (str.equals(this.daten.getLied(j).getTitel())) {
/* 200 */             m = 1; continue;
/*     */           }
/* 202 */           j++;
/* 203 */         }this.lied = this.daten.getLied(i);
/*     */       }
/* 205 */       if (null != this.lied)
/*     */       {
/* 209 */         while ((this.lied.getTitel().compareTo(this.buchstaben[(k + 1)]) <= 0) && (i < this.liedVectorSize))
/*     */         {
/* 211 */           this.pbn.progress();
/* 212 */           if (this.lied.getKopie())
/* 213 */             this.bw.write("<LI><A href=" + i + ".html>" + this.lied.getTitel() + "</A> <A href=\"" + j + ".html\">(Original:  " + this.lied.getOriginal() + ")</A></LI>");
/*     */           else
/* 215 */             this.bw.write("<LI><A href=" + i + ".html>" + this.lied.getTitel() + "</A></LI>");
/* 216 */           this.bw.newLine();
/* 217 */           i++; if (i < this.liedVector.size()) {
/* 218 */             this.lied = this.daten.getLied(i);
/* 219 */             j = 0;
/* 220 */             if (this.lied.getKopie()) {
/* 221 */               str = this.lied.getOriginal();
/* 222 */               m = 0;
/* 223 */               while ((m == 0) && (j < this.liedVectorSize)) {
/* 224 */                 if (str.equals(this.daten.getLied(j).getTitel())) {
/* 225 */                   m = 1; continue;
/*     */                 }
/* 227 */                 j++;
/* 228 */               }this.lied = this.daten.getLied(i);
/*     */             }
/*     */           }
/*     */         }
/* 232 */         this.bw.write("<br><A href=\"#Anfang\">Seitenanfang</A>");
/* 233 */         this.bw.newLine();
/*     */       }
/* 235 */       this.bw.write("</ul>");
/* 236 */       this.bw.newLine();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void lieder()
/*     */     throws IOException
/*     */   {
/* 243 */     int i1 = 0;
/* 244 */     int i2 = 0;
/* 245 */     int i3 = 0;
/*     */ 
/* 248 */     this.pbn.progress("Lieder generieren");
/* 249 */     this.pbn.setIndeterminate(false);
/* 250 */     this.d.out("Lieder schreiben");
/*     */ 
/* 252 */     for (int i = 0; i < this.liedVectorSize; i++) {
/* 253 */       this.pbn.progress();
/* 254 */       File localFile = new File(this.path + i + ".html");
/* 255 */       this.d.out("Datei (" + localFile.getName() + ") schreiben");
/* 256 */       FileWriter localFileWriter = new FileWriter(localFile);
/* 257 */       this.bw = new BufferedWriter(localFileWriter);
/* 258 */       this.lied = this.daten.getLied(i);
/* 259 */       int n = 0;
/* 260 */       if (this.lied.getKopie()) {
/* 261 */         String str = this.lied.getOriginal();
/* 262 */         int i4 = 0;
/* 263 */         while ((i4 == 0) && (n < this.liedVectorSize)) {
/* 264 */           if (str.equals(this.daten.getLied(n).getTitel())) {
/* 265 */             i4 = 1; continue;
/*     */           }
/* 267 */           n++;
/* 268 */         }this.lied = this.daten.getLied(i);
/*     */       }
/* 270 */       if (null != this.lied) {
/* 271 */         vorspann(this.lied.getTitel());
/* 272 */         this.bw.write("<div class=\"inhalt\">");
/* 273 */         this.bw.newLine();
/* 274 */         if (i > 0) {
/* 275 */           this.bw.write(" <A href=\"" + (i - 1) + ".html\">&lt;</A> ");
/* 276 */           this.bw.newLine();
/*     */         }
/* 278 */         this.bw.write(" <A href=\"" + this.name + "\">Inhaltsverzeichnis</A>");
/* 279 */         this.bw.newLine();
/* 280 */         if (i < this.liedVectorSize - 1) {
/* 281 */           this.bw.write(" <A href=\"" + (i + 1) + ".html\">&gt;</A>");
/* 282 */           this.bw.newLine();
/*     */         }
/* 284 */         this.bw.write("</div>");
/* 285 */         this.bw.newLine();
/* 286 */         this.bw.write("<hr>");
/* 287 */         this.bw.newLine();
/* 288 */         if (this.lied.getKopie()) {
/* 289 */           this.bw.write("<P class=\"original\">Original: <A href=\"" + n + ".html\">" + this.lied.getOriginal() + "</A></P>");
/* 290 */           this.bw.newLine();
/*     */         }
/* 292 */         this.bw.write("<div class=\"content\">");
/* 293 */         this.bw.write("<div class=\"lieder\">");
/* 294 */         this.bw.newLine();
/* 295 */         this.lied.setAuswahl();
/* 296 */         Strophe localStrophe = this.lied.getStrophe();
/* 297 */         i2 = 0;
/* 298 */         i3 = 0;
/* 299 */         for (int j = 1; j <= this.lied.getMaxStrophen(); j++) {
/* 300 */           this.bw.write("<P class=\"textseite\">"); this.bw.newLine();
/* 301 */           int m = 0;
/* 302 */           if (localStrophe.getRefrain()) {
/* 303 */             if (i2 != 0)
/* 304 */               this.bw.write("<div class=\"refrainText\">");
/*     */             else
/* 306 */               this.bw.write("<div class=\"refrainText\"><div class=\"refrain\">Refrain:</div><br>");
/* 307 */             m++;
/* 308 */             i2 = 1;
/* 309 */             this.bw.newLine();
/*     */           }
/* 311 */           if (localStrophe.getAnfang()) {
/* 312 */             this.bw.write("<div class=\"stropheText\"><div class=\"strophe\">Strophe:</div><br>");
/* 313 */             m++;
/* 314 */             this.bw.newLine();
/*     */           }
/* 316 */           if (localStrophe.getBridge()) {
/* 317 */             if (i3 != 0)
/* 318 */               this.bw.write("<div class=\"bridgeText\">");
/*     */             else
/* 320 */               this.bw.write("<div class=\"bridgeText\"><div class=\"bridge\">Brücke:</div><br>");
/* 321 */             m++;
/* 322 */             this.bw.newLine();
/* 323 */             i3 = 1;
/*     */           }
/* 325 */           for (int k = 0; k < 24; k++) {
/* 326 */             if ((!localStrophe.get(k).equals("")) && (!localStrophe.get(k).equals(" "))) {
/* 327 */               if (localStrophe.get(k).charAt(0) == '#')
/* 328 */                 this.bw.write("<span class=\"translation\">" + localStrophe.get(k).substring(1) + "</span><br>");
/* 329 */               else if (localStrophe.get(k).charAt(0) == '*')
/* 330 */                 this.bw.write("<span class=\"akkord\">" + localStrophe.get(k).substring(1) + "</span><br>");
/*     */               else
/* 332 */                 this.bw.write(" " + localStrophe.get(k) + "<br>");
/* 333 */               this.bw.newLine();
/*     */             }
/*     */           }
/* 336 */           for (int k = 0; k < m; k++)
/* 337 */             this.bw.write("</div>");
/* 338 */           localStrophe = this.lied.getNextStrophe();
/*     */ 
/* 340 */           this.bw.newLine();
/*     */         }
/* 342 */         this.bw.write("</div>");
/* 343 */         this.bw.write("<div class=\"rechte\"><P class=\"rechte\">");
/* 344 */         Kommentar localKommentar = this.lied.getKommentar();
/* 345 */         i1 = 0;
/* 346 */         if ((!localKommentar.getTexter().getName().equals("")) || (!localKommentar.getTexter().getVorname().equals(""))) {
/* 347 */           this.bw.write("Text: " + localKommentar.getTexter().getVorname() + " " + localKommentar.getTexter().getName());
/* 348 */           this.bw.newLine();
/* 349 */           this.bw.write("<br>");
/* 350 */           this.bw.newLine();
/* 351 */           i1 = 1;
/*     */         }
/* 353 */         if ((!localKommentar.getLiedmacher().getName().equals("")) || (!localKommentar.getLiedmacher().getVorname().equals(""))) {
/* 354 */           this.bw.write("Melodie: " + localKommentar.getLiedmacher().getVorname() + " " + localKommentar.getLiedmacher().getName());
/* 355 */           this.bw.newLine();
/* 356 */           this.bw.write("<br>");
/* 357 */           this.bw.newLine();
/* 358 */           i1 = 1;
/*     */         }
/* 360 */         if ((!localKommentar.getTranslater().getName().equals("")) || (!localKommentar.getTranslater().getVorname().equals(""))) {
/* 361 */           this.bw.write("Übersetzung: " + localKommentar.getTranslater().getVorname() + " " + localKommentar.getTranslater().getName());
/* 362 */           this.bw.newLine();
/* 363 */           this.bw.write("<br>");
/* 364 */           this.bw.newLine();
/* 365 */           i1 = 1;
/*     */         }
/* 367 */         if (localKommentar.getJahr() != 0) {
/* 368 */           this.bw.write("Copyright: " + localKommentar.getJahr());
/* 369 */           this.bw.newLine();
/* 370 */           this.bw.write("<br>");
/* 371 */           this.bw.newLine();
/* 372 */           i1 = 1;
/*     */         }
/* 374 */         if (!localKommentar.getVerlag().equals("")) {
/* 375 */           this.bw.write("Verlag: " + localKommentar.getVerlag());
/* 376 */           this.bw.newLine();
/* 377 */           this.bw.write("<br>");
/* 378 */           this.bw.newLine();
/* 379 */           i1 = 1;
/*     */         }
/* 381 */         if ((this.kommies) && (!localKommentar.getSonstiges().equals(""))) {
/* 382 */           if (i1 != 0)
/* 383 */             this.bw.write("<br>");
/* 384 */           this.bw.write("Kommentar: " + localKommentar.getSonstiges());
/* 385 */           this.bw.newLine();
/* 386 */           this.bw.write("<br>");
/* 387 */           this.bw.newLine();
/* 388 */           i1 = 1;
/*     */         }
/* 390 */         if (i1 != 0)
/* 391 */           this.bw.write("<br>");
/* 392 */         this.bw.newLine();
/* 393 */         this.bw.write("</P></div></div>");
/* 394 */         abspann();
/*     */       }
/* 396 */       this.bw.flush();
/* 397 */       localFileWriter.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void vorspann(String paramString) throws IOException
/*     */   {
/* 403 */     this.bw.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"   \"http://www.w3.org/TR/html4/strict.dtd\">");
/* 404 */     this.bw.newLine();
/* 405 */     this.bw.write("<HTML lang=\"de\">");
/* 406 */     this.bw.newLine();
/* 407 */     this.bw.write(" <HEAD>");
/* 408 */     this.bw.newLine();
/*     */ 
/* 410 */     this.bw.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf8\">");
/* 411 */     this.bw.newLine();
/* 412 */     this.bw.write("  <TITLE>" + paramString + "</TITLE>");
/* 413 */     this.bw.newLine();
/* 414 */     if (this.styles) {
/* 415 */       this.bw.write("  <link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.style + "\">");
/* 416 */       this.bw.newLine();
/*     */     }
/* 418 */     this.bw.write(" </HEAD>");
/* 419 */     this.bw.newLine();
/* 420 */     this.bw.write(" <BODY>");
/* 421 */     this.bw.newLine();
/* 422 */     this.bw.write("  <div class=\"Titel\">");
/* 423 */     this.bw.newLine();
/* 424 */     this.bw.write("   <H1><A name=\"Anfang\">" + paramString + "</A></H1>");
/* 425 */     this.bw.newLine();
/* 426 */     this.bw.write("  </div>");
/* 427 */     this.bw.newLine();
/*     */   }
/*     */ 
/*     */   private void abspann() throws IOException {
/* 431 */     this.bw.write("  <div class=\"LoBeT\">");
/* 432 */     this.bw.newLine();
/* 433 */     this.bw.write("   <HR><P>Diese Seiten wurden erstellt mit dem <A href=\"http://www.sebamueller.de/LoBeT.html\">Lobpreis Beamer Texter</A> in der " + this.VERSION + "</P>");
/* 434 */     this.bw.newLine();
/* 435 */     this.bw.write("  </div>");
/* 436 */     this.bw.newLine();
/* 437 */     this.bw.write(" </BODY>");
/* 438 */     this.bw.newLine();
/* 439 */     this.bw.write("</HTML>");
/* 440 */     this.bw.newLine();
/*     */   }
/*     */ 
/*     */   private void pfadFinden() {
/* 444 */     int i = this.path.lastIndexOf(File.separator);
/* 445 */     if (-1 != i)
/* 446 */       this.path = (this.path.substring(0, i) + File.separator);
/* 447 */     this.d.out("Pfad: " + this.path);
/*     */   }
/*     */ 
/*     */   private void statistiken() throws IOException {
/* 451 */     this.statInt = new int[this.liedVector.size()];
/* 452 */     this.statString = new String[this.liedVector.size()];
/* 453 */     this.org = new int[this.liedVectorSize];
/* 454 */     this.statLong = new long[this.liedVector.size()];
/*     */ 
/* 458 */     this.pbn.progress("Statistiken generieren");
/* 459 */     this.pbn.setIndeterminate(false);
/* 460 */     this.d.out("Statistiken schreiben");
/*     */ 
/* 462 */     File localFile = new File(this.path + "Statistiken.html");
/* 463 */     this.d.out("Datei (" + localFile.getName() + ") schreiben");
/* 464 */     FileWriter localFileWriter = new FileWriter(localFile);
/* 465 */     this.bw = new BufferedWriter(localFileWriter);
/* 466 */     vorspann("Statistiken");
/* 467 */     this.bw.write("  <div class=\"inhalt\"><A href=\"" + this.name + "\">Inhaltsverzeichnis</A></div>");
/* 468 */     this.bw.newLine();
/* 469 */     this.bw.write("  <hr>");
/* 470 */     this.bw.newLine();
/* 471 */     this.bw.write("  <div class=\"statistik\">");
/* 472 */     this.bw.newLine();
/* 473 */     if (this.abWann) {
/* 474 */       this.bw.write("  <P>" + this.wannText + "</P>");
/* 475 */       this.bw.newLine();
/*     */     }
/*     */ 
/* 478 */     for (int i = 0; i < this.liedVectorSize; i++) {
/* 479 */       this.statInt[i] = -1;
/* 480 */       this.statString[i] = "";
/* 481 */       this.org[i] = -1;
/* 482 */       this.statLong[i] = 0L;
/*     */     }
/*     */ 
/* 485 */     int m = 0;
/* 486 */     this.d.out("liedVectorSize: " + this.liedVectorSize);
/* 487 */     for (int i = 0; i < this.liedVectorSize; i++) {
/* 488 */       this.pbn.progress();
/* 489 */       this.lied = this.daten.getLied(i);
/* 490 */       if ((null == this.lied) || 
/* 491 */         (this.lied.getKopie())) continue;
/* 492 */       int j = 0;
/* 493 */       int k = this.lied.getStatistiken();
/* 494 */       this.d.out("" + this.lied.getTimeStatistiken());
/* 495 */       if (this.aufsteigend) {
/* 496 */         while ((j < this.liedVectorSize) && (this.statInt[j] <= k) && (this.statInt[j] != -1))
/* 497 */           j++;
/*     */       }
/* 499 */       while ((j < this.liedVectorSize) && (this.statInt[j] >= k) && (this.statInt[j] != -1)) {
/* 500 */         j++;
/*     */       }
/* 502 */       if (j >= this.liedVectorSize)
/* 503 */         j = this.liedVectorSize - 1;
/* 504 */       if (this.statInt[j] != -1)
/* 505 */         verschieben(j);
/* 506 */       this.statInt[j] = k;
/* 507 */       this.statString[j] = this.lied.getTitel();
/* 508 */       this.statLong[j] = this.lied.getTimeStatistiken();
/* 509 */       this.org[j] = i;
/* 510 */       if (m < k) {
/* 511 */         m = k;
/*     */       }
/*     */     }
/*     */ 
/* 515 */     this.bw.write("   <table>");
/* 516 */     this.bw.newLine();
/*     */ 
/* 518 */     int i = 0;
/* 519 */     this.d.out("Jetzt: " + this.jetzt);
/* 520 */     this.d.out("Wann:  " + this.wann);
/* 521 */     while ((i < this.liedVectorSize) && (this.statInt[i] != -1)) {
/* 522 */       this.pbn.progress();
/*     */ 
/* 524 */       if ((!this.abWann) || ((this.abWann) && (this.statLong[i] > this.wann))) {
/* 525 */         this.bw.write("    <tr>");
/* 526 */         this.bw.newLine();
/* 527 */         this.bw.write("     <td>" + this.statInt[i] + "</td><td><A href=\"" + this.org[i] + ".html\">" + this.statString[i] + "</A></td>");
/* 528 */         this.bw.newLine();
/* 529 */         this.bw.write("    </tr>");
/* 530 */         this.bw.newLine();
/*     */       }
/* 532 */       i++;
/*     */     }
/*     */ 
/* 535 */     this.bw.write("   </table>");
/* 536 */     this.bw.newLine();
/* 537 */     this.bw.write("  </div>");
/* 538 */     this.bw.newLine();
/* 539 */     abspann();
/* 540 */     this.bw.flush();
/* 541 */     localFileWriter.close();
/*     */   }
/*     */ 
/*     */   private void verschieben(int paramInt)
/*     */   {
/* 547 */     for (int i = this.liedVectorSize - 2; i >= paramInt; i--)
/*     */     {
/* 549 */       this.statInt[(i + 1)] = this.statInt[i];
/* 550 */       this.statString[(i + 1)] = this.statString[i];
/* 551 */       this.org[(i + 1)] = this.org[i];
/* 552 */       this.statLong[(i + 1)] = this.statLong[i];
/*     */     }
/*     */   }
/*     */ }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     HTML
 * JD-Core Version:    0.6.0
 */