/*     */ import java.awt.Color;
/*     */ import java.awt.Container;
/*     */ import java.awt.Dimension;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.Toolkit;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.awt.event.KeyEvent;
/*     */ import java.awt.event.MouseEvent;
/*     */ import javax.swing.ButtonGroup;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JCheckBox;
/*     */ import javax.swing.JColorChooser;
/*     */ import javax.swing.JComboBox;
/*     */ import javax.swing.JDialog;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JPanel;
/*     */ import javax.swing.JRadioButton;
/*     */ import javax.swing.JTabbedPane;
/*     */ 
/*     */ public class LiedEinstellungenGUI extends JDialog
/*     */ {
/*     */   public static final long serialVersionUID = 1L;
/*     */   private LoBeT l;
/*     */   private TextEinstellungen e;
/*  11 */   private Debug d = new Debug(true);
/*  12 */   private boolean cancel = false;
/*     */ 
/*  14 */   private boolean neu = false;
/*     */ 
/*  16 */   private JPanel panel = new JPanel();
/*  17 */   private GridBagLayout gridbag = new GridBagLayout();
/*  18 */   private GridBagConstraints constraints = new GridBagConstraints();
/*     */ 
/*  21 */   private JPanel mainPanel = new JPanel();
/*  22 */   private JPanel liedPanel = new JPanel();
/*  23 */   private JTabbedPane textTab = new JTabbedPane();
/*  24 */   private JPanel liedStrophenPanel = new JPanel();
/*  25 */   private JPanel liedRefrainPanel = new JPanel();
/*  26 */   private JPanel liedBridgePanel = new JPanel();
/*  27 */   private JPanel liedUsetzPanel = new JPanel();
/*     */ 
/*  31 */   private JLabel strophenFontLabel = new JLabel("Schriftart: ");
/*  32 */   private JLabel refrainFontLabel = new JLabel("Schriftart: ");
/*  33 */   private JLabel bridgeFontLabel = new JLabel("Schriftart: ");
/*  34 */   private JLabel translateFontLabel = new JLabel("Schriftart: ");
/*     */ 
/*  36 */   private JLabel strophenFontSizeLabel = new JLabel("Schriftgröße: ");
/*  37 */   private JLabel refrainFontSizeLabel = new JLabel("Schriftgröße: ");
/*  38 */   private JLabel bridgeFontSizeLabel = new JLabel("Schriftgröße: ");
/*  39 */   private JLabel translateFontSizeLabel = new JLabel("Schriftgröße um kleiner: ");
/*     */ 
/*  41 */   private JLabel strophenFarbeLabel = new JLabel("Schriftfarbe: ");
/*  42 */   private JLabel refrainFarbeLabel = new JLabel("Schriftfarbe: ");
/*  43 */   private JLabel bridgeFarbeLabel = new JLabel("Schriftfarbe: ");
/*  44 */   private JLabel liedHintergrundLabel = new JLabel("Hintergrundfarbe: ");
/*  45 */   private JLabel translateFarbeLabel = new JLabel("Schriftfarbe: ");
/*     */ 
/*  50 */   private JButton okButton = new JButton("OK");
/*  51 */   private JButton cancelButton = new JButton("Abbrechen");
/*     */ 
/*  53 */   private JButton hgliedButton = new JButton("Farbe wählen");
/*  54 */   private JButton liedFarbeButton = new JButton("Farbe wählen");
/*  55 */   private JButton translateFarbeButton = new JButton("Farbe wählen");
/*  56 */   private JButton schattenLiedButton = new JButton("Farbe wählen");
/*     */   private FarbPunkte liedIcon;
/*     */   private FarbPunkte liedHGIcon;
/*     */   private FarbPunkte transFIcon;
/*     */   private FarbPunkte schattenLIcon;
/*  64 */   private JCheckBox refrainItalic = new JCheckBox("Kursiv");
/*  65 */   private JCheckBox stropheItalic = new JCheckBox("Kursiv");
/*  66 */   private JCheckBox bridgeItalic = new JCheckBox("Kursiv");
/*  67 */   private JCheckBox translateItalic = new JCheckBox("Kursiv");
/*     */ 
/*  69 */   private JCheckBox refrainBold = new JCheckBox("Fett");
/*  70 */   private JCheckBox stropheBold = new JCheckBox("Fett");
/*  71 */   private JCheckBox bridgeBold = new JCheckBox("Fett");
/*  72 */   private JCheckBox translateBold = new JCheckBox("Fett");
/*     */ 
/*  74 */   private JCheckBox liedKleiner = new JCheckBox("Verkleinern");
/*  75 */   private JCheckBox anzeigeCB = new JCheckBox("Anzeigen");
/*     */ 
/*  77 */   private JCheckBox schattenLiedFarbeLabel = new JCheckBox("Rahmenfarbe: ");
/*     */ 
/*  80 */   private JRadioButton liedZeileButton = new JRadioButton("nur Zeile");
/*  81 */   private JRadioButton liedTextButton = new JRadioButton("ganzen Text");
/*     */ 
/*  83 */   private ButtonGroup liedgrp = new ButtonGroup();
/*     */ 
/*  86 */   private JComboBox refrainFont = new JComboBox();
/*  87 */   private JComboBox stropheFont = new JComboBox();
/*  88 */   private JComboBox bridgeFont = new JComboBox();
/*  89 */   private JComboBox translateFont = new JComboBox();
/*     */ 
/*  91 */   private JComboBox refrainFontSize = new JComboBox();
/*  92 */   private JComboBox stropheFontSize = new JComboBox();
/*  93 */   private JComboBox bridgeFontSize = new JComboBox();
/*  94 */   private JComboBox translateFontSize = new JComboBox();
/*     */ 
/*  96 */   private Color[] Farben = new Color[4];
/*     */ 
/*     */   public LiedEinstellungenGUI(LoBeT paramLoBeT, TextEinstellungen paramTextEinstellungen)
/*     */   {
/* 110 */     super(paramLoBeT, "Liedereinstellungen", true);
/* 111 */     this.l = paramLoBeT;
/* 112 */     setDefaultCloseOperation(0);
/* 113 */     Dimension localDimension = Toolkit.getDefaultToolkit().getScreenSize();
/*     */ 
/* 116 */     setLocation(localDimension.width / 2 - 200, localDimension.height / 2 - 100);
/*     */ 
/* 118 */     this.e = paramTextEinstellungen;
/* 119 */     init();
/* 120 */     create();
/* 121 */     getContentPane().add(this.panel);
/* 122 */     setVisible(true);
/*     */   }
/*     */ 
/*     */   private void init()
/*     */   {
/* 129 */     this.Farben[0] = this.e.getTextF();
/* 130 */     this.Farben[1] = this.e.getTextH();
/* 131 */     this.Farben[2] = this.e.getTransF();
/* 132 */     this.Farben[3] = this.e.getRahmenFarbe();
/*     */ 
/* 134 */     this.liedIcon = new FarbPunkte(this.Farben[0]);
/* 135 */     this.liedHGIcon = new FarbPunkte(this.Farben[1]);
/* 136 */     this.transFIcon = new FarbPunkte(this.Farben[2]);
/* 137 */     this.schattenLIcon = new FarbPunkte(this.Farben[3]);
/* 138 */     this.liedFarbeButton.setIcon(this.liedIcon);
/* 139 */     this.hgliedButton.setIcon(this.liedHGIcon);
/* 140 */     this.translateFarbeButton.setIcon(this.transFIcon);
/* 141 */     this.schattenLiedButton.setIcon(this.schattenLIcon);
/*     */ 
/* 143 */     for (int i = 0; i < 6; i++) {
/* 144 */       this.stropheFont.addItem(TextEinstellungen.fontNamen[i]);
/* 145 */       this.refrainFont.addItem(TextEinstellungen.fontNamen[i]);
/* 146 */       this.bridgeFont.addItem(TextEinstellungen.fontNamen[i]);
/* 147 */       this.translateFont.addItem(TextEinstellungen.fontNamen[i]);
/*     */     }
/* 149 */     for (int i = 1; i < 151; i++) {
/* 150 */       this.stropheFontSize.addItem("" + i);
/* 151 */       this.refrainFontSize.addItem("" + i);
/* 152 */       this.bridgeFontSize.addItem("" + i);
/* 153 */       this.translateFontSize.addItem("" + (i - 1));
/*     */     }
/*     */ 
/* 156 */     this.liedZeileButton.setSelected(this.e.getTextZeile());
/* 157 */     this.stropheFont.setSelectedIndex(this.e.getTextFont(1));
/* 158 */     this.refrainFont.setSelectedIndex(this.e.getTextFont(2));
/* 159 */     this.bridgeFont.setSelectedIndex(this.e.getTextFont(3));
/* 160 */     this.translateFont.setSelectedIndex(this.e.getTextFont(4));
/* 161 */     this.stropheFontSize.setSelectedIndex(this.e.getTextSize(1) - 1);
/* 162 */     this.refrainFontSize.setSelectedIndex(this.e.getTextSize(2) - 1);
/* 163 */     this.bridgeFontSize.setSelectedIndex(this.e.getTextSize(3) - 1);
/* 164 */     this.translateFontSize.setSelectedIndex(this.e.getTextSize(4));
/* 165 */     this.stropheBold.setSelected(this.e.getTextBold(1));
/* 166 */     this.refrainBold.setSelected(this.e.getTextBold(2));
/* 167 */     this.bridgeBold.setSelected(this.e.getTextBold(3));
/* 168 */     this.translateBold.setSelected(this.e.getTextBold(4));
/* 169 */     this.stropheItalic.setSelected(this.e.getTextItalic(1));
/* 170 */     this.refrainItalic.setSelected(this.e.getTextItalic(2));
/* 171 */     this.bridgeItalic.setSelected(this.e.getTextItalic(3));
/* 172 */     this.translateItalic.setSelected(this.e.getTextItalic(4));
/* 173 */     this.anzeigeCB.setSelected(this.e.getAnzeige());
/* 174 */     this.schattenLiedFarbeLabel.setSelected(this.e.getRahmen());
/*     */ 
/* 177 */     this.liedKleiner.setSelected(this.e.getTextKleiner());
/* 178 */     this.liedZeileButton.setSelected(this.e.getTextZeile());
/* 179 */     this.liedTextButton.setSelected(!this.e.getTextZeile());
/* 180 */     if (this.liedKleiner.isSelected()) {
/* 181 */       this.liedZeileButton.setEnabled(true);
/* 182 */       this.liedTextButton.setEnabled(true);
/*     */     } else {
/* 184 */       this.liedZeileButton.setEnabled(false);
/* 185 */       this.liedTextButton.setEnabled(false);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void create()
/*     */   {
/* 191 */     this.gridbag = new GridBagLayout();
/* 192 */     this.constraints = new GridBagConstraints();
/*     */ 
/* 195 */     this.mainPanel.setLayout(this.gridbag);
/*     */ 
/* 197 */     this.liedStrophenPanel.setLayout(this.gridbag);
/* 198 */     this.liedRefrainPanel.setLayout(this.gridbag);
/* 199 */     this.liedBridgePanel.setLayout(this.gridbag);
/* 200 */     this.liedUsetzPanel.setLayout(this.gridbag);
/*     */ 
/* 203 */     this.liedPanel.setLayout(this.gridbag);
/*     */ 
/* 207 */     constr(0, 1, 1, 1);
/* 208 */     this.constraints.fill = 1;
/* 209 */     this.gridbag.setConstraints(this.liedHintergrundLabel, this.constraints);
/* 210 */     this.liedPanel.add(this.liedHintergrundLabel);
/*     */ 
/* 212 */     constr(1, 1, 1, 1);
/* 213 */     this.constraints.fill = 1;
/* 214 */     this.gridbag.setConstraints(this.hgliedButton, this.constraints);
/* 215 */     this.liedPanel.add(this.hgliedButton);
/*     */ 
/* 218 */     constr(0, 2, 1, 1);
/* 219 */     this.constraints.fill = 1;
/* 220 */     this.gridbag.setConstraints(this.strophenFarbeLabel, this.constraints);
/* 221 */     this.liedPanel.add(this.strophenFarbeLabel);
/*     */ 
/* 223 */     constr(1, 2, 1, 1);
/* 224 */     this.constraints.fill = 1;
/* 225 */     this.gridbag.setConstraints(this.liedFarbeButton, this.constraints);
/* 226 */     this.liedPanel.add(this.liedFarbeButton);
/*     */ 
/* 228 */     constr(0, 3, 1, 1);
/* 229 */     this.constraints.fill = 1;
/* 230 */     this.gridbag.setConstraints(this.schattenLiedFarbeLabel, this.constraints);
/* 231 */     this.liedPanel.add(this.schattenLiedFarbeLabel);
/*     */ 
/* 233 */     constr(1, 3, 1, 1);
/* 234 */     this.constraints.fill = 1;
/* 235 */     this.gridbag.setConstraints(this.schattenLiedButton, this.constraints);
/* 236 */     this.liedPanel.add(this.schattenLiedButton);
/*     */ 
/* 238 */     constr(0, 4, 1, 1);
/* 239 */     this.constraints.fill = 1;
/* 240 */     this.gridbag.setConstraints(this.liedKleiner, this.constraints);
/* 241 */     this.liedPanel.add(this.liedKleiner);
/*     */ 
/* 243 */     constr(1, 4, 1, 1);
/* 244 */     this.constraints.fill = 1;
/* 245 */     this.gridbag.setConstraints(this.liedZeileButton, this.constraints);
/* 246 */     this.liedPanel.add(this.liedZeileButton);
/*     */ 
/* 248 */     constr(1, 5, 1, 1);
/* 249 */     this.constraints.fill = 1;
/* 250 */     this.gridbag.setConstraints(this.liedTextButton, this.constraints);
/* 251 */     this.liedPanel.add(this.liedTextButton);
/*     */ 
/* 253 */     constr(0, 0, 1, 1);
/* 254 */     this.constraints.fill = 1;
/* 255 */     this.gridbag.setConstraints(this.strophenFontLabel, this.constraints);
/* 256 */     this.liedStrophenPanel.add(this.strophenFontLabel);
/*     */ 
/* 258 */     constr(1, 0, 1, 1);
/* 259 */     this.constraints.fill = 1;
/* 260 */     this.gridbag.setConstraints(this.stropheFont, this.constraints);
/* 261 */     this.liedStrophenPanel.add(this.stropheFont);
/*     */ 
/* 263 */     constr(2, 0, 1, 1);
/* 264 */     this.constraints.fill = 1;
/* 265 */     this.gridbag.setConstraints(this.stropheBold, this.constraints);
/* 266 */     this.liedStrophenPanel.add(this.stropheBold);
/*     */ 
/* 268 */     constr(3, 0, 1, 1);
/* 269 */     this.constraints.fill = 1;
/* 270 */     this.gridbag.setConstraints(this.stropheItalic, this.constraints);
/* 271 */     this.liedStrophenPanel.add(this.stropheItalic);
/*     */ 
/* 273 */     constr(0, 1, 1, 1);
/* 274 */     this.constraints.fill = 1;
/* 275 */     this.gridbag.setConstraints(this.strophenFontSizeLabel, this.constraints);
/* 276 */     this.liedStrophenPanel.add(this.strophenFontSizeLabel);
/*     */ 
/* 278 */     constr(1, 1, 1, 1);
/* 279 */     this.constraints.fill = 1;
/* 280 */     this.gridbag.setConstraints(this.stropheFontSize, this.constraints);
/* 281 */     this.liedStrophenPanel.add(this.stropheFontSize);
/*     */ 
/* 285 */     constr(0, 0, 1, 1);
/* 286 */     this.constraints.fill = 1;
/* 287 */     this.gridbag.setConstraints(this.refrainFontLabel, this.constraints);
/* 288 */     this.liedRefrainPanel.add(this.refrainFontLabel);
/*     */ 
/* 290 */     constr(1, 0, 1, 1);
/* 291 */     this.constraints.fill = 1;
/* 292 */     this.gridbag.setConstraints(this.refrainFont, this.constraints);
/* 293 */     this.liedRefrainPanel.add(this.refrainFont);
/*     */ 
/* 295 */     constr(2, 0, 1, 1);
/* 296 */     this.constraints.fill = 1;
/* 297 */     this.gridbag.setConstraints(this.refrainBold, this.constraints);
/* 298 */     this.liedRefrainPanel.add(this.refrainBold);
/*     */ 
/* 300 */     constr(3, 0, 1, 1);
/* 301 */     this.constraints.fill = 1;
/* 302 */     this.gridbag.setConstraints(this.refrainItalic, this.constraints);
/* 303 */     this.liedRefrainPanel.add(this.refrainItalic);
/*     */ 
/* 305 */     constr(0, 1, 1, 1);
/* 306 */     this.constraints.fill = 1;
/* 307 */     this.gridbag.setConstraints(this.refrainFontSizeLabel, this.constraints);
/* 308 */     this.liedRefrainPanel.add(this.refrainFontSizeLabel);
/*     */ 
/* 310 */     constr(1, 1, 1, 1);
/* 311 */     this.constraints.fill = 1;
/* 312 */     this.gridbag.setConstraints(this.refrainFontSize, this.constraints);
/* 313 */     this.liedRefrainPanel.add(this.refrainFontSize);
/*     */ 
/* 316 */     constr(0, 0, 1, 1);
/* 317 */     this.constraints.fill = 1;
/* 318 */     this.gridbag.setConstraints(this.bridgeFontLabel, this.constraints);
/* 319 */     this.liedBridgePanel.add(this.bridgeFontLabel);
/*     */ 
/* 321 */     constr(1, 0, 1, 1);
/* 322 */     this.constraints.fill = 1;
/* 323 */     this.gridbag.setConstraints(this.bridgeFont, this.constraints);
/* 324 */     this.liedBridgePanel.add(this.bridgeFont);
/*     */ 
/* 326 */     constr(2, 0, 1, 1);
/* 327 */     this.constraints.fill = 1;
/* 328 */     this.gridbag.setConstraints(this.bridgeBold, this.constraints);
/* 329 */     this.liedBridgePanel.add(this.bridgeBold);
/*     */ 
/* 331 */     constr(3, 0, 1, 1);
/* 332 */     this.constraints.fill = 1;
/* 333 */     this.gridbag.setConstraints(this.bridgeItalic, this.constraints);
/* 334 */     this.liedBridgePanel.add(this.bridgeItalic);
/*     */ 
/* 336 */     constr(0, 1, 1, 1);
/* 337 */     this.constraints.fill = 1;
/* 338 */     this.gridbag.setConstraints(this.bridgeFontSizeLabel, this.constraints);
/* 339 */     this.liedBridgePanel.add(this.bridgeFontSizeLabel);
/*     */ 
/* 341 */     constr(1, 1, 1, 1);
/* 342 */     this.constraints.fill = 1;
/* 343 */     this.gridbag.setConstraints(this.bridgeFontSize, this.constraints);
/* 344 */     this.liedBridgePanel.add(this.bridgeFontSize);
/*     */ 
/* 347 */     constr(0, 0, 1, 1);
/* 348 */     this.constraints.fill = 1;
/* 349 */     this.gridbag.setConstraints(this.translateFontLabel, this.constraints);
/* 350 */     this.liedUsetzPanel.add(this.translateFontLabel);
/*     */ 
/* 352 */     constr(1, 0, 1, 1);
/* 353 */     this.constraints.fill = 1;
/* 354 */     this.gridbag.setConstraints(this.translateFont, this.constraints);
/* 355 */     this.liedUsetzPanel.add(this.translateFont);
/*     */ 
/* 357 */     constr(2, 0, 1, 1);
/* 358 */     this.constraints.fill = 1;
/* 359 */     this.gridbag.setConstraints(this.translateBold, this.constraints);
/* 360 */     this.liedUsetzPanel.add(this.translateBold);
/*     */ 
/* 362 */     constr(3, 0, 1, 1);
/* 363 */     this.constraints.fill = 1;
/* 364 */     this.gridbag.setConstraints(this.translateItalic, this.constraints);
/* 365 */     this.liedUsetzPanel.add(this.translateItalic);
/*     */ 
/* 367 */     constr(2, 1, 2, 1);
/* 368 */     this.constraints.fill = 1;
/* 369 */     this.gridbag.setConstraints(this.anzeigeCB, this.constraints);
/* 370 */     this.liedUsetzPanel.add(this.anzeigeCB);
/*     */ 
/* 372 */     constr(0, 1, 1, 1);
/* 373 */     this.constraints.fill = 1;
/* 374 */     this.gridbag.setConstraints(this.translateFontSizeLabel, this.constraints);
/* 375 */     this.liedUsetzPanel.add(this.translateFontSizeLabel);
/*     */ 
/* 377 */     constr(1, 1, 1, 1);
/* 378 */     this.constraints.fill = 1;
/* 379 */     this.gridbag.setConstraints(this.translateFontSize, this.constraints);
/* 380 */     this.liedUsetzPanel.add(this.translateFontSize);
/*     */ 
/* 382 */     constr(0, 2, 1, 1);
/* 383 */     this.constraints.fill = 1;
/* 384 */     this.gridbag.setConstraints(this.translateFarbeLabel, this.constraints);
/* 385 */     this.liedUsetzPanel.add(this.translateFarbeLabel);
/*     */ 
/* 387 */     constr(1, 2, 1, 1);
/* 388 */     this.constraints.fill = 1;
/* 389 */     this.gridbag.setConstraints(this.translateFarbeButton, this.constraints);
/* 390 */     this.liedUsetzPanel.add(this.translateFarbeButton);
/*     */ 
/* 393 */     this.textTab.add("Strophen", this.liedStrophenPanel);
/* 394 */     this.textTab.add("Refrain", this.liedRefrainPanel);
/* 395 */     this.textTab.add("Brücke", this.liedBridgePanel);
/* 396 */     this.textTab.add("Übersetzung", this.liedUsetzPanel);
/*     */ 
/* 398 */     constr(0, 6, 3, 2);
/* 399 */     this.constraints.fill = 1;
/* 400 */     this.gridbag.setConstraints(this.textTab, this.constraints);
/* 401 */     this.liedPanel.add(this.textTab);
/*     */ 
/* 408 */     constr(0, 1, 5, 1);
/* 409 */     this.constraints.fill = 1;
/* 410 */     this.gridbag.setConstraints(this.liedPanel, this.constraints);
/* 411 */     this.mainPanel.add(this.liedPanel);
/*     */ 
/* 413 */     constr(2, 2, 1, 1);
/* 414 */     this.constraints.fill = 0;
/* 415 */     this.gridbag.setConstraints(this.okButton, this.constraints);
/* 416 */     this.mainPanel.add(this.okButton);
/*     */ 
/* 418 */     constr(4, 2, 1, 1);
/* 419 */     this.constraints.fill = 0;
/* 420 */     this.gridbag.setConstraints(this.cancelButton, this.constraints);
/* 421 */     this.mainPanel.add(this.cancelButton);
/*     */ 
/* 423 */     this.okButton.addActionListener(new LiedGUIActionAdapter(this));
/* 424 */     this.cancelButton.addActionListener(new LiedGUIActionAdapter(this));
/*     */ 
/* 426 */     this.liedFarbeButton.addActionListener(new LiedGUIActionAdapter(this));
/* 427 */     this.translateFarbeButton.addActionListener(new LiedGUIActionAdapter(this));
/* 428 */     this.hgliedButton.addActionListener(new LiedGUIActionAdapter(this));
/* 429 */     this.schattenLiedButton.addActionListener(new LiedGUIActionAdapter(this));
/*     */ 
/* 431 */     this.liedKleiner.addMouseListener(new LiedGUIMouseAdapter(this));
/* 432 */     this.liedKleiner.addKeyListener(new LiedGUITastenAdapter(this));
/*     */ 
/* 434 */     this.liedgrp.add(this.liedZeileButton);
/* 435 */     this.liedgrp.add(this.liedTextButton);
/*     */ 
/* 437 */     getContentPane().add(this.mainPanel);
/* 438 */     pack();
/*     */   }
/*     */ 
/*     */   private void constr(int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
/* 442 */     this.constraints.gridx = paramInt1;
/* 443 */     this.constraints.gridy = paramInt2;
/* 444 */     this.constraints.gridwidth = paramInt3;
/* 445 */     this.constraints.gridheight = paramInt4;
/*     */   }
/*     */ 
/*     */   public void close() {
/* 449 */     setVisible(false);
/* 450 */     dispose();
/*     */   }
/*     */ 
/*     */   public void action(ActionEvent paramActionEvent) {
/* 454 */     Object localObject = paramActionEvent.getSource();
/* 455 */     if (localObject == this.okButton)
/* 456 */       OK();
/* 457 */     else if (localObject == this.cancelButton)
/* 458 */       close();
/* 459 */     else if (localObject == this.liedFarbeButton)
/* 460 */       Farbewaehlen(0);
/* 461 */     else if (localObject == this.hgliedButton)
/* 462 */       Farbewaehlen(1);
/* 463 */     else if (localObject == this.translateFarbeButton)
/* 464 */       Farbewaehlen(2);
/* 465 */     else if (localObject == this.schattenLiedButton)
/* 466 */       Farbewaehlen(3);
/*     */   }
/*     */ 
/*     */   private void OK()
/*     */   {
/* 473 */     this.e.setTextKleiner(this.liedKleiner.isSelected());
/* 474 */     this.e.setTextZeile(this.liedZeileButton.isSelected());
/* 475 */     this.e.setTextFont(1, this.stropheFont.getSelectedIndex());
/* 476 */     this.e.setTextFont(2, this.refrainFont.getSelectedIndex());
/* 477 */     this.e.setTextFont(3, this.bridgeFont.getSelectedIndex());
/* 478 */     this.e.setTextFont(4, this.translateFont.getSelectedIndex());
/* 479 */     this.e.setFontSize(1, this.stropheFontSize.getSelectedIndex() + 1);
/* 480 */     this.e.setFontSize(2, this.refrainFontSize.getSelectedIndex() + 1);
/* 481 */     this.e.setFontSize(3, this.bridgeFontSize.getSelectedIndex() + 1);
/* 482 */     this.e.setFontSize(4, this.translateFontSize.getSelectedIndex());
/* 483 */     this.e.setBold(1, this.stropheBold.isSelected());
/* 484 */     this.e.setBold(2, this.refrainBold.isSelected());
/* 485 */     this.e.setBold(3, this.bridgeBold.isSelected());
/* 486 */     this.e.setBold(4, this.translateBold.isSelected());
/* 487 */     this.e.setItalic(1, this.stropheItalic.isSelected());
/* 488 */     this.e.setItalic(2, this.refrainItalic.isSelected());
/* 489 */     this.e.setItalic(3, this.bridgeItalic.isSelected());
/* 490 */     this.e.setItalic(4, this.translateItalic.isSelected());
/* 491 */     this.e.setAnzeige(this.anzeigeCB.isSelected());
/* 492 */     this.e.setTextF(this.Farben[0]);
/* 493 */     this.e.setTextH(this.Farben[1]);
/* 494 */     this.e.setTransF(this.Farben[2]);
/* 495 */     this.e.setRahmenFarbe(this.Farben[3]);
/* 496 */     this.e.setRahmen(this.schattenLiedFarbeLabel.isSelected());
/*     */ 
/* 498 */     close();
/*     */   }
/*     */ 
/*     */   public boolean cancel() {
/* 502 */     return this.cancel;
/*     */   }
/*     */ 
/*     */   public boolean getNew()
/*     */   {
/* 507 */     return this.neu;
/*     */   }
/*     */ 
/*     */   private void Farbewaehlen(int paramInt) {
/* 511 */     if ((paramInt >= 0) && (paramInt < 4)) {
/* 512 */       Color localColor = JColorChooser.showDialog(this.l, "Farbe wählen", this.Farben[paramInt]);
/* 513 */       if (null != localColor) {
/* 514 */         this.Farben[paramInt] = localColor;
/* 515 */         switch (paramInt) {
/*     */         case 0:
/* 517 */           this.liedIcon.setFarbe(localColor);
/* 518 */           break;
/*     */         case 1:
/* 520 */           this.liedHGIcon.setFarbe(localColor);
/* 521 */           break;
/*     */         case 2:
/* 523 */           this.transFIcon.setFarbe(localColor);
/* 524 */           break;
/*     */         case 3:
/* 526 */           this.schattenLIcon.setFarbe(localColor);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void taste(KeyEvent paramKeyEvent)
/*     */   {
/* 535 */     int i = paramKeyEvent.getModifiers();
/* 536 */     int j = paramKeyEvent.getKeyChar();
/* 537 */     int k = paramKeyEvent.getKeyCode();
/* 538 */     Object localObject = paramKeyEvent.getSource();
/*     */ 
/* 540 */     if (k != 0)
/*     */     {
/* 542 */       if (k == 10)
/*     */       {
/* 545 */         OK();
/* 546 */       } else if (k == 27)
/* 547 */         close();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void CheckBoxen(Object paramObject)
/*     */   {
/* 554 */     if (paramObject == this.liedKleiner) {
/* 555 */       this.d.out("CheckBox liedKleiner");
/* 556 */       if (this.liedKleiner.isSelected()) {
/* 557 */         this.liedZeileButton.setEnabled(true);
/* 558 */         this.liedTextButton.setEnabled(true);
/*     */       } else {
/* 560 */         this.liedZeileButton.setEnabled(false);
/* 561 */         this.liedTextButton.setEnabled(false);
/*     */       }
/* 563 */       if (this.liedKleiner.isSelected()) {
/* 564 */         this.d.out("textKleiner is Selected und wird ausgeschaltet");
/* 565 */         this.liedKleiner.setSelected(false);
/*     */       } else {
/* 567 */         this.d.out("textKleiner is not Selected und wird angeschaltet");
/* 568 */         this.liedKleiner.setSelected(true);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void mouse(MouseEvent paramMouseEvent) {
/* 574 */     Object localObject = paramMouseEvent.getSource();
/*     */ 
/* 576 */     if (localObject == this.liedKleiner)
/* 577 */       if (this.liedKleiner.isSelected()) {
/* 578 */         this.liedZeileButton.setEnabled(true);
/* 579 */         this.liedTextButton.setEnabled(true);
/*     */       } else {
/* 581 */         this.liedZeileButton.setEnabled(false);
/* 582 */         this.liedTextButton.setEnabled(false);
/*     */       }
/*     */   }
/*     */ }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     LiedEinstellungenGUI
 * JD-Core Version:    0.6.0
 */