        import java.awt.BorderLayout;
        import java.awt.Container;
        import java.awt.Dimension;
        import java.awt.event.ActionEvent;
        import java.io.File;
        import java.io.PrintStream;
        import javax.swing.ImageIcon;
        import javax.swing.JButton;
        import javax.swing.JDesktopPane;
        import javax.swing.JFileChooser;
        import javax.swing.JFrame;
        import javax.swing.JMenu;
        import javax.swing.JMenuBar;
        import javax.swing.JMenuItem;
        import javax.swing.JOptionPane;
        import javax.swing.JPanel;
        import javax.swing.JToolBar;
        import javax.swing.KeyStroke;
        import javax.swing.SwingUtilities;
        import javax.swing.UIManager;
        import javax.swing.UnsupportedLookAndFeelException;
        import javax.swing.plaf.ColorUIResource;
        import javax.swing.plaf.metal.MetalLookAndFeel;
        
        public class LoBeT extends JFrame
        {
          public static final long serialVersionUID = 1L;
          private final String VERSION = Start.showVersion();
          private static final String LaFmetal = "javax.swing.plaf.metal.MetalLookAndFeel";
          private static final String LaFwindows = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
          private static final String LaFmotif = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
          private static final String LaFmac = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
          private static final String LaFbasic = "javax.swing.plaf.basic.BasicLookAndFeel";
          private static final int STARTLOOKANDFEEL = 1;
          private AllgMetalTheme allg = new AllgMetalTheme();
          private GrauMetalTheme grau = new GrauMetalTheme();
          private NormalMetalTheme normal = new NormalMetalTheme();
          private NormalMetalTheme eigen = new NormalMetalTheme();
          public static final int SAVE_EXPORT01 = 0;
          public static final int SAVE_EXPORT02 = 1;
          public static final int SAVE_EXPORT03 = 2;
          public static final int SAVE_EXPORT04 = 3;
          public static final int SAVE_TEXT01 = 4;
          public static final int SAVE_TEXT02 = 5;
          public static final int SAVE_TEXT03 = 6;
          public static final int SAVE_HTML01 = 7;
          public static final int SAVE_XML01 = 8;
          private Daten jdaten;
          private File file;
          private File lastFile;
          private File lastDir;
          private JFileChooser jfc;
          private int i;
          private int status = 0;
          public static final int start = 0;
          public static final int geladen = 1;
          public static final int unsave = 2;
          private Debug d = new Debug(false);
          private boolean debug = false;
          private boolean schliessen = false;
          private boolean beenden = false;
          private boolean warten = false;
          private String DateiString = "";
        
          private boolean backup = false;
          private int startx = 0;
          private int starty = 0;
          private JPanel tisch;
          private JDesktopPane desktop;
          private Schirm Lieder;
          private Schirm Texte;
          private Schirm Bilder;
          private Schirm aktuell;
          private Schirm suchen;
          private SuchenGUI such;
          private AblaufPlanGUI ablauf;
          private PrinterGUI printer;
          private PrinterPreviewGUI printerPreview;
          private EinstellungenGUI einstell;
          private Einstellungen options = new Einstellungen();
          private BorderLayout bord;
          private ColorUIResource primary1;
          private ColorUIResource primary2;
          private ColorUIResource primary3;
          private ColorUIResource secondary1;
          private ColorUIResource secondary2;
          private ColorUIResource secondary3;
          private ColorUIResource black;
          private ColorUIResource white;
          private JMenuBar menuBar = new JMenuBar();
          private JMenu dateiMenu = new JMenu();
          private JMenu bearbMenu = new JMenu();
          private JMenu ansichtMenu = new JMenu();
          private JMenu optionenMenu = new JMenu();
          private JMenu extrasMenu = new JMenu();
          private JMenu hilfeMenu = new JMenu();
        
          private JMenuItem beendenItem = new JMenuItem();
          private JMenuItem neuItem = new JMenuItem();
          private JMenuItem ladenItem = new JMenuItem();
          private JMenuItem saveItem = new JMenuItem();
          private JMenuItem saveunterItem = new JMenuItem();
          private JMenuItem importItem = new JMenuItem("Importieren");
        
          private JMenu exportMenu = new JMenu();
          private JMenu lobetMenu = new JMenu();
          private JMenuItem lobetExport01Item = new JMenuItem();
          private JMenuItem lobetExport02Item = new JMenuItem();
          private JMenuItem lobetExport03Item = new JMenuItem();
          private JMenuItem lobetExport04Item = new JMenuItem();
          private JMenu textExportMenu = new JMenu();
          private JMenuItem textLiedExport01Item = new JMenuItem();
          private JMenuItem textTextExport01Item = new JMenuItem();
          private JMenuItem textListeExport01Item = new JMenuItem();
          private JMenuItem htmlExport01Item = new JMenuItem();
          private JMenuItem xmlExport01Item = new JMenuItem("XML");
          private JMenuItem abLaufItem = new JMenuItem("Ablaufplan");
          private JMenu druckMenu = new JMenu();
          private JMenuItem druckLiederItem = new JMenuItem("Liederliste");
          private JMenuItem druckTexteItem = new JMenuItem("Textliste");
          private JMenuItem druckAblaufItem = new JMenuItem("Ablaufplan");
          private JMenuItem schliessenItem = new JMenuItem();
        
          private JMenuItem suchenItem = new JMenuItem();
          private JMenuItem suchLKItem = new JMenuItem("Duplikate suchen");
          private JMenuItem suchLOItem = new JMenuItem("Originale suchen");
          private JMenuItem suchaaktItem = new JMenuItem("Alle Duplikate aktualisieren");
          private JMenuItem suchDelItem = new JMenuItem("Alle Duplikate löschen");
          private JMenuItem addStatItem = new JMenuItem("Lieder zu Statistiken hinzufügen");
          private JMenuItem delStatItem = new JMenuItem("Statistiken löschen");
        
          private JMenuItem LIEDItem = new JMenuItem();
          private JMenuItem TEXTItem = new JMenuItem();
          private JMenuItem BILDItem = new JMenuItem();
          private JMenuItem AKTItem = new JMenuItem();
          private JMenuItem SUCHItem = new JMenuItem();
          private JMenuItem Ansicht1Item = new JMenuItem();
          private JMenuItem Ansicht2Item = new JMenuItem();
          private JMenuItem vorItem = new JMenuItem();
          private JMenuItem diaItem = new JMenuItem();
        
          private JMenuItem einstellungenItem = new JMenuItem();
          private JMenuItem fontloeschenItem = new JMenuItem();
          private JMenu lookAndFeelMenu = new JMenu();
          private JMenuItem basicLAF = new JMenuItem();
          private JMenuItem normalLAF = new JMenuItem();
          private JMenuItem grauLAF = new JMenuItem();
          private JMenuItem motifLAF = new JMenuItem();
          private JMenuItem macLAF = new JMenuItem();
          private JMenuItem windowsLAF = new JMenuItem();
          private JMenu eigeneMenu = new JMenu("Eigene");
          private JMenuItem setOwnItem = new JMenuItem("Setzen");
          private JMenuItem chooseOwnItem = new JMenuItem("Anwenden");
          private JMenuItem orgOwnItem = new JMenuItem("Wiederherstellen");
        
          private JMenuItem hilfeItem = new JMenuItem();
        
          private JMenuItem gplItem = new JMenuItem("Lizenz");
          private JMenuItem ueberItem = new JMenuItem();
          private JToolBar bar;
          private JButton neuButton = new JButton();
          private JButton openButton = new JButton();
          private JButton saveButton = new JButton();
          private JButton saveAsButton = new JButton();
          private JButton importButton = new JButton();
          private JButton ablaufplanButton = new JButton();
          private JButton suchButton = new JButton();
          private JButton druckButton = new JButton();
          private JButton diaButton = new JButton();
          private JButton startButton = new JButton();
          private JButton helpButton = new JButton();
          private JButton aboutButton = new JButton();
        
          public static void main(String[] paramArrayOfString)
          {
            LoBeT localLoBeT;
            File localFile;
            switch (paramArrayOfString.length) {
            case 0:
              localLoBeT = new LoBeT();
              break;
            case 1:
              if (paramArrayOfString[0].equals("-d")) {
                localLoBeT = new LoBeT(true);
                System.out.println("Starten fertig");
              } else if (paramArrayOfString[0].equals("-s")) {
                ausgabe();
              } else {
                localFile = new File(paramArrayOfString[0]);
                localLoBeT = new LoBeT(localFile);
              }
              break;
            case 2:
              if (paramArrayOfString[0].equals("-d")) {
                if (paramArrayOfString[1].equals("-s")) {
                  ausgabe();
                } else {
                  localFile = new File(paramArrayOfString[1]);
                  localLoBeT = new LoBeT(true, localFile);
                  System.out.println("Starten fertig");
                }
              } else if (paramArrayOfString[0].equals("-s")) {
                localFile = new File(paramArrayOfString[1]);
                localLoBeT = new LoBeT(false, true, localFile);
              } else {
                ausgabe();
              }
              break;
            case 3:
              if ((paramArrayOfString[0].equals("-d")) && (paramArrayOfString[1].equals("-s"))) {
                localFile = new File(paramArrayOfString[2]);
                localLoBeT = new LoBeT(true, true, localFile);
                System.out.println("Starten fertig");
              } else {
                ausgabe();
              }
              break;
            default:
              ausgabe();
            }
          }
        
          private static void ausgabe() {
            System.out.println("Zuviele Argumente.");
            System.out.println("Usage: java -jar LoBeT.jar [-d][-s] File");
            System.out.println("-d: Debugmodus");
            System.out.println("-s: Es wird gleich die Präsentation gestartet");
          }
        
          public LoBeT() {
            initGUI();
          }
        
          public LoBeT(int paramInt1, int paramInt2) {
            this.startx = paramInt1;
            this.starty = paramInt2;
            initGUI();
          }
        
          public LoBeT(boolean paramBoolean) {
            this.debug = paramBoolean;
            this.d = new Debug(paramBoolean);
            initGUI();
          }
        
          public LoBeT(boolean paramBoolean, int paramInt1, int paramInt2) {
            this.debug = paramBoolean;
            this.d = new Debug(paramBoolean);
            this.startx = paramInt1;
            this.starty = paramInt2;
            initGUI();
          }
        
          public LoBeT(File paramFile) {
            this.jdaten = new Daten(this.debug);
            this.Lieder = new Schirm(this, this.jdaten, 0, this.debug);
            this.Texte = new Schirm(this, this.jdaten, 1, this.debug);
            this.Bilder = new Schirm(this, this.jdaten, 2, this.debug);
            this.aktuell = new Schirm(this, this.jdaten, 3, this.debug);
            this.suchen = new Schirm(this, this.jdaten, 4, this.debug);
            this.einstell = new EinstellungenGUI(this, this.jdaten, this.debug);
        
            initGUI();
            this.file = paramFile;
            if (null != paramFile) {
              this.warten = true;
        
              ProgressBarNeuThread localProgressBarNeuThread = new ProgressBarNeuThread(this, this.jdaten, paramFile, 1);
              localProgressBarNeuThread.start();
            }
          }
        
          public LoBeT(boolean paramBoolean, File paramFile) {
            this.debug = paramBoolean;
            this.d = new Debug(paramBoolean);
            this.jdaten = new Daten(paramBoolean);
            this.Lieder = new Schirm(this, this.jdaten, 0, paramBoolean);
            this.Texte = new Schirm(this, this.jdaten, 1, paramBoolean);
            this.Bilder = new Schirm(this, this.jdaten, 2, paramBoolean);
            this.aktuell = new Schirm(this, this.jdaten, 3, paramBoolean);
            this.suchen = new Schirm(this, this.jdaten, 4, paramBoolean);
            this.einstell = new EinstellungenGUI(this, this.jdaten, paramBoolean);
        
            initGUI();
            this.file = paramFile;
            if (null != paramFile) {
              this.warten = true;
        
              ProgressBarNeuThread localProgressBarNeuThread = new ProgressBarNeuThread(this, this.jdaten, paramFile, 1);
              localProgressBarNeuThread.start();
            }
          }
        
          public LoBeT(boolean paramBoolean1, boolean paramBoolean2, File paramFile) {
            this.debug = paramBoolean1;
            this.d = new Debug(paramBoolean1);
            this.jdaten = new Daten(paramBoolean1);
            this.Lieder = new Schirm(this, this.jdaten, 0, paramBoolean1);
            this.Texte = new Schirm(this, this.jdaten, 1, paramBoolean1);
            this.Bilder = new Schirm(this, this.jdaten, 2, paramBoolean1);
            this.aktuell = new Schirm(this, this.jdaten, 3, paramBoolean1);
            this.suchen = new Schirm(this, this.jdaten, 4, paramBoolean1);
            this.einstell = new EinstellungenGUI(this, this.jdaten, paramBoolean1);
        
            initGUI();
            this.file = paramFile;
            if (null != paramFile) {
              this.warten = true;
        
              ProgressBarNeuThread localProgressBarNeuThread = new ProgressBarNeuThread(this, this.jdaten, paramFile, 1, paramBoolean2);
              localProgressBarNeuThread.start();
            }
          }
        
          public LoBeT(boolean paramBoolean1, boolean paramBoolean2, int paramInt1, int paramInt2, File paramFile) {
            this.debug = paramBoolean1;
            this.startx = paramInt1;
            this.starty = paramInt2;
            this.d = new Debug(paramBoolean1);
            this.jdaten = new Daten(paramBoolean1);
            this.Lieder = new Schirm(this, this.jdaten, 0, paramBoolean1);
            this.Texte = new Schirm(this, this.jdaten, 1, paramBoolean1);
            this.Bilder = new Schirm(this, this.jdaten, 2, paramBoolean1);
            this.aktuell = new Schirm(this, this.jdaten, 3, paramBoolean1);
            this.suchen = new Schirm(this, this.jdaten, 4, paramBoolean1);
            this.einstell = new EinstellungenGUI(this, this.jdaten, paramBoolean1);
        
            initGUI();
            this.file = paramFile;
            if (null != paramFile) {
              this.warten = true;
              ProgressBarNeuThread localProgressBarNeuThread = new ProgressBarNeuThread(this, this.jdaten, paramFile, 1, paramBoolean2);
              localProgressBarNeuThread.start();
            }
          }
        
          public void initGUI()
          {
            setDefaultCloseOperation(0);
            MenuActionAdapter localMenuActionAdapter = new MenuActionAdapter(this);
        
            setSize(new Dimension(736, 600));
            setTitle("LoBeT");
            setLocation(this.startx, this.starty);
        
            ImageIcon localImageIcon = new ImageIcon(LoBeT.class.getResource("icons/Jar24.gif"));
            setIconImage(localImageIcon.getImage());
        
            addWindowListener(localMenuActionAdapter);
        
            this.dateiMenu.setText("Datei");
            this.dateiMenu.setMnemonic('D');
            this.neuItem.setText("Neu");
            this.neuItem.addActionListener(new MenuActionAdapter(this));
            this.neuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
            this.ladenItem.setText("Öffnen");
            this.ladenItem.addActionListener(new MenuActionAdapter(this));
            this.ladenItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
            this.saveItem.setText("Speichern");
            this.saveItem.addActionListener(new MenuActionAdapter(this));
            this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            this.saveunterItem.setText("Speichern unter");
            this.saveunterItem.addActionListener(new MenuActionAdapter(this));
            this.schliessenItem.setText("Schliessen");
            this.schliessenItem.addActionListener(new MenuActionAdapter(this));
            this.schliessenItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        
            this.importItem.addActionListener(new MenuActionAdapter(this));
        
            this.exportMenu.setText("Exportieren");
            this.lobetMenu.setText("LoBeT-Formate");
            this.lobetExport01Item.setText("1.0");
            this.lobetExport01Item.addActionListener(new MenuActionAdapter(this));
            this.lobetExport02Item.setText("1.1");
            this.lobetExport02Item.addActionListener(new MenuActionAdapter(this));
            this.lobetExport03Item.setText("1.2");
            this.lobetExport03Item.addActionListener(new MenuActionAdapter(this));
            this.lobetExport04Item.setText("1.3");
            this.lobetExport04Item.addActionListener(new MenuActionAdapter(this));
            this.textExportMenu.setText("Text");
            this.textLiedExport01Item.setText("Liedertexte");
            this.textLiedExport01Item.addActionListener(new MenuActionAdapter(this));
            this.textTextExport01Item.setText("(Text)Texte");
            this.textTextExport01Item.addActionListener(new MenuActionAdapter(this));
            this.textListeExport01Item.setText("Liederliste");
            this.textListeExport01Item.addActionListener(new MenuActionAdapter(this));
            this.htmlExport01Item.setText("HTML");
            this.htmlExport01Item.addActionListener(new MenuActionAdapter(this));
            this.xmlExport01Item.addActionListener(new MenuActionAdapter(this));
            this.druckMenu.setText("Drucken");
            this.druckMenu.addActionListener(new MenuActionAdapter(this));
        
            this.druckMenu.setMnemonic('P');
            this.druckLiederItem.addActionListener(new MenuActionAdapter(this));
            this.druckTexteItem.addActionListener(new MenuActionAdapter(this));
            this.druckAblaufItem.addActionListener(new MenuActionAdapter(this));
            this.abLaufItem.addActionListener(new MenuActionAdapter(this));
            this.beendenItem.setText("Beenden");
            this.beendenItem.addActionListener(new MenuActionAdapter(this));
            this.beendenItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        
            this.bearbMenu.setText("Bearbeiten");
            this.suchenItem.setText("Suchen");
            this.suchenItem.addActionListener(new MenuActionAdapter(this));
            this.suchenItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
            this.suchLKItem.addActionListener(new MenuActionAdapter(this));
            this.suchLOItem.addActionListener(new MenuActionAdapter(this));
            this.suchaaktItem.addActionListener(new MenuActionAdapter(this));
            this.suchDelItem.addActionListener(new MenuActionAdapter(this));
            this.addStatItem.addActionListener(new MenuActionAdapter(this));
            this.delStatItem.addActionListener(new MenuActionAdapter(this));
        
            this.ansichtMenu.setText("Ansicht");
            this.ansichtMenu.setMnemonic('A');
            this.LIEDItem.setText("Lieder");
            this.LIEDItem.setMnemonic('L');
            this.TEXTItem.setText("Texte");
            this.TEXTItem.setMnemonic('T');
            this.BILDItem.setText("Bilder");
            this.BILDItem.setMnemonic('B');
            this.AKTItem.setText("Aktuell");
            this.AKTItem.setMnemonic('A');
            this.SUCHItem.setText("Suchergebnisse");
            this.Ansicht1Item.setText("gestaffelte Fenster");
            this.Ansicht2Item.setText("gekachelte Fenster");
            this.vorItem.setText("Vorführung");
            this.diaItem.setText("Diaschau");
        
            this.LIEDItem.addActionListener(new MenuActionAdapter(this));
            this.TEXTItem.addActionListener(new MenuActionAdapter(this));
            this.BILDItem.addActionListener(new MenuActionAdapter(this));
            this.AKTItem.addActionListener(new MenuActionAdapter(this));
            this.SUCHItem.addActionListener(new MenuActionAdapter(this));
            this.Ansicht1Item.addActionListener(new MenuActionAdapter(this));
            this.Ansicht2Item.addActionListener(new MenuActionAdapter(this));
            this.vorItem.addActionListener(new MenuActionAdapter(this));
            this.vorItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
            this.diaItem.addActionListener(new MenuActionAdapter(this));
            this.diaItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        
            this.optionenMenu.setText("Optionen");
            this.optionenMenu.setMnemonic('O');
            this.einstellungenItem.setText("Einstellungen");
            this.einstellungenItem.addActionListener(new MenuActionAdapter(this));
            this.einstellungenItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            this.fontloeschenItem.setText("Fontgrößen löschen");
            this.fontloeschenItem.addActionListener(new MenuActionAdapter(this));
            this.lookAndFeelMenu.setText("Sehen und Fühlen");
            this.lookAndFeelMenu.addActionListener(new MenuActionAdapter(this));
            this.normalLAF.setText("metal");
            this.normalLAF.addActionListener(new MenuActionAdapter(this));
            this.basicLAF.setText("basic");
            this.basicLAF.addActionListener(new MenuActionAdapter(this));
            this.grauLAF.setText("grau");
            this.grauLAF.addActionListener(new MenuActionAdapter(this));
            this.motifLAF.setText("Motif");
            this.motifLAF.addActionListener(new MenuActionAdapter(this));
            this.macLAF.setText("Mac");
            this.macLAF.addActionListener(new MenuActionAdapter(this));
            this.windowsLAF.setText("Windows");
            this.windowsLAF.addActionListener(new MenuActionAdapter(this));
        
            this.setOwnItem.addActionListener(new MenuActionAdapter(this));
            this.chooseOwnItem.addActionListener(new MenuActionAdapter(this));
            this.orgOwnItem.addActionListener(new MenuActionAdapter(this));
        
            this.hilfeMenu.setText("Hilfe");
            this.hilfeItem.setText("Hilfe");
            this.hilfeItem.addActionListener(new MenuActionAdapter(this));
        
            this.ueberItem.setText("Über LoBeT");
            this.ueberItem.addActionListener(new MenuActionAdapter(this));
            this.gplItem.addActionListener(new MenuActionAdapter(this));
        
            this.druckMenu.add(this.druckLiederItem);
            this.druckMenu.add(this.druckTexteItem);
            this.druckMenu.add(this.druckAblaufItem);
        
            this.dateiMenu.add(this.neuItem);
            this.dateiMenu.addSeparator();
            this.dateiMenu.add(this.ladenItem);
            this.dateiMenu.add(this.saveItem);
            this.dateiMenu.add(this.saveunterItem);
            this.dateiMenu.add(this.schliessenItem);
            this.dateiMenu.addSeparator();
            this.dateiMenu.add(this.abLaufItem);
            this.dateiMenu.add(this.druckMenu);
            this.dateiMenu.addSeparator();
            this.dateiMenu.add(this.importItem);
            this.dateiMenu.add(this.exportMenu);
            this.dateiMenu.addSeparator();
            this.dateiMenu.add(this.beendenItem);
        
            this.exportMenu.add(this.lobetMenu);
            this.exportMenu.add(this.textExportMenu);
            this.exportMenu.add(this.htmlExport01Item);
            this.exportMenu.add(this.xmlExport01Item);
        
            this.lobetMenu.add(this.lobetExport03Item);
        
            this.textExportMenu.add(this.textListeExport01Item);
            this.textExportMenu.add(this.textLiedExport01Item);
            this.textExportMenu.add(this.textTextExport01Item);
        
            this.eigeneMenu.add(this.setOwnItem);
            this.eigeneMenu.add(this.chooseOwnItem);
            this.eigeneMenu.add(this.orgOwnItem);
        
            this.lookAndFeelMenu.add(this.grauLAF);
            this.lookAndFeelMenu.add(this.eigeneMenu);
            this.lookAndFeelMenu.addSeparator();
            this.lookAndFeelMenu.add(this.normalLAF);
        
            this.lookAndFeelMenu.add(this.motifLAF);
            this.lookAndFeelMenu.add(this.macLAF);
            this.lookAndFeelMenu.add(this.windowsLAF);
        
            this.optionenMenu.add(this.einstellungenItem);
            this.optionenMenu.add(this.fontloeschenItem);
            this.optionenMenu.add(this.lookAndFeelMenu);
        
            this.bearbMenu.add(this.suchenItem);
            this.bearbMenu.add(this.suchLKItem);
            this.bearbMenu.add(this.suchLOItem);
            this.bearbMenu.addSeparator();
            this.bearbMenu.add(this.suchaaktItem);
            this.bearbMenu.add(this.suchDelItem);
            this.bearbMenu.addSeparator();
            this.bearbMenu.add(this.addStatItem);
            this.bearbMenu.add(this.delStatItem);
        
            this.ansichtMenu.add(this.LIEDItem);
            this.ansichtMenu.add(this.TEXTItem);
            this.ansichtMenu.add(this.BILDItem);
            this.ansichtMenu.add(this.AKTItem);
            this.ansichtMenu.add(this.SUCHItem);
            this.ansichtMenu.addSeparator();
            this.ansichtMenu.add(this.Ansicht1Item);
            this.ansichtMenu.add(this.Ansicht2Item);
            this.ansichtMenu.addSeparator();
            this.ansichtMenu.add(this.vorItem);
            this.ansichtMenu.add(this.diaItem);
        
            this.hilfeMenu.add(this.hilfeItem);
        
            this.hilfeMenu.addSeparator();
            this.hilfeMenu.add(this.gplItem);
            this.hilfeMenu.add(this.ueberItem);
        
            this.menuBar.add(this.dateiMenu);
            this.menuBar.add(this.bearbMenu);
            this.menuBar.add(this.ansichtMenu);
            this.menuBar.add(this.optionenMenu);
            this.menuBar.add(this.hilfeMenu);
        
            setJMenuBar(this.menuBar);
        
            this.neuButton.addActionListener(new MenuActionAdapter(this));
            this.openButton.addActionListener(new MenuActionAdapter(this));
            this.saveButton.addActionListener(new MenuActionAdapter(this));
            this.saveAsButton.addActionListener(new MenuActionAdapter(this));
            this.importButton.addActionListener(new MenuActionAdapter(this));
            this.ablaufplanButton.addActionListener(new MenuActionAdapter(this));
            this.suchButton.addActionListener(new MenuActionAdapter(this));
            this.druckButton.addActionListener(new MenuActionAdapter(this));
            this.startButton.addActionListener(new MenuActionAdapter(this));
            this.diaButton.addActionListener(new MenuActionAdapter(this));
            this.helpButton.addActionListener(new MenuActionAdapter(this));
            this.aboutButton.addActionListener(new MenuActionAdapter(this));
        
            setToolTips(true);
            setIcons(false);
        
            this.desktop = new JDesktopPane();
            this.tisch = new JPanel();
            this.bar = new JToolBar();
        
            this.bar.add(this.neuButton);
            this.bar.add(this.openButton);
            this.bar.add(this.importButton);
            this.bar.add(this.saveButton);
            this.bar.add(this.saveAsButton);
            this.bar.addSeparator();
            this.bar.add(this.ablaufplanButton);
            this.bar.addSeparator();
            this.bar.add(this.suchButton);
        
            this.bar.addSeparator();
            this.bar.add(this.diaButton);
            this.bar.add(this.startButton);
            this.bar.addSeparator();
            this.bar.add(this.helpButton);
            this.bar.add(this.aboutButton);
        
            this.bord = new BorderLayout();
            this.tisch.setLayout(this.bord);
            this.tisch.add("Center", this.desktop);
            this.tisch.add("North", this.bar);
        
            getContentPane().add(this.tisch);
            setVisible(true);
            setStatus(this.status);
            try {
              SwingUtilities.updateComponentTreeUI(this);
            }
            catch (NullPointerException localNullPointerException) {
              System.err.println("Nullpointereception beim Erstellen der GUI. Programm muss neu gestartet werden.");
              JOptionPane.showMessageDialog(this, "Nullpointereception beim Erstellen der GUI. Programm muss neu gestartet werden.", "Nullpointerexception beim Starten", 0, null);
        
              System.exit(-1);
            }
          }
        
          public void setStatus(int paramInt)
          {
            switch (paramInt) {
            case 0:
              this.status = paramInt;
              this.DateiString = "";
              setTitle("LoBeT");
              this.neuItem.setEnabled(true);
              this.ladenItem.setEnabled(true);
              this.saveItem.setEnabled(false);
              this.saveunterItem.setEnabled(false);
              this.schliessenItem.setEnabled(false);
              this.abLaufItem.setEnabled(false);
              this.druckMenu.setEnabled(false);
              this.importItem.setEnabled(false);
              this.exportMenu.setEnabled(false);
              this.beendenItem.setEnabled(true);
        
              this.suchenItem.setEnabled(false);
              this.suchLKItem.setEnabled(false);
              this.suchLOItem.setEnabled(false);
              this.suchaaktItem.setEnabled(false);
              this.suchDelItem.setEnabled(false);
              this.addStatItem.setEnabled(false);
              this.delStatItem.setEnabled(false);
        
              this.LIEDItem.setEnabled(false);
              this.TEXTItem.setEnabled(false);
              this.BILDItem.setEnabled(false);
              this.AKTItem.setEnabled(false);
              this.SUCHItem.setEnabled(false);
              this.Ansicht1Item.setEnabled(false);
              this.Ansicht2Item.setEnabled(false);
              this.vorItem.setEnabled(false);
              this.diaItem.setEnabled(false);
        
              this.einstellungenItem.setEnabled(false);
              this.fontloeschenItem.setEnabled(false);
        
              this.hilfeItem.setEnabled(true);
        
              this.gplItem.setEnabled(true);
              this.ueberItem.setEnabled(true);
        
              this.neuButton.setEnabled(true);
              this.openButton.setEnabled(true);
              this.saveButton.setEnabled(false);
              this.saveAsButton.setEnabled(false);
              this.importButton.setEnabled(false);
              this.ablaufplanButton.setEnabled(false);
              this.suchButton.setEnabled(false);
              this.druckButton.setEnabled(false);
              this.startButton.setEnabled(false);
              this.diaButton.setEnabled(false);
              this.helpButton.setEnabled(true);
              this.aboutButton.setEnabled(true);
              break;
            case 1:
              this.status = paramInt;
              setTitle("LoBeT (" + this.DateiString + ")");
              this.neuItem.setEnabled(false);
              this.ladenItem.setEnabled(false);
              this.saveItem.setEnabled(false);
              this.saveunterItem.setEnabled(true);
              this.schliessenItem.setEnabled(true);
              this.abLaufItem.setEnabled(true);
              this.druckMenu.setEnabled(true);
              this.importItem.setEnabled(true);
              this.exportMenu.setEnabled(true);
              this.beendenItem.setEnabled(true);
        
              this.suchenItem.setEnabled(true);
              this.suchLKItem.setEnabled(true);
              this.suchLOItem.setEnabled(true);
              this.suchaaktItem.setEnabled(true);
              this.suchDelItem.setEnabled(true);
              this.addStatItem.setEnabled(true);
              this.delStatItem.setEnabled(true);
        
              this.LIEDItem.setEnabled(true);
              this.TEXTItem.setEnabled(true);
              this.BILDItem.setEnabled(true);
              this.AKTItem.setEnabled(true);
              this.SUCHItem.setEnabled(true);
              this.Ansicht1Item.setEnabled(true);
              this.Ansicht2Item.setEnabled(true);
              this.vorItem.setEnabled(true);
              this.diaItem.setEnabled(true);
        
              this.einstellungenItem.setEnabled(true);
              this.fontloeschenItem.setEnabled(true);
        
              this.hilfeItem.setEnabled(true);
        
              this.gplItem.setEnabled(true);
              this.ueberItem.setEnabled(true);
        
              this.neuButton.setEnabled(false);
              this.openButton.setEnabled(false);
              this.saveButton.setEnabled(false);
              this.saveAsButton.setEnabled(true);
              this.importButton.setEnabled(true);
              this.ablaufplanButton.setEnabled(true);
              this.suchButton.setEnabled(true);
              this.druckButton.setEnabled(true);
              this.startButton.setEnabled(true);
              this.diaButton.setEnabled(true);
              this.helpButton.setEnabled(true);
              this.aboutButton.setEnabled(true);
              break;
            case 2:
              this.status = paramInt;
              setTitle("LoBeT (" + this.DateiString + ") [Geändert]");
              this.neuItem.setEnabled(false);
              this.ladenItem.setEnabled(false);
              this.saveItem.setEnabled(true);
              this.saveunterItem.setEnabled(true);
              this.schliessenItem.setEnabled(true);
              this.abLaufItem.setEnabled(true);
              this.druckMenu.setEnabled(true);
              this.importItem.setEnabled(true);
              this.exportMenu.setEnabled(true);
              this.beendenItem.setEnabled(true);
        
              this.suchenItem.setEnabled(true);
              this.suchLKItem.setEnabled(true);
              this.suchLOItem.setEnabled(true);
              this.suchaaktItem.setEnabled(true);
              this.suchDelItem.setEnabled(true);
              this.addStatItem.setEnabled(true);
              this.delStatItem.setEnabled(true);
        
              this.LIEDItem.setEnabled(true);
              this.TEXTItem.setEnabled(true);
              this.BILDItem.setEnabled(true);
              this.AKTItem.setEnabled(true);
              this.SUCHItem.setEnabled(true);
              this.Ansicht1Item.setEnabled(true);
              this.Ansicht2Item.setEnabled(true);
              this.vorItem.setEnabled(true);
              this.diaItem.setEnabled(true);
        
              this.einstellungenItem.setEnabled(true);
              this.fontloeschenItem.setEnabled(true);
        
              this.hilfeItem.setEnabled(true);
        
              this.gplItem.setEnabled(true);
              this.ueberItem.setEnabled(true);
        
              this.neuButton.setEnabled(false);
              this.openButton.setEnabled(false);
              this.saveButton.setEnabled(true);
              this.saveAsButton.setEnabled(true);
              this.importButton.setEnabled(true);
              this.ablaufplanButton.setEnabled(true);
              this.suchButton.setEnabled(true);
              this.druckButton.setEnabled(true);
              this.startButton.setEnabled(true);
              this.diaButton.setEnabled(true);
              this.helpButton.setEnabled(true);
              this.aboutButton.setEnabled(true);
              break;
            default:
              setTitle("LoBeT");
              this.neuItem.setEnabled(false);
              this.ladenItem.setEnabled(false);
              this.saveItem.setEnabled(false);
              this.saveunterItem.setEnabled(false);
              this.schliessenItem.setEnabled(false);
              this.abLaufItem.setEnabled(false);
              this.druckMenu.setEnabled(false);
              this.importItem.setEnabled(false);
              this.exportMenu.setEnabled(false);
              this.beendenItem.setEnabled(true);
        
              this.suchenItem.setEnabled(false);
              this.suchLKItem.setEnabled(false);
              this.suchLOItem.setEnabled(false);
              this.suchaaktItem.setEnabled(false);
              this.suchDelItem.setEnabled(false);
              this.addStatItem.setEnabled(false);
              this.delStatItem.setEnabled(false);
        
              this.LIEDItem.setEnabled(false);
              this.TEXTItem.setEnabled(false);
              this.BILDItem.setEnabled(false);
              this.AKTItem.setEnabled(false);
              this.SUCHItem.setEnabled(false);
              this.Ansicht1Item.setEnabled(false);
              this.Ansicht2Item.setEnabled(false);
              this.vorItem.setEnabled(false);
              this.diaItem.setEnabled(false);
        
              this.einstellungenItem.setEnabled(false);
              this.fontloeschenItem.setEnabled(false);
        
              this.hilfeItem.setEnabled(false);
        
              this.gplItem.setEnabled(false);
              this.ueberItem.setEnabled(false);
              this.neuButton.setEnabled(false);
              this.openButton.setEnabled(false);
              this.saveButton.setEnabled(false);
              this.saveAsButton.setEnabled(false);
              this.importButton.setEnabled(false);
              this.ablaufplanButton.setEnabled(false);
              this.suchButton.setEnabled(false);
              this.druckButton.setEnabled(false);
              this.startButton.setEnabled(false);
              this.diaButton.setEnabled(false);
              this.helpButton.setEnabled(false);
              this.aboutButton.setEnabled(false);
            }
          }
        
          void menuEvent(ActionEvent paramActionEvent)
          {
            String str = paramActionEvent.getActionCommand();
            Object localObject = paramActionEvent.getSource();
            if (!this.warten)
              if (localObject == this.beendenItem) {
                ende();
              } else if (localObject == this.ladenItem) {
                oeffneDatei();
              }
              else if (localObject == this.openButton) {
                oeffneDatei();
              }
              else if (localObject == this.neuItem) {
                neu();
              }
              else if (localObject == this.neuButton) {
                neu();
              }
              else if (localObject == this.schliessenItem) {
                schluss();
              }
              else if (localObject == this.saveItem) {
                speichern();
              }
              else if (localObject == this.saveButton) {
                speichern();
              }
              else if (localObject == this.saveunterItem) {
                speichernUnter();
              }
              else if (localObject == this.saveAsButton) {
                speichernUnter();
              }
              else if (localObject == this.ueberItem) {
                ueberLoBeT();
              }
              else if (localObject == this.aboutButton) {
                ueberLoBeT();
              } else if (localObject == this.LIEDItem) {
                this.Lieder.open();
              }
              else if (localObject == this.TEXTItem) {
                this.Texte.open();
              }
              else if (localObject == this.BILDItem) {
                this.Bilder.open();
              }
              else if (localObject == this.AKTItem) {
                this.aktuell.open();
              }
              else if (localObject == this.SUCHItem) {
                this.suchen.open();
              }
              else if (localObject == this.Ansicht1Item) {
                gestaffelt();
              }
              else if (localObject == this.Ansicht2Item) {
                gekachelt();
              }
              else if (localObject == this.einstellungenItem) {
                this.einstell.open(this.jdaten);
              }
              else if (localObject == this.fontloeschenItem) {
                this.jdaten.fontloeschen();
              }
              else if (localObject == this.vorItem) {
                go();
                System.gc();
              }
              else if (localObject == this.startButton) {
                go();
                System.gc();
              }
              else if (localObject == this.grauLAF) {
                lookIt(1);
              }
              else if (localObject == this.normalLAF) {
                lookIt(0);
              }
              else if (localObject == this.motifLAF) {
                lookIt(2);
              }
              else if (localObject == this.macLAF) {
                lookIt(3);
              }
              else if (localObject == this.windowsLAF) {
                lookIt(4);
              } else if (localObject == this.basicLAF) {
                lookIt(6);
              }
              else if (localObject == this.lobetExport01Item) {
                exportieren(0);
              }
              else if (localObject == this.lobetExport02Item) {
                exportieren(1);
              }
              else if (localObject == this.lobetExport03Item) {
                exportieren(2);
              }
              else if (localObject == this.lobetExport04Item) {
                exportieren(3);
              }
              else if (localObject == this.textTextExport01Item) {
                exportieren(4);
              }
              else if (localObject == this.textLiedExport01Item) {
                exportieren(5);
              }
              else if (localObject == this.textListeExport01Item) {
                exportieren(6);
              }
              else if (localObject == this.htmlExport01Item) {
                exportieren(7);
              }
              else if (localObject == this.xmlExport01Item) {
                exportieren(8);
              }
              else if (localObject == this.importItem) {
                importieren();
              }
              else if (localObject == this.importButton) {
                importieren();
              }
              else if (localObject == this.diaItem) {
                diaShow();
              }
              else if (localObject == this.diaButton) {
                diaShow();
              } else if (localObject == this.setOwnItem) {
                setOwn();
              } else if (localObject == this.chooseOwnItem) {
                lookIt(5);
              } else if (localObject == this.orgOwnItem) {
                orgOwn();
              } else if (localObject == this.suchenItem) {
                suchen();
              } else if (localObject == this.suchButton) {
                suchen();
              } else if (localObject == this.suchLKItem) {
                suchen(true);
              } else if (localObject == this.suchLOItem) {
                suchen(false);
              } else if (localObject == this.suchaaktItem) {
                nachSuchen(this.jdaten.dupliAkt());
                this.Lieder.Akt();
                this.aktuell.Akt();
                this.suchen.Akt();
                setStatus(2);
              } else if (localObject == this.suchDelItem) {
                this.jdaten.dupliDel();
                this.Lieder.Akt();
                this.aktuell.Akt();
                this.suchen.Akt();
                setStatus(2);
              } else if (localObject == this.hilfeItem) {
                hilfe();
              } else if (localObject == this.gplItem) {
                hilfe(10);
              } else if (localObject == this.helpButton) {
                hilfe();
              } else if (localObject == this.addStatItem) {
                this.jdaten.addstatistiken();
                setStatus(2);
              } else if (localObject == this.delStatItem) {
                this.jdaten.delstatistiken();
                setStatus(2);
              } else if (localObject == this.druckAblaufItem)
              {
                this.printer.open(6);
                this.printerPreview.open(6);
              } else if (localObject == this.abLaufItem) {
                this.ablauf.open();
                this.d.out("Ablaufplan");
              } else if (localObject == this.ablaufplanButton) {
                this.ablauf.open();
              } else {
                int j = JOptionPane.showConfirmDialog(this, "Das ist noch nicht eingebaut", "allg. Versionsproblem", -1, 1, null);
              }
          }
        
          public void hilfe()
          {
            Hilfe localHilfe = new Hilfe(this);
            this.desktop.add(localHilfe);
            localHilfe.open();
          }
        
          public void noHelp(Hilfe paramHilfe) {
            this.desktop.remove(paramHilfe);
          }
        
          public void hilfe(int paramInt) {
            Hilfe localHilfe = new Hilfe(this, paramInt);
            this.desktop.add(localHilfe);
            localHilfe.open();
          }
        
          public void openPrinter(int paramInt) {
            this.printer.open(paramInt);
            this.printerPreview.open(paramInt);
          }
        
          private void lookIt(int paramInt)
          {
            try
            {
              switch (paramInt) {
              case 0:
                MetalLookAndFeel.setCurrentTheme(this.normal);
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this);
        
                break;
              case 1:
                MetalLookAndFeel.setCurrentTheme(this.grau);
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this);
                break;
              case 2:
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this);
                break;
              case 3:
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.mac.MacLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this);
                break;
              case 4:
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this);
                break;
              case 5:
                MetalLookAndFeel.setCurrentTheme(this.allg);
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this);
                break;
              case 6:
                SwingUtilities.updateComponentTreeUI(this);
              }
            }
            catch (UnsupportedLookAndFeelException localUnsupportedLookAndFeelException)
            {
              System.err.println("This Look & Feel is not supported on this platform.");
              JOptionPane.showMessageDialog(this, "Dieses Look & Feel wird auf dieser Plattform nicht unterstützt.", "Look & Feel", 2);
        
              localUnsupportedLookAndFeelException.printStackTrace();
            } catch (IllegalAccessException localIllegalAccessException) {
              System.err.println("Look & Feel could not be accessed.");
              localIllegalAccessException.printStackTrace();
              JOptionPane.showMessageDialog(this, "Auf dieses Look & Feel konnte nicht zugegriffen werden.", "Look & Feel", 2);
            }
            catch (ClassNotFoundException localClassNotFoundException) {
              System.err.println("Look & Feel could not found.");
              localClassNotFoundException.printStackTrace();
              JOptionPane.showMessageDialog(this, "Dieses Look & Feel wurde nicht gefunden.", "Look & Feel", 2);
            }
            catch (InstantiationException localInstantiationException) {
              System.err.println("Look & Feel could not be instantiated.");
              localInstantiationException.printStackTrace();
              JOptionPane.showMessageDialog(this, "Dieses Look & Feel konnte nicht instantiiert werden.", "Look & Feel", 2);
            }
            catch (Exception localException) {
              System.err.println("Look And Feel konnte nicht geladen werden!");
              JOptionPane.showMessageDialog(this, "Allgemeiner Look & Feel Fehler.", "Look & Feel", 2);
        
              localException.printStackTrace();
            }
          }
        
          private void setOwn() {
            GUIGUI localGUIGUI = new GUIGUI(this, this.allg);
            if (!localGUIGUI.cancel()) {
              this.allg = localGUIGUI.getTheme();
              this.jdaten.getEinstellungen().setAllgMetalTheme(this.allg);
              if (this.status != 0) setStatus(2);
              lookIt(5);
            }
          }
        
          private void go() {
            Bildschirm localBildschirm = new Bildschirm(this, this.jdaten, this.debug);
            this.Lieder.nachSpeichern();
            this.Texte.nachSpeichern();
          }
        
          public void gogo(int paramInt1, int paramInt2)
          {
            Bildschirm localBildschirm = new Bildschirm(this, this.jdaten, paramInt1, paramInt2, this.debug);
            this.Lieder.nachSpeichern();
            this.Texte.nachSpeichern();
          }
        
          public void orgOwn() {
            this.allg = new AllgMetalTheme();
            lookIt(5);
          }
        
          private void neu()
          {
            this.jdaten = new Daten(this.debug);
            this.Lieder = new Schirm(this, this.jdaten, 0, this.debug);
            this.Texte = new Schirm(this, this.jdaten, 1, this.debug);
            this.Bilder = new Schirm(this, this.jdaten, 2, this.debug);
            this.aktuell = new Schirm(this, this.jdaten, 3, this.debug);
            this.suchen = new Schirm(this, this.jdaten, 4, this.debug);
            this.einstell = new EinstellungenGUI(this, this.jdaten, this.debug);
            this.such = new SuchenGUI(this, this.jdaten, this.debug);
            this.ablauf = new AblaufPlanGUI(this, this.jdaten, this.debug);
            this.printer = new PrinterGUI(this, this.jdaten, this.debug);
            this.printerPreview = new PrinterPreviewGUI(this, this.jdaten, this.debug);
        
            this.desktop.add(this.suchen);
            this.desktop.add(this.aktuell);
            this.desktop.add(this.Bilder);
            this.desktop.add(this.Texte);
            this.desktop.add(this.Lieder);
            this.desktop.add(this.einstell);
            this.desktop.add(this.such);
            this.desktop.add(this.ablauf);
            this.desktop.add(this.printer);
            this.desktop.add(this.printerPreview);
            this.Bilder.setVisible(false);
            this.aktuell.setVisible(false);
            this.suchen.setVisible(false);
            this.einstell.setVisible(false);
            this.such.setVisible(false);
            this.ablauf.setVisible(false);
            this.printer.setVisible(false);
            this.printerPreview.setVisible(false);
            this.desktop.setVisible(true);
        
            setVisible(true);
        
            this.file = null;
            this.DateiString = "Unbenannt";
            setStatus(1);
          }
        
          private void schliessen()
          {
            this.Lieder.setVisible(false);
            this.Texte.setVisible(false);
            this.Bilder.setVisible(false);
            this.aktuell.setVisible(false);
            this.suchen.setVisible(false);
            this.einstell.setVisible(false);
            this.such.setVisible(false);
            this.ablauf.setVisible(false);
            this.printer.setVisible(false);
            this.printerPreview.setVisible(false);
        
            this.Lieder.dispose();
            this.Texte.dispose();
            this.Bilder.dispose();
            this.aktuell.dispose();
            this.suchen.dispose();
            this.einstell.dispose();
            this.such.dispose();
            this.ablauf.dispose();
            this.printer.dispose();
            this.printerPreview.dispose();
        
            this.desktop.remove(this.Lieder);
            this.desktop.remove(this.Texte);
            this.desktop.remove(this.Bilder);
            this.desktop.remove(this.aktuell);
            this.desktop.remove(this.suchen);
            this.desktop.remove(this.einstell);
            this.desktop.remove(this.such);
            this.desktop.remove(this.ablauf);
            this.desktop.remove(this.printer);
            this.desktop.remove(this.printerPreview);
        
            this.Lieder = null;
            this.Texte = null;
            this.Bilder = null;
            this.aktuell = null;
            this.suchen = null;
            this.such = null;
            this.ablauf = null;
            this.printer = null;
            this.printerPreview = null;
            this.einstell = null;
            this.jdaten.loeschen();
            this.jdaten = null;
            this.lastFile = null;
        
            setVisible(true);
            this.beenden = false;
            this.schliessen = false;
            this.warten = false;
            this.file = null;
            this.lastFile = null;
            this.DateiString = "";
            setStatus(0);
            SwingUtilities.updateComponentTreeUI(getContentPane());
            System.gc();
          }
        
          public void ende()
          {
            this.beenden = true;
            if (this.status == 2) {
              int j = JOptionPane.showConfirmDialog(this, "Es gibt ungespeicherte Daten\n\nWollen Sie jetzt Speichern?", "Beenden", 1, 2, null);
        
              switch (j) {
              case 0:
                speichern();
        
                break;
              case 1:
                System.exit(0);
                break;
              case 2:
                this.beenden = false;
                break;
              }
            }
            else {
              System.exit(0);
            }
          }
        
          private void schluss()
          {
            this.schliessen = true;
            if (this.status == 2) {
              int j = JOptionPane.showConfirmDialog(this, "Es gibt ungespeicherte Daten\n\nWollen Sie jetzt Speichern?", "Schliessen", 1, 2, null);
        
              switch (j) {
              case 0:
                speichern();
                break;
              case 1:
                schliessen();
                break;
              case 2:
                this.schliessen = false;
                break;
              }
            }
            else {
              schliessen();
            }
          }
        
          private void oeffneDatei()
          {
            this.jdaten = new Daten(this.debug);
            this.Lieder = new Schirm(this, this.jdaten, 0, this.debug);
            this.Texte = new Schirm(this, this.jdaten, 1, this.debug);
            this.Bilder = new Schirm(this, this.jdaten, 2, this.debug);
            this.aktuell = new Schirm(this, this.jdaten, 3, this.debug);
            this.suchen = new Schirm(this, this.jdaten, 4, this.debug);
            this.einstell = new EinstellungenGUI(this, this.jdaten, this.debug);
        
            if (null == this.lastDir)
              this.jfc = new JFileChooser();
            else
              this.jfc = new JFileChooser(this.lastDir);
            this.jfc.setDialogTitle("Öffne LoBeT-Datei");
            this.jfc.addChoosableFileFilter(Schirm.makeFileFilter("LoBeT-Dateien", new String[] { "*.lbt", "*.lxt" }));
            int j = this.jfc.showOpenDialog(this);
            if (j == 0) {
              String str1 = this.jfc.getSelectedFile().getName();
              String str2 = this.jfc.getSelectedFile().getPath();
              String str3 = this.jfc.getSelectedFile().getAbsolutePath();
              this.file = new File(str3);
              if (null != this.file) {
                this.warten = true;
        
                ProgressBarNeuThread localProgressBarNeuThread = new ProgressBarNeuThread(this, this.jdaten, this.file, 1);
                localProgressBarNeuThread.start();
              }
            }
          }
        
          private void speichernUnter()
          {
            this.d.out("Datei speichern unter");
            if (null == this.lastDir)
              this.jfc = new JFileChooser();
            else
              this.jfc = new JFileChooser(this.lastDir);
            this.jfc.setDialogTitle("Speichern Unter");
            this.jfc.addChoosableFileFilter(Schirm.makeFileFilter("LoBeT-Dateien", new String[] { "*.lbt", "*.lxt" }));
            int j = this.jfc.showSaveDialog(this);
            if (j == 0) {
              String str1 = this.jfc.getSelectedFile().getName();
              String str2 = this.jfc.getSelectedFile().getPath();
              String str3 = this.jfc.getSelectedFile().getAbsolutePath();
              if ((!str3.substring(str3.length() - 4).equalsIgnoreCase(".lbt")) && (!str3.substring(str3.length() - 4).equalsIgnoreCase(".lxt")))
                str3 = str3 + ".lbt";
              this.file = new File(str3);
              if (this.file.exists()) {
                this.d.out("Datei existiert schon");
                int k = JOptionPane.showConfirmDialog(this, "Die Datei existiert schon\n\nWollen Sie die Datei überschreiben?", "Speichern unter (überschreiben)", 0, 3, null);
        
                if (k == 0) {
                  this.d.out("Sicherheitskopie anlegen: " + str3 + ".bak");
        
                  this.d.out("Existiert die Sicherung schon?");
                  File localFile = new File(str3 + ".bak");
                  if (localFile.exists()) {
                    this.d.out("Ja, existiert");
                    if (!localFile.delete())
                      this.d.out("Löschen des Backups nicht möglich.");
                    else
                      this.d.out("Backup gelöscht!");
                  }
                  else {
                    this.d.out("Nein, noch nicht!");
                  }
        
                  if (this.file.renameTo(localFile)) {
                    this.d.out("Datei wurde umbenannt");
                    this.backup = true;
                  } else {
                    this.d.out("Die Datei konnte nicht umbenannt werden");
                    JOptionPane.showMessageDialog(this, "Es konnte kein Backup angelegt werden!", "Datei speichern", 2);
                  }
        
                  this.d.out("Datei überschreiben");
                  ProgressBarNeuThread localProgressBarNeuThread2 = new ProgressBarNeuThread(this, this.jdaten, this.file, 0);
                  this.warten = true;
                  localProgressBarNeuThread2.start();
                } else {
                  this.d.out("Datei nicht überschreiben");
                  speichernUnter();
                }
              } else {
                this.d.out("Datei existiert noch nicht");
                ProgressBarNeuThread localProgressBarNeuThread1 = new ProgressBarNeuThread(this, this.jdaten, this.file, 0);
                this.warten = true;
                localProgressBarNeuThread1.start();
              }
            }
          }
        
          private void speichern()
          {
            this.d.out("Datei speichern");
            if (null == this.lastFile) {
              speichernUnter();
            } else {
              this.file = this.lastFile;
              String str = this.file.getAbsolutePath();
              this.d.out("Keine Abfrage; Datei ist schon ausgewählt");
              if (this.backup) {
                this.d.out("Es muss kein Backup mehr angelegt werden");
              } else {
                this.d.out("Sicherheitskopie anlegen: " + str + ".bak");
                this.d.out("Existiert die Sicherung schon?");
                File localObject = new File(str + ".bak");
                if (((File)localObject).exists()) {
                  this.d.out("Ja, existiert");
                  if (!((File)localObject).delete())
                    this.d.out("Löschen des Backups nicht möglich.");
                  else
                    this.d.out("Backup gelöscht!");
                }
                else {
                  this.d.out("Nein, noch nicht!");
                }
                if (this.file.renameTo((File)localObject)) {
                  this.d.out("Datei wurde umbenannt");
                  this.backup = true;
                } else {
                  this.d.out("Die Datei konnte nicht umbenannt werden");
                  JOptionPane.showMessageDialog(this, "Es konnte kein Backup angelegt werden!", "Datei speichern", 2);
                }
        
                this.d.out("Datei überschreiben");
              }
              Object localObject = new ProgressBarNeuThread(this, this.jdaten, this.file, 0);
              this.warten = true;
              ((ProgressBarNeuThread)localObject).start();
            }
          }
        
          public void nachSpeichern(boolean paramBoolean) {
            this.warten = false;
        
            if (paramBoolean) {
              if (this.beenden)
                System.exit(0);
              if (this.schliessen) {
                setStatus(1);
                schliessen();
              } else {
                this.lastFile = this.file;
                this.lastDir = this.file;
                this.DateiString = this.file.getName();
                setStatus(1);
                this.Lieder.nachSpeichern();
                this.Bilder.nachSpeichern();
                this.Texte.nachSpeichern();
                this.aktuell.nachSpeichern();
              }
            }
            else if (this.beenden) {
              System.err.println("Datei konnte nicht geschrieben werden. Programm wird nicht beendet!");
              JOptionPane.showMessageDialog(this, "Datei konnte nicht geschrieben werden.\n\nProgramm wird nicht beendet!", "Datei speichern", 1, null);
        
              this.beenden = false;
            } else if (this.schliessen) {
              this.schliessen = false;
              System.err.println("Datei konnte nicht geschrieben werden. Projekt wird nicht geschlossen!");
              JOptionPane.showMessageDialog(this, "Datei konnte nicht geschrieben werden.\n\nProjekt wird nicht geschlossen!", "Datei speichern", 1, null);
            }
            else
            {
              this.beenden = false;
              this.schliessen = false;
              System.err.println("Datei konnte nicht geschrieben werden.");
              JOptionPane.showMessageDialog(this, "Datei konnte nicht geschrieben werden.", "Datei speichern", 2, null);
            }
        
            this.d.out("Speichern beendet");
          }
        
          public void nachLaden(boolean paramBoolean1, boolean paramBoolean2) {
            this.warten = false;
            if (paramBoolean1) {
              this.lastFile = this.file;
              this.lastDir = this.file;
              this.DateiString = this.file.getName();
              this.allg = this.jdaten.getEinstellungen().getAllgMetalTheme();
              setStatus(1);
              this.such = new SuchenGUI(this, this.jdaten, this.debug);
              this.ablauf = new AblaufPlanGUI(this, this.jdaten, this.debug);
              this.printer = new PrinterGUI(this, this.jdaten, this.debug);
              this.printerPreview = new PrinterPreviewGUI(this, this.jdaten, this.debug);
        
              this.aktuell.setVisible(true);
              this.suchen.setVisible(false);
              this.einstell.setVisible(false);
              this.such.setVisible(false);
              this.ablauf.setVisible(false);
              this.printer.setVisible(false);
              this.printerPreview.setVisible(false);
        
              this.desktop.add(this.suchen);
              this.desktop.add(this.such);
              this.desktop.add(this.ablauf);
              this.desktop.add(this.printer);
              this.desktop.add(this.printerPreview);
              this.desktop.add(this.aktuell);
              this.desktop.add(this.Bilder);
              this.desktop.add(this.Texte);
              this.desktop.add(this.Lieder);
              this.desktop.add(this.einstell);
        
              this.Lieder.nachLaden();
              this.Bilder.nachLaden();
              this.Texte.nachLaden();
              this.aktuell.nachLaden();
              this.ablauf.nachLaden();
              this.printer.nachLaden();
              this.printerPreview.nachLaden();
              Einstellungen localEinstellungen = this.jdaten.getEinstellungen();
              setToolTips(localEinstellungen.getToolTips());
              setIcons(localEinstellungen.getIcons());
        
              this.jdaten.fontloeschen();
              this.desktop.setVisible(true);
        
              setVisible(true);
              this.backup = false;
        
              if (paramBoolean2)
                go();
            } else {
              System.err.println("Datei konnte nicht geladen werden.");
              JOptionPane.showMessageDialog(this, "Datei konnte nicht geladen werden.", "Datei laden", 1, null);
        
              this.jdaten = null;
              this.Lieder = null;
              this.Texte = null;
              this.Bilder = null;
              this.aktuell = null;
              this.suchen = null;
              this.such = null;
              this.ablauf = null;
              this.printer = null;
              this.printerPreview = null;
              this.DateiString = "";
              setStatus(0);
            }
            this.d.out("Laden beendet");
          }
        
          public void nachExport(boolean paramBoolean)
          {
            this.warten = false;
        
            if (paramBoolean) {
              this.Lieder.nachSpeichern();
              this.Bilder.nachSpeichern();
              this.Texte.nachSpeichern();
              this.aktuell.nachSpeichern();
              this.ablauf.nachLaden();
              this.printer.nachLaden();
              this.printerPreview.nachLaden();
            } else {
              System.err.println("Datei konnte nicht geschrieben werden.");
              JOptionPane.showMessageDialog(this, "Datei konnte nicht geschrieben werden.", "Datei speichern", 2, null);
            }
        
            this.d.out("Export beendet");
          }
        
          public void nachImport(boolean paramBoolean) {
            this.warten = false;
        
            if (paramBoolean) {
              this.Lieder.nachLaden();
              this.Bilder.nachLaden();
              this.Texte.nachLaden();
              this.aktuell.nachLaden();
              this.ablauf.nachLaden();
              this.printer.nachLaden();
              this.printerPreview.nachLaden();
            } else {
              System.err.println("Datei konnte nicht gelesen werden.");
              JOptionPane.showMessageDialog(this, "Datei konnte nicht gelesen werden.", "Datei importieren", 2, null);
            }
        
            this.d.out("Import beendet");
          }
        
          private void exportieren(int paramInt)
          {
            this.d.out("Daten exportieren");
            if (null == this.lastDir)
              this.jfc = new JFileChooser();
            else
              this.jfc = new JFileChooser(this.lastDir);
            this.jfc.setDialogTitle("Exportieren");
            switch (paramInt) {
            case 0:
            case 1:
            case 2:
            case 3:
              this.jfc.addChoosableFileFilter(Schirm.makeFileFilter("LoBeT-Dateien", new String[] { "*.lbt", "*.lxt" }));
              break;
            case 4:
              this.jfc.addChoosableFileFilter(Schirm.makeFileFilter("Texte", new String[] { "*.txt" }));
              break;
            case 5:
              this.jfc.addChoosableFileFilter(Schirm.makeFileFilter("Liedtexte", new String[] { "*.txt" }));
              break;
            case 6:
              this.jfc.addChoosableFileFilter(Schirm.makeFileFilter("Liederlisten", new String[] { "*.txt" }));
              break;
            case 7:
              this.jfc.addChoosableFileFilter(Schirm.makeFileFilter("HTML-Dateien", new String[] { "*.html", "*.htm" }));
              break;
            case 8:
              this.jfc.addChoosableFileFilter(Schirm.makeFileFilter("XML-Dateien", new String[] { "*.xml" }));
            }
        
            int j = this.jfc.showSaveDialog(this);
            if (j == 0) {
              String str1 = this.jfc.getSelectedFile().getName();
              String str2 = this.jfc.getSelectedFile().getPath();
              String str3 = this.jfc.getSelectedFile().getAbsolutePath();
              if ((!str3.substring(str3.length() - 4).equalsIgnoreCase(".lbt")) && (!str3.substring(str3.length() - 4).equalsIgnoreCase(".lxt")) && (!str3.substring(str3.length() - 4).equalsIgnoreCase(".txt")) && (!str3.substring(str3.length() - 4).equalsIgnoreCase(".html")) && (!str3.substring(str3.length() - 4).equalsIgnoreCase(".htm")) && (!str3.substring(str3.length() - 4).equalsIgnoreCase(".xml"))) {
                switch (paramInt) {
                case 0:
                case 1:
                case 2:
                case 3:
                  str3 = str3 + ".lbt";
                  break;
                case 4:
                case 5:
                case 6:
                  str3 = str3 + ".txt";
                  break;
                case 7:
                  str3 = str3 + ".html";
                  break;
                case 8:
                  str3 = str3 + ".xml";
                }
              }
        
              this.file = new File(str3);
              if (this.file.exists()) {
                this.d.out("Datei existiert schon");
                int k = JOptionPane.showConfirmDialog(this, "Die Datei existiert schon\n\nWollen Sie die Datei überschreiben?", "Exportieren (Datei überschreiben)", 0, 3, null);
        
                if (k == 0) {
                  this.d.out("Sicherheitskopie anlegen: " + str3 + ".bak");
                  this.d.out("Existiert die Sicherung schon?");
                  File localFile = new File(str3 + ".bak");
                  if (localFile.exists()) {
                    this.d.out("Ja, existiert");
                    if (!localFile.delete())
                      this.d.out("Löschen des Backups nicht möglich.");
                    else
                      this.d.out("Backup gelöscht!");
                  }
                  else {
                    this.d.out("Nein, noch nicht!");
                  }
                  if (this.file.renameTo(localFile)) {
                    this.d.out("Datei wurde umbenannt");
                  } else {
                    this.d.out("Die Datei konnte nicht umbenannt werden");
                    JOptionPane.showMessageDialog(this, "Es konnte kein Backup angelegt werden!", "Datei speichern", 2);
                  }
        
                  this.d.out("Datei überschreiben");
                  ProgressBarNeuThread localProgressBarNeuThread2 = new ProgressBarNeuThread(this, this.jdaten, this.file, 3, paramInt);
                  this.warten = true;
                  localProgressBarNeuThread2.start();
                } else {
                  this.d.out("Datei nicht überschreiben");
                }
              }
              else {
                this.d.out("Datei existiert noch nicht");
                ProgressBarNeuThread localProgressBarNeuThread1 = new ProgressBarNeuThread(this, this.jdaten, this.file, 3, paramInt);
                this.warten = true;
                localProgressBarNeuThread1.start();
              }
            }
          }
        
          public void importieren()
          {
            this.d.out("Daten importieren");
            if (null == this.lastDir)
              this.jfc = new JFileChooser();
            else
              this.jfc = new JFileChooser(this.lastDir);
            this.jfc.setDialogTitle("Importieren");
            this.jfc.addChoosableFileFilter(Schirm.makeFileFilter("XML-Dateien", new String[] { "*.xml" }));
            int j = this.jfc.showOpenDialog(this);
            if (j == 0) {
              String str1 = this.jfc.getSelectedFile().getName();
              String str2 = this.jfc.getSelectedFile().getPath();
              String str3 = this.jfc.getSelectedFile().getAbsolutePath();
              this.file = new File(str3);
              if (this.file.exists()) {
                this.d.out("Datei existiert");
                ProgressBarNeuThread localProgressBarNeuThread = new ProgressBarNeuThread(this, this.jdaten, this.file, 5);
                this.warten = true;
                localProgressBarNeuThread.start();
              } else {
                System.err.println("Datei existiert nicht.");
                JOptionPane.showMessageDialog(this, "Die Datei existiert nicht.", "Datei importieren", 1, null);
              }
            }
          }
        
          public void nachSuchen(boolean paramBoolean)
          {
            if (paramBoolean) {
              this.d.out("Gefunden");
              this.suchen.open();
            } else {
              this.d.out("Leider nichts gefunden");
              JOptionPane.showMessageDialog(this, "Wir konnten nichts finden!", "Suchen", 1);
            }
        
            this.suchen.nachLaden();
            this.Lieder.nachSpeichern();
            this.Bilder.nachSpeichern();
            this.Texte.nachSpeichern();
            this.aktuell.nachSpeichern();
            this.d.out("Suchen beendet");
          }
        
          public void einstell()
          {
            this.Lieder.nachLaden();
            this.Bilder.nachLaden();
            this.Texte.nachLaden();
            this.aktuell.nachLaden();
            this.suchen.nachLaden();
            this.ablauf.nachLaden();
            this.printer.nachLaden();
            this.printerPreview.nachLaden();
            Einstellungen localEinstellungen = this.jdaten.getEinstellungen();
            setToolTips(localEinstellungen.getToolTips());
            setIcons(localEinstellungen.getIcons());
          }
        
          private void setToolTips(boolean paramBoolean)
          {
            if (paramBoolean) {
              this.neuButton.setToolTipText("Neues Projekt");
              this.openButton.setToolTipText("Projekt öffnen");
              this.saveButton.setToolTipText("Projekt speichern");
              this.saveAsButton.setToolTipText("Projekt speichern unter");
              this.importButton.setToolTipText("XMLDaten importieren");
              this.ablaufplanButton.setToolTipText("Ablaufplan bearbeiten");
              this.suchButton.setToolTipText("Suchen");
              this.druckButton.setToolTipText("Drucken");
              this.startButton.setToolTipText("Vorführung starten");
              this.diaButton.setToolTipText("Diavorführung starten");
              this.helpButton.setToolTipText("Hilfe");
              this.aboutButton.setToolTipText("Über LoBeT");
            } else {
              this.neuButton.setToolTipText(null);
              this.openButton.setToolTipText(null);
              this.saveButton.setToolTipText(null);
              this.saveAsButton.setToolTipText(null);
              this.importButton.setToolTipText(null);
              this.ablaufplanButton.setToolTipText(null);
              this.suchButton.setToolTipText(null);
              this.druckButton.setToolTipText(null);
              this.startButton.setToolTipText(null);
              this.diaButton.setToolTipText(null);
              this.helpButton.setToolTipText(null);
              this.aboutButton.setToolTipText(null);
            }
          }
        
          private void setIcons(boolean paramBoolean) {
            if (paramBoolean)
            {
              this.neuButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/New24.gif")));
              this.openButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Open24.gif")));
              this.saveButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Save24.gif")));
              this.saveAsButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/SaveAs24.gif")));
              this.importButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Import24.gif")));
              this.ablaufplanButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/History24.gif")));
              this.suchButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Search24.gif")));
              this.druckButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Print24.gif")));
              this.startButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Play24.gif")));
              this.diaButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Movie24.gif")));
              this.helpButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Help24.gif")));
              this.aboutButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/About24.gif")));
            }
            else {
              this.neuButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/New16.gif")));
              this.openButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Open16.gif")));
              this.saveButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Save16.gif")));
              this.saveAsButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/SaveAs16.gif")));
              this.importButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Import16.gif")));
              this.ablaufplanButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/History16.gif")));
              this.suchButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Search16.gif")));
              this.druckButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Print16.gif")));
              this.startButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Play16.gif")));
              this.diaButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Movie16.gif")));
              this.helpButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/Help16.gif")));
              this.aboutButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/About16.gif")));
            }
          }
        
          private void ueberLoBeT()
          {
            String str= "LobpreisBeamerTexter\n \nAutor: Sebastian Müller\nEMail: LoBeT@sebamueller.de\nHomepage: www.sebamueller.de\n\nCopyright 2013\n\nLizenz: GPL\n" + this.VERSION;
            if (status != 0) {
              str += "\nDateiversion: " + this.jdaten.getDateiVersion();
            }
        
            int j = JOptionPane.showConfirmDialog(this, str, "Über LoBeT", -1, 1, null);
          }
        
          public String version()
          {
            return this.VERSION;
          }
        
          private void suchen() {
            this.such.open();
          }
        
          private void suchen(boolean paramBoolean) {
            Suchen localSuchen = new Suchen(paramBoolean);
            ProgressBarNeuThread localProgressBarNeuThread = new ProgressBarNeuThread(this, this.jdaten, localSuchen);
            localProgressBarNeuThread.run();
          }
        
          private void diaShow()
          {
            this.jfc = new JFileChooser();
            this.jfc.setDialogTitle("Bilder für Diashow auswählen");
            this.jfc.addChoosableFileFilter(Schirm.makeFileFilter("Bilder", new String[] { "*.jpg", "*.gif", "*.png" }));
            this.jfc.setMultiSelectionEnabled(true);
            int j = this.jfc.showOpenDialog(this);
            if (j == 0) {
              File[] arrayOfFile = this.jfc.getSelectedFiles();
              this.d.out("Diashow; Dateinamen:");
              if (this.debug) {
                for (int k = 0; k < arrayOfFile.length; k++) {
                  File localFile = arrayOfFile[k];
                  String str1 = localFile.getName();
                  String str2 = localFile.getPath();
                  String str3 = localFile.getAbsolutePath();
                  this.d.out(str1);
                  this.d.out(str3);
                }
              }
              if (arrayOfFile.length > 0) {
                DiaThread localDiaThread = new DiaThread(this, this.jdaten, this.debug);
                DiaShow localDiaShow = new DiaShow(localDiaThread, this, this.jdaten, this.debug, arrayOfFile);
              }
            }
          }
        
          private void gestaffelt()
          {
            this.Lieder.staffel();
            this.Texte.staffel();
            this.Bilder.staffel();
            this.aktuell.staffel();
            this.suchen.staffel();
          }
        
          private void gekachelt() {
            int j = this.desktop.getSize().width;
            int k = this.desktop.getSize().height;
        
            int n = 0;
            boolean[] arrayOfBoolean = new boolean[5];
            Schirm[] arrayOfSchirm = new Schirm[5];
        
            for (int m = 0; m < 5; m++) {
              arrayOfBoolean[m] = false;
            }
            arrayOfSchirm[0] = this.Lieder;
            arrayOfSchirm[1] = this.Texte;
            arrayOfSchirm[2] = this.Bilder;
            arrayOfSchirm[3] = this.aktuell;
            arrayOfSchirm[4] = this.suchen;
        
            for (int m = 0; m < 5; m++) {
              if (arrayOfSchirm[m].isVisible()) {
                n++;
                arrayOfBoolean[m] = true;
              }
            }
            //m = 0;
            switch (n)
               {
                case 0:
                 break;
             case 1:
                {
              for (int m = 0; m < 5; ) {
                if (arrayOfBoolean[m] ){
                  arrayOfSchirm[m].kachel(0, 0, j, k);
                  m++;
                    continue;
                } 
                while (!arrayOfBoolean[m])
                  m++;

//                arrayOfSchirm[m].kachel(0, 0, j / 2, k);
//                m++;
//                while (!arrayOfBoolean[m] )
//                  m++;
//                arrayOfSchirm[m].kachel(j / 2, 0, j / 2, k);
//                break;
//
///*  
//                while (!arrayOfBoolean[m])
//                  m++;
//                arrayOfSchirm[m].kachel(0, 0, j / 2, k / 2);
//                m++;
//                while (!arrayOfBoolean[m])
//                  m++;
//                arrayOfSchirm[m].kachel(j / 2, 0, j / 2, k / 2);
//                m++;
//                while (!arrayOfBoolean[m])
//                  m++;
//                arrayOfSchirm[m].kachel(0, k / 2, j, k / 2);
//                break;
//        
//                while (!arrayOfBoolean[m])
//                  m++;
//                arrayOfSchirm[m].kachel(0, 0, j / 2, k / 2);
//                m++;
//                while (!arrayOfBoolean[m])
//                  m++;
//                arrayOfSchirm[m].kachel(j / 2, 0, j / 2, k / 2);
//                m++;
//                while (!arrayOfBoolean[m])
//                  m++;
//                arrayOfSchirm[m].kachel(0, k / 2, j / 2, k / 2);
//                m++;
//                while (!arrayOfBoolean[m])
//                  m++;
//                arrayOfSchirm[m].kachel(j / 2, k / 2, j / 2, k / 2);
//                break;
//     */ 
                this.Lieder.kachel(j, k);
                this.Texte.kachel(j, k);
                this.Bilder.kachel(j, k);
                this.aktuell.kachel(j, k);
                this.suchen.kachel(j, k);
              }
                }
                case 2:
            case 3:
            case 4:
            case 5: } 
          }
        
          public void nachAkt() {
            this.aktuell.Akt();
            this.suchen.Akt();
            setStatus(2);
          }
        }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     LoBeT
 * JD-Core Version:    0.6.0
 */