/*     */ import java.awt.Container;
/*     */ import java.awt.Dimension;
/*     */ import java.awt.Font;
/*     */ import java.awt.FontMetrics;
/*     */ import java.awt.Graphics;
/*     */ import java.awt.Graphics2D;
/*     */ import java.awt.GraphicsDevice;
/*     */ import java.awt.GraphicsEnvironment;
/*     */ import java.awt.IllegalComponentStateException;
/*     */ import java.awt.Toolkit;
/*     */ import java.awt.image.BufferedImage;
/*     */ import java.io.PrintStream;
/*     */ import javax.swing.JFrame;
/*     */ 
/*     */ public class NewstickerBildschirm extends JFrame
/*     */ {
/*     */   public static final long serialVersionUID = 1L;
/*   9 */   private Debug d = new Debug(true);
/*     */   private Newsticker nt;
/*     */   private LoBeT l;
/*     */   private Bildschirm b;
/*     */   private DiaShow dia;
/*  14 */   private int warten = 50;
/*     */ 
/*  16 */   private int maxFont = 200;
/*  17 */   private boolean maxFontSchon = false;
/*     */   private int hoehe;
/*  19 */   private int breite = 0;
/*     */   private boolean cd;
/*  20 */   private boolean ticker = false;
/*     */ 
/*  22 */   private Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
/*     */ 
/*  25 */   private boolean neu = false;
/*     */   private Container content;
/*     */   private Graphics comp2d;
/*     */   private BufferedImage leinwand;
/*     */   private BufferedImage logoBild;
/*     */   private BildschirmZeichnen zeichnen;
/*  33 */   private int x = this.screen.width; private int y = this.screen.height;
/*     */   private int maxOber;
/*     */   private int maxUnter;
/*     */   private Graphics2D g;
/*     */   private FontMetrics fm;
/*     */   private FontMetrics fmc;
/*     */   private Font f;
/*     */   private Font fc;
/*  41 */   private int maxLength = 0;
/*  42 */   private int von = this.x;
/*  43 */   private int bis = 0;
/*  44 */   private int wo = this.von;
/*     */   private int speed;
/*  46 */   private int jetzt = 0;
/*  47 */   private int wann = 0;
/*     */   private long startzeit;
/*     */   private long jetztzeit;
/*     */   private long weiterzeit;
/*     */   private long zeit;
/*     */   private long endzeit;
/*  53 */   private boolean cduhrzeit = false;
/*     */ 
/*     */   private void datenUbertragen() {
/*  56 */     this.cd = this.nt.CDisEnabled();
/*  57 */     this.ticker = this.nt.TickerisEnabled();
/*  58 */     this.speed = this.nt.getSpeed();
/*  59 */     this.wann = (10000 / ((this.speed + 1) * 10));
/*  60 */     this.zeit = (this.nt.getCountdown() + 1000L);
/*  61 */     this.warten = this.nt.getMilli();
/*  62 */     this.cduhrzeit = this.nt.isUhrzeit();
/*  63 */     this.endzeit = this.nt.getEndzeit();
/*     */   }
/*     */ 
/*     */   public NewstickerBildschirm(Bildschirm paramBildschirm, Newsticker paramNewsticker, LoBeT paramLoBeT, boolean paramBoolean) {
/*  67 */     super("LoBeT-Newsticker");
/*  68 */     this.nt = paramNewsticker;
/*  69 */     this.b = paramBildschirm;
/*  70 */     this.dia = null;
/*  71 */     datenUbertragen();
/*  72 */     this.d = new Debug(paramBoolean);
/*  73 */     this.l = paramLoBeT;
/*  74 */     starten();
/*     */   }
/*     */ 
/*     */   public NewstickerBildschirm(DiaShow paramDiaShow, Newsticker paramNewsticker, LoBeT paramLoBeT, boolean paramBoolean)
/*     */   {
/*  79 */     setTitle("LoBeT-Newsticker");
/*  80 */     setVisible(false);
/*  81 */     this.nt = paramNewsticker;
/*  82 */     this.b = null;
/*  83 */     this.dia = paramDiaShow;
/*  84 */     datenUbertragen();
/*  85 */     this.d = new Debug(paramBoolean);
/*  86 */     this.l = paramLoBeT;
/*  87 */     starten();
/*     */   }
/*     */ 
/*     */   public void starten() {
/*  91 */     if ((this.cd) || (this.ticker)) {
/*  92 */       create();
/*     */ 
/*  94 */       setVisible(false);
/*     */     } else {
/*  96 */       close();
/*  97 */       ende();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void create()
/*     */   {
/* 103 */     this.d.out("Creation von Newsticker Beginn");
/*     */     try
/*     */     {
/* 106 */       if (isDisplayable())
/* 107 */         System.err.println("Newsticker ist displayable und damit k�nnen wir es nicht umdekorieren...");
/*     */       else
/* 109 */         setUndecorated(true);
/*     */     }
/*     */     catch (IllegalComponentStateException localIllegalComponentStateException)
/*     */     {
/* 113 */       System.err.println("Warnung: Konnte Fenster nicht undekoriert machen");
/* 114 */       localIllegalComponentStateException.printStackTrace();
/*     */     }
/*     */ 
/* 122 */     this.breite = this.x;
/*     */ 
/* 126 */     String str1 = Newsticker.fontNamen[this.nt.getFont()];
/* 127 */     String str2 = Newsticker.fontNamen[this.nt.getCDFont()];
/* 128 */     this.d.out("Fontnamen: " + str1 + "-" + str2);
/* 129 */     int i = 0;
/* 130 */     int j = this.nt.getSize();
/* 131 */     this.d.out("org. Fontstring, fontBold, fontSize: " + str1 + " " + i + " " + j);
/* 132 */     this.f = new Font(str1, i, j);
/*     */ 
/* 134 */     this.fc = new Font(str2, i, j);
/* 135 */     this.fm = getFontMetrics(this.f);
/* 136 */     this.fmc = getFontMetrics(this.fc);
/* 137 */     this.hoehe = this.fm.getHeight();
/* 138 */     this.maxOber = this.fm.getMaxAscent();
/* 139 */     this.maxUnter = this.fm.getMaxDescent();
/* 140 */     this.maxLength = this.fm.stringWidth(this.nt.getText());
/* 141 */     this.bis = (-1 * this.maxLength);
/* 142 */     this.wo = this.von;
/* 143 */     this.von = 0;
/*     */ 
/* 145 */     int k = 0;
/* 146 */     int m = 0;
/* 147 */     switch (this.nt.getPosition()) { case 0:
/*     */     case 1:
/* 149 */       m = 0; break;
/*     */     case 2:
/*     */     case 3:
/* 151 */       m = (this.y - (this.hoehe + this.maxUnter)) / 2; break;
/*     */     case 4:
/*     */     case 5:
/* 153 */       m = this.y - (this.hoehe + this.maxUnter);
/*     */     }
/*     */ 
/* 156 */     setLocation(k, m);
/* 157 */     this.d.out("Höhe: " + this.hoehe + " Breite: " + this.breite + " MaxOber: " + this.maxOber + " MaxUnter: " + this.maxUnter);
/*     */ 
/* 159 */     this.leinwand = new BufferedImage(this.breite, this.hoehe, 1);
/* 160 */     this.g = this.leinwand.createGraphics();
/* 161 */     this.g.setBackground(this.nt.getHinterFarbe());
/* 162 */     this.g.setColor(this.nt.getHinterFarbe());
/* 163 */     this.g.fillRect(0, 0, this.breite, this.hoehe + this.maxUnter);
/* 164 */     this.g.setColor(this.nt.getTextFarbe());
/*     */ 
/* 166 */     this.g.setFont(this.f);
/*     */ 
/* 169 */     setSize(new Dimension(this.breite, this.hoehe));
/*     */ 
/* 174 */     this.zeichnen = new BildschirmZeichnen(this.breite, this.hoehe, this.l);
/* 175 */     GraphicsDevice localGraphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
/*     */ 
/* 177 */     setResizable(false);
/*     */ 
/* 179 */     this.content = getContentPane();
/*     */ 
/* 181 */     this.content.add(this.zeichnen);
/*     */ 
/* 185 */     this.d.out("Ausgabe Newsticker");
/* 186 */     this.zeichnen.maleBild(this.leinwand);
/* 187 */     ausgabeBildschirm();
/*     */ 
/* 189 */     repaint();
/* 190 */     setDefaultCloseOperation(0);
/*     */ 
/* 192 */     this.startzeit = System.currentTimeMillis();
/* 193 */     this.weiterzeit = System.currentTimeMillis();
/* 194 */     this.d.out("Creation von Newsticker Ende");
/*     */   }
/*     */ 
/*     */   private void ausgabeBildschirm()
/*     */   {
/* 199 */     this.b.maleNewsticker(this, this.nt);
/*     */   }
/*     */ 
/*     */   public void close() {
/* 203 */     this.zeichnen.close();
/* 204 */     this.leinwand.flush();
/* 205 */     this.d.out("Newsticker: Wir haben geschlossen");
/* 206 */     if (null != this.b) this.b.schwarzBlenden();
/* 207 */     if (null != this.dia) this.dia.schwarzBlenden(); 
/*     */   }
/*     */ 
/*     */   public void ende()
/*     */   {
/* 211 */     setVisible(false);
/* 212 */     if (null != this.b) this.b.NewstickerEnde(true);
/* 213 */     if (null != this.dia) this.dia.NewstickerEnde(true);
/* 214 */     dispose();
/* 215 */     this.d.out("Newsticker: Wir haben beendet");
/*     */   }
/*     */ 
/*     */   public boolean getNew() {
/* 219 */     return this.neu;
/*     */   }
/*     */ 
/*     */   private boolean veraendert() {
/* 223 */     this.neu = true;
/* 224 */     return this.neu;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 229 */     this.jetztzeit = System.currentTimeMillis();
/* 230 */     long l1 = this.jetztzeit - this.weiterzeit;
/* 231 */     this.weiterzeit = System.currentTimeMillis();
/* 232 */     int k = 0;
/* 233 */     String str1 = "";
/* 234 */     String str2 = "";
/* 235 */     String str3 = "";
/* 236 */     String str4 = "";
/*     */ 
/* 239 */     if (this.ticker)
/*     */     {
/* 247 */       this.g.setFont(this.f);
/* 248 */       this.wo -= (int)(f(this.speed) * l1 / this.warten);
/*     */ 
/* 250 */       if (this.wo < this.bis) this.wo = this.von;
/* 251 */       this.g.setColor(this.nt.getHinterFarbe());
/* 252 */       this.g.fillRect(0, 0, this.breite, this.hoehe);
/* 253 */       this.g.setColor(this.nt.getTextFarbe());
/* 254 */       this.g.drawString(this.nt.getText(), this.wo, this.hoehe - this.maxUnter);
/* 255 */       if (this.wo < this.bis + this.x) {
/* 256 */         this.g.drawString(this.nt.getText(), this.wo + this.maxLength, this.hoehe - this.maxUnter);
/*     */       }
/*     */     }
/* 259 */     if (this.cd)
/*     */     {
/* 263 */       long l2 = this.startzeit + this.zeit - this.jetztzeit;
/* 264 */       if (this.cduhrzeit)
/* 265 */         l2 = this.endzeit - this.jetztzeit;
/* 266 */       if (l2 < 1000L) {
/* 267 */         close();
/* 268 */         ende();
/*     */       }
/* 270 */       int i = (int)l2 / 3600000;
/* 271 */       int j = (int)(l2 - i * 3600000) / 60000;
/* 272 */       k = (int)(l2 - i * 3600000 - j * 60000) / 1000;
/* 273 */       if (k < 10) str2 = "0" + k; else str2 = "" + k;
/* 274 */       if (j < 10) str3 = "0" + j; else str3 = "" + j;
/* 275 */       str4 = "" + i;
/* 276 */       if (i > 0) str1 = str4 + ":" + str3 + ":" + str2; else str1 = str3 + ":" + str2;
/* 277 */       this.g.setFont(this.fc);
/* 278 */       int m = this.fmc.stringWidth(str1);
/* 279 */       int n = 0;
/* 280 */       int i1 = 0;
/* 281 */       if (this.ticker) {
/* 282 */         switch (this.nt.getPosition()) { case 0:
/* 283 */           n = 0; break;
/*     */         case 1:
/* 284 */           n = this.x - m; break;
/*     */         case 2:
/* 285 */           n = 0; break;
/*     */         case 3:
/* 286 */           n = this.x - m; break;
/*     */         case 4:
/* 287 */           n = 0; break;
/*     */         case 5:
/* 288 */           n = this.x - m;
/*     */         }
/* 290 */         this.g.setColor(this.nt.getHinterFarbe());
/* 291 */         this.g.fillRect(n, 0, n + m, this.hoehe + this.maxUnter);
/* 292 */         this.g.setColor(this.nt.getTextFarbe());
/* 293 */         this.g.drawString(str1, n, this.hoehe - this.maxUnter);
/*     */       }
/*     */       else {
/* 296 */         switch (this.nt.getPosition()) { case 0:
/* 297 */           i1 = 0; n = 0; break;
/*     */         case 4:
/* 298 */           i1 = this.y - (this.hoehe + this.maxUnter); n = 0; break;
/*     */         case 2:
/*     */         case 3:
/* 300 */           n = (this.x - m) / 2; i1 = (this.y - (this.hoehe + this.maxUnter)) / 2; break;
/*     */         case 1:
/* 301 */           i1 = 0; n = this.x - m; break;
/*     */         case 5:
/* 302 */           i1 = this.y - (this.hoehe + this.maxUnter); n = this.x - m;
/*     */         }
/* 304 */         this.g.setColor(this.nt.getHinterFarbe());
/* 305 */         this.g.fillRect(0, 0, n + m, this.hoehe + this.maxUnter);
/* 306 */         this.g.setColor(this.nt.getTextFarbe());
/* 307 */         this.g.drawString(str1, 0, this.hoehe - this.maxUnter);
/* 308 */         setBounds(n, i1, m, this.hoehe);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 313 */     ausgabeBildschirm();
/*     */   }
/*     */ 
/*     */   private void OK()
/*     */   {
/* 319 */     this.d.out("Die Returntaste wurde gedrückt!");
/* 320 */     this.d.out("Die Zusatzzahl: ");
/*     */   }
/*     */ 
/*     */   public static int f(int paramInt) {
/* 324 */     switch (paramInt) { case 0:
/* 325 */       return 1;
/*     */     case 1:
/* 326 */       return 2;
/*     */     case 2:
/* 327 */       return 5;
/*     */     case 3:
/* 328 */       return 10;
/*     */     case 4:
/* 329 */       return 30;
/*     */     case 5:
/* 330 */       return 50;
/*     */     case 6:
/* 331 */       return 80;
/*     */     case 7:
/* 332 */       return 100;
/*     */     }
/* 334 */     return 1;
/*     */   }
/*     */ }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     NewstickerBildschirm
 * JD-Core Version:    0.6.0
 */