/*     */ import java.awt.Container;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.awt.event.KeyEvent;
/*     */ import java.io.PrintStream;
/*     */ import java.util.Arrays;
/*     */ import java.util.List;
/*     */ import javax.print.DocFlavor;
/*     */ import javax.print.DocFlavor.SERVICE_FORMATTED;
/*     */ import javax.print.DocPrintJob;
/*     */ import javax.print.PrintException;
/*     */ import javax.print.PrintService;
/*     */ import javax.print.PrintServiceLookup;
/*     */ import javax.print.ServiceUI;
/*     */ import javax.print.SimpleDoc;
/*     */ import javax.print.attribute.Attribute;
/*     */ import javax.print.attribute.HashPrintRequestAttributeSet;
/*     */ import javax.print.attribute.PrintRequestAttributeSet;
/*     */ import javax.print.attribute.PrintServiceAttributeSet;
/*     */ import javax.print.attribute.standard.MediaSizeName;
/*     */ import javax.swing.ImageIcon;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JComboBox;
/*     */ import javax.swing.JInternalFrame;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JOptionPane;
/*     */ import javax.swing.JPanel;
/*     */ import javax.swing.border.EmptyBorder;
/*     */ import javax.swing.border.LineBorder;
/*     */ 
/*     */ public class PrinterPreviewGUI extends JInternalFrame
/*     */ {
/*     */   public static final long serialVersionUID = 1L;
/*     */   public static final int LIED = 1;
/*     */   public static final int TEXT = 2;
/*     */   public static final int LIEDLISTE = 3;
/*     */   public static final int TEXTLISTE = 4;
/*     */   public static final int AKTLISTE = 5;
/*     */   public static final int ABLAUFPLAN = 6;
/*  21 */   final String sCrLf = System.getProperty("line.separator");
/*  22 */   final String sPrintFile = "PrintFile.ps";
/*  23 */   final String sErrNoPrintService = new StringBuilder().append(this.sCrLf).append("Es ist kein passender Print-Service installiert.").toString();
/*     */ 
/*  25 */   private String titel = "";
/*  26 */   String s2ndParm = null;
/*     */ 
/*  28 */   DocFlavor flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
/*  29 */   PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
/*     */ 
/*  31 */   PrintService prservDflt = PrintServiceLookup.lookupDefaultPrintService();
/*  32 */   PrintService[] prservices = PrintServiceLookup.lookupPrintServices(this.flavor, this.aset);
/*     */ 
/*  34 */   PrintService prserv = null;
/*     */ 
/*  36 */   private Debug d = new Debug(false);
/*  37 */   private boolean debug = false;
/*     */ 
/*  40 */   private JPanel mainPanel = new JPanel();
/*  41 */   private JPanel wasPanel = new JPanel();
/*  42 */   private JPanel druckPanel = new JPanel();
/*     */ 
/*  45 */   private EmptyBorder border5 = new EmptyBorder(5, 5, 5, 5);
/*     */   private GridBagConstraints constraints;
/*     */   private GridBagLayout gridbag;
/*  52 */   private JLabel titelLabel = new JLabel("Drucken");
/*  53 */   private JLabel uSchriftLabel = new JLabel("Überschrift");
/*  54 */   private JLabel nSchriftLabel = new JLabel("normal");
/*  55 */   private JLabel sSizeLabel = new JLabel("Schriftgröße: ");
/*  56 */   private JLabel sArtLabel = new JLabel("Schriftart: ");
/*  57 */   private JLabel leerLabel = new JLabel("  ");
/*     */ 
/*  61 */   private JButton okButton = new JButton("Drucken");
/*  62 */   private JButton cancelButton = new JButton("Abbrechen");
/*  63 */   private JButton aktuellButton = new JButton("Aktuell-Liste hinzufügen");
/*  64 */   private JButton helpButton = new JButton();
/*  65 */   private JButton pageButton = new JButton();
/*  66 */   private JButton prevButton = new JButton();
/*     */ 
/*  69 */   private JComboBox uFontSize = new JComboBox();
/*  70 */   private JComboBox normalFontSize = new JComboBox();
/*  71 */   private JComboBox uFontArt = new JComboBox();
/*  72 */   private JComboBox normalFontArt = new JComboBox();
/*     */   private Daten daten;
/*     */   private LoBeT lobet;
/*     */   private Einstellungen einstellungen;
/*     */   private int typ;
/*     */ 
/*     */   public PrinterPreviewGUI(LoBeT paramLoBeT, Daten paramDaten, boolean paramBoolean)
/*     */   {
/*  83 */     this.d = new Debug(paramBoolean);
/*  84 */     this.debug = paramBoolean;
/*  85 */     setTitle("Drucken");
/*  86 */     this.daten = paramDaten;
/*  87 */     this.einstellungen = paramDaten.getEinstellungen();
/*  88 */     this.lobet = paramLoBeT;
/*  89 */     int i = paramDaten.getEinstellungen().getSeitenFontSize();
/*  90 */     setBounds(0, 0, 480, 400);
/*  91 */     initGUI();
/*  92 */     init();
/*  93 */     create();
/*  94 */     setResizable(true);
/*  95 */     setMaximizable(true);
/*  96 */     setIconifiable(true);
/*  97 */     setClosable(true);
/*  98 */     setVisible(true);
/*     */   }
/*     */ 
/*     */   public void init()
/*     */   {
/* 107 */     this.einstellungen = this.daten.getEinstellungen();
/* 108 */     switch (this.typ) {
/*     */     case 6:
/* 110 */       this.titelLabel.setText("Ablauf drucken");
/* 111 */       break;
/*     */     case 1:
/* 113 */       this.titelLabel.setText("Lied drucken");
/* 114 */       break;
/*     */     default:
/* 116 */       this.titelLabel.setText("Etwas drucken");
/*     */     }
/* 118 */     PrintSetupValues localPrintSetupValues = this.einstellungen.getPrintSetupValues();
/* 119 */     this.uFontSize.setSelectedIndex(localPrintSetupValues.getUeberschriftFontSize() - 1);
/* 120 */     this.normalFontSize.setSelectedIndex(localPrintSetupValues.getNormalFontSize() - 1);
/* 121 */     this.uFontArt.setSelectedIndex(localPrintSetupValues.getUeberschriftFontArt());
/* 122 */     this.normalFontArt.setSelectedIndex(localPrintSetupValues.getNormalFontArt());
/*     */   }
/*     */ 
/*     */   public void initGUI()
/*     */   {
/* 134 */     this.okButton.addActionListener(new PrinterPreviewGUIActionAdapter(this));
/* 135 */     this.cancelButton.addActionListener(new PrinterPreviewGUIActionAdapter(this));
/* 136 */     this.helpButton.addActionListener(new PrinterPreviewGUIActionAdapter(this));
/* 137 */     this.prevButton.addActionListener(new PrinterPreviewGUIActionAdapter(this));
/* 138 */     this.pageButton.addActionListener(new PrinterPreviewGUIActionAdapter(this));
/*     */ 
/* 140 */     for (int i = 1; i < 151; i++) {
/* 141 */       this.uFontSize.addItem(new StringBuilder().append("").append(i).toString());
/* 142 */       this.normalFontSize.addItem(new StringBuilder().append("").append(i).toString());
/*     */     }
/* 144 */     this.uFontSize.setSelectedIndex(13);
/* 145 */     this.normalFontSize.setSelectedIndex(11);
/* 146 */     TextEinstellungen localTextEinstellungen = this.einstellungen.getTextEinstellungen();
/* 147 */     for (int i = 0; i < 6; i++) {
/* 148 */       this.uFontArt.addItem(TextEinstellungen.fontNamen[i]);
/* 149 */       this.normalFontArt.addItem(TextEinstellungen.fontNamen[i]);
/*     */     }
/* 151 */     this.uFontArt.setSelectedIndex(4);
/* 152 */     this.normalFontArt.setSelectedIndex(4);
/*     */ 
/* 154 */     setIcons(this.einstellungen.getIcons());
/* 155 */     setToolTips(this.einstellungen.getToolTips());
/* 156 */     RadioButtonsInit();
/*     */ 
/* 158 */     this.aset.add(MediaSizeName.ISO_A4);
/*     */   }
/*     */ 
/*     */   public void create()
/*     */   {
/* 164 */     setDefaultCloseOperation(1);
/*     */ 
/* 166 */     this.gridbag = new GridBagLayout();
/* 167 */     this.constraints = new GridBagConstraints();
/*     */ 
/* 170 */     this.mainPanel.setLayout(this.gridbag);
/* 171 */     this.wasPanel.setLayout(this.gridbag);
/* 172 */     this.druckPanel.setLayout(this.gridbag);
/*     */ 
/* 175 */     constr(0, 0, 2, 1);
/* 176 */     this.constraints.fill = 1;
/* 177 */     this.gridbag.setConstraints(this.titelLabel, this.constraints);
/* 178 */     this.wasPanel.add(this.titelLabel);
/*     */ 
/* 180 */     constr(1, 1, 1, 1);
/* 181 */     this.constraints.fill = 1;
/* 182 */     this.gridbag.setConstraints(this.uSchriftLabel, this.constraints);
/* 183 */     this.wasPanel.add(this.uSchriftLabel);
/*     */ 
/* 185 */     constr(2, 1, 1, 1);
/* 186 */     this.constraints.fill = 1;
/* 187 */     this.gridbag.setConstraints(this.leerLabel, this.constraints);
/* 188 */     this.wasPanel.add(this.leerLabel);
/*     */ 
/* 190 */     constr(3, 1, 1, 1);
/* 191 */     this.constraints.fill = 1;
/* 192 */     this.gridbag.setConstraints(this.nSchriftLabel, this.constraints);
/* 193 */     this.wasPanel.add(this.nSchriftLabel);
/*     */ 
/* 195 */     constr(0, 2, 1, 1);
/* 196 */     this.constraints.fill = 1;
/* 197 */     this.gridbag.setConstraints(this.sSizeLabel, this.constraints);
/* 198 */     this.wasPanel.add(this.sSizeLabel);
/*     */ 
/* 200 */     constr(1, 2, 1, 1);
/* 201 */     this.constraints.fill = 1;
/* 202 */     this.gridbag.setConstraints(this.uFontSize, this.constraints);
/* 203 */     this.wasPanel.add(this.uFontSize);
/*     */ 
/* 205 */     constr(3, 2, 1, 1);
/* 206 */     this.constraints.fill = 1;
/* 207 */     this.gridbag.setConstraints(this.normalFontSize, this.constraints);
/* 208 */     this.wasPanel.add(this.normalFontSize);
/*     */ 
/* 210 */     constr(0, 3, 1, 1);
/* 211 */     this.constraints.fill = 1;
/* 212 */     this.gridbag.setConstraints(this.sArtLabel, this.constraints);
/* 213 */     this.wasPanel.add(this.sArtLabel);
/*     */ 
/* 215 */     constr(1, 3, 1, 1);
/* 216 */     this.constraints.fill = 1;
/* 217 */     this.gridbag.setConstraints(this.uFontArt, this.constraints);
/* 218 */     this.wasPanel.add(this.uFontArt);
/*     */ 
/* 220 */     constr(3, 3, 1, 1);
/* 221 */     this.constraints.fill = 1;
/* 222 */     this.gridbag.setConstraints(this.normalFontArt, this.constraints);
/* 223 */     this.wasPanel.add(this.normalFontArt);
/*     */ 
/* 226 */     constr(0, 0, 1, 1);
/* 227 */     this.constraints.fill = 1;
/* 228 */     this.gridbag.setConstraints(this.helpButton, this.constraints);
/* 229 */     this.druckPanel.add(this.helpButton);
/*     */ 
/* 231 */     constr(0, 1, 1, 1);
/* 232 */     this.constraints.fill = 1;
/* 233 */     this.gridbag.setConstraints(this.pageButton, this.constraints);
/* 234 */     this.druckPanel.add(this.pageButton);
/*     */ 
/* 236 */     constr(0, 2, 1, 1);
/* 237 */     this.constraints.fill = 1;
/* 238 */     this.gridbag.setConstraints(this.prevButton, this.constraints);
/* 239 */     this.druckPanel.add(this.prevButton);
/*     */ 
/* 243 */     constr(0, 0, 2, 4);
/* 244 */     this.constraints.fill = 1;
/* 245 */     this.gridbag.setConstraints(this.wasPanel, this.constraints);
/* 246 */     this.mainPanel.add(this.wasPanel);
/*     */ 
/* 248 */     constr(2, 0, 1, 3);
/* 249 */     this.constraints.fill = 1;
/* 250 */     this.gridbag.setConstraints(this.druckPanel, this.constraints);
/* 251 */     this.mainPanel.add(this.druckPanel);
/*     */ 
/* 253 */     constr(1, 4, 1, 1);
/* 254 */     this.constraints.fill = 0;
/* 255 */     this.gridbag.setConstraints(this.okButton, this.constraints);
/* 256 */     this.mainPanel.add(this.okButton);
/*     */ 
/* 258 */     constr(2, 4, 1, 1);
/* 259 */     this.constraints.fill = 0;
/* 260 */     this.gridbag.setConstraints(this.cancelButton, this.constraints);
/* 261 */     this.mainPanel.add(this.cancelButton);
/*     */ 
/* 263 */     this.mainPanel.setBorder(new LineBorder(null, 1));
/* 264 */     this.wasPanel.setBorder(new LineBorder(null, 1));
/* 265 */     this.druckPanel.setBorder(new LineBorder(null, 1));
/*     */ 
/* 273 */     getContentPane().add(this.mainPanel);
/* 274 */     pack();
/*     */   }
/*     */ 
/*     */   public void menuEvent(ActionEvent paramActionEvent)
/*     */   {
/* 283 */     String str = paramActionEvent.getActionCommand();
/* 284 */     Object localObject = paramActionEvent.getSource();
/* 285 */     if (localObject == this.okButton)
/* 286 */       drucken();
/* 287 */     else if (localObject == this.cancelButton)
/* 288 */       close();
/* 289 */     else if (localObject == this.helpButton)
/* 290 */       this.lobet.hilfe(6);
/* 291 */     else if (localObject == this.pageButton)
/* 292 */       pageSetup();
/*     */   }
/*     */ 
/*     */   public void taste(KeyEvent paramKeyEvent)
/*     */   {
/* 297 */     int i = paramKeyEvent.getModifiers();
/* 298 */     int j = paramKeyEvent.getKeyChar();
/* 299 */     int k = paramKeyEvent.getKeyCode();
/*     */ 
/* 301 */     if (k != 0)
/*     */     {
/* 303 */       if (k == 10)
/*     */       {
/* 305 */         this.d.out("Enter gedrückt!");
/* 306 */         drucken();
/* 307 */       } else if (k == 27) {
/* 308 */         close();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void constr(int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*     */   {
/* 345 */     this.constraints.gridx = paramInt1;
/* 346 */     this.constraints.gridy = paramInt2;
/* 347 */     this.constraints.gridwidth = paramInt3;
/* 348 */     this.constraints.gridheight = paramInt4;
/*     */   }
/*     */ 
/*     */   private void drucken() {
/* 352 */     int i = 0;
/*     */     try {
/* 354 */       if (null == this.prserv) {
/* 355 */         this.d.out("Kein PageSetup gemacht!");
/* 356 */         pageSetup();
/*     */       }
/* 358 */       if (null != this.prserv) {
/* 359 */         this.d.out(new StringBuilder().append("ASET: ").append(this.aset).toString());
/* 360 */         this.d.out("Ausgewaehlter Print-Service:");
/* 361 */         this.d.out(new StringBuilder().append("\t\t\t").append(this.prserv).toString());
/* 362 */         printPrintServiceAttributesAndDocFlavors(this.prserv);
/* 363 */         System.out.print("create Printjob..");
/* 364 */         DocPrintJob localDocPrintJob = this.prserv.createPrintJob();
/* 365 */         this.einstellungen.setPrintSetupValues(new PrintSetupValues(this.uFontSize.getSelectedIndex() + 1, this.normalFontSize.getSelectedIndex() + 1, this.uFontArt.getSelectedIndex(), this.normalFontArt.getSelectedIndex()));
/* 366 */         SimpleDoc localSimpleDoc = new SimpleDoc(new LoBeTPrintableObject(this.typ, this.daten), this.flavor, null);
/* 367 */         this.d.out("Drucke");
/* 368 */         localDocPrintJob.print(localSimpleDoc, this.aset);
/* 369 */         this.d.out("Dingens ist erfolgreich gedruckt.");
/* 370 */         i = 1;
/*     */       }
/*     */     } catch (PrintException localPrintException) {
/* 373 */       System.err.println(localPrintException);
/*     */     }
/*     */ 
/* 377 */     if (i != 0)
/* 378 */       close();
/*     */   }
/*     */ 
/*     */   public void nachLaden()
/*     */   {
/* 383 */     init();
/*     */   }
/*     */ 
/*     */   public void close() {
/* 387 */     setVisible(false);
/*     */   }
/*     */ 
/*     */   public void open(int paramInt) {
/* 391 */     this.typ = paramInt;
/* 392 */     setVisible(false);
/* 393 */     init();
/*     */     try {
/* 395 */       setIcon(false);
/*     */     } catch (Exception localException) {
/* 397 */       System.err.println("Fehler beim Deiconifizieren der EinstellungenGUI");
/*     */ 
/* 399 */       JOptionPane.showMessageDialog(this, "Fehler beim deiconifizieren!", "DeIconifizieren", 0);
/*     */     }
/* 401 */     setLocation(0, 0);
/* 402 */     setVisible(true);
/*     */   }
/*     */ 
/*     */   private void setToolTips()
/*     */   {
/* 407 */     if (this.einstellungen.getToolTips());
/*     */   }
/*     */ 
/*     */   private void RadioButtonsInit()
/*     */   {
/*     */   }
/*     */ 
/*     */   private void pageSetup()
/*     */   {
/* 421 */     int i = -1;
/*     */ 
/* 427 */     if ((null == this.prservices) || (0 >= this.prservices.length)) {
/* 428 */       if (null != this.prservDflt)
/*     */       {
/* 430 */         System.err.println("Nur Default-Printer, da lookupPrintServices fehlgeschlagen.");
/* 431 */         this.prservices = new PrintService[] { this.prservDflt };
/*     */       }
/*     */       else
/*     */       {
/* 435 */         System.err.println(this.sErrNoPrintService);
/*     */       }
/*     */     }
/* 438 */     this.d.out("Print-Services:");
/* 439 */     for (int j = 0; j < this.prservices.length; j++) {
/* 440 */       this.d.out(new StringBuilder().append("\t").append(j).append(":\t").append(this.prservices[j]).append(this.prservDflt != this.prservices[j] ? "" : " (Default)").toString());
/*     */     }
/* 442 */     if ((0 <= i) && (i < this.prservices.length)) {
/* 443 */       this.prserv = this.prservices[i];
/*     */     }
/*     */     else {
/* 446 */       if (!Arrays.asList(this.prservices).contains(this.prservDflt))
/* 447 */         this.prservDflt = null;
/* 448 */       this.prserv = ServiceUI.printDialog(null, 50, 50, this.prservices, this.prservDflt, null, this.aset);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setToolTips(boolean paramBoolean)
/*     */   {
/* 479 */     if (paramBoolean) {
/* 480 */       this.helpButton.setToolTipText("Hilfe zum Drucken");
/* 481 */       this.prevButton.setToolTipText("Druckvorschau");
/* 482 */       this.pageButton.setToolTipText("Druckeigenschaften");
/*     */     } else {
/* 484 */       this.helpButton.setToolTipText(null);
/* 485 */       this.prevButton.setToolTipText(null);
/* 486 */       this.pageButton.setToolTipText(null);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setIcons(boolean paramBoolean) {
/* 491 */     if (paramBoolean)
/*     */     {
/* 493 */       this.helpButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/ContextualHelp24.gif")));
/* 494 */       this.prevButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/PrintPreview24.gif")));
/* 495 */       this.pageButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/PageSetup24.gif")));
/*     */     }
/*     */     else {
/* 498 */       this.helpButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/ContextualHelp16.gif")));
/* 499 */       this.prevButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/PrintPreview16.gif")));
/* 500 */       this.pageButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/PageSetup16.gif")));
/*     */     }
/*     */   }
/*     */ 
/*     */   private void printPrintServiceAttributesAndDocFlavors(PrintService paramPrintService) {
/* 505 */     Object localObject = null;
/* 506 */     Attribute[] arrayOfAttribute = paramPrintService.getAttributes().toArray();
/* 507 */     DocFlavor[] arrayOfDocFlavor = paramPrintService.getSupportedDocFlavors();
/*     */     int i;
/* 508 */     if ((null != arrayOfAttribute) && (0 < arrayOfAttribute.length)) {
/* 509 */       for (i = 0; i < arrayOfAttribute.length; i++)
/* 510 */         System.out.println(new StringBuilder().append("\t\t\tPrintService-Attribute[").append(i).append("]: ").append(arrayOfAttribute[i].getName()).append(" = ").append(arrayOfAttribute[i]).toString());
/*     */     }
/* 512 */     if ((null != arrayOfDocFlavor) && (0 < arrayOfDocFlavor.length))
/* 513 */       for (i = 0; i < arrayOfDocFlavor.length; i++)
/*     */       {
/* 515 */         String str = arrayOfDocFlavor[i].getMimeType();
/* 516 */         if ((null != str) && (!str.equals(localObject)))
/* 517 */           System.out.println(new StringBuilder().append("\t\t\tPrintService-DocFlavor-Mime[").append(i).append("]: ").append(str).toString());
/* 518 */         localObject = str;
/*     */       }
/*     */   }
/*     */ }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     PrinterPreviewGUI
 * JD-Core Version:    0.6.0
 */