       import java.io.File;
       import java.io.IOException;
       import java.io.PrintStream;
       import javax.xml.parsers.ParserConfigurationException;
       import javax.xml.parsers.SAXParser;
       import javax.xml.parsers.SAXParserFactory;
       import org.xml.sax.Attributes;
       import org.xml.sax.SAXException;
       import org.xml.sax.helpers.DefaultHandler;
       
       public class XMLDaten extends DefaultHandler
       {
         static int READING_TITEL = 1;
         static int READING_ORIGINAL = 2;
         static int READING_ANFANG = 3;
         static int READING_REFRAIN = 4;
         static int READING_BRIDGE = 5;
         static int READING_TRANSLATE = 6;
         static int READING_ZEILE = 7;
         static int READING_VORNAME = 8;
         static int READING_NAME = 9;
         static int READING_AUTOR = 10;
         static int READING_MELODIE = 11;
         static int READING_UEBERSETZER = 12;
         static int READING_COPYRIGHT = 13;
         static int READING_VERLAG = 14;
         static int READING_KOMMENTAR = 15;
         static int READING_VERSION = 16;
         static int READING_WANN = 17;
         static int READING_WIE_OFT = 18;
       
         static int READING_NOTHING = 0;
         int currentActivity = READING_NOTHING;
       
         private String titel = "";
         private String original = "";
         private boolean anfang = false;
         private boolean refrain = false;
         private boolean bridge = false;
         private boolean translate = false;
         private String zeile = "";
         private Autor liedmacher;
         private Autor texter;
         private Autor translater;
         private int copyrightZahl;
         private int versionZahl;
         private String vorname = "";
         private String name = "";
         private String copyright = "";
         private String verlag = "";
         private String kommentar = "";
         private String version = "";
       
         private String wann = "";
         private String wieOft = "";
       
         private int wieOftZahl = 0;
         private long wannZahl = 0L;
         private XMLLied[] lieder;
         private Text[] texte;
         private int woLied = 0;
         private int woText = 0;
         private int woZeile = 0;
         private int woXLied = 0;
         private int woXText = 0;
         private Debug d;
         private boolean debug = false;
         public static final int maxZeile = 24;
         private String[] zeilen = new String[24];
         ProgressBarNeu pbn;
         int liedAnzahl;
         int textAnzahl;
       
    @SuppressWarnings("LeakingThisInConstructor")
         public XMLDaten(int paramInt1, int paramInt2, ProgressBarNeu paramProgressBarNeu, File paramFile, boolean paramBoolean)
         {
           debug = paramBoolean;
           d = new Debug(paramBoolean);
       
           pbn = paramProgressBarNeu;
           liedAnzahl = paramInt1;
           textAnzahl = paramInt2;
       
           lieder = new XMLLied[paramInt1];
           texte = new Text[paramInt2];
           SAXParserFactory localSAXParserFactory = SAXParserFactory.newInstance();
           localSAXParserFactory.setValidating(true);
           try {
             SAXParser localSAXParser = localSAXParserFactory.newSAXParser();
             localSAXParser.parse(paramFile, this);
           } catch (ParserConfigurationException localParserConfigurationException) {
             System.out.println("Could not create that parser.");
             System.out.println(localParserConfigurationException.getMessage());
           } catch (SAXException localSAXException) {
             System.out.println("Problem with the SAX parser.");
             System.out.println(localSAXException.getMessage());
           } catch (IOException localIOException) {
             System.out.println("Error reading file.");
             System.out.println(localIOException.getMessage());
           }
           paramProgressBarNeu.ende();
           if (paramBoolean)
             ausgabe();
         }
       
         public void startElement(String paramString1, String paramString2, String paramString3, Attributes paramAttributes)
         {
           int i;
           if (paramString3.equals("Lied")) {
             currentActivity = READING_NOTHING;
             pbn.progress();
             for (i = 0; i < 24; i++)
               zeilen[i] = "";
             titel = "";
             original = "";
             anfang = false;
             refrain = false;
             bridge = false;
             translate = false;
             zeile = "";
             vorname = "";
             name = "";
             copyright = "";
             verlag = "";
             kommentar = "";
             version = "";
             woZeile = 0;
             wann = "";
             wieOft = "";
             wieOftZahl = 0;
             wannZahl = 0L;
             liedmacher = new Autor();
             texter = new Autor();
             translater = new Autor();
             copyrightZahl = 0;
             versionZahl = 0;
             lieder[woLied] = new XMLLied();
           } else if (paramString3.equals("Text")) {
             currentActivity = READING_NOTHING;
             pbn.progress();
             for (i = 0; i < 24; i++)
               zeilen[i] = "";
             titel = "";
             zeile = "";
             vorname = "";
             name = "";
             copyright = "";
             verlag = "";
             kommentar = "";
             version = "";
             woZeile = 0;
             liedmacher = new Autor();
             texter = new Autor();
             translater = new Autor();
             copyrightZahl = 0;
             versionZahl = 0;
             texte[woText] = new Text();
           } else if (paramString3.equals("Titel")) {
             currentActivity = READING_TITEL;
           } else if (paramString3.equals("Original")) {
             currentActivity = READING_ORIGINAL;
           } else if (paramString3.equals("Lieder")) {
             currentActivity = READING_NOTHING;
             pbn.progress("Lese Lieder...");
           } else if (paramString3.equals("Texte")) {
             currentActivity = READING_NOTHING;
             pbn.progress("Lese Texte...");
           } else if (paramString3.equals("Version")) {
             currentActivity = READING_VERSION;
           } else if (paramString3.equals("Vorname")) {
             currentActivity = READING_VORNAME;
           } else if (paramString3.equals("Name")) {
             currentActivity = READING_NAME;
           } else if (paramString3.equals("Verlag")) {
             currentActivity = READING_VERLAG;
           } else if (paramString3.equals("Kommentar")) {
             currentActivity = READING_KOMMENTAR;
           } else if (paramString3.equals("Zeile")) {
             currentActivity = READING_ZEILE;
           } else if (paramString3.equals("Anfang")) {
             anfang = true;
           } else if (paramString3.equals("Refrain")) {
             refrain = true;
           } else if (paramString3.equals("Bridge")) {
             bridge = true;
           } else if (paramString3.equals("Statistik")) {
             currentActivity = READING_WIE_OFT;
           } else if (paramString3.equals("WannStatistik")) {
             currentActivity = READING_WANN;
           } else if (paramString3.equals("Copyright")) {
             currentActivity = READING_COPYRIGHT;
           } else {
             currentActivity = READING_NOTHING;
           }
         }
       
         public void characters(char[] paramArrayOfChar, int paramInt1, int paramInt2)
         {
           String str = new String(paramArrayOfChar, paramInt1, paramInt2);
       
           if (currentActivity == READING_TITEL)
             titel += str;
           else if (currentActivity == READING_ORIGINAL)
             original += str;
           else if (currentActivity == READING_ZEILE)
             zeilen[woZeile] = (zeilen[woZeile] + str);
           else if (currentActivity == READING_VORNAME)
             vorname += str;
           else if (currentActivity == READING_NAME)
             name += str;
           else if (currentActivity == READING_COPYRIGHT)
             copyright += str;
           else if (currentActivity == READING_VERSION)
             version += str;
           else if (currentActivity == READING_KOMMENTAR)
             kommentar += str;
           else if (currentActivity == READING_VERLAG)
             verlag += str;
           else if (currentActivity == READING_WANN)
             wann += str;
           else if (currentActivity == READING_WIE_OFT)
             wieOft += str;
         }
       
         public void endElement(String paramString1, String paramString2, String paramString3)
         {
           int i = 0;
           if (paramString3.equals("Lied"))
           {
             lieder[woLied].setTitel(titel);
             lieder[woLied].setOriginal(original);
             lieder[woLied].setKommentar(new Kommentar(liedmacher, texter, translater, copyrightZahl, kommentar, verlag, versionZahl));
             lieder[woLied].removeStrophe(0);
             lieder[woLied].setStatistiken(wieOftZahl, wannZahl);
             woLied += 1;
           }
           else if (paramString3.equals("Zeile")) {
             if (woZeile < 23)
               woZeile += 1;
           }
           else
           {
             Strophe localStrophe;
             if (paramString3.equals("Liedseite")) {
               localStrophe = new Strophe();
               for (i = 0; i < 24; i++) {
                 localStrophe.set(zeilen[i], i);
                 zeilen[i] = "";
               }
               localStrophe.setAnfang(anfang);
               localStrophe.setBridge(bridge);
               localStrophe.setRefrain(refrain);
               lieder[woLied].addStrophe(localStrophe);
               anfang = false;
               bridge = false;
               refrain = false;
               woZeile = 0;
             } else if (paramString3.equals("Textseite")) {
               localStrophe = new Strophe();
               for (i = 0; i < 24; i++) {
                 localStrophe.set(zeilen[i], i);
                 zeilen[i] = "";
               }
               texte[woText].addText(localStrophe);
               anfang = false;
               bridge = false;
               refrain = false;
               woZeile = 0;
             } else if (paramString3.equals("Text")) {
               d.out("Text: " + woText + " " + titel);
               texte[woText].setTitel(titel);
               texte[woText].setKommentar(new Kommentar(liedmacher, texter, translater, copyrightZahl, kommentar, verlag, versionZahl));
               texte[woText].removeText(0);
               woText += 1;
             }
             else if (paramString3.equals("Textautor")) {
               texter = new Autor(vorname, name);
               vorname = "";
               name = "";
             } else if (paramString3.equals("Melodie")) {
               liedmacher = new Autor(vorname, name);
               vorname = "";
               name = "";
             } else if (paramString3.equals("Uebersetzer")) {
               translater = new Autor(vorname, name);
               vorname = "";
               name = "";
             } else if (paramString3.equals("Copyright")) {
               if (copyright.equals(""))
                 copyrightZahl = 0;
               else
                 try {
                   copyrightZahl = Integer.parseInt(copyright);
                 } catch (NumberFormatException localNumberFormatException1) {
                   copyrightZahl = 0;
                   d.out("Warnung: Keine Zahl im Copyright");
                 }
             }
             else if (paramString3.equals("Version")) {
               if (version.equals(""))
                 version = "0";
               try {
                 versionZahl = Integer.parseInt(version);
               } catch (NumberFormatException localNumberFormatException2) {
                 versionZahl = 0;
                 d.out("Exception Version");
               }
             } else if (paramString3.equals("WannStatistik")) {
               if (wann.equals(""))
                 wann = "0";
               try
               {
                 wannZahl = Long.parseLong(wann);
               } catch (NumberFormatException localNumberFormatException3) {
                 wannZahl = 0L;
                 d.out("Exception WannStatistik");
               }
             } else if (paramString3.equals("Statistik")) {
               if (wieOft.equals(""))
                 wieOft = "0";
               try {
                 wieOftZahl = Integer.parseInt(wieOft);
               } catch (NumberFormatException localNumberFormatException4) {
                 wieOftZahl = 0;
                 d.out("Exception wieOft");
               }
             }
           }
         }
       
         public void ausgabe() {
           for (int i = 0; i < liedAnzahl; i++)
             System.out.println("Lied: " + lieder[i].getTitel());
           for (int i = 0; i < textAnzahl; i++)
             System.out.println("Text: " + texte[i].getTitel());
         }
       
         public void startLied() {
           woXLied = 0;
         }
       
         public void startText() {
           woXText = 0;
         }
       
         public XMLLied nextLied() {
           XMLLied localXMLLied = null;
           if (woXLied < liedAnzahl) {
             localXMLLied = lieder[woXLied];
             woXLied += 1;
           }
           return localXMLLied;
         }
       
         public Text nextText() {
           Text localText = null;
           if (woXText < textAnzahl) {
             localText = texte[woXText];
             woXText += 1;
           }
           return localText;
         }
       }
