import java.util.Date;
//Hier kommen die Daten einer Datevbuchung rein

public class Buchung{
	private boolean sollHaben = true; //Von der Buchungsmaske: 
	private int soll = 0;		  //Konto im Soll
	private int haben = 0;		  //Konto im Haben
	private int betrag = 0;		  //Betrag in Cent: 100 Cent gleich 1 Euro.
	private String beleg1 = "";	  //Belegfelder 1 und 2
	private String beleg2 = "";
	private short tag = 1;		  //Das Datum.
	private short monat = 1;
	private short jahr = 2020;
	private String text;		  //Buchungstext
	private boolean storno = false;	  //Wurde die Buchung storniert?
	private Datum datum;
		
	public Buchung(int betrag, int soll, int haben, String beleg1, String beleg2, short tag, short monat, short jahr, String text, boolean sollHaben){
		//Soll = Konto Haben = Gegenkonto H-> Konto im Haben -> Soll = im Haben  S-> Konto im Soll -> im Soll
		//S -> sollhaben = true;
		this.betrag = betrag;
		this.soll = soll;
		this.haben = haben;
		this.beleg1 = beleg1;
		this.beleg2 = beleg2;
		this.tag = tag;
		this.monat = monat;
		this.jahr = jahr;
		this.text = text;
		this.sollHaben = sollHaben;
	}
		
	public int getSoll(){
		return soll;
		//Konto
	}
	
	public int getHaben(){
		return haben;
		//Gegenkonto
	}
	
	public int getGegen(){
		/*Soll = Konto 
		  Haben = Gegenkonto 
		  sollhaben = false: H-> Konto im Haben -> Soll = im Haben  
		  sollhaben = true:  S-> Konto im Soll -> im Soll
		//S -> sollhaben = true;
		*/
		if(sollHaben){
			return soll;
		} else {
			return haben;
		}
	}
	
	public int getKonto(){
		if(sollHaben){
			return haben;
		} else {
			return soll;
		}
	}
	
	public boolean getSollHaben(){
		return sollHaben;
	}
		
	public int getBetrag(){
		return betrag;
	}
	
	public String getBeleg1(){
		return beleg1;
	}
	
	public String getBeleg2(){
		return beleg2;
	}
	
	public short getTag(){
		return tag;
	}
	
	public short getMonat(){
		return monat;
	}
	
	public short getJahr(){
		return jahr;
	}
		
	public String getText(){
		return text;
	}
			
	public String writeXML(){	
		String ausgabe = "";
		ausgabe = ausgabe+"<betrag>"+betrag+"</betrag>";
		if(sollHaben){
			//Wenn sollHaben, dann ist das Konto im Haben und Gegen im Soll
			ausgabe = ausgabe+"<soll konto=\"0\">"+soll+"</soll>";
		} else {
			ausgabe = ausgabe+"<soll konto=\"1\">"+soll+"</soll>";
		}
		ausgabe = ausgabe+"<haben>"+haben+"</haben>";
		ausgabe = ausgabe+"<beleg1>"+beleg1+"</beleg1>";
		ausgabe = ausgabe+"<beleg2>"+beleg2+"</beleg2>";
		ausgabe = ausgabe+"<text>"+text+"</text>";
		ausgabe = ausgabe+"<tag>"+tag+"</tag>";
		ausgabe = ausgabe+"<monat>"+monat+"</monat>";
		ausgabe = ausgabe+"<jahr>"+jahr+"</jahr>";
		return ausgabe;
	}
	
	public Datum getDatum(){
		datum = new Datum(tag, monat, jahr);
		return datum;
	}
	
}
