import java.util.regex.*;

/*
Daten der linken oder rechten Tabelle beim Vergleich.
*/

public class DateiDaten{
	private String[][] daten;
	private int zeilen;
	private int datevzeilen;
	private int[] zeile;
	private int spalten;
	private int[] status;//0 leer; 1 gefunden gleiches Datum; 2 Sammler gleiches Datum; 3 gefunden; 4 Sammler; 5 Storno
	private int[] ziffern;//vom ausziffern her: Die Ausziffernummer;
	private int[] datum;//Spalten, in denen das Datum stehen könnte
	private int[] soll;
	private int[] haben;
	private int[] summe;
	private int[] saldo;
	private boolean saldofertig = false;
	private boolean vorzeichen = false;
	private int maxZiffer = 0;//Zum Ausziffern die aktuelle Zahl
	public static final int status_LEER = 0;//Standard
	public static final int status_GEFUNDEN = 1;//bei Saldo: alle ausgeschlossenen
	public static final int status_SAMMLER = 2;//bei Saldo: Problemfälle
	public static final int status_GEFUNDEN_WEIT = 3;
	public static final int status_SAMMLER_WEIT = 4;
	public static final int status_STORNO = 5;
	public static final int status_SALDO = 6;
	private boolean datev = false;
	private boolean jahreszahlen = false;
	
	private DateiDaten kurz = null;
	
	//Daten aus Buchhalter:
	private int wahlDatum = -1;//Welche Spalte Datum -1 = keine Auswahl
	private int wahlSoll = -1;
	private int wahlHaben = -1;
	private int genauigkeit = 100;
	private boolean stornoFirst = true;
	private boolean zeilenOhneDatum = false;
	private boolean Summanden = true;
	private boolean ohneDatumRCB = true;
	
	private int[] sort;       //zu sortierendes Feld
	private int[] sort_merge; //Hilfsfeld
	private int[] datumInt;	  //Hier steht eine codierte Form des Datums.
	

	
	public DateiDaten(int zeilen, int spalten){
		if(zeilen > 0 && spalten > 0){
			this.zeilen = zeilen;
			this.spalten = spalten;
			//Wir wollen noch den Status jeder Zeile speichern
			daten = new String[zeilen][spalten];
			status = new int[zeilen];
			ziffern = new int[zeilen];
			zeile = new int[zeilen];
			for(int i = 0; i < zeilen; i++){
				status[i] = 0;
				ziffern[i] = 0;
				
			}
			datum = new int[spalten];
			soll  = new int[spalten];
			haben = new int[spalten];
			
			for(int i = 0; i < spalten;i++){
				datum[i] = 1;//Alle Spalten könnten Datum enthalten
				soll[i]  = 1;
				haben[i] = 1;
			}
		}
	}
	
	public void einlesen(int zeile, int spalte, String text){
		if(zeile >= 0 && zeile < zeilen && spalte >= 0 && spalte < spalten)
			daten[zeile][spalte] = text;
	}
	
	public void einlesen(int zeile, String[] text){
		if(zeile >= 0 && zeile < zeilen)
			for(int i=0; i < text.length; i++)
				daten[zeile][i] = text[i];
	}
	
	public int getZeilen(){
		if(datev)
			return datevzeilen;
		else
			return zeilen;
	}
	
	public int getVisibleZeilen(){
		int j =0 ;
		int maxzeilen = zeilen;
		if(datev)
			maxzeilen = datevzeilen;
		
		if(zeilenOhneDatum){
			for(int i = 0; i < maxzeilen; i++)
				if(istDatum(i, wahlDatum))
					if(status[i] == 0) 
						j++;
		} else {
			for(int i = 0; i < maxzeilen; i++)
				if(status[i] == 0) 
					j++;
		}
		return j;
	}
	
	public int getSpalten(){
		return spalten;
	}
	
	public String getText(int zeile, int spalte){
		String text = "";
		if(zeile >= 0 && zeile < zeilen && spalte >= 0 && spalte < spalten)
			text = daten[zeile][spalte];
		if(null == text)
			text = "";
		return text;
	}
	
	public int status(int zeile){
		int ergebnis = 0;
		if(zeile >= 0 && zeile < zeilen){
			if(zeilenOhneDatum){
				if(istDatum(zeile, wahlDatum))
					ergebnis = status[zeile];
				else
					ergebnis = -1;
			} else {
				ergebnis = status[zeile];
			}
		}
		return ergebnis;
	}
	
	public boolean istStatus(int zeile){
		boolean ergebnis = false;
		if(zeile >= 0 && zeile < zeilen)
			ergebnis = (status[zeile] == 0);
		return ergebnis;
	}
	
	public String getStatus(int zeile){
		String text = "";
		if(zeile >= 0 && zeile < zeilen)
			text = ""+status[zeile];
		return text;
	}
	
	public void setStatus(int zeile, int stat){
		if(zeile >= 0 && zeile < zeilen)
			status[zeile] = stat;
	}
	
	public int ziffer(int zeile){
		int ergebnis = 0;
		if(zeile >= 0 && zeile < zeilen)
			ergebnis = ziffern[zeile];
		return ergebnis;
	}
	
	public String getZiffer(int zeile){
		String text = "";
		if(zeile >= 0 && zeile < zeilen)
			text = ""+ziffern[zeile];
		return text;
	}
	
	public boolean istDatum(int zeile){
		/*
			Wenn der String auf ein Datumsformat passt,
			ist er ein Datum.
		*/
		boolean ergebnis = false;
		String text = "";
		if(zeile >= 0 && zeile < zeilen)
			for(int i = 0; i < spalten; i++){
				if(daten[zeile][i] == null){
					datum[i] = 0;
					//System.out.print("null");
				} else if((daten[zeile][i].equals(""))){
					datum[i] = 0;
					//System.out.print("-,,-");
				} else if(!Pattern.matches("[0-9]?[0-9]\\.[0-9]?[0-9]\\.[0-9]?[0-9]?[0-9][0-9]", daten[zeile][i])){
					//Format von Domus und StarMoney
					if(!Pattern.matches("[0-9]?[0-9][0-9][0-9]", daten[zeile][i])){
						//Format von Datev
						datum[i] = 0;
					}
					//System.out.println("kein Datumsmatch");
				}
			}
		int anzahl = 0;
		for(int i = 0; i < spalten; i++)
			anzahl = anzahl +datum[i];
		if(anzahl > 0)
			ergebnis = true;
		return ergebnis;
	}
	
	public void setDatev(boolean datev, int datevzeilen){
		this.datev = datev;
		if(datev && datevzeilen > 0)
			this.datevzeilen = datevzeilen;
	}
	
	public boolean datev(){
		return datev;
	}
	
	public boolean istDatum(int zeile, int spalte){
		/*
			Wenn der String auf ein Datumsformat passt,
			ist er ein Datum.
		*/
		boolean ergebnis = false;
		String text = "";
		if(zeile >= 0 && zeile < zeilen && spalte >=0 && spalte < spalten){
			if(daten[zeile][spalte] == null){
			} else if((daten[zeile][spalte].equals(""))){
			} else if(Pattern.matches("[0-9]?[0-9]\\.[0-9]?[0-9]\\.[0-9]?[0-9]?[0-9][0-9]", daten[zeile][spalte])){
					//Format von Domus und StarMoney
					ergebnis = true;
			} else if(Pattern.matches("[0-9]?[0-9][0-9][0-9]", daten[zeile][spalte])){
					//Format von Datev
					ergebnis = true;
			} else {
				//System.out.println("Datum falsch: "+daten[zeile][spalte]);
			}
		}
		return ergebnis;
	}
	
	public boolean istGleichesDatum(int zeile, int spalte, String datum){
		boolean ergebnis = false;
		int tagL = 0;
		int monatL = 0;
		int jahrL = 0;
		int tagR = 0;
		int monatR = 0;
		int jahrR = 0;
		String datumL = "";
		String datumR = datum;
		if(datum == null)
			datumR = "";
		String[] dutamL;
		String[] dutamR;
		if(wahlDatum > -1){		
			datumL = getText(zeile, wahlDatum);
			if(Pattern.matches("[0-9]?[0-9]\\.[0-9]?[0-9]\\.[0-9]?[0-9]?[0-9][0-9]", datumL)){
				//Format von Domus und StarMoney
				dutamL = datumL.split("\\.");
				try{
					//System.out.println("Split: "+datumL+"---"+dutamL[0]);
					tagL = Integer.parseInt(dutamL[0]);
					monatL = Integer.parseInt(dutamL[1]);
					jahrL = Integer.parseInt(dutamL[2]);
				} catch (NumberFormatException nfe){
					//Nüscht. Funktioniert doch.
				}
			} else if(Pattern.matches("[0-9]?[0-9][0-9][0-9]", datumL)){
				//Format von Datev
				datumL = datumL.trim();
				try{
					if(datumL.length() > 3){
						tagL = Integer.parseInt(datumL.substring(0, 2));
						monatL = Integer.parseInt(datumL.substring(2, 4));
					} else {
						tagL = Integer.parseInt(datumL.substring(0, 1));
						monatL = Integer.parseInt(datumL.substring(1, 3));
					}
				} catch (NumberFormatException nfe){
					//Nüscht. Funktioniert doch.
				}
			}
		}
		
		if(Pattern.matches("[0-9]?[0-9]\\.[0-9]?[0-9]\\.[0-9]?[0-9]?[0-9][0-9]", datumR)){
			//Format von Domus und StarMoney
			dutamR = datumR.split("\\.");
			//System.out.println("Split: "+datumR+"---"+dutamR[0]);
			try{
				tagR = Integer.parseInt(dutamR[0]);
				monatR = Integer.parseInt(dutamR[1]);
				jahrR = Integer.parseInt(dutamR[2]);
			} catch (NumberFormatException nfe){
				//Nüscht. Funktioniert doch.
			}
		} else if(Pattern.matches("[0-9]?[0-9][0-9][0-9]", datumR)){
			//Format von Datev
			datumR = datumR.trim();
			try{
				if(datumR.length() > 3){
					tagR = Integer.parseInt(datumR.substring(0, 2));
					monatR = Integer.parseInt(datumR.substring(2, 4));
				} else {
					tagR = Integer.parseInt(datumR.substring(0, 1));
					monatR = Integer.parseInt(datumR.substring(1, 3));
				}
			} catch (NumberFormatException nfe){
				//Nüscht. Funktioniert doch.
			}
		}
		if(0 == jahrL || 0 == jahrR) 
			ergebnis = (tagL == tagR && monatL == monatR);
		else
			ergebnis = (tagL == tagR && monatL == monatR && jahrL == jahrR);
		//System.out.println("L: "+tagL+"."+monatL+". == "+tagR+"."+monatR+".  :"+ergebnis);
		return ergebnis;
	}
	
	public boolean istSollHaben(int zeile){
		/*
			Wenn der String auf ein Betragsformat passt,
			ist er ein Betrag.
		*/
		boolean ergebnis = false;
		String text = "";
		if(zeile >= 0 && zeile < zeilen)
			for(int i = 0; i < spalten; i++){
				if(daten[zeile][i] == null){
					soll[i] = 0;
					haben[i] = 0;
					//System.out.print("null");
				} else if((daten[zeile][i].equals(""))){
					soll[i] = 0;
					haben[i] = 0;
					//System.out.print("-,,-");
				//} else if(!Pattern.matches("[-]?([0-9]*[.]?)*[0-9]*[,]?[0-9]?[0-9]?", daten[zeile][i])){
				} else if(!Pattern.matches("[-]?([0-9]*[.]?)*[0-9]*[,][0-9][0-9]", daten[zeile][i])){
						soll[i] = 0;
						haben[i] = 0;
					//System.out.println("kein Sollmatch: "+daten[zeile][i]);
				} 
			}
		int anzahl = 0;
		for(int i = 0; i < spalten; i++)
			anzahl = anzahl +soll[i];
		if(anzahl > 0)
			ergebnis = true;
		return ergebnis;
	}
	
	public boolean istSollHaben(int zeile, int spalte){
		/*
			Wenn der String auf ein Betragsformat passt,
			ist er ein Betrag.
		*/
		boolean ergebnis = false;
		String text = "";
		if(zeile >= 0 && zeile < zeilen && spalte >=0 && spalte < spalten){
			if(daten[zeile][spalte] == null){
			} else if((daten[zeile][spalte].equals(""))){
			//} else if(Pattern.matches("[-]?([0-9]*[.]?)*[0-9]*[,][0-9][0-9]", daten[zeile][spalte])){
			} else if(Pattern.matches("[-]?([0-9]*[.]?)*[0-9]*[,]?[0-9]?[0-9]?", daten[zeile][spalte])){
				ergebnis = true;
			} else {
				System.out.println("Soll/Haben falsch: "+daten[zeile][spalte]);
			}
		}
		return ergebnis;
	}
	
	public int getDatumsSpalte(){
		int i = 0;
		int spalte = -1;
		if(datev){
			spalte = 9;
		} else {
			while(spalte == -1 && i < spalten){
				if(datum[i] == 1)
					spalte = i;
				i++;
			}
		}
		//System.out.println("Datumsspalte: "+spalte);
		wahlDatum = spalte;
		return spalte;
	}
	
	public int getSollSpalte(){
		int i = 0;
		int spalte = -1;
		if(datev){
			spalte = 0;
		} else {
			while(spalte == -1 && i < spalten){
				if(soll[i] == 1)
					spalte = i;
				i++;
				if(wahlDatum == spalte)
					spalte = -1;
			}
		}
		//System.out.println("Sollspalte: "+spalte);
		wahlSoll = spalte;
		return spalte;
	}
	
	public int getHabenSpalte(){
		int i = 0;
		int sollS = getSollSpalte();
		int spalte = -1;
		if(datev){
			spalte = -1;
		} else {
			while(spalte == -1 && i < spalten){
				if(soll[i] == 1 && i != sollS)
					spalte = i;
				i++;
				if(wahlDatum == spalte || wahlSoll == spalte)
					spalte = -1;
			}
		}
		//System.out.println("Habenspalte: "+spalte);
		wahlHaben = spalte;
		return spalte;
	}
	
	public void setzeGUIDaten(int wahlDatum, int wahlSoll, int wahlHaben, boolean stornoFirst, boolean zeilenOhneDatum, boolean Summanden, boolean ohneDatumRCB){
		if(wahlDatum >= -1 && wahlDatum < spalten)
			this.wahlDatum = wahlDatum;//Welche Spalte Datum 0 = keine Auswahl
		if(wahlSoll >= -1 && wahlSoll < spalten)
			this.wahlSoll = wahlSoll;
		if(wahlHaben >= -1 && wahlHaben < spalten)
			this.wahlHaben = wahlHaben;
		this.stornoFirst = stornoFirst;
		this.zeilenOhneDatum = zeilenOhneDatum;
		this.Summanden = Summanden;
		this.ohneDatumRCB = ohneDatumRCB;
		saldofertig = false;
		if(zeilen > 0)
			getSaldo(0);
		//System.out.println("Wahldatum: "+this.wahlDatum);
	}
	
	public int getWahlDatum(){	
		return wahlDatum;
	}
	
	public int getWahlSoll(){
		return wahlSoll;
	}
	
	public int getWahlHaben(){
		return wahlHaben;
	}
	
	public boolean getStornoFirst(){
		return stornoFirst;
	}
	
	public boolean getZeilenOhneDatum(){
		return zeilenOhneDatum;
	}
	
	public int getNextZiffer(){
		return ++maxZiffer;
	}
	
	public void setZiffer(int zeile, int zahl){
		if(zeile > -1 && zeile < zeilen && zahl > 0)
			ziffern[zeile] = zahl;
	}
	
	public String textkurz(String text, int position){
		String s = "";
		if(position > text.length())
			position = text.length();
			s = text.substring(0, position);
		return s;
	}
	
	public int stringToInt(String s){
		/*
		int i = 0;
		String text = s.trim();
		text = punktDurchStrich(text);
		
		if(0 == text.length())
			i = 0;
		else
			try{
				i = (int) (Float.parseFloat(text)*genauigkeit);//Vorsicht Rundungsdifferenzen!!!
				System.out.println(StringToInt.String2Int(s, genauigkeit));
			} catch (NumberFormatException nfe){
				i = 0;
			}
		
		return i;
		*/
		if(s == null) s = "";
		s = s.trim();
		int ergebnis = 0;
		boolean vorKomma = true;
		boolean negativ = false;
		char[] text = s.toCharArray();
		int nachkomma = genauigkeit;
		//System.out.print("Ergebnis vor Komma: ");
		for(int i=0; i < text.length;i++){
			if(text[i] == '-') {
				negativ = true;
			} else if (text[i] == '.') {//1.000 enderpunkte
			} else if(text[i] == ','){//| text[i] == '.') {
				if(vorKomma){
					vorKomma = false; 
					ergebnis = ergebnis*genauigkeit; 
				}
				//System.out.println("Ergebnis nach Komma: ");
			} else if(vorKomma){
				ergebnis = ergebnis * 10 + Character.digit( text[i], 10 );
				//System.out.println(""+ergebnis+" "+Character.digit( text[i], 10 ));
			} else {
				nachkomma = nachkomma / 10;
				ergebnis = ergebnis + Character.digit( text[i], 10 )*nachkomma;
				//System.out.println(""+ergebnis+" "+Character.digit( text[i], 10 ));
			}
		}
		if (negativ) {ergebnis = -ergebnis;}
		if(vorKomma) {vorKomma = false; ergebnis = ergebnis*genauigkeit;}
		//System.out.println("Ergebnis: "+ergebnis);
		return ergebnis;
	}
	
	public boolean istGleichesSoll(int zeile, int spalte, String soll){
		//Kann auch für Haben benutzt werden.
		boolean ergebnis = false;
		if(zeile > -1 && zeile < zeilen && spalte > -1 && spalte < spalten){
			int links = stringToInt(daten[zeile][spalte]);
			int rechts = stringToInt(soll);
			if((links == rechts) && (links != 0))
				ergebnis = true;
			/*if(ergebnis)
				System.out.println("TiGS_: "+links+" "+rechts+" "+": "+daten[zeile][spalte]+" "+soll);
			else
				System.out.println("FiGS_: "+links+" "+rechts+" "+": "+daten[zeile][spalte]+" "+soll);
				*/
		}
		return ergebnis;
	}
	
	public boolean istGleichesSoll(int zeile, int spalte, String sollT, String habenT){
		//Links nur Soll, Rechts Soll und Haben
		//Immer die Summe einer Buchung vergleichen!!!
		boolean ergebnis = false;
		if(zeile > -1 && zeile < zeilen && spalte > -1 && spalte < spalten){
			int links = stringToInt(daten[zeile][spalte]);
			int soll  = stringToInt(sollT);
			int haben = stringToInt(habenT);
			if((links != 0) && (links == soll - haben))
				ergebnis = true;
			/*
			if(ergebnis)
				System.out.println("TiGS__: "+links+" "+soll+" "+haben+": "+daten[zeile][spalte]+" "+sollT+" "+habenT);
			else
				System.out.println("FiGS__: "+links+" "+soll+" "+haben+": "+daten[zeile][spalte]+" "+sollT+" "+habenT);
			*/
		}
		return ergebnis;
	}
	
	public boolean istGleichesSoll(int zeile, int spalte, int hspalte, String sollT, String habenT){
		//Links nur Soll, Rechts Soll und Haben
		//Immer die Summe einer Buchung vergleichen!!!
		boolean ergebnis = false;
		if(zeile > -1 && zeile < zeilen && spalte > -1 && spalte < spalten && hspalte > -1 && hspalte < spalten){
			int links  = stringToInt(daten[zeile][spalte]);
			int rechts = stringToInt(daten[zeile][hspalte]);
			int soll   = stringToInt(sollT);
			int haben  = stringToInt(habenT);
			if((links - rechts == soll - haben) && ((soll - haben) != 0))
				ergebnis = true;
			/*
			if(ergebnis)
				System.out.println("TiGS__: "+links+" "+soll+" "+haben+": "+daten[zeile][spalte]+" "+sollT+" "+habenT);
			else
				System.out.println("FiGS__: "+links+" "+soll+" "+haben+": "+daten[zeile][spalte]+" "+sollT+" "+habenT);
			*/
		}
		return ergebnis;
	}
	
	public boolean Summanden(){
		return Summanden;
	}
	
	public boolean ohneDatum(){
		return ohneDatumRCB;
	}
	
	public int getBuchwert(int zeile){
		int ergebnis = 0;
		int links = 0;
		int rechts = 0;
		if(zeile > -1 && zeile < zeilen){
			if(wahlSoll > -1 && wahlSoll < spalten)
				links  = stringToInt(daten[zeile][wahlSoll]);
			if(wahlHaben > -1 && wahlHaben < spalten)
				rechts = stringToInt(daten[zeile][wahlHaben]);
			if(vorzeichen){
				ergebnis = links + rechts;
			} else {
				ergebnis = links - rechts;
			}
			
		}
		return ergebnis;
	}
	
	public void setInvinsible(DateiDaten kurz){
		this.kurz = kurz;
	}
	  
	public DateiDaten getInvinsible(){
		return kurz;
	}
	
	public void setZeile(int i, int j){
		if(j > -1 && j < zeilen)
			zeile[j] = i;
	}
	
	public int getZeile(int i){
		int ausgabe = 0;
		if(datev){
			if(i > -1 && i < datevzeilen)	
				ausgabe = zeile[i];
		} else {
			if(i > -1 && i < zeilen)
				ausgabe = zeile[i];
		}
		return ausgabe;
	}
	
	public void resetStatus(){
		saldofertig = false;
		for(int i = 0; i < zeilen; i++){
			status[i] = 0;
			ziffern[i] = 0;
		}
		maxZiffer = 0;
	}
	
	public int getSollSumme(){
		int sollsumme = 0;
		for(int zeile = 0; zeile < zeilen; zeile++)
			if(wahlSoll > -1 && wahlSoll < spalten)
				sollsumme = sollsumme +stringToInt(daten[zeile][wahlSoll]);
		return sollsumme;
	}
	
	public int getHabenSumme(){
		int habensumme = 0;
		for(int zeile = 0; zeile < zeilen; zeile++)
			if(wahlHaben > -1 && wahlHaben < spalten)
				habensumme = habensumme + stringToInt(daten[zeile][wahlHaben]);
		return habensumme;
	}
	
	public int getSaldo(int zeile){
		int laufsaldo = 0;
		if(saldofertig && null != saldo){
		} else {
			saldofertig = true;
			saldo = new int[zeilen];
			for(int i = 0; i < zeilen; i++){
				laufsaldo = laufsaldo + getBuchwert(i);
				saldo[i] = laufsaldo;
				
			}
		}
		return saldo[zeile];
	}
	
	public void setGUIVorzeichen(boolean vorzeichen){
		/*
			Es gibt Programme, wie z.B. Domus 4000, welche die Spalten nach
			Forderungen und Zahlungen gliedern. Das bedeutet aber, dass 
			sich die Salden nicht ausgleichen.
			Forderung	Zahlung	Saldo	Nach unserer Saldoberechnung:
			-900			-900	 900
					900	0	1800
			Ergo dürfen wir in solch einem Fall nicht die Spalte berücksichtigen,
			sondern nur die Vorzeichen.
		*/
		this.vorzeichen = vorzeichen;
	}
	
	
	//b[i] = sort_merge[i]
	//a[i] = sort[i]
	// Variante b
	void merge(int lo, int m, int hi){
		//https://www.inf.hs-flensburg.de/lang/algorithmen/sortieren/merge/mergiter.htm
		int i, j, k;
		i=0; j=lo;
		// vordere Hälfte von a in Hilfsarray b kopieren
		while (j<=m)
			sort_merge[i++]=sort[j++];

		i=0; k=lo;
		// jeweils das nächstgrößte Element zurückkopieren
				while (k<j && j<=hi){
					/*
					System.out.println("i: "+i);
					System.out.println("Sort_MErge["+i+"]: "+sort_merge[i]);
					System.out.println("DatumInt["+i+"]: "+datumInt[sort_merge[i]]);
					*/
					if (datumInt[sort_merge[i]] <= datumInt[sort[j]])
						sort[k++]=sort_merge[i++];
					else
						sort[k++]=sort[j++];
				}
		// Rest von b falls vorhanden zurückkopieren
		while (k<j)
			sort[k++]=sort_merge[i++];
	}

	private int max(int a, int b){
		//https://www.inf.hs-flensburg.de/lang/algorithmen/sortieren/merge/mergiter.htm
		return a>b? a: b;
	}
    
	public void sortieren(){
		/* 	Wir wollen Datumsvergleiche machen und benötigen dafür die Daten.
			Zuerst einmal eine Liste erstellen mit Daten.
		*/
		
		machDatum();
		if(mussSortieren()){
		
			sort = new int[zeilen];       //zu sortierendes Feld
			sort_merge = new int[zeilen]; //Hilfsfeld
		
			for(int i = 0; i < zeilen; i++){
				sort[i] = i;
				sort_merge[i] = i;
				//System.out.println("datumInt["+i+"]: "+datumInt[i]);
			}
		
			//https://www.inf.hs-flensburg.de/lang/algorithmen/sortieren/merge/mergiter.htm
			int n = zeilen;//loesungen;
		
			int m, s;
			for (s=1; s<n; s+=s){
				for (m=n-1-s; m>=0; m-=s+s)
					merge(max(m-s+1, 0), m, m+s);
			}
		
			//Alle Daten kopieren
			String[][] austausch = new String[zeilen][spalten];
			for(int i= 0; i < zeilen; i++)
				for(int j = 0; j < spalten; j++)
					austausch[i][j] = daten[sort[i]][j];
			for(int i= 0; i < zeilen; i++)
				for(int j = 0; j < spalten; j++)
					daten[i][j] = austausch[i][j];
		}
		//machDatum();
		/*
		for(int i = 0; i < zeilen; i++)
			System.out.println("Ausgabe: "+daten[i][wahlDatum]+" "+datumInt[i]+" "+datumInt[sort[i]]);
		*/

	}
	
	private boolean mussSortieren(){
		boolean ergebnis = false;
		for(int i = 0; i < zeilen-1; i++){
			if(datumInt[i] > datumInt[i+1])
				ergebnis = true;
		}
		if(ergebnis)
			System.out.println("Muss sortiert werden!");
		else
			System.out.println("Muss NICHT sortiert werden!");
		return ergebnis;
	}
	
	private void machDatum(){
		datumInt = new int[zeilen];
		String datumL = "";
		String[] dutamL;
		int tagL = 0;
		int monatL = 0;
		int jahrL = 0;
		
		if(wahlDatum > -1){
			for(int i = 0; i < zeilen; i++){
				datumL = getText(i, wahlDatum);
				//System.out.println("datumL: "+datumL);
				if(Pattern.matches("[0-9]?[0-9]\\.[0-9]?[0-9]\\.[0-9]?[0-9]?[0-9][0-9]", datumL)){
					//Format von Domus und StarMoney
					dutamL = datumL.split("\\.");
					try{
						//System.out.println("Split: "+datumL+"---"+dutamL[0]);
						tagL = Integer.parseInt(dutamL[0]);
						monatL = Integer.parseInt(dutamL[1]);
						jahrL = Integer.parseInt(dutamL[2]);
						//System.out.println("Datum: "+tagL+"."+monatL+"."+jahrL+" datumInt: "+datumInt[i]);
					} catch (NumberFormatException nfe){
						//Nüscht. Funktioniert doch.
					}
				} else if(Pattern.matches("[0-9]?[0-9][0-9][0-9]", datumL)){
					//Format von Datev
					datumL = datumL.trim();
					try{
						if(datumL.length() > 3){
							tagL = Integer.parseInt(datumL.substring(0, 2));
							monatL = Integer.parseInt(datumL.substring(2, 4));
						} else {
							tagL = Integer.parseInt(datumL.substring(0, 1));
							monatL = Integer.parseInt(datumL.substring(1, 3));
						}
					} catch (NumberFormatException nfe){
						//Nüscht. Funktioniert doch.
					}
				}
				datumInt[i] = jahrL * 10000 + monatL * 100 + tagL;
			}
		} else {
			System.out.println("Kein Wahldatum!");
		}
	}
}
