public class DatevDaten{
	private int anzahl = 0; 
	private Buchung[] journal;
	private int genauigkeit = 100;
	private int wo = 0;//nächste Eintragung
	private PrimanotaTableModel ptm;
	private KontoTableModel ktm;
	private int max_Kontenplan = 0;
	private boolean[] use      = new boolean[max_Kontenplan];
	private int maxUse         = 0;//Wieviele Konten werden benutzt?
	private Konto[] konto      = new Konto[max_Kontenplan];// Hier werden die Buchungen eingepflegt.
	private int kontonummer    = 0;//Aktuelle Kontonummer
	
	public DatevDaten(DatevDaten daten, int hinzu){
		//Wir konstruieren uns aus uns selber
		int neu = 0;
		if(null == daten)
			neu = hinzu;
		else
			neu = daten.getAnzahl() + hinzu;
		journal = new Buchung[neu];
		if(null != daten){
			//kopiere alte Daten
			for(int i = 0; i < daten.getAnzahl(); i++)
				journal[i] = daten.getBuchung(i);
			wo = daten.getAnzahl();
		}
	}
	
	public int getAnzahl(){
		anzahl = 0;
		if(null == journal)
			anzahl = 0;
		else
			anzahl = journal.length;
		return anzahl;
	}
	
	public Buchung getBuchung(int i){
		Buchung b = null;
		if(null != journal && i < journal.length)
			b = journal[i];
		return b;
	}
	
	public void setBuchung(Buchung buchung){
		if(null != journal && null != buchung)
			if(wo >= 0 && wo < journal.length)
				journal[wo++] = buchung;
	}
	
	public int stringToInt(String s){
		if(s == null) s = "";
		s = s.trim();
		int ergebnis = 0;
		boolean vorKomma = true;
		boolean negativ = false;
		char[] text = s.toCharArray();
		int nachkomma = genauigkeit;
		//System.out.print("Ergebnis vor Komma: ");
		for(int i=0; i < text.length;i++){
			if(text[i] == '-') {
				negativ = true;
			} else if (text[i] == '.') {//1.000 enderpunkte
			} else if(text[i] == ','){//| text[i] == '.') {
				if(vorKomma){
					vorKomma = false; 
					ergebnis = ergebnis*genauigkeit; 
				}
				//System.out.println("Ergebnis nach Komma: ");
			} else if(vorKomma){
				ergebnis = ergebnis * 10 + Character.digit( text[i], 10 );
				//System.out.println(""+ergebnis+" "+Character.digit( text[i], 10 ));
			} else {
				nachkomma = nachkomma / 10;
				ergebnis = ergebnis + Character.digit( text[i], 10 )*nachkomma;
				//System.out.println(""+ergebnis+" "+Character.digit( text[i], 10 ));
			}
		}
		if (negativ) {ergebnis = -ergebnis;}
		if(vorKomma) {vorKomma = false; ergebnis = ergebnis*genauigkeit;}
		//System.out.println("Ergebnis: "+ergebnis);
		return ergebnis;
	}
	
	public PrimanotaTableModel getTableModel(){
		ptm = new PrimanotaTableModel();
		//Zeile, Betrag, S/H, Gegenkonto, Konto, Beleg1, Beleg2, Text = 8
		ptm.setData(wo, this);
		return ptm;
	}
	
	public KontoTableModel getKontoTableModel(){
		return ktm;
	}
	
	
	
	public void kontieren(){
		//Alle Daten in Konten quetschen.
		int max = 0;
		//System.out.println("Wo: "+wo+"\njournal["+journal.length+"]");
		//max = Größte Kontonummer herausfinden
		for(int i = 0; i < wo; i++){
			if(null != journal[i]){
				if(journal[i].getSoll() > max)
					max = journal[i].getSoll();
				if(journal[i].getHaben() > max)
					max = journal[i].getHaben();
			}
		}
		max_Kontenplan = max+1;
		use   = new boolean[max_Kontenplan];
		konto = new Konto[max_Kontenplan];// Hier werden die Buchungen eingepflegt.
		//Aber erst einmal die Strukturen anlegen:
		for(int i = 0; i < max_Kontenplan; i++){
			use[i] = false;
			konto[i] = new Konto(i);
		}
		
		
		//Hier ist die Einpflege der Daten
		
		for(int i = 0; i < wo; i++){
			if(null != journal[i]){
				//System.out.println("Konten: "+journal[i].getSoll()+ " "+journal[i].getHaben());
				konto[journal[i].getSoll()].neueBuchung(journal[i], i);
				konto[journal[i].getHaben()].neueBuchung(journal[i], i);
				use[journal[i].getSoll()] = true;
				use[journal[i].getHaben()] = true;
			}
		}
		maxUse = 0;
		//System.out.print("Die Kontozahlen:");
		for(int i = 0; i < max_Kontenplan; i++){
			if(use[i]){
				//System.out.print(" "+i);
				maxUse++;
			}
		}
		//System.out.println();
		
		ktm = new KontoTableModel();
		//Zeile, Datum, Soll, Haben, Saldo, Gegen, Beleg1, Beleg2, Text = 9
		ktm.setData(this);
		
	}
	
	public int getFirstKonto(){
                int raus = -1;
                int i = -1;
                //log.finest("getNextKonto i: "+i);
                boolean weiter = true;
                i++;
                while(weiter && i < max_Kontenplan){
                        if(use[i]){
                                raus = i;
                                weiter = false;
                        } else {
                                i++;
                        }
                }
                kontonummer = raus;
		ktm.setKonto(kontonummer);
                ktm.fireTableDataChanged();
                return raus;
        }

	public int getLastKonto(){
                int raus = max_Kontenplan;
                int i = max_Kontenplan;
                boolean weiter = true;
                i--;
                while(weiter && i > -1){
                        if(use[i]){
                                raus = i;
                                weiter = false;
                        } else {
                                i--;
                        }
                }
                kontonummer = raus;
		ktm.setKonto(kontonummer);
                ktm.fireTableDataChanged();
                return raus;
        }
	
	public int getNextKontonummer(){
		int raus = kontonummer;
		int i = kontonummer;
		boolean weiter = true;
		i++;
		while(weiter && i < max_Kontenplan){
			if(use[i]){
				raus = i;
				weiter = false;
			} else {
				i++;
			}
		}
		kontonummer = raus;
		return raus;
	}
	
	public int getPreviousKontonummer(){
		int raus = kontonummer;
		int i = kontonummer;
		boolean weiter = true;
		i--;
		while(weiter && i > 0){
			if(use[i]){
				raus = i;
				weiter = false;
			} else {
				i--;
			}
		}
		kontonummer = raus;
		return raus;
	}
	
	public int getKontonummer(){
		return kontonummer;
	}
	
	public int getKontonummer(int konto){
		//System.out.println("Anfrage: Gibt es Konto "+konto+"?");
		int raus = kontonummer;
		int hoch = kontonummer;
		int runter = kontonummer;
		boolean weiter = true;
		
		if(konto > 0 && konto < max_Kontenplan){
			if(use[konto]){
				raus = konto;
				weiter = false;
			} else {
				hoch = konto + 1;
				runter = konto -1;
				while(weiter){
					if(runter > 0){
						if(use[runter]){
							raus = runter;
							weiter = false;
						}
					}
					if(hoch < max_Kontenplan){
						if(use[hoch]){
							raus = hoch;
							weiter = false;
						}
					}
					runter--;
					hoch++;
					if(runter <= 0 && hoch >= max_Kontenplan)
						weiter = false;
				}
			}
		}
		kontonummer = raus;
		return raus;
	}
	
	public Konto getKonto(){
		return konto[kontonummer];
	}
	
	public Konto getKonto(int i){
		return konto[i];
	}
	
	public int getMaxKontenplan(){
		return max_Kontenplan;
	}
	
	public SuSaTableModel getSuSaTableModel(){
		SuSaTableModel stm = new SuSaTableModel();
		stm.setData(this);
		getFirstKonto();
		return stm;
	}
	
	public int getMaxUse(){
		return maxUse;
	}
	

}