import javax.swing.*;

public class DatevKopieVergleichThread extends Thread{

	private DateiDaten daten;
	private Buchhalter bh;
	private Konto konto;
	private int ladeWas = 0;
	
	public DatevKopieVergleichThread(Buchhalter bh, Konto konto, DateiDaten daten, int ladeWas){
		this.bh = bh;
		this.konto = konto;
		this.daten = daten;
		this.ladeWas = ladeWas;
	}
	
	public void run(){
		int zeilen = konto.getRowCount();
		bh.setDatevMax(zeilen);
		bh.setDatevStatus(0);
		for(int i = 0; i < zeilen; i++){
			daten.einlesen(i, 0, ""+konto.getIndex(i));//welche Zeile im Journal
			daten.einlesen(i, 1, konto.getDatum(i).toString());
			daten.einlesen(i, 2, ""+bh.intToString(konto.getSoll(i)));
			daten.einlesen(i, 3, ""+bh.intToString(konto.getHaben(i)));
			daten.einlesen(i, 4, ""+bh.intToString(konto.getSaldo(i)));
			daten.einlesen(i, 5, ""+konto.gegen(i));
			daten.einlesen(i, 6, ""+konto.getBeleg1(i));
			daten.einlesen(i, 7, ""+konto.getBeleg2(i));
			daten.einlesen(i, 8, ""+konto.getBuchungstext(i));
			bh.setDatevStatus(i);
		}
		bh.setDatevStatus(zeilen);
		bh.nachtoVergleich(ladeWas, daten);
	}
}
