import javax.swing.table.AbstractTableModel;
import java.text.DecimalFormat;

class KontoTableModel extends AbstractTableModel {
	private static final long serialVersionUID = 1L;
	private boolean DEBUG = false;
	private DecimalFormat nf = new DecimalFormat();
	private String[] columnNames;
	private int column, row = 0;
	private int genauigkeit = 100;
	private String genautext = "";
	private DatevDaten daten;
	private Konto konto;

	private Object[][] data;
  
	public void setData(DatevDaten daten){
		Buchung buchung;
		if(null != daten)
			this.daten = daten;
		this.column = 9;
		konto = daten.getKonto(daten.getFirstKonto());
		row = konto.getRowCount()+2;
		//Erste Zeile = Anfangsbestand
		//Letzte Zeile = Summe von Soll Haben 
		if(row > 2)
			this.row = row;
		columnNames = new String[column];
		columnNames[0] = "Zeile";
		columnNames[1] = "Datum";
		columnNames[2] = "Soll";
		columnNames[3] = "Haben";
		columnNames[4] = "Saldo";
		columnNames[5] = "Gegen";
		columnNames[6] = "Beleg1";
		columnNames[7] = "Beleg2";
		columnNames[8] = "Text";
		data = new Object[row][column];
		for(int i = 0; i < 9; i++){
			data[0][i] = "";
			data[row-1][i] = "";
		}
		data[0][4] = ""+intToString(konto.getAnfangsbestand());
		for(int i = 1; i < row-2; i++){
			data[i][0] = ""+konto.getIndex(i-1);
			data[i][1] = ""+konto.getDatum(i-1).toString();
			data[i][2] = ""+intToString(konto.getSoll(i-1));
			data[i][3] = ""+intToString(konto.getHaben(i-1));
			data[i][4] = ""+intToString(konto.getSaldo(i-1));
			data[i][5] = ""+konto.gegen(i-1);
			data[i][6] = ""+konto.getBeleg1(i-1);
			data[i][7] = ""+konto.getBeleg2(i-1);
			data[i][8] = ""+konto.getBuchungstext(i-1);
		}
		data[row-1][0] = "Summen:";
		data[row-1][2] = konto.getSuSaSoll();
		data[row-1][3] = konto.getSuSaHaben();
		data[row-1][4] = konto.getSaldo();
		
		genautext = "";
		int genau = genauigkeit;
		while(genau > 9){
			genautext = genautext + "0";
			genau = genau / 10;
		}  	
	}
  
	public void setWerte(int col, int row, int wert){
		if(col >= 0 && row >= 0){
			String text = "";
			String vortext = "";//0en zwischen Komma und Wert sonst:(0,005) -> (0,5)
			int nullgenau;
			int genauigkei = genauigkeit;//Sonst wieder nur Ärger
			int betrag = 0;
			boolean unterNull = false;
			if(wert == 1) genauigkei = genauigkeit -1;
			unterNull = (wert < 0);
			if(unterNull)
				betrag = -wert;
			else
				betrag = wert;
			
			
			if(0 != wert){
				
				nullgenau = genauigkei/betrag;
				if ((nullgenau == 0) && (betrag-(betrag/genauigkei)*genauigkei > 0))
					nullgenau = genauigkei/(betrag-(betrag/genauigkei)*genauigkei);
				//System.out.println("ng g/w "+nullgenau+"="+genauigkei+"/"+wert);
				//System.out.println("ng g/b "+nullgenau+"="+genauigkei+"/"+betrag);
				while(nullgenau > 10){
					//System.out.println("Vortext: "+vortext+" Ng: "+nullgenau);
					vortext = vortext + "0";
					nullgenau = nullgenau / 10;
				}
				//System.out.println("Vortext: "+vortext+" Ng: "+nullgenau);
				text = ""+tausender(wert/genauigkei);
				//System.out.println("text = wert/genau : "+text+"="+wert+"/"+genauigkei);
				if((betrag % genauigkei) != 0){
					/*if(unterNull){
						text = text + ","+ vortext+((-wert) % genauigkei);
					} else {
						text = text + ","+ vortext+(wert % genauigkei);
					}
					*/
					text = text + ","+ vortext+(betrag % genauigkei);
				}	else
					text = text + ","+genautext; 
				if(unterNull){
					
					if(wert <= -genauigkeit)
						text = text;
					else
						text = "-"+text;
				}
				//System.out.println("Text: "+text);
			} else
				text = "";
			//System.out.println("STM: "+row+" : "+col);
			
			data[row][col] = text;
		}
	}
	
	public void setKonto(int k){
		if( k >= 0 && k < daten.getMaxKontenplan()){
			konto = daten.getKonto(k);
			row = konto.getRowCount()+2;
			if(row > 2)
				this.row = row;
			data = new Object[row][column];
			
			data[0][4] = ""+intToString(konto.getAnfangsbestand());
			for(int i = 1; i < row-1; i++){
				data[i][0] = ""+konto.getIndex(i-1);
				data[i][1] = ""+konto.getDatum(i-1).toString();
				data[i][2] = ""+intToString(konto.getSoll(i-1));
				data[i][3] = ""+intToString(konto.getHaben(i-1));
				data[i][4] = ""+intToString(konto.getSaldo(i-1));
				data[i][5] = ""+konto.gegen(i-1);
				data[i][6] = ""+konto.getBeleg1(i-1);
				data[i][7] = ""+konto.getBeleg2(i-1);
				data[i][8] = ""+konto.getBuchungstext(i-1);
			}
			data[row-1][0] = "Summen:";
			data[row-1][2] = intToString(konto.getSuSaSoll());
			data[row-1][3] = intToString(konto.getSuSaHaben());
			data[row-1][4] = intToString(konto.getSaldo());
		} else {
			System.out.println("Hier ist die Kacke am Dampfen!");
		}
			
	}
  
  
	public int getColumnCount() {
		return columnNames.length;
	}

	public int getRowCount() {
		return data.length;
	}

	public String getColumnName(int col) {
		return columnNames[col];
	}

	public Object getValueAt(int row, int col) {
		return data[row][col];
	}

  /*
   * JTable uses this method to determine the default renderer/ editor for
   * each cell. If we didn't implement this method, then the last column
   * would contain text ("true"/"false"), rather than a check box.
   */
  //public Class getColumnClass(int c) {
  //  return getValueAt(0, c).getClass();
  //}

  /*
   * Don't need to implement this method unless your table's editable.
   */
	public boolean isCellEditable(int row, int col) {
		//Note that the data/cell address is constant,
		//no matter where the cell appears onscreen.
		if (col < 1) {
			return true;
		} else {
			return false;
		}
	}

  /*
   * Don't need to implement this method unless your table's data can
   * change.
   */
	public void setValueAt(Object value, int row, int col) {
		if (DEBUG) {
			System.out.println("Setting value at " + row + "," + col
			+ " to " + value + " (an instance of "
			+ value.getClass() + ")");
		}

		data[row][col] = value;
		fireTableCellUpdated(row, col);

		if (DEBUG) {
			System.out.println("New value of data:");
			printDebugData();
		}
	}

	private void printDebugData() {
		int numRows = getRowCount();
		int numCols = getColumnCount();

		for (int i = 0; i < numRows; i++) {
			System.out.print("  row " + i + ":");
			for (int j = 0; j < numCols; j++) {
				System.out.print("  " + data[i][j]);
			}
			System.out.println();
		}
		System.out.println("--------------------------");
	}

	public String tausender(int zahl){
		String tausender = ""+nf.format(zahl);
		return tausender;
	}
	
	public String intToString(int wert){
		int genauigkei = genauigkeit;//Sonst nur Ärger
		boolean unterNull = (wert < 0);
		int betrag = wert;
		String text = "";
		if(unterNull)
			betrag = -wert;
		else
			betrag = wert;
  	
		if(betrag == 1) genauigkei = genauigkeit -1;
		text = ""+tausender(betrag/genauigkei);
					
					
		String genautext = "";
		int genau = genauigkei;
		String vortext = "";//0en zwischen Komma und Wert sonst:(0,005) -> (0,5)
		if(betrag == 0){
			text = "0,00";
		} else {
			int nullgenau = genauigkei/betrag;
			if ((nullgenau == 0) && (betrag-(betrag/genauigkei)*genauigkei > 0))
   			nullgenau = genauigkei/(betrag-(betrag/genauigkei)*genauigkei);
			while(nullgenau > 10){
				vortext = vortext + "0";
				nullgenau = nullgenau / 10;
			}
	
			while(genau > 10){
				genautext = genautext + "0";
				genau = genau / 10;
			}
	
			if((betrag % genauigkei) != 0){
				text = text + ","+vortext+ (betrag % genauigkei);
			}	else 
				text = text + ","+genautext+"0"; 
			if(unterNull)
				text = "-"+text;
		}
		//System.out.println("Wert: "+wert+" Text: "+text);
		return text;
	}
	
	public String shortToString(short i){
		String ausgabe = "";
		if(i < 10)
			ausgabe = "0";
		ausgabe = ausgabe + i;
		return ausgabe;
	}
}

