import javax.swing.*;

public class VergleichData extends Thread{
	private Buchhalter bh;
	private JFrame f;
	private DateiDaten links, rechts;
	private long Endzeit = System.currentTimeMillis();
	private long Startzeit = System.currentTimeMillis();
	private OrgaTimer timer;
	private int maxAuswahl = 30;
	private int[] fundsachen;
	private int zeileG, zifferG = 0;// Global

	public VergleichData(Buchhalter bh, JFrame f, DateiDaten links, DateiDaten rechts, int maxAuswahl){
		super();
		this.bh = bh;
		this.f = f;
		this.links = links;
		this.rechts = rechts;
		this.maxAuswahl = maxAuswahl;
		timer = new OrgaTimer(this);
	}
	
	@Override public void run(){
		/*
			Wir lassen vorher (noch einmal) testen, ob alles stimmt.
			Und erst dann gehen wir mit der Arbeit los.
		*/
		Startzeit = System.currentTimeMillis();
		TestData td = new TestData(bh, f, links, rechts);
		td.bitteAntworten(this);
		td.start();
		timer.start();
		stups();
	}
	
	public void allesGut(){
		/*
			Yeah! Wir haben Antwort erhalten.
			Los gehts! Jetzt sind wir drann.
		*/		
		
		//Anfang
		if(links.getStornoFirst()) storno(links);
		if(rechts.getStornoFirst()) storno(rechts);
		
		sucheTreffer(true);//Alle Treffer Suchen, nur mit dem gleichen Datum
		
		
		if(links.Summanden()) sucheSummanden(true);//Alle Summanden zu einem Feld suchen, mit dem gleichen Datum
		
		if(links.ohneDatum()) sucheTreffer(false);//Alle Treffer Suchen, auch ohne gleiches Datum
		
		//Ende
		if(!links.getStornoFirst()) storno(links);
		if(!rechts.getStornoFirst()) storno(rechts);
		
		/*
			WARNUNG: 	RADIOAKTIV
								KANN EWIG DAUERN!!!
								Daher nach der Eleminierung der Stornierungen.
		*/
		//sucheSummanden(false);//Alle Summanden zu einem Feld suchen, ohne gleiches Datum
		if(links.ohneDatum() && links.Summanden()) sucheSummanden(false);
		
		
		System.out.println("Fertig: ");
		ende();
	}
	
	public void storno(DateiDaten dd){
		/*
			Nur innerhalb einer Datei.
			Status = 5;
			DateiDaten.status_STORNO;
		*/
		
	}
	
	public void sucheTreffer(boolean mitDatum){
		int maxZeilenl = links.getZeilen();
		int maxZeilenr = rechts.getZeilen();
		int datuml = links.getWahlDatum();
		int datumr = rechts.getWahlDatum();
		int sollL = links.getWahlSoll();
		int sollR = rechts.getWahlSoll();
		int habenL = links.getWahlHaben();
		int habenR = rechts.getWahlHaben();
		int ziffer = 0;
		boolean nurSollL = (links.getWahlHaben() == -1);
		boolean nurSollR = (rechts.getWahlHaben() == -1);
		boolean treffer = false;
		
		//Status setzen:
		bh.setMaxVergleich(true, maxZeilenl);
		bh.setStatusVergleich(true, 0);
		
		if(mitDatum && datuml > -1 && datumr > -1){
			for(int i = 0; i < maxZeilenl; i++){
				zeileG = i;
				if(links.status(i) == 0){
					//Nur Zeilen suchen, die noch kein Ergebnis haben.
					/*
						Wenn nur mit Datum ausgewählt, 
					*/
					if(links.istDatum(i,datuml) ){//|| (!links.istDatum(i,datuml) && links.getZeilenOhneDatum())){
						for(int j = 0; j < maxZeilenr; j++){
							if(rechts.status(j) == 0 && rechts.istDatum(j,datumr)){
								//Was ist mit rechts.getZeilenOhneDatum()
								//System.out.print("#L "+links.getText(i
								if(links.istGleichesDatum(i, datuml, rechts.getText(j, datumr))){
									//GLEICHES DATUM!!!
									//IF(links == rechts) 1 eintragen, next i => j = maxZeilenr
									//Nicht nur die einzelnen Werte vergleichen!!! (Soll Zahl Haben = 0,00 -> führt zu komischen
									//Ergebnissen. Immer die Summe beider Buchungen vergleichen!!!
									treffer = false;
									if(nurSollL && nurSollR){
										//Beide kein Haben
										if(links.istGleichesSoll(i, sollL, rechts.getText(j, sollR)))
											treffer = true;
									} else if(nurSollL) {
										//Links hat kein Haben
										if(links.istGleichesSoll(i, sollL, rechts.getText(j, sollR), rechts.getText(j, habenR)))
											treffer = true;
									} else if(nurSollR) {
										//Rechts hat kein Haben
										if(rechts.istGleichesSoll(j, sollR, links.getText(i, sollL), links.getText(i, habenL)))
											treffer = true;
									} else {
										//Beide haben Soll und Haben
										if(links.istGleichesSoll(i, sollL, habenL, rechts.getText(j, sollR), rechts.getText(j, habenR)))
											treffer = true;
									}
									if(treffer){
										ziffer = links.getNextZiffer();
										zifferG = ziffer;
										links.setZiffer(i,ziffer);
										rechts.setZiffer(j,ziffer);
										links.setStatus(i,DateiDaten.status_GEFUNDEN);
										rechts.setStatus(j,DateiDaten.status_GEFUNDEN);
										j = maxZeilenr;
									}
								}
							}
						}
					}
				}
				
				bh.setStatusVergleich(true, i);
			}
		} else if(!mitDatum){
			// Die ganze Datei durchkämmen
			for(int i = 0; i < maxZeilenl; i++){
				zeileG = i;
				if(links.status(i) == 0){
					for(int j = 0; j < maxZeilenr; j++){
						if(rechts.status(j) == 0){
							treffer = false;
							if(nurSollL && nurSollR){
								//Beide kein Haben
								if(links.istGleichesSoll(i, sollL, rechts.getText(j, sollR)))
									treffer = true;
							} else if(nurSollL) {
								//Links hat kein Haben
								if(links.istGleichesSoll(i, sollL, rechts.getText(j, sollR), rechts.getText(j, habenR)))
									treffer = true;
							} else if(nurSollR) {
								//Rechts hat kein Haben
								if(rechts.istGleichesSoll(j, sollR, links.getText(i, sollL), links.getText(i, habenL)))
									treffer = true;
							} else {
								//Beide haben Soll und Haben
								if(links.istGleichesSoll(i, sollL, habenL, rechts.getText(j, sollR), rechts.getText(j, habenR)))
									treffer = true;
							}
							if(treffer){
								ziffer = links.getNextZiffer();
								zifferG = ziffer;
								links.setZiffer(i,ziffer);
								rechts.setZiffer(j,ziffer);
								links.setStatus(i,DateiDaten.status_GEFUNDEN_WEIT);
								rechts.setStatus(j,DateiDaten.status_GEFUNDEN_WEIT);
								j = maxZeilenr;
								//System.out.println("Gefunden ohne Datum: "+i+": "+ziffer+" "+j);
							}
						}
					}
				}
				bh.setStatusVergleich(true, i);
			}
		}
		bh.setStatusVergleich(true, maxZeilenl);
		//stups();
		/*try {
				this.sleep(1500);
			} catch (InterruptedException e) {
   		// Thread wurde abgebrochen
			}
		*/
	}
	
	public void sucheSummanden(boolean mitDatum){
		/*
			Die Suche ist hier etwas einfacher, aber dennoch erst zu meistern.
			Zuerst wird die offensichtliche Lösung genommen (ALLE Summanden) und probiert.
			Ist die Lösung falsch, wird erst der Thread genommen.
			
			Aber auch hier benötigen wir eine einfachere Version: 
			Das erste Ergebnis wird genommen. Es stehen keine weiteren Durchläufe mehr an.
			Und wir beschränken die Summanden auf maxAuswahl Stück.
		
			Desweiteren wird immer die Variablenoptimierund und die Identitätslösung genommen,
			damit möglichst wenig berechnet wird.
		*/
		int maxZeilenl = links.getZeilen();
		int maxZeilenr = rechts.getZeilen();
		int datuml = links.getWahlDatum();
		int datumr = rechts.getWahlDatum();
		int sollL = links.getWahlSoll();
		int sollR = rechts.getWahlSoll();
		int habenL = links.getWahlHaben();
		int habenR = rechts.getWahlHaben();
		int ziffer = 0;
		int suche = 0;
		boolean nurSollL = (links.getWahlHaben() == -1);
		boolean nurSollR = (rechts.getWahlHaben() == -1);
		boolean treffer = false;
		fundsachen = new int[maxZeilenr];

		
		
		
		//Status setzen:
		bh.setMaxVergleich(true, maxZeilenl);
		bh.setStatusVergleich(true, 0);
		boolean halt = false;

		
		if(mitDatum && datuml > -1 && datumr > -1){
			for(int nochEinmal = 0; nochEinmal < 3; nochEinmal++)//Wenn mehrere Sammler auf einmal gelaufen sind, dann können mehrere gefunden werden, auch wenn maxAnzahl zu klein ist für alle.
			for(int i = 0; i < maxZeilenl; i++){//Alle Zeilen linke Spalte
				zeileG = i;
				if(links.status(i) == 0){
					//System.out.println("VG: Zeile: "+i);
					//System.out.println("VG: Status == 0");
					for(int j = 0; j < maxZeilenr; j++)
						fundsachen[j] = 0; 
					if(links.istDatum(i,datuml) ){
						suche = links.getBuchwert(i);
						if(suche != 0){
							//System.out.println("VG: Suche: "+suche);
							for(int j = 0; j < maxZeilenr; j++){
								if(rechts.status(j) == 0 && rechts.istDatum(j,datumr)){
									//System.out.print("#L "+links.getText(i
									if(links.istGleichesDatum(i, datuml, rechts.getText(j, datumr))){
										//GLEICHES DATUM!!!
										fundsachen[j] = 1;//Rechte Seite
									}
								}
							}
							//System.out.println("VG: Alle Zeilen Rechts aufgenommen.");
							/*Hier geht es los mit der richtigen Suche.
								Wegen Chaos muss das alles hier passieren, da sonst keine
								geordnete Übergabe der Daten möglich.
								Vielleicht einfach eine neue Funktion dafür machen.
								
								Zuerst alle Summieren und testen. Wenn das noch nicht, dann Finde Summe.
							*/
							
							//Daten daten = new Daten(int suche, 0, maxZeilenr, true);
							//daten.setEingabe(int i, int eingabe);
							//Zuerst: Alle Daten einsammeln in fundsachen[i]
							int summe = 0;
							halt = false;
/*							if(i > 65 && i < 75){
								System.out.println("Teste i- "+i);
							}	
*/
							for(int j = 0; j < maxZeilenr; j++){//Rechte Seite bei Linke Zeile i
								if(fundsachen[j] == 1){
									fundsachen[j] = rechts.getBuchwert(j);//Ersetze fundsachen 1 mit dem Buchwert
									summe = summe + fundsachen[j];
									if(summe == suche){
										//Hier ist es sehr fehleranfällig: 
										//In den Fundsachen sind alle vom gleichen Datum enthalten.
										//Wir brauchen aber nur die, welche bis jetzt sind!!!
						
										ziffer = links.getNextZiffer();
										zifferG = ziffer;
										//System.out.println("***** i+1: "+(i+1)+" Ziffer: "+ziffer);
										//System.out.println("Gefunden: "+ziffer+"----");
										links.setZiffer(i,ziffer);
										//System.out.println("links: "+(i+1));
										for(int k = 0; k < j+1; k++){//Wichtig!!! Nur bis hier hin und nicht weiter!!!
											if(fundsachen[k] != 0){
												//System.out.println("rechts: "+(j+1));
												rechts.setZiffer(k,ziffer);
												rechts.setStatus(k,DateiDaten.status_SAMMLER);
											}
										}
										links.setStatus(i,DateiDaten.status_SAMMLER);
										halt = true;
									}
								}
							}
							//System.out.println("VG: Summe: "+summe);
							if(!halt && summe == suche){
								//sucheErledigt(i,maxZeilenl);
								//System.out.println("Teste i: "+i);
								
								//beendet. Alles schon erledigt. Keine Daten aufnehmen! Alle Daten markieren.
								//System.out.println("Yeah, gefunden");
								ziffer = links.getNextZiffer();
								zifferG = ziffer;
								//System.out.println("***** i+1: "+(i+1)+" Ziffer: "+ziffer);
								//System.out.println("Gefunden: "+ziffer+"----");
								links.setZiffer(i,ziffer);
								//System.out.println("links: "+(i+1));
								for(int j = 0; j < maxZeilenr; j++){
									if(fundsachen[j] != 0){
										//System.out.println("rechts: "+(j+1));
										rechts.setZiffer(j,ziffer);
										rechts.setStatus(j,DateiDaten.status_SAMMLER);
									}
								}
								links.setStatus(i,DateiDaten.status_SAMMLER);
								halt = true;
								
							} else if(!halt){
								//Wir müssen erst die Ergebnisse finden
								//System.out.println("VG: Max Zeilenr: "+maxZeilenr);
								Daten daten = new Daten(suche, 0, maxZeilenr, true, true);
								//bh.progressIntermediate(true, true);
								int maxSucheKandidaten = 0;
								for(int j = 0; j < maxZeilenr; j++){
									if(fundsachen[j] != 0){
										//System.out.println("VG fundsachen["+j+"] = "+fundsachen[j]);
										maxSucheKandidaten++;
										if(maxSucheKandidaten <= maxAuswahl){
											daten.setEingabe(j, fundsachen[j]);
										} else {
											maxSucheKandidaten--;
											fundsachen[j] = 0;
										}
									}
								}
								//System.out.println("VG Kandidaten = "+maxSucheKandidaten);
								if(maxSucheKandidaten > 1){
									//System.out.println("VG: Anzahl der Kandidaten: "+maxSucheKandidaten);
									int stand = 0;
									boolean weiter = true;
									bh.setMaxVergleich(false, maxSucheKandidaten);
									bh.setStatusVergleich(false, 0);
									int lauf = 0;
									while (weiter && (stand < maxSucheKandidaten)){
										//SucheSumme ss = new SucheSumme(this, stand, daten);
										SucheSumme ss = new SucheSumme(stand, daten);
										//daten.print();
										ss.run();
										if(ss.gefunden()){
											Daten loesung = ss.gibLoesung();
											int[] felder = loesung.getLoesungsfeld();
											//System.out.println("VG: felder.length: "+felder.length);
											ziffer = links.getNextZiffer();
											zifferG = ziffer;
											links.setZiffer(i,ziffer);
											//System.out.println("Gefunden2: "+ziffer+"----");
											//System.out.println("links: "+(i+1));
											for(int j = 0; j < maxZeilenr; j++){
												if(felder[j] != 0){
													//System.out.println("rechts: "+(j+1));
													rechts.setZiffer(j,ziffer);
													rechts.setStatus(j,DateiDaten.status_SAMMLER);
												}
											}
											links.setStatus(i,DateiDaten.status_SAMMLER);
											weiter = false;
										}
										bh.setStatusVergleich(false, stand);
										stand++;
										lauf++;
									}
									//System.out.println("**********\n* Lauf: "+lauf+"\n**********");
								}
							}
						}
						bh.progressIntermediate(true, false);
						bh.setMaxVergleich(false, 100);
						bh.setStatusVergleich(false, 100);
					}
					bh.setStatusVergleich(true, i);
				}
				
			}
		} else if(!mitDatum){
		}
		bh.setStatusVergleich(true, maxZeilenl);
		bh.progressIntermediate(true, false);
	}
	
	private void sucheErledigt(int i, int maxZeilenr){
		
		//beendet. Alles schon erledigt. Keine Daten aufnehmen! Alle Daten markieren.
		//System.out.println("Yeah, gefunden");
		int ziffer = links.getNextZiffer();
		zifferG = ziffer;
		//System.out.println("***** i+1: "+(i+1)+" Ziffer: "+ziffer);
		//System.out.println("Gefunden: "+ziffer+"----");
		links.setZiffer(i,ziffer);
		//System.out.println("links: "+(i+1));
		for(int j = 0; j < maxZeilenr; j++){
			if(fundsachen[j] != 0){
				//System.out.println("rechts: "+(j+1));
				rechts.setZiffer(j,ziffer);
				rechts.setStatus(j,DateiDaten.status_SAMMLER);
			}
		}
		links.setStatus(i,DateiDaten.status_SAMMLER);
	}
	
	public void stups(){
  	Endzeit = System.currentTimeMillis();
  	bh.setTime(false, Endzeit-Startzeit);
  	bh.setZeilenZiffer(zeileG+1, zifferG);
  }
  
  public void ende(){
  	timer.ende();
  	bh.setZeilenZiffer(zeileG+1, zifferG);
  }
}

