import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.io.PrintStream;
import javax.swing.*;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JDialog;
import java.text.DecimalFormat;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.nio.file.*;

import java.nio.charset.Charset;
import java.util.Map;

public class Buchhalter implements Runnable{
	//Einstellungen
	/*
		Teilsummenproblem
		https://de.wikipedia.org/wiki/Teilsummenproblem
		https://towardsdatascience.com/how-to-find-all-solutions-to-the-subset-sum-problem-597f77677e45?gi=49bfd46e10bb
		subset sum problem
	*/
	private final String VERSION = "0.65.51.20";//Major, Minor, Bugfix, Build
	private int maxEingabe = 30;//Bis hierin merkt er sich die Eingabe
	private int maxFinder = 1000;
	private Daten datenLeer;
	
	public static final int sort_Anzahl 	= 0;
	public static final int sort_Diff 	= 1;
	private int sort_auswahl = -1;
	public final static int TABLINKS	= 0;//HoleDatei(status) Tabelle Links
	public final static int TABRECHTS	= 1;//HoleDatei(status) Tabelle Rechts
	public final static int TABSALDO	= 2;//HoleDatei(status) Tab Daten Saldo
	public final static int SUMMETXT	= 3;//HoleDatei(status) SummeFinden
	public final static int CSV     	= 4;//HoleDatei(status) CSV
	
	
	private DecimalFormat nf = new DecimalFormat();
	private boolean optimizer = true;
	private int threads = 1;
	private int nachkomma = 2;
	private int genauigkeit = 100;
	private int loesungen = 0;
	private int guteLoesungen = 0;
	private boolean tabellenstatus = false;
	private int benchmarkStatus = 0;
	private int maxAuswahl = 20;
	private int threadindex = 0;//Auswahl 1, 2, 4, 8, 16, 32, ...Threads
	private int erwartung = 0; //Wieviele Gute Ergebnisse erwarte ich
	private int erwartungMax = 20;//Wieviele Gesamtergebnisse erwarte ich.
	
	//GUI-Datenwerte
	private JFrame f;
	private File file;
	private File lastFile;
	private File lastDir;
	private JFileChooser jfc;
	
	private int sucheInt = 0;
	private int abweichInt = 0;

	private int[] eingabeDaten = new int[maxEingabe];
	private Daten daten;
	private DateiDatenTableModel ddmL;
	private DateiDatenTableModel ddmR;
	private DateiDatenTableModel ddmS;
	private DateiDaten datenL;
	private DateiDaten datenR;
	private DateiDaten datenSaldo;
	
	private JPanel statusleiste;
	private int statusMax = 100;
	private int status = 0;
	
	private int statusMaxL = 100;
	private int statusMaxR = 100;
	private int statusL = 0;
	private int statusR = 0;
	private int datevStatusMax = 100;
	private int datevStatus = 0;
	
	private int statusSaldo = 0;
	private int statusMaxSaldo = 100;

	private boolean statusColumnVisibleButton = true;
	
	
	private int stunden, minuten, sekunden = 0;
	private String tstunden, tminuten, tsekunden, tmilli = "";
	
	//### LABELS ###
	JLabel statustext = new JLabel(".");
	
	JLabel labelSuche = new JLabel("Suche:");
	JTextField suche;	
	JLabel labelAbweichung = new JLabel("Abweichung:");
	JTextField abweich;
	JLabel labelquer = new JLabel("Quersumme:");
	JLabel labelQuer = new JLabel(" ");
	JLabel label9 = new JLabel("Vielfaches von 9: nein");
	JLabel labelHalbe = new JLabel("Halbe:");
	JLabel labelHalbes = new JLabel(" ");
	JLabel labelZeit = new JLabel("Zeit:");
	JLabel labelProg = new JLabel("Bis:  ");//Prognose
	JLabel labelZeiten = new JLabel(" ");
	JLabel labelloesung = new JLabel("Lösungen: ");
	JLabel labelLoesungen = new JLabel(" ");
	JLabel labelgut = new JLabel("sehr gut: ");
	JLabel labelnachgut = new JLabel(" ");
	JLabel labelleer = new JLabel(" ");
	JLabel labelerwartungen = new JLabel(" ");
	JLabel labelminLos = new JLabel("Minimal. Positionen: 0");
	JLabel labelmaxLos = new JLabel("Maximal. Positionen: 0");
	JLabel labelEinstellungen = new JLabel("Einstellungen:");
	JLabel labelAnzahlEingabe = new JLabel("maximale Eingabe:");
	JLabel labelMaxLoesungen = new JLabel("maximale Lösungen:");
	JLabel labelMaxExit = new JLabel("max Sort Exit:");
	JLabel labelMaxDuplikate = new JLabel("max Duplikate:");
	JLabel labelSummeDaten = new JLabel("Summe Daten:");
	JLabel labelGenau = new JLabel("Nachkommastellen:");
	JLabel labelSummanden = new JLabel("Summanden:");
	JLabel labelmaxSuch = new JLabel("Kandidaten:");
	JLabel labelMinDifferenz = new JLabel("min. Differenz:");
	JLabel labelMinPosSumme = new JLabel("min. pos. Summe:");
	JLabel labelMaxDifferenz = new JLabel("max. Differenz:");
	JLabel labelMaxPosSumme = new JLabel("max. pos. Summe:");
	JTextField maxLos;
	JTextField maxInput;
	JLabel labelThreads = new JLabel("Threads:");
	String[] threadText = { "1", "2", "4", "8","16", "32"};
	String[] genauText = { "0","1", "2", "3", "4", "5"};
	JComboBox<String> threadsCB, genauCB;
	JComboBox<String> sortCB;
	JComboBox<String> cvsCB;
	JComboBox<String> trennerInputCB;
	JComboBox<String> trennerOutputCB;
	JCheckBox threadOpti, variOpti, identOpti, negativCB, sortExitCB;//Threadoptimierung, Variablenoptimierung und Identitäten, Sortierung mit Sprung
	private boolean threado = false; 
	private boolean vario = true;
	private boolean identi = false;
	private boolean negativ = false;
	private boolean sortExit = false;
	
	private JSplitPane jsp;
	private JSplitPane jsp2;
	
	
	//### T O O L B A R ###

	private JToolBar bar = new JToolBar();
	private JButton neuButton = new JButton();
	private JButton leerButton = new JButton();
	private JButton summeFindenbt = new JButton();
	private JButton benchmarkButton = new JButton();
	private JButton aboutButton = new JButton();
	private JButton sortButton = new JButton();
	private JButton noDuploButton = new JButton();
	
	private JButton openButton = new JButton();
	private JButton saveButton = new JButton();
	private JButton saveAsButton = new JButton();
	private JButton importButton = new JButton();
	private JButton ablaufplanButton = new JButton();
	private JButton visibleButton = new JButton();
	private JButton columnVisibleButton = new JButton();
	private JButton suchButton = new JButton();
	private JButton druckButton = new JButton();
	private JButton diaButton = new JButton();
	private JButton startButton = new JButton();
	private JButton stopButton = new JButton();
	private JButton helpButton = new JButton();
	


	//### P R O G R E S S B A R ###
	private JProgressBar progressBar;
	
	private JTable eingabetable;
	
	//private JDialog einstellungen = new JDialog();
	
	SuchOrganisator so;
	DateiOrganisator dateiOrga;
	DatevOrganisator datevOrga;
	CSVOrganisator   csvOrga;

	/*
	**************************************************
	** Deklarationen Vergleich                      **
	**************************************************	
	*/
	
	private JButton tabelleLButton = new JButton();
	private JButton tabelleRButton = new JButton();
	private JButton vergleichStartButton = new JButton();
	private JButton testButton = new JButton();
	private JButton selectButton = new JButton();
	private JButton editRowButton = new JButton();
	private JButton makeNewButton = new JButton();
	private JButton dateButton = new JButton();//Alle Tage einzeln, aber als Block vergleichen
	private JButton blockButton = new JButton();//Block rechts (Auswahl) mit Sammler links vergleichen
	private JButton sollhabenButton = new JButton();//SuSaSoll und Haben ausrechnen.
	private JProgressBar progressBarVergleich1;
	private JProgressBar progressBarVergleich2;
	private JToolBar vergleichBar;
	
	private JTable tableLinks, tableRechts;
	
	private JSplitPane splitL;
	private JSplitPane splitR;
	
	private JPanel vergleichLinks = new JPanel();
	private JPanel vergleichRechts = new JPanel();
	
	private JPanel vergleichProgressPanel = new JPanel();
	
	private JComboBox<String> datumLCB;
	private JComboBox<String> datumRCB;
	private JComboBox<String> sollLCB;
	private JComboBox<String> sollRCB;
	private JComboBox<String> habenLCB;
	private JComboBox<String> habenRCB;

	private JComboBox<String> zeig1LCB;
	private JComboBox<String> zeig2LCB;
	private JComboBox<String> zeig3LCB;
	private JComboBox<String> zeig4LCB;

	private JComboBox<String> zeig1RCB;
	private JComboBox<String> zeig2RCB;
	private JComboBox<String> zeig3RCB;
	private JComboBox<String> zeig4RCB;
	
	private JLabel labelEinstellungenLinks = new JLabel("Einstellungen links:");
	private JLabel labelEinstellungenRechts = new JLabel("Einstellungen rechts:");
	private JLabel labelDatumL = new JLabel("Datum");
	private JLabel labelDatumR = new JLabel("Datum");
	private JLabel labelSollL = new JLabel("Soll");
	private JLabel labelSollR = new JLabel("Soll");
	private JLabel labelHabenL = new JLabel("Haben");
	private JLabel labelHabenR = new JLabel("Haben");
	private JLabel labelSollHaben = new JLabel("Summe Links: Rechts:");
	
	private JCheckBox stornoLCB = new JCheckBox("Storno zuerst");
	private JCheckBox stornoRCB = new JCheckBox("Storno zuerst");
	
	private JCheckBox firstLCB = new JCheckBox("Erste Zeile ignorieren");
	private JCheckBox firstRCB = new JCheckBox("Erste Zeile ignorieren");
	
	private JCheckBox ignoreLCB = new JCheckBox("Zeilen ohne Datum ignorieren");
	private JCheckBox ignoreRCB = new JCheckBox("Zeilen ohne Datum ignorieren");
	private JCheckBox sollHabenLCB = new JCheckBox("Wenn Soll/ Haben unwichtig");//Nur in Vorbereitung
	private JCheckBox sollHabenRCB = new JCheckBox("Wenn Soll/ Haben unwichtig");
	
	private JCheckBox summandenSucheLCB = new JCheckBox("Summandensuche");//Schneller
	private JCheckBox summandenSucheRCB = new JCheckBox("Summandensuche");//Schneller
	
	private JCheckBox sucheOhneDatumLCB = new JCheckBox("Suche ohne Datum");//Schneller
	private JCheckBox sucheOhneDatumRCB = new JCheckBox("Suche ohne Datum");//Schneller
	
	private JLabel labelZeitVergleich = new JLabel("Zeit:");
	private JLabel labelZeileVergleich = new JLabel("Zeile:");
	private JLabel labelZifferVergleich = new JLabel("Ziffer:");
	private JLabel labelZeitenVergleich = new JLabel(" ");
	private JLabel labelAbbruch = new JLabel("Abbruchbedingung:");
	private JComboBox<String> abbruchRCB;

	private TableColumnManager tcmL;
	private TableColumnManager tcmR;

	
	/*
	**************************************************
	** Deklarationen Saldo                          **
	**************************************************	
	*/
	
	/*
	--- Toolbar ---
	private JButton tabelleLButton = new JButton();
	private JButton tabelleRButton = new JButton();
	private JButton vergleichStartButton = new JButton();
	private JButton testButton = new JButton();
	private JButton selectButton = new JButton();
	private JButton editRowButton = new JButton();
	private JButton makeNewButton = new JButton();
	private JButton dateButton = new JButton();//Alle Tage einzeln, aber als Block vergleichen
	private JButton blockButton = new JButton();//Block rechts (Auswahl) mit Sammler links vergleichen
	*/
	
	private SaldoThread st;
	private String saldoAusgabeText = "";
	private JDialog bericht;
	private JTextArea berichtTextArea;
	private boolean selectAll = false;
	
	private JLabel labelSaldoStatus      = new JLabel(" ");
	
	private JButton openSaldoButton      = new JButton();
	private JButton saveSaldoButton      = new JButton();
	private JButton saldozuSummeButton   = new JButton();
	
	private JButton selectAllSaldoButton = new JButton();//selectAllSaldoButton edit-select-all
	private JButton startSaldoButton     = new JButton();
	private JButton testSaldoButton      = new JButton();
	
	private JButton allesSaldoButton     = new JButton();
	private JButton overNullSaldoButton  = new JButton();
	private JButton unterhalbSaldoButton = new JButton();
	private JButton negativSaldoButton   = new JButton();
	private JButton gleicherSaldoButton  = new JButton();
	private JButton paarSaldoButton      = new JButton();
	private JButton findeNullSaldoButton = new JButton();
	private JButton findeSaldoButton     = new JButton();
	
	
	private JButton analyseSaldoButton = new JButton();
	private JButton presentSaldoButton = new JButton();
	private JButton makeNewSaldoButton = new JButton();
	
	
	
	private JProgressBar progressBarSaldo;
	//private JProgressBar progressBarVergleich2;
	private JToolBar saldoBar;
	
	private JTable tableSaldo;
	
	private JSplitPane splitSaldo;
	//private JSplitPane splitR;
	
	
	private JPanel saldoLinks = new JPanel();
	private JPanel saldoRechts = new JPanel();
	
	
	private JPanel saldoProgressPanel = new JPanel();
	private JPanel saldoausgabe = new JPanel();
	
	private JComboBox<String> datumSaldoCB;
	private JComboBox<String> sollSaldoCB;
	private JComboBox<String> habenSaldoCB;
	private JComboBox<String> textSaldoCB;
	private JComboBox<String> gegenSaldoCB;
	
	
	private JLabel setStatusSaldolabel   = new JLabel("Status: ");
	private JButton statusSaldoButton    = new JButton();
	private JComboBox<String> statusSaldoCB;
	
	
	private JLabel labelEinstellungenSaldo = new JLabel("Einstellungen:");
	private JLabel labelDatumSaldo = new JLabel("Datum");
	private JLabel labelSollSaldo = new JLabel("Soll");
	private JLabel labelHabenSaldo = new JLabel("Haben");
	private JLabel labelSollHabenSaldo = new JLabel("Summe Links: Rechts:");
	private JLabel labelBText = new JLabel("Buchungstext:");
	private JLabel gegenLabel = new JLabel("Gegenkonto:");
	
	
	private JCheckBox firstSaldoCB = new JCheckBox("Erste Zeile ignorieren");
	private JCheckBox ignoreSaldoCB = new JCheckBox("Zeilen ohne Datum ignorieren");
	private JCheckBox summandenSucheSaldoCB = new JCheckBox("Summandensuche");//Schneller
	private JCheckBox sucheOhneDatumSaldoCB = new JCheckBox("Suche ohne Datum");//Schneller
	private JCheckBox vorStattSpalteSaldoCB = new JCheckBox("Vorzeichen statt Spalte");//plus minus
	
	private JLabel labelAusschluss = new JLabel("Ausschlusswörter:");
	private JTextArea saldoAusschluss = new JTextArea();
	
	private JLabel labelZeitSaldo = new JLabel("Zeit:");
	private JLabel labelZeileSaldo = new JLabel("Zeile:");
	private JLabel labelZifferSaldo = new JLabel("Ziffer:");
	private JLabel labelZeitenSaldo = new JLabel(" ");
	private JLabel labelAbbruchSaldo = new JLabel("Abbruchbedingung:");
	private JComboBox<String> abbruchSaldoCB;

	private TableColumnManager tcmS;
	
	
	/*
	**************************************************
	** Deklarationen Datev                          **
	**************************************************	
	*/
	
	private JToolBar datevBar = new JToolBar();
	private JToolBar datevSuSaBar = new JToolBar();
	private JToolBar datevKontoBar = new JToolBar();
	private JButton datevDateiButton = new JButton();
	private JButton SuSaButton = new JButton();
	private JButton SuSaDruckButton = new JButton();
	private JButton SuSaSaveButton = new JButton();
	private JButton KontoSaveButton = new JButton();
	private JProgressBar datevProgressBar;
	private JLabel labelDatevStatus;
	
	private JTabbedPane tabpaneDatev;
	private JPanel panelDatevPrimanota;
	private JPanel panelDatevSuSa;
	private JPanel panelDatevKonto;
	
	private JScrollPane primanotascroll;
	private JTable primanotaTable;
	private JScrollPane susascroll;
	private JTable susaTable;
	private DatevDaten datevdaten;
	
	private	JButton firstButton;
	private JButton linksButton;
	private JButton rechtsButton;
	private JButton lastButton;
	
	private JButton toVergleichButton;
	private JButton toSaldoButton;
	
	private JTextField nummer;

	private JTable kontoTable;
	private JScrollPane kontoscroll;
	private KontoTableModel ktm;
	private SuSaTableModel stm;
	private int kontonummer = 0;
	
	/*
	**************************************************
	** Deklarationen Fix CSV                        **
	**************************************************	
	*/
	
	private JToolBar csvBar = new JToolBar();
	private JPanel mainCSVPanel = new JPanel();
	private JPanel leftCSVPanel = new JPanel();
	private JPanel centerCSVPanel = new JPanel();
	private JPanel rightCSVPanel = new JPanel();
	private JButton openCSVButton = new JButton();
	private JProgressBar progressBarCSV;
	private JPanel csvProgressPanel;
	private JLabel labelCSVStatus;
	private int statusCSV = 0;
	private JTextField csvPfad;
	private JButton csvPfadAktualisierenButton;
	private JComboBox<String> encodingsEingabeCB;
	private JComboBox<String> encodingsAusgabeCB;
	private EncodingSelector encodingSelector;

	/*
	**************************************************
	**************************************************
	***                                            ***
	***      Ende der Variablendeklaration         ***
	***                                            ***
	**************************************************
	**************************************************
	*/

	public void run(){
		initGUI();
	}

	public static void main( String[] args ) {
		//Start
		//Buchhalter bh = new Buchhalter();
		SwingUtilities.invokeLater(new Buchhalter());
	}
	
	public Buchhalter(){
	}
	
	public void initGUI(){
		f = new JFrame( "Buchhalter Buddy ("+VERSION+")" );
		f.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
		f.setSize( 1100, 900 );

		// Hier erzeugen wir unsere JPanels
		JPanel panelSummeFinden = new JPanel();
		JPanel panelVergleich = new JPanel();
		JPanel panelDatev = new JPanel();
		JPanel panelSaldo = new JPanel();
		JPanel panelCSV   = new JPanel();
		
		JPanel panelAnnuitaten = new JPanel();
		JPanel panelDarlehen = new JPanel();
		JPanel panelKasse = new JPanel();
	
		// Erzeugung eines JTabbedPane-Objektes
		JTabbedPane tabpane = new JTabbedPane(JTabbedPane.TOP,JTabbedPane.SCROLL_TAB_LAYOUT );
		tabpane.addTab("Summanden finden", panelSummeFinden);
		tabpane.addTab("Vergleich", panelVergleich);
		tabpane.addTab("Datev", panelDatev);
		tabpane.addTab("Saldo", panelSaldo);
		tabpane.addTab("Fix CSV", panelCSV);
		
		//tabpane.addTab("Annuitätenrechner", panelAnnuitaten);
		//tabpane.addTab("Darlehensrechner", panelDarlehen);
		//tabpane.addTab("Kassensturz", panelKasse);
		f.add(tabpane);
		
		/*//Menü
		JMenuBar mainbar = new JMenuBar();
		JMenu menuDatei = new JMenu("Datei");
		JMenuItem options = new JMenuItem("Einstellungen");
		menuDatei.add(options);
		mainbar.add(menuDatei);
		f.setJMenuBar(mainbar);
		*/
		
		/*
		**********************************************************
		*** Alles zu Sumanden finden                           ***
		**********************************************************
		*/
		//Toolbar
		bar = new JToolBar();
		summeFindenbt.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/media-playback-start.png")));
		openButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-open.png")));
		saveButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-save.png")));
		neuButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-new.png")));
		aboutButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/help-browser.png")));
		stopButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/process-stop.png")));
		leerButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/edit-clear.png")));
		benchmarkButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/utilities-system-monitor.png")));
		sortButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/go-down.png")));
		noDuploButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/emblem-favorite.png")));
		
		openButton.addActionListener(new ButtonActionListener(this));
		saveButton.addActionListener(new ButtonActionListener(this));
		neuButton.addActionListener(new ButtonActionListener(this));
		leerButton.addActionListener(new ButtonActionListener(this));
		summeFindenbt.addActionListener(new ButtonActionListener(this));
		stopButton.addActionListener(new ButtonActionListener(this));
		aboutButton.addActionListener(new ButtonActionListener(this));
		benchmarkButton.addActionListener(new ButtonActionListener(this));
		sortButton.addActionListener(new ButtonActionListener(this));
		noDuploButton.addActionListener(new ButtonActionListener(this));
		
		summeFindenbt.setToolTipText("Starte die Suche");
		openButton.setToolTipText("Eingabewerte einlesen");
		saveButton.setToolTipText("Ergebnisse in eine CSV-Datei abspeichern");
		neuButton.setToolTipText("Suche löschen ohne Werte zu löschen");
		aboutButton.setToolTipText("Über");
		stopButton.setToolTipText("Stop");
		leerButton.setToolTipText("Suche löschen und Werte auch löschen");
		benchmarkButton.setToolTipText("Benchmarkwerte");
		sortButton.setToolTipText("Ergebnisse dieser Spalte nach unten sortieren");
		noDuploButton.setToolTipText("Keine Duplikate anzeigen");

		//bar.setLayout(new FlowLayout(FlowLayout.LEFT));
		//panelSummeFinden.setLayout( new java.awt.BorderLayout() );
		//panelSummeFinden.add(bar, java.awt.BorderLayout.PAGE_START);

		bar.setLayout(new java.awt.BorderLayout());
		JPanel leftbar = new JPanel();
		JPanel centerbar = new JPanel();
		JPanel rightbar = new JPanel();
		leftbar.add(openButton);
		leftbar.add(saveButton);
		leftbar.add(new JSeparator());
		leftbar.add(neuButton);
		leftbar.add(leerButton);
		leftbar.add(summeFindenbt);
		leftbar.add(new JSeparator());
		leftbar.add(stopButton);
		bar.add(leftbar, java.awt.BorderLayout.LINE_START);
		//bar.add(new JSeparator());
		//bar.add(Box.createHorizontalGlue());
		rightbar.add(benchmarkButton);
		rightbar.add(aboutButton);
		bar.add(centerbar, java.awt.BorderLayout.CENTER);
		bar.add(rightbar, java.awt.BorderLayout.LINE_END);
				
		//Summe Finden zeichnen
		panelSummeFinden.setLayout( new java.awt.BorderLayout() );
		panelSummeFinden.add(bar, java.awt.BorderLayout.PAGE_START);
		
		jsp = new JSplitPane();
		panelSummeFinden.add(jsp, java.awt.BorderLayout.CENTER);
		JPanel eingabe = new JPanel();
		JPanel ausgabe = new JPanel();
		String[] sortStrings = { "sort. n. Anzahl", "nach Differenz" };
		sortCB = new JComboBox<String>(sortStrings);
		sortCB.addActionListener (new ActionListener () {public void actionPerformed(ActionEvent e) {sortieren();
		}	});
		centerbar.add(sortButton);
		centerbar.add(sortCB);
		centerbar.add(noDuploButton);
		JScrollPane scrollPaneEingabe = new JScrollPane(eingabe);
		scrollPaneEingabe.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		jsp.setLeftComponent(scrollPaneEingabe);
		jsp.setRightComponent(ausgabe);
		jsp.setOneTouchExpandable(true);
		jsp.setDividerLocation(250);
		
		statusleiste = new JPanel();
		statusleiste.add(statustext);
		statusleiste.add(new JSeparator());
		progressBar = new JProgressBar(0, statusMax);
		progressBar.setValue(100);
		progressBar.setStringPainted(false);

		statusleiste.add(progressBar);
		panelSummeFinden.add(statusleiste, java.awt.BorderLayout.SOUTH);
				
		//Panel Eingabe und Optionen:
		eingabe.setLayout( new javax.swing.BoxLayout(eingabe, javax.swing.BoxLayout.Y_AXIS ) );
		eingabe.add(labelSuche);
		suche = new JTextField(20);
		suche.setMaximumSize( suche.getPreferredSize() );
		suche.addFocusListener(new FocusTest(this, suche));
		eingabe.add(suche);
		eingabe.add(labelAbweichung);
		abweich = new JTextField(20);
		abweich.setMaximumSize( suche.getPreferredSize() );
		abweich.addFocusListener(new FocusTest(this, abweich));
		eingabe.add(abweich);
		eingabe.add(labelquer);
		eingabe.add(labelQuer);
		eingabe.add(label9);
		eingabe.add(labelHalbe);
		eingabe.add(labelHalbes);
		eingabe.add(labelZeit);
		eingabe.add(labelProg);
		eingabe.add(labelZeiten);
		eingabe.add(labelloesung);
		eingabe.add(labelgut);
		eingabe.add(labelerwartungen);
		eingabe.add(labelnachgut);
		eingabe.add(labelminLos);
		eingabe.add(labelmaxLos);
		eingabe.add(labelMinDifferenz);
		eingabe.add(labelMaxDifferenz);
		eingabe.add(labelMinPosSumme);
		eingabe.add(labelMaxPosSumme);
		eingabe.add(new JSeparator());
		eingabe.add(labelMaxExit);
		eingabe.add(labelMaxDuplikate);
		eingabe.add(labelSummeDaten);
		eingabe.add(labelSummanden);
		eingabe.add(labelmaxSuch);
		eingabe.add(new JSeparator());
		eingabe.add(labelEinstellungen);
		eingabe.add(labelAnzahlEingabe);
		maxInput = new JTextField(20);
		maxInput.setText(""+maxEingabe);
		maxInput.setMaximumSize( new Dimension(300,30) );
		eingabe.add(maxInput);
		eingabe.add(labelMaxLoesungen);
		maxLos = new JTextField(20);
		maxLos.addFocusListener(new FocusTest(this, maxLos));
		maxLos.setText("1000");
		maxLos.setMaximumSize( new Dimension(300,30) );
		eingabe.add(maxLos);
		eingabe.add(labelThreads);
		threadsCB = new JComboBox<>();
		for ( String s : threadText )
  		threadsCB.addItem( s );
		threadsCB.setMaximumSize( new Dimension(300,30) );
		eingabe.add(threadsCB);
		threadsCB.setSelectedIndex(0);
		eingabe.add(labelGenau);
		genauCB = new JComboBox<>();
		for ( String s : genauText )
			genauCB.addItem( s );
		genauCB.setMaximumSize( new Dimension(300,30) );
		eingabe.add(genauCB);
		genauCB.setSelectedIndex(2);
		//threadopti, variOpti
		threadOpti = new JCheckBox("Threadoptimierung");
		variOpti = new JCheckBox("Variablenoptimierung");
		identOpti = new JCheckBox("keine Duplikate (ohne Gewähr)");
		identOpti.addItemListener(new JCheckboxListener(this, identOpti));
		negativCB = new JCheckBox("keine negativen Duplikate (Testphase)");
		sortExitCB = new JCheckBox("Sort Exit");
		variOpti.setToolTipText("Vor der Berechnung werden Summanden entfernt, die unmöglich zur Summe beitragen können. Zum Beispiel, weil sie zu groß sind.");
		sortExitCB.setToolTipText("Sortierung von Groß nach Klein mit Exit, wenn kein zweiter Summand mehr möglich ist.\nBeisst sich mit keine Duplikate und funktioniert nur mit positiven Summanden.");
		sortExitCB.addItemListener(new JCheckboxListener(this, sortExitCB));
		identOpti.setToolTipText("Sortierung nach Anzahl der Häufigkeit gleicher Summanden, so dass Doppelte effizient übersprungen werden können. Beisst sich mit sortExit.");
		negativCB.setToolTipText("Gleiche positive und negative Summanden werden erkannt und dann wegoptimiert. Ist noch Buganfällig.");
		//eingabe.add(threadOpti);
		eingabe.add(variOpti);
		eingabe.add(sortExitCB);
		eingabe.add(identOpti);
		eingabe.add(negativCB);
		threadOpti.setEnabled(false);
		variOpti.setEnabled(true);
		variOpti.setSelected(true);
		sortExitCB.setEnabled(true);
		sortExitCB.setSelected(false);
		identOpti.setEnabled(true);
		identOpti.setSelected(true);
		negativCB.setEnabled(true);
		negativCB.setSelected(false);
		sortCB.setEnabled(false);
		sortButton.setEnabled(false);
		noDuploButton.setEnabled(false);
	
		eingabetable = new JTable(maxEingabe,1);
		JScrollPane scrollPane = new JScrollPane(eingabetable);
		eingabetable.setFillsViewportHeight(false);
		//ausgabe.add(scrollPane);
		ausgabe.setLayout( new java.awt.BorderLayout() );
		ausgabe.add(scrollPane, BorderLayout.CENTER);
		eingabetable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		((JLabel)eingabetable.getDefaultRenderer(String.class)).setHorizontalAlignment (JLabel.RIGHT);

		arrayReset();
		
		saveButton.setEnabled(false);
		stopButton.setEnabled(false);
		sortButton.setEnabled(false);
		noDuploButton.setEnabled(false);
		
		/*
		**********************************************************
		*** Alles zu Vergleich                                 ***
		**********************************************************
		Beim ersten Mal noch keine Tabellen nötig.
		*/
		//
		//


		//Toolbar
		vergleichBar = new JToolBar();
		//vergleichBar.setLayout(new FlowLayout(FlowLayout.LEFT));
		tabelleLButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/format-indent-less.png")));
		tabelleRButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/format-indent-more.png")));
		vergleichStartButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/media-playback-start.png")));
		visibleButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/format-text-strikethrough.png")));
		columnVisibleButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/column-hide.png")));
		testButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/applications-accessories.png")));
		selectButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/emblem-symbolic-link.png")));
		editRowButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/emblem-important.png")));
		makeNewButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/edit-clear.png")));
		dateButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/office-calendar.png")));
		blockButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/accessories-calculator.png")));

		tabelleLButton.addActionListener(new ButtonActionListener(this));
		tabelleRButton.addActionListener(new ButtonActionListener(this));
		vergleichStartButton.addActionListener(new ButtonActionListener(this));
		visibleButton.addActionListener(new ButtonActionListener(this));
		columnVisibleButton.addActionListener(new ButtonActionListener(this));
		testButton.addActionListener(new ButtonActionListener(this));
		selectButton.addActionListener(new ButtonActionListener(this));
		editRowButton.addActionListener(new ButtonActionListener(this));
		makeNewButton.addActionListener(new ButtonActionListener(this));
		dateButton.addActionListener(new ButtonActionListener(this));
		blockButton.addActionListener(new ButtonActionListener(this));
		
		tabelleLButton.setToolTipText("Linke Tabelle einlesen (Bank)");
		tabelleRButton.setToolTipText("Rechte Tabelle einlesen (Buchhaltung");
		vergleichStartButton.setToolTipText("Vergleich starten");
		visibleButton.setToolTipText("Schalter nur fehlerhafte einblenden.");
		columnVisibleButton.setToolTipText("Schalter nur gewünschte Spalten einblenden.");
		testButton.setToolTipText("Teste ob die Einstellungen für die Suche geeignet sind.");
		selectButton.setToolTipText("Manuell ausgewählte linke und rechte Zeilen überprüfen.");
		editRowButton.setToolTipText("Manuell ausgewählte linke und rechte Zeilen miteinander verknüpfen.");
		makeNewButton.setToolTipText("Tabellenstatus zurücksetzen.");
		dateButton.setToolTipText("Vergleiche ganze Tage.");
		blockButton.setToolTipText("Finde zu links passende Auswahl rechts.");
		
		sollhabenButton = new JButton();
		sollhabenButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/face-glasses.png")));
		sollhabenButton.setToolTipText("Berechne Soll- und Habenspallten.");
		sollhabenButton.addActionListener(new ButtonActionListener(this));
		sollhabenButton.setEnabled(false);

		//bar.add(centerbar, java.awt.BorderLayout.CENTER);
		//bar.add(rightbar, java.awt.BorderLayout.LINE_END);

		vergleichBar.setLayout(new java.awt.BorderLayout());
		
		JPanel leftvbar = new JPanel();
		JPanel centervbar = new JPanel();
		JPanel rightvbar = new JPanel();
		
		leftvbar.add(tabelleLButton);
		leftvbar.add(tabelleRButton);
		leftvbar.add(new JSeparator());
		leftvbar.add(testButton);
		leftvbar.add(dateButton);
		leftvbar.add(vergleichStartButton);
		leftvbar.add(new JSeparator());
		leftvbar.add(selectButton);
		leftvbar.add(editRowButton);
		leftvbar.add(blockButton);
		leftvbar.add(new JSeparator());
		leftvbar.add(visibleButton);
		leftvbar.add(columnVisibleButton);
		leftvbar.add(new JSeparator());
		rightvbar.add(sollhabenButton);
		rightvbar.add(makeNewButton);
		vergleichBar.add(leftvbar, java.awt.BorderLayout.LINE_START);
		vergleichBar.add(centervbar, java.awt.BorderLayout.CENTER);
		vergleichBar.add(rightvbar, java.awt.BorderLayout.LINE_END);

		panelVergleich.setLayout( new java.awt.BorderLayout() );
		panelVergleich.add(vergleichBar, java.awt.BorderLayout.PAGE_START);
		
		//Nach Toolbar kommen Panels
		JPanel vergleichOptionpanel = new JPanel();
		
		splitL = new JSplitPane();
		splitR = new JSplitPane();
		splitL.setLeftComponent(vergleichOptionpanel);
		splitL.setRightComponent(splitR);
		splitR.setLeftComponent(vergleichLinks);
		splitR.setRightComponent(vergleichRechts);
		splitL.setOneTouchExpandable(true);
		splitR.setOneTouchExpandable(true);
		panelVergleich.add(splitL, java.awt.BorderLayout.CENTER);
		panelVergleich.add(vergleichProgressPanel, java.awt.BorderLayout.PAGE_END);
		
		datumLCB = new JComboBox<>();
		datumRCB = new JComboBox<>();
		sollLCB = new JComboBox<>();
		sollRCB = new JComboBox<>();
		habenLCB = new JComboBox<>();
		habenRCB = new JComboBox<>();
		zeig1LCB = new JComboBox<>();
		zeig2LCB = new JComboBox<>();
		zeig3LCB = new JComboBox<>();
		zeig4LCB = new JComboBox<>();
		zeig1RCB = new JComboBox<>();
		zeig2RCB = new JComboBox<>();
		zeig3RCB = new JComboBox<>();
		zeig4RCB = new JComboBox<>();
		
		abbruchRCB = new JComboBox<>();
		for (int i = 1; i < 201; i++)
			abbruchRCB.addItem(""+i+" Kandidaten pro Tag");
		abbruchRCB.setMaximumSize( new Dimension(300,30) );

		//labelleer
		
		vergleichOptionpanel.setLayout( new javax.swing.BoxLayout(vergleichOptionpanel, javax.swing.BoxLayout.Y_AXIS ) );
		vergleichOptionpanel.add(labelEinstellungenLinks);
		vergleichOptionpanel.add(labelDatumL);
		vergleichOptionpanel.add(datumLCB);
		vergleichOptionpanel.add(labelSollL);
		vergleichOptionpanel.add(sollLCB);
		vergleichOptionpanel.add(labelHabenL);
		vergleichOptionpanel.add(habenLCB);
		//vergleichOptionpanel.add(stornoLCB);
		vergleichOptionpanel.add(zeig1LCB);
		vergleichOptionpanel.add(zeig2LCB);
		vergleichOptionpanel.add(zeig3LCB);
		vergleichOptionpanel.add(zeig4LCB);
		vergleichOptionpanel.add(firstLCB);
		vergleichOptionpanel.add(ignoreLCB);
		vergleichOptionpanel.add(summandenSucheLCB);
		vergleichOptionpanel.add(sucheOhneDatumLCB);
		vergleichOptionpanel.add(new JSeparator());
		vergleichOptionpanel.add(labelZeitVergleich);
		vergleichOptionpanel.add(labelZeileVergleich);
		vergleichOptionpanel.add(labelZifferVergleich);
		vergleichOptionpanel.add(new JSeparator());
		vergleichOptionpanel.add(labelAbbruch);
		vergleichOptionpanel.add(abbruchRCB);
		vergleichOptionpanel.add(new JSeparator());
		vergleichOptionpanel.add(labelEinstellungenRechts);
		vergleichOptionpanel.add(labelDatumR);
		vergleichOptionpanel.add(datumRCB);
		vergleichOptionpanel.add(labelSollR);
		vergleichOptionpanel.add(sollRCB);
		vergleichOptionpanel.add(labelHabenR);
		vergleichOptionpanel.add(habenRCB);
		//vergleichOptionpanel.add(stornoRCB);
		vergleichOptionpanel.add(zeig1RCB);
		vergleichOptionpanel.add(zeig2RCB);
		vergleichOptionpanel.add(zeig3RCB);
		vergleichOptionpanel.add(zeig4RCB);
		vergleichOptionpanel.add(firstRCB);
		vergleichOptionpanel.add(ignoreRCB);
		//vergleichOptionpanel.add(summandenSucheRCB);
		//vergleichOptionpanel.add(sucheOhneDatumRCB);
		
		datumLCB.setMaximumSize( new Dimension(300,30) );
		sollLCB.setMaximumSize( new Dimension(300,30) );
		habenLCB.setMaximumSize( new Dimension(300,30) );
		datumRCB.setMaximumSize( new Dimension(300,30) );
		sollRCB.setMaximumSize( new Dimension(300,30) );
		habenRCB.setMaximumSize( new Dimension(300,30) );
		
		zeig1LCB.setMaximumSize( new Dimension(300,30) );
		zeig2LCB.setMaximumSize( new Dimension(300,30) );
		zeig3LCB.setMaximumSize( new Dimension(300,30) );
		zeig4LCB.setMaximumSize( new Dimension(300,30) );
		zeig1RCB.setMaximumSize( new Dimension(300,30) );
		zeig2RCB.setMaximumSize( new Dimension(300,30) );
		zeig3RCB.setMaximumSize( new Dimension(300,30) );
		zeig4RCB.setMaximumSize( new Dimension(300,30) );
		//STATUSZEILE NICHT VERGESSEN!!!
		
		progressBarVergleich1 = new JProgressBar(0, statusMaxL);
		progressBarVergleich2 = new JProgressBar(0, statusMaxR);
		progressBarVergleich1.setValue(100);
		progressBarVergleich2.setValue(100);
		progressBarVergleich1.setStringPainted(false);
		progressBarVergleich2.setStringPainted(false);
		
		vergleichProgressPanel.add(labelSollHaben);
		vergleichProgressPanel.add(progressBarVergleich1);
		vergleichProgressPanel.add(progressBarVergleich2);
		
		/*
		**********************************************************
		*** Alles zu Saldo                                     ***
		**********************************************************
		Beim ersten Mal noch keine Tabelle nötig.
		*/
		//
		//


		//Toolbar
		saldoBar = new JToolBar();
		//vergleichBar.setLayout(new FlowLayout(FlowLayout.LEFT));
		
		openSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-open.png")));
		openSaldoButton.addActionListener(new ButtonActionListener(this));
		openSaldoButton.setToolTipText("Datei einlesen");
		
		saveSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-save-as.png")));
		saveSaldoButton.addActionListener(new ButtonActionListener(this));
		saveSaldoButton.setToolTipText("Tabelle speichern");
		saveSaldoButton.setEnabled(false);
		
		saldozuSummeButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/edit-undo.png")));
		saldozuSummeButton.addActionListener(new ButtonActionListener(this));
		saldozuSummeButton.setToolTipText("Offene Zeilen zu Summe Finden hinzufügen.");
		saldozuSummeButton.setEnabled(false);
		
		testSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/applications-accessories.png")));
		testSaldoButton.addActionListener(new ButtonActionListener(this));
		testSaldoButton.setEnabled(false);
		testSaldoButton.setToolTipText("Teste ob die Einstellungen für die Suche geeignet sind.");
		
		selectAllSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/edit-select-all.png")));
		selectAllSaldoButton.addActionListener(new ButtonActionListener(this));
		selectAllSaldoButton.setToolTipText("Alles auswählen oder abwählen.");
		selectAllSaldoButton.setEnabled(false);
		
		startSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/media-playback-start.png")));
		startSaldoButton.addActionListener(new ButtonActionListener(this));
		startSaldoButton.setToolTipText("Grundeinstellungen ausführen.");
		startSaldoButton.setEnabled(false);
		
		//Buttons für die Aufgaben
		allesSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/media-seek-forward.png")));
		allesSaldoButton.addActionListener(new ButtonActionListener(this));
		allesSaldoButton.setToolTipText("Alle Stufen ausführen.");
		allesSaldoButton.setEnabled(false);
		
		
		overNullSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/oberhalbNullsaldo.png")));
		overNullSaldoButton.addActionListener(new ButtonActionListener(this));
		overNullSaldoButton.setToolTipText("Alles über Nullsaldo ausblenden.");
		overNullSaldoButton.setEnabled(false);
		
		
		unterhalbSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/unterhalbSaldo.png")));
		unterhalbSaldoButton.addActionListener(new ButtonActionListener(this));
		unterhalbSaldoButton.setToolTipText("Alles unterhalb des Saldo ausblenden.");
		unterhalbSaldoButton.setEnabled(false);
		
		negativSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/negativSaldo.png")));
		negativSaldoButton.addActionListener(new ButtonActionListener(this));
		negativSaldoButton.setToolTipText("Finde zu negativen Saldo passenden Summanden.");
		negativSaldoButton.setEnabled(false);
		
		gleicherSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/gleicherSaldo.png")));
		gleicherSaldoButton.addActionListener(new ButtonActionListener(this));
		gleicherSaldoButton.setToolTipText("Gleicher Saldo.");
		gleicherSaldoButton.setEnabled(false);
		
		findeNullSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/findeNullSaldo.png")));
		findeNullSaldoButton.addActionListener(new ButtonActionListener(this));
		findeNullSaldoButton.setToolTipText("Finde Nullsaldo.");
		findeNullSaldoButton.setEnabled(false);
		
		findeSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/findeSaldo.png")));
		findeSaldoButton.addActionListener(new ButtonActionListener(this));
		findeSaldoButton.setToolTipText("Finde Saldo.");
		findeSaldoButton.setEnabled(false);
		
		paarSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/paarSaldo.png")));
		paarSaldoButton.addActionListener(new ButtonActionListener(this));
		paarSaldoButton.setToolTipText("Finde paarweise Saldo.");
		paarSaldoButton.setEnabled(false);
		
		analyseSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/x-office-presentation.png")));
		analyseSaldoButton.addActionListener(new ButtonActionListener(this));
		analyseSaldoButton.setToolTipText("Offene Posten analysieren.");
		analyseSaldoButton.setEnabled(false);
		
		presentSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/utilities-terminal.png")));
		//presentSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/x-office-presentation.png")));
		presentSaldoButton.addActionListener(new ButtonActionListener(this));
		presentSaldoButton.setToolTipText("Log anzeigen.");
		presentSaldoButton.setEnabled(false);
		
		makeNewSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/edit-clear.png")));
		makeNewSaldoButton.addActionListener(new ButtonActionListener(this));
		makeNewSaldoButton.setToolTipText("Zurücksetzen.");
		makeNewSaldoButton.setEnabled(false);
		
		setStatusSaldolabel   = new JLabel("Status: ");
		//statusSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/edit-clear.png")));
		statusSaldoButton.addActionListener(new ButtonActionListener(this));
		statusSaldoButton.setToolTipText("Status anwenden.");
		statusSaldoButton.setText("Status anwenden");
		
				
		//leftsbar.add(openSaldoButton);
		
		saldoAusschluss.setLineWrap(true);
		saldoAusschluss.setWrapStyleWord(true);
		saldoAusschluss.setText("Kaution;Miete;Hausbank;Mieter;Kautionsverrechnung;Bundesagentur für Arbeit");
		JScrollPane scrollpaneSaldoA = new JScrollPane(saldoAusschluss);

		saldoBar.setLayout(new java.awt.BorderLayout());
		
		JPanel leftsbar = new JPanel();
		JPanel centersbar = new JPanel();
		JPanel rightsbar = new JPanel();
		
		leftsbar.add(openSaldoButton);
		leftsbar.add(saveSaldoButton);
		leftsbar.add(saldozuSummeButton);
		
		centersbar.add(selectAllSaldoButton);
		centersbar.add(testSaldoButton);
		centersbar.add(allesSaldoButton);
		centersbar.add(new JSeparator());
		centersbar.add(startSaldoButton);
		centersbar.add(overNullSaldoButton);
		centersbar.add(unterhalbSaldoButton);
		centersbar.add(negativSaldoButton);
		centersbar.add(paarSaldoButton);
		centersbar.add(gleicherSaldoButton);
		centersbar.add(findeNullSaldoButton);
		centersbar.add(findeSaldoButton);
		
		rightsbar.add(analyseSaldoButton);
		rightsbar.add(presentSaldoButton);
		rightsbar.add(makeNewSaldoButton);
		
		saldoBar.add(leftsbar, java.awt.BorderLayout.LINE_START);
		saldoBar.add(centersbar, java.awt.BorderLayout.CENTER);
		saldoBar.add(rightsbar, java.awt.BorderLayout.LINE_END);
		

		panelSaldo.setLayout( new java.awt.BorderLayout() );
		panelSaldo.add(saldoBar, java.awt.BorderLayout.PAGE_START);
		
		//Nach Toolbar kommen Panels
		JPanel saldoOptionpanel = new JPanel();
		
		splitSaldo = new JSplitPane();
		splitSaldo.setLeftComponent(saldoOptionpanel);
		splitSaldo.setRightComponent(saldoausgabe);
		splitSaldo.setOneTouchExpandable(true);
		panelSaldo.add(splitSaldo, java.awt.BorderLayout.CENTER);
		panelSaldo.add(saldoProgressPanel, java.awt.BorderLayout.PAGE_END);
		
		
		datumSaldoCB = new JComboBox<>();
		sollSaldoCB  = new JComboBox<>();
		habenSaldoCB = new JComboBox<>();
		textSaldoCB  = new JComboBox<>();
		gegenSaldoCB = new JComboBox<>();
		
		abbruchSaldoCB = new JComboBox<>();
		for (int i = 1; i < 201; i++){
			abbruchSaldoCB.addItem(""+i+" Kandidaten");
		}
		
		
		statusSaldoCB = new JComboBox<>();
		//for (int i = 0; i < 7; i++)
		//	statusSaldoCB.addItem("Status "+i);
		statusSaldoCB.addItem("0: Nichts");
		statusSaldoCB.addItem("1: Gefunden");
		statusSaldoCB.addItem("2: Sammler");
		statusSaldoCB.addItem("3: Gefunden weit");
		statusSaldoCB.addItem("4: Sammler weit");
		statusSaldoCB.addItem("5: manuell");
		statusSaldoCB.addItem("6: gut");
		

		//labelleer
		
		saldoOptionpanel.setLayout( new javax.swing.BoxLayout(saldoOptionpanel, javax.swing.BoxLayout.Y_AXIS ) );
		saldoOptionpanel.add(labelEinstellungenSaldo);
		saldoOptionpanel.add(labelDatumSaldo);
		saldoOptionpanel.add(datumSaldoCB);
		saldoOptionpanel.add(labelSollSaldo);
		saldoOptionpanel.add(sollSaldoCB);
		saldoOptionpanel.add(labelHabenSaldo);
		saldoOptionpanel.add(habenSaldoCB);
		saldoOptionpanel.add(labelBText);
		saldoOptionpanel.add(textSaldoCB);
		saldoOptionpanel.add(gegenLabel);
		saldoOptionpanel.add(gegenSaldoCB);
		
		//vergleichOptionpanel.add(stornoLCB);
		saldoOptionpanel.add(firstSaldoCB);
		//saldoOptionpanel.add(ignoreSaldoCB);//Zeilen ohne Datum ignorieren
		//saldoOptionpanel.add(summandenSucheSaldoCB);//Summandensuche
		//saldoOptionpanel.add(sucheOhneDatumSaldoCB);//Suche ohne Datum
		saldoOptionpanel.add(vorStattSpalteSaldoCB);
		saldoOptionpanel.add(new JSeparator());
		//
		saldoOptionpanel.add(setStatusSaldolabel);
		saldoOptionpanel.add(statusSaldoCB);
		saldoOptionpanel.add(statusSaldoButton);
		
		//
		saldoOptionpanel.add(labelAusschluss);
		saldoOptionpanel.add(scrollpaneSaldoA);
		saldoOptionpanel.add(labelZeitSaldo);
		saldoOptionpanel.add(labelZeileSaldo);
		saldoOptionpanel.add(labelZifferSaldo);
		saldoOptionpanel.add(new JSeparator());
		saldoOptionpanel.add(labelAbbruchSaldo);
		saldoOptionpanel.add(abbruchSaldoCB);
		
		
		datumSaldoCB.setMaximumSize( new Dimension(300,30) );
		sollSaldoCB.setMaximumSize( new Dimension(300,30) );
		habenSaldoCB.setMaximumSize( new Dimension(300,30) );
		textSaldoCB.setMaximumSize( new Dimension(300,30) );
		abbruchSaldoCB.setMaximumSize( new Dimension(300,30) );
		statusSaldoCB.setMaximumSize( new Dimension(300,30) );
		gegenSaldoCB.setMaximumSize( new Dimension(300,30) );
		
		datumSaldoCB.setEnabled(false);
		sollSaldoCB.setEnabled(false);
		habenSaldoCB.setEnabled(false);
		textSaldoCB.setEnabled(false);
		statusSaldoCB.setEnabled(false);
		gegenSaldoCB.setEnabled(false);
		
		/*
		//STATUSZEILE NICHT VERGESSEN!!!
		*/
		progressBarSaldo = new JProgressBar(0, statusMaxSaldo);
		progressBarSaldo.setValue(100);
		progressBarSaldo.setStringPainted(false);
		
		saldoProgressPanel.add(labelSaldoStatus);
		saldoProgressPanel.add(progressBarSaldo);
		
		/*
		**********************************************************
		*** Alles zu Datev                                     ***
		**********************************************************
		*/
		//panelDatev
		JPanel datevProgressPanel = new JPanel();
		
		tabpaneDatev = new JTabbedPane(JTabbedPane.TOP,JTabbedPane.SCROLL_TAB_LAYOUT );
		/*
		tabpaneDatev.addTab("Primanota", panelDatevPrimanota);
		tabpaneDatev.addTab("SuSa", panelDatevSuSa);
		tabpaneDatev.addTab("Konto", panelDatevKonto);
		*/
		
		//Buttons
		
		datevDateiButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-open.png")));
		datevDateiButton.addActionListener(new ButtonActionListener(this));
		datevDateiButton.setToolTipText("Datev-Datei(en) einlesen");
		
		SuSaButton   = new JButton();
		SuSaButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/accessories-calculator.png")));
		SuSaButton.setToolTipText("Berechne Daten erneut.");
		SuSaButton.addActionListener(new ButtonActionListener(this));
		SuSaButton.setEnabled(false);
		
		SuSaDruckButton   = new JButton();
		SuSaDruckButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-print.png")));
		SuSaDruckButton.setToolTipText("Drucke SuSa.");
		SuSaDruckButton.addActionListener(new ButtonActionListener(this));
		SuSaDruckButton.setEnabled(false);
		
		SuSaSaveButton   = new JButton();
		SuSaSaveButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-save.png")));
		SuSaSaveButton.setToolTipText("Exportiere SuSa in csv.");
		SuSaSaveButton.addActionListener(new ButtonActionListener(this));
		SuSaSaveButton.setEnabled(false);
		
		KontoSaveButton   = new JButton();
		KontoSaveButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-save.png")));
		KontoSaveButton.setToolTipText("Exportiere das Konto als csv.");
		KontoSaveButton.addActionListener(new ButtonActionListener(this));
		KontoSaveButton.setEnabled(false);
		
		//Labels
		labelDatevStatus = new JLabel("");
		
		//Toolbar
		datevBar = new JToolBar();
		//datevBar.setLayout(new FlowLayout(FlowLayout.LEFT));
		datevBar.setLayout(new java.awt.BorderLayout());
		
		JPanel leftdbar = new JPanel();
		JPanel centerdbar = new JPanel();
		JPanel rightdbar = new JPanel();
		
		leftdbar.add(datevDateiButton);
		leftdbar.add(new JSeparator());
		/*
		leftdbar.add(SuSaButton);
		leftdbar.add(SuSaDruckButton);
		leftdbar.add(SuSaSaveButton);
		*/
		SuSaButton.setEnabled(false);
		SuSaDruckButton.setEnabled(false);
		SuSaSaveButton.setEnabled(false);
		/*
		leftvbar.add(tabelleRButton);
		leftvbar.add(new JSeparator());
		leftvbar.add(testButton);
		leftvbar.add(dateButton);
		leftvbar.add(vergleichStartButton);
		leftvbar.add(new JSeparator());
		leftvbar.add(selectButton);
		leftvbar.add(editRowButton);
		leftvbar.add(blockButton);
		leftvbar.add(new JSeparator());
		leftvbar.add(visibleButton);
		leftvbar.add(new JSeparator());
		rightvbar.add(makeNewButton);
		*/
		datevBar.add(leftdbar, java.awt.BorderLayout.LINE_START);
		datevBar.add(centerdbar, java.awt.BorderLayout.CENTER);
		datevBar.add(rightdbar, java.awt.BorderLayout.LINE_END);
		
		panelDatev.setLayout( new java.awt.BorderLayout() );
		panelDatev.add(datevBar, java.awt.BorderLayout.PAGE_START);
		panelDatev.add(tabpaneDatev, java.awt.BorderLayout.CENTER);
		tabpaneDatev.setEnabled(false);
		
		//Datev: Primanota
		panelDatevPrimanota = new JPanel();
		
		primanotaTable = new JTable();
		primanotascroll = new JScrollPane(primanotaTable);
		//primanotascroll.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		
		panelDatevPrimanota.setLayout( new java.awt.BorderLayout() );
		//panelDatevPrimanota.add(datevBar, java.awt.BorderLayout.PAGE_START);
		panelDatevPrimanota.add(primanotascroll, java.awt.BorderLayout.CENTER);
		
		
		//datevProgressBar
		
		//STATUSZEILE NICHT VERGESSEN!!!

		datevProgressBar = new JProgressBar(0, datevStatusMax);
		datevProgressBar.setValue(100);
		datevProgressBar.setStringPainted(false);
		
		datevProgressPanel.add(labelDatevStatus);
		datevProgressPanel.add(datevProgressBar);
		
		panelDatev.add(datevProgressPanel, java.awt.BorderLayout.PAGE_END);
		
		/*
		**********************************************************
		*** Ende Datev                                         ***
		**********************************************************
		*/
		
		/*
		**********************************************************
		*** Alles zu CSV                                       ***
		**********************************************************
		Beim ersten Mal noch keine Tabelle nötig.
		*/
		//
		//
		/*
			Encodings feststellen
		*/
		//Map<String, Charset> encodings = Charset.availableCharsets();
		//JComboBox<String> encodingsCB = new JComboBox<>(encodings.keySet().toArray(new String[0]));
		encodingSelector = new EncodingSelector();
		encodingsEingabeCB = encodingSelector.getEingabeEncodingComboBox();
		encodingsAusgabeCB = encodingSelector.getAusgabeEncodingComboBox();


		cvsCB = new JComboBox<>();
		trennerInputCB = new JComboBox<>();
		trennerOutputCB = new JComboBox<>();
		for (int i = 0; i < 2001; i++){
			cvsCB.addItem(""+i);
		}
		trennerInputCB.addItem(",");
		trennerInputCB.addItem(";");
		trennerInputCB.addItem(":");
		trennerInputCB.addItem("tab");
		trennerInputCB.addItem(" ");

		trennerOutputCB.addItem(",");
		trennerOutputCB.addItem(";");
		trennerOutputCB.addItem(":");
		trennerOutputCB.addItem("tab");
		trennerOutputCB.addItem(" ");

		//Toolbar
		csvBar = new JToolBar();
		leftCSVPanel     = new JPanel();
		centerCSVPanel   = new JPanel();
		rightCSVPanel    = new JPanel();
		csvProgressPanel = new JPanel();
		labelCSVStatus   = new JLabel("");
		
		mainCSVPanel     = new JPanel();
		JLabel cvsLabel  = new JLabel("Anzahl pro Feld");
		JLabel trennerInputLabel   = new JLabel("Trenner Eingabe:");
		JLabel trennerOutputLabel  = new JLabel("Trenner Ausgabe:");
		JLabel encodingInputLabel  = new JLabel("Encoding Eingabe:");
		JLabel encodingOutputLabel = new JLabel("Encoding Ausgabe:");
		csvPfad = new JTextField("Hier Pfad zum Aktualisieren eingeben.");
		csvPfadAktualisierenButton = new JButton("Aktualisieren");
		csvPfadAktualisierenButton.addActionListener(new ButtonActionListener(this));
		csvPfadAktualisierenButton.setToolTipText("Öffnungspfade neu setzen");
		csvPfadAktualisierenButton.setEnabled(true);
		
		//vergleichBar.setLayout(new FlowLayout(FlowLayout.LEFT));
		csvBar.setLayout(new java.awt.BorderLayout());
		leftCSVPanel.setLayout(new java.awt.BorderLayout());
		
		openCSVButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-open.png")));
		openCSVButton.addActionListener(new ButtonActionListener(this));
		openCSVButton.setToolTipText("Datei einlesen");
		
		leftCSVPanel.add(openCSVButton);
		csvBar.add(leftCSVPanel, java.awt.BorderLayout.PAGE_START);
		csvBar.add(centerCSVPanel, java.awt.BorderLayout.CENTER);
		csvBar.add(rightCSVPanel, java.awt.BorderLayout.LINE_END);
		
		
		progressBarCSV = new JProgressBar(0, 100);
		progressBarCSV.setValue(100);
		progressBarCSV.setStringPainted(false);
		
		csvProgressPanel.add(labelCSVStatus);
		csvProgressPanel.add(progressBarCSV);
		csvProgressPanel.add(csvPfad);
		csvProgressPanel.add(csvPfadAktualisierenButton);
		
		
		mainCSVPanel.setLayout(new java.awt.FlowLayout());
		mainCSVPanel.add(cvsLabel);
		mainCSVPanel.add(cvsCB);
		mainCSVPanel.add(trennerInputLabel);
		mainCSVPanel.add(trennerInputCB);
		mainCSVPanel.add(trennerOutputLabel);
		mainCSVPanel.add(trennerOutputCB);
		mainCSVPanel.add(encodingInputLabel);
		mainCSVPanel.add(encodingsEingabeCB);
		mainCSVPanel.add(encodingOutputLabel);
		mainCSVPanel.add(encodingsAusgabeCB);
		cvsCB.setSelectedIndex(40);
		
		panelCSV.setLayout( new java.awt.BorderLayout() );
		panelCSV.add(csvBar, java.awt.BorderLayout.PAGE_START);
		panelCSV.add(mainCSVPanel, java.awt.BorderLayout.CENTER);
		panelCSV.add(csvProgressPanel, java.awt.BorderLayout.PAGE_END);
		//panelCSV.add(tabpaneDatev, java.awt.BorderLayout.CENTER);
		
		/*
		**********************************************************
		*** ENDE CSV                                           ***
		**********************************************************
		*/
		
		
		//Anzeigen
		f.setVisible( true );
		
		
		splitR.setDividerLocation(0.5d);
		splitR.setResizeWeight(0.5d);
		
		datumLCB.setEnabled(false);
		datumRCB.setEnabled(false);
		sollLCB.setEnabled(false);
		sollRCB.setEnabled(false);
		habenLCB.setEnabled(false);
		habenRCB.setEnabled(false);

		zeig1LCB.setEnabled(false);
		zeig2LCB.setEnabled(false);
		zeig3LCB.setEnabled(false);
		zeig4LCB.setEnabled(false);
		zeig1RCB.setEnabled(false);
		zeig2RCB.setEnabled(false);
		zeig3RCB.setEnabled(false);
		zeig4RCB.setEnabled(false);

		vergleichStartButton.setEnabled(false);
		makeNewButton.setEnabled(false);
		visibleButton.setEnabled(false);
		columnVisibleButton.setEnabled(false);
		testButton.setEnabled(false);
		selectButton.setEnabled(false);
		editRowButton.setEnabled(false);
		dateButton.setEnabled(false);
		blockButton.setEnabled(false);
		stornoLCB.setSelected(true);
		stornoRCB.setSelected(true);
		summandenSucheLCB.setSelected(false);
		summandenSucheRCB.setSelected(false);
		sucheOhneDatumLCB.setSelected(false);
		sucheOhneDatumRCB.setSelected(false);
		abbruchRCB.setSelectedIndex(maxAuswahl-1);
		abbruchSaldoCB.setSelectedIndex(maxAuswahl-1);
	}
	
	/*
	***********************************************
	***********************************************
	***                                         ***
	***   ***   ***   A C T I O N   ***   ***   ***
	***                                         ***
	***********************************************
	***********************************************	
	*/

	

	

	public void action(ActionEvent e){
		//System.out.println("Wer A sagt");
		String cmd = e.getActionCommand();
		Object src = e.getSource();
		if(src == summeFindenbt){
			holeDaten();
		} else if(src == stopButton){
			stopButton.setEnabled(false);
			so.beenden();
		} else if(src == openButton){
			einlesenEingabe();
		} else if(src == saveButton){
			speichernErgebnisse();
		} else if(src == neuButton){
			neueSeite(true);
		} else if(src == aboutButton){
			hilfe();
		} else if(src == leerButton){
			leeren();
		} else if(src == benchmarkButton){
			benchmark();
		} else if(src == tabelleLButton){
			holeDatei(TABLINKS);
		} else if(src == tabelleRButton){
			holeDatei(TABRECHTS);
		} else if(src == testButton){
			testen();
		} else if(src == vergleichStartButton){
			vergleichen();
		} else if(src == visibleButton){
			switchVisible();
		} else if(src == columnVisibleButton){
			switchColumnVisibleButton();
		} else if(src == selectButton){
			getSummeSelectedRows();
		} else if(src == editRowButton){
			editSelectedRow();
		} else if(src == makeNewButton){
			resetStatus();
		} else if(src == dateButton){
			tagessuche();
		} else if(src == blockButton){
			findeSummeSelectedRows();
		} else if(src == datevDateiButton){
			ladeDatev();
		} else if(src == openSaldoButton){
			holeDatei(TABSALDO);
		} else if(src == firstButton){
			first();
		} else if(src == lastButton){
			last();
		} else if(src == linksButton){
			left();
		} else if(src == rechtsButton){
			right();
		} else if(src == SuSaButton){
			SuSaCalc();
		} else if(src == SuSaDruckButton){
			SuSaprint();
		} else if(src == SuSaSaveButton){
			speichernSuSa();
		} else if(src == KontoSaveButton){
			speichernKonto();
		} else if(src == sollhabenButton){
			sollHabenVergleich();
		} else if(src == nummer){
			Kontoauswahl();
		} else if(src == toVergleichButton){
			toVergleich(TABRECHTS);
		} else if(src == toSaldoButton){
			toVergleich(TABSALDO);
		} else if(src == startSaldoButton){
			saldoStart();
		} else if(src == testSaldoButton){
			saldoTest();
		} else if(src == allesSaldoButton){
			alleSchritte();
		} else if(src == overNullSaldoButton){
			schritt(5);
		} else if(src == unterhalbSaldoButton){
			schritt(6);
		} else if(src == negativSaldoButton){
			schritt(7);
		} else if(src == gleicherSaldoButton){
			schritt(8);
		} else if(src == findeNullSaldoButton){
			schritt(9);
		} else if(src == findeSaldoButton){
			schritt(10);
		} else if(src == paarSaldoButton){
			paarSaldo();
		} else if(src == presentSaldoButton){
			presentSaldo();
		} else if(src == makeNewSaldoButton){
			resetStatusSaldo();
		} else if(src == saldozuSummeButton){
			//saldozuSumme();
			pushToFind();
		} else if(src == saveSaldoButton){
			speichernSaldo(TABSALDO);
		} else if(src == selectAllSaldoButton){
			selectAll();
		} else if(src == sortButton){
			sortColumn();
		} else if(src == noDuploButton){
			noDuplo();
		} else if(src == statusSaldoButton){
			statusAnwenden();
		} else if(src == analyseSaldoButton){
			analyse();
		} else if(src == openCSVButton){
			holeDatei(CSV);
		} else if(src == csvPfadAktualisierenButton){
			pfadAktualisieren();
		}
	}
	
	public void leeren(){
		neueSeite(false);
	}
	
	private void testeSaldoThread(){
		if(null == st){
			st = new SaldoThread(this, datenSaldo);
			datenSaldo.setGUIVorzeichen(vorStattSpalteSaldoCB.isSelected());
			st.setGUIDaten(vorStattSpalteSaldoCB.isSelected(), abbruchSaldoCB.getSelectedIndex(), 
				datumSaldoCB.getSelectedIndex()-1,
				sollSaldoCB.getSelectedIndex()-1,
				habenSaldoCB.getSelectedIndex()-1);
		
			datenSaldo.setzeGUIDaten(datumLCB.getSelectedIndex()-1, 
				sollSaldoCB.getSelectedIndex()-1, 
				habenSaldoCB.getSelectedIndex()-1, 
				false, 
				false, 
				false, 
				false);
			st.start();
		}
	}
	
	private void starteSaldoThread(int was){
		st = new SaldoThread(this, datenSaldo, was);
		datenSaldo.setGUIVorzeichen(vorStattSpalteSaldoCB.isSelected());
		st.setGUIDaten(vorStattSpalteSaldoCB.isSelected(), abbruchSaldoCB.getSelectedIndex(), 
			datumSaldoCB.getSelectedIndex()-1,
			sollSaldoCB.getSelectedIndex()-1,
			habenSaldoCB.getSelectedIndex()-1);
		datenSaldo.setzeGUIDaten(datumLCB.getSelectedIndex()-1, 
			sollSaldoCB.getSelectedIndex()-1, 
			habenSaldoCB.getSelectedIndex()-1, 
			false, 
			false, 
			false, 
			false);
		st.start();
	}
	
	private void analyse(){
		//testeSaldoThread();
		//st.analyse();
		starteSaldoThread(SaldoThread.was_analyse);
	}
	
	public void analyseSaldoDialog(String ausgabe){
		JDialog bericht = new JDialog(f, "Analyse");
			bericht.setTitle("Analyse");
			bericht.setSize(600,400);
			bericht.setModal(false);
			JEditorPane berichtTextArea = new JEditorPane("text/html", "<html><head><Title>Auswertung</TITLE></HEAD><BODY><H1>Auswertung</H1>"+ausgabe+"</BODY></html>");
			//berichtTextArea.setPage();
			//berichtTextArea.setText(saldoAusgabeText);
			//berichtTextArea.setLineWrap(true);
			//berichtTextArea.setWrapStyleWord(true);
			JScrollPane berichtScroll = new JScrollPane(berichtTextArea);
			bericht.add(berichtScroll);
		
		//berichtTextArea.setText(saldoAusgabeText);
		bericht.setVisible(true);
	}
	
	private void alleSchritte(){
		testeSaldoThread();
		st.alles();
	}
	
	private void paarSaldo(){
		testeSaldoThread();
		st.paarSaldo();
		ddmS.fireTableDataChanged();
	}
	
	private void statusAnwenden(){
		//testeSaldoThread();
		//Welcher Status, welches Feld, Welcher Text
		//System.out.println("Status: "+statusSaldoCB.getSelectedIndex()+"\nTextSpalte: "+textSaldoCB.getSelectedIndex());
		//st.statusAnwenden(statusSaldoCB.getSelectedIndex(), textSaldoCB.getSelectedIndex()-1, saldoAusschluss.getText());
		//ddmS.fireTableDataChanged();
		starteSaldoThread(SaldoThread.was_anwenden);
	}
	
	public int getSaldoStatus(){
		return statusSaldoCB.getSelectedIndex();
	}
	
	public int getSaldoTextSpalte(){
		return textSaldoCB.getSelectedIndex()-1;
	}
	
	public String getSaldoSuchtext(){
		return saldoAusschluss.getText();
	}
	
	public int getGegenSpalte(){
		return gegenSaldoCB.getSelectedIndex()-1;
	}
	
	private void schritt(int schritt){
		testeSaldoThread();
		switch(schritt){
			case 5: st.schritt5();
				break;
			case 6: st.schritt6();
				break;
			case 7: st.schritt7();
				break;
			case 8: st.schritt8();
				break;
			case 9:	st.schritt9();
				break;
			case 10:st.schritt10();
				break;
		}
		ddmS.fireTableDataChanged();
	}
	
	private void toVergleich(int ladeWas){
		//Daten aus dem Datevpanel (Konto) in den rechten Bereich des Vergleiches übertragen.
		int kontonr = 0;
		int zeilen = 0;
		int spalten = 9;//Datevstandard
		Konto konto;
		DatevKopieVergleichThread dkvt;
		switch (ladeWas){
			case TABRECHTS:
				kontonr = datevdaten.getKontonummer();
				konto = datevdaten.getKonto(kontonr);
				zeilen = konto.getRowCount();
				datenR = new DateiDaten(zeilen, spalten);
				dkvt = new DatevKopieVergleichThread(this, konto, datenR, ladeWas);
				dkvt.start();
				break;
			case TABSALDO:
				kontonr = datevdaten.getKontonummer();
				konto = datevdaten.getKonto(kontonr);
				zeilen = konto.getRowCount();
				datenSaldo = new DateiDaten(zeilen, spalten);
				dkvt = new DatevKopieVergleichThread(this, konto, datenSaldo, ladeWas);
				dkvt.start();
				break;
		}
	}

	public void nachtoVergleich(int ladeWas, DateiDaten daten){
		int spalten = 9;
		DateiDatenTableModel ddm;
		switch(ladeWas){
		case TABRECHTS:
			this.datenR = daten;
			ddm = new DateiDatenTableModel();
			ddm.setData(daten);
			ddmR = ddm;
			vergleichRechts.removeAll();
			tableRechts  = new JTable(ddm);
			tableRechts.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			((JLabel)tableRechts.getDefaultRenderer(String.class)).setHorizontalAlignment (JLabel.RIGHT);
			//for(int i = 0;i < loesungen+1; i++){
				//tableLinks.getColumnModel().getColumn(i).setPreferredWidth(80);
			JScrollPane scrollPane2 = new JScrollPane(tableRechts);
			tableRechts.setFillsViewportHeight(true);
			vergleichRechts.setLayout(new BorderLayout() );
			vergleichRechts.add(scrollPane2, BorderLayout.CENTER);
			scrollPane2.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

			progressBarVergleich2.setIndeterminate(false);
			progressBarVergleich2.setStringPainted(true);
			progressBarVergleich2.setMaximum(100);
			progressBarVergleich2.setValue(100);
			
			tableRechts.setDefaultRenderer( Object.class, new MyCellRenderer(datenR));
			tableRechts.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor());
			tableRechts.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			tableRechts.setRowSelectionAllowed(true);
			tableRechts.setColumnSelectionAllowed(false);
			//tableRechts.addListSelectionListener(new MyListSelectionHandler(this));
			
			//Datumspalte setzen
			spalten = datenR.getSpalten();
			datumRCB.removeAllItems();
			sollRCB.removeAllItems();
			habenRCB.removeAllItems();

			zeig1RCB.removeAllItems();
			zeig2RCB.removeAllItems();
			zeig3RCB.removeAllItems();
			zeig4RCB.removeAllItems();

			datumRCB.addItem("Keine");
			sollRCB.addItem("Keine");
			habenRCB.addItem("Keine");

			zeig1RCB.addItem("Keine");
			zeig2RCB.addItem("Keine");
			zeig3RCB.addItem("Keine");
			zeig4RCB.addItem("Keine");
			for(int i = 0; i < spalten; i++){
				datumRCB.addItem(""+(i+1)+": "+textkurz(datenR.getText(0,i),10));
				sollRCB.addItem(""+(i+1)+": "+textkurz(datenR.getText(0,i),10));
				habenRCB.addItem(""+(i+1)+": "+textkurz(datenR.getText(0,i),10));

				zeig1RCB.addItem(""+(i+1)+": "+textkurz(datenR.getText(0,i),10));
				zeig2RCB.addItem(""+(i+1)+": "+textkurz(datenR.getText(0,i),10));
				zeig3RCB.addItem(""+(i+1)+": "+textkurz(datenR.getText(0,i),10));
				zeig4RCB.addItem(""+(i+1)+": "+textkurz(datenR.getText(0,i),10));
			}
			datumRCB.setSelectedIndex(2);
			sollRCB.setSelectedIndex(3);
			habenRCB.setSelectedIndex(4);
		
			datumRCB.setEnabled(true);
			sollRCB.setEnabled(true);
			habenRCB.setEnabled(true);
		
			if(null != datenR && null != datenL){
				testButton.setEnabled(true);
				selectButton.setEnabled(true);
				dateButton.setEnabled(true);
				blockButton.setEnabled(true);
				vergleichStartButton.setEnabled(true);
				visibleButton.setEnabled(true);
				makeNewButton.setEnabled(true);
				sollhabenButton.setEnabled(true);
			}
		
			JOptionPane.showMessageDialog(f, "Die Daten stehen im Reiter Vergleich bereit!", "Kopieren der Daten Konto in Vergleich.", JOptionPane.INFORMATION_MESSAGE);
			tcmR = new TableColumnManager(tableRechts);
			break;
		case TABSALDO:
			this.datenSaldo = daten;
			ddm = new DateiDatenTableModel();
			ddm.setData(daten);
			ddmS = ddm;
			saldoausgabe.removeAll();
			tableSaldo  = new JTable(ddm);
			tableSaldo.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			((JLabel)tableSaldo.getDefaultRenderer(String.class)).setHorizontalAlignment (JLabel.RIGHT);
			JScrollPane scrollPaneSaldo = new JScrollPane(tableSaldo);
			tableSaldo.setFillsViewportHeight(true);
			saldoausgabe.setLayout(new BorderLayout() );
			saldoausgabe.add(scrollPaneSaldo, BorderLayout.CENTER);
			scrollPaneSaldo.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

			progressBarSaldo.setIndeterminate(false);
			progressBarSaldo.setStringPainted(true);
			progressBarSaldo.setMaximum(100);
			progressBarSaldo.setValue(100);
			
			tableSaldo.setDefaultRenderer( Object.class, new MyCellRenderer(datenSaldo));
			tableSaldo.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor());
			tableSaldo.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			tableSaldo.setRowSelectionAllowed(true);
			tableSaldo.setColumnSelectionAllowed(false);
			
			//Datumspalte setzen
			spalten = datenSaldo.getSpalten();
			datumSaldoCB.removeAllItems();
			sollSaldoCB.removeAllItems();
			habenSaldoCB.removeAllItems();
			textSaldoCB.removeAllItems();
			gegenSaldoCB.removeAllItems();
			datumSaldoCB.addItem("Keine");
			sollSaldoCB.addItem("Keine");
			habenSaldoCB.addItem("Keine");
			textSaldoCB.addItem("Keine");
			gegenSaldoCB.addItem("Keine");
			for(int i = 0; i < spalten; i++){
				datumSaldoCB.addItem(""+(i+1)+": "+textkurz(datenSaldo.getText(0,i),10));
				sollSaldoCB.addItem(""+(i+1)+": "+textkurz(datenSaldo.getText(0,i),10));
				habenSaldoCB.addItem(""+(i+1)+": "+textkurz(datenSaldo.getText(0,i),10));
				textSaldoCB.addItem(""+(i+1)+": "+textkurz(datenSaldo.getText(0,i),10));
				gegenSaldoCB.addItem(""+(i+1)+": "+textkurz(datenSaldo.getText(0,i),10));
			}
			datumSaldoCB.setSelectedIndex(2);
			sollSaldoCB.setSelectedIndex(3);
			habenSaldoCB.setSelectedIndex(4);
			textSaldoCB.setSelectedIndex(9);
			gegenSaldoCB.setSelectedIndex(8);
		
			datumSaldoCB.setEnabled(true);
			sollSaldoCB.setEnabled(true);
			habenSaldoCB.setEnabled(true);
			textSaldoCB.setEnabled(true);
			gegenSaldoCB.setEnabled(true);
			statusSaldoCB.setEnabled(true);
		
			/*
			Buttons aktivieren
			if(null != datenR && null != datenL){
				testButton.setEnabled(true);
				selectButton.setEnabled(true);
				dateButton.setEnabled(true);
				blockButton.setEnabled(true);
				vergleichStartButton.setEnabled(true);
				visibleButton.setEnabled(true);
				makeNewButton.setEnabled(true);
				sollhabenButton.setEnabled(true);
			}
			*/
			saveSaldoButton.setEnabled(true);
			saldozuSummeButton.setEnabled(true);
			startSaldoButton.setEnabled(true);
			selectAllSaldoButton.setEnabled(true);
			testSaldoButton.setEnabled(true);
			allesSaldoButton.setEnabled(true);
			overNullSaldoButton.setEnabled(true);
			unterhalbSaldoButton.setEnabled(true);
			negativSaldoButton.setEnabled(true);
			gleicherSaldoButton.setEnabled(true);
			findeNullSaldoButton.setEnabled(true);
			findeSaldoButton.setEnabled(true);
			paarSaldoButton.setEnabled(true);
			analyseSaldoButton.setEnabled(true);
			presentSaldoButton.setEnabled(true);	
			makeNewSaldoButton.setEnabled(true);
			statusSaldoButton.setEnabled(true);
		
			st = null;
			testeSaldoThread();
		
			JOptionPane.showMessageDialog(f, "Die Daten stehen im Reiter Saldo bereit!", "Kopieren der Daten Konto in Saldo.", JOptionPane.INFORMATION_MESSAGE);
			tcmS = new TableColumnManager(tableSaldo);
			break;
		}
	}
	
	private void saldoStart(){
		st = null;
		testeSaldoThread();
		//st = new SaldoThread(this, datenSaldo);
		/*
			Die Textspalte muss noch identifiziert und übergeben werden!!!
		*/
		//JOptionPane.showMessageDialog(f, "Das Beste wurde versucht.", "Saldo berechnen.", JOptionPane.INFORMATION_MESSAGE);
		setMaxVergleich(TABSALDO, 100);
		setStatusVergleich(TABSALDO, 100);
		progressIntermediate(TABSALDO, false);
	}
	
	private void saldoTest(){
		st = null;
		testeSaldoThread();
		datenSaldo.sortieren();
		ddmS.fireTableDataChanged();
	}
	
	private void Kontoauswahl(){
		int konto = datevdaten.getKontonummer();
		//System.out.println("Anfrage: Kontoänderung?");
		try{
			konto = (Integer.parseInt(nummer.getText()));
		} catch (NumberFormatException nfe){
			//Wat sollen wa machen. Ist halt keine Nummer.
		}
		if(konto > 0){
			kontonummer = datevdaten.getKontonummer(konto);
			nummer.setText(""+kontonummer); 
			ktm.setKonto(kontonummer);
			ktm.fireTableDataChanged();
		}
	}
	
	private void sollHabenVergleich(){
		datenL.setzeGUIDaten(datumLCB.getSelectedIndex()-1, sollLCB.getSelectedIndex()-1, habenLCB.getSelectedIndex()-1, stornoLCB.isSelected(), ignoreLCB.isSelected(), summandenSucheLCB.isSelected(), sucheOhneDatumLCB.isSelected());
		datenR.setzeGUIDaten(datumRCB.getSelectedIndex()-1, sollRCB.getSelectedIndex()-1, habenRCB.getSelectedIndex()-1, stornoRCB.isSelected(), ignoreRCB.isSelected(), summandenSucheRCB.isSelected(), sucheOhneDatumRCB.isSelected());
		String ergebnis = "" +	"Daten links Soll: "+intToString(datenL.getSollSumme())+
					"\nDaten links Haben: "+intToString(datenL.getHabenSumme())+
					"\nDaten rechts Soll: "+intToString(datenR.getSollSumme())+
					"\nDaten rechts Haben: "+intToString(datenR.getHabenSumme());
		System.out.println(ergebnis);
		JOptionPane.showMessageDialog(f, ergebnis, "Soll- und Habenvergleich.", JOptionPane.INFORMATION_MESSAGE);
	}
	
	public void switchVisible(){
		ddmL.switchVisible();
		if(ddmL.isVisible()){
			tableLinks.setDefaultRenderer( Object.class, new MyCellRenderer(datenL));
			tableLinks.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor());
			tableLinks.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			tableLinks.setRowSelectionAllowed(true);
			tableLinks.setColumnSelectionAllowed(false);
			blockButton.setEnabled(true);
		} else {
			tableLinks.setDefaultRenderer( Object.class, new MyCellRenderer(datenL.getInvinsible()));
			tableLinks.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor());
			tableLinks.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			tableLinks.setRowSelectionAllowed(true);
			tableLinks.setColumnSelectionAllowed(false);
			blockButton.setEnabled(false);
		}
		ddmR.switchVisible();
		if(ddmR.isVisible()){
			tableRechts.setDefaultRenderer( Object.class, new MyCellRenderer(datenR));
			tableRechts.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor());
			tableRechts.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			tableRechts.setRowSelectionAllowed(true);
			tableRechts.setColumnSelectionAllowed(false);
		} else {
			tableRechts.setDefaultRenderer( Object.class, new MyCellRenderer(datenR.getInvinsible()));
			tableRechts.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor());
			tableRechts.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			tableRechts.setRowSelectionAllowed(true);
			tableRechts.setColumnSelectionAllowed(false);
		}
		ddmL.fireTableDataChanged();
		ddmR.fireTableDataChanged();
	}

	private void switchColumnVisibleButton(){
		if(statusColumnVisibleButton){
			columnVisibleButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/column-show.png")));
			tcmL.hideAllColumn();

			tcmL.showColumn(0);
			tcmL.showColumn(1);
			tcmL.showColumn(2);
			tcmL.showColumn(3);

			if(datumLCB.getSelectedIndex()>0)
				tcmL.showColumn(datumLCB.getSelectedIndex()+3);
			if(sollLCB.getSelectedIndex()>0)
				tcmL.showColumn(sollLCB.getSelectedIndex()+3);
			if(habenLCB.getSelectedIndex()>0)
				tcmL.showColumn(habenLCB.getSelectedIndex()+3);

			if(zeig1LCB.getSelectedIndex()>0)
				tcmL.showColumn(zeig1LCB.getSelectedIndex()+3);
			if(zeig2LCB.getSelectedIndex()>0)
				tcmL.showColumn(zeig2LCB.getSelectedIndex()+3);
			if(zeig3LCB.getSelectedIndex()>0)
				tcmL.showColumn(zeig3LCB.getSelectedIndex()+3);
			if(zeig4LCB.getSelectedIndex()>0)
				tcmL.showColumn(zeig4LCB.getSelectedIndex()+3);

			tcmR.hideAllColumn();

			tcmR.showColumn(0);
			tcmR.showColumn(1);
			tcmR.showColumn(2);
			tcmR.showColumn(3);





			if(datumRCB.getSelectedIndex()>0)
				tcmR.showColumn(datumRCB.getSelectedIndex()+3);
			if(sollRCB.getSelectedIndex()>0)
				tcmR.showColumn(sollRCB.getSelectedIndex()+3);
			if(habenRCB.getSelectedIndex()>0)
				tcmR.showColumn(habenRCB.getSelectedIndex()+3);

			if(zeig1RCB.getSelectedIndex()>0)
				tcmR.showColumn(zeig1RCB.getSelectedIndex()+3);
			if(zeig2RCB.getSelectedIndex()>0)
				tcmR.showColumn(zeig2RCB.getSelectedIndex()+3);
			if(zeig3RCB.getSelectedIndex()>0)
				tcmR.showColumn(zeig3RCB.getSelectedIndex()+3);
			if(zeig4RCB.getSelectedIndex()>0)
				tcmR.showColumn(zeig4RCB.getSelectedIndex()+3);

			statusColumnVisibleButton = false;
		} else {
			columnVisibleButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/column-hide.png")));
			tcmL.showAllColumn();
			tcmR.showAllColumn();
			statusColumnVisibleButton = true;
		}
	}

	private void pfadAktualisieren(){
		String pfad = csvPfad.getText();
		Path path = Paths.get(pfad);
		if (Files.exists(path)) {
			if (Files.isDirectory(path)) {
				lastDir = new File(pfad);
				JOptionPane.showMessageDialog(f, "Der Pfad wurde erfolgreich aktualisiert.", "Pfad aktualisieren.", JOptionPane.INFORMATION_MESSAGE);
			} else {
				JOptionPane.showMessageDialog(f, "Der Pfad ist kein Verzeichnis und wurde demnach nicht aktualisiert.", "Pfad aktualisieren.", JOptionPane.WARNING_MESSAGE);
				//System.out.println(new File(pfad).getPath());
			}
		} else {
			JOptionPane.showMessageDialog(f, "Der Pfad existiert nicht und wurde demnach nicht aktualisiert.", "Pfad aktualisieren.", JOptionPane.WARNING_MESSAGE);
		}
	}
	
	private void holeDatei(int ladeWas){
		boolean links = true;
		encodingSelector.setEingabeEncoding(encodingsEingabeCB.getSelectedIndex());
		encodingSelector.setAusgabeEncoding(encodingsAusgabeCB.getSelectedIndex());
		jfc = new JFileChooser();
		//int returnVal = jfc.showOpenDialog(f);
		String pfad = csvPfad.getText();
		
		if (null == this.lastDir){
			if(pfad.equals("Pfad"))
				jfc = new JFileChooser();
			else
				jfc = new JFileChooser(pfad);
		} else {
			jfc = new JFileChooser(this.lastDir);
		}
		FileFilter filter = new FileNameExtensionFilter("CSV-Datei", "csv");
		//jfc.setFileFilter(filter);
		//filter = null;
		switch(ladeWas){
			case TABLINKS: jfc.setDialogTitle("Öffne CVS-Datei (Bank)");
				links = true;
				break;
			case TABRECHTS: jfc.setDialogTitle("Öffne CVS-Datei (Buchhaltung)");
				links = false;
				break;
			case TABSALDO:	jfc.setDialogTitle("Öffne CVS-Datei (Konto)");
				break;
			case SUMMETXT:  jfc.setDialogTitle("Öffne Eingabedatei");
					filter = new FileNameExtensionFilter("CSV oder Textdatei", "csv", "txt");
				break;
			case CSV:	jfc.setDialogTitle("Öffne CVS-Datei");
				jfc.setMultiSelectionEnabled(true);
				filter = new FileNameExtensionFilter("CSV oder Textdatei", "csv", "txt");
				break;
			default:
		}
		/*
		if(links)
			jfc.setDialogTitle("Öffne CVS-Datei (Bank)");
		else
			jfc.setDialogTitle("Öffne CVS-Datei (Buchhaltung)");
		*/
		
		//jfc.addChoosableFileFilter(filter);
		if(null != filter){
			jfc.setFileFilter(filter);
			jfc.addChoosableFileFilter(filter);
		}
		int ret = jfc.showOpenDialog(f);
		if (ret == JFileChooser.APPROVE_OPTION) {
			//erfolgreich
			String str1 = jfc.getSelectedFile().getName();
			String str2 = jfc.getSelectedFile().getPath();
			String str3 = jfc.getSelectedFile().getAbsolutePath();
			file = new File(str3);
			//ignoriere erste Zeile!
			boolean ignore = false;
			switch(ladeWas){
				case TABLINKS: ignore = firstLCB.isSelected();
					break;
				case TABRECHTS: ignore = firstRCB.isSelected();
					break;
				case TABSALDO:	ignore = firstSaldoCB.isSelected();
					break;
				default:
			}
			/*
			if(links){
				ignore = firstLCB.isSelected();
			} else {
				ignore = firstRCB.isSelected();
			}
			*/
			if (null != this.file) {
				switch(ladeWas){
					case TABLINKS:
					case TABRECHTS:
						dateiOrga = new DateiOrganisator(this, f, file, ladeWas, ignore, encodingSelector.getEingabeEncoding());
						progressIntermediate(ladeWas, true);
						dateiOrga.start();
						break;
					case SUMMETXT:
						progressBar.setStringPainted(true);
						statustext.setText("Laden.");
						LadenSummeFinden dateiSummeFinden = new LadenSummeFinden (this, f, file);
						dateiSummeFinden.start();
						break;
					case TABSALDO:
						dateiOrga = new DateiOrganisator(this, f, file, ladeWas, ignore, encodingSelector.getEingabeEncoding());
						progressIntermediate(ladeWas, true);
						dateiOrga.start();
						break;
					case CSV:
						File[] selectedFiles = jfc.getSelectedFiles();
						csvOrga = new CSVOrganisator(this, f, selectedFiles, cvsCB.getSelectedIndex(), trennerInputCB.getSelectedIndex(), trennerOutputCB.getSelectedIndex(), encodingSelector.getEingabeEncoding(), encodingSelector.getAusgabeEncoding());
						csvOrga.start();
				}
			}
			lastDir = file;
		}

	}
	
	public void endeDatei(boolean links){
		if(links)
			progressBarVergleich1.setIndeterminate(false);
		else
			progressBarVergleich2.setIndeterminate(false);
	}
	
	public void setDateiDatenModel(int ladeWas, boolean links, DateiDatenTableModel ddm, DateiDaten daten){
		int spalten = 0;
		switch (ladeWas){
		case TABLINKS:
			datenL = daten;
			ddmL = ddm;
			vergleichLinks.removeAll();
			tableLinks  = new JTable(ddm);
			tableLinks.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			((JLabel)tableLinks.getDefaultRenderer(String.class)).setHorizontalAlignment (JLabel.RIGHT);
			//for(int i = 0;i < loesungen+1; i++){
				//tableLinks.getColumnModel().getColumn(i).setPreferredWidth(80);

			JScrollPane scrollPane1 = new JScrollPane(tableLinks);
			tableLinks.setFillsViewportHeight(true);
			vergleichLinks.setLayout(new BorderLayout() );
			vergleichLinks.add(scrollPane1, BorderLayout.CENTER);
			scrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

			progressBarVergleich1.setIndeterminate(false);
			progressBarVergleich1.setStringPainted(false);
			
			tableLinks.setDefaultRenderer( Object.class, new MyCellRenderer(datenL));
			tableLinks.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor());
			tableLinks.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			tableLinks.setRowSelectionAllowed(true);
			tableLinks.setColumnSelectionAllowed(false);
			//tableLinks.getSelectionModel().addListSelectionListener(new MyListSelectionHandler(this));
			
			//Datumspalte setzen
			spalten = daten.getSpalten();
			datumLCB.removeAllItems();
			sollLCB.removeAllItems();
			habenLCB.removeAllItems();

			zeig1LCB.removeAllItems();
			zeig2LCB.removeAllItems();
			zeig3LCB.removeAllItems();
			zeig4LCB.removeAllItems();

			datumLCB.addItem("Keine");
			sollLCB.addItem("Keine");
			habenLCB.addItem("Keine");
			zeig1LCB.addItem("Keine");
			zeig2LCB.addItem("Keine");
			zeig3LCB.addItem("Keine");
			zeig4LCB.addItem("Keine");

			for(int i = 0; i < spalten; i++){
				datumLCB.addItem(""+(i+1)+": "+textkurz(daten.getText(0,i),10));
				sollLCB.addItem(""+(i+1)+": "+textkurz(daten.getText(0,i),10));
				habenLCB.addItem(""+(i+1)+": "+textkurz(daten.getText(0,i),10));

				zeig1LCB.addItem(""+(i+1)+": "+textkurz(datenL.getText(0,i),10));
				zeig2LCB.addItem(""+(i+1)+": "+textkurz(datenL.getText(0,i),10));
				zeig3LCB.addItem(""+(i+1)+": "+textkurz(datenL.getText(0,i),10));
				zeig4LCB.addItem(""+(i+1)+": "+textkurz(datenL.getText(0,i),10));

			}
			datumLCB.setSelectedIndex(daten.getDatumsSpalte()+1);
			sollLCB.setSelectedIndex(daten.getSollSpalte()+1);
			habenLCB.setSelectedIndex(daten.getHabenSpalte()+1);
			
			datumLCB.setEnabled(true);
			sollLCB.setEnabled(true);
			habenLCB.setEnabled(true);

			zeig1LCB.setEnabled(true);
			zeig2LCB.setEnabled(true);
			zeig3LCB.setEnabled(true);
			zeig4LCB.setEnabled(true);


			splitR.setDividerLocation(0.5d);
			splitR.setResizeWeight(0.5d);
			tcmL = new TableColumnManager(tableLinks);
			break;
		case TABRECHTS:
			datenR = daten;
			ddmR = ddm;
			vergleichRechts.removeAll();
			tableRechts  = new JTable(ddm);
			tableRechts.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			((JLabel)tableRechts.getDefaultRenderer(String.class)).setHorizontalAlignment (JLabel.RIGHT);
			//for(int i = 0;i < loesungen+1; i++){
				//tableLinks.getColumnModel().getColumn(i).setPreferredWidth(80);

			JScrollPane scrollPane2 = new JScrollPane(tableRechts);
			tableRechts.setFillsViewportHeight(true);
			vergleichRechts.setLayout(new BorderLayout() );
			vergleichRechts.add(scrollPane2, BorderLayout.CENTER);
			scrollPane2.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

			progressBarVergleich2.setIndeterminate(false);
			progressBarVergleich2.setStringPainted(false);
			
			tableRechts.setDefaultRenderer( Object.class, new MyCellRenderer(datenR));
			tableRechts.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor());
			tableRechts.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			tableRechts.setRowSelectionAllowed(true);
			tableRechts.setColumnSelectionAllowed(false);
			//tableRechts.addListSelectionListener(new MyListSelectionHandler(this));
			
			//Datumspalte setzen
			spalten = daten.getSpalten();
			datumRCB.removeAllItems();
			sollRCB.removeAllItems();
			habenRCB.removeAllItems();

			zeig1RCB.removeAllItems();
			zeig2RCB.removeAllItems();
			zeig3RCB.removeAllItems();
			zeig4RCB.removeAllItems();

			datumRCB.addItem("Keine");
			sollRCB.addItem("Keine");
			habenRCB.addItem("Keine");

			zeig1RCB.addItem("Keine");
			zeig2RCB.addItem("Keine");
			zeig3RCB.addItem("Keine");
			zeig4RCB.addItem("Keine");

			for(int i = 0; i < spalten; i++){
				datumRCB.addItem(""+(i+1)+": "+textkurz(daten.getText(0,i),10));
				sollRCB.addItem(""+(i+1)+": "+textkurz(daten.getText(0,i),10));
				habenRCB.addItem(""+(i+1)+": "+textkurz(daten.getText(0,i),10));

				zeig1RCB.addItem(""+(i+1)+": "+textkurz(datenR.getText(0,i),10));
				zeig2RCB.addItem(""+(i+1)+": "+textkurz(datenR.getText(0,i),10));
				zeig3RCB.addItem(""+(i+1)+": "+textkurz(datenR.getText(0,i),10));
				zeig4RCB.addItem(""+(i+1)+": "+textkurz(datenR.getText(0,i),10));
			}
			datumRCB.setSelectedIndex(daten.getDatumsSpalte()+1);
			sollRCB.setSelectedIndex(daten.getSollSpalte()+1);
			habenRCB.setSelectedIndex(daten.getHabenSpalte()+1);
			
			datumRCB.setEnabled(true);
			sollRCB.setEnabled(true);
			habenRCB.setEnabled(true);

			zeig1RCB.setEnabled(true);
			zeig2RCB.setEnabled(true);
			zeig3RCB.setEnabled(true);
			zeig4RCB.setEnabled(true);

			splitR.setDividerLocation(0.5d);
			splitR.setResizeWeight(0.5d);
			tcmR = new TableColumnManager(tableRechts);
			break;
		case TABSALDO:
			datenSaldo = daten;
			ddmS = ddm;
			saldoausgabe.removeAll();
			tableSaldo  = new JTable(ddm);
			tableSaldo.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			((JLabel)tableSaldo.getDefaultRenderer(String.class)).setHorizontalAlignment (JLabel.RIGHT);
			JScrollPane scrollPaneSaldo = new JScrollPane(tableSaldo);
			tableSaldo.setFillsViewportHeight(true);
			saldoausgabe.setLayout(new BorderLayout() );
			saldoausgabe.add(scrollPaneSaldo, BorderLayout.CENTER);
			splitSaldo.setRightComponent(saldoausgabe);
			scrollPaneSaldo.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

			progressBarSaldo.setIndeterminate(false);
			
			tableSaldo.setDefaultRenderer( Object.class, new MyCellRenderer(datenSaldo));
			tableSaldo.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor());
			tableSaldo.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			tableSaldo.setRowSelectionAllowed(true);
			tableSaldo.setColumnSelectionAllowed(false);
			
			//Datumspalte setzen
			
			spalten = daten.getSpalten();
			datumSaldoCB.removeAllItems();
			sollSaldoCB.removeAllItems();
			habenSaldoCB.removeAllItems();
			textSaldoCB.removeAllItems();
			gegenSaldoCB.removeAllItems();
			datumSaldoCB.addItem("Keine");
			sollSaldoCB.addItem("Keine");
			habenSaldoCB.addItem("Keine");
			textSaldoCB.addItem("Keine");
			gegenSaldoCB.addItem("Keine");
			for(int i = 0; i < spalten; i++){
				datumSaldoCB.addItem(""+(i+1)+": "+textkurz(daten.getText(0,i),10));
				sollSaldoCB.addItem(""+(i+1)+": "+textkurz(daten.getText(0,i),10));
				habenSaldoCB.addItem(""+(i+1)+": "+textkurz(daten.getText(0,i),10));
				textSaldoCB.addItem(""+(i+1)+": "+textkurz(daten.getText(0,i),10));
				gegenSaldoCB.addItem(""+(i+1)+": "+textkurz(daten.getText(0,i),10));
			}
			datumSaldoCB.setSelectedIndex(daten.getDatumsSpalte()+1);
			sollSaldoCB.setSelectedIndex(daten.getSollSpalte()+1);
			habenSaldoCB.setSelectedIndex(daten.getHabenSpalte()+1);
			textSaldoCB.setSelectedIndex(daten.getHabenSpalte()+1);
			gegenSaldoCB.setSelectedIndex(0);
			
			datumSaldoCB.setEnabled(true);
			sollSaldoCB.setEnabled(true);
			habenSaldoCB.setEnabled(true);
			textSaldoCB.setEnabled(true);
			gegenSaldoCB.setEnabled(true);
			statusSaldoCB.setEnabled(true);
			
			saveSaldoButton.setEnabled(true);
			saldozuSummeButton.setEnabled(true);
			selectAllSaldoButton.setEnabled(true);
			startSaldoButton.setEnabled(true);
			testSaldoButton.setEnabled(true);
			allesSaldoButton.setEnabled(true);
			overNullSaldoButton.setEnabled(true);
			unterhalbSaldoButton.setEnabled(true);
			negativSaldoButton.setEnabled(true);
			gleicherSaldoButton.setEnabled(true);
			findeNullSaldoButton.setEnabled(true);
			findeSaldoButton.setEnabled(true);
			paarSaldoButton.setEnabled(true);
			analyseSaldoButton.setEnabled(true);
			presentSaldoButton.setEnabled(true);	
			makeNewSaldoButton.setEnabled(true);
			statusSaldoButton.setEnabled(true);
			st = null;
			testeSaldoThread();
			tcmS = new TableColumnManager(tableSaldo);
			break;
		}
		
		//Wenn beide geladen sind, darf der Go-Button gedrückt werden!!!
		if(null != datenR && null != datenL){
			testButton.setEnabled(true);
			selectButton.setEnabled(true);
			dateButton.setEnabled(true);
			blockButton.setEnabled(true);
			vergleichStartButton.setEnabled(true);
			visibleButton.setEnabled(true);
			columnVisibleButton.setEnabled(true);
			makeNewButton.setEnabled(true);
			sollhabenButton.setEnabled(true);
		}
	}
	
	private void ladeDatev(){
		jfc = new JFileChooser();
		//int returnVal = jfc.showOpenDialog(f);
		String pfad = csvPfad.getText();
		encodingSelector.setEingabeEncoding(encodingsEingabeCB.getSelectedIndex());

		if (null == this.lastDir){
			if(pfad.equals("Pfad"))
				jfc = new JFileChooser();
			else
				jfc = new JFileChooser(pfad);
		} else {
			jfc = new JFileChooser(this.lastDir);
		}
		jfc.setMultiSelectionEnabled(true);
		jfc.setDialogTitle("Öffne CVS-Datei (Datev-Datei)");
		FileFilter filter = new FileNameExtensionFilter("CSV-Datei", "csv");
		jfc.addChoosableFileFilter(filter);
		jfc.setFileFilter(filter);
		int ret = jfc.showOpenDialog(f);
		if (ret == JFileChooser.APPROVE_OPTION) {
			//erfolgreich
			
			File[] selectedFiles = jfc.getSelectedFiles();
			//for(int i = 0; i < selectedFiles.length; i++){
				//Für jede Datei feststellen, ob die Datei existiert
    		
			
			String str1 = jfc.getSelectedFile().getName();
			String str2 = jfc.getSelectedFile().getPath();
			String str3 = jfc.getSelectedFile().getAbsolutePath();
			file = new File(str3);
			if (null != this.file) {
				datevOrga = new DatevOrganisator(this, f, selectedFiles, encodingSelector.getEingabeEncoding());
				datevProgressIntermediate(true);
				datevOrga.start();
			}
			lastDir = file;
		}
	}
	
	public void datevGeladen(DatevDaten datevdaten){
		this.datevdaten = datevdaten;
		tabpaneDatev.setEnabled(true);
		tabpaneDatev.removeAll();
		
		//primanotaTable = new JTable();
		//primanotascroll.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		//panelDatevPrimanota.setLayout( new java.awt.BorderLayout() );
		//panelDatevPrimanota.add(datevBar, java.awt.BorderLayout.PAGE_START);
		
		panelDatevPrimanota = new JPanel();
		panelDatevSuSa = new JPanel();
		panelDatevKonto = new JPanel();
		
		/*
			Alles zu Konto
		*/
		
		firstButton   = new JButton();
		linksButton   = new JButton();
		rechtsButton  = new JButton();
		lastButton    = new JButton();
		datevKontoBar = new JToolBar();
		
		nummer = new JTextField(""+datevdaten.getFirstKonto());
		nummer.setColumns(10);
		nummer.addActionListener(new ButtonActionListener(this));
		
		firstButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/media-skip-backward.png")));
		linksButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/media-seek-backward.png")));
		rechtsButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/media-seek-forward.png")));
		lastButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/media-skip-forward.png")));
		
		firstButton.setToolTipText("Erstes Konto");
		linksButton.setToolTipText("Konto vorher");
		rechtsButton.setToolTipText("Konto nachher");
		lastButton.setToolTipText("Letztes Konto");
		
		firstButton.addActionListener(new ButtonActionListener(this));
		linksButton.addActionListener(new ButtonActionListener(this));
		rechtsButton.addActionListener(new ButtonActionListener(this));
		lastButton.addActionListener(new ButtonActionListener(this));
		
		KontoSaveButton = new JButton();
		KontoSaveButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-save.png")));
		KontoSaveButton.setToolTipText("Exportiere das Konto als csv.");
		KontoSaveButton.addActionListener(new ButtonActionListener(this));
		KontoSaveButton.setEnabled(true);
		
		toVergleichButton = new JButton();
		toVergleichButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/edit-undo.png")));
		toVergleichButton.setToolTipText("Exportiere das Konto in den Vergleich.");
		toVergleichButton.addActionListener(new ButtonActionListener(this));
		toVergleichButton.setEnabled(true);
		
		toSaldoButton = new JButton();
		toSaldoButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/edit-redo.png")));
		toSaldoButton.setToolTipText("Exportiere das Konto in Saldoberechnung.");
		toSaldoButton.addActionListener(new ButtonActionListener(this));
		toSaldoButton.setEnabled(true);
		
		datevKontoBar.setLayout(new java.awt.BorderLayout());
		JPanel leftDSbar = new JPanel();
		JPanel centerDSbar = new JPanel();
		JPanel rightDSbar = new JPanel();
		/*
		leftDSbar.add(openButton);
		leftDSbar.add(saveButton);
		leftDSbar.add(new JSeparator());
		leftbar.add(neuButton);
		leftbar.add(leerButton);
		leftbar.add(summeFindenbt);
		leftbar.add(new JSeparator());
		leftbar.add(stopButton);
		*/
		
		centerDSbar.add(firstButton);
		centerDSbar.add(linksButton);
		centerDSbar.add(nummer);
		centerDSbar.add(rechtsButton);
		centerDSbar.add(lastButton);
		
		leftDSbar.add(toVergleichButton);
		rightDSbar.add(toSaldoButton);
		rightDSbar.add(KontoSaveButton);
		
		
		ktm = datevdaten.getKontoTableModel();
		kontoTable = new JTable(ktm);
		((JLabel)kontoTable.getDefaultRenderer(String.class)).setHorizontalAlignment (JLabel.RIGHT);
		kontoscroll = new JScrollPane(kontoTable);
		panelDatevKonto.setLayout( new java.awt.BorderLayout() );
		panelDatevKonto.add(kontoscroll, java.awt.BorderLayout.CENTER);
		kontoTable.addMouseListener(new tableMouseListener(this));
		
		datevKontoBar.add(leftDSbar, java.awt.BorderLayout.LINE_START);
		datevKontoBar.add(centerDSbar, java.awt.BorderLayout.CENTER);
		datevKontoBar.add(rightDSbar, java.awt.BorderLayout.LINE_END);
		panelDatevKonto.add(datevKontoBar, java.awt.BorderLayout.PAGE_START);
		
		/*
			Alles Zu Primanota
		*/
		primanotaTable = new JTable(datevdaten.getTableModel());
		primanotascroll = new JScrollPane(primanotaTable);
		panelDatevPrimanota.setLayout( new java.awt.BorderLayout() );
		panelDatevPrimanota.add(primanotascroll, java.awt.BorderLayout.CENTER);
		
		/*
			Alles Zur SuSa
		*/
		
		SuSaButton = new JButton();
		SuSaButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/accessories-calculator.png")));
		SuSaButton.setToolTipText("Berechne Daten erneut.");
		SuSaButton.addActionListener(new ButtonActionListener(this));
		
		SuSaDruckButton = new JButton();
		SuSaDruckButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-print.png")));
		SuSaDruckButton.setToolTipText("Drucke SuSa.");
		SuSaDruckButton.addActionListener(new ButtonActionListener(this));
		
		
		SuSaSaveButton = new JButton();
		SuSaSaveButton.setIcon(new ImageIcon(Buchhalter.class.getResource("icons/document-save.png")));
		SuSaSaveButton.setToolTipText("Exportiere SuSa in csv.");
		SuSaSaveButton.addActionListener(new ButtonActionListener(this));
		
		datevSuSaBar.setLayout(new java.awt.BorderLayout());
		JPanel leftsusabar = new JPanel();
		JPanel centersusabar = new JPanel();
		JPanel rightsusabar = new JPanel();
		
		leftsusabar.add(SuSaButton);
		leftsusabar.add(SuSaDruckButton);
		leftsusabar.add(SuSaSaveButton);
		SuSaButton.setEnabled(true);
		SuSaDruckButton.setEnabled(true);
		SuSaSaveButton.setEnabled(true);
		
		datevSuSaBar.add(leftsusabar, java.awt.BorderLayout.LINE_START);
		
		stm = datevdaten.getSuSaTableModel();
		susaTable = new JTable(datevdaten.getSuSaTableModel());
		susascroll = new JScrollPane(susaTable);
		panelDatevSuSa.setLayout( new java.awt.BorderLayout() );
		panelDatevSuSa.add(datevSuSaBar, java.awt.BorderLayout.PAGE_START);
		panelDatevSuSa.add(susascroll, java.awt.BorderLayout.CENTER);
		
		((JLabel)susaTable.getDefaultRenderer(String.class)).setHorizontalAlignment (JLabel.RIGHT);
		
		tabpaneDatev.addTab("Primanota", panelDatevPrimanota);
		tabpaneDatev.addTab("SuSa", panelDatevSuSa);
		tabpaneDatev.addTab("Konto", panelDatevKonto);
		datevOrga = null;
	}
	
	private void SuSaCalc(){
		stm = (SuSaTableModel) susaTable.getModel();
		stm.SuSaCalc(susaTable);
		/*
		Alles kein Zweck, wir brauchen das Tablemodel direkt aus der Tabelle.
		Dann klappt das auch.
		
		stm.fireTableDataChanged();
		susaTable = new JTable(stm);
		susaTable.validate();
		susaTable.invalidate();
		susaTable.validate();
		susaTable.repaint();
		susaTable.setModel(tableUserModel);
		susaTable.repaint();
		susaTable.updateUI();
		*/
	}
	
	private void SuSaprint(){
		JOptionPane.showMessageDialog(f, "Die SuSa kann leider noch nicht gedruckt werden.", "Drucken.", JOptionPane.ERROR_MESSAGE);
		/*
		PrinterJob printJob = PrinterJob.getPrinterJob();
		PrintObject po = new PrintObject();
		printJob.setPrintable(po);
		if(printJob.printDialog()){
			//final Dimension dimPageDimension = printJob.getPageDimension();
			//po.setDimension(printJob.getPageDimension());
			po.setTableModel((SuSaTableModel) susaTable.getModel());
			try{
				printJob.print();
			} catch (PrinterException e){
				e.printStackTrace();
			}
		}
		*/
		
	}
	
	private void first(){
		kontonummer = datevdaten.getFirstKonto();
		nummer.setText(""+kontonummer); 
		ktm.setKonto(kontonummer);
		ktm.fireTableDataChanged();
        }
	
	private void last(){
		kontonummer = datevdaten.getLastKonto();
		nummer.setText(""+kontonummer); 
		ktm.setKonto(kontonummer);
		ktm.fireTableDataChanged();
        }
        
        private void left(){
		//Kontoblatt vorheriges Kontoblatt
		kontonummer = datevdaten.getPreviousKontonummer();
		nummer.setText(""+kontonummer); 
		ktm.setKonto(kontonummer);
		ktm.fireTableDataChanged();
        }
	
	private void right(){
		//Kontoblatt nächstes Kontoblatt
		kontonummer = datevdaten.getNextKontonummer();
		nummer.setText(""+kontonummer); 
		ktm.setKonto(kontonummer);
		ktm.fireTableDataChanged();
        }

	
	private void testen(){
		//Mit den Einstellungen und Daten überprüfen, ob Daten für Aufgabe geeignet sind.
		//Zuerst aber Daten füttern.
		//Links
		datenL.setzeGUIDaten(datumLCB.getSelectedIndex()-1, sollLCB.getSelectedIndex()-1, habenLCB.getSelectedIndex()-1, stornoLCB.isSelected(), ignoreLCB.isSelected(), summandenSucheLCB.isSelected(), sucheOhneDatumLCB.isSelected());
		datenR.setzeGUIDaten(datumRCB.getSelectedIndex()-1, sollRCB.getSelectedIndex()-1, habenRCB.getSelectedIndex()-1, stornoRCB.isSelected(), ignoreRCB.isSelected(), summandenSucheRCB.isSelected(), sucheOhneDatumRCB.isSelected());
		ddmL.fireTableDataChanged();
		ddmR.fireTableDataChanged();
		TestData td = new TestData(this, f, datenL, datenR);
		td.start();
	}
	
	public void vergleichen(){
		datenL.setzeGUIDaten(datumLCB.getSelectedIndex()-1, sollLCB.getSelectedIndex()-1, habenLCB.getSelectedIndex()-1, stornoLCB.isSelected(), ignoreLCB.isSelected(), summandenSucheLCB.isSelected(), sucheOhneDatumLCB.isSelected());
		datenR.setzeGUIDaten(datumRCB.getSelectedIndex()-1, sollRCB.getSelectedIndex()-1, habenRCB.getSelectedIndex()-1, stornoRCB.isSelected(), ignoreRCB.isSelected(), summandenSucheRCB.isSelected(), sucheOhneDatumRCB.isSelected());
		maxAuswahl = abbruchRCB.getSelectedIndex()+1;
		ddmL.fireTableDataChanged();
		ddmR.fireTableDataChanged();
		VergleichData vd = new VergleichData(this, f, datenL, datenR, maxAuswahl);
		vd.start();
	}
	
	
	public String textkurz(String text, int position){
		String s = "";
		if(null != text){
			if(position > text.length())
				position = text.length();
			s = text.substring(0, position);
		}
		return s;
	}
	
	public void setMaxVergleich(boolean links, int max){
		if(max > 0){
			if(links){
				progressBarVergleich1.setStringPainted(true);
				statusMaxL = max;
				progressBarVergleich1.setMaximum(max);
			} else {
				progressBarVergleich2.setStringPainted(true);
				statusMaxR = max;
				progressBarVergleich2.setMaximum(max);
			}
		}
	}
	
	public void setMaxVergleich(int ladeWas, int max){
		if(max > 0){
			switch(ladeWas){
				case TABLINKS: 
				progressBarVergleich1.setStringPainted(true);
				statusMaxL = max;
				progressBarVergleich1.setMaximum(max);
				break;
				case TABRECHTS: 
				progressBarVergleich2.setStringPainted(true);
				statusMaxR = max;
				progressBarVergleich2.setMaximum(max);
				break;
				case TABSALDO:
				progressBarSaldo.setStringPainted(true);
				statusMaxSaldo = max;
				progressBarSaldo.setMaximum(max);
				break;
				default:
			}
		}
	}
	
		

	public void setStatusVergleich(int ladeWas, int status){
		if(status >= 0){
			switch(ladeWas){
				case TABLINKS: 
				progressBarVergleich1.setStringPainted(true);
				statusL = status;
				progressBarVergleich1.setValue(status);
				break;
				case TABRECHTS: 
				progressBarVergleich2.setStringPainted(true);
				statusR = status;
				progressBarVergleich2.setValue(status);
				break;
				case TABSALDO:
				progressBarSaldo.setStringPainted(true);
				statusSaldo = status;
				progressBarSaldo.setValue(status);
				break;
				case CSV:
				progressBarCSV.setStringPainted(true);
				statusCSV = status;
				progressBarCSV.setValue(status);
				default:
			}
		}
	}
	
	public void setStatusVergleich(boolean links, int status){
		if(status >= 0){
			if(links){
				progressBarVergleich1.setStringPainted(true);
				statusL = status;
				progressBarVergleich1.setValue(status);
			} else {
				progressBarVergleich2.setStringPainted(true);
				statusR = status;
				progressBarVergleich2.setValue(status);
			}
		}
	}

	
	public void progressIntermediate(int ladeWas, boolean on){
		switch(ladeWas){
			case TABLINKS: progressBarVergleich1.setIndeterminate(on);
				break;
			case TABRECHTS: progressBarVergleich2.setIndeterminate(on);
				break;
			case TABSALDO:	progressBarSaldo.setIndeterminate(on);
				break;
			default:
		}
		/*
		
		if(links)
			progressBarVergleich1.setIndeterminate(on);
		else
			progressBarVergleich2.setIndeterminate(on);
		*/
	}
	
	
	public void progressIntermediate(boolean links, boolean on){
		if(links)
			progressBarVergleich1.setIndeterminate(on);
		else
			progressBarVergleich2.setIndeterminate(on);
	}
	
	
	public void setDatevMax(int max){
		if(max > 0){
			datevProgressBar.setStringPainted(true);
			datevStatusMax = max;
			datevProgressBar.setMaximum(max);
		}
	}
	
	public void setDatevStatus(int status){
		int anzeige;
		if(status >= 0){
			datevProgressBar.setStringPainted(true);
			if(status > datevStatusMax)
				status = datevStatusMax;
			datevStatus = status;
			datevProgressBar.setValue(status);
		}
	}
	
	
	public void datevProgressIntermediate(boolean on){
		datevProgressBar.setIndeterminate(on);
	}
	
	
	public void setDifferenzen(int minDifferenz, int minposDifferenz, int maxDifferenz, int maxposDifferenz){
		if(minDifferenz < so.maxDifferenz)
			labelMinDifferenz.setText("min. Differenz: "+intToString(minDifferenz));
		else
			labelMinDifferenz.setText("min. Differenz: ");
		if(minposDifferenz < so.maxDifferenz)
			labelMinPosSumme.setText("min. pos. Summe: "+intToString(minposDifferenz));
		else
			labelMinPosSumme.setText("min. pos. Summe: ");
		if(maxDifferenz > 0)
			labelMaxDifferenz.setText("max. Differenz: "+intToString(maxDifferenz));
		else
			labelMaxDifferenz.setText("max. Differenz: ");
		if(maxposDifferenz > 0)
			labelMaxPosSumme.setText("max. pos. Summe: "+intToString(maxposDifferenz));
		else
			labelMaxPosSumme.setText("max. pos. Summe: ");
	}
	
	public void benchmark(){
		benchmarkStatus++;
		sortCB.setEnabled(false);
		sortButton.setEnabled(false);
		noDuploButton.setEnabled(false);
		erwartung = 0;
		erwartungMax = 0;

		switch (benchmarkStatus){
			case 22: suche.setText("19,6");
							/*
							Lösungen:
								30.246 Optimale: 139 oder 160
								3-8 Positionen
								0:00:00.018 mit Ident, 1 Thread optimale: 160
								0:00:08.145 ohne Ident, mit Vari, 8 Threads 8 Kerne
								0:00:14.554 ohne Ident, mit Vari, 4 Threads
							Alter Rechner:
								0:01:05.271 mit Vari, 1 Thread
								0:01:08.634
								0:17:19.279 ohne Variablenoptimierung
								0:00:20.177 mit Vari mit 4 Threads
			
							Neuer Rechner:
								0:11:20.645 ohne Vari,  1 Thread
								0:02:45.843 ohne Vari,  4 Threads
								0:01:50.050 ohne Vari,  8 Threads, 8 Kerne
								0:02:04.500 ohne Vari,  8 Threads, 8 Kerne
								0:01:37.407 ohne Vari, 16 Threads, 8 Kerne, Lüftung
								0:01:56.018 ohne Vari, 32 Threads, 8 Kerne, Lüftung
			
								0:00:36.369 mit Vari,  1 Thread
								0:00:10.899 mit Vari,  4 Threads (4 Kerne)
								0:00:06.646 mit Vari,  8 Threads (8 Kerne)
								0:00:06.209 mit Vari, 16 Threads (8 Kerne)
								0:00:07.100 mit Vari, 32 Threads (8 Kerne)
							
							*/
							abweich.setText("0,5");
							maxInput.setText("34");
							maxLos.setText("100000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							for(int i = 0;i<5;i++)
								eingabetable.getModel().setValueAt("2,0", i, 0);
							for(int i = 5;i<10;i++)
								eingabetable.getModel().setValueAt("3,0", i, 0);
							for(int i = 10;i<15;i++)
								eingabetable.getModel().setValueAt("4,0", i, 0);
							for(int i = 15;i<20;i++)
								eingabetable.getModel().setValueAt("5,0", i, 0);
							for(int i = 20;i<25;i++)
								eingabetable.getModel().setValueAt("6,0", i, 0);
							for(int i = 25;i<30;i++)
								eingabetable.getModel().setValueAt("7,0", i, 0);
							eingabetable.getModel().setValueAt("100,0", 30, 0);
							eingabetable.getModel().setValueAt("20,4", 31, 0);
							eingabetable.getModel().setValueAt("20,5", 32, 0);
							eingabetable.getModel().setValueAt("20,6", 33, 0);
							break;
			
			case 6: suche.setText("19,6");
							/*
							Lösung:   57/30246
							32 Kerne: 46/2069
							16 Kerne: 44/2969
							 8 Kerne: 44/4439
							 4 Kerne: 44/6714
							 2 Kerne: 57/75
							*/
							abweich.setText("0,5");
							maxInput.setText("34");
							maxLos.setText("100000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							for(int i = 0;i<6;i++)
								eingabetable.getModel().setValueAt(""+(i+2)+",0", i, 0);
							for(int i = 6;i<12;i++)
								eingabetable.getModel().setValueAt(""+(i-4)+",0", i, 0);
							for(int i = 12;i<18;i++)
								eingabetable.getModel().setValueAt(""+(i-10)+",0", i, 0);
							for(int i = 18;i<24;i++)
								eingabetable.getModel().setValueAt(""+(i-16)+",0", i, 0);
							for(int i = 24;i<30;i++)
								eingabetable.getModel().setValueAt(""+(i-22)+",0", i, 0);
							eingabetable.getModel().setValueAt("100,0", 30, 0);
							eingabetable.getModel().setValueAt("20,4", 31, 0);
							eingabetable.getModel().setValueAt("20,5", 32, 0);
							eingabetable.getModel().setValueAt("20,6", 33, 0);
							break;
			case 27: suche.setText("7");
							/*
							11 Lösungen ohne Optimierung
							3 Lösungen mit Identität
							Bei 16 Threads findet er nur 2
							*/
							abweich.setText("0");
							maxInput.setText("8");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("90,0", 0, 0);
							eingabetable.getModel().setValueAt("1,0", 1, 0);
							eingabetable.getModel().setValueAt("2,0", 2, 0);
							eingabetable.getModel().setValueAt("2,0", 3, 0);
							eingabetable.getModel().setValueAt("2,0", 4, 0);
							eingabetable.getModel().setValueAt("2,0", 5, 0);
							eingabetable.getModel().setValueAt("3,0", 6, 0);
							eingabetable.getModel().setValueAt("6,0", 7, 0);
							break;
			case 4: suche.setText("7");
							/*
							9 Lösungen ohne Optimierung
							4 Lösungen mit Identität
							*/
							abweich.setText("0");
							maxInput.setText("8");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("90,0", 0, 0);
							eingabetable.getModel().setValueAt("1,0", 1, 0);
							eingabetable.getModel().setValueAt("2,0", 2, 0);
							eingabetable.getModel().setValueAt("2,0", 3, 0);
							eingabetable.getModel().setValueAt("2,0", 4, 0);
							eingabetable.getModel().setValueAt("3,0", 5, 0);
							eingabetable.getModel().setValueAt("3,0", 6, 0);
							eingabetable.getModel().setValueAt("6,0", 7, 0);
							break;
			case 5: suche.setText("7");
							/*
							9 Lösungen ohne Optimierung
							4 Lösungen mit Identität
							*/
							abweich.setText("0");
							maxInput.setText("11");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("90,0", 0, 0);
							eingabetable.getModel().setValueAt("1,0", 1, 0);
							eingabetable.getModel().setValueAt("2,0", 2, 0);
							eingabetable.getModel().setValueAt("2,0", 3, 0);
							eingabetable.getModel().setValueAt("2,0", 4, 0);
							eingabetable.getModel().setValueAt("2,0", 5, 0);
							eingabetable.getModel().setValueAt("3,0", 6, 0);
							eingabetable.getModel().setValueAt("3,0", 7, 0);
							eingabetable.getModel().setValueAt("3,0", 8, 0);
							eingabetable.getModel().setValueAt("3,0", 9, 0);
							eingabetable.getModel().setValueAt("6,0", 10, 0);
							break;
			
			case 2: suche.setText("19");
							abweich.setText("2");
							maxInput.setText("28");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							for(int i = 0;i<28;i++)
								eingabetable.getModel().setValueAt(""+(i+10), i, 0);
							//for(int i = 0;i<28;i++)
							//	eingabetable.getModel().setValueAt(""+(i+5), i, 0);
							break;
			case 7: suche.setText("19");
							abweich.setText("2");
							maxInput.setText("28");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							for(int i = 0;i<20;i++)
								eingabetable.getModel().setValueAt(""+(i+10), i, 0);
							break;
			case 8: suche.setText("2");
							abweich.setText("2");
							maxInput.setText("40");
							maxLos.setText("1000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							for(int i = -20;i<20;i++)
								eingabetable.getModel().setValueAt(""+(i+10), i+20, 0);
							break;
			case 9: suche.setText("2");
							abweich.setText("2");
							maxInput.setText("40");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							for(int i = -10;i<20;i++)
								eingabetable.getModel().setValueAt(""+(i+5), i+10, 0);
							break;
			case 10: suche.setText("2478,25");
							abweich.setText("");
							maxInput.setText("42");
							maxLos.setText("1000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							//eingabetable.getModel().setValueAt(""+(i+5), i+10, 0);
							eingabetable.getModel().setValueAt("2367,44", 0, 0);
							eingabetable.getModel().setValueAt("1036,07", 1, 0);
							eingabetable.getModel().setValueAt("1106,41", 2, 0);
							eingabetable.getModel().setValueAt("2453,85", 3, 0);
							eingabetable.getModel().setValueAt("2520,68", 4, 0);
							eingabetable.getModel().setValueAt("1153,32", 5, 0);
							eingabetable.getModel().setValueAt("2520,68", 6, 0);
							eingabetable.getModel().setValueAt("1153,32", 7, 0);
							eingabetable.getModel().setValueAt("1153,32", 8, 0);
							eingabetable.getModel().setValueAt("2520,68", 9, 0);
							eingabetable.getModel().setValueAt("1360,03", 10, 0);
							eingabetable.getModel().setValueAt("-833,34", 11, 0);
							eingabetable.getModel().setValueAt("1360,03", 12, 0);
							eingabetable.getModel().setValueAt("1360,03", 13, 0);
							eingabetable.getModel().setValueAt("1360,03", 14, 0);
							eingabetable.getModel().setValueAt("1360,03", 15, 0);
							eingabetable.getModel().setValueAt("1385,22", 16, 0);
							eingabetable.getModel().setValueAt("1366,43", 17, 0);
							eingabetable.getModel().setValueAt("1366,43", 18, 0);
							eingabetable.getModel().setValueAt("1366,43", 19, 0);
							eingabetable.getModel().setValueAt("1366,43", 20, 0);
							eingabetable.getModel().setValueAt("1366,43", 21, 0);
							eingabetable.getModel().setValueAt("1366,43", 22, 0);
							eingabetable.getModel().setValueAt("1366,43", 23, 0);
							eingabetable.getModel().setValueAt("1366,43", 24, 0);
							eingabetable.getModel().setValueAt("1366,43", 25, 0);
							eingabetable.getModel().setValueAt("1366,43", 26, 0);
							eingabetable.getModel().setValueAt("1366,43", 27, 0);
							eingabetable.getModel().setValueAt("1366,43", 28, 0);
							eingabetable.getModel().setValueAt("1366,43", 29, 0);
							eingabetable.getModel().setValueAt("1371,10", 30, 0);
							eingabetable.getModel().setValueAt("1049,11", 31, 0);
							eingabetable.getModel().setValueAt("1010,51", 32, 0);
							eingabetable.getModel().setValueAt("1731,69", 33, 0);
							eingabetable.getModel().setValueAt("1371,10", 34, 0);
							eingabetable.getModel().setValueAt("1371,10", 35, 0);
							eingabetable.getModel().setValueAt("1371,10", 36, 0);
							eingabetable.getModel().setValueAt("1371,10", 37, 0);
							eingabetable.getModel().setValueAt("1371,10", 38, 0);
							eingabetable.getModel().setValueAt("1371,10", 39, 0);
							//eingabetable.getModel().setValueAt(""+), 0, 0);
						break;
			case 11: suche.setText("19,6");
							abweich.setText("0,5");
							maxInput.setText("28");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							for(int i = 0;i<20;i++)
								eingabetable.getModel().setValueAt("1,0"+(i), i, 0);
							break;
			case 12: suche.setText("136.574,11");
							abweich.setText("");
							maxInput.setText("35");
							maxLos.setText("1000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							//eingabetable.getModel().setValueAt(""+(i+5), i+10, 0);
							eingabetable.getModel().setValueAt("100.223,47", 0, 0);
							eingabetable.getModel().setValueAt("1.530,00", 1, 0);
							eingabetable.getModel().setValueAt("24.901,23", 2, 0);
							eingabetable.getModel().setValueAt("17.704,06", 3, 0);
							eingabetable.getModel().setValueAt("-6.022,43", 4, 0);
							eingabetable.getModel().setValueAt("-6.974,52", 5, 0);
							eingabetable.getModel().setValueAt("-9.295,14", 6, 0);
							eingabetable.getModel().setValueAt("-4.124,73", 7, 0);
							eingabetable.getModel().setValueAt("-4.982,04", 8, 0);
							eingabetable.getModel().setValueAt("-458,83", 9, 0);
							eingabetable.getModel().setValueAt("-12.069,58", 10, 0);
							eingabetable.getModel().setValueAt("-260,07", 11, 0);
							eingabetable.getModel().setValueAt("-257,04", 12, 0);
							eingabetable.getModel().setValueAt("-2.837,08", 13, 0);
							eingabetable.getModel().setValueAt("-3.121,70", 14, 0);
							eingabetable.getModel().setValueAt("-390,01", 15, 0);
							eingabetable.getModel().setValueAt("-458,78", 16, 0);
							eingabetable.getModel().setValueAt("-963,41", 17, 0);
							eingabetable.getModel().setValueAt("-2.538,20", 18, 0);
							eingabetable.getModel().setValueAt("-2.277,18", 19, 0);
							eingabetable.getModel().setValueAt("-613,55", 20, 0);
							eingabetable.getModel().setValueAt("-3.851,24", 21, 0);
							eingabetable.getModel().setValueAt("-6.449,30", 22, 0);
							eingabetable.getModel().setValueAt("619,34", 23, 0);
							eingabetable.getModel().setValueAt("-96,00", 24, 0);
							eingabetable.getModel().setValueAt("-4,50", 25, 0);
							eingabetable.getModel().setValueAt("1.090,94", 26, 0);
							eingabetable.getModel().setValueAt("-9.748,92", 27, 0);
							eingabetable.getModel().setValueAt("-11.588,80", 28, 0);
							eingabetable.getModel().setValueAt("-1.234,16", 29, 0);
							eingabetable.getModel().setValueAt("1.401,65", 30, 0);
							eingabetable.getModel().setValueAt("885,00", 31, 0);
							eingabetable.getModel().setValueAt("-1.147,57", 32, 0);
							eingabetable.getModel().setValueAt("3.681,63", 33, 0);
						break;
			case 13: suche.setText("36");
							abweich.setText("0");
							maxInput.setText("7");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							for(int i = 0;i<7;i++)
								eingabetable.getModel().setValueAt(""+(i+10), i, 0);
							break;
			case 14: suche.setText("-19,6");
							abweich.setText("0,5");
							maxInput.setText("28");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							for(int i = 0;i<20;i++)
								eingabetable.getModel().setValueAt("-1,0"+(i), i, 0);
							break;
			case 15: suche.setText("-1,12");
							abweich.setText("0,5");
							maxInput.setText("28");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							for(int i = 0;i<20;i++)
								eingabetable.getModel().setValueAt("-1,0"+(i), i, 0);
							break;
			case 16: suche.setText("272,29");
							/*
								250 Ergebnisse
								5-9
								0:07:58.708 8 Threads 8 Kerne
							*/
							abweich.setText("0");
							maxInput.setText("37");
							maxLos.setText("1000");
							threadsCB.setSelectedIndex(0);
							variOpti.setSelected(true);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("15,0", 0, 0);
							eingabetable.getModel().setValueAt("17,85", 1, 0);
							eingabetable.getModel().setValueAt("17,85", 2, 0);
							eingabetable.getModel().setValueAt("107,10", 3, 0);
							eingabetable.getModel().setValueAt("96,99", 4, 0);
							eingabetable.getModel().setValueAt("46", 5, 0);
							eingabetable.getModel().setValueAt("98", 6, 0);
							eingabetable.getModel().setValueAt("64", 7, 0);
							eingabetable.getModel().setValueAt("180", 8, 0);
							eingabetable.getModel().setValueAt("35,50", 9, 0);
							eingabetable.getModel().setValueAt("51", 10, 0);
							eingabetable.getModel().setValueAt("38,50", 11, 0);
							eingabetable.getModel().setValueAt("90", 12, 0);
							eingabetable.getModel().setValueAt("30", 13, 0);
							eingabetable.getModel().setValueAt("38", 14, 0);
							eingabetable.getModel().setValueAt("56", 15, 0);
							eingabetable.getModel().setValueAt("16,66", 16, 0);
							eingabetable.getModel().setValueAt("15", 17, 0);
							eingabetable.getModel().setValueAt("35,50", 18, 0);
							eingabetable.getModel().setValueAt("50", 19, 0);
							eingabetable.getModel().setValueAt("55,93", 20, 0);
							eingabetable.getModel().setValueAt("126", 21, 0);
							eingabetable.getModel().setValueAt("120", 22, 0);
							eingabetable.getModel().setValueAt("51", 23, 0);
							eingabetable.getModel().setValueAt("51", 24, 0);
							eingabetable.getModel().setValueAt("42", 25, 0);
							eingabetable.getModel().setValueAt("115,50", 26, 0);
							eingabetable.getModel().setValueAt("30,35", 27, 0);
							eingabetable.getModel().setValueAt("67", 28, 0);
							eingabetable.getModel().setValueAt("75", 29, 0);
							eingabetable.getModel().setValueAt("42,25", 30, 0);
							eingabetable.getModel().setValueAt("62,48", 31, 0);
							eingabetable.getModel().setValueAt("52", 32, 0);
							eingabetable.getModel().setValueAt("107,10", 33, 0);
							eingabetable.getModel().setValueAt("55", 34, 0);
							eingabetable.getModel().setValueAt("294,53", 35, 0);
							eingabetable.getModel().setValueAt("32,53", 36, 0);
							break;
			case 17: suche.setText("50,5");
							/*
								2 Ergebnisse
								2 Positionen
								
							*/
							abweich.setText("0");
							maxInput.setText("9");
							maxLos.setText("10");
							threadsCB.setSelectedIndex(0);
							variOpti.setSelected(true);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("15,0", 0, 0);
							eingabetable.getModel().setValueAt("17,85", 1, 0);
							eingabetable.getModel().setValueAt("17,85", 2, 0);
							eingabetable.getModel().setValueAt("16,66", 3, 0);
							eingabetable.getModel().setValueAt("30", 4, 0);
							eingabetable.getModel().setValueAt("35,50", 5, 0);
							eingabetable.getModel().setValueAt("35,50", 6, 0);
							eingabetable.getModel().setValueAt("38", 7, 0);
							eingabetable.getModel().setValueAt("38,50", 8, 0);
							break;
			case 18: suche.setText("7");
							/*
							9 Lösungen ohne Optimierung
							4 Lösungen mit Identität
							*/
							abweich.setText("0");
							maxInput.setText("7");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("1,0", 0, 0);
							eingabetable.getModel().setValueAt("2,0", 1, 0);
							eingabetable.getModel().setValueAt("2,0", 2, 0);
							eingabetable.getModel().setValueAt("2,0", 3, 0);
							eingabetable.getModel().setValueAt("3,0", 4, 0);
							eingabetable.getModel().setValueAt("3,0", 5, 0);
							eingabetable.getModel().setValueAt("6,0", 6, 0);
							break;
							
			
			case 19: suche.setText("36");
							abweich.setText("2");
							maxInput.setText("28");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							for(int i = 0;i<28;i++)
								eingabetable.getModel().setValueAt(""+(i+10), i, 0);
							break;
			case 20: suche.setText("415,36");
							/*
								Beste Lösung: 3 Positionen 440, -464,64, 440
								8 Threads 8 Kerne
							*/
							abweich.setText("0");
							maxInput.setText("72");
							maxLos.setText("1000");
							threadsCB.setSelectedIndex(0);
							variOpti.setSelected(true);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("-67,62", 0, 0);
							eingabetable.getModel().setValueAt("440", 1, 0);
							eingabetable.getModel().setValueAt("-450", 2, 0);
							eingabetable.getModel().setValueAt("440", 3, 0);
							eingabetable.getModel().setValueAt("-450", 4, 0);
							eingabetable.getModel().setValueAt("440", 5, 0);
							eingabetable.getModel().setValueAt("-450", 6, 0);
							eingabetable.getModel().setValueAt("440", 7, 0);
							eingabetable.getModel().setValueAt("-450", 8, 0);
							eingabetable.getModel().setValueAt("440", 9, 0);
							eingabetable.getModel().setValueAt("-450", 10, 0);
							eingabetable.getModel().setValueAt("440", 11, 0);
							eingabetable.getModel().setValueAt("-450", 12, 0);
							eingabetable.getModel().setValueAt("440", 13, 0);
							eingabetable.getModel().setValueAt("-450", 14, 0);
							eingabetable.getModel().setValueAt("440", 15, 0);
							eingabetable.getModel().setValueAt("-450", 16, 0);
							eingabetable.getModel().setValueAt("440", 17, 0);
							eingabetable.getModel().setValueAt("-450", 18, 0);
							eingabetable.getModel().setValueAt("440", 19, 0);
							eingabetable.getModel().setValueAt("-450", 20, 0);
							eingabetable.getModel().setValueAt("148,20", 21, 0);
							eingabetable.getModel().setValueAt("440", 22, 0);
							eingabetable.getModel().setValueAt("-450", 23, 0);
							eingabetable.getModel().setValueAt("440", 24, 0);
							eingabetable.getModel().setValueAt("-390,13", 25, 0);
							eingabetable.getModel().setValueAt("440", 26, 0);
							eingabetable.getModel().setValueAt("-395,13", 27, 0);
							eingabetable.getModel().setValueAt("440", 28, 0);
							eingabetable.getModel().setValueAt("-395,13", 29, 0);
							eingabetable.getModel().setValueAt("440", 30, 0);
							eingabetable.getModel().setValueAt("-395,13", 31, 0);
							eingabetable.getModel().setValueAt("440", 32, 0);
							eingabetable.getModel().setValueAt("-395,13", 33, 0);
							eingabetable.getModel().setValueAt("-299,35", 34, 0);
							eingabetable.getModel().setValueAt("440", 35, 0);
							eingabetable.getModel().setValueAt("-455", 36, 0);
							eingabetable.getModel().setValueAt("440", 37, 0);
							eingabetable.getModel().setValueAt("-455", 38, 0);
							eingabetable.getModel().setValueAt("440", 39, 0);
							eingabetable.getModel().setValueAt("-455", 40, 0);
							eingabetable.getModel().setValueAt("440", 41, 0);
							eingabetable.getModel().setValueAt("-455", 42, 0);
							eingabetable.getModel().setValueAt("440", 43, 0);
							eingabetable.getModel().setValueAt("160", 44, 0);
							eingabetable.getModel().setValueAt("-455", 45, 0);
							eingabetable.getModel().setValueAt("25,14", 46, 0);
							eingabetable.getModel().setValueAt("-455", 47, 0);
							eingabetable.getModel().setValueAt("440", 48, 0);
							eingabetable.getModel().setValueAt("455", 49, 0);
							eingabetable.getModel().setValueAt("-455", 50, 0);
							eingabetable.getModel().setValueAt("440", 51, 0);
							eingabetable.getModel().setValueAt("50", 52, 0);
							eingabetable.getModel().setValueAt("-455", 53, 0);
							eingabetable.getModel().setValueAt("440", 54, 0);
							eingabetable.getModel().setValueAt("-455", 55, 0);
							eingabetable.getModel().setValueAt("440", 56, 0);
							eingabetable.getModel().setValueAt("-455", 57, 0);
							eingabetable.getModel().setValueAt("440", 58, 0);
							eingabetable.getModel().setValueAt("-140,60", 59, 0);
							eingabetable.getModel().setValueAt("-455", 60, 0);
							eingabetable.getModel().setValueAt("440", 61, 0);
							eingabetable.getModel().setValueAt("154,88", 62, 0);
							eingabetable.getModel().setValueAt("-455", 63, 0);
							eingabetable.getModel().setValueAt("440", 64, 0);
							eingabetable.getModel().setValueAt("-464,64", 65, 0);
							eingabetable.getModel().setValueAt("440", 66, 0);
							eingabetable.getModel().setValueAt("39,64", 67, 0);
							eingabetable.getModel().setValueAt("-464,64", 68, 0);
							eingabetable.getModel().setValueAt("440", 69, 0);
							eingabetable.getModel().setValueAt("", 70, 0);
							eingabetable.getModel().setValueAt("", 71, 0);
							break;
			case 21: suche.setText("19");
							abweich.setText("2");
							maxInput.setText("28");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							neueSeite(false);
							for(int i = 0;i<28;i++)
								eingabetable.getModel().setValueAt(""+(i+10), i, 0);
							break;
			case 26: suche.setText("7");
							/*
							23 Lösungen ohne Optimierung
							7 Lösungen mit Identität
							Lösung 2 + 5 wird nicht gefunden, wenn 2 Threads spielen.
							Lösung 1 + 2 + 4 wird nicht gefunden, wenn 8 Threads spielen.
							*/
							abweich.setText("0");
							maxInput.setText("11");
							maxLos.setText("10000");
							threadsCB.setSelectedIndex(0);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("90,0", 0, 0);
							eingabetable.getModel().setValueAt("1,0", 1, 0);
							eingabetable.getModel().setValueAt("2,0", 2, 0);
							eingabetable.getModel().setValueAt("4,0", 3, 0);
							eingabetable.getModel().setValueAt("2,0", 4, 0);
							eingabetable.getModel().setValueAt("2,0", 5, 0);
							eingabetable.getModel().setValueAt("5,0", 6, 0);
							eingabetable.getModel().setValueAt("3,0", 7, 0);
							eingabetable.getModel().setValueAt("3,0", 8, 0);
							eingabetable.getModel().setValueAt("3,0", 9, 0);
							eingabetable.getModel().setValueAt("6,0", 10, 0);
							break;
			case 23: suche.setText("-1236,11");
							/*
								8 Threads 8 Kerne
							*/
							abweich.setText("0");
							maxInput.setText("82");
							maxLos.setText("1000");
							threadsCB.setSelectedIndex(0);
							variOpti.setSelected(true);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("812,75", 0, 0);
							eingabetable.getModel().setValueAt("-1433,25", 1, 0);
							eingabetable.getModel().setValueAt("-812,75", 2, 0);
							eingabetable.getModel().setValueAt("812,75", 3, 0);
							eingabetable.getModel().setValueAt("1433,25", 4, 0);
							eingabetable.getModel().setValueAt("-812,75", 5, 0);
							eingabetable.getModel().setValueAt("-812,75", 6, 0);
							eingabetable.getModel().setValueAt("-812,75", 7, 0);
							eingabetable.getModel().setValueAt("1400", 8, 0);
							eingabetable.getModel().setValueAt("900", 9, 0);
							eingabetable.getModel().setValueAt("-812,75", 10, 0);
							eingabetable.getModel().setValueAt("-812,75", 11, 0);
							eingabetable.getModel().setValueAt("500", 12, 0);
							eingabetable.getModel().setValueAt("400", 13, 0);
							eingabetable.getModel().setValueAt("650", 14, 0);
							eingabetable.getModel().setValueAt("-812,75", 15, 0);
							eingabetable.getModel().setValueAt("-812,75", 16, 0);
							eingabetable.getModel().setValueAt("800", 17, 0);
							eingabetable.getModel().setValueAt("850", 18, 0);
							eingabetable.getModel().setValueAt("-812,75", 19, 0);
							eingabetable.getModel().setValueAt("910", 20, 0);
							eingabetable.getModel().setValueAt("-812,75", 21, 0);
							eingabetable.getModel().setValueAt("900", 22, 0);
							eingabetable.getModel().setValueAt("-812,75", 23, 0);
							eingabetable.getModel().setValueAt("-812,75", 24, 0);
							eingabetable.getModel().setValueAt("820", 25, 0);
							eingabetable.getModel().setValueAt("730", 26, 0);
							eingabetable.getModel().setValueAt("-812,75", 27, 0);
							eingabetable.getModel().setValueAt("-812,75", 28, 0);
							eingabetable.getModel().setValueAt("450", 29, 0);
							eingabetable.getModel().setValueAt("-812,75", 30, 0);
							eingabetable.getModel().setValueAt("840", 31, 0);
							eingabetable.getModel().setValueAt("200", 32, 0);
							eingabetable.getModel().setValueAt("970", 33, 0);
							eingabetable.getModel().setValueAt("-812,75", 34, 0);
							eingabetable.getModel().setValueAt("-812,75", 35, 0);
							eingabetable.getModel().setValueAt("176,02", 36, 0);
							eingabetable.getModel().setValueAt("-812,75", 37, 0);
							eingabetable.getModel().setValueAt("600", 38, 0);
							eingabetable.getModel().setValueAt("-812,75", 39, 0);
							eingabetable.getModel().setValueAt("1300", 40, 0);
							eingabetable.getModel().setValueAt("-812,75", 41, 0);
							eingabetable.getModel().setValueAt("1137,11", 42, 0);
							eingabetable.getModel().setValueAt("-812,75", 43, 0);
							eingabetable.getModel().setValueAt("570", 44, 0);
							eingabetable.getModel().setValueAt("-812,75", 45, 0);
							eingabetable.getModel().setValueAt("-812,75", 46, 0);
							eingabetable.getModel().setValueAt("1541,26", 47, 0);
							eingabetable.getModel().setValueAt("-812,75", 48, 0);
							break;
			case 24: suche.setText("3");
							/*
							3 Lösungen ohne Optimierung
							2 Lösungen mit Identität
							*/
							abweich.setText("0");
							maxInput.setText("5");
							maxLos.setText("1000");
							threadsCB.setSelectedIndex(0);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("1,0", 0, 0);
							eingabetable.getModel().setValueAt("2,0", 1, 0);
							eingabetable.getModel().setValueAt("3,0", 2, 0);
							eingabetable.getModel().setValueAt("2,0", 3, 0);
							break;
			case 25: suche.setText("683,66");
							/*
								8 Threads 8 Kerne
							*/
							abweich.setText("0");
							maxInput.setText("30");
							maxLos.setText("100000");
							threadsCB.setSelectedIndex(0);
							variOpti.setSelected(true);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("28", 7, 0);
							eingabetable.getModel().setValueAt("28", 8, 0);
							eingabetable.getModel().setValueAt("28", 9, 0);
							eingabetable.getModel().setValueAt("28", 10, 0);
							eingabetable.getModel().setValueAt("28", 11, 0);
							eingabetable.getModel().setValueAt("28", 12, 0);
							eingabetable.getModel().setValueAt("28", 13, 0);
							eingabetable.getModel().setValueAt("28", 14, 0);
							eingabetable.getModel().setValueAt("28", 15, 0);
							eingabetable.getModel().setValueAt("28", 16, 0);
							eingabetable.getModel().setValueAt("28", 17, 0);
							eingabetable.getModel().setValueAt("28", 18, 0);
							eingabetable.getModel().setValueAt("28", 19, 0);
							eingabetable.getModel().setValueAt("28", 20, 0);
							eingabetable.getModel().setValueAt("28", 21, 0);
							eingabetable.getModel().setValueAt("128,95", 1, 0);
							eingabetable.getModel().setValueAt("128,95", 2, 0);
							eingabetable.getModel().setValueAt("128,95", 6, 0);
							eingabetable.getModel().setValueAt("128,95", 4, 0);
							eingabetable.getModel().setValueAt("128,95", 5, 0);
							eingabetable.getModel().setValueAt("128,95", 	28, 0);
							eingabetable.getModel().setValueAt("-1,17", 	3, 0);
							eingabetable.getModel().setValueAt("106,10", 	22, 0);
							eingabetable.getModel().setValueAt("18,71", 	23, 0);
							eingabetable.getModel().setValueAt("-504,73", 	24, 0);
							eingabetable.getModel().setValueAt("-420", 	25, 0);
							eingabetable.getModel().setValueAt("-420", 	26, 0);
							eingabetable.getModel().setValueAt("448", 	27, 0);
							eingabetable.getModel().setValueAt("448", 	0, 0);
							break;
			case 01: suche.setText("12");
							/*
								8 von 20
							*/
							abweich.setText("0");
							maxInput.setText("12");
							maxLos.setText("1000");
							threadsCB.setSelectedIndex(0);
							variOpti.setSelected(true);
							identOpti.setSelected(true);
							neueSeite(false);
							erwartung = 6;
							erwartungMax = 20;
							eingabetable.getModel().setValueAt("7", 0, 0);
							eingabetable.getModel().setValueAt("5", 1, 0);
							eingabetable.getModel().setValueAt("4", 2, 0);
							eingabetable.getModel().setValueAt("3", 3, 0);
							eingabetable.getModel().setValueAt("2", 4, 0);
							eingabetable.getModel().setValueAt("0", 5, 0);
							eingabetable.getModel().setValueAt("0", 6, 0);
							eingabetable.getModel().setValueAt("-2", 7, 0);
							eingabetable.getModel().setValueAt("-2", 8, 0);
							eingabetable.getModel().setValueAt("-3", 9, 0);
							eingabetable.getModel().setValueAt("-4", 10, 0);
							eingabetable.getModel().setValueAt("-5", 11, 0);
							break;
			case 03: suche.setText("15");
							/*
								6 gute Lösungen
								Mit negativ nur 2 Lösungen.
								8 Threads 8 Kerne
							*/
							abweich.setText("0");
							maxInput.setText("33");
							maxLos.setText("1000");
							threadsCB.setSelectedIndex(0);
							variOpti.setSelected(true);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("20", 0, 0);
							eingabetable.getModel().setValueAt("19", 1, 0);
							eingabetable.getModel().setValueAt("18", 2, 0);
							eingabetable.getModel().setValueAt("17", 3, 0);
							eingabetable.getModel().setValueAt("16", 4, 0);
							eingabetable.getModel().setValueAt("2", 5, 0);
							eingabetable.getModel().setValueAt("2", 6, 0);
							eingabetable.getModel().setValueAt("2", 7, 0);
							eingabetable.getModel().setValueAt("2", 8, 0);
							eingabetable.getModel().setValueAt("2", 9, 0);
							eingabetable.getModel().setValueAt("2", 10, 0);
							eingabetable.getModel().setValueAt("2", 11, 0);
							eingabetable.getModel().setValueAt("2", 12, 0);
							eingabetable.getModel().setValueAt("2", 13, 0);
							eingabetable.getModel().setValueAt("2", 14, 0);

							eingabetable.getModel().setValueAt("5", 15, 0);
							eingabetable.getModel().setValueAt("6", 16, 0);
							eingabetable.getModel().setValueAt("7", 17, 0);
							eingabetable.getModel().setValueAt("8", 18, 0);
							eingabetable.getModel().setValueAt("9", 19, 0);
							eingabetable.getModel().setValueAt("10", 20, 0);

							eingabetable.getModel().setValueAt("15", 21, 0);
							eingabetable.getModel().setValueAt("14", 22, 0);
							eingabetable.getModel().setValueAt("13", 23, 0);
							eingabetable.getModel().setValueAt("12", 24, 0);
							eingabetable.getModel().setValueAt("11", 25, 0);
							eingabetable.getModel().setValueAt("21", 26, 0);

							eingabetable.getModel().setValueAt("21", 27, 0);
							eingabetable.getModel().setValueAt("22", 28, 0);
							eingabetable.getModel().setValueAt("23", 29, 0);
							eingabetable.getModel().setValueAt("23", 30, 0);
							eingabetable.getModel().setValueAt("24", 31, 0);
							eingabetable.getModel().setValueAt("25", 32, 0);
							break;
			case 99: suche.setText("0");
							/*
								8 Threads 8 Kerne
							*/
							abweich.setText("0");
							maxInput.setText("82");
							maxLos.setText("1000");
							threadsCB.setSelectedIndex(0);
							variOpti.setSelected(true);
							identOpti.setSelected(true);
							neueSeite(false);
							eingabetable.getModel().setValueAt("", 0, 0);
							eingabetable.getModel().setValueAt("", 1, 0);
							eingabetable.getModel().setValueAt("", 2, 0);
							eingabetable.getModel().setValueAt("", 3, 0);
							eingabetable.getModel().setValueAt("", 4, 0);
							eingabetable.getModel().setValueAt("", 5, 0);
							eingabetable.getModel().setValueAt("", 6, 0);
							eingabetable.getModel().setValueAt("", 7, 0);
							eingabetable.getModel().setValueAt("", 8, 0);
							eingabetable.getModel().setValueAt("", 9, 0);
							eingabetable.getModel().setValueAt("", 10, 0);
							eingabetable.getModel().setValueAt("", 11, 0);
							eingabetable.getModel().setValueAt("", 12, 0);
							eingabetable.getModel().setValueAt("", 13, 0);
							eingabetable.getModel().setValueAt("", 14, 0);
							eingabetable.getModel().setValueAt("", 15, 0);
							eingabetable.getModel().setValueAt("", 16, 0);
							eingabetable.getModel().setValueAt("", 17, 0);
							eingabetable.getModel().setValueAt("", 18, 0);
							eingabetable.getModel().setValueAt("", 19, 0);
							eingabetable.getModel().setValueAt("", 20, 0);
							eingabetable.getModel().setValueAt("", 21, 0);
							eingabetable.getModel().setValueAt("", 22, 0);
							eingabetable.getModel().setValueAt("", 23, 0);
							eingabetable.getModel().setValueAt("", 24, 0);
							eingabetable.getModel().setValueAt("", 25, 0);
							eingabetable.getModel().setValueAt("", 26, 0);
							eingabetable.getModel().setValueAt("", 27, 0);
							eingabetable.getModel().setValueAt("", 28, 0);
							eingabetable.getModel().setValueAt("", 29, 0);
							eingabetable.getModel().setValueAt("", 30, 0);
							eingabetable.getModel().setValueAt("", 31, 0);
							eingabetable.getModel().setValueAt("", 32, 0);
							eingabetable.getModel().setValueAt("", 33, 0);
							eingabetable.getModel().setValueAt("", 34, 0);
							eingabetable.getModel().setValueAt("", 35, 0);
							eingabetable.getModel().setValueAt("", 36, 0);
							eingabetable.getModel().setValueAt("", 37, 0);
							eingabetable.getModel().setValueAt("", 38, 0);
							eingabetable.getModel().setValueAt("", 39, 0);
							eingabetable.getModel().setValueAt("", 40, 0);
							eingabetable.getModel().setValueAt("", 41, 0);
							eingabetable.getModel().setValueAt("", 42, 0);
							eingabetable.getModel().setValueAt("", 43, 0);
							eingabetable.getModel().setValueAt("", 44, 0);
							eingabetable.getModel().setValueAt("", 45, 0);
							eingabetable.getModel().setValueAt("", 46, 0);
							eingabetable.getModel().setValueAt("", 47, 0);
							eingabetable.getModel().setValueAt("", 48, 0);
							eingabetable.getModel().setValueAt("", 49, 0);
							eingabetable.getModel().setValueAt("", 50, 0);
							eingabetable.getModel().setValueAt("", 51, 0);
							eingabetable.getModel().setValueAt("", 52, 0);
							eingabetable.getModel().setValueAt("", 53, 0);
							eingabetable.getModel().setValueAt("", 54, 0);
							eingabetable.getModel().setValueAt("", 55, 0);
							eingabetable.getModel().setValueAt("", 56, 0);
							eingabetable.getModel().setValueAt("", 57, 0);
							eingabetable.getModel().setValueAt("", 58, 0);
							eingabetable.getModel().setValueAt("", 59, 0);
							eingabetable.getModel().setValueAt("", 60, 0);
							eingabetable.getModel().setValueAt("", 61, 0);
							eingabetable.getModel().setValueAt("", 62, 0);
							eingabetable.getModel().setValueAt("", 63, 0);
							eingabetable.getModel().setValueAt("", 64, 0);
							eingabetable.getModel().setValueAt("", 65, 0);
							eingabetable.getModel().setValueAt("", 66, 0);
							eingabetable.getModel().setValueAt("", 67, 0);
							eingabetable.getModel().setValueAt("", 68, 0);
							eingabetable.getModel().setValueAt("", 69, 0);
							eingabetable.getModel().setValueAt("", 70, 0);
							eingabetable.getModel().setValueAt("", 71, 0);
							eingabetable.getModel().setValueAt("", 72, 0);
							eingabetable.getModel().setValueAt("", 73, 0);
							eingabetable.getModel().setValueAt("", 74, 0);
							eingabetable.getModel().setValueAt("", 75, 0);
							eingabetable.getModel().setValueAt("", 76, 0);
							eingabetable.getModel().setValueAt("", 77, 0);
							eingabetable.getModel().setValueAt("", 78, 0);
							eingabetable.getModel().setValueAt("", 79, 0);
							eingabetable.getModel().setValueAt("", 80, 0);
							break;
			default: benchmarkStatus = 0;
		}
		labelerwartungen.setText("Erwartung: "+erwartung+"/"+erwartungMax);
							
			//

		//eingabetable.getModel().setValueAt("-1,00", 0, 0);
		/*
		
		eingabetable.getModel().setValueAt("10", 0, 0);
		eingabetable.getModel().setValueAt("5,", 1, 0);
		eingabetable.getModel().setValueAt("-5,", 2, 0);
		eingabetable.getModel().setValueAt("-10,", 3, 0);
		eingabetable.getModel().setValueAt("-20,", 4, 0);
		eingabetable.getModel().setValueAt("-30,", 5, 0);
		eingabetable.getModel().setValueAt("-40,", 6, 0);
		*/
	}
	
	public void hilfe(){
		JOptionPane.showMessageDialog(null, "Buchhalter Buddy \nvon\nSebastian Müller\n\nhttp://sebamueller.de/programme/buchhalter\n\nVersion: "+VERSION);
	}
	
	public int stringToInt(String s){
		/*
		int i = 0;
		String text = s.trim();
		text = punktDurchStrich(text);
		
		if(0 == text.length())
			i = 0;
		else
			try{
				i = (int) (Float.parseFloat(text)*genauigkeit);//Vorsicht Rundungsdifferenzen!!!
				System.out.println(StringToInt.String2Int(s, genauigkeit));
			} catch (NumberFormatException nfe){
				i = 0;
			}
		
		return i;
		*/
		s = s.trim();
		int ergebnis = 0;
		boolean vorKomma = true;
		boolean negativ = false;
		char[] text = s.toCharArray();
		int nachkomma = genauigkeit;
		//System.out.print("Ergebnis vor Komma: ");
		for(int i=0; i < text.length;i++){
			if(text[i] == '-') {
				negativ = true;
			} else if (text[i] == '.') {//1.000 enderpunkte
			} else if(text[i] == ','){//| text[i] == '.') {
				if(vorKomma){
					vorKomma = false; 
					ergebnis = ergebnis*genauigkeit; 
				}
				//System.out.println("Ergebnis nach Komma: ");
			} else if(vorKomma){
				ergebnis = ergebnis * 10 + Character.digit( text[i], 10 );
				//System.out.println(""+ergebnis+" "+Character.digit( text[i], 10 ));
			} else {
				nachkomma = nachkomma / 10;
				ergebnis = ergebnis + Character.digit( text[i], 10 )*nachkomma;
				//System.out.println(""+ergebnis+" "+Character.digit( text[i], 10 ));
			}
		}
		if (negativ) {ergebnis = -ergebnis;}
		if(vorKomma) {vorKomma = false; ergebnis = ergebnis*genauigkeit;}
		//System.out.println("Ergebnis: "+ergebnis);
		return ergebnis;
	}
	
	public void pruefeDaten(){
		statustext.setText("");
		sucheInt = 0;
		abweichInt = 0;
		label9.setText("Vielfaches von 9: nein");
		
		//System.out.println("PD: maxEingabe: "+maxEingabe);
		String sucheText = suche.getText();
		sucheText = sucheText.trim();
		//sucheText = punktDurchStrich(sucheText);
		
		String abweichText = abweich.getText();
		abweichText = abweichText.trim();
		//abweichText = punktDurchStrich(abweichText);
		
		String maxEingabeText = maxInput.getText();
		maxEingabeText = maxEingabeText.trim();
		
		String maxLosText = maxLos.getText();
		maxLosText = maxLosText.trim();
		
		
		if(0 == sucheText.length())
			sucheInt = 0;
		else
			try{
				//sucheInt = (int) (Float.parseFloat(sucheText)*genauigkeit);//Hier Rundungsdifferenz!!!
				sucheInt = stringToInt(sucheText);
				statustext.setText(".");
			} catch (NumberFormatException nfe){
				sucheInt = 0;
				statustext.setText("Suche: Keine Zahl!-"+sucheText+"-");
			}
		
		if(0 == abweichText.length())
			abweichInt = 0;
		else
			try{
				//abweichInt = (int) (Float.parseFloat(abweichText)*genauigkeit);
				abweichInt = stringToInt(abweichText);
			} catch (NumberFormatException nfe){
				abweichInt = 0;
				statustext.setText("Abweichung: Keine Zahl!");
			}
		if(0 == sucheInt % 9)
			label9.setText("Vielfaches von 9: ja");
		
		float genauigkeitF = genauigkeit;
		float halbe = (sucheInt /2)/genauigkeitF;
		labelHalbe.setText("Halbe: "+intToString((int)(halbe*genauigkeit)));
		labelquer.setText("Quersumme: "+quersumme(sucheInt));
		threadindex = threadsCB.getSelectedIndex();
		System.out.println("Threadindex: "+threadindex);
		threads = (int)Math.pow( 2,threadindex);//Später, jetzt brauchen wir noch die genaue Auswahl.
		//threads = threadindex;
		System.out.println("Threads: "+threads);
		
		int genauindex = genauCB.getSelectedIndex();
		System.out.println("Genauindex: "+genauindex);
		genauigkeit = (int)Math.pow( 10,genauindex);
		System.out.println("Genauigkeit: "+genauigkeit);
		
		if(0 == maxEingabeText.length())
			maxEingabe = 30;
		else
			try{
				maxEingabe = (Integer.parseInt(maxEingabeText));
			} catch (NumberFormatException nfe){
				maxEingabe = 30;
				statustext.setText("maximale Eingabe: Keine Zahl!");
			}
		/*
		if(null == datenLeer)
			datenLeer = new Daten();
		if(maxEingabe > datenLeer.getMaxData())
			maxEingabe = datenLeer.getMaxData();*/
			
		if(0 == maxLosText.length())
			maxFinder = 1000;
		else
			try{
				maxFinder = (Integer.parseInt(maxLosText));
			} catch (NumberFormatException nfe){
				maxFinder = 1000;
				statustext.setText("maximale Lösungen: Keine Zahl!");
			}
			
		threado = threadOpti.isSelected();
		vario = variOpti.isSelected();//Threadoptimierung und Variablenoptimierung
		sortExit = sortExitCB.isSelected();
		identi = identOpti.isSelected();
		negativ = negativCB.isSelected();
		//System.out.println("PDE: maxEingabe: "+maxEingabe);
	}
	
	public void holeTabelle(){
		int maxReihen = 0;
		int eingabe;
		int max = maxEingabe;
		//System.out.println("HT: maxEingabe: "+maxEingabe);
		
		if(tabellenstatus){
			//Nach einem Lauf
			if(max > eingabeDaten.length)
			max = eingabeDaten.length;
			SummandenTableModel stm =(SummandenTableModel)eingabetable.getModel();
			maxReihen = stm.getRowCount();
			if(maxReihen > eingabeDaten.length){
				eingabeDaten = new int[maxReihen];
				maxEingabe = maxReihen;
				max = maxEingabe;
				//maxReihen = max;
			}
			for(int row=0;row<maxReihen;row++){
				if(null!= stm.getValueAt(row,0)){
					//System.out.println(deft.getValueAt(row,0));
					eingabe = stringToInt((String)stm.getValueAt(row,0));
					if(row < maxEingabe)
						eingabeDaten[row] = eingabe;
					else
						maxEingabe = row;
					//System.out.println(eingabe);
				}
			}
		} else {
			//Vor einem Lauf, z.B. wenn jemand auf NEU gedrück hat.
			DefaultTableModel deft=(DefaultTableModel)eingabetable.getModel();
			maxReihen = deft.getRowCount();
			//System.out.println("maxReihen > max : "+maxReihen+" > "+max);
			if(maxReihen > eingabeDaten.length){
				eingabeDaten = new int[maxReihen];
				maxEingabe = maxReihen;
				//maxReihen = max;
				max = maxEingabe;
			}
			for(int row=0;row<maxReihen;row++){
				if(null!= deft.getValueAt(row,0)){
					//System.out.println(deft.getValueAt(row,0));
					eingabe = stringToInt((String)deft.getValueAt(row,0));//Warnung: Warum funktioniert das auch bei FLOAT???
					//System.out.println("row < max : "+row+" < "+max);
					//System.out.println("eingabeDaten.length: "+eingabeDaten.length);
					if(row < max)
						eingabeDaten[row] = eingabe;
					else
						maxEingabe = row;
					//System.out.println(eingabe);
				}

			}
		}
		//System.out.println("HTE: maxEingabe: "+maxEingabe);
	}
	
	public void setBeendet(){
		neuButton.setEnabled(true);
		summeFindenbt.setEnabled(false);
		openButton.setEnabled(true);
		saveButton.setEnabled(true);
		stopButton.setEnabled(false);
		benchmarkButton.setEnabled(true);
		sortCB.setEnabled(true);
		sortButton.setEnabled(true);
		noDuploButton.setEnabled(true);
		//Lösungen kopieren
		JOptionPane.showMessageDialog(f, "Der Suchlauf ist beendet.", "Suchlauf beendet.", JOptionPane.INFORMATION_MESSAGE);
		
		//so = null;nachdem wir die Lösungen kopiert haben
		//eingabetable.fireTableDataChanged();
	}
	
	public void wirdBeendet(){
		stopButton.setEnabled(false);
	}
	
	public int[] getEingabeDaten(){
		int max = maxEingabe;
		if(max > eingabeDaten.length)
			max = eingabeDaten.length;
		int[] giveAway = new int[max];
		for(int i= 0; i< max; i++)
			giveAway[i] = eingabeDaten[i];
		return giveAway;
	}
	
	public void holeDaten(){
		pruefeDaten();
		
		labelloesung.setText("Lösungen: ");
		labelgut.setText("sehr gut: ");
		
		labelminLos.setText("Minimal. Positionen: 0");
		labelmaxLos.setText("Maximal. Positionen: 0");
		labelMinDifferenz.setText("min. Differenz: ");
		labelMaxDifferenz.setText("max. Differenz: ");
		labelMinPosSumme.setText("min. pos. Summe: ");
		labelMaxPosSumme.setText("max. pos. Summe: ");

		labelSummeDaten.setText("Summe Daten:");
		labelSummanden.setText("Summanden:");
		labelmaxSuch.setText("Kandidaten:");

		System.out.println("Suche: "+sucheInt);
		System.out.println("Abweichung: "+abweichInt);
		
		holeTabelle();
		
		int max = maxEingabe;
		if(max > eingabeDaten.length)
			max = eingabeDaten.length;
		
		System.out.println("BH: "+maxEingabe+" : "+eingabeDaten.length+" = "+max);
		daten = new Daten(sucheInt, abweichInt, max, vario, identi, sortExit);
		for(int i = 0; i < max;i++)
			daten.setEingabe(i,eingabeDaten[i]);
		if(daten.maxSuch() > 0){
			progressBar.setValue(100);
			progressBar.setStringPainted(true);
			labelZeit.setText("Zeit:");
			labelProg.setText("Bis:  ");//Prognose
			so = new SuchOrganisator(this, threads, daten, threado, vario, identi, negativ);
			so.setMaxFinder(maxFinder);
			System.out.println("maxDaten: "+ daten.getMaxData());
			System.out.println("maxSuch: "+ daten.maxSuch());
			so.start();
			labelloesung.setText("Lösungen: ");
		
			openButton.setEnabled(false);
			saveButton.setEnabled(false);
			neuButton.setEnabled(false);
			summeFindenbt.setEnabled(false);
			stopButton.setEnabled(true);
			benchmarkButton.setEnabled(false);
			tabellenstatus = true;
		} else {
			JOptionPane.showMessageDialog(f, "Es wurden keine passenden Kandidaten gefunden!\n\nSumme der Daten:\n"+intToString(daten.getDatenSumme()), "Keine Kandidaten", JOptionPane.WARNING_MESSAGE);
		}
		labelSummeDaten.setText("Summe Daten: "+intToString(daten.getDatenSumme()));
		labelMaxDuplikate.setText("max Duplikate: "+daten.getMaxDuplikate());
		labelMaxExit.setText("max Sort Exit: "+daten.getMaxExit());
		labelmaxSuch.setText("Kandidaten: "+daten.maxSuch());
		labelSummanden.setText("Summanden: "+daten.getMaxKandidaten());
	}
	
	public String punktDurchStrich(String s){
		//Ersetze in einem String alle Kommas in Punkte
		//return s.replace(",", "."); 
		//Wird sonst nur zu einem Bug. Ab jetzt nur noch deutsches Format unterstützt.
		return s;
	}
	
	public void arrayReset(){
		for(int i = 0;i<maxEingabe;i++)
			eingabeDaten[i] = 0;
	}
	
	public void setStatusMax(int i){
		if(i > 0)
			statusMax = i;
		progressBar.setMaximum(statusMax);
	}
	
	public void setStatus(int i){
		if(i <= statusMax)
			progressBar.setValue(i);
	}
	
	public void setLoesungen(int l){
		labelloesung.setText("Lösungen: "+l);
		loesungen = l;
	}
	
	public void setSehrGut(int l){
		labelgut.setText("sehr gut: "+l);
		guteLoesungen = l;
	}
	
	public void setLoesungen(int einmalig, int l){
		if(einmalig >= 0){
			labelloesung.setText("Lösungen: "+einmalig+"/ "+l);
			loesungen = l;
		}
	}
	
	public void setSehrGut(int einmalig, int l){
		if(einmalig >= 0){
			labelgut.setText("sehr gut: "+einmalig+"/ "+l);
			guteLoesungen = l;
		}
	}
	
	public void setPos(int min, int max){
		labelminLos.setText("Minimal. Positionen: "+min);
		labelmaxLos.setText("Maximal. Positionen: "+max);
	}
	
	public int getGenauigkeit(){
		return genauigkeit;
	}
	
	public void setTableModel(SummandenTableModel stm, MySFCellRenderer mSFcr){
		eingabetable = new JTable(stm);
		eingabetable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		//mSFcr
		eingabetable.setDefaultRenderer(Object.class, mSFcr);
		//((JLabel)eingabetable.getDefaultRenderer(String.class)).setHorizontalAlignment (JLabel.RIGHT);
		try{
			for(int i = 0;i < loesungen+1; i++){
				eingabetable.getColumnModel().getColumn(i).setPreferredWidth(80);
				//eingabetable.getColumnModel().getColumn(i).getCellRenderer().setHorizontalAlignment(SwingConstants.RIGHT);
			}
		} catch (ArrayIndexOutOfBoundsException exception) {
			System.out.println("Ups: Swing ist nicht Threadsicher");
		}

		//Alte Werte noch eintragen
		/*
		String text = "";
		for(int i = 0;i<maxEingabe;i++){
			if(0 != eingabeDaten[i]){
				text = ""+eingabeDaten[i]/genauigkeit;
				if((eingabeDaten[i] % genauigkeit) != 0)
					text = text + ","+ (eingabeDaten[i] % genauigkeit);
				else
					text = text + ",00"; 
			} else
				text = "";
			eingabetable.getModel().setValueAt(text, i, 0);
		}*/
		
		JPanel ausgabe = new JPanel();
		
		ausgabe.setLayout( new java.awt.BorderLayout() );
		jsp.setRightComponent(ausgabe);
		JScrollPane scrollPane = new JScrollPane(eingabetable);
		eingabetable.setFillsViewportHeight(true);//Hier???
		ausgabe.add(scrollPane, BorderLayout.CENTER);
		
		scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		eingabetable.setColumnSelectionAllowed(true);
		eingabetable.setRowSelectionAllowed(false);
				
		FixedColumnTable fct = new FixedColumnTable(1, scrollPane);
		jsp.setDividerLocation(250);
	}
	
	public String timeString(boolean zeit, long dauer){
		String ausgabe = "";
		stunden = (int)(dauer/3600000);
		minuten = (int)(dauer/60000 - stunden*60);
		sekunden = (int)((dauer/1000) % 60);
		int milli = (int)(dauer % 1000);
		
		if(minuten < 10)
			tminuten = "0"+minuten;
		else
			tminuten = ""+minuten;
		
		if(sekunden < 10)
			tsekunden = "0"+sekunden;
		else
			tsekunden = ""+sekunden;
			
		tmilli = "";
		//if(milli < 1000)tmilli = "0";
		if(milli < 100) tmilli = tmilli + "0";
		if(milli < 10)  tmilli = tmilli + "0";
		tmilli = tmilli + milli;
		
		//System.out.println("Es gibt bis "+ n +" genau "+ anzahl + " Primzahlen!");
		//System.out.println("Minuten: "+ minuten);
		//System.out.println("Sekunden: "+ sekunden);
		//System.out.println("Millisekunden: "+ milli);
		//System.out.println("Berechnungszeit: " + dauer + " Millisekunden = " + stunden + ":" + tminuten + ":" + tsekunden + "."+tmilli);
		if(zeit)
			ausgabe = "Zeit:" + stunden + ":" + tminuten + ":" + tsekunden + "."+tmilli;
		else
			ausgabe = "Bis: " + stunden + ":" + tminuten + ":" + tsekunden + "."+tmilli;
		return ausgabe;
	}
	
	public void setTime(boolean suche, long dauer){
		if(suche)
			labelZeit.setText(timeString(true, dauer));
		else
			labelZeitVergleich.setText(timeString(true, dauer));
	}
	
	public void setProgTime(long dauer){
		labelProg.setText(timeString(false, dauer));
	}
	
	public void setProgTimeString(int dauer){
		String text = "Aha";
		switch (dauer){
			case 30: 
			case 31:
			case 32:
			case 33:
			case 34: text = "Bis: Minuten";
				break;
			case 35:
			case 36:
			case 37: text = "Bis: eine Stunde";
				break;
			case 38:
			case 39: text = "Bis: Stunden";
				break;
			case 40:
			case 41: text = "Bis: Tage";
				break;
			case 42:
			case 43:
			case 44: text = "Bis: Wochen";
				break;
			case 45:
			case 46:
			case 47: text = "Bis: Monate";
				break;
			case 48:
			case 49:
			case 50: text = "Bis: Jahre";
				break;
			case 51:
			case 52:
			case 53:
			case 54: text = "Bis: Dekaden";
				break;
			default: text = "Bis: ";
		}
		if(dauer > 55)
			text = "Bis: E.d.L.";
		labelProg.setText(text);
	}
	
	public void setZeilenZiffer(int zeile, int ziffer){
		if(zeile >= 0 && ziffer >= 0){
			labelZeileVergleich.setText("Zeile: "+zeile);
			labelZifferVergleich.setText("Ziffer: "+ziffer);
		}
	}
	
	public int quersumme(int zahl) {
		int betrag = zahl;
		if(zahl < 0)
			betrag = -zahl;
		if (betrag <= 9) return betrag;
		return betrag%10 + quersumme(betrag/10);
	}
	
	public void setStop(){
		statustext.setText("Abgebrochen...");
		progressBar.setValue(statusMax);
		progressBar.setMaximum(statusMax);
		progressBar.setStringPainted(true);
	}
	
	private void neueSeite(boolean alteWerte){
		openButton.setEnabled(true);
		saveButton.setEnabled(false);
		summeFindenbt.setEnabled(true);
		int summewert = 0;
		holeTabelle();
		pruefeDaten();
		sortCB.setEnabled(false);
		sortButton.setEnabled(false);
		noDuploButton.setEnabled(false);
		eingabetable = new JTable(maxEingabe,1);
		eingabetable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		eingabetable.getColumnModel().getColumn(0).setPreferredWidth(80);
		((JLabel)eingabetable.getDefaultRenderer(String.class)).setHorizontalAlignment (JLabel.RIGHT);
		setStatus(statusMax);
		int genauigkei = genauigkeit;//Sonst nur Ärger
		//Alte Werte noch eintragen
		if(alteWerte){
			
			String text = "";
			int wert = 0;
			int max = maxEingabe;
			int betrag = 0;
			boolean unterNull = false;
			if(eingabeDaten.length <= maxEingabe)
				max = eingabeDaten.length;
			
			
			for(int i = 0;i<max;i++){
				if(0 != eingabeDaten[i]){
					wert = eingabeDaten[i];
					text = intToString(wert);
					summewert = summewert + wert;
					/* Ausgelagert in neuer Funktion
					
					genauigkei = genauigkeit;//Sonst nur Ärger
					unterNull = (wert < 0);
  				if(unterNull)
  					betrag = -wert;
  				else
  					betrag = wert;
					if(betrag == 1) genauigkei = genauigkeit -1;
					text = ""+betrag/genauigkei;
					
					
					String genautext = "";
		  		int genau = genauigkei;
		  		String vortext = "";//0en zwischen Komma und Wert sonst:(0,005) -> (0,5)
  				int nullgenau;
		  		nullgenau = (int)genauigkei/betrag;
   				while(nullgenau > 10){
		   			vortext = vortext + "0";
   					nullgenau = nullgenau / 10;
   				}
  				while(genau > 10){
  					genautext = genautext + "0";
  					genau = (int)genau / 10;
  				}
					
					if((betrag % genauigkei) != 0){
						text = text + ","+vortext+ (betrag % genauigkei);
					}	else 
						text = text + ","+genautext; 
					if(unterNull)
						text = "-"+text;
					*/	
				} else
					text = "";
					
				
				eingabetable.getModel().setValueAt(text, i, 0);
			}
		} else {
			eingabeDaten = new int[maxEingabe];
		}
		
		labelSummeDaten.setText("Summe Daten: "+intToString(summewert));
		tabellenstatus = false;
		JPanel ausgabe = new JPanel();
		jsp.setRightComponent(ausgabe);
		JScrollPane scrollPane = new JScrollPane(eingabetable);
		//eingabetable.setFillsViewportHeight(true);
		//ausgabe.add(scrollPane);
		ausgabe.setLayout( new java.awt.BorderLayout() );
		ausgabe.add(scrollPane, BorderLayout.CENTER);
		scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		jsp.setDividerLocation(250);
	}
	
	public static javax.swing.filechooser.FileFilter makeFileFilter(String description, String [] pattern){
		final String [] p = pattern;
		final String d = description;
		return new javax.swing.filechooser.FileFilter(){
			private String [] pat = p;
			public boolean accept(File file){
				if (file.isDirectory()) return true;
				for (int i=0;i<pat.length;i++) if (searchPattern(pat[i].toUpperCase(), file.getName().toUpperCase())) return true;
				return false;
			}
			public String getDescription()
			{
				String des=d+" ("+pat[0];
				for (int i=1;i<pat.length;i++) des+=", "+pat[i];
				return des+")";
			}
		};
	}

	public static boolean searchPattern(String pattern, String text){
		return searchPattern(pattern, 0, text, 0);
	}

	public static boolean searchPattern(String pattern, int ip, String text, int it){
		if (ip>=pattern.length() && it>=text.length()) return true;
		if (ip>=pattern.length()) return false;
		if (it>=text.length()){
			if (pattern.charAt(ip)=='*') return searchPattern(pattern, ip+1, text, it);
			return false;
		}
		if (pattern.charAt(ip)=='?') return searchPattern(pattern, ip+1, text, it+1);
		if (pattern.charAt(ip)=='*'){
			for (int i=it;i<=text.length();i++)
			if (searchPattern(pattern, ip+1, text, i)) return true;
			return false;
		}
		if (pattern.charAt(ip)!=text.charAt(it)) return false;
		return searchPattern(pattern, ip+1, text, it+1);
	}
	
	public void getSummeSelectedRows(){//(JTable links, JTable rechts){
		/*
			Zeilen in einer Tabelle:
			int[] zeilen = table.getSelectedRows();
			this.setCellSelectionEnabled(true);
			this.setRowSelectionAllowed(true);
			
			labelSollHaben.setText("Summe Links: Rechts:");
		*/
		
		
		int[] links = tableLinks.getSelectedRows();
		int[] rechts = tableRechts.getSelectedRows();
		//System.out.println("Selektierte Reihen Links: "+links.length+" Rechts: "+rechts.length);
		int ergL = 0;
		int ergR = 0;
		boolean fehler = false;
		int zeile = 0;
		
		if(ddmL.isVisible()){
			for(int i = 0; i < links.length; i++){
				if(0 == datenL.status(links[i])){
					ergL = ergL + datenL.getBuchwert(links[i]);
					if(!datenL.istStatus(links[i])){
						fehler = true;
						System.out.println("Statusfehler: "+datenL.status(links[i]));
					}
				}
			}
		} else {
			for(int i = 0; i < links.length; i++){
				try{
					zeile = Integer.parseInt(ddmL.getValueAt(links[i],0).toString());
				} catch (NumberFormatException nfe){
					zeile = 0;
				}
				if(0 == datenL.status(zeile-1)){
					ergL = ergL + datenL.getBuchwert(zeile-1);
					if(!datenL.istStatus(zeile-1)) {
						fehler = true;
						System.out.println("Statusfehler: "+datenL.status(zeile-1));
					}
					//System.out.println("Zeile: "+zeile);//datenL.status(links[i]));
				}
			}
		}
		zeile = 0;
		if(ddmR.isVisible()){
			for(int i = 0; i < rechts.length; i++){
				if(0 == datenR.status(rechts[i])){
					ergR = ergR + datenR.getBuchwert(rechts[i]);
					if(!datenR.istStatus(rechts[i])) {
						fehler = true;
						System.out.println("Statusfehler: "+datenR.status(rechts[i]));
					}
				}
			}
		} else {
			for(int i = 0; i < rechts.length; i++){
				try{
					zeile = Integer.parseInt(ddmR.getValueAt(rechts[i],0).toString());
				} catch (NumberFormatException nfe){
					zeile = 0;
				}
				if(0 == datenR.status(zeile-1)){
					ergR = ergR + datenR.getBuchwert(zeile-1);
					if(!datenR.istStatus(zeile-1)) {
						fehler = true;
						System.out.println("Statusfehler: "+datenR.status(zeile-1));
					}
				//System.out.println("Zeile: "+zeile);//datenL.status(links[i]));
				}
			}
		}
		if(ergL == ergR && !fehler){
			labelSollHaben.setText("Summe Links: "+intToString(ergL)+" #"+links.length+" Rechts:"+intToString(ergR)+" #"+rechts.length+" Beides gleich!");
			editRowButton.setEnabled(true);
		} else {
			labelSollHaben.setText("Summe Links: "+intToString(ergL)+" #"+links.length+" Rechts:"+intToString(ergR)+" #"+rechts.length+" ("+intToString(ergL-ergR)+")");
			editRowButton.setEnabled(false);
		}
	}
	
	public void editSelectedRow(){
		int[] links = tableLinks.getSelectedRows();
		int[] rechts = tableRechts.getSelectedRows();
		//System.out.println("Selektierte Reihen Links: "+links.length+" Rechts: "+rechts.length);
		int ergL = 0;
		int ergR = 0;
		int ziffer = 0;
		int zeile = 0;
		boolean fehler = false;
		
		/*
		for(int i = 0; i < links.length; i++){
			ergL = ergL + datenL.getBuchwert(links[i]);
			if(!datenL.istStatus(links[i])) {
				fehler = true;
				System.out.println("Statusfehler: "+datenL.status(links[i]));
			}
		}
		for(int i = 0; i < rechts.length; i++){
			ergR = ergR + datenR.getBuchwert(rechts[i]);
			if(!datenR.istStatus(rechts[i])) {
				fehler = true;
				System.out.println("Statusfehler: "+datenR.status(rechts[i]));
			}
		}
		*/
		
		if(ddmL.isVisible()){
			for(int i = 0; i < links.length; i++){
				if(0 == datenL.status(links[i])){
					ergL = ergL + datenL.getBuchwert(links[i]);
					if(!datenL.istStatus(links[i])) {
						fehler = true;
						System.out.println("Statusfehler: "+datenL.status(links[i]));
					}
				}
			}
		} else {
			for(int i = 0; i < links.length; i++){
				try{
					zeile = Integer.parseInt(ddmL.getValueAt(links[i],0).toString());
				} catch (NumberFormatException nfe){
					zeile = 0;
				}
				if(0 == datenL.status(zeile-1)){
					ergL = ergL + datenL.getBuchwert(zeile-1);
					if(!datenL.istStatus(zeile-1)) {
						fehler = true;
						System.out.println("Statusfehler: "+datenL.status(zeile-1));
					}
					//System.out.println("Zeile: "+zeile);//datenL.status(links[i]));
				}
			}
		}
		zeile = 0;
		if(ddmR.isVisible()){
			for(int i = 0; i < rechts.length; i++){
				if(0 == datenR.status(rechts[i])){
					ergR = ergR + datenR.getBuchwert(rechts[i]);
					if(!datenR.istStatus(rechts[i])) {
						fehler = true;
						System.out.println("Statusfehler: "+datenR.status(rechts[i]));
					}
				}
			}
		} else {
			for(int i = 0; i < rechts.length; i++){
				try{
					zeile = Integer.parseInt(ddmR.getValueAt(rechts[i],0).toString());
				} catch (NumberFormatException nfe){
					zeile = 0;
				}
				if(0 == datenR.status(zeile-1)){
					ergR = ergR + datenR.getBuchwert(zeile-1);
					if(!datenR.istStatus(zeile-1)) {
						fehler = true;
						System.out.println("Statusfehler: "+datenR.status(zeile-1));
					}
					//System.out.println("Zeile: "+zeile);//datenL.status(links[i]));
				}
			}
		}
		
		if(ergL == ergR && !fehler){
			//labelSollHaben.setText("Summe Links: "+intToString(ergL)+" Rechts:"+intToString(ergR)+" Markiert!");
			labelSollHaben.setText("Summe Links: "+intToString(ergL)+" #"+links.length+" Rechts:"+intToString(ergR)+" #"+rechts.length+" Markiert!");
			ziffer = datenL.getNextZiffer();
			if(ddmL.isVisible()){
				for(int i = 0; i < links.length; i++){
					if(0 == datenL.status(links[i])){
						datenL.setZiffer(links[i],ziffer);
						datenL.setStatus(links[i],2);
					}
				}
			} else {
				for(int i = 0; i < links.length; i++){
					try{
						zeile = Integer.parseInt(ddmL.getValueAt(links[i],0).toString());
					} catch (NumberFormatException nfe){
						zeile = 0;
					}
					if(0 == datenL.status(zeile-1)){
						datenL.setZiffer(zeile-1,ziffer);
						datenL.setStatus(zeile-1,2);
					}
				}
			}
			if(ddmR.isVisible()){
				for(int i = 0; i < rechts.length; i++){
					if(0 == datenR.status(rechts[i])){
						datenR.setZiffer(rechts[i],ziffer);
						datenR.setStatus(rechts[i],2);
					}
				}
			}else {
				for(int i = 0; i < rechts.length; i++){
					try{
						zeile = Integer.parseInt(ddmR.getValueAt(rechts[i],0).toString());
					} catch (NumberFormatException nfe){
						zeile = 0;
					}
					if(0 == datenR.status(zeile-1)){
						datenR.setZiffer(zeile-1,ziffer);
						datenR.setStatus(zeile-1,2);
					}
				}
			}
			ddmL.fireTableDataChanged();
			ddmR.fireTableDataChanged();
		} else {
			//labelSollHaben.setText("Summe Links: "+intToString(ergL)+" Rechts:"+intToString(ergR)+" ");
			labelSollHaben.setText("Summe Links: "+intToString(ergL)+" #"+links.length+" Rechts:"+intToString(ergR)+" #"+rechts.length+" ");
		}
		editRowButton.setEnabled(false);
	}
	
	public void findeSummeSelectedRows(){//(JTable links, JTable rechts){
		/*
			Zeilen in einer Tabelle:
			int[] zeilen = table.getSelectedRows();
			this.setCellSelectionEnabled(true);
			this.setRowSelectionAllowed(true);
			
			labelSollHaben.setText("Summe Links: Rechts:");
		*/
		
		
		int[] links = tableLinks.getSelectedRows();
		int[] rechts = tableRechts.getSelectedRows();
		//System.out.println("Selektierte Reihen Links: "+links.length+" Rechts: "+rechts.length);
		int ergL = 0;
		int ergR = 0;
		boolean fehler = false;
		
		for(int i = 0; i < links.length; i++){
			if(0 == datenL.status(links[i])){
				ergL = ergL + datenL.getBuchwert(links[i]);
				if(!datenL.istStatus(links[i])) {
					fehler = true;
					System.out.println("Statusfehler: "+datenL.status(links[i]));
				}
			}
		}
		for(int i = 0; i < rechts.length; i++){
			if(0 == datenR.status(rechts[i])){
				ergR = ergR + datenR.getBuchwert(rechts[i]);
				if(!datenR.istStatus(rechts[i])) {
					fehler = true;
					System.out.println("Statusfehler: "+datenR.status(rechts[i]));
				}
			}
		}
		if(!fehler){
			Blockwart bw = new Blockwart(this, links, rechts, datenL, datenR);
			bw.start();
		}
	}
	
	private void resetStatus(){
		datenL.resetStatus();
		datenR.resetStatus();
		ddmL.fireTableDataChanged();
		ddmR.fireTableDataChanged();
		setDateButtonEnabled();
	}
	
	private void resetStatusSaldo(){
		datenSaldo.resetStatus();
		ddmS.fireTableDataChanged();
		st.reset();
		for (int i = 0; i < tableSaldo.getColumnCount(); i++) {
			tableSaldo.getColumnModel().getColumn(i).setCellRenderer(new MyCellRenderer(datenSaldo));
		}
	}
	
	public void setDialog(String titel, String text){
		JOptionPane.showMessageDialog(f, text, titel, JOptionPane.INFORMATION_MESSAGE);
		if(null != ddmL)
			ddmL.fireTableDataChanged();
		if(null != ddmR)
			ddmR.fireTableDataChanged();
		if(null != ddmS)
			ddmS.fireTableDataChanged();
	}
	
	public void presentSaldo(){
		if(null != st)
			saldoAusgabeText = st.saldoAusgabe();
		System.out.println(saldoAusgabeText);
		if(null == bericht){
			bericht = new JDialog(f, "Bericht");
			bericht.setTitle("Bericht");
			bericht.setSize(600,400);
			bericht.setModal(false);
			berichtTextArea = new JTextArea();
			berichtTextArea.setText(saldoAusgabeText);
			berichtTextArea.setLineWrap(true);
			berichtTextArea.setWrapStyleWord(true);
			JScrollPane berichtScroll = new JScrollPane(berichtTextArea);
			bericht.add(berichtScroll);
		}
		berichtTextArea.setText(saldoAusgabeText);
		bericht.setVisible(true);
	}
	
	private void tagessuche(){
		dateButton.setEnabled(false);//Nur einmal möglich. 
		datenL.setzeGUIDaten(datumLCB.getSelectedIndex()-1, sollLCB.getSelectedIndex()-1, habenLCB.getSelectedIndex()-1, stornoLCB.isSelected(), ignoreLCB.isSelected(), summandenSucheLCB.isSelected(), sucheOhneDatumLCB.isSelected());
		datenR.setzeGUIDaten(datumRCB.getSelectedIndex()-1, sollRCB.getSelectedIndex()-1, habenRCB.getSelectedIndex()-1, stornoRCB.isSelected(), ignoreRCB.isSelected(), summandenSucheRCB.isSelected(), sucheOhneDatumRCB.isSelected());
		
		DateblockData dd = new DateblockData(this, f, datenL, datenR);
		dd.start();
	}
	
	public void setDateButtonEnabled(){
		dateButton.setEnabled(true);//Wegen Fehler. 
		ddmL.fireTableDataChanged();
		ddmR.fireTableDataChanged();
	}
	
	public int getThreadIndex(){
		return threadindex;
	}
	
	public void sortieren(){
		sort_auswahl = sortCB.getSelectedIndex();
		//JOptionPane.showMessageDialog(null, "Sortauswahl: "+sort_auswahl);
		so.sortieren();
	}
	
	private void sortColumn(){

		int[] i = eingabetable.getSelectedColumns();
		if(null != i && i.length > 0){
			SummandenTableModel stm = (SummandenTableModel)eingabetable.getModel();
			for(int j = 0; j < i.length; j++)
				so.sort(i[j], stm);
			stm.fireTableDataChanged();
		}


	}

	private void noDuplo(){
		so.setDuplikate();
		so.sortieren();
	}
	
	public int getAuswahl(){
		return sort_auswahl;
	}
	
	private void saldozuSumme(){
		//Vom SaldoThread die Daten speichern.
	}
	
	public String intToString(int wert){
		int genauigkei = genauigkeit;//Sonst nur Ärger
		boolean unterNull = (wert < 0);
		int betrag = wert;
		String text = "";
  	if(unterNull)
  		betrag = -wert;
  	else
  		betrag = wert;
  	
		if(betrag == 1) genauigkei = genauigkeit -1;
		text = ""+tausender(betrag/genauigkei);
					
					
		String genautext = "";
		int genau = genauigkei;
		String vortext = "";//0en zwischen Komma und Wert sonst:(0,005) -> (0,5)
		if(betrag == 0){
			text = "0,00";
		} else {
			int nullgenau = genauigkei/betrag;
			if ((nullgenau == 0) && (betrag-(betrag/genauigkei)*genauigkei > 0))
   			nullgenau = genauigkei/(betrag-(betrag/genauigkei)*genauigkei);
			while(nullgenau > 10){
				vortext = vortext + "0";
				nullgenau = nullgenau / 10;
			}
	
			while(genau > 10){
				genautext = genautext + "0";
				genau = genau / 10;
			}
	
			if((betrag % genauigkei) != 0){
				text = text + ","+vortext+ (betrag % genauigkei);
			}	else 
				text = text + ","+genautext+"0"; 
			if(unterNull)
				text = "-"+text;
		}
		//System.out.println("Wert: "+wert+" Text: "+text);
		return text;
	}
	
	public String tausender(int zahl){
		String tausender = ""+nf.format(zahl);
		return tausender;
	}
	
	private void selectAll(){
		if(selectAll){
			tableSaldo.clearSelection();
			selectAll = false;
		} else {
			tableSaldo.selectAll();
			selectAll = true;
		}
	}
	
	private void einlesenEingabe(){
		holeDatei(SUMMETXT);
	}
	
	private void pushToFind(){
		testeSaldoThread();
		st.pushToFind(tableSaldo.getSelectedRows());
	}
	
	public void setFindeSumme(String text1, String text2, String[] stringEingabe){
		if(text1 != null)
			suche.setText(text1);
		if(text2 != null)
			abweich.setText(text2);
		if(null != stringEingabe){
			maxInput.setText(""+stringEingabe.length);
			maxLos.setText("1000");
			threadsCB.setSelectedIndex(0);
			variOpti.setSelected(true);
			identOpti.setSelected(true);
			neueSeite(false);
			for(int i = 0; i < stringEingabe.length; i++)
				eingabetable.getModel().setValueAt(stringEingabe[i], i, 0);
		}
		ladenSpeichernFertig();
	}
	
	private void speichernErgebnisse(){
		boolean backup = false;
		boolean links = true;
		jfc = new JFileChooser();
		
		if (null == this.lastDir)
			jfc = new JFileChooser();
		else
			jfc = new JFileChooser(this.lastDir);
		FileFilter filter = new FileNameExtensionFilter("CSV-Datei", "csv");
		jfc.setDialogTitle("Speichere CVS-Datei (Ergebnisse)");
		if(null != filter)
			jfc.setFileFilter(filter);
		int ret = jfc.showSaveDialog(f);
		if (ret == JFileChooser.APPROVE_OPTION) {
			String str1 = jfc.getSelectedFile().getName();
			String str2 = jfc.getSelectedFile().getPath();
			String str3 = jfc.getSelectedFile().getAbsolutePath();
			if ((!str3.substring(str3.length() - 4).equalsIgnoreCase(".csv")) )
				str3 = str3 + ".csv";
			file = new File(str3);
			if (file.exists()) {
				int k = JOptionPane.showConfirmDialog(f, "Die Datei existiert schon\n\nWollen Sie die Datei überschreiben?", "Speichern unter (überschreiben)", 0, 3, null);
				if (k == 0) {
					//Sicherheitskopie anlegen:
					File localFile = new File(str3 + ".bak");
					if (localFile.exists()) {
						//Backupfile existiert
						if (!localFile.delete())
							System.out.println("Löschen des Backups nicht möglich.");
						else
							System.out.println("Backup gelöscht!");
					} else {
						//Nein, noch nicht!
					}
					if (file.renameTo(localFile)) {
						//Datei wurde umbenannt
						backup = true;
					} else {
						System.out.println("Die Datei konnte nicht umbenannt werden");
						JOptionPane.showMessageDialog(f, "Es konnte kein Backup angelegt werden!", "Datei speichern", 2);
					}
					if(backup){
						progressBar.setStringPainted(true);
						statustext.setText("Speichern.");
						so.exportieren(file, (SummandenTableModel)eingabetable.getModel());
					}

				} else {
					//Nicht überschreiben, Abbrechen.
				}
			} else {
				//Datei ist neu
				progressBar.setStringPainted(true);
				statustext.setText("Speichern.");
				so.exportieren(file, (SummandenTableModel)eingabetable.getModel());
			}
			lastDir = file;
		}

	}
	
	private void speichernSaldo(int ladeWas){
		boolean backup = false;
		boolean links = true;
		jfc = new JFileChooser();
		
		if (null == this.lastDir)
			jfc = new JFileChooser();
		else
			jfc = new JFileChooser(this.lastDir);
		FileFilter filter = new FileNameExtensionFilter("BBC-Datei", "bbc");
		jfc.setDialogTitle("Speichere BuchhalterBuddy-Datei");
		if(null != filter)
			jfc.setFileFilter(filter);
		int ret = jfc.showSaveDialog(f);
		if (ret == JFileChooser.APPROVE_OPTION) {
			String str1 = jfc.getSelectedFile().getName();
			String str2 = jfc.getSelectedFile().getPath();
			String str3 = jfc.getSelectedFile().getAbsolutePath();
			if ((!str3.substring(str3.length() - 4).equalsIgnoreCase(".bbc")) )
				str3 = str3 + ".bbc";
			file = new File(str3);
			if (file.exists()) {
				int k = JOptionPane.showConfirmDialog(f, "Die Datei existiert schon\n\nWollen Sie die Datei überschreiben?", "Speichern unter (überschreiben)", 0, 3, null);
				if (k == 0) {
					//Sicherheitskopie anlegen:
					File localFile = new File(str3 + ".bak");
					if (localFile.exists()) {
						//Backupfile existiert
						if (!localFile.delete())
							System.out.println("Löschen des Backups nicht möglich.");
						else
							System.out.println("Backup gelöscht!");
					} else {
						//Nein, noch nicht!
					}
					if (file.renameTo(localFile)) {
						//Datei wurde umbenannt
						backup = true;
						System.out.println("Backup erstellt!");
					} else {
						System.out.println("Die Datei konnte nicht umbenannt werden");
						JOptionPane.showMessageDialog(f, "Es konnte kein Backup angelegt werden!", "Datei speichern", 2);
					}
					if(backup){
						switch(ladeWas){
							case TABSALDO:
								progressBarSaldo.setStringPainted(true);
								labelSaldoStatus.setText("Speichern.");
								st.exportieren(file, (DateiDatenTableModel)tableSaldo.getModel());
								break;
						}
						//so.exportieren(file, (SummandenTableModel)eingabetable.getModel());
					}

				} else {
					//Nicht überschreiben, Abbrechen.
				}
			} else {
				//Datei ist neu
				switch(ladeWas){
					case TABSALDO:
						progressBarSaldo.setStringPainted(true);
						labelSaldoStatus.setText("Speichern.");
						st.exportieren(file, (DateiDatenTableModel)tableSaldo.getModel());
						break;
				}
				/*
				progressBarSaldo.setStringPainted(true);
				labelSaldoStatus.setText("Speichern.");
				st.exportieren(file, (DateiDatenTableModel)tableSaldo.getModel());
				//so.exportieren(file, (SummandenTableModel)eingabetable.getModel());
				*/
			}
			lastDir = file;
		}

	}
	
	public void ladenSpeichernFertig(){
		statustext.setText(".");
	}
	
	private void speichernSuSa(){
		boolean backup = false;
		boolean links = true;
		jfc = new JFileChooser();
		
		if (null == this.lastDir)
			jfc = new JFileChooser();
		else
			jfc = new JFileChooser(this.lastDir);
		FileFilter filter = new FileNameExtensionFilter("CSV-Datei", "csv");
		jfc.setDialogTitle("Speichere CVS-Datei (SuSa)");
		if(null != filter)
			jfc.setFileFilter(filter);
		int ret = jfc.showSaveDialog(f);
		if (ret == JFileChooser.APPROVE_OPTION) {
			String str1 = jfc.getSelectedFile().getName();
			String str2 = jfc.getSelectedFile().getPath();
			String str3 = jfc.getSelectedFile().getAbsolutePath();
			if ((!str3.substring(str3.length() - 4).equalsIgnoreCase(".csv")) )
				str3 = str3 + ".csv";
			file = new File(str3);
			if (file.exists()) {
				int k = JOptionPane.showConfirmDialog(f, "Die Datei existiert schon\n\nWollen Sie die Datei überschreiben?", "Speichern unter (überschreiben)", 0, 3, null);
				if (k == 0) {
					//Sicherheitskopie anlegen:
					File localFile = new File(str3 + ".bak");
					if (localFile.exists()) {
						//Backupfile existiert
						if (!localFile.delete())
							System.out.println("Löschen des Backups nicht möglich.");
						else
							System.out.println("Backup gelöscht!");
					} else {
						//Nein, noch nicht!
					}
					if (file.renameTo(localFile)) {
						//Datei wurde umbenannt
						backup = true;
					} else {
						System.out.println("Die Datei konnte nicht umbenannt werden");
						JOptionPane.showMessageDialog(f, "Es konnte kein Backup angelegt werden!", "Datei speichern", 2);
					}
					if(backup){
						datevProgressBar.setStringPainted(true);
						//statustext.setText("Speichern.");
						//so.exportieren(file, (SummandenTableModel)eingabetable.getModel());
						SuSaExportThread set = new SuSaExportThread(this, file, (SuSaTableModel)susaTable.getModel());
						set.start();
					}

				} else {
					//Nicht überschreiben, Abbrechen.
				}
			} else {
				//Datei ist neu
				datevProgressBar.setStringPainted(true);
				//statustext.setText("Speichern.");
				//so.exportieren(file, (SummandenTableModel)eingabetable.getModel());
				SuSaExportThread set = new SuSaExportThread(this, file, (SuSaTableModel)susaTable.getModel());
				set.start();
			}
			lastDir = file;
		}

	}
	
	private void speichernKonto(){
		boolean backup = false;
		boolean links = true;
		jfc = new JFileChooser();
		
		if (null == this.lastDir)
			jfc = new JFileChooser();
		else
			jfc = new JFileChooser(this.lastDir);
		FileFilter filter = new FileNameExtensionFilter("CSV-Datei", "csv");
		jfc.setDialogTitle("Speichere CVS-Datei (Konto)");
		if(null != filter)
			jfc.setFileFilter(filter);
		int ret = jfc.showSaveDialog(f);
		if (ret == JFileChooser.APPROVE_OPTION) {
			String str1 = jfc.getSelectedFile().getName();
			String str2 = jfc.getSelectedFile().getPath();
			String str3 = jfc.getSelectedFile().getAbsolutePath();
			if ((!str3.substring(str3.length() - 4).equalsIgnoreCase(".csv")) )
				str3 = str3 + ".csv";
			file = new File(str3);
			if (file.exists()) {
				int k = JOptionPane.showConfirmDialog(f, "Die Datei existiert schon\n\nWollen Sie die Datei überschreiben?", "Speichern unter (überschreiben)", 0, 3, null);
				if (k == 0) {
					//Sicherheitskopie anlegen:
					File localFile = new File(str3 + ".bak");
					if (localFile.exists()) {
						//Backupfile existiert
						if (!localFile.delete())
							System.out.println("Löschen des Backups nicht möglich.");
						else
							System.out.println("Backup gelöscht!");
					} else {
						//Nein, noch nicht!
					}
					if (file.renameTo(localFile)) {
						//Datei wurde umbenannt
						backup = true;
					} else {
						System.out.println("Die Datei konnte nicht umbenannt werden");
						JOptionPane.showMessageDialog(f, "Es konnte kein Backup angelegt werden!", "Datei speichern", 2);
					}
					if(backup){
						datevProgressBar.setStringPainted(true);
						//statustext.setText("Speichern.");
						//so.exportieren(file, (SummandenTableModel)eingabetable.getModel());
						KontoExportThread ket = new KontoExportThread(this, file, (KontoTableModel)datevdaten.getKontoTableModel());
						//KontoExportThread ket = new KontoExportThread(this, file, (KontoTableModel)kontoTable.getModel());
						ket.start();
					}

				} else {
					//Nicht überschreiben, Abbrechen.
				}
			} else {
				//Datei ist neu
				datevProgressBar.setStringPainted(true);
				KontoExportThread ket = new KontoExportThread(this, file, (KontoTableModel)datevdaten.getKontoTableModel());
				ket.start();
			}
			lastDir = file;
		}

	}

	public void mouseClicked(){
		rechneKonto();
	}

	public void mouseReleased(){
		rechneKonto();
	}

	private void rechneKonto(){
		int[] zeilen = kontoTable.getSelectedRows();
		String ausgabe = "";
		int soll = 0;
		int haben = 0;
		int summe = 0;
		//datevdaten
		int kontonr = datevdaten.getKontonummer();
		Konto konto = datevdaten.getKonto(kontonr);
		int maxZeilen = konto.getRowCount();
		if(zeilen != null && zeilen.length > 0){
			if(zeilen.length == 1){
				ausgabe = "Ein Element Soll: ";
				if(zeilen[0] == 0){//Saldo
						summe = konto.getAnfangsbestand();
				} else if(zeilen[0] == konto.getRowCount()+2){
						//Da Saldozeile markiert
				} else {
					soll = soll + konto.getSoll(zeilen[0]-1);
					haben = haben + konto.getHaben(zeilen[0]-1);
					summe = summe + konto.getSoll(zeilen[0]-1) - konto.getHaben(zeilen[0]-1);
				}
			} else {
				ausgabe = ""+zeilen.length+" Elemente Soll: ";
				for(int i = 0; i < zeilen.length; i++){
					if(0 == zeilen[i]){
						summe = konto.getAnfangsbestand();
					} else {
						soll = soll + konto.getSoll(zeilen[i]-1);
						haben = haben + konto.getHaben(zeilen[i]-1);
						summe = summe + konto.getSoll(zeilen[i]-1) - konto.getHaben(zeilen[i]-1);
					}
				}
			}


			labelDatevStatus.setText(ausgabe+intToString(soll)+" Haben: "+intToString(haben)+" Summe: "+intToString(summe));
		}
	}

	public void setJCheckboxCheck(JCheckBox jcb){
		if(jcb == identOpti)
			if(identOpti.isSelected())
				sortExitCB.setSelected(false);
		if(jcb == sortExitCB)
			if(sortExitCB.isSelected())
				identOpti.setSelected(false);
	}
}

class tableMouseListener implements MouseListener{
	Buchhalter bh;

	public tableMouseListener(Buchhalter bh){
		this.bh = bh;
	}

	public void mouseReleased(MouseEvent e){bh.mouseReleased();}
	public void mousePressed(MouseEvent e){}
	public void mouseExited(MouseEvent e){}
	public void mouseEntered(MouseEvent e){}
	public void mouseClicked(MouseEvent e){bh.mouseClicked();}

}

class ButtonActionListener implements ActionListener{
	Buchhalter bh;
	
	public ButtonActionListener(Buchhalter bh){
		this.bh = bh;
	}
	
	public void actionPerformed(ActionEvent e){
		bh.action(e);
	}
}

class FocusTest implements FocusListener {
		Buchhalter bh;
    JTextField tf;
   
    public FocusTest(Buchhalter bh, JTextField tf) {
        this.bh = bh;
        this.tf = tf;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if(e.getSource().equals(tf)) {
        	bh.pruefeDaten();
        }
    }
   
}

class JCheckboxListener implements ItemListener {
	Buchhalter bh;
	JCheckBox jcb;

	public JCheckboxListener(Buchhalter bh, JCheckBox jcb){
		this.bh = bh;
		this.jcb = jcb;
	}

	public void itemStateChanged(ItemEvent e){
		bh.setJCheckboxCheck(jcb);
	}
}
/*
class MyListSelectionHandler implements ListSelectionListener {
	Buchhalter bh;
		public MyListSelectionHandler(Buchhalter bh){
			this.bh = bh;
		}
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
				
        int firstIndex = e.getFirstIndex();
        int lastIndex = e.getLastIndex();
        boolean isAdjusting = e.getValueIsAdjusting();
        output.append("Event for indexes "
                      + firstIndex + " - " + lastIndex
                      + "; isAdjusting is " + isAdjusting
                      + "; selected indexes:");

        if (lsm.isSelectionEmpty()) {
            output.append(" <none>");
        } else {
            // Find out which indexes are selected.
            int minIndex = lsm.getMinSelectionIndex();
            int maxIndex = lsm.getMaxSelectionIndex();
            for (int i = minIndex; i <= maxIndex; i++) {
                if (lsm.isSelectedIndex(i)) {
                    output.append(" " + i);
                }
            }
        }
        output.append(newline);
        
        bh.getSummeSelectedRows();
    }
}
*/

