import java.util.Date;
import java.text.SimpleDateFormat;
import java.text.*;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.LocalDate; 


public class Datum{
	private short tag = 1;
	private short monat = 1;
	private short jahr = 2020;
	private Date localDatum;
	
	public Datum(String datum){
		/*
		String text = datum.replace(",", ".");
		int breit = text.length();
		if(breit == 10){//01.03.2020
		tag = (short) stringToInt(text.substring(0,2));
		monat = (short) stringToInt(text.substring(3,5));
		jahr = (short) stringToInt(text.substring(6,10));
		}
		//System.out.println("Tag: "+tag+"\nMonat: "+monat+"\nJahr: "+jahr);
		*/
		testDatum(datum);
		/*
		tag = (short) stringToInt(datum.substring(0,2));
		monat = (short) stringToInt(datum.substring(3,5));
		jahr = (short) stringToInt(datum.substring(6,10));
		*/
	}
	
	public Datum(short tag, short monat, short jahr){
		testDatum(""+getTagString(tag)+"."+getTagString(monat)+"."+jahr);
	}
	
	public Datum(){
		LocalDateTime now = LocalDateTime.now();
    DateTimeFormatter df;
    /*
        df = DateTimeFormatter.BASIC_ISO_DATE;    // 20160131
        df = DateTimeFormatter.ISO_LOCAL_DATE;    // 2016-18-31
        df = DateTimeFormatter.ISO_DATE_TIME;     // 2016-01-31T20:07:07.095
        System.out.println(now.format(df));       
        df = DateTimeFormatter.ofPattern("dd.MM.yyyy kk:mm");     // 31.01.2016 20:07
    */
    df = DateTimeFormatter.ofPattern("dd.MM.yyyy");     // 31.01.2021
    testVollDatum(now.format(df));
    //System.out.println("Datum neu angelegt mit aktuellem Datum: "+now.format(df));
	}
	
	public short getTag(){
		return tag;
	}
	
	public short getMonat(){
		return monat;
	}
	
	public short getJahr(){
		return jahr;
	}
	
	public String toString(){
		return ""+getTagString(tag)+"."+getTagString(monat)+"."+jahr;
	}
	
	public int stringToInt(String s){
		//Direkt in Integer. Keine Dezimalstellen hinter dem Komma. Es gibt kein Komma!
		int genauigkeit = 1;
		s = s.trim();
		int ergebnis = 0;
		boolean vorKomma = true;
		boolean negativ = false;
		char[] text = s.toCharArray();
		int nachkomma = genauigkeit;
		//System.out.print("Ergebnis vor Komma: ");
		for(int i=0; i < text.length;i++){
			if(text[i] == '-') {
				negativ = true;
			} else if (text[i] == '.') {//1.000 enderpunkte
			} else if(text[i] == ','){//| text[i] == '.') {
				if(vorKomma){
					vorKomma = false;
					ergebnis = ergebnis*genauigkeit;
				}
				//System.out.println("Ergebnis nach Komma: ");
			} else if(Character.isDigit(text[i])){
				if(vorKomma){
					ergebnis = ergebnis * 10 + Character.digit( text[i], 10 );
					//System.out.println(""+ergebnis+" "+Character.digit( text[i], 10 ));
				} else {
					//System.out.println(""+ergebnis+" "+Character.digit( text[i], 10 ));
				}
			}
		}
		return ergebnis;
	}
	
	/*
	Ersetzt durch getString
	public String getText(){
		String ergebnis = "";
		if(tag < 10)
			ergebnis = ergebnis + "0";
		ergebnis = ergebnis + tag+".";
		if(monat < 10)
			ergebnis = ergebnis + "0";
		ergebnis = ergebnis + monat+"."+jahr;
		return ergebnis;
	}
	*/
	public String getText(){
		return toString();
	}
	
	public boolean testVollDatum(String text){
		boolean ergebnis = true;
		String dtext = text.replace(",", ".");
		int breit = text.length();
		String[] result = dtext.split(".");
		//System.out.println("Datum: -"+text+"-");
		//for(int i = 0; i < result.length; i ++)
			//System.out.println(result[i]);
		if(10 == breit){
			tag = (short) stringToInt(dtext.substring(0,2));
			monat = (short) stringToInt(dtext.substring(3,5));
			jahr = (short) stringToInt(dtext.substring(6,10));
			java.text.SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
			dateFormat.setLenient( false );
			Date theDate = new Date();
			try {
				theDate = dateFormat.parse(""+tag+"."+monat+"."+jahr);
				//System.out.println("Datumstring gewandelt: "+ dateFormat.format(theDate));
			} catch (ParseException pe) {
				//System.out.println("Eingegebenes Datum (" + text + ") entspricht nicht Format \"dd.MM.yyyy\"");
				ergebnis = false; 
			}
			if(ergebnis){
				if((tag <1 || tag > 31) || (monat < 1 || monat > 12) || jahr < 2000) 
					ergebnis = false;
				if(ergebnis){	
					//Kann das Datum existieren?
					//z.B. 31.02.2020
					localDatum = theDate;
				}
			}
		} else {
			ergebnis = false;
		}
			return ergebnis;
	}
	
	public boolean testDatum(String text){
		return testDatum(text, monat, jahr);
	}
	
	public boolean testDatum(String text, short monat, short jahr){
		String dtext = text.replace(",", ".");
		String raus = "";
		boolean ergebnis = false;
		int breite = dtext.length();
		String[] result = dtext.split(".");
		//System.out.println("Datum: ");
		//for(int i = 0; i < result.length; i ++)
			//System.out.println(result[i]);
		if(breite < 4){//1 || 01 || 01.
			ergebnis = testVollDatum(""+getTagString(stringToInt(dtext))+"."+getTagString(monat)+"."+jahr);
		} else if(breite == 4){//0102 || 01.2
			ergebnis = testVollDatum(""+dtext.substring(0,2)+"."+dtext.substring(2,4)+"."+jahr);
		} else if((breite == 5) || (breite == 6)){//01.02. || 01.02 || 010222 = 01.02.2022
			ergebnis = testVollDatum(""+dtext.substring(0,2)+"."+dtext.substring(3,5)+"."+jahr);
		} else if(breite == 8){//01022020 || 01.02.22 = 01.02.2022 || 1.2.25
			ergebnis = testVollDatum(""+dtext.substring(0,2)+"."+dtext.substring(2,4)+"."+dtext.substring(4,8));
		} else if(breite == 10){//01.02.2020			
			ergebnis = testVollDatum(dtext);
		} 
		if(!ergebnis && breite > 3){
			//2.3. || 2.3.25 || 2.3.2025
			//split nach .
			String ttag = "";
			String tmonat = ""; 
			String tjahr = "";
			
				
			if(result.length > 0){
				result[0] = result[0];
				if(result[0].length() == 1)
				  ttag = "0"+result[0];
				else
				  ttag = result[0].substring(0,2);
				if(result.length > 1){
					if(result[1].length() == 1)
				  tmonat = "0"+result[1];
				else
				  tmonat = result[1].substring(0,2);
				}
				if(result.length > 2){
					if(result[2].length() == 2)
				  tjahr = "20"+result[2];
				else
				  tjahr = result[2].substring(0,4);
				}
			}
			ergebnis = testVollDatum(""+ttag+"."+tmonat+"."+tjahr);
		}
		return ergebnis;
	}
	
	public static String getTagString(int tag){
		String raus = "";
		if(tag < 10)
			raus = "0";
		return ""+raus+tag;
	}
	
	
	public int stringToIntMinus(String s){
		//Direkt in Integer. Keine Dezimalstellen hinter dem Komma. Es gibt kein Komma!
		int genauigkeit = 1;
		s = s.trim();
		int ergebnis = 0;
		boolean vorKomma = true;
		boolean negativ = false;
		char[] text = s.toCharArray();
		int nachkomma = genauigkeit;
		//System.out.print("Ergebnis vor Komma: ");
		for(int i=0; i < text.length;i++){
			if(text[i] == '-') {
				negativ = true;
			} else if (text[i] == '.') {//1.000 enderpunkte
			} else if(text[i] == ','){//| text[i] == '.') {
				if(vorKomma){
					vorKomma = false;
					ergebnis = ergebnis*genauigkeit;
				}
				//System.out.println("Ergebnis nach Komma: ");
			} else if(Character.isDigit(text[i])){
				if(vorKomma){
					ergebnis = ergebnis * 10 + Character.digit( text[i], 10 );
					//System.out.println(""+ergebnis+" "+Character.digit( text[i], 10 ));
				} else {
					//System.out.println(""+ergebnis+" "+Character.digit( text[i], 10 ));
				}
			}
		}
		if(negativ)
			ergebnis = ergebnis * -1;
		return ergebnis;
	}
	
	
	public Date getDate(){
		return localDatum;
	}
}
