import java.util.*;
import java.lang.Math.*;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.io.BufferedOutputStream;


public class KontoExportThread extends Thread{	
	private Buchhalter bh;
	private File file;
	private KontoTableModel ktm;

	public KontoExportThread(Buchhalter bh, File file, KontoTableModel ktm){
		super();
		this.bh = bh;
		this.file = file;
		this.ktm = ktm;
	}
	
	@Override public void run(){
		exportieren();
	}
  	
	public void exportieren(){
		int spalten = ktm.getColumnCount();
		int zeilen = ktm.getRowCount();
		int status = 0;
		bh.setDatevMax(zeilen);
		bh.setDatevStatus(status);
		FileOutputStream fos;
		BufferedWriter bw;
		try
		{
			fos = new FileOutputStream(file);
			bw = new BufferedWriter(new OutputStreamWriter(fos, "UTF-8"));
			for(int j = 0; j < spalten; j++){
				bw.write((String)ktm.getColumnName(j));
				bw.write(";");
			}
			bh.setDatevStatus(++status);
			bw.newLine();
			for(int i = 0; i < zeilen; i++){
				bh.setDatevStatus(++status);
				for(int j = 0; j < spalten; j++){
					if(ktm.getValueAt(i,j) != null)
						bw.write((String)ktm.getValueAt(i,j));
					bw.write(";");
				}
				bw.newLine();
			}
			bw.flush();
			fos.flush();
			fos.close();
		} catch (FileNotFoundException fnfe){
		} catch (Exception e ) { 
			System.err.println(e);
			e.printStackTrace();

		} finally {
		}
	
		//bh.ladenSpeichernFertig();
	}
	
}
