import javax.swing.table.AbstractTableModel;
import java.text.DecimalFormat;

class PrimanotaTableModel extends AbstractTableModel {
	private static final long serialVersionUID = 1L;
	private boolean DEBUG = false;
	private DecimalFormat nf = new DecimalFormat();
	private String[] columnNames;
	private int column, row = 0;
	private int genauigkeit = 100;
	private String genautext = "";
	private DatevDaten daten;

	private Object[][] data;
  
	public void setData(int row, DatevDaten daten){
		Buchung buchung;
		if(null != daten)
			this.daten = daten;
		this.column = 9;
		if(row > 0)
			this.row = row;
		columnNames = new String[column];
		columnNames[0] = "Zeile";
		columnNames[1] = "Betrag";
		columnNames[2] = "S/H";
		columnNames[3] = "Datum";
		columnNames[4] = "Gegen";
		columnNames[5] = "Konto";
		columnNames[6] = "Beleg1";
		columnNames[7] = "Beleg2";
		columnNames[8] = "Text";
		data = new Object[row][column];
		for(int i = 0; i < row; i++){
			buchung = daten.getBuchung(i);
			if(null != buchung){
				data[i][0] = ""+(i+1);
				data[i][1] = ""+intToString(buchung.getBetrag());
				if(buchung.getSollHaben())
					data[i][2] = "S";
				else
					data[i][2] = "H";
				data[i][3] = ""+shortToString(buchung.getTag())+"."+shortToString(buchung.getMonat())+"."+buchung.getJahr();//getGegen();
				data[i][4] = ""+buchung.getHaben();//getGegen();
				data[i][5] = ""+buchung.getSoll();//getKonto();
				data[i][6] = ""+buchung.getBeleg1();
				data[i][7] = ""+buchung.getBeleg2();
				data[i][8] = ""+buchung.getText();
			}
		}
		
		genautext = "";
		int genau = genauigkeit;
		while(genau > 9){
			genautext = genautext + "0";
			genau = genau / 10;
		}  	
	}
  
	public void setWerte(int col, int row, int wert){
		if(col >= 0 && row >= 0){
			String text = "";
			String vortext = "";//0en zwischen Komma und Wert sonst:(0,005) -> (0,5)
			int nullgenau;
			int genauigkei = genauigkeit;//Sonst wieder nur Ärger
			int betrag = 0;
			boolean unterNull = false;
			if(wert == 1) genauigkei = genauigkeit -1;
			unterNull = (wert < 0);
			if(unterNull)
				betrag = -wert;
			else
				betrag = wert;
			
			
			if(0 != wert){
				
				nullgenau = genauigkei/betrag;
				if ((nullgenau == 0) && (betrag-(betrag/genauigkei)*genauigkei > 0))
					nullgenau = genauigkei/(betrag-(betrag/genauigkei)*genauigkei);
				//System.out.println("ng g/w "+nullgenau+"="+genauigkei+"/"+wert);
				//System.out.println("ng g/b "+nullgenau+"="+genauigkei+"/"+betrag);
				while(nullgenau > 10){
					//System.out.println("Vortext: "+vortext+" Ng: "+nullgenau);
					vortext = vortext + "0";
					nullgenau = nullgenau / 10;
				}
				//System.out.println("Vortext: "+vortext+" Ng: "+nullgenau);
				text = ""+tausender(wert/genauigkei);
				//System.out.println("text = wert/genau : "+text+"="+wert+"/"+genauigkei);
				if((betrag % genauigkei) != 0){
					/*if(unterNull){
						text = text + ","+ vortext+((-wert) % genauigkei);
					} else {
						text = text + ","+ vortext+(wert % genauigkei);
					}
					*/
					text = text + ","+ vortext+(betrag % genauigkei);
				}	else
					text = text + ","+genautext; 
				if(unterNull){
					
					if(wert <= -genauigkeit)
						text = text;
					else
						text = "-"+text;
				}
				//System.out.println("Text: "+text);
			} else
				text = "";
			//System.out.println("STM: "+row+" : "+col);
			
			data[row][col] = text;
		}
	}
  
  
	public int getColumnCount() {
		return columnNames.length;
	}

	public int getRowCount() {
		return data.length;
	}

	public String getColumnName(int col) {
		return columnNames[col];
	}

	public Object getValueAt(int row, int col) {
		return data[row][col];
	}

  /*
   * JTable uses this method to determine the default renderer/ editor for
   * each cell. If we didn't implement this method, then the last column
   * would contain text ("true"/"false"), rather than a check box.
   */
  //public Class getColumnClass(int c) {
  //  return getValueAt(0, c).getClass();
  //}

  /*
   * Don't need to implement this method unless your table's editable.
   */
	public boolean isCellEditable(int row, int col) {
		//Note that the data/cell address is constant,
		//no matter where the cell appears onscreen.
		if (col < 1) {
			return true;
		} else {
			return false;
		}
	}

  /*
   * Don't need to implement this method unless your table's data can
   * change.
   */
	public void setValueAt(Object value, int row, int col) {
		if (DEBUG) {
			System.out.println("Setting value at " + row + "," + col
			+ " to " + value + " (an instance of "
			+ value.getClass() + ")");
		}

		data[row][col] = value;
		fireTableCellUpdated(row, col);

		if (DEBUG) {
			System.out.println("New value of data:");
			printDebugData();
		}
	}

	private void printDebugData() {
		int numRows = getRowCount();
		int numCols = getColumnCount();

		for (int i = 0; i < numRows; i++) {
			System.out.print("  row " + i + ":");
			for (int j = 0; j < numCols; j++) {
				System.out.print("  " + data[i][j]);
			}
			System.out.println();
		}
		System.out.println("--------------------------");
	}

	public String tausender(int zahl){
		String tausender = ""+nf.format(zahl);
		return tausender;
	}
	
	public String intToString(int wert){
		int genauigkei = genauigkeit;//Sonst nur Ärger
		boolean unterNull = (wert < 0);
		int betrag = wert;
		String text = "";
		if(unterNull)
			betrag = -wert;
		else
			betrag = wert;
  	
		if(betrag == 1) genauigkei = genauigkeit -1;
		text = ""+tausender(betrag/genauigkei);
					
					
		String genautext = "";
		int genau = genauigkei;
		String vortext = "";//0en zwischen Komma und Wert sonst:(0,005) -> (0,5)
		if(betrag == 0){
			text = "0,00";
		} else {
			int nullgenau = genauigkei/betrag;
			if ((nullgenau == 0) && (betrag-(betrag/genauigkei)*genauigkei > 0))
   			nullgenau = genauigkei/(betrag-(betrag/genauigkei)*genauigkei);
			while(nullgenau > 10){
				vortext = vortext + "0";
				nullgenau = nullgenau / 10;
			}
	
			while(genau > 10){
				genautext = genautext + "0";
				genau = genau / 10;
			}
	
			if((betrag % genauigkei) != 0){
				text = text + ","+vortext+ (betrag % genauigkei);
			}	else 
				text = text + ","+genautext+"0"; 
			if(unterNull)
				text = "-"+text;
		}
		//System.out.println("Wert: "+wert+" Text: "+text);
		return text;
	}
	
	public String shortToString(short i){
		String ausgabe = "";
		if(i < 10)
			ausgabe = "0";
		ausgabe = ausgabe + i;
		return ausgabe;
	}
}

