import javax.swing.*;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.io.BufferedOutputStream;

public class SaldoThread extends Thread{
	
	public static final int was_nichts   = 0;//Nichts
	public static final int was_analyse  = 1;//Analyse ausführen
	public static final int was_anwenden = 2;//Status anwenden

	private DateiDaten daten;
	private Buchhalter bh;
	//Die Daten der GUI:
	private int datums = 0;
	private int solls = 0;
	private int habens = 0;
	private int texts = 0;
	private int gegens = 0;
	private int abbruch = 20;//Ab wieviel Kandidaten soll abgebrochen werden?
	private boolean vorzeichen = false;//true egal, ob soll oder haben Vorzeichen zählt. 
		//false: Soll wird hinzugezählt, Haben wird abgezogen.
	
	private int spalten = 0;
	private int zeilen = 0;
	
	private int[] soll;
	private int[] haben;
	private int[] saldo;
	private boolean[] use;
	private boolean weiter = true;
	private boolean weiter2 = true;
	private int min, max;// Min ist die minimale Zeilennummer (oben), max die Maximale Zeilennummer (unten)
	private String ergebnislog = "";
	private int ziffer = 0;
	private int was = 0;

	
	public SaldoThread(Buchhalter bh, DateiDaten daten){
		was = was_nichts;
		this.bh = bh;
		this.daten = daten;
		spalten = daten.getSpalten();
		zeilen = daten.getZeilen();
		min = 0;
		max = zeilen-1;
	}
	
	public SaldoThread(Buchhalter bh, DateiDaten daten, int was){
		this.bh = bh;
		this.daten = daten;
		this.was = was;
		spalten = daten.getSpalten();
		zeilen = daten.getZeilen();
		min = 0;
		max = zeilen-1;
	}
	
	public void setGUIDaten(boolean vorzeichen, int abbruch, int datums, int solls, int habens){
		this.vorzeichen = vorzeichen;
		if(abbruch > 0)
			this.abbruch = abbruch;
		if(datums > 0 && datums < spalten)
			this.datums = datums;
		if(solls > 0 && solls < spalten)
			this.solls = solls;
		if(habens > 0 && habens < spalten)
			this.habens = habens;
	}
	
	public void run(){
		grund();
		switch(was){
			case was_analyse: analyse(bh.getGegenSpalte());
				break;
			case was_anwenden: statusAnwenden(bh.getSaldoStatus(), bh.getSaldoTextSpalte(), bh.getSaldoSuchtext());
				break;
		}
	}
	
	private void sortNachDatum(){
		daten.sortieren();
	}
	
	private void sollHabenSpalten(){
		soll  = new int[zeilen];
		haben = new int[zeilen];
		saldo = new int[zeilen];
		use   = new boolean[zeilen];
		int wert = 0;
		int lsaldo = 0;
		for(int i = 0; i < zeilen; i++){
			wert = daten.getBuchwert(i);
			if(vorzeichen){
				if(wert < 0){
					soll[i] = -wert;
					haben[i] = 0;
					//System.out.println("Wert-: "+bh.intToString(wert)+" soll["+(i+1)+"]: "+bh.intToString(soll[i])+" haben["+(i+1)+"]: "+bh.intToString(haben[i]));
				} else {
					soll[i] = 0;
					haben[i] = wert;
					//System.out.println("Wert+: "+bh.intToString(wert)+" soll["+(i+1)+"]: "+bh.intToString(soll[i])+" haben["+(i+1)+"]: "+bh.intToString(haben[i]));
				}
				lsaldo = lsaldo - wert;
			} else {
				if(wert > 0){
					soll[i] = wert;
					haben[i] = 0;
					//System.out.println("Wert-: "+bh.intToString(wert)+" soll["+(i+1)+"]: "+bh.intToString(soll[i])+" haben["+(i+1)+"]: "+bh.intToString(haben[i]));
				} else {
					soll[i] = 0;
					haben[i] = -wert;
					//System.out.println("Wert+: "+bh.intToString(wert)+" soll["+(i+1)+"]: "+bh.intToString(soll[i])+" haben["+(i+1)+"]: "+bh.intToString(haben[i]));
				}
				lsaldo = lsaldo + wert;
			}
			
			saldo[i] = lsaldo;
			use[i] = true;
		}
	}
	
	private void log(String weiter){
		ergebnislog = ergebnislog + weiter+"\n";
	}
	
	private void saldenNeuberechnung(){
		int lsaldo = 0;
		//System.out.println("Saldenneuberechnung: "+zeile+" Min: "+min);
		for(int i = 0; i <= max; i++){
			if(use[i]){					    
				if(vorzeichen){
					//System.out.println("Saldoberechnung: Saldo["+(i+1)+"] = "+bh.intToString(lsaldo -soll[i] + haben[i])+" = "+bh.intToString(lsaldo)+" - "+bh.intToString(soll[i])+" + "+bh.intToString(haben[i]));
					lsaldo = lsaldo - soll[i] + haben[i];
				} else {
					//System.out.println("Saldoberechnung: Saldo["+(i+1)+"] = "+bh.intToString(lsaldo +soll[i] - haben[i])+" = "+bh.intToString(lsaldo)+" + "+bh.intToString(soll[i])+" - "+bh.intToString(haben[i]));
					lsaldo = lsaldo + soll[i] - haben[i];
				}
				saldo[i] = lsaldo;
				//System.out.println("Zeile: "+i+" "+bh.intToString(lsaldo));
			}
		}
	}
	
	public void grund(){
		//Schritt 1: Nach Datum sortieren
		sortNachDatum();
		//Schritt 2: Soll und Habenspalten erzeugen.
		//+ Schritt 3: Saldospalte generieren
		sollHabenSpalten();
		//Schritt 4: Wenn der Saldo = 0 ist, dann nichts zu tun.
		int sald = daten.getSaldo(zeilen-1);
		saldenNeuberechnung();
	}
	
	public void alles(){
		bh.setMaxVergleich(bh.TABSALDO, 100);
		bh.setStatusVergleich(bh.TABSALDO, 0);
		bh.progressIntermediate(bh.TABSALDO, true);
		grund();
		//Schritt 5: Alle Zeilen oberhalb vom letzten Nullsaldo ausblenden
		schritt5();
		/*
		 Schritt 6:	Leider Schritt 6 vor Schritt 7, da sonst nur Komplikationen:
				Von unten: Der Saldo von unten nach oben gefunden. Alles darunter
				ist nicht der Saldo.
		*/
		schritt6();
		
		/*Schritt 7: 	Falls der (negative) Saldo zufällig einer der Summanden ist, 
				dann alles darüber.
				Wir gehen den Saldo von min zu max.
		*/
		schritt7();
		
		/*Schritt 8:
				Nächster Schritt: Wenn ein Saldo sich wiederholt, 
				dann sind wohl die Werte dazwischen egal.
		*/
		schritt8();
		
		/*
			Schritt 9: Von den verbliebenen herausfinden, welche zusammen den Saldo 0 ergeben.
				Diese sind dann auch auszublenden und können nicht das Ergebnis sein.
		*/
		schritt9();
		
		/*
			Schritt 10: Falls wir weniger als die Abbruchkandidaten haben, dann brutal durchrechnen.
					Wir können nicht die triviale Lösung nehmen, weil diese leider
					eben gerade nicht gesucht ist. (Die triviale Lösung ist: alle)
		*/
		schritt10();
		
		bh.setMaxVergleich(bh.TABSALDO, 100);
		bh.setStatusVergleich(bh.TABSALDO, 100);
		bh.progressIntermediate(bh.TABSALDO, false);
		bh.presentSaldo();
	}
	
	public void schritt5(){
		//Schritt 5: Alle Zeilen oberhalb vom letzten Nullsaldo ausblenden
		saldenNeuberechnung();
		int ziffer = 0;
		for(int i = max; i >= 0; i--){
			if(use[i] && saldo[i] == 0){
				min = i;
				System.out.println("Minimum Zeilenanzahl: "+min);
				ziffer = daten.getNextZiffer();
				log("# "+ziffer+": Alles oberhalb des Nullsaldos ausgeschlossen.\nMinimum: "+(min+1));
				while(i >= 0){
					if(use[i]){
						use[i] = false;
						daten.setZiffer(i, ziffer);
						daten.setStatus(i, DateiDaten.status_GEFUNDEN);
					}
					i--;
				}
			}
		}
	}
	
	public void schritt6(){
		/*
		 Schritt 6:	Leider Schritt 6 vor Schritt 7, da sonst nur Komplikationen:
				Von unten: Der Saldo von unten nach oben gefunden. Alles darunter
				ist nicht der Saldo.
		*/
		saldenNeuberechnung();
		weiter2 = false;
		System.out.println("Saldosuche: "+bh.intToString(saldo[zeilen-1]));
		for(int i = max; i > min; i--){
			
			int j = i-1;
			if(saldo[i] == saldo[zeilen-1]){
				weiter2 = true;
				max = i;
			} else {
				//System.out.println("Saldo["+(i+1)+"]: "+bh.intToString(saldo[i]));
			}
			
		}
		
		while (weiter2){
			ziffer = daten.getNextZiffer();
			log("# "+ziffer+": Alles unterhalb des Saldos ("+bh.intToString(saldo[max])+") in Zeile: "+(max+1)+" ausgeschlossen.");
			for(int i = max+1; i < zeilen; i++){
				if(use[i]){
					daten.setZiffer(i, ziffer);
					daten.setStatus(i, DateiDaten.status_GEFUNDEN);
					use[i] = false;
				}
			}
			weiter2 = false;
		}
	}
	
	public void schritt7(){
		/*Schritt 7: 	Falls der (negative) Saldo zufällig einer der Summanden ist, 
				dann alles darüber.
				Wir gehen den Saldo von min zu max.
		*/
		saldenNeuberechnung();
		for(int i = min+1; i <= max; i++){
			weiter2 = true;
			int j = i+1;
			while(weiter2 && j < max){
				if(vorzeichen){
					//if(use[i] && use[j] && saldo[i] != 0 && (soll[j] == -saldo[i] || haben[j] == saldo[i])){
					if(use[i] && use[j] && saldo[i] != 0 && (soll[j] == saldo[i] || haben[j] == -saldo[i])){
						log("Soll: "+bh.intToString(soll[j])+" Saldo: "+bh.intToString((-saldo[i]))+" Haben: "+bh.intToString(haben[j])+" Saldo: "+bh.intToString((saldo[i])));
						weiter2 = false;
						int k = i;
						ziffer = daten.getNextZiffer();
						log("# "+ziffer+": Alles oberhalb des negativen Nullsaldos ("+bh.intToString(saldo[i])+") in Zeile: "+(i+1)+" ausgeschlossen.\nSummand gefunden in Zeile: "+(j+1));
						while(k > min){
							if(use[k]){
								daten.setZiffer(k, ziffer);
								daten.setStatus(k, DateiDaten.status_GEFUNDEN);
							}
							use[k] = false;
							k--;
						}
						min = i;
						if(use[j]){
							daten.setZiffer(j, ziffer);
							daten.setStatus(j, DateiDaten.status_GEFUNDEN);
						}
						use[j] = false;
						saldenNeuberechnung();
						j = max;
					} else {
						j++;
					}
				} else {
					if(use[i] && use[j] && saldo[i] != 0 && (soll[j] == -saldo[i] || haben[j] == saldo[i])){
					//if(use[i] && use[j] && saldo[i] != 0 && (soll[j] == saldo[i] || haben[j] == -saldo[i])){
						log("Soll: "+bh.intToString(soll[j])+" Saldo: "+bh.intToString((-saldo[i]))+" Haben: "+bh.intToString(haben[j])+" Saldo: "+bh.intToString((saldo[i])));
						weiter2 = false;
						int k = i;
						ziffer = daten.getNextZiffer();
						log("# "+ziffer+": Alles oberhalb des negativen Nullsaldos ("+bh.intToString(saldo[i])+") in Zeile: "+(i+1)+" ausgeschlossen.\nSummand gefunden in Zeile: "+(j+1));
						while(k > min){
							if(use[k]){
								daten.setZiffer(k, ziffer);
								daten.setStatus(k, DateiDaten.status_GEFUNDEN);
							}
							use[k] = false;
							k--;
						}
						min = i;
						if(use[j]){
							daten.setZiffer(j, ziffer);
							daten.setStatus(j, DateiDaten.status_GEFUNDEN);
						}
						use[j] = false;
						saldenNeuberechnung();
						j = max;
					} else {
						j++;
					}
				}
			}
			
		}
	}
	
	public void schritt8(){
		/*
			Nächster Schritt: Wenn ein Saldo sich wiederholt, dann sind wohl die Werte dazwischen egal.
		*/
		saldenNeuberechnung();
		
			for(int i = min; i <= max; i++){
				weiter2 = false;
				int saldostart = saldo[i];
				int saldopos = i;
				if(use[i]){
					for(int j = i+1; j <= max; j++){
						if(use[j] && (saldo[j] == saldostart)){
							weiter2 = true;
							saldopos = j;
						}
					}
					if(weiter2){
						ziffer = daten.getNextZiffer();
						log("# "+ziffer+": Finden von gleichen Salden. "+bh.intToString(saldostart));
						for(int j = i+1; j <= saldopos; j++){
							if(use[j]){
								daten.setZiffer(j, ziffer);
								daten.setStatus(j, DateiDaten.status_SAMMLER);
							}
							use[j] = false;
						}
					}
				}
			}
		
	}
	
	public void schritt9(){
		/*
			Schritt 9: Von den verbliebenen herausfinden, welche zusammen den Saldo 0 ergeben.
				Diese sind dann auch auszublenden und können nicht das Ergebnis sein.
		*/
		saldenNeuberechnung();
		
			int k = 0;
			for(int i = min; i <= max; i++){
				if(use[i])
					k++;
			}
			boolean huhu = false;
			if(k <= abbruch){
				//Ab hier wird nach Summanden, die die Summe 0 ergeben gesucht
				int[] fundsachen = new int[zeilen];
				Daten suchDaten = new Daten(0, 0, zeilen, true, false);
				for(int i = 0; i < zeilen; i++){
					if(use[i]){
						fundsachen[i] = soll[i] - haben[i];
						huhu = true;
					} else {
						fundsachen[i] = 0;
					}
					suchDaten.setEingabe(i, fundsachen[i]);
				}
				if(huhu){
					suchDaten.maxSuch();
					/*
					int[] test = suchDaten.getSuchArray();
					if(null != test && test.length > 0){
						for(int i = 0; i < zeilen; i++){
							System.out.println("Fundsachen["+i+"] "+fundsachen[i]);
							System.out.println("suchDaten ["+i+"] "+test[i]);
						}
					}
					
					
					suchDaten.print();
					*/
				}
				huhu = false;
				SucheSumme ss = new SucheSumme(0, suchDaten);
				ss.run();
				if(ss.gefunden()){
					System.out.println("Gefunden!");
					Daten loesung = ss.gibLoesung();
					if(null != loesung){
						int[] felder = loesung.getLoesungsfeld();
						ziffer = daten.getNextZiffer();
						log("# "+ziffer+": Finden von gesammelten Nullösungen.");
						for(int i = 0; i < zeilen; i++){
							if(felder[i] != 0){
								System.out.println("L: "+felder[i]);
								daten.setZiffer(i, ziffer);
								daten.setStatus(i, DateiDaten.status_SAMMLER);
								use[i] = false;
							} else {
								//System.out.println("L: "+felder[i]);
							}
						}
					}
				} else {
					log("Keine Nullösung gefunden. (Obwohl vielleicht doch Kandidaten dabei waren)");
				}
				
			}
			bh.setMaxVergleich(bh.TABSALDO, 100);
			bh.setStatusVergleich(bh.TABSALDO, 100);
			bh.progressIntermediate(bh.TABSALDO, false);
		
	}
	
	public void schritt10(){
		/*
			Schritt 10: Falls wir weniger als die Abbruchkandidaten haben, dann brutal durchrechnen.
					Wir können nicht die triviale Lösung nehmen, weil diese leider
					eben gerade nicht gesucht ist. (Die triviale Lösung ist: alle)
		*/
		saldenNeuberechnung();
		
			int k = 0;
			for(int i = min; i <= max; i++){
				if(use[i])
					k++;
			}
			if(k <= abbruch){
				//Ab hier wird gerechnent
				int[] fundsachen = new int[zeilen];
				Daten suchDaten = new Daten(saldo[zeilen-1], 0, zeilen, true, false);
				for(int i = 0; i < zeilen; i++){
					if(use[i]){
						if(vorzeichen)
							fundsachen[i] = - soll[i] + haben[i];	
						else 
							fundsachen[i] = soll[i] - haben[i];
						System.out.print(".. "+i);
					} else {
						fundsachen[i] = 0;
					}
					suchDaten.setEingabe(i, fundsachen[i]);
				}
				suchDaten.maxSuch();
				//suchDaten.print();
				//System.out.println();
				SucheSumme ss = new SucheSumme(0, suchDaten, false);
				ss.run();
				if(ss.gefunden()){
					Daten loesung = ss.gibLoesung();
					if(null != loesung){
						int[] felder = loesung.getLoesungsfeld();
						ziffer = daten.getNextZiffer();
						log("# "+ziffer+": Finden von gesammelten Lösungen.");
						for(int i = 0; i < zeilen; i++){
							if(felder[i] != 0){
								daten.setZiffer(i, ziffer);
								daten.setStatus(i, DateiDaten.status_SALDO);
							}
						}
					}
				}
				
			}
			
		
	}
	
	public void paarSaldo(){
		saldenNeuberechnung();
		for(int i = 0; i < zeilen; i++){
			if(use[i]){
				if(soll[i] > 0){
					//Zuerst unten nachschauen, dann oben
					weiter2 = true;
					if((i+1)< zeilen){
						if(use[i+1]){
							if(haben[i+1] == soll[i]){
								ziffer = daten.getNextZiffer();
								log("# "+ziffer+": Finden von paarweisen Summanden+.");
								log("soll["+(i+1)+"] == haben ["+(i+2)+"] == "+bh.intToString(soll[i]));
								daten.setZiffer(i, ziffer);
								daten.setStatus(i, DateiDaten.status_GEFUNDEN);
								daten.setZiffer(i+1, ziffer);
								daten.setStatus(i+1, DateiDaten.status_GEFUNDEN);
								use[i] = false;
								use[i+1] = false;
								weiter2 = false;
							}
						}
					}
					if(weiter2){
						if((i-1) > 0){
							if(use[i-1]){
								if(haben[i-1] == soll[i]){
									ziffer = daten.getNextZiffer();
									log("# "+ziffer+": Finden von paarweisen Summanden-.");
									log("soll["+i+"] == haben ["+(i+1)+"] == "+bh.intToString(soll[i]));
									daten.setZiffer(i, ziffer);
									daten.setStatus(i, DateiDaten.status_GEFUNDEN);
									daten.setZiffer(i-1, ziffer);
									daten.setStatus(i-1, DateiDaten.status_GEFUNDEN);
									use[i] = false;
									use[i-1] = false;
									weiter2 = false;
								}
							}
						}
					}
				} else {
					if((i+1)< zeilen){
						if(use[i+1]){
							//Wenn Haben zuerst kommt
							if(haben[i] == soll[i+1]){
								ziffer = daten.getNextZiffer();
								log("# "+ziffer+": Finden von paarweisen Summanden+.");
								log("soll["+(i+2)+"] == haben ["+(i+1)+"] == "+bh.intToString(soll[i+1]));
								daten.setZiffer(i, ziffer);
								daten.setStatus(i, DateiDaten.status_GEFUNDEN);
								daten.setZiffer(i+1, ziffer);
								daten.setStatus(i+1, DateiDaten.status_GEFUNDEN);
								use[i] = false;
								use[i+1] = false;
								weiter2 = false;
							}
						}
					}
				}
			}
		}
	}
	
	public void reset(){
		ergebnislog = "";
		sortNachDatum();
		sollHabenSpalten();
	}
	
	public String saldoAusgabe(){
		return "Saldolog:\n"+ergebnislog;
	}
	
	public void exportieren(File file, DateiDatenTableModel ddtm){
		int spalten = ddtm.getColumnCount();
		int zeilen = ddtm.getRowCount();
		int status = 0;
		bh.setStatusMax(zeilen);
		bh.setStatus(status);
		FileOutputStream fos;
		BufferedWriter bw;
		try
		{
			fos = new FileOutputStream(file);
			bw = new BufferedWriter(new OutputStreamWriter(fos, "UTF-8"));
			for(int j = 0; j < spalten; j++){
					bw.write((String)ddtm.getColumnName(j));
					bw.write(";");
			}
			bh.setStatus(++status);
			bw.newLine();
			for(int i = 0; i < zeilen; i++){
				bh.setStatus(++status);
				for(int j = 0; j < 3; j++){
					bw.write(""+ddtm.getValueAt(i,j));
					bw.write(";");
				}
				for(int j = 3; j < spalten; j++){
					bw.write("\""+(String)ddtm.getValueAt(i,j)+"\"");
					if(j < spalten-1)
						bw.write(";");
				}
				bw.newLine();
			}
			bw.flush();
			fos.flush();
			fos.close();
		} catch (FileNotFoundException fnfe){
		} catch (Exception e ) { 
			//System.err.println(e);
			e.printStackTrace();
		} finally {
		}
	
		bh.ladenSpeichernFertig();
	}
	
	public void pushToFind(int [] rows){
		/*
		Welche Möglichkeiten gibt es?
		Alle sind selektiert: Nur die offenen Posten rüberschieben.
		Nur ein paar sind selektiert (das kann in beiden Modi möglich sein, da nachträglich verändert):
			Nur die markierten offenen Posten rüberschieben. 
		Keiner ist selektiert: Nur die offenen Posten rüberschieben.
		*/
		String[] stringEingabe;
		int anzahl = 0;
		int lang = 0;
		int i = 0;
		int j = 0;
		for(i = 0; i < zeilen; i++){
			if(use[i])
				anzahl++;
		}
		if(rows.length == 0 || rows.length ==  zeilen){
			stringEingabe = new String[anzahl];
			j = 0;
			for(i = 0; i < zeilen; i++){
				//if(use[i]){
				if(daten.status(i) == 0){
					if(vorzeichen)
						stringEingabe[j++] = ""+bh.intToString(-soll[i]+haben[i]);
					else
						stringEingabe[j++] = ""+bh.intToString(soll[i]-haben[i]);
				}
			}
		} else {
			//Entweder gibt es weniger verwehrtbare Zeilen oder wir haben weniger selektiert.
			if(anzahl < rows.length)
				lang = anzahl;
			else 
				lang = rows.length;
			stringEingabe = new String[lang];
			j = 0;
			System.out.println("Rows: "+rows.length+" Anzahl: "+anzahl);
			i = 0; 
			while(i < zeilen){
				System.out.println("j: "+j+" i: "+i);
				if(rows[j] == i){
					//if(use[i]){
					if(daten.status(i) == 0){
						if(vorzeichen)
							stringEingabe[j++] = ""+bh.intToString(-soll[i]+haben[i]);
						else
							stringEingabe[j++] = ""+bh.intToString(soll[i]-haben[i]);
					} else {
						stringEingabe[j++] = "";
					}
				}
				if(j < rows.length)
					i++;
				else
					i = zeilen;
				
			}
		}
		bh.setFindeSumme(""+bh.intToString(saldo[zeilen-1]), "", stringEingabe);
	}
	
	public void statusAnwenden(int status, int textSpalte, String suche){
		if(textSpalte >= 0)
			texts = textSpalte;
		bh.setStatusMax(zeilen);
		bh.setStatus(0);
		String text = "";
		text = suche.replaceAll("\n", "");
		String[] split = text.split(";");
		text = "";
		boolean weiter = true;
		boolean gefunden = false;
		int i = 0;
		int j = 0;
		int ziffer = 0;
		int anzahl = 0;
		for(i = 0; i < zeilen; i++){
			text = daten.getText(i, texts);
			weiter = true;
			j = 0;
			while(weiter && j < split.length){
				if(text.indexOf(split[j]) >= 0){
					anzahl++;
					weiter = false;
					if(!gefunden)
						ziffer = daten.getNextZiffer();
					gefunden = true;
					daten.setStatus(i, status);
					daten.setZiffer(i, ziffer);
				}
				j++;
			}
			bh.setStatus(i);
		}
		bh.setStatus(zeilen);
		bh.setDialog("Gefunden","Wir haben den Status "+anzahl+" Mal gefunden");
	}
	
	public void analyse(int gegenSpalte){
		bh.setStatusMax(zeilen);
		bh.setStatus(0);
		String ausgabe = "";
		int i = 0;
		int j = 0;
		boolean weiter = true;
		//Wieviele Stati gibt es?
		int[][] status = new int[zeilen][3];//0 Status, 1 Anzahl, 2 Summe
		String[] gegen = new String[zeilen];//Welche Gegenkonten gibt es und welche werden benutzt?
		int[][] gegenAnzahl = new int[zeilen][2];//Anzahl und Summe der Gegenkonten
		
		for(i = 0; i < zeilen; i++){
			status[i][0] = -1;
			status[i][1] = 0;
			status[i][2] = 0;
			gegen [i] = "";
			gegenAnzahl[i][0] = 0;
			gegenAnzahl[i][1] = 0;
		}
		for(i = 0; i < zeilen; i++){
			//Status
			weiter = true;
			j = 0;
			while(weiter && j < zeilen){
				if(status[j][0] == daten.status(i)){
					status[j][1]++;
					status[j][2] = status[j][2] + daten.getBuchwert(i);
					weiter = false;
				} else {
					j++;
				}
			}
			if(weiter){
				//Wir haben keinen Status gefunden
				j = 0;
				while(weiter && j < zeilen){
					if(-1 == status[j][0]){
						//Anlegen im Feld genau hier!
						if(daten.status(i) != 6){
							System.out.println("Anlegen Status 0 mit Zeile "+(i+1)+" in Feld status["+j+"][0]");
						}
						
						status[j][0] = daten.status(i);
						status[j][1] = 1;
						status[j][2] = daten.getBuchwert(i);
						weiter = false;
					} else {
						j++;
					}
				}
			}
			//Gegenkonto
			if(daten.status(i) > 0)
				weiter = true;
			else
				weiter = false;
			j = 0;
			while(weiter && j < zeilen){
				if(gegen[j].equals(daten.getText(i, gegenSpalte))){
					gegenAnzahl[j][0]++;
					gegenAnzahl[j][1] = gegenAnzahl[j][1] + daten.getBuchwert(i);
					weiter = false;
				} else {
					j++;
				}
			}
			if(weiter){
				//Wir haben keinen Gegen gefunden
				j = 0;
				while(weiter && j < zeilen){
					if(gegen[j].equals("")){
						//Anlegen im Feld genau hier!
						gegen[j]          = daten.getText(i, gegenSpalte);
						gegenAnzahl[j][0] = 1;
						gegenAnzahl[j][1] = daten.getBuchwert(i);
						weiter = false;
					} else {
						j++;
					}
				}
			}
			
			bh.setStatus(i);
		}
		i = 0;
		weiter = true;
		ausgabe = ausgabe + "<H2>Statusanzeige</H2><table><tr><th>Status</th><th>Wie oft</th><th>Summe</th></tr>\n";
		int summeStatus = 0;
		int summeWert = 0;
		while(weiter && i < zeilen){
			if(status[i][0] > -1){
				ausgabe = ausgabe + "<tr><td>"+status[i][0]+"</td><td>"+status[i][1]+"</td><td>"+bh.intToString(status[i][2])+"</td></tr>\n";
				summeStatus = summeStatus + status[i][1];
				summeWert = summeWert + status[i][2];
				i++;
			} else {
				weiter = false;
			}
		}
		ausgabe = ausgabe + "<tr><td></td><td>"+summeStatus+"</td><td>"+bh.intToString(summeWert)+"</td></tr>";
		ausgabe = ausgabe + "</table>\n";
		ausgabe = ausgabe + "<H2>Kontoanzeige</H2><table><tr><th>Konto</th><th>Wie oft</th><th>Summe</th></tr>";
		
		i = 0;
		weiter = true;
		summeStatus = 0;
		summeWert = 0;
		while(weiter && i < zeilen){
			if(gegen[i].equals("")){
				weiter = false;
			} else {
				ausgabe = ausgabe + "<tr><td>"+gegen[i]+"</td><td>"+gegenAnzahl[i][0]+"</td><td>"+bh.intToString(gegenAnzahl[i][1])+"</td></tr>\n";
				summeStatus = summeStatus + gegenAnzahl[i][0];
				summeWert = summeWert + gegenAnzahl[i][1];
				i++;
			
			}
		}
		ausgabe = ausgabe + "<tr><td></td><td>"+summeStatus+"</td><td>"+bh.intToString(summeWert)+"</td></tr>";
		ausgabe = ausgabe + "</table>\n";
		
		bh.setStatus(zeilen);
		//bh.setDialog("Analyse",ausgabe);
		bh.analyseSaldoDialog(ausgabe);
	}
}

/*
Schritt 1: Buchungszeilen nach Datum sortieren. Im Idealfall ist schon sortiert.
Schritt 2: Sollspalte und Habenspalte mit Integern generieren.
		Wenn nach Vorzeichen, dann nach Vorzeichen, sonst nach Soll-/ Habenspalten
Schritt 3: Array mit fortlaufenden Saldo generieren. Ergo Saldo ausrechnen.
		Wenn der Saldo == 0, dann nichts zu tun.
		Gleichzeitig ein Array mit boolean (noch drin) auf true generieren.
Schritt 4: Alle Zeilen über einem Nullsaldo ausziffern (markieren als unwichtig -> false)
Schritt 5: Falls der Saldo schon einmal auftaucht, dann alle Felder unterhalb als unwichtig markieren. -> false
Schritt 6: Falls einer der Summanden auch als Saldo auftaucht: Beispiel:
		Soll	Haben	Saldo
		...	...	0	<--	Alle vorher sind keine Lösung
		120		120
			60	60
		100		160
			30	130	<--	Dieser Saldo ist Nullsaldo, da
		200		330
			50	280
			80	200
			130	70	<--	hier ausgeglichen. Dieser Summand ist nicht Teil
						der Lösungsmenge.
		...	...	...
				70	<--	Saldo?, dann alle vorher keine Lösung bis zur 70.

Schritt X: Variablenoptimierung kann nicht sein: Summanden, die es auf keinen Fall sein können löschen.
Schritt 7: Anzahl der Kandidaten finden. Wenn dazwischen weniger als Abbruchkandidaten, dann brutal durchrechnen.
		Falls größer: Paarweise Differenzen finden. Aber dazu später.
*/