import javax.swing.table.AbstractTableModel;
import java.text.DecimalFormat;

class SummandenTableModel extends AbstractTableModel {
	private static final long serialVersionUID = 1L;
	private boolean DEBUG = false;
	private DecimalFormat nf = new DecimalFormat();
	private String[] columnNames;
	private Daten daten;
	private int column, row = 0;
	private int genauigkeit = 100;
	private String genautext = "";
	private int plusMaxRow = 8;

	private Object[][] data;
  
	public void setData(int column, int row, int genauigkeit){
		if(column > 0)
			this.column = column;
		if(row > 0)
			this.row = row+plusMaxRow;
		if(genauigkeit >= 0)
			this.genauigkeit = genauigkeit;
		columnNames = new String[column];
		columnNames[0] = "Eingabe";
		for(int i = 1; i < column;i++)
			columnNames[i] = ""+i;
		data = new Object[row+plusMaxRow][column];
		for(int i = 0; i < row+plusMaxRow; i++)
			for(int j = 0; j < column; j++)
				data[i][j] = "";
	
		genautext = "";
		int genau = genauigkeit;
		while(genau > 9){
			genautext = genautext + "0";
			genau = genau / 10;
		}
		data[row+2][0] = "Summe:";
		data[row+3][0] = "Abweich.:";
		data[row+4][0] = "pos. Abw.:";
		data[row+5][0] = "Positionen:";
		data[row+6][0] = "Duplikate:";
		data[row+7][0] = "neg Dupli:";
	}
  
	public void setWerte(int col, int row, int wert){
	if(col >= 0 && row >= 0){
		String text = "";
		String vortext = "";//0en zwischen Komma und Wert sonst:(0,005) -> (0,5)
		int nullgenau;
		int genauigkei = genauigkeit;//Sonst wieder nur Ärger
		int betrag = 0;
		boolean unterNull = false;
		if(wert == 1) genauigkei = genauigkeit -1;
		unterNull = (wert < 0);
		if(unterNull)
			betrag = -wert;
		else
			betrag = wert;


		if(0 != wert){

			nullgenau = genauigkei/betrag;
			if ((nullgenau == 0) && (betrag-(betrag/genauigkei)*genauigkei > 0))
				nullgenau = genauigkei/(betrag-(betrag/genauigkei)*genauigkei);
			//System.out.println("ng g/w "+nullgenau+"="+genauigkei+"/"+wert);
			//System.out.println("ng g/b "+nullgenau+"="+genauigkei+"/"+betrag);
			while(nullgenau > 10){
				//System.out.println("Vortext: "+vortext+" Ng: "+nullgenau);
				vortext = vortext + "0";
				nullgenau = nullgenau / 10;
			}
			//System.out.println("Vortext: "+vortext+" Ng: "+nullgenau);
				text = ""+tausender(wert/genauigkei);
				//System.out.println("text = wert/genau : "+text+"="+wert+"/"+genauigkei);
				if((betrag % genauigkei) != 0){
					/*if(unterNull){
						text = text + ","+ vortext+((-wert) % genauigkei);
					} else {
						text = text + ","+ vortext+(wert % genauigkei);
					}
					*/
					text = text + ","+ vortext+(betrag % genauigkei);
				}	else
					text = text + ","+genautext; 
				if(unterNull){
					
					if(wert <= -genauigkeit)
						text = text;
					else
						text = "-"+text;
				}
				//System.out.println("Text: "+text);
			} else
				text = "";
			//System.out.println("STM: "+row+" : "+col);
			
			data[row][col] = text;
		}
  }
  
  public void setWerte(int col, boolean gut, boolean duplikat, boolean negDupli){
  	if(gut && col >= 0) data[row-6][col] = "**GUT**";
	if(duplikat && col >= 0) data[row-1][col] = "Duplikat";
	if(negDupli && col >= 0) data[row-1][col] = "neg Dupli";
  }
  
  public void setSumme(int col, int summe){
  	if(col >= 0) setWerte(col, row-5,summe);
  }
  
  public void setAbweichung(int col, int summe){
  	if(col >= 0) setWerte(col, row-4,summe);
  }
  
  public void setPosAbweichung(int col, int summe){
  	if(col >= 0) setWerte(col, row-3,summe);
  }
  
  public void setPositionen(int col, int pos){
  	if(col >= 0) data[row-2][col] = ""+pos;
  }

  public int getColumnCount() {
    return columnNames.length;
  }

  public int getRowCount() {
    return data.length;
  }

  public String getColumnName(int col) {
    return columnNames[col];
  }

  public Object getValueAt(int row, int col) {
    return data[row][col];
  }

  /*
   * JTable uses this method to determine the default renderer/ editor for
   * each cell. If we didn't implement this method, then the last column
   * would contain text ("true"/"false"), rather than a check box.
   */
  //public Class getColumnClass(int c) {
  //  return getValueAt(0, c).getClass();
  //}

  /*
   * Don't need to implement this method unless your table's editable.
   */
  public boolean isCellEditable(int row, int col) {
    //Note that the data/cell address is constant,
    //no matter where the cell appears onscreen.
    if (col < 1) {
    return true;
    } else {
    return false;
    }
  }

  /*
   * Don't need to implement this method unless your table's data can
   * change.
   */
  public void setValueAt(Object value, int row, int col) {
    if (DEBUG) {
    System.out.println("Setting value at " + row + "," + col
      + " to " + value + " (an instance of "
      + value.getClass() + ")");
    }

    data[row][col] = value;
    fireTableCellUpdated(row, col);

    if (DEBUG) {
    System.out.println("New value of data:");
    printDebugData();
    }
  }

	private void printDebugData() {
		int numRows = getRowCount();
		int numCols = getColumnCount();

		for (int i = 0; i < numRows; i++) {
			System.out.print("  row " + i + ":");
			for (int j = 0; j < numCols; j++) {
				System.out.print("  " + data[i][j]);
			}
			System.out.println();
		}
		System.out.println("--------------------------");
	}

	public String tausender(int zahl){
		String tausender = ""+nf.format(zahl);
		return tausender;
	}
}

