import javax.swing.*;

public class TestData extends Thread{
	private Buchhalter bh;
	private JFrame f;
	private DateiDaten links, rechts;
	private boolean benachrichtigeMich = false;
	private VergleichData vd;
	private DateblockData dd;

	public TestData(Buchhalter bh, JFrame f, DateiDaten links, DateiDaten rechts){
		super();
		this.bh = bh;
		this.f = f;
		this.links = links;
		this.rechts = rechts;
	}
	
	@Override public void run(){
		/*
			Los gehts:
			als erstes werden die Einstellungen geprüft, weil das am schnellsten geht.
			Wir können ohne Datum und ohne Haben leben, aber nicht ohne Soll.
		*/
		boolean weiter = true;
		String fehler = "Einstellungen falsch!";
		String fehlertext = "allet jut";
		int zeile = 0;
		int spalte = 0;
		int maxZeilen = 0;
		int i = 0;
		if(links.getWahlSoll() == -1){
			weiter = false;
			fehlertext = "Linke Seite ist keine Soll (Betrags)-Spalte ausgewählt";
		}
		/*
			Wenn Zeilen ohne Datum ignorieren ausgewählt wurde, 
			aber kein Datum ausgewählt wurde, dann ist die Einstellung falsch
		*/
		if(weiter && links.getZeilenOhneDatum() && links.getWahlDatum() == -1){
			weiter = false;
			fehlertext = "Linke Seite ist Zeilen ohne Datum ignorieren ausgewählt,\naber keine Spalte mit dem Datum ausgewählt!";
		}
		if(weiter && rechts.getWahlSoll() == -1){
			weiter = false;
			fehlertext = "Rechte Seite ist keine Soll (Betrags)-Spalte ausgewählt";
		}
		if(weiter && rechts.getZeilenOhneDatum() && rechts.getWahlDatum() == -1){
			weiter = false;
			fehlertext = "Rechte Seite ist -Zeilen ohne Datum ignorieren- ausgewählt,\naber keine Spalte mit dem Datum ausgewählt!";
		}
		
		/*
			Das waren schon alle möglichen falschen Einstellungen.
			Nun werden die Daten überprüft.
			Zuerst die Datumsdaten;
		*/
		
		
		if(weiter){
			//linke Seite
			fehler = "Datumsspalten links fehlerhaft!";
			maxZeilen = links.getZeilen();
			bh.setMaxVergleich(true, (maxZeilen*3));
			bh.setStatusVergleich(true, 0);
			if(maxZeilen > 0)
				links.getSaldo(0);
			spalte = links.getWahlDatum();
			if(!links.getZeilenOhneDatum() && spalte >= 0){
				i = 0;
				while(weiter && i < maxZeilen){ 
					zeile = i+1;//Anzeige um einen Zähler höher
					if(!links.istDatum(i,spalte)){
						weiter = false;
						fehlertext = "In Zeile "+zeile+" ist das Datum in Spalte "+(spalte+1)+" falsch!";
					}
					bh.setStatusVergleich(true, i);
					i++;
				}
			} else {
				bh.setStatusVergleich(true, maxZeilen);
			}
			//Sollspalten überprüfen
			if(weiter){
				fehler ="Sollspalten links fehlerhaft";
				spalte = links.getWahlSoll();
				i = 0;
				while(weiter && i < maxZeilen){ 
					zeile = i+1;//Anzeige um einen Zähler höher
					/*
					//Wenn Soll fehlerhaft, aber Datum richtig ist
						Soll ist fehlerhaft
							Aber ignorieren wir, wenn Datum fehlerhaft ist UND Zeilen ohne Datum ausgewählt
							Also, ist es falsch, 	WENN das Datum gar nicht ausgewählt wurde 
																		ODER das Datum funktioniert und ignorieren gedrückt wurde
					*/
					if(!links.istSollHaben(i,spalte))
						if(links.getWahlDatum() == -1 || (links.getZeilenOhneDatum() && links.istDatum(i, links.getWahlDatum()))){
							weiter = false;
							fehlertext = "In Zeile "+zeile+" ist das Soll in Spalte "+(spalte+1)+" falsch!";
						}
					bh.setStatusVergleich(true, maxZeilen+i);
					i++;
				}
			}
			//Habenspalten überprüfen
			//Aber nur, wenn Habenspalten auch ausgesucht wurden!
			if(weiter && links.getWahlHaben()>= 0){
				//System.out.println("links.getWahlHaben()>= 0 : "+links.getWahlHaben());
				fehler ="Habenspalten links fehlerhaft";
				spalte = links.getWahlHaben();
				i = 0;
				while(weiter && i < maxZeilen){ 
					zeile = i+1;//Anzeige um einen Zähler höher
					//Wenn Haben fehlerhaft, aber Datum richtig ist
					if(!links.istSollHaben(i,spalte))
						if(links.getWahlDatum() == -1 || (links.getZeilenOhneDatum() && links.istDatum(i, links.getWahlDatum()))){
							weiter = false;
							fehlertext = "In Zeile "+zeile+" ist das Haben in Spalte "+(spalte+1)+" falsch!";
						}
					bh.setStatusVergleich(true, maxZeilen+maxZeilen+i);
					i++;
				}
			} else {
				bh.setStatusVergleich(true, maxZeilen*3);
			}
		}
		if(weiter){
			//rechte Seite
			fehler = "Datumsspalten rechts fehlerhaft!";
			maxZeilen = rechts.getZeilen();
			bh.setMaxVergleich(false, (maxZeilen*3));
			bh.setStatusVergleich(false, 0);
			if(maxZeilen > 0)
				rechts.getSaldo(0);
			spalte = rechts.getWahlDatum();
			if(!rechts.getZeilenOhneDatum() && spalte >= 0){
				i = 0;
				while(weiter && i < maxZeilen){ 
					zeile = i+1;//Anzeige um einen Zähler höher
					if(!rechts.istDatum(i,spalte)){
						weiter = false;
						fehlertext = "In Zeile "+zeile+" ist das Datum in Spalte "+(spalte+1)+" falsch!";
					}
					bh.setStatusVergleich(false, i);
					i++;
				}
			} else {
				bh.setStatusVergleich(false, maxZeilen);
			}
			//Sollspalten überprüfen
			if(weiter){
				fehler ="Sollspalten rechts fehlerhaft";
				spalte = rechts.getWahlSoll();
				i = 0;
				while(weiter && i < maxZeilen){ 
					zeile = i+1;//Anzeige um einen Zähler höher
					//Wenn Soll fehlerhaft, aber Datum richtig ist
					if(!rechts.istSollHaben(i,spalte))
						if(rechts.getWahlDatum() == -1 || (rechts.getZeilenOhneDatum() && rechts.istDatum(i, rechts.getWahlDatum()))){
							weiter = false;
							fehlertext = "In Zeile "+zeile+" ist das Soll in Spalte "+(spalte+1)+" falsch!";
						}
					bh.setStatusVergleich(false, maxZeilen+i);
					i++;
				}
			}
			//Habenspalten überprüfen
			//Aber nur, wenn Habenspalten auch ausgesucht wurden!
			if(weiter && rechts.getWahlHaben()>= 0){
				fehler ="Habenspalten rechts fehlerhaft";
				spalte = rechts.getWahlHaben();
				i = 0;
				while(weiter && i < maxZeilen){ 
					zeile = i+1;//Anzeige um einen Zähler höher
					//Wenn Soll fehlerhaft, aber Datum richtig ist
					if(!rechts.istSollHaben(i,spalte))
						if(rechts.getWahlDatum() == -1 || (rechts.getZeilenOhneDatum() && rechts.istDatum(i, rechts.getWahlDatum()))){
							weiter = false;
							fehlertext = "In Zeile "+zeile+" ist das Haben in Spalte "+(spalte+1)+" falsch!";
						}
					bh.setStatusVergleich(false, maxZeilen+maxZeilen+i);
					i++;
				}
			} else {
				bh.setStatusVergleich(false, maxZeilen*3);
			}
		}
		
		/*
			Fehlerausgabe. Jeder Fehler nur ein Dialog!
		*/
		if(weiter){
			if(benachrichtigeMich){
				if(null!= vd){
					vd.allesGut();
				}
				if(null!= dd){
					dd.allesGut();
				}
			} else {
				JOptionPane.showMessageDialog(f, "Überprüfung beendet und für gut befunden");
			}
		} else {
			JOptionPane.showMessageDialog(f, fehlertext, fehler, JOptionPane.WARNING_MESSAGE);
			bh.setDateButtonEnabled();
		}
	}
	
	public void bitteAntworten(VergleichData vd){
		this.vd = vd;
		benachrichtigeMich = true;
	}
	
	public void bitteAntworten(DateblockData dd){
		this.dd = dd;
		benachrichtigeMich = true;
	}
}

