import java.util.GregorianCalendar;
import java.util.Calendar;
import java.util.logging.*;
import java.io.*;


public class Daten{
	GregorianCalendar aktuell;
	GregorianCalendar[] planzeit; //Zeit, wann losgehen sollte
	GregorianCalendar[] endzeit;  //aktuelle Zeit, wann Countdown abläuft
	GregorianCalendar[] endprogrammzeit;  //aktuelle Zeit, wann Countdown abläuft
	long startzeit;  //Zeit, wann der Countdown losgeht!
	long[] diffMilliseconds;//Zeit zwischen den Zeiten.
	long lastCountdown = 0;//Letzter Countdown vor der Pause
	long extraCountdownEndzeit = 0;//Zeit ExtraCountdown in Millisekunden
	long extraCountdownRestzeit = 0;//Restzeit ExtraCountdown in Millisekunden
	long meineStartzeit = 0;//Für die Verspätungsanzeige
	long programmStartzeit = 0;//Für die Verspätungsanzeige
	boolean pause = false;
	boolean farbe = false;//Gelbe Farbe für die letzten 5 Minuten, wenn über 10 Minuten das Ereignis war.
	boolean farben[];//Ja, wenn diff > 540.000
	boolean rot = false;
	boolean vorStart = false;//Es ist 14:00 Uhr und der Countdown soll um 15:00 Uhr beginnen.
	boolean extraCD = false;//Es existiert ein ExtraCountdown, true, wenn dieser läuft.
	boolean extraPause = false;// Pause des ExtraCountdowns
	private long millisStart = 1;//Anzahl der Millisekunden vor dem Start
	private Log log;
	private String logtext = "";
	private String extraText = "";
	private String plusZeit = "";
	private boolean spatzeit = false;
	private boolean showLate = false;
	
	int jahr;
	int monat;
	int tag;
	int stunden[];
	int minuten[];
	int sekunden[];

	//ExtraCountdown
	int stundenECD = 0;
	int minutenECD = 0;
	int sekundenECD = 0;
	
	String was[];
	String wer[];
	
	boolean countdown_running = false;
	boolean auto = true;
	private Bildschirm bs;
	
	//String stunde, minute, minuteCD, sekundeCD minuteDiff, sekundeDiff = "";
	
	int status = -1;
	int maxStatus = 0;
	String countdown = "";
	String zeitString = "";
	
	int letzteStunde = 00; //falls Integer.parseInt nicht funktioniert
	int letzteMinute = 00; //
	int nächsteStunde = 00;
	int nächsteMinute = 00;

	long promille = 0;//Der Promillefortschritt
	long max_promille = 0;//maximale Promille, wird nur geändert, wenn neuer Punkt angewählt wird.
	long millis = 0;
	
	int maxDaten = 0;

	public Daten(int maxDaten, Log log){
		aktuell = new GregorianCalendar();
		jahr = aktuell.get(GregorianCalendar.YEAR);
		monat = aktuell.get(GregorianCalendar.MONTH);
		tag =  aktuell.get(GregorianCalendar.DAY_OF_MONTH);
		if(maxDaten > 0)
			this.maxDaten = maxDaten;
		if(null != log)
			this.log = log;
		else
			log = new Log(0);
	}
	
	public boolean einlesen(String text, boolean zeit){
		/*
			Das ist für eine spätere Variante, in der man nicht die konkreten Uhrzeiten eingibt, sondern die Zeiten,
			die die einzelnen Punkte benötigen. Das soll der erste Schritt sein, damit dann im laufendem Betrieb
			neue Punkte hinzugefügt werden können oder ein Punkt live mehr Zeit gegeben werden kann.
		*/
		boolean ausgabe = false;
		if(zeit){
			/*
				Die Zeiten sind Uhrzeiten
			*/
			ausgabe = einlesen(text);

		} else {
			/*
				Alles wird als direkte Zeitanzeige verstanden.
				Also 01:15 bedeutet eine Stunde und 15 Minuten
			*/
			boolean ok = true;
			String[] zeilen = text.split("\n");
			log.fine("Anzahl Zeilen: "+zeilen.length);
			String textzeile = "";
		}
		return ausgabe;
	}

	public boolean einlesen(String text){
		boolean ok = true;
		String[] zeilen = text.split("\n");
		log.fine("Anzahl Zeilen: "+zeilen.length);
		String textzeile = "";
		
		int stunde = 0;
		int minute = 0;
		if(zeilen.length > 1){
			planzeit = new GregorianCalendar[zeilen.length];
			endzeit = new GregorianCalendar[zeilen.length];
			endprogrammzeit = new GregorianCalendar[zeilen.length];
			diffMilliseconds = new long[zeilen.length];
			farben = new boolean[zeilen.length];
			stunden = new int[zeilen.length];
			minuten = new int[zeilen.length];
			sekunden = new int[zeilen.length];
			wer = new String[zeilen.length];
			was = new String[zeilen.length];
			for(int i = 0; i < zeilen.length; i++){
				farben[i] = false;
				if(i > zeilen.length - 2){
					try{
						log.fine("Test: "+zeilen[i-1] +"-");
						log.fine("Test: "+zeilen[i] +"-");
						log.fine("Ende: "+zeilen[i].substring(0,5));
					} catch (StringIndexOutOfBoundsException sioufbe) {
						ok= false;
					}
					maxStatus = i;
				} else {
					if(zeilen[i].length() > 4){ 
						logtext = "Zeit: "+zeilen[i].substring(0,5)+" 1|"+zeilen[i].substring(0,2)+":"+zeilen[i].substring(3,5)+" 2|";
						
						try{
							stunde =  Integer.parseInt(zeilen[i].substring(0,2));
							minute =  Integer.parseInt(zeilen[i].substring(3,5));
							stunden[i] = stunde;
							minuten[i] = minute;
							nächsteStunde =  Integer.parseInt(zeilen[i+1].substring(0,2));
							nächsteMinute =  Integer.parseInt(zeilen[i+1].substring(3,5));
						} catch (NumberFormatException e){
							stunde = letzteStunde;
							minute = letzteMinute+1;
							stunden[i] = stunde;
							minuten[i] = minute;
							nächsteStunde =  letzteStunde;
							nächsteMinute = letzteMinute+2;
						}
						letzteStunde = stunde;
						letzteMinute = minute+1;
						if(letzteMinute > 57){
							letzteMinute = 00;
							letzteStunde++;
							if(letzteStunde > 24)
								letzteStunde = 0;
						}
						logtext = logtext + zweiDigit(stunde)+":"+zweiDigit(minute)+" 3|";
						//GregorianCalendar( jahr, monat, tag, stunde, minute );
						planzeit[i] = new GregorianCalendar( jahr, monat, tag, stunde, minute );
						endzeit[i] = new GregorianCalendar( jahr, monat, tag, nächsteStunde, nächsteMinute );
						endprogrammzeit[i] = new GregorianCalendar( jahr, monat, tag, nächsteStunde, nächsteMinute );
						long diffMillis = endzeit[i].getTimeInMillis() - planzeit[i].getTimeInMillis();
						diffMilliseconds[i] = diffMillis;
						if(diffMillis < 0){
							tag = tag+1;
							endzeit[i] = new GregorianCalendar( jahr, monat, tag, nächsteStunde, nächsteMinute );
							diffMillis = endzeit[i].getTimeInMillis() - planzeit[i].getTimeInMillis();
						}
						if(diffMillis > 540000)
							farben[i] = true;
						else
							farben[i] = false;
						double diffDay = diffMillis / 1000D / 60D / 60D / 24D; 
						double diffHour = diffDay % 1 * 24;
						double diffMin = diffHour % 1 * 60;
						//double diffSec = diffMin % 1 * 60;
						logtext = logtext +zweiDigit((int)diffHour)+":"+zweiDigit((int)diffMin)+" 4|";
						maxDaten = zeilen.length;
					} else {
						ok = false;
					}
					//Was:
					textzeile = zeilen[i].substring(6,zeilen[i].length());
					String[] waswer = textzeile.split("\\*");
					was[i] = waswer[0];
					if(waswer.length > 1 && waswer.length < 3)
						wer[i] = waswer[1];
					else
						wer[i] = "";
					log.finer(logtext +was[i]+":"+wer[i]+"|"+waswer.length);
				}
			}
		}
		return ok;
	}
	
	public int getSec(long millis){
		double diffDay = millis / 1000D / 60D / 60D / 24D; 
		double diffHour = diffDay % 1 * 24;
		double diffMin = diffHour % 1 * 60;
		double diffSec = diffMin  % 1 * 60;
		return (int)diffSec;
	}
	
	public int getMin(long millis){
		double diffDay = millis / 1000D / 60D / 60D / 24D; 
		double diffHour = diffDay % 1 * 24;
		double diffMin = diffHour % 1 * 60;
		return (int)diffMin;
	}
	
	public int getHour(long millis){
		double diffDay = millis / 1000D / 60D / 60D / 24D; 
		double diffHour = diffDay % 1 * 24;
		double diffMin = diffHour % 1 * 60;
		return (int)diffHour;
	}

	public static String zweiDigit(int zahl){
		if(zahl > 9)
			return ""+zahl;
		else
			return "0"+zahl;
	}	
		
	public String aktuelleUhrzeit(){
		//Ausgabe aktuell
		//java.util.Date date = new java.util.Date();
		//String minute = zweiDigit(date.getMinutes()); // Minute in der Stunde
		zeitString = "";
		Calendar rightNow = Calendar.getInstance();
		String minute = zweiDigit(rightNow.get(Calendar.MINUTE));
		String stunde = zweiDigit(rightNow.get(Calendar.HOUR_OF_DAY));
		
		//Für interne Berechnungen Countdown
		if(!pause){
			rot = false;
			boolean mitFarben = false;
			long Millis = 0;
			if(-1 == status)
				Millis = startzeit;//planzeit[status+1].getTimeInMillis();
			else
				Millis = endzeit[status].getTimeInMillis();
			aktuell = new GregorianCalendar();
			millis = Millis - aktuell.getTimeInMillis();

			//Endzeit anzeigen:
			if(status >= 0 && status < maxStatus)//Else: Zeit VOR dem Start.
				zeitString = ""+zweiDigit(endzeit[status].get(Calendar.HOUR_OF_DAY))+":"+zweiDigit(endzeit[status].get(Calendar.MINUTE));
			else
				zeitString = ""+zweiDigit(planzeit[0].get(Calendar.HOUR_OF_DAY))+":"+zweiDigit(planzeit[0].get(Calendar.MINUTE));
			if(millis > 0){
				/*
				//Endzeit anzeigen:
				if(status >= 0 && status < maxStatus)
					zeitString = ""+zweiDigit(endzeit[status].get(Calendar.HOUR_OF_DAY))+":"+zweiDigit(endzeit[status].get(Calendar.MINUTE));
				else
					zeitString = ""+zweiDigit(planzeit[0].get(Calendar.HOUR_OF_DAY))+":"+zweiDigit(planzeit[0].get(Calendar.MINUTE));
				*/
				double diffDay = millis / 1000D / 60D / 60D / 24D; 
				double diffHour = diffDay % 1 * 24;
				double diffMin = diffHour % 1 * 60;
				double diffSec = diffMin % 1 * 60;
			
				String minuteCD = zweiDigit(getMin(millis)); // Minute in der Stunde
				String stundeCD = zweiDigit(getHour(millis));
				String sekundeCD = zweiDigit(getSec(millis));
			
				if(diffHour >= 1){
					countdown = ""+stundeCD+":"+minuteCD+":"+sekundeCD;
				} else {
					countdown = ""+minuteCD+":"+sekundeCD;
				}
				if(millis < 300000){
					if(-1 == status){
						farbe = true;
					} else {
						farbe = farben[status];
					}
				} else {
					farbe = false;
				}
			} else {
				//Zeit abgelaufen
				auto = bs.getAuto();
				if(auto){
					vorStart = false;
					//nexter
					if(status < maxStatus-1){
						status++;
						meineStartzeit = aktuell.getTimeInMillis();
					} else {
						if(0 == status && !rot){
							meineStartzeit = aktuell.getTimeInMillis();
							if(0 == status)
								programmStartzeit = meineStartzeit;
						}
						rot = true;
					}
				} else {
					countdown = "00:00";
					rot = true;
					//Hier Pluszeit berechnen. Auf eine Minute genau.
					//if(status >= 0 && status < maxStatus){
					//	plusZeit = "+"+(aktuell.getTimeInMillis()-endzeit[status].getTimeInMillis());
					//}
				}
			}
		}
		
		//System.out.println("Uhrzeit: "+stunde+":"+minute);
		//System.out.println("Berechnung: "+stundeCD+":"+minuteCD+":"+sekundeCD);
		
		return ""+stunde+":"+minute;
	}
	
	public String getCountdown(){
		return countdown;
	}
	
	public void setAuto(boolean auto){
		this.auto = auto;
	}
	
	public void start(Bildschirm bs){
		/*
			Jetzt zählt es. Alles noch einmal berechnen.
		*/
		this.bs = bs;
		if(status == -1){
			//wir starten am Anfang
			countdown_running = true;
			long Millis = planzeit[0].getTimeInMillis();
			aktuell = new GregorianCalendar();
			long millis = Millis - aktuell.getTimeInMillis();
			long milliAktuell = aktuell.getTimeInMillis();
			programmStartzeit = aktuell.getTimeInMillis();
			if(millis < 0){
				//Wir haben den (Start-)Zeitpunkt verpasst
				log.info("Verpasst: Endzeiten werden neu berechnet.");
				for(int i = 0; i < maxDaten-1; i++){
					System.out.println("Daten: "+i+" "+stunden[i]+":"+minuten[i]);
					if(i > 0){
						endzeit[i].setTimeInMillis(endzeit[i-1].getTimeInMillis()+diffMilliseconds[i]);
					} else {
						endzeit[i].setTimeInMillis(milliAktuell+diffMilliseconds[i]);
					}
					endprogrammzeit[i] = new GregorianCalendar();
					endprogrammzeit[i].setTimeInMillis(endzeit[i].getTimeInMillis());
				}
			} else {
				vorStart = true;
				//Wir sind vor der Zeit.
				log.info("Voll in der Zeit. Endzeiten bleiben die gleichen.");
				for(int i = 0; i < maxDaten; i++){
					//System.out.println("Daten: "+stunden[i]+":"+minuten[i]);
				}
				startzeit = Millis;
				millisStart = millis;
			}
		} else {
		}
	}

	public void pStart(){
		//Ab hier wird die Endzeit des Programmes festgezurrt und alle Verspätungen angezeigt.
		for(int i = 0; i < maxDaten-1; i++){
			endprogrammzeit[i] = new GregorianCalendar();
			endprogrammzeit[i].setTimeInMillis(endzeit[i].getTimeInMillis());
			//endprogrammzeit[i] = endzeit[i];
			spatzeit = true;
			programmStartzeit = meineStartzeit;
		}
	}
	
	public void next(){
		vorStart = false;
		if(status < maxStatus-1){
			status++;
			meineStartzeit = aktuell.getTimeInMillis();
			//if(0 == status)
			//	programmStartzeit = meineStartzeit;
			long Millis = planzeit[0].getTimeInMillis();
			aktuell = new GregorianCalendar();
			long millis = Millis - aktuell.getTimeInMillis();
			long milliAktuell = aktuell.getTimeInMillis();
			for(int i = status; i < maxDaten-1; i++){
				if(i > status){
					endzeit[i].setTimeInMillis(endzeit[i-1].getTimeInMillis()+diffMilliseconds[i]+1001);
				} else {
					endzeit[i].setTimeInMillis(milliAktuell+diffMilliseconds[i]+1001);
				}
			}
			//max_promille = endzeit[status];
		}
		auto = false;
		pause = false;
	}
	
	public void pre(){
		if(status > 0){
			status--;
			meineStartzeit = aktuell.getTimeInMillis();
			long Millis = planzeit[0].getTimeInMillis();
			aktuell = new GregorianCalendar();
			long millis = Millis - aktuell.getTimeInMillis();
			long milliAktuell = aktuell.getTimeInMillis();
			for(int i = status; i < maxDaten-1; i++){
				if(i > status){
					endzeit[i].setTimeInMillis(endzeit[i-1].getTimeInMillis()+diffMilliseconds[i]+1001);
				} else {
					endzeit[i].setTimeInMillis(milliAktuell+diffMilliseconds[i]+1001);
				}
			}
			//max_promille = endzeit[status];
		}
		auto = false;
		pause = false;
	}
	
	public void plusminus(boolean plusminus){
		long Millis = 0;
		long millis = 0;
		if(-1 == status)//Anfang.
			Millis = planzeit[status+1].getTimeInMillis();
		else
			Millis = endzeit[status].getTimeInMillis();
		aktuell = new GregorianCalendar();
		if(plusminus)
			millis = Millis - aktuell.getTimeInMillis()+60000;
		else
			millis = Millis - aktuell.getTimeInMillis()-60000;

		aktuell = new GregorianCalendar();
		long milliAktuell = aktuell.getTimeInMillis();
		if(status == -1){
			startzeit = milliAktuell+millis;
			for(int i = 0; i < maxDaten-1; i++){
				if(i > 0){
					endzeit[i].setTimeInMillis(endzeit[i-1].getTimeInMillis()+diffMilliseconds[i]+1001);
				} else {
					endzeit[i].setTimeInMillis(startzeit+diffMilliseconds[i]+1001);
				}
			}
		} else {
			for(int i = status; i < maxDaten-1; i++){
				if(i > status){
					endzeit[i].setTimeInMillis(endzeit[i-1].getTimeInMillis()+diffMilliseconds[i]+1001);
				} else {
					endzeit[i].setTimeInMillis(milliAktuell+millis);
				}
			}
		}
		auto = false;
	}


	public void pause(){
		long Millis = 0;
		long millis = lastCountdown;
		if(pause){
			aktuell = new GregorianCalendar();
			long milliAktuell = aktuell.getTimeInMillis();
			if(status == -1){
				startzeit = milliAktuell+lastCountdown;
				for(int i = 0; i < maxDaten-1; i++){
					if(i > 0){
						endzeit[i].setTimeInMillis(endzeit[i-1].getTimeInMillis()+diffMilliseconds[i]+1001);
					} else {
						endzeit[i].setTimeInMillis(startzeit+diffMilliseconds[i]+1001);
					}
				}
			} else {
				for(int i = status; i < maxDaten-1; i++){
					if(i > status){
						endzeit[i].setTimeInMillis(endzeit[i-1].getTimeInMillis()+diffMilliseconds[i]+1001);
					} else {
						endzeit[i].setTimeInMillis(milliAktuell+lastCountdown);
					}
				}
			}
			pause = false;
		} else {
			Millis = 0;
			if(-1 == status)//Anfang.
				Millis = planzeit[status+1].getTimeInMillis();
			else
				Millis = endzeit[status].getTimeInMillis();
			aktuell = new GregorianCalendar();
			millis = Millis - aktuell.getTimeInMillis();
			lastCountdown = millis;//Letzter Countdown vor der Pause
			pause = true;			
		}
		auto = false;
	}
	
	public String wer(boolean jetzt){
		String back = "";
		if(status == -1){
			if(jetzt)
				back = "";
			else
				back = wer[0];
		} else {
			if(jetzt)
				back = wer[status];
			else
				back = wer[status+1];
		}
		if(null == back)
			back = "";
		return back;
	}
	
	public String was(boolean jetzt){
		String back = "";
		if(status == -1){
			if(jetzt)
				back = "";
			else
				back = was[0];
		} else {
			if(jetzt)
				back = was[status];
			else
				back = was[status+1];
		}
		if(null == back)
			back = "";
		return back;
	}
	
	public boolean mitFarbe(){
		return farbe;
	}
	
	public boolean rot(){
		return rot;
	}

	public String endzeit(){
		//Umschaltzeit anzeigen
		return zeitString;
	}

	public long getProzess(){
		long ausgabe = 0;
		if(!pause){
			if(vorStart){
				if(millis > 0){
					//ausgabe = millis/diffMilliseconds[status]*1000;
					ausgabe = 1000*millis/millisStart;
				}
			} else {
				if(millis > 0){
					//ausgabe = millis/diffMilliseconds[status]*1000;
					if(status >= 0 && status < maxStatus)
						ausgabe = 1000*millis/diffMilliseconds[status];
				}
			}
		}
		return ausgabe;
	}
	
	public void setExtraCountdown(int stunde, int minute, int sekunde){
		if(stunde >= 0 && stunde < 24)
			stundenECD = stunde;
		if(minute >= 0 && minute < 60)
			minutenECD = minute;
		if(sekunde >= 0 && sekunde < 60)
			sekundenECD = sekunde;
		extraCD = false;
	}

	public String getExtraCountdown(){
		String ausgabe = "";
		if(extraCD){
			if(!extraPause){
				long millis = 0;
				GregorianCalendar aktuell = new GregorianCalendar();
				millis = extraCountdownEndzeit - aktuell.getTimeInMillis();
				if(millis > 0){
					double diffDay = millis / 1000D / 60D / 60D / 24D;
					double diffHour = diffDay % 1 * 24;
					double diffMin = diffHour % 1 * 60;
					double diffSec = diffMin % 1 * 60;

					String minuteCD = zweiDigit(getMin(millis)); // Minute in der Stunde
					String stundeCD = zweiDigit(getHour(millis));
					String sekundeCD = zweiDigit(getSec(millis));

					if(millis > 3600000)
						ausgabe = ""+stundeCD+":"+minuteCD+":"+sekundeCD;
					else
						ausgabe = ""+minuteCD+":"+sekundeCD;
				} else {
					if(bs.getAutoExtra()){
						starteExtraCountdown(true);
						if(stundenECD > 0)
							ausgabe = ""+zweiDigit(stundenECD)+":"+zweiDigit(minutenECD)+":"+zweiDigit(sekundenECD);
						else
							ausgabe = ""+zweiDigit(minutenECD)+":"+zweiDigit(sekundenECD);
					} else {
						ausgabe = "00:00";
					}
				}
				extraText = ausgabe;
			} else {
				ausgabe = extraText;
			}
		} else {
			//Startwert des Countdowns anzeigen
			if(stundenECD > 0)
				ausgabe = ""+zweiDigit(stundenECD)+":"+zweiDigit(minutenECD)+":"+zweiDigit(sekundenECD);
			else
				ausgabe = ""+zweiDigit(minutenECD)+":"+zweiDigit(sekundenECD);
		}
		return ausgabe;
	}

	public void starteExtraCountdown(boolean plus){
		extraCD = true;
		extraPause = false;
		GregorianCalendar aktuell = new GregorianCalendar();
		extraCountdownEndzeit = aktuell.getTimeInMillis();
		if(plus)
			extraCountdownEndzeit = extraCountdownEndzeit + stundenECD*3600000+minutenECD*60000+sekundenECD*1000+1000;
		else
			extraCountdownEndzeit = extraCountdownEndzeit + stundenECD*3600000+minutenECD*60000+sekundenECD*1000;
	}

	public void stopExtraCountdown(){
		extraCD = true;
		extraCountdownEndzeit = 0;
	}

	public boolean zuLangsam(){
		boolean ausgabe = false;
		plusZeit = "P0";
		GregorianCalendar aktuell = new GregorianCalendar();
		if(status >= 0 && status < maxStatus){
			if(null != endprogrammzeit[status]){
				//if(aktuell.getTimeInMillis() > endprogrammzeit[status].getTimeInMillis()+60000)
				if(rot){
					if(aktuell.getTimeInMillis()-endprogrammzeit[status].getTimeInMillis() > 60000){
						ausgabe = true;
						//plusZeit = "+"+(endprogrammzeit[status].getTimeInMillis()-endzeit[status].getTimeInMillis());
						plusZeit = "+"+(aktuell.getTimeInMillis()-endprogrammzeit[status].getTimeInMillis())/60000;
					} else {
						plusZeit = "P1 "+(aktuell.getTimeInMillis()-endprogrammzeit[status].getTimeInMillis())/60000;;
					}
				} else {
					if(status > 0){
						if(meineStartzeit-endprogrammzeit[status-1].getTimeInMillis() > 60000 ){
							ausgabe = true;
							plusZeit = "+"+(meineStartzeit-endprogrammzeit[status-1].getTimeInMillis())/60000;
						} else {
							plusZeit = "P2 "+(meineStartzeit-endprogrammzeit[status-1].getTimeInMillis())/60000;
						}
					} else {
						if(meineStartzeit-programmStartzeit > 60000){
							ausgabe = true;
							plusZeit = "+"+(meineStartzeit-programmStartzeit)/60000;
						} else {
							plusZeit = "P3 "+(meineStartzeit-programmStartzeit)/60000;
						}
					}
				}
			} else {
				if(aktuell.getTimeInMillis()-programmStartzeit > 60000){
					ausgabe = true;
					plusZeit = "+"+(meineStartzeit-programmStartzeit)/60000;
				} else {
					plusZeit = "P4 = Null";
				}
			}
		} else {
			if(status == -1){
				if(aktuell.getTimeInMillis() > startzeit +60000){
					ausgabe = true;
					plusZeit = "+"+(aktuell.getTimeInMillis()-startzeit)/60000;
				} else {
					plusZeit = "P6";
				}
			} else {
				plusZeit = "P7";
			}
		}
		if(!showLate)
			ausgabe = false;
		return ausgabe;
	}

	public String wievielZuLangsam(){
		return plusZeit;
	}

	public void pauseExtraCountdown(){
		GregorianCalendar aktuell = new GregorianCalendar();
		if(extraPause){
			log.finer("ExtraPause Deaktiviert");
			extraPause = false;
			extraCountdownEndzeit = aktuell.getTimeInMillis();
			extraCountdownEndzeit = extraCountdownEndzeit + extraCountdownRestzeit;
		} else {
			log.finer("ExtraPause Aktiviert");
			extraPause = true;
			extraCountdownRestzeit = extraCountdownEndzeit - aktuell.getTimeInMillis();
		}
	}

	public void lateChange(boolean showLate){
		this.showLate = showLate;
	}

}


