import java.util.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.logging.*;

public class Eintrag extends JDialog{
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
	private JPanel mainPanel = new JPanel();
	private JPanel buttons = new JPanel();
	private JPanel comboPanel = new JPanel();
	private JPanel panelGlobal = new JPanel();//Alle Einstellungen für den gesamten Tag
	private JPanel panelFrei = new JPanel();//Wie lange frei? Von Bis, Taktung
	private JPanel panelPatient = new JPanel();//Patientenpanel, Stammdaten, Termine, Rezepte, 
	private JPanel notizPanel = new JPanel();
	private JPanel patientenPanel = new JPanel();
	private JPanel patientenPanel2 = new JPanel();//Namen und NEU
	private JLabel labelTag = new JLabel("Tag:");
	private JLabel labelVon = new JLabel("Von:");
	private JLabel labelBis = new JLabel("Bis:");
	private JLabel labelGlobal = new JLabel("Nur Ganztagesaktionen möglich!");
	private JLabel labelTelefon = new JLabel("");
	private JLabel labelTherapie = new JLabel("Therapie und wo:");
	private JTextField therapie = new JTextField();
	private JTextField kursname = new JTextField();
	private JTextField notiz = new JTextField();
	private JTextField vorname = new JTextField();
	private JTextField nachname = new JTextField();
	private JTextArea notizen = new JTextArea();
	private JButton ok = new JButton("OK");
	private JButton cancel = new JButton("Abbrechen");
	private JButton anTverschieben = new JButton("Verschiebe zu ");//Kurs und Patienten verschieben
	private JButton delete = new JButton("Löschen");//Löscht alles, setzt es auf FREI zurück
	private JButton neuB = new JButton("Neu");//Neuer Patient
	private JButton prufB = new JButton("Prüfen");//Prüfen, ob geht.
	private JComboBox comboTag = new JComboBox();
	private JComboBox vonZeit = new JComboBox();
	private JComboBox bisZeit = new JComboBox();
	private JComboBox patienten = new JComboBox();
	private JCheckBox packungCB = new JCheckBox("Packung");
	private JCheckBox geratCB = new JCheckBox("ET/US");
	private JRadioButton wahl1RB = new JRadioButton("so schnell wie möglich (alle Th.)");
	private JRadioButton wahl2RB = new JRadioButton("diese Woche, dieser Therapeut");
	private JRadioButton wahl3RB = new JRadioButton("nächste Woche, dieser Therapeut");
	private JRadioButton wahl4RB = new JRadioButton("in zwei Wochen, dieser Therapeut");
	private JRadioButton wahl5RB = new JRadioButton("in drei Wochen, dieser Therapeut");
	private JRadioButton wahl6RB = new JRadioButton("in vier Wochen, dieser Therapeut");
	private ButtonGroup wahlen = new ButtonGroup();
	private DateComboBox vonUrlaub, bisUrlaub;
	
	private Termin termin;
	private int therapeut;
	private int spalte = -1;//Eingabe
	private int globaleSpalte = -1;//Für Terminfeld
	private int zeile = -1;//Ist identisch mit Terminfeld
	private int oldindex = -1;
	private int theraKannDaNicht = 0;
	private boolean woche = false;//true = Wochenansicht ein Therapeut, false Tagesansicht ein Therapeut
	private boolean alle = false;//false normal, true Tagesansicht ALLE Therapeuten
	private boolean one = true;
	private boolean global = false;
	private boolean packung = false;
	private boolean vonbisda = true;
	private boolean update = true;
	private boolean noInit = false;
	private int rgt = 0;//Raum Gerät oder Termin dran schuld!
	public static final int RAUM   = 0;
	public static final int GERAT  = 1;
	public static final int TERMIN = 2;
	private KalenderFenster kalenderFenster;
	private PatientenFenster patientenFenster;
	//public final static String[] UHRZEIT = new String[86];
	
	private	JPanel line1 = new JPanel();
	private	JPanel line2 = new JPanel();
	private	JPanel vonbisPanel = new JPanel();
	private	JPanel kursPanel = new JPanel();
	private	JPanel urlauberPanel = new JPanel();


	//Patienten
	private JPanel stammdaten = new JPanel();
	private JPanel rezepte = new JPanel();
	private JPanel rezeptDatenPanel = new JPanel();
	private JPanel terminPanel = new JPanel();

	private JButton RezeptButton = new JButton("Rezepte");
	private JButton leerButton = new JButton("Patient speichern");
	private JButton neuButton = new JButton("Neu");
	private JButton speichernButton = new JButton("Speichern");
	private JButton delButton = new JButton("Löschen");
	private JButton neuTerminButton = new JButton("Neue Termine bei");

	private JTextField telefonFD = new JTextField();
	private JTextField telefon2FD = new JTextField();
	private JTextField telefon3FD = new JTextField();
	
	private JTextField birthFD = new JTextField(10);
	private JTextArea kommentarTA = new JTextArea();
	private JScrollPane kommentarSP = new JScrollPane(kommentarTA);
	private JTextArea termineTA = new JTextArea();
	private JScrollPane termineSP = new JScrollPane(termineTA, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,                                          JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS); 
	private Point point = new Point( 0, (int)(termineTA.getSize().getHeight()) );
	//termineSP.setViewportView(termineTA);
	//private JScrollPane termineSP = new JScrollPane(termineTA);
	private JComboBox HerrFrau = new JComboBox();
	
	private JLabel leer = new JLabel(" ");
	private JLabel leer2 = new JLabel(" ");
	private JLabel leer3 = new JLabel(" ");
	private JLabel leer4 = new JLabel(" ");
	private JLabel leer5 = new JLabel(" ");
	private JLabel leer6 = new JLabel(" ");
	private JLabel nameLabel = new JLabel("Name");
	private JLabel theraLabel = new JLabel("Therapeut");
	private JLabel nummer = new JLabel("000");
	private JLabel adressLabel = new JLabel("Adresse");
	private JLabel plzLabel = new JLabel("Postleitzahl");
	private JLabel ortLabel = new JLabel("Ort");
	private JLabel emailLabel = new JLabel("EMail");
	private JLabel telefonLabel = new JLabel("Telefon");
	private JLabel birthLabel = new JLabel("Geburtstag");
	private JLabel therapeutLabel = new JLabel("Therapeut");
	private JLabel krankenkassenLabel = new JLabel("Krankenkasse");
	private JLabel rezepteLabel = new JLabel("Rezepte");
	private JLabel kommentarLabel = new JLabel("Geschichte:");
	private JTabbedPane jt = new JTabbedPane();

	private JComboBox kasseCB = new JComboBox();
	private JComboBox theraCB = new JComboBox();
	private JComboBox theraTerminCB = new JComboBox();


	private Physiomat physiomat;
	private Date datum;
	private Daten daten;

	private Container c = this.getContentPane(); 
	private	GridBagLayout gbl = new GridBagLayout(); 
	private	GridBagLayout gbl2 = new GridBagLayout(); 
	private	GridBagLayout gbl3 = new GridBagLayout(); 

	static void addComponent( Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty ) { 
		GridBagConstraints gbc = new GridBagConstraints(); 
		gbc.fill = GridBagConstraints.BOTH; 
		gbc.gridx = x; gbc.gridy = y; 
		gbc.gridwidth = width; gbc.gridheight = height; 
		gbc.weightx = weightx; gbc.weighty = weighty; 
		gbl.setConstraints( c, gbc ); 
		cont.add( c ); 
	} 
	
	static void addComponent( Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height) 
	{ 
		GridBagConstraints gbc = new GridBagConstraints(); 
		gbc.fill = GridBagConstraints.BOTH; 
		gbc.gridx = x; gbc.gridy = y; 
		gbc.gridwidth = width; gbc.gridheight = height; 
		gbc.weightx = 1.0; gbc.weighty = 1.0; 
		gbl.setConstraints( c, gbc ); 
		cont.add( c ); 
	}

	public Eintrag(Physiomat physiomat, Daten daten, Date datum, int therapeut, int spalte, int zeile){
		super(physiomat, "Eintrag editieren", true);
		//Tageskalender
		this.physiomat = physiomat;
		kalenderFenster = physiomat.getKalenderFenster();
		patientenFenster = physiomat.getPatientenFenster();
		//Neu= Leer
		//this.setTitle("Eintrag editieren");
		
		//this.termin = termin;
		this.therapeut = therapeut;
		this.spalte = spalte;
		this.zeile = zeile;
		//this.woche = woche;//Ob aus dem Wochenkalender oder aus dem Tageskalender geklickt.
		this.datum = datum;
		this.daten = daten;
		initGUI();
	}
	
	public Eintrag(Physiomat physiomat, Daten daten, int therapeut, int spalte, int zeile, boolean global){
		super(physiomat, "Eintrag editieren", true);
		/*
			Alibi. Dies ist der erste Eintrag im Kalender. Hier werden globale Sachen eingetragen, wie Arbeitszeiten, Krankheiten,
			Urlaub
		*/
		//Neu= Leer
		//Wochenkalender
		this.physiomat = physiomat;
		kalenderFenster = physiomat.getKalenderFenster();
		patientenFenster = physiomat.getPatientenFenster();
		//this.termin = termin;
		this.therapeut = therapeut;
		this.spalte = spalte;
		this.zeile = zeile;
		this.woche = true;//Ob aus dem Wochenkalender oder aus dem Tageskalender geklickt.
		this.daten = daten;
		this.global = global;
		berechneDatum();//Tagesansicht, deswegen berechnen
		initGUI();
	}

	public Eintrag(Physiomat physiomat, Daten daten, int therapeut, int spalte, int zeile){
		super(physiomat, "Eintrag editieren", true);
		//Wochenkalender
		this.physiomat = physiomat;
		kalenderFenster = physiomat.getKalenderFenster();
		patientenFenster = physiomat.getPatientenFenster();
		//Neu= Leer
		//this.termin = termin;
		this.therapeut = therapeut;
		this.spalte = spalte;
		this.zeile = zeile;
		this.woche = true;//Ob aus dem Wochenkalender oder aus dem Tageskalender geklickt.
		this.daten = daten;
		berechneDatum();//Tagesansicht, deswegen berechnen
		initGUI();
	}
	
	public Eintrag(Physiomat physiomat, Daten daten, Date datum, int therapeut, int spalte, int zeile, boolean global){
		super(physiomat, "Eintrag editieren", true);
		/*
			Alibi. Dies ist der erste Eintrag im Kalender. Hier werden globale Sachen eingetragen, wie Arbeitszeiten, Krankheiten,
			Urlaub
		*/
		//Neu= Leer
		//Tageskalender
		this.physiomat = physiomat;
		kalenderFenster = physiomat.getKalenderFenster();
		patientenFenster = physiomat.getPatientenFenster();
		//this.termin = termin;
		this.therapeut = therapeut;
		this.spalte = spalte;
		this.zeile = zeile;
		//this.woche = woche;//Ob aus dem Wochenkalender oder aus dem Tageskalender geklickt.
		this.datum = datum;
		this.daten = daten;
		this.global = global;
		initGUI();
	}
	
	public Eintrag(boolean alle, Physiomat physiomat, Daten daten, Date datum, int therapeut, int spalte, int zeile){
		super(physiomat, "Eintrag editieren", true);
		//AlleTherapeuten
		this.alle = alle;
		this.physiomat = physiomat;
		kalenderFenster = physiomat.getKalenderFenster();
		patientenFenster = physiomat.getPatientenFenster();
		//Neu= Leer
		//this.termin = termin;
		this.therapeut = therapeut;
		this.spalte = spalte;
		this.zeile = zeile;
		//this.woche = woche;//Ob aus dem Wochenkalender oder aus dem Tageskalender geklickt.
		this.datum = datum;
		this.daten = daten;
		initGUI();
	}
	
	public Eintrag(boolean alle, Physiomat physiomat, Daten daten, Date datum, int therapeut, int spalte, int zeile, boolean global){
		super(physiomat, "Eintrag editieren", true);
		/*
			Alibi. Dies ist der erste Eintrag im Kalender. Hier werden globale Sachen eingetragen, wie Arbeitszeiten, Krankheiten,
			Urlaub
		*/
		//Neu= Leer
		//Alle Therapeuten
		this.alle = alle;
		this.physiomat = physiomat;
		kalenderFenster = physiomat.getKalenderFenster();
		patientenFenster = physiomat.getPatientenFenster();
		//this.termin = termin;
		this.therapeut = therapeut;
		this.spalte = spalte;
		this.zeile = zeile;
		//this.woche = woche;//Ob aus dem Wochenkalender oder aus dem Tageskalender geklickt.
		this.datum = datum;
		this.daten = daten;
		this.global = global;
		initGUI();
	}
	
	
	private void initGUI(){
		//Funktioniert System.out.println("Test in Eintrag.java für Umleiten der Ausgabe in Loggdateien.\n");
		this.setBounds(0,0,900,450);
		daten.nichtSpeichern(Daten.EINTRAG);
		setLocationRelativeTo(null);
		mainPanel.setLayout(gbl);
		
		c.setLayout(new BoxLayout(c, BoxLayout.Y_AXIS)); 
		patientenPanel2.setLayout(new FlowLayout()); 
		//buttons.setLayout(gbl);
		
		//addComponent( panel1 , gbl, new JLabel("Panel1! Hahaha"), 0, 0, 1, 1);
		//addComponent( panel2 , gbl, new JLabel("Panel2! oooohhh"), 0, 0, 1, 1);

		/*
		line1.add(comboTag);
		line1.add(ok);
		line1.add(cancel);
		line1.add(delete);
		*/
		
		kommentarTA.setLineWrap(true);
		kommentarTA.setWrapStyleWord(true);
		termineTA.setLineWrap(true);
		termineTA.setWrapStyleWord(true);
		notizen.setLineWrap(true);
		notizen.setWrapStyleWord(true);

		line2.add(labelTag);

		vonbisPanel.add(labelVon);
		vonbisPanel.add(vonZeit);
		vonbisPanel.add(labelBis);
		vonbisPanel.add(bisZeit);
		//kursname.
		kursPanel.setLayout(new BoxLayout(kursPanel, BoxLayout.Y_AXIS)); 
		kursPanel.add(kursname);

		notizPanel.setLayout(new BoxLayout(notizPanel, BoxLayout.Y_AXIS)); 
		notizPanel.add(notiz);
		notizPanel.add(notizen);


		stammdaten.setLayout(gbl2);
		addComponent( stammdaten, gbl2, theraLabel, 0, 2, 1, 1);
		addComponent( stammdaten, gbl2, theraCB, 1, 2, 1, 1);
		//addComponent( stammdaten, gbl2, dauerpatient, 2, 2, 1, 1);
		addComponent( stammdaten, gbl2, telefonLabel, 0, 3, 1, 1);
		addComponent( stammdaten, gbl2, telefonFD, 1, 3, 1, 1);
		addComponent( stammdaten, gbl2, telefon2FD, 1, 4, 1, 1);
		addComponent( stammdaten, gbl2, telefon3FD, 1, 5, 1, 1);
		addComponent( stammdaten, gbl2, birthLabel, 0, 6, 1, 1);
		addComponent( stammdaten, gbl2, birthFD, 1, 6, 1, 1);
		addComponent( stammdaten, gbl2, kommentarLabel, 0, 7, 1, 1);
		kommentarSP.setPreferredSize(new Dimension(150,100));
		addComponent( stammdaten, gbl2, kommentarSP, 1, 7, 2, 7);
		addComponent( stammdaten, gbl2, leer5, 0, 8, 1, 1);
		addComponent( stammdaten, gbl2, leer6, 0, 9, 1, 1);
		addComponent( stammdaten, gbl2, leer2, 0, 10, 1, 1);
		addComponent( stammdaten, gbl2, leer3, 0, 11, 1, 1);
		addComponent( stammdaten, gbl2, leer4, 0, 12, 1, 1);
		//Kommt noch, später
		//addComponent( stammdaten, gbl2, leerButton, 3, 3, 1, 1);
		//addComponent( stammdaten, gbl2, neuButton, 3, 4, 1, 1);
		//addComponent( stammdaten, gbl2, speichernButton, 3, 5, 1, 1);
		//addComponent( stammdaten, gbl2, delButton, 3, 6, 1, 1);
		
		
		//terminPanel.setLayout(new BoxLayout(terminPanel, BoxLayout.Y_AXIS)); 
		termineSP.setPreferredSize(new Dimension(150,100));
		          //setPreferredSize
		terminPanel.setLayout(new BorderLayout());
		terminPanel.add(termineSP, BorderLayout.CENTER);
		
		rezeptDatenPanel.setLayout(gbl3);
		/*
		rezeptDatenPanel.setLayout(new BoxLayout(rezeptDatenPanel, BoxLayout.Y_AXIS)); 
		rezeptDatenPanel.add(labelTherapie);
		rezeptDatenPanel.add(therapie);
		rezeptDatenPanel.add(packungCB);
		rezeptDatenPanel.add(geratCB);
		*/
		addComponent( rezeptDatenPanel, gbl3, labelTherapie , 0, 0, 2, 1);
		addComponent( rezeptDatenPanel, gbl3, therapie , 0, 1, 2, 1);
		addComponent( rezeptDatenPanel, gbl3, packungCB, 0, 2, 2, 1);
		addComponent( rezeptDatenPanel, gbl3, geratCB, 0, 3, 2, 1);
		addComponent( rezeptDatenPanel, gbl3, anTverschieben, 0, 5, 1, 1);
		addComponent( rezeptDatenPanel, gbl3, neuTerminButton, 1, 5, 1, 1);
		addComponent( rezeptDatenPanel, gbl3, theraTerminCB, 0, 6, 2, 1);
		addComponent( rezeptDatenPanel, gbl3, wahl1RB, 0, 7, 2, 1);
		addComponent( rezeptDatenPanel, gbl3, wahl2RB, 0, 8, 2, 1);
		addComponent( rezeptDatenPanel, gbl3, wahl3RB, 0, 9, 2, 1);
		addComponent( rezeptDatenPanel, gbl3, wahl4RB, 0, 10, 2, 1);
		addComponent( rezeptDatenPanel, gbl3, wahl5RB, 0, 11, 2, 1);
		addComponent( rezeptDatenPanel, gbl3, wahl6RB, 0, 12, 2, 1);
		
		wahlen.add(wahl1RB);
		wahlen.add(wahl2RB);
		wahlen.add(wahl3RB);
		wahlen.add(wahl4RB);
		wahlen.add(wahl5RB);
		wahlen.add(wahl6RB);
		
		
		//rezepte.setLayout(new BoxLayout(rezepte, BoxLayout.X_AXIS)); 
		rezepte.add(rezeptDatenPanel);
		
		
		//jt.setAutoscrolls(true);
		//termineSP.getViewport().setViewPosition( point );
		
		jt.addTab("Stammdaten",stammdaten);
		jt.addTab("Termine",terminPanel);
		jt.addTab("Rezept", rezepte);
		
		vonUrlaub = new DateComboBox(new Date());
		//vonUrlaub.setDate(new Date());
		bisUrlaub = new DateComboBox(new Date());
		//bisUrlaub.setDate(new Date())
		
		urlauberPanel.add(vonUrlaub);
		urlauberPanel.add(bisUrlaub);

		patientenPanel2.add(patienten);
		patientenPanel2.add(labelTelefon);
		patientenPanel2.add(leerButton);
		patientenPanel2.add(neuB);
		patientenPanel.add(jt);
		
		leerButton.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					//zeigePatient();
					save();
				}
			} 
		);
		neuB.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					zeigePatient();
				}
			} 
		);
		
		neuTerminButton.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					diesenTerminNeu();
				}
			} 
		);
		anTverschieben.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					verschiebeZu();
				}
			} 
		);

		/*
		mainPanel.add(line1);
		mainPanel.add(line2);
		mainPanel.add(vonbisPanel);
		*/

		
		
		//c.add(kursname);

		addComponent( mainPanel, gbl, comboTag, 0, 0, 1, 1);
		addComponent( mainPanel, gbl, ok, 1, 0, 1, 1);
		addComponent( mainPanel, gbl, cancel, 2, 0, 1, 1);
		addComponent( mainPanel, gbl, delete, 3, 0, 1, 1);
		addComponent( mainPanel, gbl, prufB, 3, 1, 1, 1);
		addComponent( mainPanel, gbl, labelTag, 0,1,3,1);
		addComponent( mainPanel, gbl, vonbisPanel, 0,2,3,1);

		c.add(mainPanel);
		
		
		for(int i=0; i < Termin.WERTE.length; i++)
			comboTag.addItem(Termin.WERTE[i]);
		
		comboTag.setMaximumRowCount(Termin.WERTE.length);

		comboTag.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					panelTausch();
				}
			} 
		);
		
		patienten.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					fuelleDaten();
				}
			} 
		);
		
		//cancel.addActionListener(new EintragActionAdapter(this));
		cancel.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					cancel();
				}
			} 
		);

		delete.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					logger.finest("Betreten");
					int index = comboTag.getSelectedIndex();
					String was = "";
					switch (index){
						case Termin.KEINEARBEITSZEIT : was = "nichts";break;
						case Termin.PATIENT : was = "den Patiententermin"; break;
						case Termin.KURS : was = "den Kurs";break;
						case Termin.NOTIZ : was = "die Notiz"; break;
						case Termin.ANMELDUNG : was = "den Bürodienst"; break;
						case Termin.URLAUB : was = "den Urlaub"; break;
						case Termin.SCHULUNG : was = "die Schulung"; break;
						case Termin.KRANK : was = "die Krankheit"; break;
						case Termin.PAUSE : was = "die Pause"; break;
						case Termin.FEIERTAG : was = "den Feiertag"; break;
						case Termin.TEAM : was = "die Teamsitzung"; break;
					}
					int antwort = JOptionPane.showConfirmDialog(physiomat, "Möchten Sie wirklich "+was+" löschen?",
						"Löschen", JOptionPane.YES_NO_OPTION,
						JOptionPane.YES_NO_OPTION);
					if(antwort == 0){
						//Ja, löschen
						int von = termin.getVonZeit();
						int bis = termin.getBisZeit();
						if(von == -1 || bis == -1){
							von = zeile;
							bis = zeile +1;
						}
						Termin neuTermin = new Termin(termin.getOldArt());
						switch(index){
							case Termin.TEAM:
								neuTermin.setArt(Termin.KEINEARBEITSZEIT);
								for(int j = 0; j < daten.getMaxTherapeuten(); j++){
									for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
										daten.setTermin(globaleSpalte, i, j, 0, neuTermin);
										daten.setTermin(globaleSpalte, i, j, 1, neuTermin);
									}
								}
								break;
							case Termin.PATIENT:
								Termin vergleich;
								for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
									vergleich = daten.getTermin(globaleSpalte, i, therapeut, 0);
									if(vergleich == termin)
										daten.setTermin(globaleSpalte, i, therapeut, 0, new Termin(termin.getOldArt()));
									vergleich = daten.getTermin(globaleSpalte, i, therapeut, 1);
									if(vergleich.getArt() == Termin.KEINEARBEITSZEIT)
										daten.setTermin(globaleSpalte, i, therapeut, 1, new Termin(Termin.FREI));
									if(vergleich == termin)
										daten.setTermin(globaleSpalte, i, therapeut, 1, new Termin(termin.getOldArt()));
								}
								if((von-1) > 0){
									vergleich = daten.getTermin(globaleSpalte, von-1, therapeut, 1);
									if(vergleich.getArt() == Termin.KEINEARBEITSZEIT)
										daten.setTermin(globaleSpalte, von-1, therapeut, 1, new Termin(Termin.FREI));
									vergleich = daten.getTermin(globaleSpalte, von, therapeut, 1);
									if(vergleich.getArt() == Termin.KEINEARBEITSZEIT)
										daten.setTermin(globaleSpalte, von, therapeut, 1, new Termin(Termin.FREI));
								}
								Calendar calR = Calendar.getInstance();
								calR.setTime(daten.getDate(globaleSpalte));
								int year = calR.get(Calendar.YEAR);
								int month = calR.get(Calendar.MONTH)+1;
								int day = calR.get(Calendar.DAY_OF_MONTH);
								String termininfo = "";
								if(von == -1)
									termininfo = ""+day+"."+month+"."+year+" : Fehlerhafte Uhrzeit";
								else
									termininfo = ""+day+"."+month+"."+year+" um "+daten.UHRZEIT[von]+" bis "+daten.UHRZEIT[bis];
								calR.setTime(new Date());
								year = calR.get(Calendar.YEAR);
								month = calR.get(Calendar.MONTH)+1;
								day = calR.get(Calendar.DAY_OF_MONTH);
								int hour = calR.get(Calendar.HOUR_OF_DAY);
								int minute = calR.get(Calendar.MINUTE);
								termin.getPatient().addTermin("G: "+day+"."+month+"."+year+"("+hour+":"+minute+")\n"+termininfo);
								daten.getTherapeut(therapeut).addTermine("G: "+day+"."+month+"."+year+"("+hour+":"+minute+")\n"+"Patient "+patienten.getSelectedItem()+" "+termininfo);
								logger.info("Patient "+patienten.getSelectedItem()+" am "+termininfo+" gelöscht.");
								break;
							default:
								if(zeile == 0){
									daten.setTermin(globaleSpalte, 0, therapeut, 0, new Termin(termin.getOldArt()));
									daten.setTermin(globaleSpalte, 0, therapeut, 1, new Termin(termin.getOldArt()));
								} else {
									for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
										daten.setTermin(globaleSpalte, i, therapeut, 0, new Termin(termin.getOldArt()));
										//daten.setTermin(globaleSpalte, i, therapeut, 1, new Termin(termin.getOldArt()));
									}
									int start = von-2;
									int ende = bis-2;
									if(start+1 <=0)
										start = von;
									//if((bis-von) > 2)
									for(int i = start+1; i < ende+1; i++){
										//Packungen entfernen, weil die freien Plätze verwirren
										daten.setTermin(globaleSpalte, i, therapeut, 1, new Termin(termin.getOldArt()));
									}
								}
								break;
						}
						logger.finest("Termin "+was+" wurde gelöscht");
						daten.setUpdate();
						cancel();
					} else {
						//nein, so lassen
					}
				}
			} 
		);
		
		ok.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					ok();
				}
			} 
		);
		prufB.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					prufIt();
				}
			} 
		);
		
		c.add(buttons);
		c.add(comboPanel);
		//c.add(panel1);
		init();
		pack();
		noInit = true;
		fuelleDaten();
		this.setVisible(true);
	}
	
	;
	
	public void init(){
		logger.finest("Betreten");
		int j = 0;
		for(int i = 7; i < 10; i++){
			vonZeit.addItem("0"+i+":00");
			bisZeit.addItem("0"+i+":00");
			vonZeit.addItem("0"+i+":10");
			bisZeit.addItem("0"+i+":10");
			vonZeit.addItem("0"+i+":20");
			bisZeit.addItem("0"+i+":20");
			vonZeit.addItem("0"+i+":30");
			bisZeit.addItem("0"+i+":30");
			vonZeit.addItem("0"+i+":40");
			bisZeit.addItem("0"+i+":40");
			vonZeit.addItem("0"+i+":50");
			bisZeit.addItem("0"+i+":50");
		}
		for(int i = 10; i < 21; i++){
			vonZeit.addItem(""+i+":00");
			bisZeit.addItem(""+i+":00");
			vonZeit.addItem(""+i+":10");
			bisZeit.addItem(""+i+":10");
			vonZeit.addItem(""+i+":20");
			bisZeit.addItem(""+i+":20");
			vonZeit.addItem(""+i+":30");
			bisZeit.addItem(""+i+":30");
			vonZeit.addItem(""+i+":40");
			bisZeit.addItem(""+i+":40");
			vonZeit.addItem(""+i+":50");
			bisZeit.addItem(""+i+":50");
		}
		vonZeit.addItem("21:00");
		bisZeit.addItem("21:00");
		
		if(woche){
			globaleSpalte = daten.getWochenAnfang()+((spalte-1)/2);
			datum = new Date(daten.getWochenStartTag().getTime().getTime());
			Calendar cal = Calendar.getInstance();
			cal.setTime(datum);
			cal.add(Calendar.DATE, ((spalte-1)/2));//richtig, da Datum.
			datum = new Date(cal.getTime().getTime());
			if(spalte % 2 == 0)
				packung = true;//modulo(spalte,2);//modulo 2 ganzzahlig
		} else if(alle){
			/*Alle Therapeuten, Datum ist gesetzt, Packung ergibt sich aus dem Termin
			*/
			logger.finest("Eintrag \"alle Therapeuten\"");
			globaleSpalte = daten.getSpalte(datum);
			//therapeut = spalte-1;
			termin = daten.getTermin(globaleSpalte, zeile, therapeut, 0);
			
			if(termin.getArt() == Termin.PATIENT)
				packung = termin.getPackung();
		} else {
			//Hier muss noch das Datum bestimmt werden:
			//datum = (Wird Global übergeben)
			globaleSpalte = daten.getWochenTag();
			if(spalte == 3)
				packung = true;
		}
		vonUrlaub.setDate(datum);
		bisUrlaub.setDate(datum);
		if(packung)
			logger.finest("Packungspatient\nDatum: "+datum+"\nSpalte: "+spalte+"\nGSpalte: "+globaleSpalte+"\n"+(((spalte-1)/2)-1));
		else
			logger.finest("Datum: "+datum+"\nSpalte: "+spalte+"\nGSpalte: "+globaleSpalte+"\n"+(((spalte-1)/2)-1)+"\nTherapeut: "+therapeut);
		if(packung)
			termin = daten.getTermin(globaleSpalte, zeile, therapeut, 1);
		else 
			termin = daten.getTermin(globaleSpalte, zeile, therapeut, 0);
		comboTag.setSelectedIndex(termin.getArt());
		Calendar cal = Calendar.getInstance();
		cal.setTime(datum);
		//labelTag.setText("Datum: "+datum);
		labelTag.setText("Datum: "+cal.get(Calendar.DAY_OF_MONTH)+". "+(cal.get(Calendar.MONTH)+1)+". "+cal.get(Calendar.YEAR));
		Patient p, p2;
		String next = "";
		String nun = "";
		boolean doppelt = false;
		int c = 1;
		for(int i = 0; i < daten.getMaxPatienten(); i++){
			p = daten.getPatient(i);
			nun = ""+p.getNachname()+", "+p.getVorname();
			if((i+1)< daten.getMaxPatienten()){
				p2 = daten.getPatient(i+1);
				next = ""+p2.getNachname()+", "+p2.getVorname();
				if(nun.equals(next)){
					nun = nun+"["+c+++"] "+p.getGeburtstag();//nun = nun+"("+c+++")";
					doppelt = true;
				} else if(doppelt){
					nun = nun+"["+c+++"] "+p.getGeburtstag();//nun = nun+"("+c+++")";
					doppelt = false;
				}
			}
			patienten.addItem(nun);
		}
		Therapeut t;
		theraCB.addItem("Kein");
		for(int i = 0; i < daten.getMaxTherapeuten(); i++){
			t = daten.getTherapeut(i);
			theraCB.addItem(t.getVorname()+" "+t.getNachname());
			theraTerminCB.addItem(t.getVorname()+" "+t.getNachname());
		}
		anTverschieben.setEnabled(false);
		neuTerminButton.setEnabled(false);
		wahl1RB.setEnabled(false);
		wahl2RB.setEnabled(false);
		wahl3RB.setEnabled(false);
		wahl4RB.setEnabled(false);
		wahl5RB.setEnabled(false);
		wahl6RB.setEnabled(false);
		/*
		birthFD.setEnabled(false);
		telefonFD.setEnabled(false);
		telefon2FD.setEnabled(false);
		telefon3FD.setEnabled(false);
		kommentarTA.setEnabled(false);
		termineTA.setEnabled(false);
		*/
		if(packung)
			packungCB.setSelected(true);
		switch (termin.getArt()){
			case Termin.KURS : kursname.setText(termin.getKurs());break;
			case Termin.PATIENT : 
					if(termin.getPackung()){
						packung=true;
						packungCB.setSelected(true);
					}
					patienten.setSelectedIndex(daten.getTerminPatient(termin.getPatient()));
					therapie.setText(termin.therapie());
					packung = termin.getPackung();
					vonZeit.setEnabled(false);
					bisZeit.setEnabled(false);
					comboTag.setEnabled(false);
					patienten.setEnabled(false);
					neuB.setEnabled(false);
					prufB.setEnabled(false);
					theraCB.setSelectedIndex(termin.getPatient().getTherapeut());
					theraTerminCB.setSelectedIndex(daten.getAktivenTherapeuten());//termin.getPatient().getTherapeut());
					anTverschieben.setEnabled(true);
					neuTerminButton.setEnabled(true);
					wahl1RB.setEnabled(true);
					wahl2RB.setEnabled(true);
					wahl3RB.setEnabled(true);
					wahl4RB.setEnabled(true);
					wahl5RB.setEnabled(true);
					wahl6RB.setEnabled(true);
					wahl3RB.setSelected(true);
					packungCB.setEnabled(false);
					geratCB.setEnabled(false);
					ok.setEnabled(false);
					if(termin.getGeraet() > 0)
						geratCB.setSelected(true);
					break;
			case Termin.NOTIZ: notiz.setText(termin.getNotiz());notizen.setText(termin.getNotizen());break;
				
		}
		if(termin.getVonZeit() == -1){
			if(zeile > 0)
			vonZeit.setSelectedIndex(zeile-1);
			if(zeile < 85)
				if(packung) {
					bisZeit.setSelectedIndex(zeile+3);//zwanzig Minutentakt plus Packung am Anfang
					comboTag.setSelectedIndex(Termin.PATIENT);//Wenn neu und auf Packung geklickt, dann kann es nur ein Patient sein.
				} else
					bisZeit.setSelectedIndex(zeile+1);//zwanzig Minutentakt
		} else {
			vonZeit.setSelectedIndex(termin.getVonZeit());
			bisZeit.setSelectedIndex(termin.getBisZeit());
		}
		
	}

	public void ok(){
		//panelZeigen();
		logger.finest("Betreten");
		int index = comboTag.getSelectedIndex();
		int oldvon = termin.getVonZeit();
		int oldbis = termin.getBisZeit();
		int oldart = termin.getOldArt();
		int von = vonZeit.getSelectedIndex();
		int bis = bisZeit.getSelectedIndex();
		boolean spring = true;
		if(pruefen()){
			Termin leerTermin = new Termin();
			switch (index){
				case Termin.KEINEARBEITSZEIT : 
					termin = new Termin(Termin.KEINEARBEITSZEIT);
					termin.setOldArt(Termin.KEINEARBEITSZEIT);
					for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
						termin = new Termin(Termin.KEINEARBEITSZEIT);
						termin.setOldArt(Termin.KEINEARBEITSZEIT);
						daten.setTermin(globaleSpalte, i, therapeut, 0, termin);
						termin = new Termin(Termin.KEINEARBEITSZEIT);
						termin.setOldArt(Termin.KEINEARBEITSZEIT);
						//daten.setTermin(globaleSpalte, i, therapeut, 1, leerTermin);
						daten.setTermin(globaleSpalte, i, therapeut, 1, termin);
					}
					//termin.setZeit(von, bis);
					logger.finest("Freie Termine gelöscht.");
					break;
				case Termin.FREI : 
					termin = new Termin(Termin.FREI);
					termin.setOldArt(Termin.FREI);
					for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
						termin = new Termin(Termin.FREI);
						termin.setOldArt(Termin.FREI);
						daten.setTermin(globaleSpalte, i, therapeut, 0, termin);
						termin = new Termin(Termin.FREI);
						termin.setOldArt(Termin.FREI);
						daten.setTermin(globaleSpalte, i, therapeut, 1, termin);
					}
					//termin.setZeit(von, bis);
					logger.finest("Freie Termine erstellt.");
					break;
				case Termin.KURS : /*Termin eintragen, Kurs belegen */
					termin = new Termin(Termin.KURS);
					termin.setKurs(kursname.getText());
					termin.setOldArt(oldart);
						
					for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
						daten.setTermin(globaleSpalte, i, therapeut, 0, termin);
						//daten.setTermin(globaleSpalte, i, therapeut, 1, leerTermin);//Leertermin weiter unten
					}
					termin.setZeit(von, bis);
					logger.finest("Kurs angemalt");
					int start = von-2;
					int ende = bis-2;
					if(start+1 <=0)
						start = von;
					//if((bis-von) > 2)
						for(int i = start+1; i < ende+1; i++){
						//Packungen entfernen, weil die freien Plätze verwirren
						daten.setTermin(globaleSpalte, i, therapeut, 1, new Termin());
					}
					break;
				case Termin.PAUSE : 
					termin = new Termin(Termin.PAUSE);
					termin.setOldArt(oldart);
					for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
						daten.setTermin(globaleSpalte, i, therapeut, 0, termin);
						//daten.setTermin(globaleSpalte, i, therapeut, 1, leerTermin);
					}
					termin.setZeit(von, bis);
					logger.finest("Pause erstellt.");
					start = von-2;
					ende = bis-2;
					if(start+1 <=0)
						start = von;
					//if((bis-von) > 2)
						for(int i = start+1; i < ende+1; i++){
						//Packungen entfernen, weil die freien Plätze verwirren
						daten.setTermin(globaleSpalte, i, therapeut, 1, new Termin());
					}
					break;
				case Termin.ANMELDUNG : 
					termin = new Termin(Termin.ANMELDUNG);
					termin.setOldArt(oldart);
					for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
						daten.setTermin(globaleSpalte, i, therapeut, 0, termin);
						daten.setTermin(globaleSpalte, i, therapeut, 1, leerTermin);
					}
					termin.setZeit(von, bis);
					logger.finest("Anmeldung erstellt.");
					break;
				case Termin.NOTIZ : 
					termin = new Termin(Termin.NOTIZ);
					termin.setOldArt(oldart);
					termin.setNotizen(notiz.getText(), notizen.getText());
					for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
						daten.setTermin(globaleSpalte, i, therapeut, 0, termin);
						daten.setTermin(globaleSpalte, i, therapeut, 1, leerTermin);
					}
					termin.setZeit(von, bis);
					logger.finest("Pause erstellt.");
					break;
				case Termin.URLAUB : 
					termin = new Termin(Termin.URLAUB);
					termin.setOldArt(oldart);
					int vonDatum = daten.getSpalte(vonUrlaub.getDate());
					int bisDatum = daten.getSpalte(bisUrlaub.getDate());
					if(vonDatum > bisDatum){
						int tausch = vonDatum;
						vonDatum = bisDatum;
						bisDatum = tausch;
					}
					if(vonDatum == bisDatum){
						//Zeile ist 0
						//daten.setTermin(globaleSpalte, 0, therapeut, 0, termin);
						//daten.setTermin(globaleSpalte, 0, therapeut, 1, leerTermin);
						daten.setTermin(vonDatum, 0, therapeut, 0, termin);
						daten.setTermin(vonDatum, 0, therapeut, 1, leerTermin);
					} else {
						for(int i = vonDatum; i <= bisDatum; i++){
							daten.setTermin(i, 0, therapeut, 0, termin);
							daten.setTermin(i, 0, therapeut, 1, leerTermin);
						}
					}
					von = 0; bis = 0;
					spring = false;
					logger.finest("Urlaub erstellt.");
					break;
				case Termin.SCHULUNG : 
					termin = new Termin(Termin.SCHULUNG);
					termin.setOldArt(oldart);
					vonDatum = daten.getSpalte(vonUrlaub.getDate());
					bisDatum = daten.getSpalte(bisUrlaub.getDate());
					if(vonDatum > bisDatum){
						int tausch = vonDatum;
						vonDatum = bisDatum;
						bisDatum = tausch;
					}
					if(vonDatum == bisDatum){
						//Zeile ist 0
						daten.setTermin(vonDatum, 0, therapeut, 0, termin);
						daten.setTermin(vonDatum, 0, therapeut, 1, leerTermin);
					} else {
						for(int i = vonDatum; i <= bisDatum; i++){
							daten.setTermin(i, 0, therapeut, 0, termin);
							daten.setTermin(i, 0, therapeut, 1, leerTermin);
						}
					}
					von = 0; bis = 0;
					spring = false;
					logger.finest("Schulung erstellt.");
					break;
				case Termin.KRANK : 
					termin = new Termin(Termin.KRANK);
					termin.setOldArt(oldart);
					//Zeile ist 0
					vonDatum = daten.getSpalte(vonUrlaub.getDate());
					bisDatum = daten.getSpalte(bisUrlaub.getDate());
					if(vonDatum > bisDatum){
						int tausch = vonDatum;
						vonDatum = bisDatum;
						bisDatum = tausch;
					}
					if(vonDatum == bisDatum){
						//Zeile ist 0
						daten.setTermin(vonDatum, 0, therapeut, 0, termin);
						daten.setTermin(vonDatum, 0, therapeut, 1, leerTermin);
					} else {
						for(int i = vonDatum; i <= bisDatum; i++){
							daten.setTermin(i, 0, therapeut, 0, termin);
							daten.setTermin(i, 0, therapeut, 1, leerTermin);
						}
					}
					von = 0; bis = 0;
					spring = false;
					logger.finest("Krankheit eingeschrieben.");
					break;
				case Termin.FEIERTAG : 
					termin = new Termin(Termin.FEIERTAG);
					termin.setOldArt(oldart);
					//Zeile ist 0
					vonDatum = daten.getSpalte(vonUrlaub.getDate());
					bisDatum = daten.getSpalte(bisUrlaub.getDate());
					if(vonDatum > bisDatum){
						int tausch = vonDatum;
						vonDatum = bisDatum;
						bisDatum = tausch;
					}
					if(vonDatum == bisDatum){
						//Zeile ist 0
						daten.setTermin(vonDatum, 0, therapeut, 0, termin);
						daten.setTermin(vonDatum, 0, therapeut, 1, leerTermin);
					} else {
						for(int i = vonDatum; i <= bisDatum; i++){
							daten.setTermin(i, 0, therapeut, 0, termin);
							daten.setTermin(i, 0, therapeut, 1, leerTermin);
						}
					}
					von = 0; bis = 0;
					spring = false;
					logger.finest("Feiertag eingeschrieben.");
					break;
				case Termin.TEAM :
					termin = new Termin(Termin.TEAM);
					termin.setZeit(von, bis);
					spring = false;
					for(int j = 0; j < daten.getMaxTherapeuten(); j++){
						for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
							daten.setTermin(globaleSpalte, i, j, 0, termin);
						}
					}
					break;
				case Termin.PATIENT :
					termin = new Termin(Termin.PATIENT);
					termin.setPatient(daten.getPatient(patienten.getSelectedIndex()), packung);
					termin.setPackung(packung);
					termin.setTherapie(therapie.getText());
					if(packung){
						for(int i = von+1; i < von+3; i++){//Packung
							daten.setTermin(globaleSpalte, i, therapeut, 1, termin);
						}
						for(int i = von+3; i < bis+1; i++){//Behandlung
							daten.setTermin(globaleSpalte, i, therapeut, 0, termin);
							if(i < bis-1)
								daten.setTermin(globaleSpalte, i, therapeut, 1, new Termin(Termin.KEINEARBEITSZEIT));
						}
					} else {
						termin.setOldArt(oldart);
						for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
							daten.setTermin(globaleSpalte, i, therapeut, 0, termin);
						}
						start = von-2;
						ende = bis-2;
						if(start+1 <=0)
							start = von;
						//if((bis-von) > 2)
							for(int i = start+1; i < ende+1; i++){
							//Packungen entfernen, weil die freien Plätze verwirren
							daten.setTermin(globaleSpalte, i, therapeut, 1, new Termin(Termin.KEINEARBEITSZEIT));
						}
					}
					termin.setZeit(von, bis);
					termin.setRaum(1);
					if(geratCB.isSelected())
						termin.setGeraet(1);
					else
						termin.setGeraet(0);
					Calendar calR = Calendar.getInstance();
					calR.setTime(daten.getDate(globaleSpalte));
					int year = calR.get(Calendar.YEAR);
					int month = calR.get(Calendar.MONTH)+1;
					int day = calR.get(Calendar.DAY_OF_MONTH);
					String termininfo = ""+day+"."+month+"."+year+" um "+daten.UHRZEIT[von]+" bis "+daten.UHRZEIT[bis];
					calR = Calendar.getInstance();
					calR.setTime(new Date());
					year = calR.get(Calendar.YEAR);
					month = calR.get(Calendar.MONTH)+1;
					day = calR.get(Calendar.DAY_OF_MONTH);
					int hour = calR.get(Calendar.HOUR_OF_DAY);
					int minute = calR.get(Calendar.MINUTE);
					termin.getPatient().addTermin("E: "+day+"."+month+"."+year+"("+hour+":"+minute+")\n"+termininfo);
					daten.getTherapeut(therapeut).addTermine("E: "+day+"."+month+"."+year+"("+hour+":"+minute+")\n"+"Patient "+patienten.getSelectedItem()+" "+termininfo);
					logger.info("Patient "+patienten.getSelectedItem()+" am "+termininfo+" eingeordnet.");
					//zu Patiententermin hinzufügen
					break;
			}
			
			if((oldbis < von || oldvon > bis) && (oldvon != -1) && (spring)){
				int antwort = JOptionPane.showConfirmDialog(physiomat, "Möchten Sie den anderen Termin behalten?","Alten Termin Löschen/ Behalten.", JOptionPane.YES_NO_OPTION, JOptionPane.YES_NO_OPTION);
				logger.finest("Antwort: "+antwort);
				if(antwort == 0)
					spring = false;
			}
			if(von > oldvon && oldvon != -1 && spring)
				for(int i = oldvon+1; i < von+1; i++){//Zeile in daten ist eins höher
					leerTermin = new Termin(oldart);
					daten.setTermin(globaleSpalte, i, therapeut, 0, leerTermin);
					leerTermin = new Termin(oldart);
					daten.setTermin(globaleSpalte, i, therapeut, 1, leerTermin);
				}
			if(oldbis > bis && spring)
				for(int i = bis+1; i < oldbis+1; i++){//Zeile in daten ist eins höher
					leerTermin = new Termin(oldart);
					daten.setTermin(globaleSpalte, i, therapeut, 0, leerTermin);
					leerTermin = new Termin(oldart);
					daten.setTermin(globaleSpalte, i, therapeut, 1, leerTermin);
				}
			daten.setUpdate();
			cancel();
		} else {
			switch (index){
				case Termin.TEAM : 
					Therapeut t = daten.getTherapeut(theraKannDaNicht);
					String theraKannDaNichtName = ""+t.getVorname()+" "+t.getNachname();
					JOptionPane.showMessageDialog(physiomat, theraKannDaNichtName+" kann da nicht.", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
					logger.info("TEAMSitzung: Therapeut "+theraKannDaNichtName+" kann da nicht.");
					break;
				case Termin.KURS : 
					JOptionPane.showMessageDialog(physiomat, "Es blockieren Termine\ndie Ausführung.", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
					logger.info("Kurseintragung: Termine blockieren die Ausführung");
					break;
				case Termin.PATIENT :
					Calendar calR = Calendar.getInstance();
					calR.setTime(daten.getDate(globaleSpalte));
					int year = calR.get(Calendar.YEAR);
					int month = calR.get(Calendar.MONTH)+1;
					int day = calR.get(Calendar.DAY_OF_MONTH);
					String termininfo = ""+day+"."+month+"."+year+" um "+daten.UHRZEIT[von]+" bis "+daten.UHRZEIT[bis];
					switch (rgt){
						case RAUM: 
							JOptionPane.showMessageDialog(physiomat, "Es gibt keinen Raum für diesen Termin!", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
							logger.info("Für den Patiententermin "+patienten.getSelectedItem()+" am "+termininfo+" ist kein Raum vorhanden.");
							break;
						case TERMIN:
							JOptionPane.showMessageDialog(physiomat, "Der Termin überscheidet sich mit anderen Terminen.", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
							logger.info("Terminüberschneidung für den Patiententermin "+patienten.getSelectedItem()+" am "+termininfo);
							break;
						case GERAT:
							JOptionPane.showMessageDialog(physiomat, "Es stehen nicht genügend Geräte zur Verfügung!", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
							logger.info("Nicht genug Geräte für den Patiententermin "+patienten.getSelectedItem()+" am "+termininfo);
							break;
						default: JOptionPane.showMessageDialog(physiomat, "Patiententermin kann nicht eingetragen werden.", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
						logger.info("Patiententermine können nicht eingetragen werden (default).\nfür den Patienten "+patienten.getSelectedItem()+" am "+termininfo);
					}
					
					break;
				case Termin.FEIERTAG:
				case Termin.KRANK:
				case Termin.URLAUB:
				case Termin.SCHULUNG:
					JOptionPane.showMessageDialog(physiomat, "Datum ist ausserhalb der Reichweite des Programmes.", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
					break;
				default : JOptionPane.showMessageDialog(physiomat, "Es blockieren Termine\ndie Ausführung.", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
					logger.info("Termine blockieren die Ausführung");
			}
			//Fehler ausspucken
		}
	}
	
	public void prufIt(){
		logger.finest("Betreten");
		int index = comboTag.getSelectedIndex();
		int oldvon = termin.getVonZeit();
		int oldbis = termin.getBisZeit();
		int oldart = termin.getOldArt();
		int von = vonZeit.getSelectedIndex();
		int bis = bisZeit.getSelectedIndex();
		boolean spring = true;
		if(pruefen()){
			JOptionPane.showMessageDialog(physiomat, "Termin kann so eingetragen werden.", "Alles gut!", JOptionPane.INFORMATION_MESSAGE, null);
			logger.info("Prüfbutton ergibt freie Bahn.");
		} else {
			switch (index){
				case Termin.TEAM : 
					Therapeut t = daten.getTherapeut(theraKannDaNicht);
					String theraKannDaNichtName = ""+t.getVorname()+" "+t.getNachname();
					JOptionPane.showMessageDialog(physiomat, theraKannDaNichtName+" kann da nicht.", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
					logger.info("TEAMSitzung: Therapeut "+theraKannDaNichtName+" kann da nicht.");
					break;
				case Termin.KURS : 
					JOptionPane.showMessageDialog(physiomat, "Es blockieren Termine\ndie Ausführung.", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
					logger.info("Kurseintragung: Termine blockieren die Ausführung");
					break;
				case Termin.PATIENT :
					Calendar calR = Calendar.getInstance();
					calR.setTime(daten.getDate(globaleSpalte));
					int year = calR.get(Calendar.YEAR);
					int month = calR.get(Calendar.MONTH)+1;
					int day = calR.get(Calendar.DAY_OF_MONTH);
					String termininfo = ""+day+"."+month+"."+year+" um "+daten.UHRZEIT[von]+" bis "+daten.UHRZEIT[bis];
					switch (rgt){
						case RAUM: 
							JOptionPane.showMessageDialog(physiomat, "Es gibt keinen Raum für diesen Termin!", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
							logger.info("Für den Patiententermin "+patienten.getSelectedItem()+" am "+termininfo+" ist kein Raum vorhanden.");
							break;
						case TERMIN:
							JOptionPane.showMessageDialog(physiomat, "Der Termin überscheidet sich mit anderen Terminen.", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
							logger.info("Terminüberschneidung für den Patiententermin "+patienten.getSelectedItem()+" am "+termininfo);
							break;
						case GERAT:
							JOptionPane.showMessageDialog(physiomat, "Es stehen nicht genügend Geräte zur Verfügung!", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
							logger.info("Nicht genug Geräte für den Patiententermin "+patienten.getSelectedItem()+" am "+termininfo);
							break;
						default: JOptionPane.showMessageDialog(physiomat, "Patiententermin kann nicht eingetragen werden.", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
						logger.info("Patiententermine können nicht eingetragen werden (default).\nfür den Patienten "+patienten.getSelectedItem()+" am "+termininfo);
					}
					
					break;
				case Termin.FEIERTAG:
				case Termin.KRANK:
				case Termin.URLAUB:
				case Termin.SCHULUNG:
					JOptionPane.showMessageDialog(physiomat, "Datum ist ausserhalb der Reichweite des Programmes.", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
					break;
				default : JOptionPane.showMessageDialog(physiomat, "Es blockieren Termine\ndie Ausführung.", "Fehler!", JOptionPane.ERROR_MESSAGE, null);
					logger.info("Termine blockieren die Ausführung");
			}
		}
	}
	

	public void ActionEvent(ActionEvent e){
		Object src = e.getSource();
		if(src == cancel)
			cancel();
	}

	public void cancel(){
		daten.speichernErlaubt(Daten.EINTRAG);
		this.dispose();
	}

	public void panelZeigen(){
		if(one){
			//getContentPane().remove(panel1);
			//getContentPane().add(panel2);
			one = false;
		} else {
			//getContentPane().remove(panel2);
			//getContentPane().add(panel1);
			one = true;
		}
		//updateUI();
		repaint();
	}
	
	/*
	private void save(){
		kalenderFenster.updateDaten();
	}
	*/

	public void berechneDatum(){
		datum = new Date();
	}

	public boolean pruefen(){
		int index = comboTag.getSelectedIndex();
		int von = vonZeit.getSelectedIndex();
		int bis = bisZeit.getSelectedIndex();
		Termin prufTermin;
		boolean wert = true;
		switch (index){
			case Termin.KEINEARBEITSZEIT : //frei und keine Arbeitszeit. Alles andere nicht.
				for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
					prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 0);
					if(prufTermin.getArt() != Termin.FREI &&  prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
						wert = false;
					prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 1);
					if(prufTermin.getArt() != Termin.FREI &&  prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
						wert = false;
				}					
				break;
			case Termin.FREI : //frei und keine Arbeitszeit. Alles andere nicht.
				for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
					prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 0);
					if(prufTermin.getArt() != Termin.FREI &&  prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
						wert = false;
					prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 1);
					if(prufTermin.getArt() != Termin.FREI &&  prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
						wert = false;
				}					
				break;
			case Termin.KURS : //Kurs darf vorkommen und frei und keine Arbeitszeit. Alles andere nicht.
				for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
					prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 0);
					if(prufTermin.getArt() != Termin.KURS && prufTermin.getArt() != Termin.FREI &&  prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
						wert = false;
					prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 1);
					if(prufTermin.getArt() != Termin.KURS && prufTermin.getArt() != Termin.FREI &&  prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
						wert = false;
				}					
				break;
			case Termin.PAUSE : //Nur FREI, Pause und Keine Arbeitszeit überschreiben. Alles andere nicht.
				for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
					prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 0);
					if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.PAUSE &&  prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
						wert = false;
					prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 1);
					if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.PAUSE &&  prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
						wert = false;
				}					
				break;
			case Termin.NOTIZ : //Nur FREI und Keine Arbeitszeit überschreiben. Alles andere nicht.
				for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
					prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 0);
					if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
						wert = false;
					prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 1);
					if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
						wert = false;
				}					
				break;
			case Termin.TEAM : //Alle Therapeuten müssen dort FREI oder Keine Arbeitszeit haben
				for(int j = 0; j < daten.getMaxTherapeuten(); j++){
					prufTermin = daten.getTermin(globaleSpalte, 0, j, 0);
					if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.KEINEARBEITSZEIT){//Zeile 0 = Urlaub oder Schulung oder oder oder
						wert = false;
						theraKannDaNicht = j;
					}
					for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
						prufTermin = daten.getTermin(globaleSpalte, i, j, 0);
						if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.KEINEARBEITSZEIT){
							wert = false;
							theraKannDaNicht = j;
						}
						prufTermin = daten.getTermin(globaleSpalte, i, j, 1);
						if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.KEINEARBEITSZEIT){
							wert = false;
							theraKannDaNicht = j;
						}
					}
				}
				break;
			case Termin.PATIENT :
				/*
					OK, es steht also nichts im Wege. Nun müssen wir aber auch schauen, ob da überhaupt 
					Räume oder Geräte bereitstehen. Deswegen
					1. Termine
						stehen andere Termine im Weg?
					2. Räume
						a Passen Anzahl der Räume vor dem Wendetermin (falls der eh nicht in der Vergangenheit ist)
						b Passen Anzahl der Räume ab dem Wendetermin
					3. Geräte
						a Sind genug Geräte nun da?
						b Sind genug Geräte in der Zukunft da?
					Wenn es nicht klaptt, dann Fehlermeldung!!!
					
					1. Termine
				*/
				if(packungCB.isSelected())
						packung = true;
					else
						packung = false;
				if(packung){
					for(int i = von+1; i < von+3; i++){//Packung
						prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 1);
						if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
							wert = false;
					}
					for(int i = von+3; i < bis+1; i++){//Behandlung
						prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 0);
						if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
							wert = false;
					}
				} else {
					for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
						prufTermin = daten.getTermin(globaleSpalte, i, therapeut, 0);
						if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
							wert = false;
					}
				}
				if(!wert)
					rgt = TERMIN;
				/*
				2. Räume
				*/
				if(wert){
					int raumzahl = 0;
					Date tag = daten.getDate(globaleSpalte);
					Date vtag = daten.getRaeume().getDatum();
					logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
					if(tag.getTime() < daten.getRaeume().getDatum().getTime()){//Vorher
						//if(packung){
						//} else {
							for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
								raumzahl = 1;//Wir benötigen einen Raum
								for(int j = 0; j < daten.getMaxTherapeuten(); j++){
									raumzahl = raumzahl + daten.getTermin(globaleSpalte, i, j, 0).getRaume();
									raumzahl = raumzahl + daten.getTermin(globaleSpalte, i, j, 1).getRaume();
								}
								if(raumzahl > daten.getRaeume().getWert()){
									wert = false;
									rgt = RAUM;
								}
							}
						//}
					} else {
					//if(packung){Interessiert nicht, da ja Packung und nichtPAckung, also beides, gezählt werden müssen
					//	} else {
							for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
								raumzahl = 1;//Wir benötigen einen Raum
								for(int j = 0; j < daten.getMaxTherapeuten(); j++){
									raumzahl = raumzahl + daten.getTermin(globaleSpalte, i, j, 0).getRaume();
									raumzahl = raumzahl + daten.getTermin(globaleSpalte, i, j, 1).getRaume();
								}
								if(raumzahl > daten.getRaeume().getZukunft()){
									wert = false;
									rgt = RAUM;
								}
							}
						//}
					}
				}
				/*
				3. Geräte
				*/
				if(wert){
					int geratzahl = 0;
					if(geratCB.isSelected())
						geratzahl = 1;
					int startgeratzahl = geratzahl;
					Date tag = daten.getDate(globaleSpalte);
					Date vtag = daten.getGeraete().getDatum();
					logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
					if(tag.getTime() < vtag.getTime()){//Vorher
						//if(packung){
						//} else {
							for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
								//geratzahl = 1;//Wir benötigen einen Raum
								geratzahl = startgeratzahl;
								for(int j = 0; j < daten.getMaxTherapeuten(); j++){
									geratzahl = geratzahl + daten.getTermin(globaleSpalte, i, j, 0).getGeraet();
									geratzahl = geratzahl + daten.getTermin(globaleSpalte, i, j, 1).getGeraet();
								}
								logger.finest("Anzahl der Geräte: "+geratzahl);
								if(geratzahl > daten.getGeraete().getWert()){
									wert = false;
									rgt = GERAT;
								}
							}
						//}
					} else {
					//if(packung){Interessiert nicht, da ja Packung und nichtPAckung, also beides, gezählt werden müssen
					//	} else {
							for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
								geratzahl = startgeratzahl;
								for(int j = 0; j < daten.getMaxTherapeuten(); j++){
									geratzahl = geratzahl + daten.getTermin(globaleSpalte, i, j, 0).getGeraet();
									geratzahl = geratzahl + daten.getTermin(globaleSpalte, i, j, 1).getGeraet();
								}
								logger.finest("Anzahl der Geräte: "+geratzahl);
								if(geratzahl > daten.getGeraete().getZukunft()){
									wert = false;
									rgt = GERAT;
								}
							}
						//}
					}
				}
				break;
			case Termin.FEIERTAG:
			case Termin.KRANK:
			case Termin.URLAUB:
			case Termin.SCHULUNG:
				Date vonDatum = vonUrlaub.getDate();
				Date bisDatum = bisUrlaub.getDate();
				if(daten.getSpalte(vonDatum) == -1 || daten.getSpalte(bisDatum) == -1)
					wert = false;
				break;
			default : wert = true;
		}
		return wert;
	}
	


	public boolean modulo(int x, int y){
		boolean a = false;
		int z = x/y;
		if(z*y == x)
			return true;
		else
			return false;
	}
	
	public void panelTausch(){
		int index = comboTag.getSelectedIndex();
		if(update && !(oldindex == index)){
			update = false;
			boolean remove = false;
			//if(kursda){
			//}
				
			switch (oldindex){
				//Enternen der Panels.
				case Termin.PATIENT : mainPanel.remove(patientenPanel);mainPanel.remove(patientenPanel2);break;
				case Termin.KURS : mainPanel.remove(kursPanel);break;
				case Termin.NOTIZ: mainPanel.remove(notizPanel);break;
				case Termin.URLAUB: 
					remove = true;
					mainPanel.remove(vonbisPanel);
					mainPanel.remove(urlauberPanel);
					break;
				case Termin.SCHULUNG: 
					remove = true;
					mainPanel.remove(vonbisPanel);
					mainPanel.remove(urlauberPanel);
					break;
				case Termin.KRANK: 
					remove = true;
					mainPanel.remove(vonbisPanel);
					mainPanel.remove(urlauberPanel);
					break;
				case Termin.FEIERTAG: 
					remove = true;
					mainPanel.remove(vonbisPanel);
					mainPanel.remove(urlauberPanel);
					break;
			}
			mainPanel.remove(vonbisPanel);
			mainPanel.remove(vonbisPanel);
			vonbisda = false;
			pack();
			kursPanel.updateUI();
			notizPanel.updateUI();
			vonbisPanel.updateUI();
			mainPanel.updateUI();
			repaint();
			switch (index){
				case Termin.KEINEARBEITSZEIT :
					if(!vonbisda) addComponent( mainPanel, gbl, vonbisPanel, 0,2,3,1);
					break;
				case Termin.FREI :
					if(!vonbisda) addComponent( mainPanel, gbl, vonbisPanel, 0,2,3,1);
					break;
				case Termin.PATIENT : 
					if(!vonbisda) addComponent( mainPanel, gbl, vonbisPanel, 0,2,3,1);
					addComponent( mainPanel, gbl, patientenPanel2, 0,3,4,1);
					addComponent( mainPanel, gbl, patientenPanel,  0,4,3,1);
					break;
				case Termin.PAUSE : 
					if(!vonbisda) addComponent( mainPanel, gbl, vonbisPanel, 0,2,3,1);
					break;
				case Termin.ANMELDUNG : 
					if(!vonbisda) addComponent( mainPanel, gbl, vonbisPanel, 0,2,3,1);
					break;
				case Termin.KURS : 
					addComponent( mainPanel, gbl, kursPanel, 0,3,3,1); 
					logger.finest("Neues Kurspanel");
					if(!vonbisda) addComponent( mainPanel, gbl, vonbisPanel, 0,2,3,1);
					break;
				case Termin.NOTIZ : 
					addComponent( mainPanel, gbl, notizPanel, 0,3,3,1); 
					if(!vonbisda) addComponent( mainPanel, gbl, vonbisPanel, 0,2,3,1);
					logger.finest("Neues Notizpanel");
					break;
				case Termin.TEAM: 
					addComponent( mainPanel, gbl, kursPanel, 0,3,3,1); 
					logger.finest("Neues Teampanel");
					if(!vonbisda) addComponent( mainPanel, gbl, vonbisPanel, 0,2,3,1);
					break;
				case Termin.URLAUB:
				case Termin.KRANK:
				case Termin.FEIERTAG:
				case Termin.SCHULUNG:
					addComponent( mainPanel, gbl, urlauberPanel, 0,3,3,1); 
					break;
			}
			pack();
			kursPanel.updateUI();
			notizPanel.updateUI();
			vonbisPanel.updateUI();
			patientenPanel.updateUI();
			patientenPanel2.updateUI();
			mainPanel.updateUI();
			repaint();
			oldindex = index;
			update = true;
		}
	}
	
	private void fuelleDaten(){
		
		int index = patienten.getSelectedIndex();
		Patient p = daten.getPatient(index);
		telefonFD.setText(p.getTelefon());
		telefon2FD.setText(p.getTelefon2());
		telefon3FD.setText(p.getTelefon3());
		birthFD.setText(p.getGeburtstag());
		kommentarTA.setText(p.getKommentar());
		if(comboTag.getSelectedIndex() == Termin.PATIENT){
			if(noInit){
				theraCB.setSelectedIndex(p.getTherapeut());
				theraTerminCB.setSelectedIndex(daten.getAktivenTherapeuten());
				termineTA.setText(p.getTermine());
				if(p.getTelefon().equals("")){
					labelTelefon.setText("Telefon!!!");
					if(p.getTelefon2().equals("") && p.getTelefon3().equals(""))
					JOptionPane.showMessageDialog(this, "Es ist keine Telefonnummer angegeben!","Keine Telefonnummer.", JOptionPane.INFORMATION_MESSAGE, null);
				} else {
					labelTelefon.setText("");
				}
			}
		}
	}
	
	private void zeigePatient(){
		/*
			Erschaffe einen neuen Patienten.
		*/
		PatientenFensterDialog pfd = new PatientenFensterDialog(physiomat, daten);
		pfd.zeigen();
		Patient p = pfd.getPatient();
		//termin.setPatient(p, packung);//Hier ist was falsch!!!
		//Finde Indexnummer dieses Patienten.
		updateInit();
		patienten.setSelectedIndex(daten.getTerminPatient(p));
		fuelleDaten();
	}
	
	private void save(){
		logger.fine("Vorhandener Patient wird gespeichert.\nWICHTIG: Alle Daten müssen auf dieselbe Referenz verweisen, weil sonst die Patienten aus dem Terminkalender verloren gehen.");
			
			Patient p;
			if(termin.getArt() == Termin.PATIENT)
				p = termin.getPatient();
			else
				p = daten.getPatient(patienten.getSelectedIndex());
			String vorname = p.getVorname();
			String name = p.getNachname();
			String geburtstag = birthFD.getText();
			String telefon = telefonFD.getText();
			String telefon2 = telefon2FD.getText();
			String telefon3 = telefon3FD.getText();
			String kommentare = kommentarTA.getText();
			//gesetzlich = krankenkassengesetz.isSelected();
			//Patient = dauerpatient.isSelected();
			int kasse = p.getKasse();
			boolean herr = p.getHerr();
			String termine = termineTA.getText();
			int therapeut = theraCB.getSelectedIndex();//0 = keiner
			Patient pnew = new Patient(vorname, name, geburtstag, telefon, telefon2, telefon3, kommentare, termine,  kasse, herr, therapeut);
			Patient org = daten.getPatient(patienten.getSelectedIndex());
			org.save(pnew);
			daten.savePatient(org, patienten.getSelectedIndex());
			if(herr)
				logger.fine("Patient wurde gändert\nHerr "+vorname+" "+name+"\nGeburtstag: "+geburtstag+"\nTelefon: "+telefon+"\n"+telefon2+"\n"+telefon3+"\nKommentare: "+kommentare+"\nKasse: "+kasse+"\nTherapeut: "+therapeut+theraCB.getSelectedItem());
			else
				logger.fine("Patient wurde gändert\nFrau "+vorname+" "+name+"\nGeburtstag: "+geburtstag+"\nTelefon: "+telefon+"\n"+telefon2+"\n"+telefon3+"\nKommentare: "+kommentare+"\nKasse: "+kasse+"\nTherapeut: "+therapeut+theraCB.getSelectedItem());
		fuelleDaten();
		daten.setUnsave();
	}
	
	private void updateInit(){
		noInit = false;
		patienten.removeAllItems();
		Patient p, p2;
		String next = "";
		String nun = "";
		boolean doppelt = false;
		int c = 1;
		for(int i = 0; i < daten.getMaxPatienten(); i++){
			p = daten.getPatient(i);
			nun = ""+p.getNachname()+", "+p.getVorname();
			if((i+1)< daten.getMaxPatienten()){
				p2 = daten.getPatient(i+1);
				next = ""+p2.getNachname()+", "+p2.getVorname();
				if(nun.equals(next)){
					nun = nun+"["+c+++"] "+p.getGeburtstag();//nun = nun+"("+c+++")";
					doppelt = true;
				} else if(doppelt){
					nun = nun+"["+c+++"] "+p.getGeburtstag();//nun = nun+"("+c+++")";
					doppelt = false;
				}
			}
			patienten.addItem(nun);
		}
		noInit = true;
	}
	
	private void diesenTerminNeu(){
		logger.info("Starte Suche nach neuen Terminen:");
		int von = termin.getVonZeit();
		int bis = termin.getBisZeit();
		int index = 0;
		Termin vergleich;
		TerminTag neuT;
		Vector<Termin> termine = new Vector<Termin>(10,10);
		String woTag = "";
		if(wahl1RB.isSelected()) index = 1;//Sofort
		if(wahl2RB.isSelected()) index = 2;//diese Woche
		if(wahl3RB.isSelected()) index = 3;//nächste Woche
		if(wahl4RB.isSelected()) index = 4;//In zwei Wochen
		if(wahl5RB.isSelected()) index = 5;//In drei Wochen
		if(wahl6RB.isSelected()) index = 6;//in vier Wochen
		
		boolean geraete = geratCB.isSelected();
		boolean gefunden = false;//Falls kein Termin gefunden, dann natürlich ansagen.
		int aktSpalte = globaleSpalte;
		int endSpalte = 0;
		int dauer = bis-von;
		int thera = theraTerminCB.getSelectedIndex();
		int anzahl = 0;//entspricht suchdauer
		boolean gut = false;
		//Wenn gut, dann muss der Termin die ganze Zeit über gut sein. Eine Stunde muss
		//auch eine komplette Stunde gut sein und nicht zwischendurch unterbrochen werden.
		int terminZeile = 0;//Zeile in den Terminen
		//Date datum;
		Calendar calR = Calendar.getInstance();
		int tag, monat, jahr = 0;
		String vorname, name = "";
		Therapeut th;
		switch (index){
			case 1: 
				/*
				Sofort alle passenden freien Termine finden. 
				Suchzeit bis zu zwei Wochen.
				*/
				aktSpalte = globaleSpalte;
				endSpalte = aktSpalte+14;
				if(packung){
					//Hier zuerst Packungsspalte durchsuchen und dann nach geeigneten Kandidaten finden.
					for(int i = aktSpalte; i < endSpalte; i++){
						for(thera = 0; thera < daten.getMaxTherapeuten(); thera++){
							vergleich = daten.getTermin(i, 0, thera, 0);
							if(vergleich.getArt() != Termin.URLAUB && vergleich.getArt() != Termin.KRANK && vergleich.getArt() != Termin.SCHULUNG && vergleich.getArt() != Termin.FEIERTAG){
								for(int zeile = 1; zeile < 86; zeile++){
									vergleich = daten.getTermin(i, zeile, thera, 1);
									if(vergleich.getArt() == Termin.FREI){
										//Anfangstreffer. Nun müssen auch die anderen weiteren Treffer gut sein
										gut = true;
										anzahl = 0;
										terminZeile = zeile;
										while(anzahl < dauer && terminZeile < 86 && gut){
											if(anzahl == 1)
												vergleich = daten.getTermin(i, terminZeile, thera, 1);
											else
												vergleich = daten.getTermin(i, terminZeile, thera, 0);
											if(vergleich.getArt() != Termin.FREI)
												gut = false;
											else
												anzahl++;
											//int tt = 0;//therapeuten für die Geräte und Raumsuche
											int raum = 1;
											int gerat = 0;
											if(geraete)
												gerat = 1;
											for(int tt = 0; tt < daten.getMaxTherapeuten(); tt++){
												vergleich = daten.getTermin(i, terminZeile, tt, 0);
												raum = raum + daten.getTermin(i, terminZeile, tt, 0).getRaume();
												raum = raum + daten.getTermin(i, terminZeile, tt, 1).getRaume();
												gerat = gerat + daten.getTermin(i, terminZeile, tt, 0).getGeraet();
												gerat = gerat + daten.getTermin(i, terminZeile, tt, 1).getGeraet();
											}
											Date atag = daten.getDate(i);
											Date vtag = daten.getGeraete().getDatum();
											//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
											if(atag.getTime() < vtag.getTime()){//Vorher
												if(gerat > daten.getGeraete().getWert())
													gut = false;
											} else {
												if(gerat > daten.getGeraete().getZukunft())
													gut = false;
											}
											vtag = daten.getRaeume().getDatum();
											//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
											if(atag.getTime() < vtag.getTime()){//Vorher
												if(raum > daten.getRaeume().getWert())
													gut = false;
											} else {
												if(raum > daten.getRaeume().getZukunft())
													gut = false;
											}
											terminZeile++;
										}
										if(gut && anzahl >= dauer){
											//Wir haben einen Termin gefunden:
											calR.setTime(daten.getDate(i));
											jahr = calR.get(Calendar.YEAR);
											monat = calR.get(Calendar.MONTH)+1;
											tag = calR.get(Calendar.DAY_OF_MONTH);
											th = daten.getTherapeut(thera);
											vorname = th.getVorname();
											name = th.getNachname();
											switch (calR.get(Calendar.DAY_OF_WEEK)){
												case Calendar.MONDAY   : woTag = "Mo"; break;
												case Calendar.TUESDAY  : woTag = "Di"; break;
												case Calendar.WEDNESDAY: woTag = "Mi"; break;
												case Calendar.THURSDAY : woTag = "Do"; break;
												case Calendar.FRIDAY   : woTag = "Fr"; break;
												case Calendar.SATURDAY : woTag = "Sa"; break;
												case Calendar.SUNDAY   : woTag = "So"; break;
											}
											logger.fine("Termin gefunden:\n"+tag+"."+monat+"."+jahr+" "+daten.UHRZEIT[zeile-1]+" bei "+vorname+" "+name);
											gefunden = true;
											neuT = new TerminTag(tag, monat, jahr, i, zeile, packung, thera, woTag);
											if(geraete)
												neuT.setGeraet(1);
											termine.add(neuT);
										}
									}
								}
							}
						}
					}
				} else {
					for(int i = aktSpalte; i < endSpalte; i++){
						for(thera = 0; thera < daten.getMaxTherapeuten(); thera++){
							vergleich = daten.getTermin(i, 0, thera, 0);
							if(vergleich.getArt() != Termin.URLAUB && vergleich.getArt() != Termin.KRANK && vergleich.getArt() != Termin.SCHULUNG && vergleich.getArt() != Termin.FEIERTAG){
								for(int zeile = 1; zeile < 86; zeile++){
									vergleich = daten.getTermin(i, zeile, thera, 0);
									if(vergleich.getArt() == Termin.FREI){
										//Anfangstreffer. Nun müssen auch die anderen weiteren Treffer gut sein
										gut = true;
										anzahl = 0;
										terminZeile = zeile;
										while(anzahl < dauer && terminZeile < 86 && gut){
											vergleich = daten.getTermin(i, terminZeile, thera, 0);
											if(vergleich.getArt() != Termin.FREI)
												gut = false;
											else
												anzahl++;
											//int tt = 0;//therapeuten für die Geräte und Raumsuche
											int raum = 1;
											int gerat = 0;
											if(geraete)
												gerat = 1;
											for(int tt = 0; tt < daten.getMaxTherapeuten(); tt++){
												vergleich = daten.getTermin(i, terminZeile, tt, 0);
												raum = raum + daten.getTermin(i, terminZeile, tt, 0).getRaume();
												raum = raum + daten.getTermin(i, terminZeile, tt, 1).getRaume();
												gerat = gerat + daten.getTermin(i, terminZeile, tt, 0).getGeraet();
												gerat = gerat + daten.getTermin(i, terminZeile, tt, 1).getGeraet();
											}
											Date atag = daten.getDate(i);
											Date vtag = daten.getGeraete().getDatum();
											//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
											if(atag.getTime() < vtag.getTime()){//Vorher
												if(gerat > daten.getGeraete().getWert())
													gut = false;
											} else {
												if(gerat > daten.getGeraete().getZukunft())
													gut = false;
											}
											vtag = daten.getRaeume().getDatum();
											//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
											if(atag.getTime() < vtag.getTime()){//Vorher
												if(raum > daten.getRaeume().getWert())
													gut = false;
											} else {
												if(raum > daten.getRaeume().getZukunft())
													gut = false;
											}
											terminZeile++;
										}
										if(gut && anzahl >= dauer){
											//Wir haben einen Termin gefunden:
											calR.setTime(daten.getDate(i));
											jahr = calR.get(Calendar.YEAR);
											monat = calR.get(Calendar.MONTH)+1;
											tag = calR.get(Calendar.DAY_OF_MONTH);
											th = daten.getTherapeut(thera);
											vorname = th.getVorname();
											name = th.getNachname();
											switch (calR.get(Calendar.DAY_OF_WEEK)){
												case Calendar.MONDAY   : woTag = "Mo"; break;
												case Calendar.TUESDAY  : woTag = "Di"; break;
												case Calendar.WEDNESDAY: woTag = "Mi"; break;
												case Calendar.THURSDAY : woTag = "Do"; break;
												case Calendar.FRIDAY   : woTag = "Fr"; break;
												case Calendar.SATURDAY : woTag = "Sa"; break;
												case Calendar.SUNDAY   : woTag = "So"; break;
											}
											logger.fine("Termin gefunden:\n"+tag+"."+monat+"."+jahr+" "+daten.UHRZEIT[zeile-1]+" bei "+vorname+" "+name);
											gefunden = true;
											neuT = new TerminTag(tag, monat, jahr, i, zeile, packung, thera, woTag);
											if(geraete)
												neuT.setGeraet(1);
											termine.add(neuT);
										}
									}
								}
							}
						}
					}
				}
				break;
			case 2: 
				/*
					Ab diese Woche, aber nur dieser Therapeut; drei Wochen suchen
				*/
				aktSpalte = globaleSpalte;
				endSpalte = aktSpalte+21;
				break;
			case 3: 
				/*
					Ab nächste Woche, aber nur dieser Therapeut; drei Wochen suchen
				*/
				calR.setTime(daten.getDate(globaleSpalte));
				int dow = calR.get(Calendar.DAY_OF_WEEK);
				switch(dow){
					case Calendar.SUNDAY : aktSpalte = globaleSpalte+1; break;
					case Calendar.MONDAY : aktSpalte = globaleSpalte+7; break;
					case Calendar.TUESDAY : aktSpalte = globaleSpalte+6; break;
					case Calendar.WEDNESDAY : aktSpalte = globaleSpalte+5; break;
					case Calendar.THURSDAY : aktSpalte = globaleSpalte+4; break;
					case Calendar.FRIDAY : aktSpalte = globaleSpalte+3; break;
					case Calendar.SATURDAY : aktSpalte = globaleSpalte+2; break;
				}
				endSpalte = aktSpalte+21;
				break;
			case 4: 
				/*
					In zwei Wochen, aber nur dieser Therapeut; drei Wochen suchen
				*/
				calR.setTime(daten.getDate(globaleSpalte));
				dow = calR.get(Calendar.DAY_OF_WEEK);
				switch(dow){
					case Calendar.SUNDAY : aktSpalte = globaleSpalte+8; break;
					case Calendar.MONDAY : aktSpalte = globaleSpalte+14; break;
					case Calendar.TUESDAY : aktSpalte = globaleSpalte+13; break;
					case Calendar.WEDNESDAY : aktSpalte = globaleSpalte+12; break;
					case Calendar.THURSDAY : aktSpalte = globaleSpalte+11; break;
					case Calendar.FRIDAY : aktSpalte = globaleSpalte+10; break;
					case Calendar.SATURDAY : aktSpalte = globaleSpalte+9; break;
				}
				endSpalte = aktSpalte+21;
				break;
			case 5: 
				/*
					In drei Wochen, aber nur dieser Therapeut; drei Wochen suchen
				*/
				calR.setTime(daten.getDate(globaleSpalte));
				dow = calR.get(Calendar.DAY_OF_WEEK);
				switch(dow){
					case Calendar.SUNDAY : aktSpalte = globaleSpalte+15; break;
					case Calendar.MONDAY : aktSpalte = globaleSpalte+21; break;
					case Calendar.TUESDAY : aktSpalte = globaleSpalte+20; break;
					case Calendar.WEDNESDAY : aktSpalte = globaleSpalte+19; break;
					case Calendar.THURSDAY : aktSpalte = globaleSpalte+18; break;
					case Calendar.FRIDAY : aktSpalte = globaleSpalte+17; break;
					case Calendar.SATURDAY : aktSpalte = globaleSpalte+16; break;
				}
				endSpalte = aktSpalte+21;
				break;
			case 6: 
				/*
					In drei Wochen, aber nur dieser Therapeut; drei Wochen suchen
				*/
				calR.setTime(daten.getDate(globaleSpalte));
				dow = calR.get(Calendar.DAY_OF_WEEK);
				switch(dow){
					case Calendar.SUNDAY : aktSpalte = globaleSpalte+22; break;
					case Calendar.MONDAY : aktSpalte = globaleSpalte+28; break;
					case Calendar.TUESDAY : aktSpalte = globaleSpalte+27; break;
					case Calendar.WEDNESDAY : aktSpalte = globaleSpalte+26; break;
					case Calendar.THURSDAY : aktSpalte = globaleSpalte+25; break;
					case Calendar.FRIDAY : aktSpalte = globaleSpalte+24; break;
					case Calendar.SATURDAY : aktSpalte = globaleSpalte+23; break;
				}
				endSpalte = aktSpalte+21;
				break;
		}
		if(index != 1){//Fall 1 wurde schon behandelt. Verschiedene Therapeuten. Nun nur noch einer.
			if(packung){
				//Hier zuerst Packungsspalte durchsuchen und dann nach geeigneten Kandidaten finden.
				for(int i = aktSpalte; i < endSpalte; i++){
					//thera = daten.getAktivenTherapeuten();
					vergleich = daten.getTermin(i, 0, thera, 0);
					if(vergleich.getArt() != Termin.URLAUB && vergleich.getArt() != Termin.KRANK && vergleich.getArt() != Termin.SCHULUNG && vergleich.getArt() != Termin.FEIERTAG){
						for(int zeile = 1; zeile < 86; zeile++){
							vergleich = daten.getTermin(i, zeile, thera, 1);
							if(vergleich.getArt() == Termin.FREI){
								//Anfangstreffer. Nun müssen auch die anderen weiteren Treffer gut sein
								gut = true;
								anzahl = 0;
								terminZeile = zeile;
								while(anzahl < dauer && terminZeile < 86 && gut){
									if(anzahl==1)
										vergleich = daten.getTermin(i, terminZeile, thera, 1);
									else
										vergleich = daten.getTermin(i, terminZeile, thera, 0);
									if(vergleich.getArt() != Termin.FREI)
										gut = false;
									else
										anzahl++;
									//int tt = 0;//therapeuten für die Geräte und Raumsuche
									int raum = 1;
									int gerat = 0;
									if(geraete)
										gerat = 1;
									for(int tt = 0; tt < daten.getMaxTherapeuten(); tt++){
										vergleich = daten.getTermin(i, terminZeile, tt, 0);
										raum = raum + daten.getTermin(i, terminZeile, tt, 0).getRaume();
										raum = raum + daten.getTermin(i, terminZeile, tt, 1).getRaume();
										gerat = gerat + daten.getTermin(i, terminZeile, tt, 0).getGeraet();
										gerat = gerat + daten.getTermin(i, terminZeile, tt, 1).getGeraet();
									}
									Date atag = daten.getDate(i);
									Date vtag = daten.getGeraete().getDatum();
									//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
									if(atag.getTime() < vtag.getTime()){//Vorher
										if(gerat > daten.getGeraete().getWert())
											gut = false;
									} else {
										if(gerat > daten.getGeraete().getZukunft())
											gut = false;
									}
									vtag = daten.getRaeume().getDatum();
									//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
									if(atag.getTime() < vtag.getTime()){//Vorher
										if(raum > daten.getRaeume().getWert())
											gut = false;
									} else {
										if(raum > daten.getRaeume().getZukunft())
											gut = false;
									}
									terminZeile++;
								}
								if(gut && anzahl >= dauer){
									//Wir haben einen Termin gefunden:
									calR.setTime(daten.getDate(i));
									jahr = calR.get(Calendar.YEAR);
									monat = calR.get(Calendar.MONTH)+1;
									tag = calR.get(Calendar.DAY_OF_MONTH);
									th = daten.getTherapeut(thera);
									vorname = th.getVorname();
									name = th.getNachname();
									switch (calR.get(Calendar.DAY_OF_WEEK)){
										case Calendar.MONDAY   : woTag = "Mo"; break;
										case Calendar.TUESDAY  : woTag = "Di"; break;
										case Calendar.WEDNESDAY: woTag = "Mi"; break;
										case Calendar.THURSDAY : woTag = "Do"; break;
										case Calendar.FRIDAY   : woTag = "Fr"; break;
										case Calendar.SATURDAY : woTag = "Sa"; break;
										case Calendar.SUNDAY   : woTag = "So"; break;
									}
									logger.fine("Termin gefunden:\n"+tag+"."+monat+"."+jahr+" "+daten.UHRZEIT[zeile-1]+" bei "+vorname+" "+name);
									gefunden = true;
									neuT = new TerminTag(tag, monat, jahr, i, zeile, packung, thera, woTag);
									if(geraete)
										neuT.setGeraet(1);
									termine.add(neuT);
								}
							}
						}
					}
				}
			} else {
				for(int i = aktSpalte; i < endSpalte; i++){
					//thera = daten.getAktivenTherapeuten();
					vergleich = daten.getTermin(i, 0, thera, 0);
					if(vergleich.getArt() != Termin.URLAUB && vergleich.getArt() != Termin.KRANK && vergleich.getArt() != Termin.SCHULUNG && vergleich.getArt() != Termin.FEIERTAG){
						for(int zeile = 1; zeile < 86; zeile++){
							vergleich = daten.getTermin(i, zeile, thera, 0);
							if(vergleich.getArt() == Termin.FREI){
								//Anfangstreffer. Nun müssen auch die anderen weiteren Treffer gut sein
								gut = true;
								anzahl = 0;
								terminZeile = zeile;
								while(anzahl < dauer && terminZeile < 86 && gut){
									vergleich = daten.getTermin(i, terminZeile, thera, 0);
									if(vergleich.getArt() != Termin.FREI)
										gut = false;
									else
										anzahl++;
									//int tt = 0;//therapeuten für die Geräte und Raumsuche
									int raum = 1;
									int gerat = 0;
									if(geraete)
										gerat = 1;
									for(int tt = 0; tt < daten.getMaxTherapeuten(); tt++){
										vergleich = daten.getTermin(i, terminZeile, tt, 0);
										raum = raum + daten.getTermin(i, terminZeile, tt, 0).getRaume();
										raum = raum + daten.getTermin(i, terminZeile, tt, 1).getRaume();
										gerat = gerat + daten.getTermin(i, terminZeile, tt, 0).getGeraet();
										gerat = gerat + daten.getTermin(i, terminZeile, tt, 1).getGeraet();
									}
									Date atag = daten.getDate(i);
									Date vtag = daten.getGeraete().getDatum();
									//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
									if(atag.getTime() < vtag.getTime()){//Vorher
										if(gerat > daten.getGeraete().getWert())
											gut = false;
									} else {
										if(gerat > daten.getGeraete().getZukunft())
											gut = false;
									}
									vtag = daten.getRaeume().getDatum();
									//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
									if(atag.getTime() < vtag.getTime()){//Vorher
										if(raum > daten.getRaeume().getWert())
											gut = false;
									} else {
										if(raum > daten.getRaeume().getZukunft())
											gut = false;
									}
									terminZeile++;
								}
								if(gut && anzahl >= dauer){
									//Wir haben einen Termin gefunden:
									calR.setTime(daten.getDate(i));
									jahr = calR.get(Calendar.YEAR);
									monat = calR.get(Calendar.MONTH)+1;
									tag = calR.get(Calendar.DAY_OF_MONTH);
									th = daten.getTherapeut(thera);
									vorname = th.getVorname();
									name = th.getNachname();
									switch (calR.get(Calendar.DAY_OF_WEEK)){
										case Calendar.MONDAY   : woTag = "Mo"; break;
										case Calendar.TUESDAY  : woTag = "Di"; break;
										case Calendar.WEDNESDAY: woTag = "Mi"; break;
										case Calendar.THURSDAY : woTag = "Do"; break;
										case Calendar.FRIDAY   : woTag = "Fr"; break;
										case Calendar.SATURDAY : woTag = "Sa"; break;
										case Calendar.SUNDAY   : woTag = "So"; break;
									}
									logger.fine("Termin gefunden:\n"+tag+"."+monat+"."+jahr+" "+daten.UHRZEIT[zeile-1]+" bei "+vorname+" "+name);
									gefunden = true;
									neuT = new TerminTag(tag, monat, jahr, i, zeile, packung, thera, woTag);
									if(geraete)
										neuT.setGeraet(1);
									termine.add(neuT);
								}
							}
						}
					}
				}
			}
		}
		if(!gefunden){
			logger.info("Keinen passenden Termin gefunden!");
			JOptionPane.showMessageDialog(physiomat,
				"Es wurde leider kein passender Termin gefunden.",
				"Keine Termine!", 
				JOptionPane.ERROR_MESSAGE, null);
		} else {
			logger.finest("Therapietext: "+therapie.getText());
			TerminAuswahl ta = new TerminAuswahl(physiomat, daten, dauer, termine, termin.getPatient(), therapie.getText());
		}
	}
	
	private void verschiebeZu(){
		int thera = theraTerminCB.getSelectedIndex();
		int therapeut = daten.getAktivenTherapeuten();
		int index = comboTag.getSelectedIndex();
		int von = vonZeit.getSelectedIndex();
		int bis = bisZeit.getSelectedIndex();
		Termin prufTermin;
		boolean wert = true;
		boolean ausgabe = true;
		if(thera == therapeut){
			wert = false;
			ausgabe = false;
			JOptionPane.showMessageDialog(physiomat,
				"Der Therapeut ist ja derselbe. Da brauche ich nichts zu verschieben.",
				"Gleiche Therapeuten.", 
				JOptionPane.ERROR_MESSAGE, null);
		}
		if(packungCB.isSelected())
			packung = true;
		else
			packung = false;
		prufTermin = daten.getTermin(globaleSpalte, 0, thera, 0);
		if(prufTermin.getArt() == Termin.URLAUB || prufTermin.getArt() == Termin.SCHULUNG || prufTermin.getArt() == Termin.KRANK || prufTermin.getArt() == Termin.FEIERTAG)
			wert = false;
		if(packung){
			for(int i = von+1; i < von+3; i++){//Packung
				prufTermin = daten.getTermin(globaleSpalte, i, thera, 1);
				if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
					wert = false;
			}
			for(int i = von+3; i < bis+1; i++){//Behandlung
				prufTermin = daten.getTermin(globaleSpalte, i, thera, 0);
				if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
					wert = false;
			}
		} else {
			for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
				prufTermin = daten.getTermin(globaleSpalte, i, thera, 0);
				if(prufTermin.getArt() != Termin.FREI && prufTermin.getArt() != Termin.KEINEARBEITSZEIT)
					wert = false;
			}
		}
		if(wert){
			if(packung){
				for(int i = von+1; i < von+3; i++){//Packung
					daten.setTermin(globaleSpalte, i, thera, 1, termin);
					daten.setTermin(globaleSpalte, i, therapeut, 1, new Termin(Termin.FREI));
				}
				for(int i = von+3; i < bis+1; i++){//Behandlung
					daten.setTermin(globaleSpalte, i, thera, 0, termin);
					daten.setTermin(globaleSpalte, i, therapeut, 0, new Termin(Termin.FREI));
					if(i < bis -1){
						daten.setTermin(globaleSpalte, i, thera, 1, new Termin());
						daten.setTermin(globaleSpalte, i, therapeut, 1, new Termin(Termin.FREI));
					}
				}
			} else {
				for(int i = von+1; i < bis+1; i++){//Zeile in daten ist eins höher
					daten.setTermin(globaleSpalte, i, thera, 0, termin);
					daten.setTermin(globaleSpalte, i, therapeut, 0, new Termin(Termin.FREI));
				}
				for(int i = von-1; i < bis-1; i++){//Zeile in daten ist eins höher
					daten.setTermin(globaleSpalte, i, thera, 1, new Termin());
					daten.setTermin(globaleSpalte, i, therapeut, 1, new Termin(Termin.FREI));
				}
			}
			daten.setUpdate();
			daten.setUnsave();
			dispose();
		} else {
			logger.info("Termin kann nicht verschoben werden.");
			if(ausgabe)
				JOptionPane.showMessageDialog(physiomat,
					"Patient kann nicht verschoben werden, weil der Therapeut dort keine Zeit hat!",
					"Termin kann nicht verschoben werden.", 
					JOptionPane.ERROR_MESSAGE, null);
		}
	}
}

/*
Problem:
Wenn ein Patient 
*/
