import javax.swing.*;
import javax.swing.table.*;
import java.util.Calendar;
import java.util.logging.*;
import java.util.Date;

public class MeinTDruckTableModel extends AbstractTableModel{
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
	private Object[][] dataW = new Object[86][4];
	private String[] spalten = new String[4];
	private Daten daten;
	private boolean selected = false;
	private int x = 0;
	private int y = 0;
	private Date datum;
	private int start = 0;
	private int ende = 86;
	private boolean zuviel = (ende-start>48?true:false);
	
	

	public MeinTDruckTableModel(Daten daten, Date datum){
		super();
		this.daten = daten;
		this.datum = datum;
		spalten[0] = "Zeit";
		spalten[1] = "Patient";
		spalten[2] = "Therapie";
		spalten[3] = "Packungspatient";
		dataW[0][0] = "";//Notizzeile
		int j = 1;
		for(int i = 7; i < 10; i++){
			dataW[j++][0] = "0"+i+":00";
			dataW[j++][0] = "0"+i+":10";
			dataW[j++][0] = "0"+i+":20";
			dataW[j++][0] = "0"+i+":30";
			dataW[j++][0] = "0"+i+":40";
			dataW[j++][0] = "0"+i+":50";
		}
		for(int i = 10; i < 21; i++){
			dataW[j++][0] = ""+i+":00";
			dataW[j++][0] = ""+i+":10";
			dataW[j++][0] = ""+i+":20";
			dataW[j++][0] = ""+i+":30";
			dataW[j++][0] = ""+i+":40";
			dataW[j++][0] = ""+i+":50";
		}
		dataW[j++][0] = "21:00";
		for(int i = 0; i < 86; i++)
			for(j = 1; j < 4; j++)
				dataW[i][j]= "";
		start = daten.getStartZeit(datum);
		ende = daten.getEndZeit(datum)+2;
		zuviel = (ende-start==49?true:false);
		//if(zuviel)
		//	zuviel = (ende-start>49?false:true);
		logger.finest("Drucktabelle: \nStart: "+start+"\nEnde: "+ende);
	}

	public String getValueAt(int x, int y){
		String rwert = "";
		if((x >= 0)&&(x+start<86)&&(y>=0)&&(y<4)){
			rwert = ""+dataW[start+x][y];
		}
		if(!zuviel)
			if((start+x == ende -1) && y == 1)
				rwert = "ENDE";	
		return rwert;
	}

	public int getColumnCount(){
		return 4;
	}

	public int getRowCount(){
		if(zuviel)
			return ende-start-1;
		else
			return ende-start;
	}

	public String getColumnName(int num){
		String rwert = "";
		if((num>=0)&&(num<4))
			rwert = ""+spalten[num];
		return rwert;
	}

	public boolean isCellEditable(int row, int cow){
		return false;
	}

	public void setDaten(Daten daten){
		this.daten = daten;
	}
	
	public void setDatum(Calendar cal){
		Calendar meinC = Calendar.getInstance();
		meinC.setTime(cal.getTime());
		int anfang = 0;
		int thera = 0;
		Termin oldTermin = null;
		Termin neuTermin = null;
		Termin oldPTermin = null;//Packung
		if(null != daten){
			anfang = daten.getSpalte(meinC.getTime());
			thera = daten.getAktivenTherapeuten();
		}
		int m = 0;
		int t = 0;
		//Übernahme der Einträge
		if(null != daten)
			for(int j=0; j < 86; j++){
				if(anfang != -1){
				
					neuTermin = daten.getTermin(anfang, j, thera, 0);
					if(neuTermin != oldTermin){
						dataW[j][1]= ""+neuTermin.toString();
						dataW[j][2]= ""+neuTermin.therapie();
					} else if(neuTermin.getArt() != Termin.FREI && neuTermin.getArt() != Termin.KEINEARBEITSZEIT){
						dataW[j][1]= "\"\"";
						dataW[j][2]= "";
					}
					oldTermin = neuTermin;
						
						
					neuTermin = daten.getTermin(anfang, j, thera, 1);
						if(neuTermin != oldPTermin)
							dataW[j][3]= neuTermin.toString();
						else if(neuTermin.getArt() != Termin.FREI && neuTermin.getArt() != Termin.KEINEARBEITSZEIT)
							dataW[j][3]= "\"\"";
						oldPTermin = neuTermin;
					/*
					dataW[j][1]= neuTermin.toString();
					dataW[j][2]= neuTermin.therapie();
					dataW[j][3]= (daten.getTermin(anfang, j, thera, 1)).toString();
					//logger.finest(""+(daten.getTermin(anfang+i, j, thera, 0)).toString());
					*/
				} else {
					dataW[j][1]= "";
					dataW[j][2]= "";
					dataW[j][3]= "";
				}
				fireTableCellUpdated(j,1);
				fireTableCellUpdated(j,2);
				fireTableCellUpdated(j,3);
			}
		fireTableDataChanged();
		fireTableStructureChanged();
	}

	
}
