import javax.swing.*;
import javax.swing.table.*;
import java.util.Calendar;
import java.util.logging.*;

public class MeinWTableModel extends AbstractTableModel{
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
	private Object[][] dataW = new Object[86][13];
	private String[] spalten = new String[13];
	private Daten daten;
	private int anfang = 0;
	private boolean selected = false;
	private int x = 0;
	private int y = 0;
	

	public MeinWTableModel(Daten daten){
		super();
		this.daten = daten;
		spalten[0] = "Zeit";
		spalten[1] = "Montag";
		spalten[2] = "";
		spalten[3] = "Dienstag";
		spalten[4] = "";
		spalten[5] = "Mittwoch";
		spalten[6] = "";
		spalten[7] = "Donnerstag";
		spalten[8] = "";
		spalten[9] = "Freitag";
		spalten[10] = "";
		spalten[11] = "Sonnabend";
		spalten[12] = "";
		dataW[0][0] = "";//Notizzeile
		int j = 1;
		for(int i = 7; i < 10; i++){
			dataW[j++][0] = "0"+i+":00";
			dataW[j++][0] = "0"+i+":10";
			dataW[j++][0] = "0"+i+":20";
			dataW[j++][0] = "0"+i+":30";
			dataW[j++][0] = "0"+i+":40";
			dataW[j++][0] = "0"+i+":50";
		}
		for(int i = 10; i < 21; i++){
			dataW[j++][0] = ""+i+":00";
			dataW[j++][0] = ""+i+":10";
			dataW[j++][0] = ""+i+":20";
			dataW[j++][0] = ""+i+":30";
			dataW[j++][0] = ""+i+":40";
			dataW[j++][0] = ""+i+":50";
		}
		dataW[j++][0] = "21:00";
		for(int i = 0; i < 86; i++)
			for(j = 1; j < 13; j++)
				dataW[i][j]= "";
		//dataW[73][5]="Feierabend";
	}
	
	public String getValueAt(int x, int y){
		String rwert = "";
		if((x >= 0)&&(x<86)&&(y>=0)&&(y<13))
			rwert = ""+dataW[x][y];
		return rwert;
	}

	public int getColumnCount(){
		return 13;
	}

	public int getRowCount(){
		return 86;
	}

	public String getColumnName(int num){
		String rwert = "";
		if((num>=0)&&(num<13))
			rwert = ""+spalten[num];
		return rwert;
	}

	public boolean isCellEditable(int row, int cow){
		return false;/*
		if(!selected){
			JOptionPane.showMessageDialog(null,
				"Test",
				"Test", 
				JOptionPane.ERROR_MESSAGE, null);
			selected = true;
			x = row;
			y = cow;
		} else {
			if((row != x)||(cow !=y)){
				JOptionPane.showMessageDialog(null,
				"Test",
				"Test", 
				JOptionPane.ERROR_MESSAGE, null);
				selected = true;
				x = row;
				y = cow;
			} else {
				selected = false;
			}
		}
		return false;*/
	}

	public void setDaten(Daten daten){
		this.daten = daten;
	}
	
	public void setSpaltenDatum(Calendar cal){
		Calendar meinC = Calendar.getInstance();
		meinC.setTime(cal.getTime());
		int anfang = 0;
		int thera = 0;
		Termin neuTermin = null;
		Termin oldTermin = null;
		Termin oldPTermin = null;
		if(null != daten){
			anfang = daten.getSpalte(meinC.getTime());
			thera = daten.getAktivenTherapeuten();
		}
		int m = 0;
		int t = 0;
		/*
			Beschriftung der Tabellenköpfe
		*/
		for(int i= 0; i < 6; i++){
			m = meinC.get(Calendar.MONTH)+1;
			t = meinC.get(Calendar.DAY_OF_MONTH);
			//Beschriftung der Tabellenköpfe
			spalten[2+i*2] = ""+t+"."+m+".";
			//Übernahme der Einträge
			if(null != daten)
				for(int j=0; j < 86; j++){
					if(anfang != -1){
						neuTermin = daten.getTermin(anfang+i, j, thera, 0);
						if(neuTermin != oldTermin)
							dataW[j][1+i*2]= neuTermin.toString();
						else if(neuTermin.getArt() != Termin.FREI && neuTermin.getArt() != Termin.KEINEARBEITSZEIT)
							dataW[j][1+i*2]= "\"\"";
						oldTermin = neuTermin;
						
						neuTermin = daten.getTermin(anfang+i, j, thera, 1);
						if(neuTermin != oldPTermin)
							dataW[j][2+i*2]= neuTermin.toString();
						else if(neuTermin.getArt() != Termin.FREI && neuTermin.getArt() != Termin.KEINEARBEITSZEIT)
							dataW[j][2+i*2]= "\"\"";
						oldPTermin = neuTermin;
						//dataW[j][2+i*2]= (daten.getTermin(anfang+i, j, thera, 1)).toString();
						//logger.finest(""+(daten.getTermin(anfang+i, j, thera, 0)).toString());
					} else {
						dataW[j][2+i*2]= "";
						dataW[j][1+i*2]= "";
					}
					fireTableCellUpdated(j,i);
				}
			//nächster:
			meinC.add(Calendar.DATE, +1);
		}
		/*
			Übernahme der Einträge
		*/
		/*
		daten.getSpalte(cal)
		for(int i = 1; i < 86; i++)//Zeilen
			for(j = 1; j < 13; j++)//Spalten
				dataW[i][j]= "";
		
		String ausgabe = "";
		for(int j = 1; j < 86; j++)
			for(int i = 0; i < 13; i++)
				ausgabe = ausgabe+dataW[j][i]+"\n";
		logger.finest("Tabelle: \n"+ausgabe);
		*/
		fireTableDataChanged();
		fireTableStructureChanged();
	}
	
	public void setAnfangSpalte(int anfang){
		this.anfang = anfang;
	}

	
}
