import javax.swing.table.*;
import javax.swing.*;
import java.awt.Color;
import java.awt.Component;
import java.util.*;
import java.awt.Font;

//import javax.swing.border.EtchedBorder;
//import javax.swing.border.LineBorder;

public class MyAlleTableCellRenderer extends DefaultTableCellRenderer {
	public static final long serialVersionUID = 1L;
	private final static Color heuteFA = new Color(255, 255, 200);//Aktiv
	private final static Color heuteFP = new Color(220, 220, 200);//Passi
	private final static Color sonstFA = new Color(255, 255, 255);
	private final static Color sonstFP = new Color(200, 200, 200);
	private final static Color zeitFP = new Color(220, 220, 200);//Passi
	private final static Color zeileFA = new Color(0, 200, 0);//Zeilenfarbe
	private final static Color nichtsDa = new Color(255,0,0);//
	private Daten daten;
	private int spalte = 1;
	private Color background = new Color(255,255,255);
	private final static Color weiss = new Color(255,255,255);//
	private final static Color schwarz = new Color(0,0,0);//
	private Color foreground = schwarz;
	private int zeile = -1;
	private int maxT = daten.getMaximalTherapeuten();
	private boolean[][] dataW = new boolean[86][maxT+1];
	private int thera = 0;
	private int tagesSpalte = 0;
	
	public MyAlleTableCellRenderer(Daten daten){
		super();
		this.daten = daten;
		for(int i =0; i < 86; i++)
			for(int j = 0; j < maxT+1; j++)
				dataW[i][j] = false;
	}
	
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
		setFont(this.getFont().deriveFont(Font.BOLD));
		foreground = schwarz;
		//int lspalte = (int)((column+1)/2-1);
		int art = daten.getTermin(tagesSpalte, 0, column-1, 0).getArt();
		if(art == Termin.URLAUB || art == Termin.SCHULUNG || art == Termin.FEIERTAG || art == Termin.KRANK){
			background = nichtsDa;
			foreground = weiss;
		} else {
			if((column == 0) || (row == 0))
				background = zeitFP;
			else if(row == zeile){
				background = zeileFA;
			} else if(dataW[row][column])
				background = sonstFA;
			else
				background = sonstFP;
		}
		if(hasFocus){
			setBackground(zeileFA);
			setForeground(schwarz);
		} else {
			setBackground(background);
			setForeground(foreground);
		}
		setHorizontalAlignment(SwingConstants.CENTER);
		//setBackground(background);
		//setForeground(foreground);
		setOpaque(true);
		return this;
	}

	/*
	public void setValue(Object value){
		setBackground(Color.RED);
		setText((value == null ? "" : value.toString()));
	}
	*/
	
	/*
		Hat doch maximal drei Spalten
	public void setSpalte(int spalte){
		this.spalte = spalte;
	}
	*/
	
	
	public void setZeile(int zeile){
		this.zeile = zeile;
	}
	
	
	//JLabel c = (JLabel) super.prepareRenderer(renderer, row, column);
	//c.setFont(c.getFont().deriveFont(Font.BOLD));

	public void setTagesSpalte(int tagesSpalte){
		this.tagesSpalte = tagesSpalte;
		if(null != daten){
			thera = daten.getAktivenTherapeuten();
		}
		for(int i=0; i < 86; i++){
			for(thera = 0; thera < maxT; thera++)
				dataW[i][thera+1]= (daten.getTermin(tagesSpalte, i, thera, 0)).frei();
		}
	}

}
