import java.io.*;
import java.util.*;
import java.util.logging.*;

public class Patient implements Serializable{
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");

	private String name = "";
	private String vorname = "";
	private String geburtstag = "";
	private String telefon = "";
	private String telefon2 = "";
	private String telefon3 = "";
	private String kommentare = "";
	private String termintext = "";
	private Vector termine;
	private int therapeut = 0;//Nummer des Therapeuten 0 = keiner
	private boolean dauerPatient = false;
	//private boolean gesetzlich = true;
	private int kasse = 0;
	private boolean herr = true;
	private int id = -1;//Identifikation, um beim Speichern/ Laden schneller zu sein.
	//private Rezept mit KGG Knie

	public Patient(){
		//nichts. Alles schon belegt
	}
	
	public Patient(String vorname, String name){
		//nur zum Testen von vielen Daten
		this.name = name;
		this.vorname = vorname;
	}
	
	public Patient(String vorname, String name, String geburtstag, String telefon, String telefon2, String telefon3, String kommentare, String termine, int kasse, boolean herr, int therapeut){
		this.name = name;
		this.vorname = vorname;
		this.geburtstag = geburtstag;
		this.telefon = telefon;
		this.telefon2 = telefon2;
		this.telefon3 = telefon3;
		this.kommentare = kommentare;
		this.termintext = termine;
		this.kasse = kasse;
		//this.dauerPatient = dauerPatient;
		this.herr = herr;
		this.therapeut = therapeut;
	}
	
	public String getNachname(){
		return name;
	}
	
	public String getVorname(){
		return vorname;
	}

	public boolean equals(Patient p){
		/*
			Vergleicht zwei Patienten. Diese sind gleich, wenn Name, Vorname, 
			Geburtstag und Telefonnummer übereinstimmen. Wenn etwas nicht ausgefüllt ist,
			gilt es als Übereinstimmung.
		*/
		boolean gleich = false;
		boolean bname = false;
		boolean bvorn = false;
		boolean bbirth = false;
		boolean btel = false;
		if((name.compareTo("")==0)||(p.getNachname().compareTo("")==0)||name.compareTo(p.getNachname())==0)
			bname = true;
		if((vorname.compareTo("")==0)||(p.getVorname().compareTo("")==0)||vorname.compareTo(p.getVorname())==0)
			bvorn = true;
		if((geburtstag.compareTo("")==0)||(p.getGeburtstag().compareTo("")==0)||geburtstag.compareTo(p.getGeburtstag())==0)
			bbirth = true;
		if((telefon.compareTo("")==0)||(p.getTelefon().compareTo("")==0)||telefon.compareTo(p.getTelefon())==0)
			btel = true;
		gleich = (bname && bvorn && bbirth && btel);
		return gleich;
	}

	public String getTelefon(){
		return telefon;
	}

	public String getGeburtstag(){
		return geburtstag;
	}

	public void add(Patient p){
		/*
			Hier werden alle Einstellungen vom Patienten p übernommen. Also
			hinzugefügt. "" werden nicht übernommen!
		*/
		if(name.compareTo("")==0)
			name = p.getNachname();
		if(vorname.compareTo("")==0)
			vorname = p.getVorname();
		if(geburtstag.compareTo("")==0)
			geburtstag = p.getGeburtstag();
		if(telefon.compareTo("")==0)
			telefon = p.getTelefon();
		if(telefon2.compareTo("")==0)
			telefon2 = p.getTelefon2();
		if(telefon3.compareTo("")==0)
			telefon3 = p.getTelefon3();
		if(termintext.compareTo("")==0)
			termintext = p.getTermine();
		if(kommentare.compareTo("")==0)
			termintext = p.getKommentar();
		if(kasse == 0)
			kasse = p.getKasse();
		
	}

	public void save(Patient p){
		/*
			Da die Referenz im Kalender gebraucht wird, müssen wir die 
			Daten von einem neuen Patientenobjekt rüberkopieren.
			Vollständig!!!
		*/
		logger.warning("Save noch nicht fertig!!!");
		name = p.getNachname();
		vorname = p.getVorname();
		geburtstag = p.getGeburtstag();
		telefon = p.getTelefon();
		telefon2 = p.getTelefon2();
		telefon3 = p.getTelefon3();
		kommentare = p.getKommentar();
		termintext = p.getTermine();
		kasse = p.getKasse();
		//dauerPatient = p.getDauerPatient();
		herr = p.getHerr();
		therapeut = p.getTherapeut();
	}

	public boolean getHerr(){
		return herr;
	}

	public String getTelefon2(){
		return telefon2;
	}

	public String getTelefon3(){
		return telefon3;
	}
	
	public int getKasse(){
		return kasse;
	}

	public boolean getDauerPatient(){
		return dauerPatient;
	}

	public String getKommentar(){
		return kommentare;
	}

	public String getTermine(){
		return termintext;
	}
	
	public void addTermin(String text){
		termintext = termintext+"\n"+text;
	}
	
	public void setTermin(String text){
		termintext = text;
	}

	public int getTherapeut(){
		return therapeut;
	}

	public void setID(int id){
		this.id = id;
	}

	public int getID(){
		return id;
	}
}
