import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
//import java.awt.Toolkit;
import java.awt.datatransfer.*;
import java.util.logging.*;

public class PatientenFensterDialog extends JDialog{
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
	private Patient globalerPatient;
	private boolean update = false;
	private int index = 0;//patientenindex.

	private JPanel tisch;
	private BorderLayout bord;
	private JTabbedPane jt = new JTabbedPane();

	private JPanel panel = new JPanel();
	private JPanel stammdaten = new JPanel();
	private JPanel rezepte = new JPanel();
	private JPanel terminPanel = new JPanel();
	private Daten daten;
	private Physiomat physiomat;
	
	private String name = "";
	private String vorname = "";
	private String geburtstag = "";
	private String telefon = "";
	private String telefon2 = "";
	private String telefon3 = "";
	private String kommentare = "";
	private String termine = "";
	private boolean dauerPatient = false;
	private boolean noInit = false;
	//private boolean gesetzlich = true;
	private int kasse = 0;
	private int welcher = 0;
	private int maxPatienten = 0;
	
	// *** Labels ***
	private JLabel leer = new JLabel(" ");
	private JLabel leer2 = new JLabel(" ");
	private JLabel leer3 = new JLabel(" ");
	private JLabel leer4 = new JLabel(" ");
	private JLabel leer5 = new JLabel(" ");
	private JLabel leer6 = new JLabel(" ");
	private JLabel nameLabel = new JLabel("Name");
	private JLabel theraLabel = new JLabel("Therapeut");
	private JLabel nummer = new JLabel("000");
	private JLabel adressLabel = new JLabel("Adresse");
	private JLabel plzLabel = new JLabel("Postleitzahl");
	private JLabel ortLabel = new JLabel("Ort");
	private JLabel emailLabel = new JLabel("EMail");
	private JLabel telefonLabel = new JLabel("Telefon");
	private JLabel birthLabel = new JLabel("Geburtstag");
	private JLabel therapeutLabel = new JLabel("Therapeut");
	private JLabel krankenkassenLabel = new JLabel("Krankenkasse");
	private JLabel rezepteLabel = new JLabel("Rezepte");
	private JLabel kommentarLabel = new JLabel("Geschichte:");
	private JLabel patientenName = new JLabel();
	//private JLabel kommentarLabel = new JLabel("Geschichte:");
	
	private JButton RezeptButton = new JButton("Rezepte");
	private JButton leerButton = new JButton("Leeren");
	private JButton neuButton = new JButton("Neu");
	private JButton speichernButton = new JButton("Speichern");
	private JButton delButton = new JButton("Löschen");
	private JButton neuTerminButton = new JButton("Neue Termine");
	
	private JTextField vorName = new JTextField(15);
	private JTextField nachName = new JTextField(15);
	/*private JTextField adresseFD = new JTextField();
	private JTextField plzFD = new JTextField();
	private JTextField ortFD = new JTextField();
	private JTextField emailFD = new JTextField();*/
	private JTextField telefonFD = new JTextField();
	private JTextField telefon2FD = new JTextField();
	private JTextField telefon3FD = new JTextField();
	
	//private JTextField FD = new JTextField();
	private JTextField birthFD = new JTextField(10);
	//private JTextField monatFD = new JTextField(2);
	//private JTextField jahrFD = new JTextField(4);
	private JTextArea kommentarTA = new JTextArea();
	private JScrollPane kommentarSP = new JScrollPane(kommentarTA);
	private JTextArea termineTA = new JTextArea();
	private JScrollPane termineSP = new JScrollPane(termineTA);
	private JComboBox HerrFrau = new JComboBox();
	private JComboBox liste = new JComboBox();
	private JComboBox kasseCB = new JComboBox();
	private JComboBox theraCB = new JComboBox();
	private JRadioButton krankenkassenprivat = new JRadioButton("Privat");
	private JRadioButton krankenkassengesetz = new JRadioButton("Gesetzlich");
	private ButtonGroup kassenGroup = new ButtonGroup();
	private JCheckBox dauerpatient = new JCheckBox("Dauerpatient");
	
	private GridBagLayout gridbag = new GridBagLayout();
	private GridBagLayout gbl = new GridBagLayout();
	private GridBagLayout gbl2 = new GridBagLayout();
	private GridBagConstraints constraints = new GridBagConstraints();

	static void addComponent( Container cont, 
                            GridBagLayout gbl, 
                            Component c, 
                            int x, int y, 
                            int width, int height) 
  { 
    GridBagConstraints gbc = new GridBagConstraints(); 
    gbc.fill = GridBagConstraints.BOTH; 
    gbc.gridx = x; gbc.gridy = y; 
    gbc.gridwidth = width; gbc.gridheight = height; 
    gbc.weightx = 1.0; gbc.weighty = 1.0; 
    gbl.setConstraints( c, gbc ); 
    cont.add( c ); 
  } 

	
	public PatientenFensterDialog(Physiomat physiomat, Daten daten) {
		super(physiomat, "Patienten", true);
		this.physiomat = physiomat;
		this.daten = daten;
		this.setTitle("Patienten");
		this.setBounds(0,0,500,350);
		//this.getContentPane().add(sP); //jetzt in create
		initGUI();
	}
	
	private void initGUI(){
		bord = new BorderLayout();
		tisch = new JPanel();
		tisch.setLayout(bord);
		
		panel.setLayout(gridbag);
		stammdaten.setLayout(gbl);
		
		kommentarTA.setLineWrap(true);
		kommentarTA.setWrapStyleWord(true);
		termineTA.setLineWrap(true);
		termineTA.setWrapStyleWord(true);
		
		HerrFrau.addItem("Herr");
		HerrFrau.addItem("Frau");
		HerrFrau.setPreferredSize(new Dimension(80, 24)); 

		addComponent( panel, gridbag, HerrFrau, 1, 0, 1, 1);
		addComponent( panel, gridbag, patientenName, 2, 0, 1, 1);
		liste.setMaximumRowCount(25);
		addComponent( panel, gridbag, nameLabel, 0, 1, 1, 1);
		addComponent( panel, gridbag, vorName, 1, 1, 1, 1);
		addComponent( panel, gridbag, nachName, 2, 1, 1, 1);
		addComponent( stammdaten, gbl, krankenkassenLabel, 0, 0, 1, 1);
		addComponent( stammdaten, gbl, kasseCB, 1, 0, 1, 1);
		kasseCB.addItem("privat");
		kasseCB.addItem("AOK, BKK, IKK, ...");
		kasseCB.addItem("Barmer, DAK, TK, KKH, ...");
		/*addComponent( panel, gridbag, krankenkassenprivat, 1, 2, 1, 1);
		addComponent( panel, gridbag, krankenkassengesetz, 2, 2, 1, 1);
		//addComponent( panel, gridbag, leer, 0, 2, 1, 1);
		kassenGroup.add(krankenkassenprivat);
		kassenGroup.add(krankenkassengesetz);
		*/
		
		addComponent( stammdaten, gbl, theraLabel, 0, 2, 1, 1);
		addComponent( stammdaten, gbl, theraCB, 1, 2, 1, 1);
		//addComponent( stammdaten, gbl, dauerpatient, 2, 2, 1, 1);
		addComponent( stammdaten, gbl, telefonLabel, 0, 3, 1, 1);
		addComponent( stammdaten, gbl, telefonFD, 1, 3, 1, 1);
		addComponent( stammdaten, gbl, telefon2FD, 1, 4, 1, 1);
		addComponent( stammdaten, gbl, telefon3FD, 1, 5, 1, 1);
		addComponent( stammdaten, gbl, birthLabel, 0, 6, 1, 1);
		addComponent( stammdaten, gbl, birthFD, 1, 6, 1, 1);
		addComponent( stammdaten, gbl, kommentarLabel, 0, 7, 1, 1);
		addComponent( stammdaten, gbl, kommentarSP, 1, 7, 2, 7);
		addComponent( stammdaten, gbl, leer5, 0, 8, 1, 1);
		addComponent( stammdaten, gbl, leer6, 0, 9, 1, 1);
		addComponent( stammdaten, gbl, leer2, 0, 10, 1, 1);
		addComponent( stammdaten, gbl, leer3, 0, 11, 1, 1);
		addComponent( stammdaten, gbl, leer4, 0, 12, 1, 1);
		//addComponent( stammdaten, gbl, speichernButton, 3, 3, 1, 1);
		//addComponent( stammdaten, gbl, leerButton, 3, 3, 1, 1);
		addComponent( stammdaten, gbl, neuButton, 3, 3, 1, 1);
		//addComponent( stammdaten, gbl, speichernButton, 3, 5, 1, 1);
		//addComponent( stammdaten, gbl, delButton, 3, 6, 1, 1);
		//addComponent( panel, gridbag, neuTerminButton, 3, 8, 1, 1);
		//addComponent( stammdaten, gbl, termineSP, 2, 3, 1, 7);
		
		terminPanel.setLayout(new BoxLayout(terminPanel, BoxLayout.Y_AXIS)); 
		terminPanel.add(termineSP);
		
		RezeptButton.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				logger.finest("Rezepte werden angezeigt");
				nochNicht(); 
			} 
		} );
		
		leerButton.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				leeren(); 
			} 
		} );
		neuButton.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				neu();
				//nochNicht(); 
			} 
		} );
		speichernButton.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				save(); 
			} 
		} );
		delButton.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				//sicherheitsabfrage
				//int a = JOptionPane.showConfirmDialog(null,"choose one","choose one", JOptionPane.YES_NO_OPTION);
				int a = JOptionPane.showConfirmDialog(null, "Möchten Sie wirklich den Patienten "+" löschen?\n\nAlle Termine mit diesem Patienten werden gelöscht.", "Patienten löschen?", JOptionPane.YES_NO_OPTION); 
				if(a == 0){
					del();
				}
			}
		} );
		neuTerminButton.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				nochNicht(); 
			} 
		} );
		liste.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				logger.finest("Liste select");
				if(!update){
					logger.finest("Liste select aufgerufen:");
					select();
					//nochNicht(); 
				}
			} 
		} );
		
		
		jt.addTab("Stammdaten",stammdaten);
		jt.addTab("Termine",terminPanel);
		jt.addTab("Rezepte", rezepte);
		//addComponent( tisch, gbl2, panel, 0, 0, 4, 8); 
		addComponent( panel, gridbag, jt, 0, 2, 3, 9); 
		noInit = true;
		this.getContentPane().add(panel);
		//pack();
	}
	
	public void zeigen(){
		update();
		Patient p = daten.getPatient(index);
		//patientenName.setText(""+p.getNachname()+", "+p.getVorname());
		patientenName.setText("");
		//liste.setSelectedIndex(index);
		//update(index);
		//select();
		this.setVisible(true);
	}
	
	public void nochNicht(){
		//Noch nicht.
		JOptionPane.showMessageDialog(this, "Noch nicht eingebaut.", "Fehlt.", JOptionPane.ERROR_MESSAGE, null);
	}
	
	
	private void leeren(){
		if(!update){
			update = true;
			logger.finest("Alle Felder löschen");
			nachName.setText("");
			vorName.setText("");
			telefonFD.setText("");
			telefon2FD.setText("");
			telefon3FD.setText("");
			birthFD.setText("");
			kommentarTA.setText("");
			termineTA.setText("");
			HerrFrau.setSelectedIndex(0);
			//krankenkassengesetz.setSelected(true);
			//krankenkassenprivat.setSelected(false);
			kasseCB.setSelectedIndex(0);
			if(daten.getMaxTherapeuten() > 0)
				theraCB.setSelectedIndex(0);
			if(daten.getMaxPatienten() > 0)
				liste.setSelectedIndex(0);
			//dauerpatient.setSelected(false);
			update = false;
		}
	}
	
	private void neu(){
		logger.fine("Neuer Patient wird angelegt.");
		vorname = vorName.getText();
		name = nachName.getText();
		geburtstag = birthFD.getText();
		telefon = telefonFD.getText();
		telefon2 = telefon2FD.getText();
		telefon3 = telefon3FD.getText();
		kommentare = kommentarTA.getText();
		//gesetzlich = krankenkassengesetz.isSelected();
		//Patient = dauerpatient.isSelected();
		kasse = kasseCB.getSelectedIndex();
		boolean herr = false;
		if(HerrFrau.getSelectedIndex()==0)
			herr = true;
		//dauerPatient = dauerpatient.isSelected();
		termine = termineTA.getText();
		int therapeut = theraCB.getSelectedIndex();
		logger.finer("Überprüfe, ob neuer Patient schon existiert");
		Patient p = new Patient(vorname, name, geburtstag, telefon, telefon2, telefon3, kommentare, termine,  kasse, herr, therapeut);
		if(herr)
			logger.fine("Patientendaten:\nHerr "+vorname+" "+name+"\nGeburtstag: "+geburtstag+"\nTelefon: "+telefon+"\n"+telefon2+"\n"+telefon3+"\nKommentare: "+kommentare+"\nKasse: "+kasse+"\nTherapeut: "+therapeut+theraCB.getSelectedItem());
		else
			logger.fine("Patientendaten:\nFrau "+vorname+" "+name+"\nGeburtstag: "+geburtstag+"\nTelefon: "+telefon+"\n"+telefon2+"\n"+telefon3+"\nKommentare: "+kommentare+"\nKasse: "+kasse+"\nTherapeut: "+therapeut+theraCB.getSelectedItem());
		globalerPatient = p;
		if(daten.pruefePatient(p)){
			/*
			
			Überprüfe, ob es einen Patienten mit genau diesen Angaben schon existiert.
			Wenn ja, Fehlermeldung
			Neuen Patienten hinzufügen, alphabetisch sortiert!!!
			*/
			daten.addPatient(p);
			logger.fine("Patient wurde hinzugefügt");
		} else {
			int a = JOptionPane.showConfirmDialog(null, "Patient exitiert schon!\nWollen Sie die fehlenden Daten zu dem bestehenden Patienten hinzufügen?", "Patientenkonflikt", JOptionPane.YES_NO_OPTION); 
			logger.info("Patientenkonflikt");
			if(a == 0){
				daten.editPatient(p);
				logger.fine("Patient wurde überschrieben");
			} else {
				daten.addPatient(p);
			}
		}
		daten.setUnsave();
		dispose();
		update();
	}
	
	public void setDaten(Daten daten){
		this.daten = daten;
	}
	
	private void select(){
		//welcher = liste.getSelectedIndex();
		welcher = index;
		logger.finest("Liste select aufgerufen: "+welcher);
		Patient p = daten.getPatient(welcher);
		vorName.setText(p.getVorname());
		nachName.setText(p.getNachname());
		if(logger.isLoggable(Level.FINEST)) { logger.finest("Patient "+p.getVorname()+" "+p.getNachname()+" ausgewählt."); }
		if(p.getHerr())
			HerrFrau.setSelectedIndex(0);
		else
			HerrFrau.setSelectedIndex(1);
		vorName.setText(p.getVorname());
		nachName.setText(p.getNachname());
		telefonFD.setText(p.getTelefon());
		telefon2FD.setText(p.getTelefon2());
		telefon3FD.setText(p.getTelefon3());
		birthFD.setText(p.getGeburtstag());
		kasseCB.setSelectedIndex(p.getKasse());
		kommentarTA.setText(p.getKommentar());
		termineTA.setText(p.getTermine());
		if(daten.getMaxTherapeuten()>0)
			theraCB.setSelectedIndex(p.getTherapeut());
		/*
		if(p.getDauerPatient())
			dauerpatient.setSelected(true);
		else
			dauerpatient.setSelected(false);
		*/
	}

	private void save(){
		logger.fine("Vorhandener Patient wird gespeichert.\nWICHTIG: Alle Daten müssen auf dieselbe Referenz verweisen, weil sonst die Patienten aus dem Terminkalender verloren gehen.");
		if(daten.getMaxPatienten() <= 0){
			logger.fine("Es gibt noch keine Patienten,\nPatient wird umgeleitet zu \"Neu\".");
			neu();
		} else {
			vorname = vorName.getText();
			name = nachName.getText();
			geburtstag = birthFD.getText();
			telefon = telefonFD.getText();
			telefon2 = telefon2FD.getText();
			telefon3 = telefon3FD.getText();
			kommentare = kommentarTA.getText();
			//gesetzlich = krankenkassengesetz.isSelected();
			//Patient = dauerpatient.isSelected();
			kasse = kasseCB.getSelectedIndex();
			boolean herr = false;
			if(HerrFrau.getSelectedIndex()==0)
				herr = true;
			//dauerPatient = dauerpatient.isSelected();
			termine = termineTA.getText();
			int therapeut = theraCB.getSelectedIndex();//0 = keiner
			Patient p = new Patient(vorname, name, geburtstag, telefon, telefon2, telefon3, kommentare, termine,  kasse, herr, therapeut);
			Patient org = daten.getPatient(welcher);
			org.save(p);
			daten.savePatient(org, welcher);
			if(herr)
				logger.fine("Patient wurde gändert\nHerr "+vorname+" "+name+"\nGeburtstag: "+geburtstag+"\nTelefon: "+telefon+"\n"+telefon2+"\n"+telefon3+"\nKommentare: "+kommentare+"\nKasse: "+kasse+"\nTherapeut: "+therapeut+theraCB.getSelectedItem());
			else
				logger.fine("Patient wurde gändert\nFrau "+vorname+" "+name+"\nGeburtstag: "+geburtstag+"\nTelefon: "+telefon+"\n"+telefon2+"\n"+telefon3+"\nKommentare: "+kommentare+"\nKasse: "+kasse+"\nTherapeut: "+therapeut+theraCB.getSelectedItem());
		}
		leeren();
		update();
		dispose();
	}

	private void del(){
		if(logger.isLoggable(Level.FINE)) { logger.fine("Löschvorgang Patient: "+welcher+" "+vorName.getText()+" "+nachName.getText()); }
		update();
		nochNicht();

	}
	
	public void update(){
		//Liste aktualiseren
		update = true;
		liste.removeAllItems();
		Patient p;
		Patient p2;
		String vorher = "";
		String nun = "";
		String next = "";
		boolean doppelt = false;
		int c = 1;
		for(int i = 0; i < daten.getMaxPatienten(); i++){
			p = daten.getPatient(i);
			nun = ""+p.getNachname()+", "+p.getVorname();
			if((i+1)< daten.getMaxPatienten()){
				p2 = daten.getPatient(i+1);
				next = ""+p2.getNachname()+", "+p2.getVorname();
				if(nun.equals(next)){
					nun = nun+"["+c+++"] "+p.getGeburtstag();//nun = nun+"("+c+++")";
					doppelt = true;
				} else if(doppelt){
					nun = nun+"["+c+++"] "+p.getGeburtstag();//nun = nun+"("+c+++")";
					doppelt = false;
				}
			}
			/*
			nun = ""+p.getNachname()+", "+p.getVorname();
			if(nun.equals(vorher))
				nun = nun+"["+c+++"] "+p.getGeburtstag();//nun = nun+"("+c+++")";
			else {
				c = 1;
				vorher = nun;
			}
			*/
			liste.addItem(nun);
		}
		if(daten.getMaxPatienten() > 0)
			liste.setSelectedIndex(0);
		//Therapeuten aktualisieren
		theraCB.removeAllItems();
		theraCB.addItem("Keinen");
		Therapeut t;
		for(int i = 0; i < daten.getMaxTherapeuten(); i++){
			t = daten.getTherapeut(i);
			theraCB.addItem(""+t.getVorname()+" "+t.getNachname());
		}
		welcher = 0;
		update = false;
		daten.setUnsave();
	}
	
	public void update(int z){
		//Therapeuten aktualisieren
		theraCB.removeAllItems();
		theraCB.addItem("Keinen");
		Therapeut t;
		for(int i = 0; i < daten.getMaxTherapeuten(); i++){
			t = daten.getTherapeut(i);
			theraCB.addItem(""+t.getVorname()+" "+t.getNachname());
		}
		//Liste aktualiseren und Patient z auswählen.
		update = true;
		liste.removeAllItems();
		Patient p, p2;
		String vorher = "";
		String next = "";
		String nun = "";
		boolean doppelt = false;
		int c = 1;
		for(int i = 0; i < daten.getMaxPatienten(); i++){
			p = daten.getPatient(i);
			nun = ""+p.getNachname()+", "+p.getVorname();
			if((i+1)< daten.getMaxPatienten()){
				p2 = daten.getPatient(i+1);
				next = ""+p2.getNachname()+", "+p2.getVorname();
				if(nun.equals(next)){
					nun = nun+"["+c+++"] "+p.getGeburtstag();//nun = nun+"("+c+++")";
					doppelt = true;
				} else if(doppelt){
					nun = nun+"["+c+++"] "+p.getGeburtstag();//nun = nun+"("+c+++")";
					doppelt = false;
				}
			}
			/*
			nun = ""+p.getNachname()+", "+p.getVorname();
			if(nun.equals(vorher))
				nun = nun+"["+c+++"] "+p.getGeburtstag();//nun = nun+"("+c+++")";
			else {
				c = 1;
				vorher = nun;
			}
			*/
			liste.addItem(nun);
		}
		if(z < daten.getMaxPatienten()){
			liste.setSelectedIndex(z);
			welcher = z;
		}
		update = false;
	}
	
	public Patient getPatient(){
		return globalerPatient;
	}


}


