import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.datatransfer.*;
import java.io.*;
import java.util.*;
import java.util.logging.*;
import java.text.SimpleDateFormat;

public class Physiomat extends JFrame{
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
	/*
	private static Logger mainLogger = Logger.getLogger("de.sebamueller.Physiomat-Fehler");
	private Handler file_handler;
	private java.util.logging.Formatter klartext;
	private final String pattern = "Log-Physio-Fehler-%g.log"; 
	private final int limit = 10485760;//=10MB; 
	private final int numLogFiles = 7;
	*/
// ###### Deklaration #####
	public final String VERSION = Start.showVersion();

// ### Allgemeine Sachen ###
	private Daten daten;
	private File file = null;
	private File lastFile;
	private File lastDir;
	private JFileChooser jfc;

	private int i; // F\u00fcr alle i's im Programm (Ausgabeboxen)
	private int status = 0; //0 = Start 1 = Geladen 2 = Ungesichert
	public static final int START = 0;
	public static final int GELADEN = 1;
	public static final int UNSAVE = 2;

	//private Debug d = new Debug(false);
	private boolean debug = false;
	private boolean schliessen = false;
	private boolean beenden = false;
	private boolean warten = false;
	private String DateiString = "";

	private byte[] mem=new byte[5000000];

// ### Desktop ###
	private JPanel tisch;
	private JDesktopPane desktop; //= new JDesktopPane();
	private BorderLayout bord;
	private Statusbar statusbar;

// ### Fenster ###
	private PatientenFenster patientenfenster;// = new PatientenFenster();
	private TherapeutenFenster therapeutenfenster;
	private KalenderFenster kalenderfenster;
	//private KabinenFenster kabinenfenster;
	private KrankenkassenFenster krankenkassenfenster;
	private Anmeldung anmeldung;
	private AusruestungFenster ausruestungFenster;

//### M E N U S ###
	// Menu Obermenus

	private JMenuBar menuBar = new JMenuBar();
	private JMenu dateiMenu = new JMenu();
	private JMenu bearbMenu = new JMenu();
	private JMenu fensterMenu = new JMenu();
	private JMenu hilfeMenu = new JMenu("Hilfe");
	
	// Menu Datei
	//private JMenuItem Item = new JMenuItem();
	private JMenuItem openItem = new JMenuItem();
	private JMenuItem saveItem = new JMenuItem();
	private JMenuItem saveAsItem = new JMenuItem();
	private JMenuItem importItem = new JMenuItem();
	private JMenuItem beendenItem = new JMenuItem();
	
	// Menu Fenster
	private JMenuItem patientenItem = new JMenuItem();
	private JMenuItem therapeutenItem = new JMenuItem();
	private JMenuItem kalenderItem = new JMenuItem();
	private JMenuItem krankenkassenItem = new JMenuItem();
	private JMenuItem anmeldungItem = new JMenuItem();
	private JMenuItem kurseItem = new JMenuItem();
	private JMenuItem ausrustungItem = new JMenuItem();
	private JMenuItem druckweiteItem = new JMenuItem("Druckweite");
	//private JMenuItem Item = new JMenuItem();
	
	//Menü Hilfe
	private JMenuItem hilfeItem = new JMenuItem("Hilfe");
	private JMenuItem lizenzItem = new JMenuItem("Lizenz");
	private JMenuItem uberItem = new JMenuItem("Über Physiomat");
	
// ### TOOLBAR ###
	private JToolBar toolbar;
	private JButton openButton = new JButton();
	private JButton saveButton = new JButton();
	private JButton saveAsButton = new JButton();
	private JButton importButton = new JButton();
	private JButton helpButton = new JButton();
	private JButton aboutButton = new JButton();
	private JButton druckButton = new JButton();
	private JButton patientenButton = new JButton();
	private JButton therapeutenButton = new JButton();
	

	//### PopupMenu
	private JPopupMenu popup = new JPopupMenu("Bearbeiten");
	private JMenuItem cutItem = new JMenuItem("Ausschneiden");
	private JMenuItem kopierItem = new JMenuItem("Kopieren");
	private JMenuItem einfugItem = new JMenuItem("Einf\u00fcgen");
	
	private Transferable transfer;
	private Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();

	private static void ausgabe(){
		System.out.println("Zuviele Argumente.");
		System.out.println("Usage: java -jar Physiomat.jar [-d] File");
		System.out.println("-d: Debugmodus");
	}
	
	public void testeZeit(){
		/*
			Durch die Struktur des Programmes und seiner Daten, darf das Programm während des Tageswechsels nicht aktiv sein, oder es müsste alle Spalten um eins verschieben. Das ist mir zu blöde und deswegen schalte ich das Programm während der Zeiten 23:00 Uhr und 4:00 Uhr früh aus.
		*/
		Date jetzt = new Date();
		Calendar cal = Calendar.getInstance();
		cal.setTime(jetzt);
		int stunde = cal.get(Calendar.HOUR_OF_DAY);
		if(stunde >= 23 || stunde < 4){
			if(daten != null){
				//Wir sind schon eine ganze Weile offen.
				logger.info("Zum Schluss kurz ein letztes Mal Speichern.");
				for(int j = 0; j < 3; j++)
					daten.speichernErlaubt(j);
				Thread nt = new Thread(){
					public void run(){
						daten.save();
					}};
					nt.start();
			}
			JOptionPane.showMessageDialog(this,
				"Das Programm duldet keine Nachtarbeit.",
				"Nachtarbeit erkannt!", 
				JOptionPane.ERROR_MESSAGE, null);
				ende();
		}
	}
	
	private void logStart(){
		
	}
	
	public void testeDoppelgaenger(){
		/*
			Es darf nur eine Version pro Verzeichnis laufen, weil sie sich
			sonst gegenseitig die Daten überschreiben.
			Darf nichts loggen, weil die Daten von dem anderem Programm überschrieben werden.
		*/
		FileOutputStream fos;
		BufferedWriter bw;
		File file = new File(".physiomat/.lauf");
		File verzeichnis = new File(".physiomat");
		String ausgabe = "";
		if(!verzeichnis.exists()){
			//logger.info("Verzeichnis "+verzeichnis.getAbsolutePath()+ " existiert noch nicht.");
			if(!verzeichnis.mkdirs()){
				;//logger.info("Verzeichnis "+verzeichnis.getAbsolutePath()+ " konnte nicht angelegt werden.");
				try{
					fos = new FileOutputStream(file);
					bw = new BufferedWriter(new OutputStreamWriter(fos,"UTF-8"));
					bw.flush();
					fos.flush();
					fos.close();
				} catch (java.io.IOException e){
					e.printStackTrace();
					ausgabe = "Fehler beim Speichern von "+file.getAbsolutePath();
				}
			}
		} else {
			//logger.info("Verzeichnis "+verzeichnis.getAbsolutePath()+ " existiert schon.");
			if (file.exists()){
				JOptionPane.showMessageDialog(this,
				"Das Programm läuft schon.",
				"Doppelgänger erkannt!", 
				JOptionPane.ERROR_MESSAGE, null);
				System.exit(0);
			} else {
				try{
					fos = new FileOutputStream(file);
					bw = new BufferedWriter(new OutputStreamWriter(fos,"UTF-8"));
					bw.flush();
					fos.flush();
					fos.close();
				} catch (java.io.IOException e){
					e.printStackTrace();
					ausgabe = "Fehler beim Speichern von "+file.getAbsolutePath();
				}
			}
		}
		
		//renameFile.delete()
	}

	public Physiomat() {
		testeDoppelgaenger();
		testeZeit();
		daten = new Daten(-1,this);
		initGUI();
	}

	public Physiomat(int loglevel){
		testeDoppelgaenger();
		testeZeit();
		daten = new Daten(loglevel, this);
		initGUI();
	}

	public Physiomat(int loglevel, File file){
		this.file = file;
		testeDoppelgaenger();
		testeZeit();
		daten = new Daten(loglevel, this);
		initGUI();
	}

	private void initGUI(){
		
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		MenuActionAdapter listener = new MenuActionAdapter(this);
		this.setSize(new Dimension(736,600));
		setExtendedState(JFrame.MAXIMIZED_BOTH);
		this.setTitle("Physiomat");
		ImageIcon icon = new ImageIcon(Physiomat.class.getResource("icons/Jar24.gif"));
		setIconImage(icon.getImage());
		this.addWindowListener(listener);
		
		bord = new BorderLayout();
		desktop = new JDesktopPane();
		tisch = new JPanel();
		
		// Beschriften und Initialisieren der Men\u00fcs und Items
		dateiMenu.setText("Datei");
		dateiMenu.setMnemonic('D');
		fensterMenu.setText("Fenster");
		fensterMenu.setMnemonic('F');
		hilfeMenu.setMnemonic('H');

		//Datei
		/*
		Item.setText("Speichern");
		Item.addActionListener(new MenuActionAdapter(this));
		Item.setAccelerator(KeyStroke.getKeyStroke('S', InputEvent.CTRL_MASK));
		*/
		openItem.setText("Öffnen");
		openItem.addActionListener(new MenuActionAdapter(this));
		openItem.setAccelerator(KeyStroke.getKeyStroke('O', InputEvent.CTRL_MASK));
		saveItem.setText("Speichern");
		saveItem.addActionListener(new MenuActionAdapter(this));
		saveItem.setAccelerator(KeyStroke.getKeyStroke('S', InputEvent.CTRL_MASK));
		saveAsItem.setText("Speichern unter");
		saveAsItem.addActionListener(new MenuActionAdapter(this));
		//importItem.setText("Importieren");
		//importItem.addActionListener(new MenuActionAdapter(this));
		beendenItem.setText("Beenden");
		beendenItem.addActionListener(new MenuActionAdapter(this));
		beendenItem.setAccelerator(KeyStroke.getKeyStroke('Q', InputEvent.CTRL_MASK));
		
		//Fenster
		patientenItem.setText("Patienten");
		patientenItem.addActionListener(new MenuActionAdapter(this));
		patientenItem.setMnemonic('P');
		therapeutenItem.setText("Therapeuten");
		therapeutenItem.addActionListener(new MenuActionAdapter(this));
		therapeutenItem.setMnemonic('T');
		kalenderItem.setText("Kalender");
		kalenderItem.addActionListener(new MenuActionAdapter(this));
		krankenkassenItem.setText("Krankenkasse");
		krankenkassenItem.addActionListener(new MenuActionAdapter(this));
		anmeldungItem.setText("Anmeldung");
		anmeldungItem.addActionListener(new MenuActionAdapter(this));
		kurseItem.setText("Kursplanung");
		kurseItem.addActionListener(new MenuActionAdapter(this));
		ausrustungItem.setText("Ausrüstung");
		ausrustungItem.addActionListener(new MenuActionAdapter(this));
		ausrustungItem.setMnemonic('A');
		druckweiteItem.addActionListener(new MenuActionAdapter(this));
		
		//Hilfe
		hilfeItem.addActionListener(new MenuActionAdapter(this));
		lizenzItem.addActionListener(new MenuActionAdapter(this));
		uberItem.addActionListener(new MenuActionAdapter(this));
		
		// Den Men\u00fcs die Items und das Untermen\u00fc hinzuf\u00fcgen
		dateiMenu.add(openItem);
		dateiMenu.addSeparator();
		dateiMenu.add(saveItem);
		dateiMenu.add(saveAsItem);
		//dateiMenu.addSeparator();
		//dateiMenu.add(importItem);
		dateiMenu.addSeparator();
		dateiMenu.add(beendenItem);
		
		//fensterMenu.add(anmeldungItem);
		fensterMenu.add(patientenItem);
		fensterMenu.add(therapeutenItem);
		fensterMenu.add(kalenderItem);
		//fensterMenu.add(krankenkassenItem);
		fensterMenu.addSeparator();
		//fensterMenu.add(kurseItem);
		fensterMenu.add(ausrustungItem);
		fensterMenu.add(druckweiteItem);
		
		hilfeMenu.add(hilfeItem);
		hilfeMenu.addSeparator();
		hilfeMenu.add(lizenzItem);
		hilfeMenu.addSeparator();
		hilfeMenu.add(uberItem);
		
		// Dem JMenuBar-Objekt die JMenu\u00b4s hinzuf\u00fcgen
		menuBar.add(dateiMenu);
		//menuBar.add(bearbMenu);
		menuBar.add(fensterMenu);
		//menuBar.add(optionenMenu);
		menuBar.add(hilfeMenu);

		// Dem Frame das JMenuBar-Objekt hinzuf\u00fcgen
		this.setJMenuBar(menuBar);
		
		kopierItem.addActionListener(new MenuActionAdapter(this));
		einfugItem.addActionListener(new MenuActionAdapter(this));
		cutItem.addActionListener(new MenuActionAdapter(this));
		
		openButton.addActionListener(new MenuActionAdapter(this));
		saveButton.addActionListener(new MenuActionAdapter(this));
		saveAsButton.addActionListener(new MenuActionAdapter(this));
		helpButton.addActionListener(new MenuActionAdapter(this));
		aboutButton.addActionListener(new MenuActionAdapter(this));
		patientenButton.addActionListener(new MenuActionAdapter(this));
		therapeutenButton.addActionListener(new MenuActionAdapter(this));
		//importButton.addActionListener(new MenuActionAdapter(this));
		//druckButton.addActionListener(new MenuActionAdapter(this));
		
		popup.add(cutItem);
		popup.add(kopierItem);
		popup.add(einfugItem);
		
		//Einzelne Fenster hinzufügen
		patientenfenster = new PatientenFenster();
		therapeutenfenster = new TherapeutenFenster(this);
		kalenderfenster = new KalenderFenster(daten);
		kalenderfenster.frame(this);
		//kabinenfenster = new KabinenFenster();
		//krankenkassenfenster = new KrankenkassenFenster();
		anmeldung = new Anmeldung();
		ausruestungFenster = new AusruestungFenster(daten);

		patientenfenster.setDaten(daten);
		therapeutenfenster.setDaten(daten);
		//kalenderfenster.setDaten(daten);
		
		desktop.add(anmeldung);
		desktop.add(patientenfenster);
		desktop.add(therapeutenfenster);
		desktop.add(kalenderfenster);
		//desktop.add(kabinenfenster);
		//desktop.add(krankenkassenfenster);
		desktop.add(ausruestungFenster);
		
		
		setButtons();
		
		toolbar = new JToolBar();

		toolbar.add(openButton);
		toolbar.addSeparator();
		toolbar.add(saveButton);
		toolbar.add(saveAsButton);
		toolbar.addSeparator();
		toolbar.add(patientenButton);
		toolbar.add(therapeutenButton);
		toolbar.addSeparator();
		toolbar.add(helpButton);
		toolbar.add(aboutButton);
		
		
		/*
		toolbar.addSeparator();
		toolbar.add(importButton);
		toolbar.addSeparator();
		toolbar.add(druckButton);
		//toolbar.addSeparator();
		*/
		
		// Instanzierung einer Statusleiste mit 4 Feldern 
		statusbar = new Statusbar(2); 
		
		// Den einzelnen Feldern Texte hinzufuegen 
		statusbar.setText(0, "Statuszeile: "); 
		statusbar.setText(1, "Beispieltext: "); 
		statusbar.setBarText("Fertig");
		//statusbar.indeterminate();
		statusbar.absolute();
		//statusbar.setText(2, "EMails: "); 
		//statusbar.setText(3, "Zeit: "); 
		
		//bar = new JToolBar();
		tisch.setLayout(bord);
		tisch.add(BorderLayout.NORTH, toolbar);
		tisch.add("Center", desktop);
		tisch.add(BorderLayout.SOUTH, statusbar);
		desktop.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
		this.getContentPane().add(tisch);
		this.setVisible(true);
		setStatus(status);
		setUnstable(true);
		Thread nt = new Thread(){ public void run(){ daten.init(file); }};
		nt.start();
		/*
		Totaler Unsinn, da er nicht zurückkommt.
		setStatusBar(100, "", "Fertig.", "100%");
		setStatusBar(100);
		*/
		/*JOptionPane.showMessageDialog(this,
				"Tabellen sind initialisiert.",
				"Fertig.", 
				JOptionPane.INFORMATION_MESSAGE, null);*/
		/*
		Nun natürlich genauso dooof
		kalenderfenster.zeigen();
		desktop.moveToFront(kalenderfenster);
		try {
			kalenderfenster.setSelected(true);
	    	} catch (java.beans.PropertyVetoException PVE) {
			PVE.printStackTrace();
		}
		*/
		/*try{
			SwingUtilities.updateComponentTreeUI(this);
		}
		catch (NullPointerException npe){
			System.err.println("Nullpointereception beim Erstellen der GUI. Programm muss neu gestartet werden.");
			JOptionPane.showMessageDialog(this,
				"Nullpointereception beim Erstellen der GUI. Programm muss neu gestartet werden.",
				"Nullpointerexception beim Starten", 
				JOptionPane.ERROR_MESSAGE, null);
			System.exit(-1);
		}*/
	}
	
	public void ende(){
		/*
			Hier wird das Programm beendet
		*/
		logger.info("Das Programm soll sich beenden.");
		final File file = new File(".physiomat/.lauf");
		if(status == UNSAVE){
			int i = JOptionPane.showConfirmDialog(this,"Es gibt ungespeicherte Daten\n\nWollen Sie jetzt Speichern?","Beenden",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.WARNING_MESSAGE, null);
			switch(i){
				case JOptionPane.YES_OPTION: 
					logger.info("Nochmal kurz Speichern.");
					for(int j = 0; j < 3; j++)
						daten.speichernErlaubt(j);
					Thread nt = new Thread(){
						public void run(){
							daten.save();
							daten.logEnde();
							file.delete();
							System.exit(0);
					}};
					nt.start();
					break;
				case JOptionPane.NO_OPTION: 
					logger.info("Nicht Speichern.");
					daten.logEnde();
					file.delete();
					System.exit(0);
					break;
				case JOptionPane.CANCEL_OPTION://Tue nüscht.
			}
		} else {
			if(daten!=null)
				daten.logEnde();
			file.delete();
			System.exit(0);
		}
	}
	
	void menuEvent(ActionEvent e) {
		String cmd = e.getActionCommand();
		String ubermichtext = "Physiomat\n"+VERSION+"\n\nAutor: Sebastian Müller\nJahr: 2010\nLizenz: GPL\nQuelltext ist im JAR enthalten.\n\nMehr Informationen:\nhttp://www.sebamueller.de/programme/physiomat/\n\nEMail:\nphysiomat@sebamueller.de";
		String hilfetext = "OK.\nStell dich gerade hin!\nHole tief Luft!\n\nUnd nun sage laut: \"Du schaffst das!\"\n\nUnd dann schaffst Du das auch.";
		Object src = e.getSource();
		if (!warten)
			if(src == beendenItem){
				ende();
			} else if(src == patientenItem){
				patientenfenster.zeigen();
				desktop.moveToFront(patientenfenster);
				try {
					patientenfenster.setSelected(true);
	    			} catch (java.beans.PropertyVetoException PVE) {
					PVE.printStackTrace();
				}
			} else if(src == patientenButton){
				patientenfenster.zeigen();
				desktop.moveToFront(patientenfenster);
				try {
					patientenfenster.setSelected(true);
	    			} catch (java.beans.PropertyVetoException PVE) {
					PVE.printStackTrace();
				}
			} else if(src == therapeutenItem){
				therapeutenfenster.zeigen();
				desktop.moveToFront(therapeutenfenster);
				try {
					therapeutenfenster.setSelected(true);
	    			} catch (java.beans.PropertyVetoException PVE) {
					PVE.printStackTrace();
				}
			/*} else if(src == krankenkassenItem){
				krankenkassenfenster.zeigen();
				desktop.moveToFront(krankenkassenfenster);
				try {
					krankenkassenfenster.setSelected(true);
	    			} catch (java.beans.PropertyVetoException PVE) {
					PVE.printStackTrace();
				}
			} else if(src == anmeldungItem){
				anmeldung.zeigen();
				desktop.moveToFront(anmeldung);
				try {
					anmeldung.setSelected(true);
	    			} catch (java.beans.PropertyVetoException PVE) {
					PVE.printStackTrace();
				}*/
			} else if(src == therapeutenButton){
				therapeutenfenster.zeigen();
				desktop.moveToFront(therapeutenfenster);
				try {
					therapeutenfenster.setSelected(true);
	    			} catch (java.beans.PropertyVetoException PVE) {
					PVE.printStackTrace();
				}
			} else if(src == kalenderItem){
				kalenderfenster.zeigen();
				desktop.moveToFront(kalenderfenster);
				try {
					kalenderfenster.setSelected(true);
	    			} catch (java.beans.PropertyVetoException PVE) {
					PVE.printStackTrace();
				}
			} else if(src == druckweiteItem){
				/*String response = JOptionPane.showInputDialog(this,
					"Druckweite der Tabelle in Pixel?",
						"Drucken",
						JOptionPane.QUESTION_MESSAGE, ""+daten.getDruckweite());*/
				String response = ""+daten.getDruckweite();
				response = JOptionPane.showInputDialog(this, "Druckweite der Tabelle in Pixel?",""+daten.getDruckweite());
				try {
					if(!response.equals(""))
						daten.setDruckweite(Integer.valueOf(response)); 
				} catch (java.lang.NumberFormatException nfe){
					logger.warning("Druckweite konnte nicht eingestellt werden. \nKeine Zahl: "+response);
					JOptionPane.showMessageDialog(this,
				"Es wurde eine positive Zahl kleiner 1000 größer 0 erwartet.",
				"Keine positive Zahl!", 
				JOptionPane.ERROR_MESSAGE, null);
				}
			} else if(src == ausrustungItem){
				ausruestungFenster.zeigen();
				desktop.moveToFront(ausruestungFenster);
				try {
					ausruestungFenster.setSelected(true);
	    			} catch (java.beans.PropertyVetoException PVE) {
					PVE.printStackTrace();
				}
			} else if(src == saveItem){
				setUnstable(true);//Niemand darf, bis ende
				for(int i = 0; i < 3; i++)
					daten.speichernErlaubt(i);
				save();
			} else if(src == saveButton){
				JDialog x = new JDialog();//Niemand darf, bis ende
				for(int i = 0; i < 3; i++)
					daten.speichernErlaubt(i);
				save();
			} else if(src == saveAsItem){
				setUnstable(true);//Niemand darf, bis ende
				saveBackup();
			} else if(src == saveAsButton){
				setUnstable(true);//Niemand darf, bis ende
				saveBackup();
			} else if(src == openItem){
				setUnstable(true);//Niemand darf, bis ende
				open();
			} else if(src == openButton){
				setUnstable(true);//Niemand darf, bis ende
				open();
			} else if(src == lizenzItem){
				GPL gpl = new GPL(this);
			} else if(src == hilfeItem){
				JOptionPane.showConfirmDialog(this, hilfetext, "Hilfe", JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE, null);
			} else if(src == uberItem){
				JOptionPane.showConfirmDialog(this, ubermichtext, "Über mich.", JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE, null);
			} else if(src == helpButton){
				JOptionPane.showConfirmDialog(this, hilfetext, "Hilfe", JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE, null);
			} else if(src == aboutButton){
				JOptionPane.showConfirmDialog(this, ubermichtext, "Über mich.", JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE, null);
			} else {
				int i = JOptionPane.showConfirmDialog(this,
				"Das ist noch nicht eingebaut",
				"allg. Versionsproblem", JOptionPane.DEFAULT_OPTION,
				JOptionPane.INFORMATION_MESSAGE, null);
			}
	}
	
	public void setStatus(int s) {
		switch(s){
			case START:// Anfangszustand
				status = s;
				DateiString ="";
				this.setTitle("Physiomat");
				break;
			case GELADEN:// Geladen
				status = s;
				this.setTitle("Physiomat");// ("+DateiString+")");
				break;
			case UNSAVE:// Ver\u00e4ndert (Speichern Pflicht)
				status = s;
				this.setTitle("Physiomat [ungespeichert]");
				break;
			default:// Fehler, darf nicht vorkommen
				this.setTitle("Physiomat: Fehler");

		}
	}
	
	public void setUnstable(boolean unstable){
		if(unstable){
			//Setze alles auf nichtklickbar
			dateiMenu.setEnabled(false);
			fensterMenu.setEnabled(false);
			hilfeMenu.setEnabled(false);
			openButton.setEnabled(false);
			saveButton.setEnabled(false);
			saveAsButton.setEnabled(false);
			patientenButton.setEnabled(false);
			therapeutenButton.setEnabled(false);
		} else {
			//Setze alle Button auf klickbar
			dateiMenu.setEnabled(true);
			fensterMenu.setEnabled(true);
			hilfeMenu.setEnabled(true);
			openButton.setEnabled(true);
			saveButton.setEnabled(true);
			saveAsButton.setEnabled(true);
			patientenButton.setEnabled(true);
			therapeutenButton.setEnabled(true);
		}
	}

	public void setStatusBar(int x, String text1, String text2, String text3){
		statusbar.setText(0, text1); 
		statusbar.setText(1, text2); 
		statusbar.setBarText(text3);
		statusbar.setMax(x);
		//statusbar.indeterminate();
		statusbar.absolute();
	}

	public void setStatusBar(int x){
		statusbar.setValue(x);
		//if (logger.isLoggable(Level.FINEST)) { logger.finest("Setze Statusbar: "+x); }
	}

	public void setStatusBar(String x){
		statusbar.setText(1, x);
		//if (logger.isLoggable(Level.FINEST)) { logger.finest("Statusbar 1: "+x); }
	}

	public void setStatusBar(String x, String y){
		statusbar.setText(0, x);
		statusbar.setText(1, y);
		//if (logger.isLoggable(Level.FINEST)) { logger.finest("Statusbar:\n"+x+"\n"+y); }
	}

	public void setStatusBar(int x, String y){
		statusbar.setBarText(y);
		statusbar.setValue(x);
		//if (logger.isLoggable(Level.FINEST)) { logger.finest("Statusbar: "+x+"\n"+y); }
	}
	
	private void setButtons(){
		openButton.setIcon(new ImageIcon(Physiomat.class.getResource("icons/Open24.gif")));
		saveButton.setIcon(new ImageIcon(Physiomat.class.getResource("icons/Save24.gif")));
		saveAsButton.setIcon(new ImageIcon(Physiomat.class.getResource("icons/SaveAs24.gif")));
		helpButton.setIcon(new ImageIcon(Physiomat.class.getResource("icons/Help24.gif")));
		aboutButton.setIcon(new ImageIcon(Physiomat.class.getResource("icons/About24.gif")));
		importButton.setIcon(new ImageIcon(Physiomat.class.getResource("icons/Import24.gif")));
		druckButton.setIcon(new ImageIcon(Physiomat.class.getResource("icons/Print24.gif")));
		patientenButton.setIcon(new ImageIcon(Physiomat.class.getResource("icons/P24.gif")));
		therapeutenButton.setIcon(new ImageIcon(Physiomat.class.getResource("icons/T24.gif")));
		
		openButton.setToolTipText("Daten Laden");
		saveButton.setToolTipText("Daten speichern");
		saveAsButton.setToolTipText("Daten speichern unter");
		helpButton.setToolTipText("Hilfe");
		aboutButton.setToolTipText("\u00dcber Physiomat");
		importButton.setToolTipText("Importieren");
		druckButton.setToolTipText("Drucken");
		patientenButton.setToolTipText("Patientenansicht");
		therapeutenButton.setToolTipText("Therapeutenansicht");
	}

	public void save(){
		/*
			hier wird gespeichert, neuer Thread und dann Daten aufrufen
			public, damit auch ein externer Trigger (z.B. nach 15 Minuten)
			auch speichern darf.
		*/
		Thread t = new Thread(){
			public void run(){
				daten.save();
			}
		};
		t.start();
	}
	
	public void saveBackup(){
		/*
			hier wird gespeichert, neuer Thread und dann Daten aufrufen
			public, damit auch ein externer Trigger (z.B. nach 15 Minuten)
			auch speichern darf.
		*/
		
		int z;
		logger.fine("Datei speichern unter");
		if (null == lastDir)
			jfc = new JFileChooser();
		else
			jfc = new JFileChooser(lastDir);
		jfc.setDialogTitle("Speichern Unter");
		jfc.addChoosableFileFilter(makeFileFilter("Physiomat-Dateien", new String[]{"*.pmt"}));
		z = jfc.showSaveDialog(this);
		if (z == jfc.APPROVE_OPTION){
			String datei = jfc.getSelectedFile().getName();
			String path = jfc.getSelectedFile().getPath();
			String absPath = jfc.getSelectedFile().getAbsolutePath();
			file = new File(absPath);
			lastDir = file;
			if (file.exists()){
				logger.fine("Datei existiert schon");
				int j = JOptionPane.showConfirmDialog(this,
				"Die Datei existiert schon\n\nWollen Sie die Datei \u00fcberschreiben?",
				"Speichern unter (\u00fcberschreiben)", JOptionPane.YES_NO_OPTION,
				JOptionPane.QUESTION_MESSAGE, null);
				if (j == JOptionPane.YES_OPTION){
					logger.fine("Sicherheitskopie anlegen: "+absPath+".bak");
						/*String renameFile = absPath+".bak";
							FileCopy fc = new FileCopy(absPath, renameFile);*/
					logger.fine("Existiert die Sicherung schon?");
					File renameFile= new File(absPath+".bak");
					if (renameFile.exists()){
						logger.fine("Ja, existiert");
						if(!renameFile.delete()){ //Zieldatei erst mal loeschen
							logger.fine("L\u00f6schen des Backups nicht m\u00f6glich.");
						} else {
							logger.fine("Backup gel\u00f6scht!");
						}
					} else {
						logger.fine("Nein, noch nicht!");
					}
					//File renameFile= new File(absPath+".bak");
					if(file.renameTo(renameFile)){
						logger.fine("Datei wurde umbenannt");
					} else {
						logger.fine("Die Datei konnte nicht umbenannt werden");
						JOptionPane.showMessageDialog(this, "Es konnte kein Backup angelegt werden!",
							"Datei speichern", JOptionPane.WARNING_MESSAGE);
					}
					logger.fine("Datei \u00fcberschreiben");
					Thread t = new Thread(){
						public void run(){
							daten.save(file);
						}
					};
					t.start();
				} else {
					logger.fine("Datei nicht \u00fcberschreiben");
					saveBackup();
				}
			} else {
				logger.fine("Datei existiert noch nicht");
				Thread t = new Thread(){
					public void run(){
						daten.save(file);
					}
				};
				t.start();
			}
		}
	}
	
	public void open(){
		int z;
		logger.fine("Eine Datei öffnen");
		if (null == lastDir)
			jfc = new JFileChooser();
		else
			jfc = new JFileChooser(lastDir);
		jfc.setDialogTitle("Öffnen von Physiomatdateien");
		jfc.addChoosableFileFilter(makeFileFilter("Physiomat-Dateien", new String[]{"*.pmt"}));
		z = jfc.showOpenDialog(this);
		if (z == jfc.APPROVE_OPTION){
			String datei = jfc.getSelectedFile().getName();
			String path = jfc.getSelectedFile().getPath();
			String absPath = jfc.getSelectedFile().getAbsolutePath();
			file = new File(absPath);
			lastDir = file;
			if (file.exists()){
				logger.fine("Datei existiert -- wunderbar");
				Thread t = new Thread(){
					public void run(){
						daten.open(file);
					}
				};
				t.start();
			}
		}
	}
	
	public static javax.swing.filechooser.FileFilter makeFileFilter(String description, String [] pattern){
		final String [] p = pattern;
		final String d = description;
		return new javax.swing.filechooser.FileFilter(){
			private String [] pat = p;
			public boolean accept(File file){
				if (file.isDirectory()) return true;
				for (int i=0;i<pat.length;i++) if (searchPattern(pat[i].toUpperCase(), file.getName().toUpperCase())) return true;
				return false;
			}
			public String getDescription()
			{
				String des=d+" ("+pat[0];
				for (int i=1;i<pat.length;i++) des+=", "+pat[i];
				return des+")";
			}
		};
	}
	
	public static boolean searchPattern(String pattern, String text){
		return searchPattern(pattern, 0, text, 0);
	}

	public static boolean searchPattern(String pattern, int ip, String text, int it){
//	System.out.println("\""+pattern.substring(ip)+"\"<>\""+text.substring(it)+"\"");
		if (ip>=pattern.length() && it>=text.length()) return true;
		if (ip>=pattern.length()) return false;
		if (it>=text.length()){
			if (pattern.charAt(ip)=='*') return searchPattern(pattern, ip+1, text, it);
			return false;
		}
		if (pattern.charAt(ip)=='?') return searchPattern(pattern, ip+1, text, it+1);
		if (pattern.charAt(ip)=='*'){
			for (int i=it;i<=text.length();i++)
			if (searchPattern(pattern, ip+1, text, i)) return true;
			return false;
		}
		if (pattern.charAt(ip)!=text.charAt(it)) return false;
		return searchPattern(pattern, ip+1, text, it+1);
	}
	
	public KalenderFenster getKalenderFenster(){
		return kalenderfenster;
	}
	
	public PatientenFenster getPatientenFenster(){
		return patientenfenster;
	}
	
	public TherapeutenFenster getTherapeutenFenster(){
		return therapeutenfenster;
	}
	
	public void nachInit(){
		kalenderfenster.zeigen();
		desktop.moveToFront(kalenderfenster);
		try {
			kalenderfenster.setSelected(true);
		} catch (java.beans.PropertyVetoException PVE) {
			PVE.printStackTrace();
		}
		//kalenderfenster.drueckeKnopf();
	}

}


// Listener-Klasse f\u00fcr JMenuItem-Events
class MenuActionAdapter extends WindowAdapter implements ActionListener {
	Physiomat obj;

	MenuActionAdapter(Physiomat obj) {
		super();//Vielleicht kann dies weggelassen werden?
		this.obj = obj;
	}

	public void actionPerformed(ActionEvent e) {
		obj.menuEvent(e);
	}

	// Um die Anwendung beenden zu k\u00f6nnen
	public void windowClosing(WindowEvent e) {
		obj.ende();
	}
}
