import java.util.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.logging.*;

public class TerminAuswahl extends JDialog{
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
	protected int dauer = 0;
	protected Vector<Termin> termine = new Vector<Termin>(1,1);
	protected Physiomat physiomat;
	protected Daten daten;
	//protected Eintrag eintrag;
	protected Patient patient;
	protected String therapie = "";
	
	private Container c = this.getContentPane(); 
	private	GridBagLayout gbl = new GridBagLayout(); 
	private	GridBagLayout gbl2 = new GridBagLayout(); 
	private	GridBagLayout gbl3 = new GridBagLayout(); 
	private	GridBagLayout gbl4 = new GridBagLayout(); 
	private JPanel cbPanel = new JPanel();
	private JPanel mainPanel = new JPanel();
	private JPanel buttonPanel = new JPanel();
	protected Vector<JCheckBox> checkboxen = new Vector<JCheckBox>(10,10);
	
	private JButton ok = new JButton("OK");
	private JButton cancel = new JButton("Abbrechen");
	
	static void addComponent( Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty ) { 
		GridBagConstraints gbc = new GridBagConstraints(); 
		gbc.fill = GridBagConstraints.BOTH; 
		gbc.gridx = x; gbc.gridy = y; 
		gbc.gridwidth = width; gbc.gridheight = height; 
		gbc.weightx = weightx; gbc.weighty = weighty; 
		gbl.setConstraints( c, gbc ); 
		cont.add( c ); 
	} 
	
	static void addComponent( Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height) 
	{ 
		GridBagConstraints gbc = new GridBagConstraints(); 
		gbc.fill = GridBagConstraints.BOTH; 
		gbc.gridx = x; gbc.gridy = y; 
		gbc.gridwidth = width; gbc.gridheight = height; 
		gbc.weightx = 1.0; gbc.weighty = 1.0; 
		gbl.setConstraints( c, gbc ); 
		cont.add( c ); 
	}
	
	public TerminAuswahl(Physiomat physiomat, Daten daten, int dauer, Vector<Termin> termine, Patient patient, String therapie){
		super(physiomat, "Termine auswählen", true);
		this.physiomat = physiomat;
		this.dauer = dauer;
		this.termine = termine;
		this.daten = daten;
		//this.eintrag = eintrag;
		this.patient = patient;
		this.therapie = therapie;
		//logger.finest("Daten der Terminauswahl:\nDauer: "+dauer+"\nTermine: "+termine+"\nPatient: "+patient+"\nTherapie: "+therapie);
		initGUI();
	}
	
	private void initGUI(){
		this.setBounds(0,0,400,450);
		setLocationRelativeTo(null);
		mainPanel.setLayout(new BorderLayout());
		cbPanel.setLayout(gbl);
		c.setLayout(gbl3);
		buttonPanel.setLayout(gbl4);
		
		ok.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					ok();
				}
			} 
		);
		
		cancel.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					cancel();
				}
			} 
		);
		
		int tag, monat, jahr;
		int thera;
		Therapeut th;
		int i;
		TerminTag tt;
		int zeile;
		for(i = 0; i < termine.size(); i++){
			tt = (TerminTag)termine.get(i);
			tag = tt.getTag();
			monat = tt.getMonat();
			jahr = tt.getJahr();
			thera = tt.getTherapeut();
			zeile = tt.getZeile();
			th = daten.getTherapeut(thera);
			JCheckBox cb = new JCheckBox(tt.getWochentag()+":"+tag+"."+monat+"."+jahr+" um "+daten.UHRZEIT[zeile-1]+" bei "+th.getVorname()+" "+th.getNachname());
			addComponent( cbPanel, gbl, cb, 0, i, 1, 1);
			checkboxen.add(cb);
		}
		
		JScrollPane sp = new JScrollPane(cbPanel);
		//addComponent( mainPanel, gbl2, sp, 0, 0 , 1, 5);
		addComponent( buttonPanel, gbl2, ok, 0, 0 , 1, 1);
		addComponent( buttonPanel, gbl2, cancel, 1, 0 , 1, 1);
		//addComponent( mainPanel, gbl2, buttonPanel, 0, 5 , 1, 1);
		mainPanel.add(BorderLayout.CENTER, sp);
		mainPanel.add(BorderLayout.SOUTH, buttonPanel);
		addComponent( c, gbl3, mainPanel, 0,0,1,1);
		//pack();
		setVisible(true);
	}
	
	private void ok(){
		/*
			Unbedingt prüfen, wenn die eingetragenen Termine sich überlappen.
			Also 16:00 bis 16:20, dann darf ich aber nicht
			16:10 bis 16:30 eintragen.
			Und wenn 16:00 bis 16:30, dann auch nicht 16:20
		*/
		int i = 0;
		int start;
		int ende;
		int anzahl;
		JCheckBox cb;
		TerminTag tt;
		Termin t;
		for(i = 0; i < checkboxen.size(); i++){
			cb = checkboxen.get(i);
			if(cb.isSelected()){
				//Termin eintragen
				tt = (TerminTag)termine.get(i);
				start = tt.getZeile();
				ende = start+dauer;
				t = new Termin(Termin.PATIENT);
				t.setZeit(start-1, ende-1);//Jaja, Termindaten sind andere Daten
				t.setPatient(patient, tt.getPackung());
				t.setGeraet(tt.getGeraet());
				t.setTherapie(therapie);
				//public Termin(Termin.PATIENT, patient, kommentar, boolean kabine, boolean strom, boolean ultraschall, false, "")
				anzahl = 0;
				for(int j = start; j < ende; j++){
					if(tt.getPackung())
						if(anzahl < 2)
							daten.setTermin(tt.getSpalte(), j, tt.getTherapeut(), 1, t);
						else
							daten.setTermin(tt.getSpalte(), j, tt.getTherapeut(), 0, t);
					else
						daten.setTermin(tt.getSpalte(), j, tt.getTherapeut(), 0, t);
					anzahl++;
				}
				Calendar calR = Calendar.getInstance();
				/*calR.setTime(daten.getDate(globaleSpalte));
				int year = calR.get(Calendar.YEAR);
				int month = calR.get(Calendar.MONTH)+1;
				int day = calR.get(Calendar.DAY_OF_MONTH);*/
				String termininfo = ""+tt.getTag()+"."+tt.getMonat()+"."+tt.getJahr()+" um "+daten.UHRZEIT[start-1]+" bis "+daten.UHRZEIT[ende-1];
				calR = Calendar.getInstance();
				calR.setTime(new Date());
				int year = calR.get(Calendar.YEAR);
				int month = calR.get(Calendar.MONTH)+1;
				int day = calR.get(Calendar.DAY_OF_MONTH);
				int hour = calR.get(Calendar.HOUR_OF_DAY);
				int minute = calR.get(Calendar.MINUTE);
				logger.finest("Termin wurde eingetragen:  "+day+"."+month+"."+year+"("+hour+":"+minute+")\n"+termininfo);
				patient.addTermin("E: "+day+"."+month+"."+year+"("+hour+":"+minute+")\n"+termininfo);
			}
		}
		daten.setUnsave();
		dispose();
	}
	
	private void cancel(){
		dispose();
	}
}
