import java.io.*;

public class TerminTag extends Termin implements Serializable{
	public static final long serialVersionUID = 1L;
	/*
	Erweitert die Termin-Klasse um die Spalte/ also das Datum
	*/
	
	protected int spalte = -1;
	protected int tag = -1;
	protected int monat = -1;
	protected int jahr = -1;
	protected int zeile = -1;
	protected int therapeut = -1;
	protected String woTag = "";
	
	public TerminTag(){
		super();
	}
	
	public TerminTag(int art, Patient p, String kommentar, boolean kabine, boolean strom, boolean ultraschall, boolean erinnerung, String et){
		super(art, p, kommentar, kabine, strom, ultraschall, erinnerung, et);
	}
	
	public TerminTag(int art, Patient p, String kommentar, boolean kabine, boolean strom, boolean ultraschall, boolean erinnerung, String et, int spalte){
		super(art, p, kommentar, kabine, strom, ultraschall, erinnerung, et);
		this.spalte = spalte;
	}
	
	public TerminTag(int tag, int monat, int jahr, int spalte, int zeile, boolean packung, int therapeut, String woTag){
		super(Termin.PATIENT);
		this.spalte = spalte;
		this.tag = tag;
		this.monat = monat;
		this.jahr = jahr;
		this.packung = packung;
		this.zeile = zeile;
		this.therapeut = therapeut;
		this.woTag = woTag;
	}
	
	public TerminTag(int art){
		super(art);
	}
	
	public int getTag(){
		return tag;
	}
	
	public int getMonat(){
		return monat;
	}
	
	public int getJahr(){
		return jahr;
	}
	
	public int getTherapeut(){
		return therapeut;
	}
	
	public int getZeile(){
		return zeile;
	}
	
	public int getSpalte(){
		return spalte;
	}
	
	public String getWochentag(){
		return woTag;
	}
	
}
