import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
//import java.awt.Toolkit;
import java.awt.datatransfer.*;
import java.util.logging.*;

public class TherapeutenFenster extends JInternalFrame implements InternalFrameListener{
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
	private JComboBox HerrFrau = new JComboBox();
	private JComboBox MoV = new JComboBox();
	private JComboBox MoB = new JComboBox();
	private JComboBox DiV = new JComboBox();
	private JComboBox DiB = new JComboBox();
	private JComboBox MiV = new JComboBox();
	private JComboBox MiB = new JComboBox();
	private JComboBox DoV = new JComboBox();
	private JComboBox DoB = new JComboBox();
	private JComboBox FrV = new JComboBox();
	private JComboBox FrB = new JComboBox();
	private JComboBox SaV = new JComboBox();
	private JComboBox SaB = new JComboBox();
	private JComboBox SoV = new JComboBox();
	private JComboBox SoB = new JComboBox();
	private JComboBox pausenCB = new JComboBox();
	private int maxB = 11;//MaxBehandlungen
	private JCheckBox[][] behandlung = new JCheckBox[7][maxB];
	private JComboBox[] bezeit = new JComboBox[maxB];
	private JButton edit  = new JButton("Ändern");
	private JButton del   = new JButton("Löschen");
	private JButton eintragen = new JButton("Eintragen");
	private DateComboBox dcbv = new DateComboBox(new Date());//Von
	private DateComboBox dcbb = new DateComboBox(new Date());//Bis eintragen
	private Vector<String> namen = new Vector<String>();
	private JComboBox wer = new JComboBox(namen);
	private int welcher = 0;
	private int maxi = 0;
	
	private JLabel name = new JLabel("Name");
	private JLabel leere = new JLabel(".");
	private JLabel pause = new JLabel("Pause nach ");
	private JTabbedPane jt = new JTabbedPane();
	private JPanel tisch;
	private JPanel terminPanel = new JPanel();
	private JPanel kursZeiten = new JPanel();
	private JPanel arbeitsZeiten = new JPanel();
	private JPanel pausenZeiten = new JPanel();
	private JPanel behandlungen = new JPanel();
	private JPanel urlaubstage = new JPanel();
	private JPanel schulungen = new JPanel();
	private JPanel nachrichten = new JPanel();
	private JTextArea notizenTA = new JTextArea();
	private JScrollPane notizenSP = new JScrollPane(notizenTA);
	
	private JTextArea termineTA = new JTextArea();
	private JScrollPane termineSP = new JScrollPane(termineTA);
	
	private JTextField vorName = new JTextField(15);
	private JTextField nachName = new JTextField(15);
	private Daten daten;
	private Physiomat physiomat;
	
	
	static void addComponent( Container cont, 
                            GridBagLayout gbl, 
                            Component c, 
                            int x, int y, 
                            int width, int height, 
                            double weightx, double weighty ) 
  { 
    GridBagConstraints gbc = new GridBagConstraints(); 
    gbc.fill = GridBagConstraints.BOTH; 
    gbc.gridx = x; gbc.gridy = y; 
    gbc.gridwidth = width; gbc.gridheight = height; 
    gbc.weightx = weightx; gbc.weighty = weighty; 
    gbl.setConstraints( c, gbc ); 
    cont.add( c ); 
  } 
	
	static void addComponent( Container cont, 
                            GridBagLayout gbl, 
                            Component c, 
                            int x, int y, 
                            int width, int height) 
  { 
    GridBagConstraints gbc = new GridBagConstraints(); 
    gbc.fill = GridBagConstraints.BOTH; 
    gbc.gridx = x; gbc.gridy = y; 
    gbc.gridwidth = width; gbc.gridheight = height; 
    gbc.weightx = 1.0; gbc.weighty = 1.0; 
    gbl.setConstraints( c, gbc ); 
    cont.add( c ); 
  } 



	public TherapeutenFenster(Physiomat physiomat) {
		super();
		this.physiomat = physiomat;
		this.setTitle("Therapeuten");
		this.setBounds(0,0,500,450);
		this.setResizable(true);
		this.setMaximizable(true);
		this.setIconifiable(true);
		this.setClosable(true);
		setDefaultCloseOperation(HIDE_ON_CLOSE);
		//this.getContentPane().add(sP); //jetzt in create
		initGui();
	}
	
	public void zeigen(){
		daten.nichtSpeichern(Daten.THERAPEUT);
		this.setVisible(false);
		try {
			this.setIcon(false);
		} catch (Exception e) {
			JOptionPane.showMessageDialog(this, "Fehler beim deiconifizieren!", "DeIconifizieren", JOptionPane.ERROR_MESSAGE);
			logger.warning("Fehler beim deiconifizieren");
		}
		this.setVisible(true);
	}
	
	public void initGui(){
		//Anwender soll schliessen und ich möchte dann nur wissen, dass es passiert ist.
		this.setDefaultCloseOperation(HIDE_ON_CLOSE);
		addInternalFrameListener(this);
		
		notizenTA.setLineWrap(true);
		notizenTA.setWrapStyleWord(true);
		termineTA.setLineWrap(true);
		termineTA.setWrapStyleWord(true);
		
		Container c = this.getContentPane(); 
		GridBagLayout gbl = new GridBagLayout(); 
		GridBagLayout gbl2 = new GridBagLayout();
		c.setLayout( gbl ); 
		nachrichten.setLayout(new BoxLayout(nachrichten, BoxLayout.Y_AXIS)); 

		//wer.addItem("Neu");
		namen.add("Neu");
		HerrFrau.addItem("Herr");
		HerrFrau.addItem("Frau");
		HerrFrau.setPreferredSize(new Dimension(80, 24));
		tisch = new JPanel(gbl);
		//tisch.setPreferredSize(new Dimension(80, 100));
		/*tisch.add(HerrFrau);
		tisch.add(new JLabel(""));
		tisch.add(new JLabel(""));
		tisch.add(name);
		tisch.add(vorName);
		tisch.add(nachName);*/
		
		//                                          x  y  w  h  wx   wy 
 		//addComponent( tisch, gbl, wer, 0, 0, 2, 1); 
		addComponent( tisch, gbl, edit, 2, 0, 1, 1); 
		addComponent( tisch, gbl, del, 3, 0, 1, 1); 
		addComponent( tisch, gbl, HerrFrau, 1, 2, 1, 1); 
		addComponent( tisch, gbl, name, 0, 2, 1, 1); 
		addComponent( tisch, gbl, vorName, 2, 2, 1, 1); 
		addComponent( tisch, gbl, nachName, 3, 2, 1, 1); 
		addComponent( tisch, gbl, leere, 4, 3, 1, 1); 
		
		nachrichten.add(notizenSP);

		edit.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				edit(); 
			} 
		} );

		del.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				Thread tn = new Thread(){public void run(){del();}};
				tn.start();
			} 
		} );

		wer.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				select(); 
			} 
		} );
		
		eintragen.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				if(welcher > 0){
					Thread nt = new Thread(){
						public void run(){
							eintragen(); 
						}
					};
					nt.start();
				}
			} 
		} );

		wer.setSelectedIndex(0);
		wer.setMaximumRowCount(5);
		
		/*
		behandlungen.setLayout(gbl2);
		addComponent( behandlungen, gbl2, new Label("Was"), 0, 0, 1, 1, 1.0, 1.0);
		addComponent( behandlungen, gbl2, new Label("Beschreibung"), 1, 0, 1, 1, 1.0, 1.0);
		addComponent( behandlungen, gbl2, new Label("Mo"), 2, 0, 1, 1, 1.0, 1.0);
		addComponent( behandlungen, gbl2, new Label("Die"), 3, 0, 1, 1, 1.0, 1.0);
		addComponent( behandlungen, gbl2, new Label("Mi"), 4, 0, 1, 1, 1.0, 1.0);
		addComponent( behandlungen, gbl2, new Label("Do"), 5, 0, 1, 1, 1.0, 1.0);
		addComponent( behandlungen, gbl2, new Label("Fr"), 6, 0, 1, 1, 1.0, 1.0);
		addComponent( behandlungen, gbl2, new Label("Sa"), 7, 0, 1, 1, 1.0, 1.0);
		//addComponent( behandlungen, gbl2, new Label("So"), 8, 0, 1, 1, 1.0, 1.0);
		addComponent( behandlungen, gbl2, new Label("Dauer"), 9, 0, 1, 1, 1.0, 1.0);
		
		addComponent( behandlungen, gbl2, new Label("P"), 0, 1, 1, 1);
		addComponent( behandlungen, gbl2, new Label("MT"), 0, 2, 1, 1);
		addComponent( behandlungen, gbl2, new Label("KMT"), 0, 3, 1, 1);
		addComponent( behandlungen, gbl2, new Label("US"), 0, 4, 1, 1);
		addComponent( behandlungen, gbl2, new Label("ET"), 0, 5, 1, 1);
		addComponent( behandlungen, gbl2, new Label("KG"), 0, 6, 1, 1);
		addComponent( behandlungen, gbl2, new Label("KGG"), 0, 7, 1, 1);
		addComponent( behandlungen, gbl2, new Label("D1"), 0, 8, 1, 1);
		addComponent( behandlungen, gbl2, new Label("MLD"), 0, 9, 1, 1);
		
		addComponent( behandlungen, gbl2, new Label("Fangopackung"), 1, 1, 1, 1);
		addComponent( behandlungen, gbl2, new Label("Manuelle Therapie"), 1, 2, 1, 1);
		addComponent( behandlungen, gbl2, new Label("Massage"), 1, 3, 1, 1);
		addComponent( behandlungen, gbl2, new Label("Ultraschall"), 1, 4, 1, 1);
		addComponent( behandlungen, gbl2, new Label("Elektrotherapie"), 1, 5, 1, 1);
		addComponent( behandlungen, gbl2, new Label("Krankengymnastik"), 1, 6, 1, 1);
		addComponent( behandlungen, gbl2, new Label("KG an Geräten"), 1, 7, 1, 1);
		addComponent( behandlungen, gbl2, new Label("alles"), 1, 8, 1, 1);
		addComponent( behandlungen, gbl2, new Label("Manuelle Lymphdrainage"), 1, 9, 1, 1);
		addComponent( behandlungen, gbl2, new Label("Osteropathie"), 1, 10, 1, 1);
		addComponent( behandlungen, gbl2, new Label("privat"), 1, 11, 1, 1);
		
		for(int j= 1; j < maxB+1; j++){//Behandlungen
			for(int i = 2; i < 8;i++){//Tage
				behandlung[i-2][j-1] = new JCheckBox();
				addComponent( behandlungen, gbl2, behandlung[i-2][j-1], i, j, 1, 1);
				
			}
			bezeit[j-1] = new JComboBox();
			addComponent( behandlungen, gbl2, bezeit[j-1], 9, j, 1, 1);
			bezeit[j-1].addItem("10 Min");
			bezeit[j-1].addItem("20 Min");
			bezeit[j-1].addItem("30 Min");
			bezeit[j-1].addItem("40 Min");
			bezeit[j-1].addItem("50 Min");
			bezeit[j-1].addItem("60 Min");
		}
		
		for(int j= 1; j < maxB+1; j++)//Behandlungen
			bezeit[j-1].setSelectedIndex(1);
		*/
		arbeitsZeiten.setLayout(gbl2);
		//addComponent( arbeitsZeiten, gbl2, new Label("Tag"), 0, 0, 1, 1);
		addComponent( arbeitsZeiten, gbl2, new Label("Von:"), 1, 0, 1, 1);
		addComponent( arbeitsZeiten, gbl2, new Label("Bis:"), 2, 0, 1, 1);
		addComponent( arbeitsZeiten, gbl2, new Label("Mo"), 0, 1, 1, 1);
		addComponent( arbeitsZeiten, gbl2, new Label("Die"), 0, 2, 1, 1);
		addComponent( arbeitsZeiten, gbl2, new Label("Mi"), 0, 3, 1, 1);
		addComponent( arbeitsZeiten, gbl2, new Label("Do"), 0, 4, 1, 1);
		addComponent( arbeitsZeiten, gbl2, new Label("Fr"), 0, 5, 1, 1);
		addComponent( arbeitsZeiten, gbl2, new Label("Sa"), 0, 6, 1, 1);
		//addComponent( arbeitsZeiten, gbl2, new Label("So"), 0, 7, 1, 1);
		addComponent( arbeitsZeiten, gbl2, pause, 0, 7, 1, 1);

		addComponent( arbeitsZeiten, gbl2, eintragen, 0, 8, 1, 1);
		addComponent( arbeitsZeiten, gbl2, dcbv, 1, 8, 1, 1);
		addComponent( arbeitsZeiten, gbl2, dcbb, 2, 8, 1, 1);
	
		addComponent( arbeitsZeiten, gbl2, MoV, 1, 1, 1, 1);
		addComponent( arbeitsZeiten, gbl2, DiV, 1, 2, 1, 1);
		addComponent( arbeitsZeiten, gbl2, MiV, 1, 3, 1, 1);
		addComponent( arbeitsZeiten, gbl2, DoV, 1, 4, 1, 1);
		addComponent( arbeitsZeiten, gbl2, FrV, 1, 5, 1, 1);
		addComponent( arbeitsZeiten, gbl2, SaV, 1, 6, 1, 1);
		//addComponent( arbeitsZeiten, gbl2, SoV, 1, 7, 1, 1);
		addComponent( arbeitsZeiten, gbl2, pausenCB, 1, 7, 2, 1);
		
		addComponent( arbeitsZeiten, gbl2, MoB, 2, 1, 1, 1);
		addComponent( arbeitsZeiten, gbl2, DiB, 2, 2, 1, 1);
		addComponent( arbeitsZeiten, gbl2, MiB, 2, 3, 1, 1);
		addComponent( arbeitsZeiten, gbl2, DoB, 2, 4, 1, 1);
		addComponent( arbeitsZeiten, gbl2, FrB, 2, 5, 1, 1);
		addComponent( arbeitsZeiten, gbl2, SaB, 2, 6, 1, 1);
		//addComponent( arbeitsZeiten, gbl2, SoB, 2, 7, 1, 1);
		
		terminPanel.setLayout(new BoxLayout(terminPanel, BoxLayout.Y_AXIS)); 
		terminPanel.add(termineSP);
		
		MoV.addItem("");
		DiV.addItem("");
		MiV.addItem("");
		DoV.addItem("");
		FrV.addItem("");
		SaV.addItem("");
		SoV.addItem("");
		MoB.addItem("");
		DiB.addItem("");
		MiB.addItem("");
		DoB.addItem("");
		FrB.addItem("");
		SaB.addItem("");
		SoB.addItem("");
		
		for(int i=7; i < 21; i++)
			for(int j=0;j < 6; j++){
				MoV.addItem(""+i+":"+j+"0");
				DiV.addItem(""+i+":"+j+"0");
				MiV.addItem(""+i+":"+j+"0");
				DoV.addItem(""+i+":"+j+"0");
				FrV.addItem(""+i+":"+j+"0");
				SaV.addItem(""+i+":"+j+"0");
				SoV.addItem(""+i+":"+j+"0");
				MoB.addItem(""+i+":"+j+"0");
				DiB.addItem(""+i+":"+j+"0");
				MiB.addItem(""+i+":"+j+"0");
				DoB.addItem(""+i+":"+j+"0");
				FrB.addItem(""+i+":"+j+"0");
				SaB.addItem(""+i+":"+j+"0");
				SoB.addItem(""+i+":"+j+"0");
			}
		MoV.addItem("21:00");
		DiV.addItem("21:00");
		MiV.addItem("21:00");
		DoV.addItem("21:00");
		FrV.addItem("21:00");
		SaV.addItem("21:00");
		SoV.addItem("21:00");
		MoB.addItem("21:00");
		DiB.addItem("21:00");
		MiB.addItem("21:00");
		DoB.addItem("21:00");
		FrB.addItem("21:00");
		SaB.addItem("21:00");
		SoB.addItem("21:00");
		
		pausenCB.addItem("Keine");
		for(int i = 1; i < 31; i++)
			pausenCB.addItem(""+i+"0 Minuten");
		
		jt.addTab("Arbeitszeiten",arbeitsZeiten);
		//jt.addTab("Pausen", pausenZeiten);
		//jt.addTab("Kurse", kursZeiten);
		
		//jt.addTab("Urlaub", urlaubstage);
		//jt.addTab("Schulungen", schulungen);
		//jt.addTab("Behandlungen", behandlungen);
		jt.addTab("Nachrichten", nachrichten);
		jt.addTab("Termine", terminPanel);
		addComponent( tisch, gbl, jt, 0, 4, 4, 1); 
		addComponent( tisch, gbl, wer, 0, 0, 2, 1);
		this.getContentPane().add(tisch);
	}

	public void edit(){
		//wenn Eintrag = 0, dann hinzufügen, sonst ändern
		//Es sei denn, es sind schon zehn Therapeuten drinne!!!
		logger.finest("Editiere Therapeuten");
		Therapeut theraNew = new Therapeut();//neuer
		Therapeut theraOld = new Therapeut();//Edit
		if(welcher==0)
			theraNew = new Therapeut(nachName.getText(), vorName.getText(), daten.getAndAddTheraNummer());
		else {
			theraOld = daten.getTherapeut(welcher-1);
			theraNew = new Therapeut(nachName.getText(), vorName.getText(), theraOld.getNummer());
		}
		theraNew.setTermine(termineTA.getText());
		if(HerrFrau.getSelectedIndex()==0)
			theraNew.setHerr(true);
		else
			theraNew.setHerr(false);
		theraNew.setKommentar(notizenTA.getText());
		theraNew.setVonZeiten(0, MoV.getSelectedIndex());
		theraNew.setVonZeiten(1, DiV.getSelectedIndex());
		theraNew.setVonZeiten(2, MiV.getSelectedIndex());
		theraNew.setVonZeiten(3, DoV.getSelectedIndex());
		theraNew.setVonZeiten(4, FrV.getSelectedIndex());
		theraNew.setVonZeiten(5, SaV.getSelectedIndex());
		theraNew.setVonZeiten(6, SoV.getSelectedIndex());

		theraNew.setBisZeiten(0, MoB.getSelectedIndex());
		theraNew.setBisZeiten(1, DiB.getSelectedIndex());
		theraNew.setBisZeiten(2, MiB.getSelectedIndex());
		theraNew.setBisZeiten(3, DoB.getSelectedIndex());
		theraNew.setBisZeiten(4, FrB.getSelectedIndex());
		theraNew.setBisZeiten(5, SaB.getSelectedIndex());
		theraNew.setBisZeiten(6, SoB.getSelectedIndex());
		theraNew.setPausen(pausenCB.getSelectedIndex());

		if(welcher==0){
			if(daten.getMaxTherapeuten() >= daten.maxTherapeuten){
				int i = JOptionPane.showConfirmDialog(this,
				"Die Anzahl \nder maximal möglichen Therapeuten \nist überschritten!",
				"Zu große Praxis", JOptionPane.DEFAULT_OPTION,
				JOptionPane.INFORMATION_MESSAGE, null);
			} else {
				String text = ""+vorName.getText()+" "+nachName.getText();
				namen.add(text);
				daten.addTherapeuten(theraNew);
				wer.setSelectedIndex(++maxi);
				logger.info("Therapeut "+text+" hinzugefügt");
			}
		} else {
			
			String text = ""+vorName.getText()+" "+nachName.getText();
			namen.set(welcher, text);
			daten.setTherapeuten(welcher-1, theraNew);
			wer.setSelectedIndex(welcher);
		}
		daten.setUpdate();
	}

	public void del(){
		if(welcher == 0){
			//System.out.println("Auswahl: "+welcher);
		} else {
			if (logger.isLoggable(Level.INFO)) { logger.info("Therapeut "+vorName.getText()+" "+nachName.getText()+" soll gelöscht werden."); } 
			//sicherheitsabfrage
			//int a = JOptionPane.showConfirmDialog(null,"choose one","choose one", JOptionPane.YES_NO_OPTION);
			String anrede = "den Therapeuten\n";
			if(HerrFrau.getSelectedIndex()==1)
				anrede = "die Therapeutin\n";
			int a = JOptionPane.showConfirmDialog(null, "Möchten Sie wirklich "+anrede+vorName.getText()+" "+nachName.getText()+"\nlöschen?\n\nAlle Kalendereinträge mit ihm werden gelöscht.", "Therapeuten löschen?", JOptionPane.YES_NO_OPTION); 
 
			if(a == 0){
				int b = JOptionPane.showConfirmDialog(null, "Sind Sie sich WIRKLICH sicher, dass Sie\n"+anrede+vorName.getText()+" "+nachName.getText()+"\nlöschen möchten?\n\nWirklich alle Kalendereinträge mit ihm werden gelöscht\nund können nicht wieder hergestellt werden.", "Therapeuten löschen?", JOptionPane.YES_NO_OPTION); 
				if(b == 0){
					logger.finest("Löschung ist bestätigt");
					/*
						Au Weia!
						
						Suche alle Patienten raus, die einen Termin bei diesem Therapeuten haben. Wenn zu dem Zeitpunkt ein anderer
						Therapeut noch keinen Patienten hat, dann verschiebe den Patienten zu diesem Therapeuten.
						
						Liste alle Patienten und ihre Termine auf, wo das nicht geht!!!
						logger.fine("Termine gefunden, die verschoben werden müssen");
						Erst, wenn alle Patienten geklärt sind (angerufen und termine verschoben), dann darfst Du diesen Therapeuten löschen!!!
						logger.fine("Keine zugehörigen Termine gefunden");
						
						logger.fine("Beginne Kalenderverschiebung");
						nimm Therapeut, dann suche den ganzen Kalender ab, nach Einträgen/ Ein Index reicht.
						Verschiebe alle Kalendereinträge von später (index+1) auf (index)
						Also Therapeut 3 wird gelöscht, dann verschiebe 4 nach 3, 5 nach 4, ... bis Ende.
						logger.fine("Kalenderverschiebung erfolgreich beendet.");
					
						Dann suche Dir alle Patienten raus und entferne den Therapeuten von diesen. 
						Dann suche Dir alle Patienten raus mit Therapeut größer welcher und nehme x-1.
						logger.fine("Lösche Therapeuten aus Patienten");
						logger.fine("Löschen des Therapeuten aus den Patienten fertig.");
					*/
					boolean gefunden = false;
					Termin t1, t2;
					a = 0;
					int ende = daten.getMaxTage();
					int anfang = daten.getSpalte(new Date());
					int maxC = ende - anfang;
					physiomat.setStatusBar(maxC, "", "Prüfe Therapeut", "");
					for(int i = anfang; i < ende; i++){
						physiomat.setStatusBar(i, ""+(100*i/maxC)+"%");
						if(!gefunden)
							for(int j = 1; j < 86; j++){
								t1 = daten.getTermin(i, j, welcher-1, 0);
								t2 = daten.getTermin(i, j, welcher-1, 1);
								if(t1.getArt() == Termin.PATIENT || t2.getArt() == Termin.PATIENT)
									gefunden = true;
									a++;
							}
					}
					physiomat.setStatusBar(maxC, "100%");
					boolean weiter = false;
					if(gefunden){
						b = JOptionPane.showConfirmDialog(null, "Sind Sie sich WIRKLICH, WIRKLICH sicher, dass Sie\n"+anrede+vorName.getText()+" "+nachName.getText()+"\nlöschen möchten?\n\nEs existieren noch "+a+" Kalendereinträge mit Patiententerminen\nund diese werden dann auch mit gelöscht.", "Therapeuten löschen?", JOptionPane.YES_NO_OPTION); 
						if(b == 0){
							logger.finest("Löschung ist doppelt bestätigt");
							weiter = true;
						}
					} else {
						weiter = true;
					}
					if(weiter){
						maxC = ende;
						physiomat.setStatusBar(maxC, "", "Lösche Therapeut", "");
						for(int i = 0; i < ende; i++){
							physiomat.setStatusBar(i, ""+(100*i/maxC)+"%");
							for(int thera = (welcher); thera < daten.getMaxTherapeuten(); thera++){
								for(int j = 0; j < 86; j++){
									t1 = daten.getTermin(i, j, thera, 0);
									t2 = daten.getTermin(i, j, thera, 1);
									daten.setTermin(i, j, thera-1, 0, t1);
									daten.setTermin(i, j, thera-1, 1, t2);
									if(thera == (daten.getMaxTherapeuten()-1)){
										//Letzter Therapeut, bei dem nun alles leer werden kann.
										daten.setTermin(i, j, thera, 0, new Termin());
										daten.setTermin(i, j, thera, 1, new Termin());
									}
								}
							}
						}
						physiomat.setStatusBar(maxC, "100%");
						namen.remove(welcher);
						daten.delTherapeuten(welcher-1);
						wer.setSelectedIndex(0);
						maxi--;
						daten.setUpdate();
					}
				}
			}
		}
	}

	public void select(){
		welcher = wer.getSelectedIndex();
		logger.finest("Wer wurde selektiert: "+welcher);
		if(welcher == 0){
			vorName.setText("");
			nachName.setText("");
			notizenTA.setText("");
			termineTA.setText("");
		} else {
			Therapeut t = daten.getTherapeut(welcher-1);
			vorName.setText(t.getVorname());
			nachName.setText(t.getNachname());
			if(t.getHerr())
				HerrFrau.setSelectedIndex(0);
			else
				HerrFrau.setSelectedIndex(1);
			MoV.setSelectedIndex(t.getVonZeiten(0));
			DiV.setSelectedIndex(t.getVonZeiten(1));
			MiV.setSelectedIndex(t.getVonZeiten(2));
			DoV.setSelectedIndex(t.getVonZeiten(3));
			FrV.setSelectedIndex(t.getVonZeiten(4));
			SaV.setSelectedIndex(t.getVonZeiten(5));
			SoV.setSelectedIndex(t.getVonZeiten(6));
			MoB.setSelectedIndex(t.getBisZeiten(0));
			DiB.setSelectedIndex(t.getBisZeiten(1));
			MiB.setSelectedIndex(t.getBisZeiten(2));
			DoB.setSelectedIndex(t.getBisZeiten(3));
			FrB.setSelectedIndex(t.getBisZeiten(4));
			SaB.setSelectedIndex(t.getBisZeiten(5));
			SoB.setSelectedIndex(t.getBisZeiten(6));
			pausenCB.setSelectedIndex(t.getPausen());
			notizenTA.setText(t.getKommentar());
			termineTA.setText(t.getTermine());
		}
	}

	public void setDaten(Daten daten){
		this.daten = daten;
	}
	
	public void eintragen(){
		/*
			Werte auslesen.
			Welche Spalte beginnt es,
			Von wann bis wann
		*/
		
		long von = dcbv.getDate().getTime();
		long bis = dcbb.getDate().getTime();
		
		Calendar heuteC = Calendar.getInstance();
		heuteC.setTime(new Date());
		int year = heuteC.get(Calendar.YEAR);
		int month = heuteC.get(Calendar.MONTH);
		int day = heuteC.get(Calendar.DAY_OF_MONTH);
		Calendar calStripped = Calendar.getInstance();
		calStripped.clear();
		calStripped.set(year, month, day);
		
		long heute = calStripped.getTime().getTime();
		int maxTage = 7;
		int[][] tage = new int[maxTage][2];
		if(von < heute)
			von = heute;
		Calendar maximalesDatum = Calendar.getInstance();
		maximalesDatum.setTime(daten.getLastDay());
		if(bis > maximalesDatum.getTime().getTime()){
			bis = maximalesDatum.getTime().getTime();
			logger.finest("Datum ausserhalb der Reichweite\nWird nur bis Reichweite benutzt.");
		}
		if(bis >= heute){
			/*
				Wir fügen nur hinzu oder entfernen frei Plätze.
				Termine, die bereits Patientendaten oder Notizen oder
				Urlaubspläne enthalten, werden nicht verändert.
			*/
			logger.finest("Welcher: "+welcher);
			tage[0][0] = MoV.getSelectedIndex();
			tage[0][1] = MoB.getSelectedIndex();
			tage[1][0] = DiV.getSelectedIndex();
			tage[1][1] = DiB.getSelectedIndex();
			tage[2][0] = MiV.getSelectedIndex();
			tage[2][1] = MiB.getSelectedIndex();
			tage[3][0] = DoV.getSelectedIndex();
			tage[3][1] = DoB.getSelectedIndex();
			tage[4][0] = FrV.getSelectedIndex();
			tage[4][1] = FrB.getSelectedIndex();
			tage[5][0] = SaV.getSelectedIndex();
			tage[5][1] = SaB.getSelectedIndex();
			tage[6][0] = SoV.getSelectedIndex();
			tage[6][1] = SoB.getSelectedIndex();
			
			Calendar nun = Calendar.getInstance();
			nun.setTime(new Date(von));
			int spalte = 0;
			int woTag = 0;
			int i = 0;
			int z = 0;
			Termin t;
			int ende = daten.tage(nun.getTime(), new Date(bis));
			physiomat.setStatusBar(ende, "", "Eintragen der Therapeutenzeiten", "");
			while(nun.getTime().getTime() <= bis){
				//physiomat.setStatusBar(z);
				if(ende > 0)
					physiomat.setStatusBar(z, ""+(100*z/ende)+"%");
				//Spalte
				spalte = daten.getSpalte(nun.getTime());
				//logger.finest("Spalte: "+spalte);
				//Wochentag
				switch (nun.get(Calendar.DAY_OF_WEEK)) {
					case Calendar.MONDAY   : woTag = 0; break; 
					case Calendar.TUESDAY  : woTag = 1; break;
					case Calendar.WEDNESDAY: woTag = 2; break;
					case Calendar.THURSDAY : woTag = 3; break;
					case Calendar.FRIDAY   : woTag = 4; break;
					case Calendar.SATURDAY : woTag = 5; break;
					case Calendar.SUNDAY   : woTag = 6; break;
				}
				if(tage[woTag][0] == 0 || tage[woTag][1] == 0){
					//Kein Arbeitstag
					for(i = 0; i < 86; i++){
						t = daten.getTermin(spalte, i, welcher-1, 0); 
						if(t.getArt() == Termin.FREI || t.getArt() == Termin.PAUSE)
							t.setArt(Termin.KEINEARBEITSZEIT);
						t = daten.getTermin(spalte, i, welcher-1, 1); 
						if(t.getArt() == Termin.FREI || t.getArt() == Termin.PAUSE)
							t.setArt(Termin.KEINEARBEITSZEIT);
					}
				} else {
					//Normaler Arbeitstag
					//Zuerst die Zeit VOR Arbeitsbeginn
					//Whileschleife, weil kann sein, dass KEIN Schleifendurchlauf gewollt ist.
					i = 0;
					//logger.finest("Tage[woTag]: "+tage[woTag][0]);
					while(i < tage[woTag][0]){
						t = daten.getTermin(spalte, i, welcher-1, 0); 
						if((t.getArt() == Termin.FREI) || (t.getArt() == Termin.PAUSE))
							t.setArt(Termin.KEINEARBEITSZEIT);
						//else
						//	logger.warning("Zeile A: "+i+"\nArt: "+t.getArt());
						t = daten.getTermin(spalte, i, welcher-1, 1); 
						if((t.getArt() == Termin.FREI) || (t.getArt() == Termin.PAUSE))
							t.setArt(Termin.KEINEARBEITSZEIT);
						i++;
					}
					/*
						Arbeitszeiten:
						Hier müssen wir die Pausenzeiten berücksichtigen
					*/
					int pzahl = 0;
					int pmax = pausenCB.getSelectedIndex();
					boolean gutePause = false;
					int pdauer = 0;
					if(pmax == 0){
						logger.finest("Keine Pausen vorhanden");
						while(i < tage[woTag][1]){
							t = daten.getTermin(spalte, i, welcher-1, 0); 
							if(t.getArt() == Termin.KEINEARBEITSZEIT)
								t.setArt(Termin.FREI);
							//else
							//	logger.warning("Zeile B: "+i+"\nArt: "+t.getArt());
							t = daten.getTermin(spalte, i, welcher-1, 1); 
							if(t.getArt() == Termin.KEINEARBEITSZEIT)
								t.setArt(Termin.FREI);
							i++;
						}
					} else {
						logger.finest("Pausen vorhanden alle "+pmax+"0 Minuten.");
						while(i < tage[woTag][1]){
							if(pzahl < pmax){
								
								t = daten.getTermin(spalte, i, welcher-1, 0); 
								if(t.getArt() == Termin.KEINEARBEITSZEIT)
									t.setArt(Termin.FREI);
								t = daten.getTermin(spalte, i, welcher-1, 1); 
								if(t.getArt() == Termin.KEINEARBEITSZEIT)
									t.setArt(Termin.FREI);
								pzahl++;
								t = daten.getTermin(spalte, i, welcher-1, 0); 
								if(t.getArt() == Termin.PAUSE)
									pzahl = 0;
							} else {
								logger.finest("Pausenzeit erfüllt.");
								gutePause = false;
								t = daten.getTermin(spalte, i, welcher-1, 0); 
								if((t.getArt() == Termin.KEINEARBEITSZEIT) || t.getArt() == Termin.FREI)
									gutePause = true;
								t = daten.getTermin(spalte, i, welcher-1, 1); 
								if((t.getArt() == Termin.KEINEARBEITSZEIT) || t.getArt() == Termin.FREI)
									gutePause = true;
								t = daten.getTermin(spalte, i+1, welcher-1, 0); 
								if((t.getArt() == Termin.KEINEARBEITSZEIT) || t.getArt() == Termin.FREI)
									gutePause = true;
								t = daten.getTermin(spalte, i+1, welcher-1, 1); 
								if((t.getArt() == Termin.KEINEARBEITSZEIT) || t.getArt() == Termin.FREI)
									gutePause = true;
								if(gutePause){
									logger.finest("Konnte Pause einfügen.");
									t = new Termin(Termin.PAUSE);
									daten.setTermin(spalte,i, welcher-1, 0, t);
									daten.setTermin(spalte,i, welcher-1, 1, t);
									daten.setTermin(spalte,i+1, welcher-1, 0, t);
									daten.setTermin(spalte,i+1, welcher-1, 1, t);
									t.setZeit(i-1, i+1);//In Daten mal wieder etwas anders gespeichert
									pzahl = 0;
								} else 
									logger.warning("Konnte keine Pause einfügen!");
							}
							i++;
						}
					}
					
					//Danach
					while(i < 86){
						t = daten.getTermin(spalte, i, welcher-1, 0); 
						if((t.getArt() == Termin.FREI) || (t.getArt() == Termin.PAUSE))
							t.setArt(Termin.KEINEARBEITSZEIT);
						//else
						//	logger.warning("Zeile C: "+i+"\nArt: "+t.getArt());
						t = daten.getTermin(spalte, i, welcher-1, 1); 
						if((t.getArt() == Termin.FREI) || (t.getArt() == Termin.PAUSE))
							t.setArt(Termin.KEINEARBEITSZEIT);
						i++;
					}
				}
					
				/*
				//Test
				t = daten.getTermin(spalte, 80, welcher-1, 0); 
				t.setArt(Termin.FREI);
				daten.setTermin(spalte, 81, welcher-1, 0, t);
				daten.setTermin(spalte, 81, welcher-1, 1, t);
				*/
				nun.add(Calendar.DATE, 1);
				z++;
			//for(int i = 0; i < maxTage; i++)
			}
		} else {
			logger.finest("Termin liegt in der Vergangenheit: ");
			int i = JOptionPane.showConfirmDialog(this,
				"Die Termine liegen in der Vergangenheit",
				"Zeitreiseproblem.", JOptionPane.DEFAULT_OPTION,
				JOptionPane.INFORMATION_MESSAGE, null);
		}
		daten.setUpdate();
	}
	
	public void update(){
		/*
			Combobox wer und Vector namen löschen und neu anlegen
		*/
		//wer.removeAllItems();
		namen.removeAllElements();
		namen.add("Neu");
		Therapeut t;
		for(int i = 0; i < daten.getMaxTherapeuten(); i++){
			t = daten.getTherapeut(i);
			namen.add(t.getVorname()+" "+t.getNachname());
		}
		//wer = new JComboBox(namen);
		wer.setSelectedIndex(0);
		welcher = 0;
		wer.updateUI();
	}
	
	
	public void internalFrameClosing(InternalFrameEvent e) {
		//displayMessage("Internal frame closing", e);
		daten.speichernErlaubt(Daten.THERAPEUT);
	}
	
	public void internalFrameClosed(InternalFrameEvent e) {
		//displayMessage("Internal frame closed", e);
		daten.speichernErlaubt(Daten.THERAPEUT);
	}
	
	public void internalFrameOpened(InternalFrameEvent e) {
		//logger.finest("Internal frame opened");
		daten.nichtSpeichern(Daten.THERAPEUT);
	}

	public void internalFrameIconified(InternalFrameEvent e) {
		//logger.finest("Internal frame iconified");
		daten.speichernErlaubt(Daten.THERAPEUT);
	}

	public void internalFrameDeiconified(InternalFrameEvent e) {
		//logger.finest("Internal frame deiconified");
		daten.nichtSpeichern(Daten.THERAPEUT);
	}

	public void internalFrameActivated(InternalFrameEvent e) {
		//logger.finest("Internal frame activated");
		daten.nichtSpeichern(Daten.THERAPEUT);
	}

	public void internalFrameDeactivated(InternalFrameEvent e) {
		//logger.finest("Internal frame deactivated");
		daten.speichernErlaubt(Daten.THERAPEUT);
	}
	
}
