import javax.xml.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import java.util.*;
import java.util.logging.*;
//import java.awt.*;

public class XMLDaten extends DefaultHandler {
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
	static final int READING_NAME        = 1;
	static final int READING_VORNAME     = 2;
	static final int READING_GEBURTSTAG  = 3;
	static final int READING_TELEFON     = 4;
	static final int READING_TELEFON2    = 5;
	static final int READING_TELEFON3    = 6;
	static final int READING_KOMMENTAR   = 7;
	static final int READING_KURSNAME    = 8;
	static final int READING_KURZNOTIZ   = 9;
	static final int READING_LANGNOTIZ   = 10;
	static final int READING_PATIENTENID = 11;
	static final int READING_JETZT       = 12;
	static final int READING_ZUKUNFT     = 13;
	static final int READING_PAUSE       = 14;
	static final int READING_PTERMINE    = 15;
	static final int READING_THERAPIE    = 16;
	

	
	static int READING_NOTHING = 0;
	int currentActivity = READING_NOTHING;
	
	private Daten daten;
	private File file;
	
	private String vorname = "";
	private String name = "";
	private String geburtstag = "";
	private String telefon = "";
	private String telefon2 = "";
	private String telefon3 = "";
	private String kommentare = "";
	private String termine = "";
	private String pause = "";
	private String therapie = "";
	private int pausen = 0;
	private boolean herr = false;
	private int thera = -1;
	private int kasse = -1;
	private int counter = 0;
	private int maxCounter = 1;
	
	private int vonMo = 0;
	private int vonDi = 0;
	private int vonMi = 0;
	private int vonDo = 0;
	private int vonFr = 0;
	private int vonSa = 0;
	private int vonSo = 0;
	
	private int bisMo = 0;
	private int bisDi = 0;
	private int bisMi = 0;
	private int bisDo = 0;
	private int bisFr = 0;
	private int bisSa = 0;
	private int bisSo = 0;
	
	private int tag = 0;
	private int monat = 0;
	private int jahr = 0;
	private int verschiebung = 0;
	
	private int aktuellerThera = 0;
	private int terminArt = 0;
	private int packung = 0;
	private int spalte = 0;
	private int zeile = 0;
	private String kursname = "";
	private String kurznotiz = "";
	private String langnotiz = "";
	private String patientenid = "";
	private int patientenID = 0;
	private long id = 0L;
	
	private int geraet = 0;
	private int raum = 0;
	private int jetzt = 0;
	private int zukunft = 0;
	private String jetztText = "";
	private String zukunftText = "";
	private Ausrustung raume;
	private Ausrustung geraete;

	
	public XMLDaten(Daten daten, File input, int maxCounter) {
		super();
		this.daten = daten;
		this.file = input;
		if(maxCounter > 0)
			this.maxCounter = maxCounter;
		
		//Startdatum:
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		jahr = cal.get(Calendar.YEAR);
		monat = cal.get(Calendar.MONTH)+1;
		tag = cal.get(Calendar.DAY_OF_MONTH);
		
		//Testen, ob gültig
		/*
		SAXParserFactory factory = SAXParserFactory.newInstance();
		factory.setValidating(true);
		factory.setNamespaceAware(true);
		SAXParser parser = factory.newSAXParser();
		XMLReader reader = parser.getXMLReader();
		reader.setErrorHandler(new SimpleErrorHandler());
		reader.parse(input);
		*/

		
		SAXParserFactory factory = SAXParserFactory.newInstance();
		factory.setValidating(true);
		factory.setNamespaceAware(true);
		try {
			SAXParser sax = factory.newSAXParser();
			//sax.setErrorHandler(new SimpleErrorHandler());
			
			XMLReader reader = sax.getXMLReader();
			reader.setContentHandler(this);
			reader.parse(file.getAbsolutePath());

			
			//sax.parse(input, this );
		} catch (ParserConfigurationException pce) {
			logger.severe("Could not create that parser.\n"+pce.getMessage());
		} catch (SAXException se) {
			logger.warning("Problem with the SAX parser.\n"+se.getMessage());
		} catch (IOException ioe) {
			logger.severe("Error reading file.\n"+ioe.getMessage());
		}
	}
	
	public void startElement(String uri, String localName, String qName, Attributes attributes){
		String attribute = "";
		String attributName = "";
			currentActivity = READING_NOTHING;
		if (qName.equals("Physiomat")){
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("datei"))
						try {
							Long dateiversion = Long.valueOf(attributes.getValue(i)).longValue();
							daten.setDateiversion(dateiversion);
							daten.setStatusBar("Dateiversion: "+dateiversion);
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Dateiversion ist keine Zahl:");
						}
				}
				attribute=" "+attribute;
			}
			logger.finest("Atribute von Physiomat: "+attribute+"\nNeue Dateiversion: "+daten.getDateiversion());
			
		} else if (qName.equals("Name")){
			currentActivity = READING_NAME;
			name = "";
		} else if (qName.equals("Vorname")){
			currentActivity = READING_VORNAME;
			vorname = "";
		} else if (qName.equals("Geburtstag")){
			currentActivity = READING_GEBURTSTAG;
			geburtstag = "";
		} else if (qName.equals("Telefon")){
			currentActivity = READING_TELEFON;
			telefon = "";
		} else if (qName.equals("Telefon2")){
			currentActivity = READING_TELEFON2;
			telefon2 = "";
		} else if (qName.equals("Telefon3")){
			currentActivity = READING_TELEFON3;
			telefon3 = "";
		} else if (qName.equals("Kommentar")){
			currentActivity = READING_KOMMENTAR;
			kommentare = "";
		} else if (qName.equals("Kursname")){
			currentActivity = READING_KURSNAME;
			kursname = "";
		} else if (qName.equals("Kurznotiz")){
			currentActivity = READING_KURZNOTIZ;
			kurznotiz = "";
		} else if (qName.equals("Langnotiz")){
			currentActivity = READING_LANGNOTIZ;
			langnotiz = "";
		} else if (qName.equals("Pause")){
			currentActivity = READING_PAUSE;
			pause = "";
		} else if (qName.equals("PTermin")){
			currentActivity = READING_PTERMINE;
			termine = "";
		} else if (qName.equals("Therapie")){
			currentActivity = READING_THERAPIE;
			therapie = "";
		} else if (qName.equals("PatientenID")){
			currentActivity = READING_PATIENTENID;
			patientenid = "";
		} else if (qName.equals("jetzt")){
			currentActivity = READING_JETZT;
			jetztText = "";
		} else if (qName.equals("Zukunft")){
			currentActivity = READING_ZUKUNFT;
			zukunftText = "";
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("Tag"))
						try {
							tag = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Tag der Zukunft ist keine Zahl:");
						}
					if(attributName.equals("Monat"))
						try {
							monat = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Monat der Zukunft ist keine Zahl:");
						}
					if(attributName.equals("Jahr"))
						try {
							jahr = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Jahr der Zukunft ist keine Zahl:");
						}
				}
				logger.finest("Atribute der Zukunft: "+attribute);
			}
		} else if (qName.equals("Herr")){
			herr = true;
		} else if (qName.equals("Termin")){
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("Spalte"))
						try {
							spalte = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Spalte im Kalender ist keine Zahl:");
						}
					if(attributName.equals("Zeile"))
						try {
							zeile = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Zeile im Kalender ist keine Zahl:");
						}
					if(attributName.equals("Packung"))
						try {
							packung = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Packung im Kalender ist keine Zahl:");
						}
					if(attributName.equals("Art"))
						terminArt = Termin.KEINEARBEITSZEIT;
						for(int j = 0; j < Termin.MAXFELD; j++)
							if(attributes.getValue(i).equals(Termin.WERTE[j]))
								terminArt = j;
					if(attributName.equals("id"))
						try {
							id = (Long.valueOf(attributes.getValue(i)).longValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("ID im Kalender ist keine Zahl:");
						}
				}
				logger.finest("Atribute des Termins: "+attribute);
			}
		} else if (qName.equals("Patient")){
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("Therapeut"))
						try {
							thera = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Therapeutennummer beim Patienten ist keine Zahl:");
						}
					if(attributName.equals("Kasse"))
						try {
							kasse = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Kasse beim Patienten ist keine Zahl:");
						}
				}
			}
			logger.finest("Atribute des Patienten: "+attribute);
		} else if (qName.equals("TherapeutenTermine")){
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("Therapeut"))
						try {
							aktuellerThera = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Therapeutennummer im Kalender ist keine Zahl:");
						}
				}
			}
			logger.finest("Atribute der Therapeutentermine: "+attribute);
		} else if (qName.equals("Termine")){
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("Tag"))
						try {
							tag = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Startzeit Terminkalender Tag ist keine Zahl:");
						}
					if(attributName.equals("Monat"))
						try {
							monat = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Startzeit Terminkalender Monat ist keine Zahl:");
						}
					if(attributName.equals("Jahr"))
						try {
							jahr = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Startzeit Terminkalender Jahr ist keine Zahl:");
						}
				}
				//Startverschiebung feststellen:
				Date firstday = daten.getFirstDay();
				Calendar anfangtag = Calendar.getInstance();
				anfangtag.clear();
				anfangtag.set(jahr, monat-1, tag);
				verschiebung = daten.tage(anfangtag.getTime(), firstday);
				logger.fine("Startverschiebung: "+verschiebung);
				logger.finest("Atribute der Termine: "+attribute);
			}
		} else if (qName.equals("Montag")){
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("von"))
						try {
							vonMo = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Startzeit Montag ist keine Zahl:");
						}
					if(attributName.equals("bis"))
						try {
							bisMo = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Endzeit Montag ist keine Zahl:");
						}
				}
			}
			logger.finest("Atribute vom Montag: "+attribute);
		} else if (qName.equals("Dienstag")){
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("von"))
						try {
							vonDi = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Startzeit Dienstag ist keine Zahl:");
						}
					if(attributName.equals("bis"))
						try {
							bisDi = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Endzeit Dienstag ist keine Zahl:");
						}
				}
			}
			logger.finest("Atribute vom Dienstag: "+attribute);
		} else if (qName.equals("Mittwoch")){
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("von"))
						try {
							vonMi = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Startzeit Mittwoch ist keine Zahl:");
						}
					if(attributName.equals("bis"))
						try {
							bisMi = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Endzeit Mitwwoch ist keine Zahl:");
						}
				}
			}
			logger.finest("Atribute vom Mittwoch: "+attribute);
		} else if (qName.equals("Donnerstag")){
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("von"))
						try {
							vonDo = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Startzeit Donnerstag ist keine Zahl:");
						}
					if(attributName.equals("bis"))
						try {
							bisDo = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Endzeit Donnerstag ist keine Zahl:");
						}
				}
			}
			logger.finest("Atribute vom Donnerstag: "+attribute);
		} else if (qName.equals("Freitag")){
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("von"))
						try {
							vonFr = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Startzeit Freitag ist keine Zahl:");
						}
					if(attributName.equals("bis"))
						try {
							bisFr = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Endzeit Freitag ist keine Zahl:");
						}
				}
			}
			logger.finest("Atribute vom Freitag: "+attribute);
		} else if (qName.equals("Sonnabend")){
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("von"))
						try {
							vonSa = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Startzeit Sonnabend ist keine Zahl:");
						}
					if(attributName.equals("bis"))
						try {
							bisSa = (Integer.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Endzeit Sonnabend ist keine Zahl:");
						}
				}
			}
			logger.finest("Atribute vom Sonnabend: "+attribute);
		} else if (qName.equals("Sonntag")){
			if (attributes.getLength() >=1){
				for (int i = 0; i < attributes.getLength(); i++){
					attributName = attributes.getQName(i);
					attribute=attribute+" "+attributName+"='"+attributes.getValue(i)+"'";
					if(attributName.equals("von"))
						try {
							vonSo = (Long.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Startzeit Sonntag ist keine Zahl:");
						}
					if(attributName.equals("bis"))
						try {
							bisSo = (Long.valueOf(attributes.getValue(i)).intValue());
						} catch (java.lang.NumberFormatException nfe){
							logger.warning("Endzeit Sonntag ist keine Zahl:");
						}
				}
			}
			logger.finest("Atribute vom Sonntag: "+attribute);
		} else 
			currentActivity = READING_NOTHING;
	}

	public void characters(char[] ch, int start, int length) {
		String value = new String(ch, start, length);
		//String valeu = new String(ch, 0, ch.length);
		switch(currentActivity){
			case READING_NAME        : name = name + value; break;
			case READING_VORNAME     : vorname = vorname + value; break;
			case READING_GEBURTSTAG  : geburtstag = geburtstag + value; break;
			case READING_TELEFON     : telefon = telefon + value; break;
			case READING_TELEFON2    : telefon2 = telefon2 + value; break;
			case READING_TELEFON3    : telefon3 = telefon3 + value; break;
			case READING_KOMMENTAR   : kommentare = kommentare + value; break;
			case READING_KURSNAME    : kursname = kursname + value; break;
			case READING_KURZNOTIZ   : kurznotiz = kurznotiz + value; break;
			case READING_LANGNOTIZ   : langnotiz = langnotiz + value; break;
			case READING_PATIENTENID : patientenid = patientenid + value; break;
			case READING_JETZT       : jetztText = jetztText + value; break;
			case READING_ZUKUNFT     : zukunftText = zukunftText + value; break;
			case READING_PAUSE       : pause = pause + value; break;
			case READING_PTERMINE    : termine = termine + value; break;
			case READING_THERAPIE    : therapie = therapie + value; break;
		}
		//currentActivity = READING_NOTHING;
	}

	public void endElement(String uri, String localName, String qName) {
		currentActivity = READING_NOTHING;
		if(name.equals("       ")) name = "";
		if(telefon.equals("       ")) telefon = "";
		if(telefon2.equals("       ")) telefon2 = "";
		if(telefon3.equals("       ")) telefon3 = "";
		if(kommentare.equals("       ")) kommentare = "";
		if (qName.equals("PatientenID")) {
			try {
				patientenID = (Integer.valueOf(patientenid).intValue());
			} catch (java.lang.NumberFormatException nfe){
				logger.warning("PatientenID ist keine Zahl: "+patientenid);
			}
		} else if (qName.equals("jetzt")) {
			try {
				jetzt = (Integer.valueOf(jetztText).intValue());
			} catch (java.lang.NumberFormatException nfe){
				logger.warning("\"Jetzt\" ist keine Zahl: "+patientenid);
			}
		} else if (qName.equals("Zukunft")) {
			try {
				zukunft = (Integer.valueOf(zukunftText).intValue());
			} catch (java.lang.NumberFormatException nfe){
				logger.warning("\"Zukunft\" ist keine Zahl: "+patientenid);
			}
		} else if (qName.equals("Pause")) {
			try {
				pausen = (Integer.valueOf(pause).intValue());
			} catch (java.lang.NumberFormatException nfe){
				logger.warning("\"Pause\" ist keine Zahl: "+pause);
			}
		} else if (qName.equals("Raeume")) {
			logger.finest("Finde Räume: "+jetzt+"-"+zukunft+" "+tag+"."+monat+"."+jahr);
			Calendar datum = Calendar.getInstance();
			datum.clear();
			datum.set(jahr, monat-1, tag);
			raume = new Ausrustung(jetzt, zukunft, datum.getTime());
			jetztText = "";
			zukunftText = "";
		} else if (qName.equals("Geraete")) {
			logger.finest("Finde Geräte: "+jetzt+"-"+zukunft+" "+tag+"."+monat+"."+jahr);
			Calendar datum = Calendar.getInstance();
			datum.clear();
			datum.set(jahr, monat-1, tag);
			geraete = new Ausrustung(jetzt, zukunft, datum.getTime());
			jetztText = "";
			zukunftText = "";
		} else if (qName.equals("Ausruestung")) {
			daten.setAusrustung(raume, geraete);
			jetzt = 0;
			zukunft = 0;
			jetztText = "";
			zukunftText = "";
		} else if (qName.equals("Therapeut")) {
			daten.setStatusBar(++counter, ""+counter*100/maxCounter+"%");
			Therapeut th = new Therapeut(name, vorname, daten.getAndAddTheraNummer());
			th.setHerr(herr);
			th.setVonZeiten(0,vonMo);
			th.setVonZeiten(1,vonDi);
			th.setVonZeiten(2,vonMi);
			th.setVonZeiten(3,vonDo);
			th.setVonZeiten(4,vonFr);
			th.setVonZeiten(5,vonSa);
			th.setVonZeiten(6,vonSo);
			th.setBisZeiten(0,bisMo);
			th.setBisZeiten(1,bisDi);
			th.setBisZeiten(2,bisMi);
			th.setBisZeiten(3,bisDo);
			th.setBisZeiten(4,bisFr);
			th.setBisZeiten(5,bisSa);
			th.setBisZeiten(6,bisSo);
			th.setPausen(pausen);
			th.setKommentar(kommentare);
			th.setTermine(termine);
			if(daten.getMaxTherapeuten() >= daten.maxTherapeuten){
				/*
					Fehler: Mehr Therapeuten, als bearbeitbar vorhanden
				*/
			} else {
				daten.addTherapeuten(th);
			}
			/*
				try{
					int copyrightZahl = Integer.parseInt(copyright);
				} catch (NumberFormatException nfe){
					copyrightZahl = 0;
					System.err.out("Warnung: Keine Zahl im Copyright");
				}
			*/
			logger.fine("Finde Therapeut:\n"+vorname+" "+name);
			vorname = "";
			name = "";
			kommentare = "";
			pause = "";
			termine = "";
			herr = false;
			vonMo = 0;
			vonDi = 0;
			vonMi = 0;
			vonDo = 0;
			vonFr = 0;
			vonSa = 0;
			vonSo = 0;
	
			bisMo = 0;
			bisDi = 0;
			bisMi = 0;
			bisDo = 0;
			bisFr = 0;
			bisSa = 0;
			bisSo = 0;
			pausen = 0;
		} else if (qName.equals("Patient")) {
			daten.setStatusBar(++counter, ""+counter*100/maxCounter+"%");
			Patient p = new Patient(vorname, name, geburtstag, telefon, telefon2, telefon3, kommentare, termine, kasse, herr, thera);
			daten.addPatient(p);
			logger.fine("Finde Patient: "+vorname+" "+name);
			vorname = "";
			name = "";
			geburtstag = "";
			telefon = "";
			telefon2 = "";
			telefon3 = "";
			kommentare = "";
			termine = "";
			kasse = 0;
			herr = false;
			thera = 0;
		} else if (qName.equals("Raum")) {
			raum = 1;
		} else if (qName.equals("Geraet")) {
			geraet = 1;
		} else if (qName.equals("Termin")) {
			daten.setStatusBar(++counter, ""+counter*100/maxCounter+"%");
			logger.finest("Speicher Termin in Daten: "+(spalte-verschiebung)+" "+zeile+"\nTerminart: "+terminArt+"\nTherapeut: "+aktuellerThera+"\nPackung: "+packung+"\nID: "+id);
			Termin t = new Termin(terminArt);
			t.setID(id);
			t.setZeit(zeile-1, zeile);
			switch(terminArt){
				case Termin.FREI :
				case Termin.KEINEARBEITSZEIT:
					t.resetZeit();
					break;
				case Termin.KURS : t.setKurs(kursname); break;
				case Termin.NOTIZ: 
					t.setNotizen(kurznotiz, langnotiz); 
					logger.finest("Notizen: \nKurznotiz:\n"+kurznotiz+"\nLangnotiz: "+langnotiz); 
					break;
				case Termin.PATIENT : 
					if(packung == 1){
						t.setPatient(daten.getPatient(patientenID), true);
						t.setPackung(true);
					} else {
						t.setPatient(daten.getPatient(patientenID), false);
						t.setPackung(false);
					}
					t.setRaum(raum);
					t.setGeraet(geraet);
					t.setTherapie(therapie);
					break;
			}
			daten.setTermin(spalte-verschiebung, zeile, aktuellerThera, packung, t);
			spalte = 0;
			zeile = 0;
			packung = 0;
			id = 0L;
			kursname = "";
			kurznotiz = "";
			langnotiz = "";
			raum = 0;
			geraet = 0;
		} else if(qName.equals("Herr")) {
			herr = true;
		}
		
	}
	
	public void endDocument() throws SAXException {
		logger.info("Die Datei wurde erfolgreich geparst");
	}

}

